/*
 * Decompiled with CFR 0.152.
 */
package net.sf.samtools.util;

import net.sf.samtools.util.BinaryCodec;

public class StringUtil {
    private static final byte UPPER_CASE_OFFSET = -32;

    public static String join(String separator, String ... strings) {
        if (strings.length == 0) {
            return "";
        }
        StringBuilder ret = new StringBuilder(strings[0]);
        for (int i = 1; i < strings.length; ++i) {
            ret.append(separator);
            ret.append(strings[i]);
        }
        return ret.toString();
    }

    public static int split(String aString, String[] tokens, char delim) {
        String trailingString;
        int maxTokens = tokens.length;
        int nTokens = 0;
        int start = 0;
        int end = aString.indexOf(delim);
        if (end < 0) {
            tokens[nTokens++] = aString;
            return nTokens;
        }
        while (end > 0 && nTokens < maxTokens) {
            tokens[nTokens++] = aString.substring(start, end);
            start = end + 1;
            end = aString.indexOf(delim, start);
        }
        if (nTokens < maxTokens && (trailingString = aString.substring(start)).length() > 0) {
            tokens[nTokens++] = trailingString;
        }
        return nTokens;
    }

    public static int splitConcatenateExcessTokens(String aString, String[] tokens, char delim) {
        int maxTokens = tokens.length;
        int nTokens = 0;
        int start = 0;
        int end = aString.indexOf(delim);
        if (end < 0) {
            tokens[nTokens++] = aString;
            return nTokens;
        }
        while (end > 0 && nTokens < maxTokens - 1) {
            tokens[nTokens++] = aString.substring(start, end);
            start = end + 1;
            end = aString.indexOf(delim, start);
        }
        String trailingString = aString.substring(start);
        if (trailingString.length() > 0) {
            tokens[nTokens++] = trailingString;
        }
        return nTokens;
    }

    public static byte toUpperCase(byte b) {
        if (b < 97 || b > 122) {
            return b;
        }
        return (byte)(b + -32);
    }

    public static void toUpperCase(byte[] bytes) {
        int length = bytes.length;
        for (int i = 0; i < length; ++i) {
            if (bytes[i] < 97 || bytes[i] > 122) continue;
            bytes[i] = (byte)(bytes[i] + -32);
        }
    }

    public static String assertCharactersNotInString(String illegalChars, char ... chars) {
        for (char illegalChar : illegalChars.toCharArray()) {
            for (char ch : chars) {
                if (illegalChar != ch) continue;
                throw new IllegalArgumentException("Supplied String contains illegal character '" + illegalChar + "'.");
            }
        }
        return illegalChars;
    }

    public static String wordWrap(String s, int maxLineLength) {
        String[] lines = s.split("\n");
        StringBuilder sb = new StringBuilder();
        for (String line : lines) {
            if (sb.length() > 0) {
                sb.append("\n");
            }
            sb.append(StringUtil.wordWrapSingleLine(line, maxLineLength));
        }
        if (s.endsWith("\n")) {
            sb.append("\n");
        }
        return sb.toString();
    }

    public static String wordWrapSingleLine(String s, int maxLineLength) {
        if (s.length() <= maxLineLength) {
            return s;
        }
        StringBuilder sb = new StringBuilder();
        int startCopyFrom = 0;
        while (startCopyFrom < s.length()) {
            int i;
            int lastSpaceIndex = startCopyFrom;
            for (i = startCopyFrom; i < s.length() && i - startCopyFrom < maxLineLength; ++i) {
                if (!Character.isWhitespace(s.charAt(i))) continue;
                lastSpaceIndex = i;
            }
            if (i - startCopyFrom < maxLineLength) {
                lastSpaceIndex = i;
            }
            while (lastSpaceIndex < s.length() && Character.isWhitespace(s.charAt(lastSpaceIndex))) {
                ++lastSpaceIndex;
            }
            if (sb.length() > 0) {
                sb.append("\n");
            }
            if (lastSpaceIndex == startCopyFrom) {
                lastSpaceIndex = i;
            }
            sb.append(s.substring(startCopyFrom, lastSpaceIndex));
            startCopyFrom = lastSpaceIndex;
        }
        return sb.toString();
    }

    public static String bytesToString(byte[] data) {
        if (data == null) {
            return null;
        }
        return StringUtil.bytesToString(data, 0, data.length);
    }

    public static String bytesToString(byte[] buffer, int offset, int length) {
        return new String(buffer, 0, offset, length);
    }

    public static byte[] stringToBytes(String s) {
        byte[] byteBuffer = new byte[s.length()];
        s.getBytes(0, byteBuffer.length, byteBuffer, 0);
        return byteBuffer;
    }

    public static byte[] stringToBytes(String s, int offset, int length) {
        byte[] byteBuffer = new byte[length];
        s.getBytes(offset, offset + length, byteBuffer, 0);
        return byteBuffer;
    }

    public static String readNullTerminatedString(BinaryCodec binaryCodec) {
        StringBuilder ret = new StringBuilder();
        byte b = binaryCodec.readByte();
        while (b != 0) {
            ret.append((char)(b & 0xFF));
            b = binaryCodec.readByte();
        }
        return ret.toString();
    }

    public static void charsToBytes(char[] chars, int charOffset, int length, byte[] bytes, int byteOffset) {
        for (int i = 0; i < length; ++i) {
            bytes[byteOffset + i] = (byte)chars[charOffset + i];
        }
    }

    public static byte charToByte(char c) {
        return (byte)c;
    }

    public static char byteToChar(byte b) {
        return (char)(b & 0xFF);
    }

    public static String bytesToHexString(byte[] data) {
        char[] chars = new char[2 * data.length];
        for (int i = 0; i < data.length; ++i) {
            byte b = data[i];
            chars[2 * i] = StringUtil.toHexDigit(b >> 4 & 0xF);
            chars[2 * i + 1] = StringUtil.toHexDigit(b & 0xF);
        }
        return new String(chars);
    }

    public static byte[] hexStringToBytes(String s) throws NumberFormatException {
        if (s.length() % 2 != 0) {
            throw new NumberFormatException("Hex representation of byte string does not have even number of hex chars: " + s);
        }
        byte[] ret = new byte[s.length() / 2];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = (byte)(StringUtil.fromHexDigit(s.charAt(i * 2)) << 4 | StringUtil.fromHexDigit(s.charAt(i * 2 + 1)));
        }
        return ret;
    }

    public static char toHexDigit(int value) {
        return (char)(value < 10 ? 48 + value : 65 + value - 10);
    }

    public static int fromHexDigit(char c) throws NumberFormatException {
        int ret = Character.digit(c, 16);
        if (ret == -1) {
            throw new NumberFormatException("Not a valid hex digit: " + c);
        }
        return ret;
    }

    public static String reverseString(String s) {
        StringBuilder sb = new StringBuilder(s);
        sb.reverse();
        return sb.toString();
    }

    public static boolean isBlank(String str) {
        int strLen;
        if (str == null || (strLen = str.length()) == 0) {
            return true;
        }
        for (int i = 0; i < strLen; ++i) {
            if (Character.isWhitespace(str.charAt(i))) continue;
            return false;
        }
        return true;
    }
}

