-- MySQL Administrator dump 1.4
--
-- ------------------------------------------------------
-- Server version	5.1.54-community


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;

/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;


--
-- Create schema genome
--

CREATE DATABASE IF NOT EXISTS genome;
USE genome;

--
-- Definition of table `aceview_hg18_housekeeping`
--

DROP TABLE IF EXISTS `aceview_hg18_housekeeping`;
CREATE TABLE `aceview_hg18_housekeeping` (
  `bin` smallint(5) unsigned DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `chrom` varchar(255) DEFAULT NULL,
  `strand` char(1) DEFAULT NULL,
  `txStart` int(10) unsigned DEFAULT NULL,
  `txEnd` int(10) unsigned DEFAULT NULL,
  `cdsStart` int(10) unsigned DEFAULT NULL,
  `cdsEnd` int(10) unsigned DEFAULT NULL,
  `exonCount` int(10) unsigned DEFAULT NULL,
  `exonStarts` longblob,
  `exonEnds` longblob,
  KEY `chrom` (`chrom`,`txStart`,`txEnd`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Dumping data for table `aceview_hg18_housekeeping`
--

/*!40000 ALTER TABLE `aceview_hg18_housekeeping` DISABLE KEYS */;
INSERT INTO `aceview_hg18_housekeeping` (`bin`,`name`,`chrom`,`strand`,`txStart`,`txEnd`,`cdsStart`,`cdsEnd`,`exonCount`,`exonStarts`,`exonEnds`) VALUES 
 (0,'WDR78.aApr07','chr1','-',67051155,67163494,67052400,67163102,17,0x36373035313135352C36373036303633312C36373036353039302C36373036363038322C36373037313835352C36373037323236312C36373037333839362C36373037353938302C36373037383733392C36373038353735342C36373130303431372C36373130393634302C36373131333035312C36373132393432342C36373133313439392C36373134333437312C36373136323933322C,0x36373035323435312C36373036303738382C36373036353331372C36373036363138312C36373037313937372C36373037323431392C36373037343034382C36373037363036372C36373037383934322C36373038353934392C36373130303537332C36373130393738302C36373131333230382C36373132393533372C36373133313638342C36373134333634362C36373136333439342C),
 (0,'WDR78.eApr07','chr1','-',67051161,67163092,67072416,67109713,16,0x36373035313136312C36373036303633312C36373036353039302C36373036363038322C36373037313835352C36373037323236312C36373037353938302C36373037383733392C36373038353735342C36373130303431372C36373130393634302C36373132383435332C36373133313439392C36373134333437312C36373135373238382C36373136323933322C,0x36373035323435312C36373036303738382C36373036353331372C36373036363138312C36373037313937372C36373037323431392C36373037363036372C36373037383934322C36373038353934392C36373130303537332C36373130393738302C36373132393533372C36373133313638342C36373134333634362C36373135373338372C36373136333039322C),
 (0,'WDR78.bApr07','chr1','-',67052241,67113185,67052400,67113185,12,0x36373035323234312C36373036303633312C36373036353039302C36373037313835352C36373037323236312C36373037333839362C36373037353938302C36373037383733392C36373038353735342C36373130303431372C36373130393634302C36373131333035312C,0x36373035323435312C36373036303738382C36373036353331372C36373037313937372C36373037323431392C36373037343034382C36373037363036372C36373037383934322C36373038353934392C36373130303537332C36373130393738302C36373131333138352C),
 (0,'WDR78.cApr07','chr1','-',67075871,67163158,67075923,67163156,10,0x36373037353837312C36373037383733392C36373038353735342C36373130303431372C36373130393634302C36373131333035312C36373132393432342C36373133313439392C36373134333437312C36373136323933322C,0x36373037363036372C36373037383934322C36373038353934392C36373130303537332C36373130393738302C36373131333230382C36373132393533372C36373133313638342C36373134333634362C36373136333135382C),
 (0,'WDR78.fApr07','chr1','-',67075877,67163089,67075923,67109713,7,0x36373037353837372C36373037383733392C36373130303431372C36373130393634302C36373132393432342C36373133313439392C36373136323933322C,0x36373037363036372C36373037383934322C36373130303537332C36373130393738302C36373132393533372C36373133313633322C36373136333038392C),
 (0,'WDR78.gApr07','chr1','-',67086194,67113064,67086511,67113062,4,0x36373038363139342C36373130303431372C36373130393634302C36373131333035312C,0x36373038363538322C36373130303537332C36373130393738302C36373131333036342C),
 (0,'ADORA1.hApr07','chr1','+',201320154,201364780,201320159,201364756,3,0x3230313332303135342C3230313336333537392C3230313336343533352C,0x3230313332303332342C3230313336333637392C3230313336343738302C),
 (0,'ADORA1.dApr07','chr1','+',201326404,201403156,201364592,201401651,6,0x3230313332363430342C3230313332373434332C3230313336333537392C3230313336343032382C3230313336343533352C3230313430313031312C,0x3230313332363438352C3230313332373436312C3230313336333637392C3230313336343138332C3230313336343933332C3230313430333135362C),
 (1,'RERE.bApr07','chr1','-',8335043,8800285,8337733,8638943,24,0x383333353034332C383333383036352C383333383734362C383334303834322C383334323431302C383334323735382C383334343430392C383334353332392C383334363730322C383334373339322C383334383435382C383430353337332C383434383537312C383437373730392C383438303035312C383439313237322C383532333835392C383533393132302C383534303036332C383539373230362C383630363935352C383633383631382C383737353034392C383739393830352C,0x383333373736372C383333383234362C383333383839332C383334313536332C383334323633332C383334343133372C383334343532332C383334353439312C383334363930322C383334373438352C383334383632312C383430353435342C383434383637302C383437373830392C383438303137362C383439313332312C383532333936342C383533393231372C383534303136392C383539373333322C383630373032362C383633393038372C383737353233342C383830303238352C),
 (1,'RERE.cApr07','chr1','-',8335050,8406334,8337733,8406333,13,0x383333353035302C383333383036352C383333383734362C383334303834322C383334323431302C383334323735382C383334343430392C383334353332392C383334363730322C383334373339322C383334383435382C383430353337332C383430363230372C,0x383333373736372C383333383234362C383333383839332C383334313536332C383334323633332C383334343133372C383334343532332C383334353439312C383334363930322C383334373438352C383334383632312C383430353435342C383430363333342C),
 (1,'RERE.aApr07','chr1','-',8335050,8800285,8337733,8638943,23,0x383333353035302C383333383036352C383333383734362C383334303834322C383334323431302C383334323735382C383334343430392C383334353332392C383334363730322C383334373339322C383334383435382C383430353337332C383434383537312C383437373730392C383438303035312C383439313237322C383532333835392C383533393132302C383534303036332C383539373230362C383630363935352C383633383631382C383739393830352C,0x383333373736372C383333383234362C383333383839332C383334313536332C383334323633332C383334343133372C383334343532332C383334353439312C383334363930322C383334373438352C383334383632312C383430353435342C383434383637302C383437373830392C383438303137362C383439313332312C383532333936342C383533393231372C383534303136392C383539373333322C383630373032362C383633393038372C383830303238352C),
 (1,'RERE.dApr07','chr1','-',8338115,8508680,8338115,8508430,14,0x383333383131352C383333383734362C383334343130362C383334343430392C383334353332392C383334363730322C383334373339322C383334383435382C383430353337332C383434383537312C383437373730392C383438303035312C383439313237322C383530383430342C,0x383333383234362C383333383839332C383334343133372C383334343532332C383334353439312C383334363930322C383334373438352C383334383632312C383430353435342C383434383637302C383437373830392C383438303137362C383439313332312C383530383638302C),
 (1,'RERE.gApr07','chr1','-',8343719,8407937,8345278,8407575,7,0x383334333731392C383334353231362C383334363730322C383334373339322C383334383435382C383430353337332C383430373433342C,0x383334343133392C383334353439312C383334363930322C383334373438352C383334383632312C383430353435342C383430373933372C),
 (1,'RERE.fApr07','chr1','-',8346356,8406313,8346357,8406312,6,0x383334363335362C383334373339322C383334383435382C383430353337332C383430353831332C383430363230372C,0x383334363930322C383334373438352C383334383632312C383430353435342C383430353839342C383430363331332C),
 (1,'NBPF1.aApr07','chr1','-',16761400,16812686,16763024,16791103,29,0x31363736313430302C31363736333838382C31363736343731342C31363736353438392C31363736363236302C31363736373036302C31363736383135342C31363737323232332C31363737333536382C31363737343233382C31363737353334382C31363737363339382C31363737383237342C31363737393832362C31363738303530312C31363738313632352C31363738323637352C31363738343537302C31363738363133312C31363738363830362C31363738373933302C31363738383938302C31363739303932382C31363739313234302C31363739323532322C31363739333637332C31363739343031322C31363830373538392C31363831323431392C,0x31363736333236382C31363736343030302C31363736343838372C31363736353534312C31363736363433332C31363736373131322C31363736383331382C31363737323237352C31363737333737342C31363737343331312C31363737353536332C31363737363530312C31363737383438342C31363738303033382C31363738303537342C31363738313834302C31363738323737382C31363738343738302C31363738363334332C31363738363837392C31363738383134352C31363738393038332C31363739313133382C31363739313339352C31363739323634392C31363739333734332C31363739343039312C31363830373836312C31363831323638362C),
 (1,'NBPF1.bApr07','chr1','-',16765503,16791403,16765503,16791103,11,0x31363736353530332C31363736363236302C31363736373036302C31363736383135342C31363737303136382C31363737323232332C31363737333536382C31363737343233382C31363737353334382C31363738323637352C31363739303932382C,0x31363736353534312C31363736363433332C31363736373131322C31363736383331382C31363737303235322C31363737323237352C31363737333737342C31363737343331312C31363737353536332C31363738323737382C31363739313430332C),
 (1,'NBPF1.jApr07','chr1','-',16773568,16778468,16776394,16778449,3,0x31363737333536382C31363737343233382C31363737383237342C,0x31363737333737342C31363737363530312C31363737383436382C),
 (1,'A3GALT2.aApr07','chr1','-',33544953,33559286,33544953,33559286,5,0x33333534343935332C33333535303233392C33333535303638382C33333535303939342C33333535393236332C,0x33333534353634312C33333535303337372C33333535303737382C33333535313037382C33333535393238362C),
 (1,'jawler.aApr07','chr1','+',33552882,33564229,33552884,33563897,2,0x33333535323838322C33333536333830382C,0x33333535333031312C33333536343232392C),
 (1,'HIVEP3.aApr07','chr1','-',41748466,42157176,41748708,41823055,8,0x34313734383436362C34313735313037332C34313735363635392C34313736323939322C34313831333830312C34313831373939342C34313836373030362C34323135363637302C,0x34313734393532342C34313735323030382C34313735363734362C34313736333136382C34313831333934372C34313832333537362C34313836373230352C34323135373137362C),
 (1,'ELAVL4.kApr07','chr1','+',50286313,50417882,50286423,50417835,4,0x35303238363331332C35303338333231352C35303431353334372C35303431373830322C,0x35303238363434312C35303338333435362C35303431353435312C35303431373838322C),
 (1,'ELAVL4.cApr07','chr1','+',50286375,50439605,50286375,50439437,7,0x35303238363337352C35303338333231352C35303431353334372C35303433323032332C35303433333831392C35303433353638372C35303433393130392C,0x35303238363434312C35303338333435362C35303431353435312C35303433323137372C35303433343034352C35303433353732362C35303433393630352C),
 (1,'OMA1.iApr07','chr1','-',58653643,58765580,58653652,58765580,3,0x35383635333634332C35383734343331392C35383736353532302C,0x35383635333734352C35383734343436392C35383736353538302C),
 (1,'OMA1.kApr07','chr1','-',58700811,58767829,0,0,3,0x35383730303831312C35383734343331392C35383736373638382C,0x35383730313035342C35383734343432322C35383736373832392C),
 (1,'OMA1.bApr07','chr1','-',58706186,58784973,58712132,58777554,10,0x35383730363138362C35383731323039312C35383734343331392C35383736353532302C35383736383836302C35383737323231322C35383737323431372C35383737343737322C35383737373035342C35383738343932332C,0x35383730373236352C35383731323232382C35383734343436392C35383736353539352C35383736383938392C35383737323332302C35383737323539312C35383737353030312C35383737373536362C35383738343937332C),
 (1,'OMA1.aApr07','chr1','-',58718195,58785040,58719224,58777554,9,0x35383731383139352C35383734343331392C35383736353532302C35383736383836302C35383737323231322C35383737323431372C35383737343737322C35383737373035342C35383738343936322C,0x35383731393433342C35383734343436392C35383736353539352C35383736383938392C35383737323332302C35383737323539312C35383737353030312C35383737373536362C35383738353034302C),
 (1,'OMA1.hApr07','chr1','-',58719006,58761199,58719224,58744427,3,0x35383731393030362C35383734343331392C35383736313038362C,0x35383731393433342C35383734343436392C35383736313139392C),
 (1,'OMA1.cApr07','chr1','-',58719202,58785003,58719224,58774994,7,0x35383731393230322C35383734343331392C35383736353532302C35383737323231322C35383737323431372C35383737343737322C35383738343936322C,0x35383731393433342C35383734343436392C35383736353539352C35383737323332302C35383737323539312C35383737353030312C35383738353030332C),
 (2,'SLC44A5.cApr07','chr1','-',75440400,75636697,75441999,75538933,24,0x37353434303430302C37353434393734302C37353435313937372C37353435323139312C37353435323837372C37353435343032362C37353435363133382C37353435363736322C37353435373532392C37353435383037322C37353436303633332C37353436353939382C37353437323235382C37353437353235392C37353437363738352C37353438303237332C37353438313135382C37353438393438322C37353531333233302C37353533383838342C37353534393838372C37353537373835342C37353633343835352C37353633363632372C,0x37353434323130362C37353434393832352C37353435323036362C37353435323236322C37353435323935312C37353435343133302C37353435363233332C37353435373032352C37353435373631372C37353435383136352C37353436303733332C37353436363133302C37353437323337312C37353437353334332C37353437363930392C37353438303333342C37353438313238342C37353438393536372C37353531333331352C37353533383935382C37353534393937382C37353537373930332C37353633343839342C37353633363639372C),
 (2,'SLC44A5.aApr07','chr1','-',75441722,75634894,75444879,75634892,22,0x37353434313732322C37353434393734302C37353435313937372C37353435323139312C37353435323837372C37353435343032362C37353435363133382C37353435363736322C37353435373532392C37353435383037322C37353436303633332C37353436353939382C37353437323235382C37353437353235392C37353437363738352C37353438303237332C37353438313135382C37353438393438322C37353531333233302C37353533383838342C37353537373835342C37353633343835352C,0x37353434343939322C37353434393832352C37353435323036362C37353435323236322C37353435323935312C37353435343133302C37353435363233332C37353435373032352C37353435373631372C37353435383136352C37353436303733332C37353436363133302C37353437323337312C37353437353334332C37353437363930392C37353438303333342C37353438313238342C37353438393536372C37353531333331352C37353533383935382C37353537373930332C37353633343839342C),
 (2,'SLC44A5.bApr07','chr1','-',75441779,75614483,75441999,75538933,22,0x37353434313737392C37353434393734302C37353435313937372C37353435323139312C37353435323837372C37353435343032362C37353435363133382C37353435363736322C37353435373532392C37353435383037322C37353436303633332C37353436353939382C37353437323235382C37353437353235392C37353437363738352C37353438303237332C37353438313135382C37353438393438322C37353531333233302C37353533383838342C37353537373835342C37353631343038382C,0x37353434323130362C37353434393832352C37353435323036362C37353435323236322C37353435323935312C37353435343133302C37353435363233332C37353435373032352C37353435373631372C37353435383136352C37353436303733332C37353436363133302C37353437323337312C37353437353334332C37353437363930392C37353438303333342C37353438313238342C37353438393536372C37353531333331352C37353533383935382C37353537373930332C37353631343438332C),
 (2,'SLC44A5.dApr07','chr1','-',75472355,75614496,75472355,75614466,10,0x37353437323335352C37353437353235392C37353437363738352C37353438303237332C37353438313135382C37353438393438322C37353531333233302C37353533383838342C37353537373835342C37353631343434312C,0x37353437323337312C37353437353334332C37353437363930392C37353438303333342C37353438313238342C37353438393536372C37353531333331352C37353533383935382C37353537373930332C37353631343439362C),
 (2,'SLC44A5.fApr07','chr1','-',75480304,75614483,75480304,75538933,7,0x37353438303330342C37353438313135382C37353438393438322C37353531333233302C37353533383838342C37353537373835342C37353631343335362C,0x37353438303333342C37353438313238342C37353438393536372C37353531333331352C37353533383935382C37353537373930332C37353631343438332C),
 (2,'SLC44A5.iApr07','chr1','-',75481202,75614179,0,0,5,0x37353438313230322C37353438393438322C37353533383838342C37353537373835342C37353631343038382C,0x37353438313238342C37353438393536372C37353533383935382C37353537373930332C37353631343137392C),
 (2,'plerber.aApr07','chr1','-',83814066,84099272,0,0,3,0x38333831343036362C38333938383436382C38343039393038392C,0x38333831363934332C38333938383537302C38343039393237322C),
 (2,'ABHD7.aApr07','chr1','+',92268120,92301873,92268224,92301431,7,0x39323236383132302C39323237303634392C39323238303936372C39323238333637362C39323238383436312C39323239303635342C39323330313139392C,0x39323236383435352C39323237303733352C39323238313132352C39323238333830352C39323238383536352C39323239303830332C39323330313837332C),
 (2,'ABHD7.bApr07','chr1','+',92268146,92283774,92268224,92283683,3,0x39323236383134362C39323237303634392C39323238333637362C,0x39323236383435352C39323237303733352C39323238333737342C),
 (2,'ABHD7.cApr07','chr1','+',92270705,92281607,92270706,92281139,2,0x39323237303730352C39323238303936372C,0x39323237303733352C39323238313630372C),
 (2,'CDC14A.jApr07','chr1','+',100583145,100678112,100615723,100677758,7,0x3130303538333134352C3130303539313930352C3130303631353638392C3130303632383837352C3130303636323336352C3130303637373735342C3130303637383037352C,0x3130303538333332372C3130303539313939362C3130303631353736352C3130303632383936382C3130303636323434352C3130303637373738312C3130303637383131322C),
 (2,'CDC14A.iApr07','chr1','+',100583184,100681113,100615723,100681113,7,0x3130303538333138342C3130303539313930352C3130303631353638392C3130303632383837352C3130303636323336352C3130303637383037352C3130303638313037372C,0x3130303538333332372C3130303539313939362C3130303631353736352C3130303632383936382C3130303636323434352C3130303637383134322C3130303638313131332C),
 (2,'CDC14A.eApr07','chr1','+',100589877,100701002,100589900,100701000,9,0x3130303538393837372C3130303539313930352C3130303631353638392C3130303632383837352C3130303636323336352C3130303637383037352C3130303638313037372C3130303639333534382C3130303730303739342C,0x3130303538393935322C3130303539313939362C3130303631353736352C3130303632383936382C3130303636323434352C3130303637383134322C3130303638313134302C3130303639333633362C3130303730313030322C),
 (2,'CDC14A.aApr07','chr1','+',100590530,100737609,100591098,100737523,15,0x3130303539303533302C3130303539313930352C3130303631353638392C3130303632383837352C3130303636323336352C3130303637383037352C3130303638313037372C3130303639333534382C3130303730303739342C3130303730363039392C3130303732323433352C3130303733323936312C3130303733343134352C3130303733363232382C3130303733373037322C,0x3130303539313134372C3130303539313939362C3130303631353736352C3130303632383936382C3130303636323434352C3130303637383134322C3130303638313134302C3130303639333633362C3130303730313032352C3130303730363233382C3130303732323539352C3130303733333037342C3130303733343139332C3130303733363335312C3130303733373630392C),
 (2,'CDC14A.dApr07','chr1','+',100590624,100723531,100591098,100722610,11,0x3130303539303632342C3130303539313930352C3130303631353638392C3130303632383837352C3130303636323336352C3130303637383037352C3130303638313037372C3130303639333534382C3130303730303739342C3130303730363039392C3130303732323433352C,0x3130303539313134372C3130303539313939362C3130303631353736352C3130303632383936382C3130303636323434352C3130303637383134322C3130303638313134302C3130303639333633362C3130303730313032352C3130303730363233382C3130303732333533312C),
 (2,'CDC14A.bApr07','chr1','+',100590635,100758425,100591098,100756424,16,0x3130303539303633352C3130303539313930352C3130303631353638392C3130303632383837352C3130303636323336352C3130303637383037352C3130303638313037372C3130303639333534382C3130303730303739342C3130303730363039392C3130303732323433352C3130303733323936312C3130303733343134352C3130303733363232382C3130303733373037322C3130303735363339342C,0x3130303539313134372C3130303539313939362C3130303631353736352C3130303632383936382C3130303636323434352C3130303637383134322C3130303638313134302C3130303639333633362C3130303730313032352C3130303730363233382C3130303732323539352C3130303733333037342C3130303733343139332C3130303733363335312C3130303733373430362C3130303735383432352C),
 (2,'CDC14A.cApr07','chr1','+',100591036,100737608,100700838,100737523,14,0x3130303539313033362C3130303539313930352C3130303631353638392C3130303632383837352C3130303636323336352C3130303637383037352C3130303638313037372C3130303730303739342C3130303730363039392C3130303732323433352C3130303733323936312C3130303733343134352C3130303733363232382C3130303733373037322C,0x3130303539313134372C3130303539313939362C3130303631353736352C3130303632383936382C3130303636323434352C3130303637383134322C3130303638313134302C3130303730313032352C3130303730363233382C3130303732323539352C3130303733333037342C3130303733343139332C3130303733363335312C3130303733373630382C),
 (2,'CDC14A.fApr07','chr1','+',100601262,100693628,100601265,100693626,7,0x3130303630313236322C3130303631353638392C3130303632383837352C3130303636323336352C3130303637383037352C3130303638313037372C3130303639333534382C,0x3130303630313336392C3130303631353736352C3130303632383936382C3130303636323434352C3130303637383134322C3130303638313134302C3130303639333632382C),
 (2,'CDC14A.lApr07','chr1','+',100661812,100681258,0,0,3,0x3130303636313831322C3130303637383037352C3130303638313037372C,0x3130303636323434352C3130303637383134322C3130303638313235382C),
 (2,'CDC14A.gApr07','chr1','+',100662094,100700922,100662131,100700922,5,0x3130303636323039342C3130303637383037352C3130303638313037372C3130303639333534382C3130303730303739342C,0x3130303636323330342C3130303637383134322C3130303638313134302C3130303639333633362C3130303730303932322C),
 (2,'TTF2.aApr07','chr1','+',117404433,117447018,117404491,117445669,23,0x3131373430343433332C3131373430343539392C3131373430363533312C3131373431373830352C3131373431393031342C3131373432303332342C3131373432303738352C3131373432323036302C3131373432333731322C3131373432353937322C3131373432383136322C3131373433303536312C3131373433323934352C3131373433343139392C3131373433343637362C3131373433353437322C3131373433353936312C3131373433363837352C3131373433393435332C3131373434303239332C3131373434313439352C3131373434323937372C3131373434353532342C,0x3131373430343531392C3131373430343730322C3131373430363631382C3131373431373837322C3131373432303030342C3131373432303433392C3131373432303936382C3131373432323138382C3131373432333739342C3131373432363039322C3131373432383331332C3131373433303636372C3131373433333132372C3131373433343335332C3131373433343736382C3131373433353535352C3131373433363039352C3131373433373034362C3131373433393531322C3131373434303434342C3131373434313537382C3131373434333035322C3131373434373031382C),
 (2,'TTF2.dApr07','chr1','+',117430546,117446994,117433058,117442992,11,0x3131373433303534362C3131373433323934352C3131373433343637362C3131373433353437322C3131373433353936312C3131373433363837352C3131373433393435332C3131373434303239332C3131373434323937372C3131373434353532342C3131373434363431312C,0x3131373433303636372C3131373433333132372C3131373433343736382C3131373433353535352C3131373433363039352C3131373433373034362C3131373433393531322C3131373434303434342C3131373434333035322C3131373434353730372C3131373434363939342C),
 (2,'TTF2.eApr07','chr1','+',117432472,117446286,117434604,117437109,7,0x3131373433323437322C3131373433343139392C3131373433353437322C3131373433353936312C3131373433363837352C3131373434303239332C3131373434353532342C,0x3131373433333132372C3131373433343736382C3131373433353535352C3131373433363039352C3131373433393531322C3131373434333035322C3131373434363238362C),
 (2,'TTF2.gApr07','chr1','+',117436931,117445802,117436932,117442356,6,0x3131373433363933312C3131373433393435332C3131373434303239332C3131373434323335302C3131373434323937372C3131373434353532342C,0x3131373433373034362C3131373433393531322C3131373434303434342C3131373434323338332C3131373434333035322C3131373434353830322C),
 (2,'TTF2.fApr07','chr1','+',117440315,117447000,117440315,117445669,5,0x3131373434303331352C3131373434313439352C3131373434323937372C3131373434353532342C3131373434363333382C,0x3131373434303434342C3131373434313537382C3131373434333035322C3131373434353730372C3131373434373030302C),
 (3,'slerber.aApr07','chr1','-',159377381,159390546,159377524,159390546,2,0x3135393337373338312C3135393339303331312C,0x3135393337373532372C3135393339303534362C),
 (3,'F5.aApr07','chr1','-',167747811,167822436,167750174,167822248,25,0x3136373734373831312C3136373735313330352C3136373735343237332C3136373735363338312C3136373735393035382C3136373735393636322C3136373736303639382C3136373736313736322C3136373736333737362C3136373736353436392C3136373736363634372C3136373737323336372C3136373737363135352C3136373738303135372C3136373738323330332C3136373738353636322C3136373738363530312C3136373738383431382C3136373739313034332C3136373739323530372C3136373739353031342C3136373739363431352C3136373830383038322C3136373831383239322C3136373832323039302C,0x3136373735303332312C3136373735313438382C3136373735343432352C3136373735363532362C3136373735393231342C3136373735393736362C3136373736303737302C3136373736313837392C3136373736333935362C3136373736353638302C3136373736363838342C3136373737323534322C3136373737383937362C3136373738303337302C3136373738323435342C3136373738353837372C3136373738363630312C3136373738383539362C3136373739313230392C3136373739323732392C3136373739353135382C3136373739363632382C3136373830383230352C3136373831383338342C3136373832323433362C),
 (3,'blawrabo.aApr07','chr1','-',176159452,176164243,0,0,3,0x3137363135393435322C3137363135393939302C3137363136333731362C,0x3137363135393930362C3137363136303038312C3137363136343234332C),
 (3,'PRG4.aApr07','chr1','+',184532029,184550322,184532630,184549533,13,0x3138343533323032392C3138343533323630302C3138343533353834352C3138343533373334362C3138343533393836322C3138343534303534382C3138343534323037322C3138343534353534372C3138343534363738382C3138343534373139342C3138343534373932392C3138343534383532332C3138343534393433352C,0x3138343533323034382C3138343533323730362C3138343533353936382C3138343533373436362C3138343534303031322C3138343534303637372C3138343534343839352C3138343534353632352C3138343534363932352C3138343534373335312C3138343534383132372C3138343534383634392C3138343535303332322C),
 (3,'PRG4.cApr07','chr1','+',184532594,184549785,184532630,184549533,6,0x3138343533323539342C3138343533373334362C3138343533393836322C3138343534383035362C3138343534383532332C3138343534393433352C,0x3138343533323730362C3138343533373436362C3138343533393938352C3138343534383132372C3138343534383634392C3138343534393738352C),
 (3,'TPR.aApr07','chr1','-',184547406,184611201,184549725,184610783,51,0x3138343534373430362C3138343535303338332C3138343535333233362C3138343535343230312C3138343535343438372C3138343535363036362C3138343535383037322C3138343535383237322C3138343535393434302C3138343536313531382C3138343536313835382C3138343536333231342C3138343536373235322C3138343536373934392C3138343536383837362C3138343537303037392C3138343537303832322C3138343537313039322C3138343537323235302C3138343537323736372C3138343537333738372C3138343537353339362C3138343537363738322C3138343537373030362C3138343537393038302C3138343537393636302C3138343538303132392C3138343538313333342C3138343538313838392C3138343538333034362C3138343538353937372C3138343538373038342C3138343538373733302C3138343538393434322C3138343539313136342C3138343539313338392C3138343539323034302C3138343539333135312C3138343539343239372C3138343539353535332C3138343539363032372C3138343539363531392C3138343539373337362C3138343539373534332C3138343539383034322C3138343539383539312C3138343539393039362C3138343630333634302C3138343630363732342C3138343630393131332C3138343631303633322C,0x3138343534393738312C3138343535303437392C3138343535333335352C3138343535343335382C3138343535343538332C3138343535363137332C3138343535383136372C3138343535383334312C3138343535393632352C3138343536313630392C3138343536313939302C3138343536333431352C3138343536373333362C3138343536383039382C3138343536393134392C3138343537303238382C3138343537303838342C3138343537313239382C3138343537323434392C3138343537323931312C3138343537333939382C3138343537353532372C3138343537363931342C3138343537373134342C3138343537393232382C3138343537393834352C3138343538303333332C3138343538313435312C3138343538323034322C3138343538333231332C3138343538363134332C3138343538373232352C3138343538373836352C3138343538393630352C3138343539313331332C3138343539313532332C3138343539323230342C3138343539333337382C3138343539343430352C3138343539353735312C3138343539363131392C3138343539363636302C3138343539373436342C3138343539373632342C3138343539383133352C3138343539383735362C3138343539393230302C3138343630333733372C3138343630363739382C3138343630393231382C3138343631313230312C),
 (4,'SLC30A10.1.dApr07','chr1','-',217925391,218198611,218124259,218198542,9,0x3231373932353339312C3231383033303331322C3231383033313234332C3231383035373632372C3231383036323438342C3231383132343039302C3231383135383231392C3231383136363939322C3231383139383533322C,0x3231373932353639372C3231383033303431332C3231383033323032302C3231383035373636392C3231383036323538352C3231383132343236372C3231383135383435392C3231383136373037302C3231383139383631312C),
 (4,'OBSCNandKIAA1639.aApr07','chr1','+',226462483,226615574,226466107,226615079,81,0x3232363436323438332C3232363436363038392C3232363436373736342C3232363436383439372C3232363436393131332C3232363436393838362C3232363437303734342C3232363437313333362C3232363437383738322C3232363439373530362C3232363439383631392C3232363439393733362C3232363530303835312C3232363530343238382C3232363531303937342C3232363531383433392C3232363532373539352C3232363532383039332C3232363532383530312C3232363532383839352C3232363533303038332C3232363533303737332C3232363533313235332C3232363533313438332C3232363533323037372C3232363533333031322C3232363533333439382C3232363533343134342C3232363533343530322C3232363533343835332C3232363533363235362C3232363533373334312C3232363533373832362C3232363534303430312C3232363534313039362C3232363534323031372C3232363534323338342C3232363534323934382C3232363534363232312C3232363534363834362C3232363534373637362C3232363534383437352C3232363534393130332C3232363536303639352C3232363536313232342C3232363536313538322C3232363536323433342C3232363536333432322C3232363536333830372C3232363537303137302C3232363537313033322C3232363537313738372C3232363537323231352C3232363537333230372C3232363537353636372C3232363537373635312C3232363538373138332C3232363538373532322C3232363538373930362C3232363538383833352C3232363538393133382C3232363538393430332C3232363539303131342C3232363539303532332C3232363539313332372C3232363539313536372C3232363539323236372C3232363539323631332C3232363539333137362C3232363539343236382C3232363539343832392C3232363539353034372C3232363539353431382C3232363539353736302C3232363539363434322C3232363630343231332C3232363630353136342C3232363630353634342C3232363630373237342C3232363631303437342C3232363631333932302C,0x3232363436323530392C3232363436373039352C3232363436383033342C3232363436383735382C3232363436393432322C3232363437303135332C3232363437313032362C3232363437313631322C3232363437393035382C3232363439373738322C3232363439383839352C3232363530303031322C3232363530313132372C3232363530343536342C3232363531313235302C3232363531383731352C3232363532373837312C3232363532383337322C3232363532383736382C3232363532393136352C3232363533303335302C3232363533313034302C3232363533313336362C3232363533313633372C3232363533323138322C3232363533333237392C3232363533333736382C3232363533343431312C3232363533343736392C3232363533353132302C3232363533363532392C3232363533373630382C3232363533383039332C3232363534303637342C3232363534313336332C3232363534323238342C3232363534323634382C3232363534333231322C3232363534363438352C3232363534373131302C3232363534373934302C3232363534383733392C3232363534393336372C3232363536303936322C3232363536313439312C3232363536313835352C3232363536323730372C3232363536333631392C3232363536333838332C3232363537303434332C3232363537313330382C3232363537323037352C3232363537323439372C3232363537333537382C3232363537363533382C3232363537373933302C3232363538373236322C3232363538373634372C3232363538383130342C3232363538383836382C3232363538393233372C3232363538393632322C3232363539303137352C3232363539303539342C3232363539313435302C3232363539313730372C3232363539323436382C3232363539323639362C3232363539333335302C3232363539343432352C3232363539343934362C3232363539353231322C3232363539353537372C3232363539353933382C3232363539363535362C3232363630343338312C3232363630353236372C3232363630353737342C3232363630373338362C3232363631303531372C3232363631353537342C),
 (4,'EFCAB2.aApr07','chr1','+',243199698,243357179,243200047,243351873,8,0x3234333139393639382C3234333233323034352C3234333234373136362C3234333238393331302C3234333331323030372C3234333331333336362C3234333331333534362C3234333335313834342C,0x3234333230303336382C3234333233323135372C3234333234373235312C3234333238393338332C3234333331323038372C3234333331333430392C3234333331333631332C3234333335373137392C),
 (4,'EFCAB2.cApr07','chr1','+',243199789,243317769,243200343,243317285,8,0x3234333139393738392C3234333230303235332C3234333234373136362C3234333238393331302C3234333331323030372C3234333331333336362C3234333331333534362C3234333331373136392C,0x3234333139393936382C3234333230303336382C3234333234373235312C3234333238393338332C3234333331323038372C3234333331333430392C3234333331333631332C3234333331373736392C),
 (4,'EFCAB2.oApr07','chr1','+',243200210,243322117,0,0,6,0x3234333230303231302C3234333238393331302C3234333331323030372C3234333331333336362C3234333331333534362C3234333332303935312C,0x3234333230303336382C3234333238393338332C3234333331323038372C3234333331333430392C3234333331333631332C3234333332323131372C),
 (4,'EFCAB2.eApr07','chr1','+',243200253,243351999,243200343,243351873,7,0x3234333230303235332C3234333234373136362C3234333238393331302C3234333331323030372C3234333331333336362C3234333331333534362C3234333335313834342C,0x3234333230303336382C3234333234373235312C3234333238393338332C3234333331323038372C3234333331333430392C3234333331333631332C3234333335313939392C),
 (4,'EFCAB2.iApr07','chr1','+',243200275,243317762,243312061,243317285,6,0x3234333230303237352C3234333238393331302C3234333331323030372C3234333331333336362C3234333331333534362C3234333331373136392C,0x3234333230303336382C3234333238393338332C3234333331323038372C3234333331333430392C3234333331333631332C3234333331373736322C),
 (4,'EFCAB2.bApr07','chr1','+',243200279,243318110,243200281,243317285,8,0x3234333230303237392C3234333233323034352C3234333234373136362C3234333238393331302C3234333331323030372C3234333331333336362C3234333331333534362C3234333331373136392C,0x3234333230303336382C3234333233323135372C3234333234373235312C3234333238393338332C3234333331323038372C3234333331333430392C3234333331333631332C3234333331383131302C),
 (4,'EFCAB2.mApr07','chr1','+',243200315,243352916,243312061,243351873,6,0x3234333230303331352C3234333238393331302C3234333331323030372C3234333331333336362C3234333331333534362C3234333335313834342C,0x3234333230303336382C3234333238393338332C3234333331323038372C3234333331333430392C3234333331333631332C3234333335323931362C),
 (4,'EFCAB2.hApr07','chr1','+',243200330,243317762,243232143,243313660,7,0x3234333230303333302C3234333233323034352C3234333238393331302C3234333331323030372C3234333331333336362C3234333331333534362C3234333331363539352C,0x3234333230303336382C3234333233323135372C3234333238393338332C3234333331323038372C3234333331333430392C3234333331353030382C3234333331373736322C),
 (4,'EFCAB2.dApr07','chr1','+',243200339,243315054,243200343,243313660,6,0x3234333230303333392C3234333234373136362C3234333238393331302C3234333331323030372C3234333331333336362C3234333331333534362C,0x3234333230303336382C3234333234373235312C3234333238393338332C3234333331323038372C3234333331333430392C3234333331353035342C),
 (4,'EFCAB2.jApr07','chr1','+',243200347,243317497,243200349,243312011,8,0x3234333230303334372C3234333234373136362C3234333238393331302C3234333330353439382C3234333331323030372C3234333331333336362C3234333331333534362C3234333331373136392C,0x3234333230303336382C3234333234373235312C3234333238393338332C3234333330353533362C3234333331323038372C3234333331333430392C3234333331333631332C3234333331373439372C),
 (4,'EFCAB2.gApr07','chr1','+',243247166,243317763,243247168,243316719,6,0x3234333234373136362C3234333238393331302C3234333331323030372C3234333331333336362C3234333331333534362C3234333331363638342C,0x3234333234373235312C3234333238393338332C3234333331323038372C3234333331333430392C3234333331333631332C3234333331373736332C),
 (9,'PRKCZ.bApr07','chr1','+',1971772,2106698,1971929,2106308,18,0x313937313737322C313937363733392C313937373738322C313938303833392C323035363536302C323036353530382C323036373332352C323037303137302C323037323038382C323037373239332C323039303831362C323039333335332C323039333539392C323039353139352C323039363035322C323039363532322C323130353838312C323130363232302C,0x313937323030302C313937363836312C313937373837322C313938303839302C323035363634362C323036353634302C323036373430372C323037303232332C323037323237372C323037373339312C323039303930332C323039333438392C323039333638372C323039353331352C323039363133322C323039363631322C323130353939372C323130363639382C),
 (9,'PRKCZ.hApr07','chr1','+',1971797,2107998,1977808,2107040,13,0x313937313739372C313937363733392C313937373738322C313938303833392C323035363536302C323036353530382C323036373332352C323037303137302C323037323038382C323037373239332C323039303831362C323039333335332C323130363938302C,0x313937323030302C313937363834342C313937373837322C313938303839302C323035363634362C323036353634302C323036373430372C323037303232332C323037323237372C323037373339312C323039303930332C323039333435362C323130373939382C),
 (9,'PRKCZ.aApr07','chr1','+',1972106,2106679,1972108,2106308,18,0x313937323130362C313937363733392C313937373738322C313938303833392C323035363536302C323036353530382C323036373332352C323037303137302C323037323038382C323037373239332C323039303739322C323039333335332C323039333539392C323039353139352C323039363035322C323039363532322C323130353838312C323130363232302C,0x313937323331312C313937363836312C313937373837322C313938303839302C323035363634362C323036353634302C323036373430372C323037303232332C323037323237372C323037373339312C323039303930332C323039333438392C323039333638372C323039353331352C323039363133322C323039363631322C323130353939372C323130363637392C),
 (9,'PRKCZ.dApr07','chr1','+',1994761,2106694,1995209,2106308,15,0x313939343736312C323035363536302C323036353530382C323036373332352C323037303137302C323037323038382C323037373239332C323039303831362C323039333335332C323039333539392C323039353139352C323039363035322C323039363532322C323130353838312C323130363232302C,0x313939353232382C323035363634362C323036353634302C323036373430372C323037303232332C323037323237372C323037373339312C323039303930332C323039333438392C323039333638372C323039353331352C323039363133322C323039363631322C323130353939372C323130363639342C),
 (9,'PRKCZ.fApr07','chr1','+',2026014,2106630,2067334,2106308,15,0x323032363031342C323035363536302C323036353530382C323036363633362C323036373332352C323037303137302C323037323038382C323037373239332C323039333336332C323039333539392C323039353139352C323039363035322C323039363532322C323130353838312C323130363232302C,0x323032363139342C323035363634362C323036353634302C323036363831302C323036373430372C323037303232332C323037323237372C323037373339312C323039333438392C323039333638372C323039353331352C323039363133322C323039363631322C323130353939372C323130363633302C),
 (9,'PRKCZ.vdApr07','chr1','+',2026015,2106686,2026043,2066714,7,0x323032363031352C323035363536302C323036353530382C323036363638372C323036373332352C323037303137302C323130363232302C,0x323032363139342C323035363634362C323036353634302C323036363831302C323036373430372C323037303232332C323130363638362C),
 (9,'PRKCZ.cApr07','chr1','+',2026015,2106694,2026043,2106308,15,0x323032363031352C323035363536302C323036353530382C323036373332352C323037303137302C323037323038382C323037373239332C323039303831362C323039333335332C323039333539392C323039353139352C323039363035322C323039363532322C323130353838312C323130363232302C,0x323032363139342C323035363634362C323036353634302C323036373430372C323037303232332C323037323237372C323037373339312C323039303930332C323039333438392C323039333638372C323039353331352C323039363133322C323039363631322C323130353939372C323130363639342C),
 (9,'PRKCZ.oApr07','chr1','+',2026017,2106692,2026043,2072164,8,0x323032363031372C323035363536302C323036353530382C323037303137302C323037323038382C323039363532322C323130353838312C323130363338352C,0x323032363139342C323035363634362C323036353634302C323037303232332C323037323136342C323039363631322C323130353939372C323130363639322C),
 (9,'PRKCZ.jApr07','chr1','+',2056567,2106689,2056595,2066714,5,0x323035363536372C323036333331342C323036353530382C323036363638372C323130363239312C,0x323035363634362C323036333538302C323036353634302C323036363738312C323130363638392C),
 (9,'PRKCZ.gApr07','chr1','+',2065750,2106694,2065859,2106308,13,0x323036353735302C323036373332352C323037303137302C323037323038382C323037373239332C323039303831362C323039333335332C323039333539392C323039353139352C323039363035322C323039363532322C323130353838312C323130363232302C,0x323036353838332C323036373430372C323037303232332C323037323237372C323037373339312C323039303930332C323039333438392C323039333638372C323039353331352C323039363133322C323039363631322C323130353939372C323130363639342C),
 (9,'PRKCZ.eApr07','chr1','+',2090147,2106692,2090247,2106308,8,0x323039303134372C323039333335332C323039333539392C323039353139352C323039363035322C323039363532322C323130353838312C323130363232302C,0x323039303930332C323039333438392C323039333638372C323039353331352C323039363133322C323039363631322C323130353939372C323130363639322C),
 (9,'PRKCZ.vkApr07','chr1','+',2096559,2106692,2103159,2106308,4,0x323039363535392C323130333133302C323130353838312C323130363232302C,0x323039363631322C323130333231332C323130353939372C323130363639322C),
 (9,'PRDM16.aApr07','chr1','+',2975598,3345043,2975683,3340235,17,0x323937353539382C333039323534382C333135303531302C333239313537352C333330323931342C333330393231342C333331313136322C333331313931382C333331373830372C333332303938332C333332343235312C333332353039302C333333323030342C333333323437342C333333373239352C333333383338392C333334303130302C,0x323937353732302C333039323839382C333135303536312C333239313731302C333330333031372C333330393432322C333331313331302C333331323037322C333331393232342C333332313037312C333332343432312C333332353136382C333333323137342C333333323634392C333333373533322C333333383536342C333334353034332C),
 (9,'PRDM16.eApr07','chr1','+',2975603,3309288,2975683,3309288,6,0x323937353630332C333039323534382C333135303531302C333239313537322C333330323931342C333330393231342C,0x323937353732302C333039323839382C333135303536312C333239313731302C333330333031372C333330393238382C),
 (9,'PRDM16.dApr07','chr1','+',2975603,3345045,2975683,3340235,17,0x323937353630332C333039323534382C333135303531302C333239313537352C333330323931342C333330393231342C333331313136322C333331313931382C333331373830372C333332303938362C333332343235312C333332353039302C333333323030342C333333323437342C333333373239352C333333383338392C333334303135372C,0x323937353732302C333039323839382C333135303536312C333239313731302C333330333031372C333330393432322C333331313331302C333331323037322C333331393232342C333332313037312C333332343432312C333332353136382C333333323137342C333333323634392C333333373533322C333333383536342C333334353034352C),
 (9,'PRDM16.bApr07','chr1','+',2975603,3345045,2975683,3340235,17,0x323937353630332C333039323534382C333135303531302C333239313537352C333330323931342C333330393231342C333331313136322C333331313931382C333331373830372C333332303938362C333332343235312C333332353039302C333333323030342C333333323437342C333333373239352C333333383338392C333334303130302C,0x323937353732302C333039323839382C333135303536312C333239313731302C333330333031372C333330393432322C333331313331302C333331323037322C333331393232342C333332313037312C333332343432312C333332353136382C333333323137342C333333323634392C333333373533322C333333383536342C333334353034352C),
 (9,'PRDM16.cApr07','chr1','+',2975639,3341845,2975683,3340235,17,0x323937353633392C333039323534382C333135303531302C333239313537352C333330323931342C333330393231342C333331313136322C333331313931382C333331373830372C333332303938332C333332343235312C333332353039302C333333323030342C333333323437342C333333373239352C333333383338392C333334303135372C,0x323937353732302C333039323839382C333135303536312C333239313731302C333330333031372C333330393432322C333331313331302C333331323037322C333331393232342C333332313037312C333332343432312C333332353136382C333333323137342C333333323634392C333333373533322C333333383536342C333334313834352C),
 (9,'ACOT7.cApr07','chr1','-',6246641,6376452,6247243,6376046,9,0x363234363634312C363236333734382C363237373531302C363330313133382C363330393934352C363331363132332C363332323037392C363333323339352C363337353930332C,0x363234373334322C363236333933332C363237373632372C363330313232352C363331303036302C363331363231352C363332323233362C363333323531332C363337363435322C),
 (9,'ACOT7.aApr07','chr1','-',6246913,6368475,6247243,6368313,9,0x363234363931332C363236333734382C363237373531302C363330313133382C363330393934352C363331363132332C363332323037392C363333323339352C363336383134302C,0x363234373334322C363236333933332C363237373632372C363330313232352C363331303036302C363331363231352C363332323233362C363333323531332C363336383437352C),
 (9,'ACOT7.iApr07','chr1','-',6246918,6376023,6265527,6375950,10,0x363234363931382C363236333734382C363236353337302C363237373531302C363330313133382C363330393934352C363331363132332C363332323037392C363333323339352C363337353930332C,0x363234373334322C363236333933332C363236353533352C363237373632372C363330313232352C363331303036302C363331363231352C363332323233362C363333323531332C363337363032332C),
 (9,'ACOT7.dApr07','chr1','-',6246918,6341993,6247243,6341492,9,0x363234363931382C363236333734382C363237373531302C363330313133382C363330393934352C363331363132332C363332323037392C363333323339352C363334313437322C,0x363234373334322C363236333933332C363237373632372C363330313232352C363331303036302C363331363231352C363332323233362C363333323531332C363334313939332C),
 (9,'ACOT7.bApr07','chr1','-',6246918,6343379,6247243,6343377,9,0x363234363931382C363236333734382C363237373531302C363330313133382C363330393934352C363331363132332C363332323037392C363333323339352C363334333231362C,0x363234373334322C363236333933332C363237373632372C363330313232352C363331303036302C363331363231352C363332323233362C363333323531332C363334333337392C),
 (9,'ACOT7.gApr07','chr1','-',6246919,6376008,6263887,6375950,10,0x363234363931392C363236333734382C363236353337302C363237373531302C363330313133382C363330393934352C363331363132332C363332323037392C363333323339352C363337353930332C,0x363234373334322C363236333933332C363236353434332C363237373632372C363330313232352C363331303036302C363331363231352C363332323233362C363333323531332C363337363030382C),
 (9,'ACOT7.jApr07','chr1','-',6246949,6376042,6277602,6376040,9,0x363234363934392C363236333734382C363237373531302C363330313133382C363330393934352C363331363132332C363332323037392C363333323339352C363337353930332C,0x363234373334322C363236333933332C363237373632372C363330313232332C363331303036302C363331363231352C363332323233362C363333323531332C363337363034322C),
 (9,'ACOT7.eApr07','chr1','-',6247042,6345392,6247310,6345391,10,0x363234373034322C363237373531302C363330313133382C363330393934352C363331363132332C363332323037392C363333323339352C363334333231362C363334333530342C363334353335382C,0x363234373334322C363237373632372C363330313232352C363331303036302C363331363231352C363332323233362C363333323531332C363334333333352C363334333538322C363334353339322C),
 (9,'ACOT7.hApr07','chr1','-',6263776,6334896,6263778,6332509,8,0x363236333737362C363237373531302C363330313133382C363330393934352C363331363132332C363332323037392C363333323339352C363333343837312C,0x363236333933332C363237373632372C363330313232352C363331303036302C363331363231352C363332323233362C363333323531332C363333343839362C),
 (9,'ACOT7.fApr07','chr1','-',6277097,6376007,6277340,6375950,7,0x363237373039372C363330313133382C363330393934352C363331363132332C363332323037392C363333323339352C363337353930332C,0x363237373632372C363330313232352C363331303036302C363331363231352C363332323233362C363333323531332C363337363030372C),
 (9,'CAMTA1.aApr07','chr1','+',6767970,7752353,6768177,7749138,23,0x363736373937302C363830323832372C363830373733382C373037333935302C373233323133372C373435303437362C373632333034362C373634343337322C373634353939392C373635333535372C373636303234352C373731353039342C373731383939302C373731393537372C373731393930312C373732303630352C373732373438312C373732383439312C373733303335362C373733333834352C373733353130352C373733383238342C373734393130352C,0x363736383232322C363830323839372C363830373835372C373037343031382C373233323237332C373435303534382C373632333230302C373634343531332C373634373834362C373635333638342C373636303338302C373731353234362C373731393138372C373731393635362C373732303231372C373732313132392C373732373636392C373732383733382C373733303432382C373733343033392C373733353138302C373733383331352C373735323335332C),
 (10,'PEX14.jApr07','chr1','+',10454931,10519248,10454933,10499764,4,0x31303435343933312C31303437373931372C31303439393637312C31303531383835362C,0x31303435353232342C31303437373936352C31303439393737352C31303531393234382C),
 (10,'PEX14.fApr07','chr1','+',10457525,10612489,10457610,10612487,8,0x31303435373532352C31303437373931372C31303531383835362C31303630303937352C31303630353636322C31303630363938332C31303630393931352C31303631323137342C,0x31303435373634362C31303437373936352C31303531383934312C31303630313036312C31303630353736352C31303630373038312C31303631303030372C31303631323438392C),
 (10,'PEX14.hApr07','chr1','+',10457590,10605930,10457610,10605776,6,0x31303435373539302C31303437373931372C31303531383835362C31303538313838312C31303630303937352C31303630353636322C,0x31303435373634362C31303437373936352C31303531383934312C31303538323031302C31303630313036312C31303630353933302C),
 (10,'PEX14.dApr07','chr1','+',10457590,10613406,10457610,10612631,9,0x31303435373539302C31303437373931372C31303531383835362C31303538313838312C31303630303937352C31303630353636322C31303630363938332C31303630393931352C31303631323137342C,0x31303435373634362C31303437373936352C31303531383934312C31303538323031302C31303630313036312C31303630353736352C31303630373038312C31303631303030372C31303631333430362C),
 (10,'PEX14.lApr07','chr1','+',10457596,10600981,10457610,10571161,6,0x31303435373539362C31303437373931372C31303531383835362C31303537313132362C31303538313838312C31303630303937352C,0x31303435373634362C31303437373936352C31303531383934312C31303537313336392C31303538323031302C31303630303938312C),
 (10,'PEX14.aApr07','chr1','+',10457598,10566168,10457610,10566167,5,0x31303435373539382C31303437373931372C31303531383835362C31303535393432312C31303536363036352C,0x31303435373634362C31303437373936352C31303531383934312C31303535393435322C31303536363136382C),
 (10,'PEX14.qApr07','chr1','+',10457601,10518917,0,0,6,0x31303435373630312C31303437373931372C31303530323434362C31303530343038322C31303530373034392C31303531383835362C,0x31303435373634362C31303437373936352C31303530323632302C31303530343235312C31303530373132372C31303531383931372C),
 (10,'PEX14.oApr07','chr1','+',10457602,10502665,10457604,10502524,3,0x31303435373630322C31303437373931372C31303530323434362C,0x31303435373634362C31303437373936352C31303530323636352C),
 (10,'PEX14.mApr07','chr1','+',10457604,10561073,10457610,10559505,4,0x31303435373630342C31303437373931372C31303535393432312C31303536303435362C,0x31303435373634362C31303437373936352C31303535393833342C31303536313037332C),
 (10,'PEX14.kApr07','chr1','+',10457606,10606007,10457610,10605776,5,0x31303435373630362C31303437373931372C31303531383835362C31303630303937352C31303630353636322C,0x31303435373634362C31303437373936352C31303531383934312C31303630313036312C31303630363030372C),
 (10,'PEX14.nApr07','chr1','+',10457620,10502654,10457626,10477940,4,0x31303435373632302C31303436303535332C31303437373931372C31303530323434362C,0x31303435373634362C31303436303637352C31303437373936352C31303530323635342C),
 (10,'PEX14.cApr07','chr1','+',10457826,10613400,10458372,10613341,3,0x31303435373832362C31303437373537332C31303631323837312C,0x31303435383338342C31303437373539382C31303631333430302C),
 (10,'PEX14.eApr07','chr1','+',10478233,10613395,10581904,10612631,8,0x31303437383233332C31303531383835362C31303538313838312C31303630303937352C31303630353636322C31303630363938332C31303630393931352C31303631323137342C,0x31303437383336352C31303531383934312C31303538323031302C31303630313036312C31303630353736352C31303630373038312C31303631303030372C31303631333339352C),
 (10,'DHRS3.aApr07','chr1','-',12550468,12600953,12550955,12599940,6,0x31323535303436382C31323535353334322C31323536313333322C31323536313930372C31323536333133372C31323539393734352C,0x31323535313034302C31323535353436382C31323536313537312C31323536323032372C31323536333238312C31323630303935332C),
 (10,'DHRS3.dApr07','chr1','-',12550526,12600274,12550955,12563221,6,0x31323535303532362C31323535353334322C31323536313333322C31323536313930372C31323536333133372C31323539393135302C,0x31323535313034302C31323535353436382C31323536313537312C31323536323032372C31323536333238312C31323630303237342C),
 (10,'DHRS3.lApr07','chr1','-',12551007,12599387,12551007,12563221,4,0x31323535313030372C31323535353334322C31323536333133372C31323539393135302C,0x31323535313034302C31323535353436382C31323536333238312C31323539393338372C),
 (10,'DHRS3.eApr07','chr1','-',12561438,12601699,12561439,12599895,5,0x31323536313433382C31323536313930372C31323536333133372C31323539393734352C31323630313636332C,0x31323536313537312C31323536323032372C31323536333238312C31323539393839352C31323630313639392C),
 (10,'DHRS3.kApr07','chr1','-',12562457,12599287,12562972,12563221,2,0x31323536323435372C31323539393135302C,0x31323536333238312C31323539393238372C),
 (10,'DHRS3.fApr07','chr1','-',12562722,12600231,12562972,12599940,2,0x31323536323732322C31323539393734352C,0x31323536333238312C31323630303233312C),
 (10,'DNAJC16.aApr07','chr1','+',15725776,15771064,15728187,15767259,15,0x31353732353737362C31353732383136392C31353733333331382C31353733353535362C31353734333438302C31353734353834382C31353734373335312C31353735383630372C31353736313232332C31353736333031302C31353736333336342C31353736353030302C31353736353136332C31353736363138302C31353736363835392C,0x31353732363034302C31353732383335342C31353733333338352C31353733353839362C31353734333636352C31353734353935332C31353734373531302C31353735383733382C31353736313430372C31353736333139332C31353736333434312C31353736353038312C31353736353236322C31353736363335312C31353737313036342C),
 (10,'DNAJC16.bApr07','chr1','+',15725930,15771486,15733373,15767259,15,0x31353732353933302C31353733333331382C31353733353535362C31353734333438302C31353734353834382C31353734373335312C31353735383630372C31353736313232332C31353736333031302C31353736333336342C31353736353030302C31353736353136332C31353736363138302C31353736363835392C31353737313339352C,0x31353732363034302C31353733333338352C31353733353839362C31353734333636352C31353734353935332C31353734373531302C31353735383733382C31353736313430372C31353736333139332C31353736333434312C31353736353038312C31353736353236322C31353736363335312C31353737313033312C31353737313438362C),
 (10,'DNAJC16.eApr07','chr1','+',15725936,15770095,15728187,15765272,14,0x31353732353933362C31353732383136392C31353733333331382C31353733353535362C31353734333438302C31353734353834382C31353734373335312C31353735383630372C31353736313232332C31353736333031302C31353736333336342C31353736353030302C31353736353136332C31353736393537372C,0x31353732363034302C31353732383335342C31353733333338352C31353733353839362C31353734333636352C31353734353935332C31353734373531302C31353735383733382C31353736313430372C31353736333139332C31353736333434312C31353736353038312C31353736353637362C31353737303039352C),
 (10,'DNAJC16.dApr07','chr1','+',15725955,15771447,15725956,15765272,16,0x31353732353935352C31353732383136392C31353733333331382C31353733353535362C31353734333438302C31353734353834382C31353734373335312C31353735383630372C31353736313232332C31353736333031302C31353736333336342C31353736353030302C31353736353136332C31353736363138302C31353736363835392C31353737313337382C,0x31353732363034302C31353732383335342C31353733333338352C31353733353839362C31353734333636352C31353734353935332C31353734373531302C31353735383733382C31353736313430372C31353736333139332C31353736333434312C31353736353038312C31353736353439322C31353736363335312C31353737313034352C31353737313434372C),
 (10,'DNAJC16.cApr07','chr1','+',15725969,15775169,15725971,15773860,15,0x31353732353936392C31353732383136392C31353733333331382C31353733353535362C31353734333438302C31353734353834382C31353734373335312C31353735383630372C31353736313232332C31353736333031302C31353736333336342C31353736353030302C31353736353136332C31353736363138302C31353737333834312C,0x31353732363034302C31353732383335342C31353733333338352C31353733353839362C31353734333636352C31353734353935332C31353734373531302C31353735383733382C31353736313430372C31353736333139332C31353736333434312C31353736353038312C31353736353236322C31353736363335312C31353737353136392C),
 (10,'DNAJC16.hApr07','chr1','+',15728020,15735705,15728187,15735703,3,0x31353732383032302C31353733333331382C31353733353535362C,0x31353732383335342C31353733333338352C31353733353730352C),
 (10,'DNAJC16.kApr07-unspliced','chr1','+',15728117,15728900,15728187,15728358,1,0x31353732383131372C,0x31353732383930302C),
 (11,'ARHGEF10L.cApr07','chr1','+',17712454,17896950,17779677,17896462,27,0x31373731323435342C31373737393633342C31373738363534312C31373738373532372C31373830313230382C31373830323538392C31373830363838332C31373831353137352C31373831383432302C31373832303934352C31373832323037372C31373832333436382C31373832353033372C31373832363431312C31373833313430322C31373833333931362C31373833363936392C31373833373634332C31373833393238332C31373834373633352C31373835333731372C31373835343936302C31373835353633352C31373836333532382C31373838363635342C31373839343233392C31373839353932392C,0x31373731323630362C31373737393731342C31373738363732372C31373738373536312C31373830313330302C31373830323637332C31373830373035392C31373831353238342C31373831383532372C31373832313032332C31373832323235372C31373832333538352C31373832353133302C31373832363538352C31373833313534382C31373833343039382C31373833373038352C31373833373737312C31373833393338342C31373834373735372C31373835333830342C31373835353138342C31373835353739302C31373836333637372C31373838363832392C31373839343336322C31373839363935302C),
 (11,'ARHGEF10L.bApr07','chr1','+',17719280,17896957,17779677,17896462,28,0x31373731393238302C31373737393633342C31373738363534312C31373738373532372C31373830313230382C31373830323538392C31373830363838332C31373831353137352C31373831383432302C31373832303934352C31373832323037372C31373832333436382C31373832353033372C31373832363431312C31373833313430322C31373833333632392C31373833333931362C31373833363936392C31373833373634332C31373833393238332C31373834373633352C31373835333731372C31373835343936302C31373835353633352C31373836333532382C31373838363635342C31373839343233392C31373839353932392C,0x31373731393534312C31373737393731342C31373738363732372C31373738373536312C31373830313330302C31373830323637332C31373830373035392C31373831353238342C31373831383532372C31373832313032332C31373832323235372C31373832333538352C31373832353133302C31373832363538352C31373833313534382C31373833333634342C31373833343039382C31373833373038352C31373833373737312C31373833393338342C31373834373735372C31373835333830342C31373835353138342C31373835353739302C31373836333637372C31373838363832392C31373839343336322C31373839363935372C),
 (11,'ARHGEF10L.aApr07','chr1','+',17738916,17896957,17779677,17896462,29,0x31373733383931362C31373737393633342C31373738363534312C31373738373532372C31373830313230382C31373830323538392C31373830363838332C31373831323133392C31373831353137352C31373831383432302C31373832303934352C31373832323037372C31373832333436382C31373832353033372C31373832363431312C31373833313430322C31373833333632392C31373833333931362C31373833363936392C31373833373634332C31373833393238332C31373834373633352C31373835333731372C31373835343936302C31373835353633352C31373836333532382C31373838363635342C31373839343233392C31373839353932392C,0x31373733393033322C31373737393731342C31373738363732372C31373738373536312C31373830313330302C31373830323637332C31373830373035392C31373831323235362C31373831353238342C31373831383532372C31373832313032332C31373832323235372C31373832333538352C31373832353133302C31373832363538352C31373833313534382C31373833333634342C31373833343039382C31373833373038352C31373833373737312C31373833393338342C31373834373735372C31373835333830342C31373835353138342C31373835353739302C31373836333637372C31373838363832392C31373839343336322C31373839363935372C),
 (11,'ARHGEF10L.dApr07','chr1','+',17814170,17896950,17815151,17896462,20,0x31373831343137302C31373831383432302C31373832303934352C31373832323037372C31373832333436382C31373832353033372C31373832363431312C31373833313430322C31373833333931362C31373833363936392C31373833373634332C31373833393238332C31373834373633352C31373835333731372C31373835343936302C31373835353633352C31373836333532382C31373838363635342C31373839343233392C31373839353932392C,0x31373831353238342C31373831383532372C31373832313032332C31373832323235372C31373832333538352C31373832353133302C31373832363538352C31373833313534382C31373833343039382C31373833373038352C31373833373737312C31373833393338342C31373834373735372C31373835333830342C31373835353138342C31373835353739302C31373836333637372C31373838363832392C31373839343336322C31373839363935302C),
 (11,'ARHGEF10L.eApr07','chr1','+',17817396,17896950,17817435,17896462,18,0x31373831373339362C31373831383432302C31373832303934352C31373832323037372C31373832363431312C31373833313430322C31373833333931362C31373833363936392C31373833373634332C31373833393238332C31373834373633352C31373835333731372C31373835343936302C31373835353633352C31373836333532382C31373838363635342C31373839343233392C31373839353932392C,0x31373831373630342C31373831383532372C31373832313032332C31373832323235372C31373832363538352C31373833313534382C31373833343039382C31373833373038352C31373833373737312C31373833393338342C31373834373735372C31373835333830342C31373835353138342C31373835353739302C31373836333637372C31373838363832392C31373839343336322C31373839363935302C),
 (11,'ARHGEF10L.gApr07','chr1','+',17817739,17896950,17818440,17838323,22,0x31373831373733392C31373832303934352C31373832323037372C31373832333436382C31373832353033372C31373832363431312C31373833313430322C31373833333931362C31373833363936392C31373833373634332C31373833383331392C31373833383931332C31373833393238332C31373834373633352C31373835333731372C31373835343936302C31373835353633352C31373836333532382C31373838363635342C31373839333638352C31373839343233392C31373839353932392C,0x31373831383532372C31373832313032332C31373832323235372C31373832333538352C31373832353133302C31373832363538352C31373833313534382C31373833343039382C31373833373038352C31373833373737312C31373833383533362C31373833393036332C31373833393338342C31373834373735372C31373835333830342C31373835353138342C31373835353739302C31373836333637372C31373838363832392C31373839343037392C31373839343336322C31373839363935302C),
 (11,'ARHGEF10L.fApr07','chr1','+',17818420,17896950,17823528,17890265,20,0x31373831383432302C31373832303934352C31373832323037372C31373832333532342C31373832353033372C31373832363431312C31373833313430322C31373833333931362C31373833363936392C31373833373634332C31373833393238332C31373834373633352C31373835333731372C31373835343936302C31373835353633352C31373836333532382C31373837353732332C31373839303230312C31373839343233392C31373839353932392C,0x31373831383532372C31373832313032332C31373832323235372C31373832333538352C31373832353133302C31373832363538352C31373833313534382C31373833343039382C31373833373038352C31373833373737312C31373833393338342C31373834373735372C31373835333830342C31373835353138342C31373835353739302C31373836333637372C31373837353733312C31373839303237342C31373839343336322C31373839363935302C),
 (11,'PAX7.cApr07','chr1','+',18830086,18935219,18830684,18935120,8,0x31383833303038362C31383833333338332C31383833343139312C31383833353332332C31383839303833342C31383839393733332C31383930323137342C31383933343731322C,0x31383833303736392C31383833333631392C31383833343332312C31383833353435322C31383839313033342C31383839393839392C31383930323337372C31383933353231392C),
 (11,'PAX7.bApr07','chr1','+',18830086,18935224,18830684,18935120,8,0x31383833303038362C31383833333338332C31383833343139312C31383833353331372C31383839303833342C31383839393733332C31383930323137342C31383933343731322C,0x31383833303736392C31383833333631392C31383833343332312C31383833353435322C31383839313033342C31383839393839392C31383930323337372C31383933353232342C),
 (11,'PAX7.aApr07','chr1','+',18830582,18944124,18830582,18944010,9,0x31383833303538322C31383833333338332C31383833343139312C31383833353331372C31383839303833342C31383839393733332C31383930323137342C31383933343731322C31383934333839342C,0x31383833303736392C31383833333631392C31383833343332312C31383833353435322C31383839313033342C31383839393839392C31383930323337372C31383933343935392C31383934343132342C),
 (11,'TMCO4.gApr07','chr1','-',19881293,19937498,19882119,19937454,5,0x31393838313239332C31393839333531332C31393839393834372C31393933363435312C31393933373330312C,0x31393838323532342C31393839333633312C31393839393936352C31393933363533362C31393933373439382C),
 (11,'TMCO4.bApr07','chr1','-',19881293,19998998,19882119,19979838,16,0x31393838313239332C31393839333531332C31393839393834372C31393933363435312C31393933383930332C31393933393835362C31393934343631312C31393934353533352C31393934363234322C31393935343731332C31393936393632312C31393937303338372C31393937393635392C31393938363130352C31393939373231362C31393939383933342C,0x31393838323532342C31393839333633312C31393839393936352C31393933363533362C31393933393034302C31393934303032312C31393934343733312C31393934353637392C31393934363334302C31393935343834362C31393936393634392C31393937303536322C31393937393834362C31393938363139372C31393939373239352C31393939383939382C),
 (11,'TMCO4.eApr07','chr1','-',19881317,19999029,19882119,19979838,11,0x31393838313331372C31393839333531332C31393839393834372C31393934353533352C31393934363234322C31393935343731332C31393936393632312C31393937303338372C31393937393635392C31393938363130352C31393939383933342C,0x31393838323532342C31393839333633312C31393839393936352C31393934353637392C31393934363334302C31393935343834362C31393936393634392C31393937303536322C31393937393834362C31393938363139372C31393939393032392C);
INSERT INTO `aceview_hg18_housekeeping` (`bin`,`name`,`chrom`,`strand`,`txStart`,`txEnd`,`cdsStart`,`cdsEnd`,`exonCount`,`exonStarts`,`exonEnds`) VALUES 
 (11,'TMCO4.cApr07','chr1','-',19881319,19999293,19881708,19979838,17,0x31393838313331392C31393838323336372C31393839333531332C31393839393834372C31393933363435312C31393933383930332C31393933393835362C31393934343631312C31393934353533352C31393934363234322C31393935343731332C31393936393632312C31393937303338372C31393937393635392C31393938363130352C31393939383235332C31393939393237372C,0x31393838313739342C31393838323532342C31393839333633312C31393839393936352C31393933363533362C31393933393034302C31393934303032312C31393934343733312C31393934353637392C31393934363334302C31393935343834362C31393936393634392C31393937303536322C31393937393834362C31393938363139372C31393939383432392C31393939393239332C),
 (11,'TMCO4.dApr07','chr1','-',19881321,19998424,19881708,19979838,15,0x31393838313332312C31393838323336372C31393839333531332C31393839393834372C31393933363435312C31393933383930332C31393933393835362C31393934353533352C31393934363234322C31393935343731332C31393936393632312C31393937303338372C31393937393635392C31393938363130352C31393939383235332C,0x31393838313739342C31393838323532342C31393839333633312C31393839393936352C31393933363533362C31393933393034302C31393934303032312C31393934353637392C31393934363334302C31393935343834362C31393936393634392C31393937303536322C31393937393834362C31393938363139372C31393939383432342C),
 (11,'TMCO4.aApr07','chr1','-',19881321,19999345,19881708,19979838,16,0x31393838313332312C31393838323336372C31393839333531332C31393839393834372C31393933363435312C31393933383930332C31393933393835362C31393934343631312C31393934353533352C31393934363234322C31393935343731332C31393936393632312C31393937303338372C31393937393635392C31393938363130352C31393939393237372C,0x31393838313739342C31393838323532342C31393839333633312C31393839393936352C31393933363533362C31393933393034302C31393934303032312C31393934343733312C31393934353637392C31393934363334302C31393935343834362C31393936393634392C31393937303536322C31393937393834362C31393938363139372C31393939393334352C),
 (11,'TMCO4.fApr07','chr1','-',19881324,19999345,19882119,19979838,10,0x31393838313332342C31393934343638302C31393934353533352C31393934363234322C31393935343731332C31393936393632312C31393937303338372C31393937393635392C31393938363130352C31393939393237372C,0x31393838323337382C31393934343733312C31393934353637392C31393934363334302C31393935343834362C31393936393634392C31393937303536322C31393937393834362C31393938363139372C31393939393334352C),
 (11,'HP1BP3.bApr07','chr1','-',20941734,20985767,20943876,20979520,13,0x32303934313733342C32303934343632322C32303934363632332C32303934383830322C32303935363234352C32303936343435362C32303936363636332C32303937303030392C32303937323533302C32303937353637362C32303937383839312C32303937393432342C32303938353732382C,0x32303934343137312C32303934343733362C32303934363733352C32303934383936322C32303935363333362C32303936343631312C32303936363734342C32303937303135332C32303937323639302C32303937353833302C32303937383939312C32303937393632302C32303938353736372C),
 (11,'HP1BP3.eApr07','chr1','-',20941756,20985747,20943876,20972584,12,0x32303934313735362C32303934343632322C32303934363632332C32303934383830322C32303935363234352C32303936343435362C32303936363636332C32303937303030392C32303937323533302C32303937383839312C32303937393432342C32303938353732382C,0x32303934343137312C32303934343733362C32303934363733352C32303934383936322C32303935363333362C32303936343631312C32303936363734342C32303937303135332C32303937353833302C32303937383939312C32303937393632302C32303938353734372C),
 (11,'HP1BP3.aApr07','chr1','-',20941758,20985728,20943876,20979520,14,0x32303934313735382C32303934333832332C32303934343632322C32303934363632332C32303934383830322C32303935363234352C32303936343435362C32303936363636332C32303937303030392C32303937323533302C32303937353637362C32303937383839312C32303937393432342C32303938353236352C,0x32303934323235342C32303934343137312C32303934343733362C32303934363733352C32303934383936322C32303935363333362C32303936343631312C32303936363734342C32303937303135332C32303937323639302C32303937353833302C32303937383939312C32303937393632302C32303938353732382C),
 (11,'HP1BP3.cApr07','chr1','-',20941765,20985742,20943876,20978973,13,0x32303934313736352C32303934343632322C32303934363632332C32303934383830322C32303935363234352C32303936343435362C32303936363636332C32303937303030392C32303937323533302C32303937353637362C32303937383839312C32303937393433342C32303938353236352C,0x32303934343137312C32303934343733362C32303934363733352C32303934383936322C32303935363333362C32303936343631312C32303936363734342C32303937303135332C32303937323639302C32303937353833302C32303937383939312C32303937393632302C32303938353734322C),
 (11,'HP1BP3.hApr07','chr1','-',20942209,20986374,20949016,20979520,14,0x32303934323230392C32303934333832332C32303934343632322C32303934363632332C32303934383830322C32303935363234352C32303936343435362C32303936363636332C32303937303030392C32303937323533302C32303937353637362C32303937383839312C32303937393432342C32303938363237342C,0x32303934323235342C32303934343137312C32303934343733362C32303934363733352C32303934393035352C32303935363333362C32303936343631312C32303936363734342C32303937303135332C32303937323639302C32303937353833302C32303937383939312C32303937393632302C32303938363337342C),
 (11,'HP1BP3.fApr07','chr1','-',20946647,20986387,20946649,20986385,9,0x32303934363634372C32303934383830322C32303935363234352C32303936343435362C32303937303030392C32303937323533302C32303937353637362C32303937383839312C32303938363237342C,0x32303934363733352C32303934383936322C32303935363333362C32303936343631312C32303937303135332C32303937323639302C32303937353833302C32303937383938382C32303938363338372C),
 (11,'HP1BP3.mApr07','chr1','-',20946692,20986368,20946692,20970078,10,0x32303934363639322C32303934383834362C32303935363234352C32303936343435362C32303936363636332C32303937303030392C32303937323532362C32303937353637362C32303937383839312C32303938363237342C,0x32303934363733352C32303934383936322C32303935363333362C32303936343631312C32303936363734342C32303937303135332C32303937323639302C32303937353833302C32303937383939312C32303938363336382C),
 (11,'HP1BP3.lApr07','chr1','-',20948902,20985742,20970094,20979520,10,0x32303934383930322C32303935363234352C32303936343435362C32303936363636332C32303937303030392C32303937323532362C32303937353637362C32303937383839312C32303937393432342C32303938353732382C,0x32303934393035352C32303935363333362C32303936343631312C32303936363734342C32303937303135332C32303937323639302C32303937353833302C32303937383938382C32303937393632302C32303938353734322C),
 (11,'HP1BP3.gApr07','chr1','-',20953137,20986352,20954430,20979520,10,0x32303935333133372C32303935363234352C32303936343435362C32303936363636332C32303937303030392C32303937323533302C32303937353637362C32303937383839312C32303937393432342C32303938363237342C,0x32303935343438342C32303935363333362C32303936343631312C32303936363734342C32303937303135332C32303937323639302C32303937353833302C32303937383938382C32303937393632302C32303938363335322C),
 (11,'HP1BP3.dApr07','chr1','-',20953137,20986405,20955993,20986403,8,0x32303935333133372C32303936343435362C32303936363636332C32303937303030392C32303937323533302C32303937353637362C32303937383839312C32303938363237342C,0x32303935363333362C32303936343631312C32303936363734342C32303937303135332C32303937323639302C32303937353833302C32303937383939312C32303938363430352C),
 (11,'HP1BP3.kApr07','chr1','-',20953171,20986407,20970094,20979520,10,0x32303935333137312C32303935363234352C32303936343435362C32303936363636332C32303937303030392C32303937323532362C32303937353637362C32303937383839312C32303937393432342C32303938363237342C,0x32303935343438342C32303935363333362C32303936343631312C32303936363734342C32303937303135332C32303937323639302C32303937353833302C32303937383939312C32303937393632302C32303938363430372C),
 (11,'HP1BP3.nApr07','chr1','-',20958383,20985726,20958384,20979520,6,0x32303935383338332C32303937323631342C32303937353637362C32303937383839312C32303937393432342C32303938353333322C,0x32303935383530312C32303937323639302C32303937353833302C32303937383939312C32303937393632302C32303938353732362C),
 (11,'HP1BP3.iApr07','chr1','-',20964607,20985747,20964608,20978973,7,0x32303936343630372C32303936363636332C32303937303030392C32303937323533302C32303937353637362C32303937383839312C32303938353732382C,0x32303936343631312C32303936363734342C32303937303135332C32303937323639302C32303937353833302C32303937383939312C32303938353734372C),
 (11,'HP1BP3.jApr07','chr1','-',20966663,20985742,20966663,20978973,6,0x32303936363636332C32303937303030392C32303937323533302C32303937353637362C32303937383839312C32303938353732382C,0x32303936363734342C32303937303135332C32303937323639302C32303937353833302C32303937383938382C32303938353734322C),
 (11,'LDLRAD2.cApr07','chr1','+',21932014,22022327,0,0,6,0x32313933323031342C32313934323839302C32313937393532302C32313939393633322C32323031313432392C32323032313738362C,0x32313933323137302C32313934323937362C32313937393537352C32313939393831372C32323031313439372C32323032323332372C),
 (11,'LDLRAD2.aApr07','chr1','+',22011345,22024301,22011531,22021295,5,0x32323031313334352C32323031333437372C32323031353032322C32323032303532392C32323032313238312C,0x32323031313631362C32323031333930332C32323031353135342C32323032303639312C32323032343330312C),
 (11,'EPHB2.bApr07','chr1','+',22909843,23114410,22909843,23112650,16,0x32323930393834332C32323938303530302C32323938333437312C32333036323131362C32333036333935362C32333038313433382C32333039313936332C32333039343535312C32333039353439332C32333130353036362C32333130353738392C32333130373033322C32333130383130312C32333130393436312C32333131313532332C32333131323534312C,0x32323931303132332C32323938303536352C32323938343135362C32333036323237322C32333036343239322C32333038313536332C32333039323132362C32333039343636302C32333039353535382C32333130353138392C32333130363033372C32333130373234382C32333130383235312C32333130393635352C32333131313637392C32333131343431302C),
 (11,'EPHB2.cApr07','chr1','+',22909917,23114410,22909918,23112650,16,0x32323930393931372C32323938303530302C32323938333437312C32333036323131362C32333036333935362C32333038313433382C32333039313936332C32333039343535312C32333039353439302C32333130353036362C32333130353738392C32333130373033322C32333130383130312C32333130393436312C32333131313532332C32333131323534312C,0x32323931303132332C32323938303536352C32323938343135362C32333036323237322C32333036343239322C32333038313536332C32333039323132362C32333039343636302C32333039353535382C32333130353138392C32333130363033372C32333130373234382C32333130383235312C32333130393635352C32333131313637392C32333131343431302C),
 (11,'EPHB2.eApr07','chr1','+',22909918,23090346,22909918,23090229,7,0x32323930393931382C32323938303530302C32323938333437312C32333036323131362C32333036333935362C32333038313433382C32333039303230382C,0x32323931303132332C32323938303536352C32323938343135362C32333036323237322C32333036343239322C32333038313536332C32333039303334362C),
 (11,'EPHB2.aApr07','chr1','+',22910044,23113670,22910044,23112950,17,0x32323931303034342C32323938303530302C32323938333437312C32333036323131362C32333036333935362C32333038313433382C32333039313936332C32333039343535312C32333039353439332C32333130353036362C32333130353738392C32333130373033322C32333130383130312C32333130393436312C32333131313532332C32333131323534312C32333131323733372C,0x32323931303132332C32323938303536352C32323938343135362C32333036323237322C32333036343239322C32333038313536332C32333039323132362C32333039343636302C32333039353535382C32333130353138392C32333130363033372C32333130373234382C32333130383235312C32333130393635352C32333131313637392C32333131323634342C32333131333637302C),
 (11,'EPHB2.dApr07','chr1','+',22974257,23112832,22974281,23112650,16,0x32323937343235372C32323938303530302C32323938333437312C32333036323131362C32333036333935362C32333038313433382C32333039313936332C32333039343535312C32333039353439332C32333130353036362C32333130353738392C32333130373033322C32333130383130312C32333130393436312C32333131313532332C32333131323534312C,0x32323937343332342C32323938303536352C32323938343135362C32333036323237322C32333036343239322C32333038313536332C32333039323132362C32333039343636302C32333039353535382C32333130353138392C32333130363033372C32333130373234382C32333130383235312C32333130393635352C32333131313637392C32333131323833322C),
 (11,'EPHB2.fApr07','chr1','+',22999319,23095541,23062259,23095539,7,0x32323939393331392C32333036323131362C32333036333935362C32333038313433382C32333039313936332C32333039343535312C32333039353439332C,0x32323939393337312C32333036323237322C32333036343239322C32333038313536332C32333039323132362C32333039343636302C32333039353534312C),
 (11,'EPHB2.iApr07','chr1','+',23064242,23081914,23064243,23081626,2,0x32333036343234322C32333038313433382C,0x32333036343239322C32333038313931342C),
 (11,'CNR2.bApr07','chr1','-',24072571,24158136,24073611,24074694,3,0x32343037323537312C32343134383530322C32343135373939392C,0x32343037343733392C32343134383537392C32343135383133362C),
 (12,'rysabo.bApr07','chr1','+',27257546,27263013,27257567,27262925,3,0x32373235373534362C32373235393039312C32373236323638392C,0x32373235373630302C32373235393135382C32373236333031332C),
 (12,'SFRS4.eApr07','chr1','-',29346836,29373446,29347508,29354003,8,0x32393334363833362C32393334393230312C32393335333739342C32393335383437322C32393336343938382C32393336353832372C32393336373630312C32393337333332392C,0x32393334383332352C32393334393239312C32393335343030392C32393335393631362C32393336353136332C32393336353936352C32393337323539332C32393337333434362C),
 (12,'SFRS4.aApr07','chr1','-',29346857,29381092,29347508,29380851,6,0x32393334363835372C32393334393230312C32393335333739342C32393335383437322C32393335393437332C32393338303734342C,0x32393334383332352C32393334393239312C32393335343030392C32393335383538352C32393335393631362C32393338313039322C),
 (12,'SFRS4.cApr07','chr1','-',29346865,29380975,29347508,29380851,5,0x32393334363836352C32393335333739342C32393335383437322C32393335393437332C32393338303734342C,0x32393334383332352C32393335343030392C32393335383538352C32393335393631362C32393338303937352C),
 (12,'SFRS4.dApr07','chr1','-',29346898,29381095,29347508,29354003,10,0x32393334363839382C32393334393230312C32393335333739342C32393335383437322C32393335383936322C32393335393437332C32393336343938382C32393336353832372C32393336373630312C32393338303734342C,0x32393334383332352C32393334393239312C32393335343030392C32393335383538352C32393335393135372C32393335393631362C32393336353136332C32393336363031312C32393336373733372C32393338313039352C),
 (12,'SFRS4.bApr07','chr1','-',29346908,29380957,29347508,29380802,6,0x32393334363930382C32393334393230312C32393335333739342C32393335383437322C32393335393437332C32393338303736312C,0x32393334383332352C32393334393239312C32393335343030392C32393335383538352C32393335393631362C32393338303935372C),
 (12,'SFRS4.iApr07','chr1','-',29349201,29380988,29349203,29354003,4,0x32393334393230312C32393335333739342C32393335383437322C32393338303734342C,0x32393334393239312C32393335343030392C32393335383538352C32393338303938382C),
 (12,'SFRS4.jApr07','chr1','-',29358985,29380996,29359116,29380851,3,0x32393335383938352C32393335393437332C32393338303734342C,0x32393335393135372C32393335393631362C32393338303939362C),
 (12,'SFRS4.hApr07','chr1','-',29359268,29380996,29359411,29380851,2,0x32393335393236382C32393338303734342C,0x32393335393631362C32393338303939362C),
 (12,'FAM77C.aApr07','chr1','-',31424598,31485375,31427136,31484981,7,0x33313432343539382C33313432373239332C33313432373936332C33313432393235302C33313433303638302C33313433333438332C33313438343932372C,0x33313432373134362C33313432373337352C33313432383032342C33313432393434382C33313433303736312C33313433333632312C33313438353337352C),
 (12,'LCK.dApr07','chr1','+',32489427,32524355,32512517,32523904,13,0x33323438393432372C33323531323531322C33323531323932342C33323531333138302C33323531333530382C33323531333735362C33323531343130312C33323531343532342C33323531343739342C33323531373835382C33323531383032382C33323531383236362C33323532333730312C,0x33323438393535392C33323531323632322C33323531333030362C33323531333237312C33323531333630372C33323531333836302C33323531343235312C33323531343637372C33323531343937342C33323531373933352C33323531383138322C33323531383339382C33323532343335352C),
 (12,'LCK.bApr07','chr1','+',32489428,32524352,32512517,32523904,11,0x33323438393432382C33323531323531322C33323531323932342C33323531333530382C33323531333735362C33323531343130312C33323531343739342C33323531373835382C33323531383032382C33323531383236362C33323532333730312C,0x33323438393535392C33323531323632322C33323531333237312C33323531333630372C33323531333836302C33323531343235312C33323531343937342C33323531373933352C33323531383138322C33323531383339382C33323532343335322C),
 (12,'LCK.jApr07','chr1','+',32489432,32518280,32513542,32518010,11,0x33323438393433322C33323531323531322C33323531323932342C33323531333530382C33323531333735362C33323531343130312C33323531343532342C33323531343739342C33323531373835382C33323531383030312C33323531383236362C,0x33323438393535392C33323531323632322C33323531333030362C33323531333630372C33323531333836302C33323531343235312C33323531343637372C33323531343937342C33323531373933352C33323531383138322C33323531383238302C),
 (12,'LCK.tApr07','chr1','+',32489454,32512887,32512517,32512718,2,0x33323438393435342C33323531323531322C,0x33323438393535392C33323531323838372C),
 (12,'LCK.oApr07','chr1','+',32489454,32513436,32512517,32513275,3,0x33323438393435342C33323531323531322C33323531323932342C,0x33323438393535392C33323531323632322C33323531333433362C),
 (12,'LCK.gApr07','chr1','+',32489462,32518097,32489462,32518097,10,0x33323438393436322C33323531323531322C33323531323932342C33323531333138302C33323531333530382C33323531333735362C33323531343130312C33323531343739342C33323531373835382C33323531383032382C,0x33323438393535392C33323531323632322C33323531333030362C33323531333237312C33323531333630372C33323531333836302C33323531343235312C33323531343937342C33323531373933352C33323531383039372C),
 (12,'LCK.sApr07','chr1','+',32489483,32513607,32512517,32513275,4,0x33323438393438332C33323531323531322C33323531323932342C33323531333138302C,0x33323438393535392C33323531323632322C33323531333030362C33323531333630372C),
 (12,'LCK.pApr07','chr1','+',32489487,32513705,32512517,32513611,5,0x33323438393438372C33323531323531322C33323531323932342C33323531333138302C33323531333530382C,0x33323438393535392C33323531323632322C33323531333030362C33323531333237312C33323531333730352C),
 (12,'LCK.fApr07','chr1','+',32489505,32524348,32489507,32517986,12,0x33323438393530352C33323531323531322C33323531323932342C33323531333138302C33323531333530382C33323531333735362C33323531343130312C33323531343532342C33323531343739342C33323531373835382C33323531383236362C33323532333730312C,0x33323438393535392C33323531323632322C33323531333030362C33323531333237312C33323531333630372C33323531333836302C33323531343235312C33323531343637372C33323531343937342C33323531383138322C33323531383339382C33323532343334382C),
 (13,'ZMYM4.aApr07','chr1','+',35506894,35660325,35507234,35657865,30,0x33353530363839342C33353536333534372C33353539373131322C33353539393338312C33353539393830362C33353630383231362C33353630383535392C33353631393434362C33353631393733332C33353632333632392C33353632343236312C33353632353139302C33353632353634312C33353632373039372C33353632383133352C33353633303339392C33353633303833342C33353633313738322C33353633343733392C33353633353536342C33353633363630302C33353633373035312C33353633373636392C33353634333231302C33353634333536302C33353634363139352C33353635323135392C33353635333635332C33353635363633302C33353635373635372C,0x33353530373237332C33353536333539332C33353539373633342C33353539393434332C33353539393937372C33353630383330312C33353630383831352C33353631393632312C33353631393934362C33353632333738302C33353632343337372C33353632353436362C33353632353739322C33353632373237302C33353632383238362C33353633303534302C33353633303837322C33353633313932372C33353633343835382C33353633353733332C33353633363635342C33353633373233312C33353633373736342C33353634333338322C33353634333635362C33353634363334372C33353635323237312C33353635333930322C33353635363736302C33353636303332352C),
 (13,'ZMYM4.cApr07','chr1','+',35507155,35660131,35608606,35657865,27,0x33353530373135352C33353536333534372C33353630383231362C33353630383535392C33353631393434362C33353631393733332C33353632333632392C33353632343236312C33353632353139302C33353632353634312C33353632373039372C33353632383133352C33353633303339392C33353633303833342C33353633313738322C33353633343733392C33353633353536342C33353633363630302C33353633373035312C33353633373636392C33353634333231302C33353634333536302C33353634363139352C33353635323135392C33353635333635332C33353635363633302C33353635373635372C,0x33353530373237332C33353536333539332C33353630383330312C33353630383831352C33353631393632312C33353631393934362C33353632333738302C33353632343337372C33353632353436362C33353632353739322C33353632373237302C33353632383238362C33353633303534302C33353633303837322C33353633313932372C33353633343835382C33353633353733332C33353633363635342C33353633373233312C33353633373736342C33353634333338322C33353634333635362C33353634363334372C33353635323237312C33353635333930322C33353635363736302C33353636303133312C),
 (13,'ZMYM4.bApr07','chr1','+',35507210,35658679,35597123,35657865,31,0x33353530373231302C33353533343131342C33353536333534372C33353539373131322C33353539393338312C33353539393830362C33353630383231362C33353630383535392C33353631393434362C33353631393733332C33353632333632392C33353632343236312C33353632353139302C33353632353634312C33353632373039372C33353632383133352C33353633303339392C33353633303833342C33353633313738322C33353633343733392C33353633353536342C33353633363630302C33353633373035312C33353633373636392C33353634333231302C33353634333536302C33353634363139352C33353635323135392C33353635333635332C33353635363633302C33353635373635372C,0x33353530373237332C33353533343137362C33353536333539332C33353539373633342C33353539393434332C33353539393937372C33353630383330312C33353630383831352C33353631393632312C33353631393934362C33353632333738302C33353632343337372C33353632353436362C33353632353739322C33353632373237302C33353632383238362C33353633303534302C33353633303837322C33353633313932372C33353633343835382C33353633353733332C33353633363635342C33353633373233312C33353633373736342C33353634333338322C33353634333635362C33353634363334372C33353635323237312C33353635333930322C33353635363736302C33353635383637392C),
 (13,'ZMYM4.iApr07','chr1','+',35630867,35659645,35630869,35635254,6,0x33353633303836372C33353633313738322C33353633343733392C33353633353233392C33353633353536342C33353635393437302C,0x33353633303837322C33353633313932372C33353633343835382C33353633353331312C33353633353635302C33353635393634352C),
 (13,'MRPS15.aApr07','chr1','-',36693509,36703384,36693975,36702679,8,0x33363639333530392C33363639343337342C33363639363131302C33363639383837392C33363639393435312C33363730303237352C33363730313939332C33363730323333332C,0x33363639343131332C33363639343536362C33363639363136392C33363639383936342C33363639393530302C33363730303335312C33363730323033382C33363730333338342C),
 (13,'MRPS15.dApr07','chr1','-',36693958,36702381,36694538,36702379,7,0x33363639333935382C33363639343337342C33363639363131302C33363639393435312C33363730303237352C33363730313939332C33363730323333332C,0x33363639343131332C33363639343536362C33363639363136392C33363639393530302C33363730303335312C33363730323033382C33363730323338312C),
 (13,'MRPS15.fApr07','chr1','-',36693959,36702532,36693975,36694539,4,0x33363639333935392C33363639343337342C33363639363131302C33363730323436392C,0x33363639343131332C33363639343536362C33363639373331342C33363730323533322C),
 (13,'MRPS15.cApr07','chr1','-',36693960,36702532,36698832,36702463,6,0x33363639333936302C33363639343337342C33363639393435312C33363730303237352C33363730313939332C33363730323333332C,0x33363639343131332C33363639383936342C33363639393530302C33363730303335312C33363730323033382C33363730323533322C),
 (13,'MRPS15.bApr07','chr1','-',36694277,36702532,36694278,36702463,8,0x33363639343237372C33363639343435392C33363639363131302C33363639383837392C33363639393435312C33363730303237352C33363730313939332C33363730323333332C,0x33363639343238352C33363639343536362C33363639363136392C33363639383936342C33363639393530302C33363730303335312C33363730323033382C33363730323533322C),
 (13,'MRPS15.hApr07','chr1','-',36694464,36702565,36694464,36699463,6,0x33363639343436342C33363639363131302C33363639383837392C33363639393435312C33363730313939332C33363730323333332C,0x33363639343536362C33363639363136392C33363639383936342C33363639393530302C33363730323033382C33363730323536352C),
 (13,'MRPS15.gApr07','chr1','-',36694525,36702469,36698951,36702469,6,0x33363639343532352C33363639363131302C33363639383837392C33363730303237352C33363730313939332C33363730323333332C,0x33363639343536362C33363639363136392C33363639383936342C33363730303335312C33363730323033382C33363730323436392C),
 (13,'MRPS15.iApr07','chr1','-',36698897,36702466,0,0,5,0x33363639383839372C33363639393435312C33363730303237352C33363730313738312C33363730323333332C,0x33363639383936342C33363639393530302C33363730303335312C33363730323033382C33363730323436362C),
 (13,'C1orf149.hApr07','chr1','-',37716895,37752941,37716911,37752934,6,0x33373731363839352C33373733393939312C33373734373436352C33373734373634322C33373735313631302C33373735323834342C,0x33373731363931352C33373734303138342C33373734373531312C33373734373733302C33373735313732362C33373735323934312C),
 (13,'C1orf149.aApr07','chr1','-',37730760,37752990,37732286,37752934,8,0x33373733303736302C33373733343037322C33373733343839342C33373733393939312C33373734373436352C33373734373634322C33373735313631302C33373735323834342C,0x33373733323239352C33373733343130362C33373733343932342C33373734303138342C33373734373531312C33373734373733302C33373735313732362C33373735323939302C),
 (13,'C1orf149.cApr07','chr1','-',37731363,37753007,37732286,37752934,7,0x33373733313336332C33373733343037322C33373733393939312C33373734373436352C33373734373634322C33373735313631302C33373735323834342C,0x33373733323239352C33373733343130362C33373734303138342C33373734373531312C33373734373733302C33373735313732362C33373735333030372C),
 (13,'C1orf149.fApr07','chr1','-',37731365,37753245,37734779,37752934,8,0x33373733313336352C33373733343037322C33373733343733342C33373733393939312C33373734373436352C33373734373634322C33373735313631302C33373735323834342C,0x33373733323239352C33373733343130362C33373733343739322C33373734303138342C33373734373531312C33373734373733302C33373735313732362C33373735333234352C),
 (13,'C1orf149.dApr07','chr1','-',37731366,37752941,37734779,37752934,9,0x33373733313336362C33373733343037322C33373733343733342C33373733343839342C33373733393939312C33373734373436352C33373734373634322C33373735313631302C33373735323834342C,0x33373733323239352C33373733343130362C33373733343739322C33373733343932342C33373734303138342C33373734373531312C33373734373733302C33373735313732362C33373735323934312C),
 (13,'C1orf149.iApr07','chr1','-',37731495,37752457,37732286,37751750,6,0x33373733313439352C33373733343037322C33373733393939312C33373734373436352C33373734373634322C33373735313631302C,0x33373733323239352C33373733343130362C33373734303138342C33373734373531312C33373734373733302C33373735323435372C),
 (13,'C1orf149.bApr07','chr1','-',37731817,37752951,37731956,37752934,6,0x33373733313831372C33373733393939312C33373734373436352C33373734373634322C33373735313631302C33373735323834342C,0x33373733323030322C33373734303138342C33373734373531312C33373734373733302C33373735313732362C33373735323935312C),
 (13,'C1orf149.kApr07','chr1','-',37732131,37752860,37732286,37751660,8,0x33373733323133312C33373733343037322C33373733343839342C33373733393939312C33373734373436352C33373734373634322C33373735313631302C33373735323730342C,0x33373733323239352C33373733343130362C33373733343932342C33373734303138342C33373734373531312C33373734373733302C33373735313732362C33373735323836302C),
 (13,'C1orf149.jApr07','chr1','-',37739342,37752430,37739954,37752428,5,0x33373733393334322C33373734373436352C33373734373634322C33373735313631302C33373735323339382C,0x33373734303138342C33373734373531312C33373734373733302C33373735313732362C33373735323433302C),
 (13,'C1orf149.eApr07','chr1','-',37739456,37752941,37739456,37752934,6,0x33373733393435362C33373733393939312C33373734373436352C33373734373634322C33373735313631302C33373735323834342C,0x33373733393437382C33373734303138342C33373734373531312C33373734373733302C33373735313732362C33373735323934312C),
 (13,'C1orf149.gApr07','chr1','-',37740070,37752967,37740073,37752934,6,0x33373734303037302C33373734333332302C33373734373436352C33373734373634322C33373735313631302C33373735323834342C,0x33373734303138342C33373734333430392C33373734373531312C33373734373733302C33373735313732362C33373735323936372C),
 (13,'RIMS3.bApr07','chr1','-',40856519,40903971,40864775,40880184,9,0x34303835363531392C34303835383039372C34303836373036382C34303836373532392C34303837313332372C34303837343137342C34303837393936372C34303838353932362C34303930333635322C,0x34303835373036312C34303836343938382C34303836373230382C34303836373633312C34303837313434302C34303837343331362C34303838303231352C34303838363130312C34303930333937312C),
 (13,'RIMS3.aApr07','chr1','-',40864478,40903704,40864775,40880184,8,0x34303836343437382C34303836373036382C34303836373532392C34303837313332372C34303837343137342C34303837393936372C34303838353932362C34303930333635322C,0x34303836343938382C34303836373230382C34303836373633312C34303837313434302C34303837343331362C34303838303231352C34303838363032312C34303930333730342C),
 (14,'LEPRE1.gApr07','chr1','-',42984592,43005278,42984954,42993199,15,0x34323938343539322C34323938353532392C34323938353938302C34323938363435372C34323938383434332C34323939303533312C34323939303739342C34323939333132362C34323939333830352C34323939343635382C34323939363034302C34323939373130392C34323939373435382C34333030303538302C34333030343736342C,0x34323938353131302C34323938353637302C34323938363035362C34323938363537352C34323938383539342C34323939303632372C34323939303932322C34323939333437352C34323939333839352C34323939343731332C34323939363138302C34323939373234312C34323939373634382C34333030303733332C34333030353237382C),
 (14,'LEPRE1.cApr07','chr1','-',42984630,43005289,42985090,43005229,15,0x34323938343633302C34323938353531302C34323938353938302C34323938363435372C34323938383434332C34323939303533312C34323939303739342C34323939333132362C34323939333432322C34323939333830352C34323939363034302C34323939373130392C34323939373435382C34333030303538302C34333030343736342C,0x34323938353131302C34323938353637302C34323938363035362C34323938363537352C34323938383539342C34323939303632372C34323939303932322C34323939333234382C34323939333437352C34323939333839352C34323939363138302C34323939373234312C34323939373634382C34333030303733332C34333030353238392C),
 (14,'LEPRE1.iApr07','chr1','-',42984631,42993467,42986550,42993466,9,0x34323938343633312C34323938363032342C34323938363435372C34323938383434332C34323938393839382C34323939303533312C34323939303739342C34323939333132362C34323939333432322C,0x34323938343938362C34323938363035362C34323938363537352C34323938383539342C34323938393939382C34323939303632372C34323939303932322C34323939333234382C34323939333436372C),
 (14,'LEPRE1.aApr07','chr1','-',42984631,43005269,42985169,43005229,14,0x34323938343633312C34323938353938302C34323938363435372C34323938383434332C34323939303533312C34323939303739342C34323939333132362C34323939333432322C34323939333830352C34323939363034302C34323939373130392C34323939373435382C34333030303538302C34333030343736342C,0x34323938353637302C34323938363035362C34323938363537352C34323938383539342C34323939303632372C34323939303932322C34323939333234382C34323939333437352C34323939333839352C34323939363138302C34323939373234312C34323939373634382C34333030303733332C34333030353236392C),
 (14,'LEPRE1.dApr07','chr1','-',42984632,42993245,42984647,42993244,5,0x34323938343633322C34323938393939382C34323939303533312C34323939303739342C34323939333132362C,0x34323938343838322C34323939303039322C34323939303632372C34323939303932322C34323939333234352C),
 (14,'LEPRE1.fApr07','chr1','-',42984632,43005246,42984954,42993199,14,0x34323938343633322C34323938353532392C34323938353938302C34323938363435372C34323938383434332C34323939303533312C34323939303739342C34323939333132362C34323939333830352C34323939363034302C34323939373130392C34323939373435382C34333030303538302C34333030343736342C,0x34323938353131302C34323938353637302C34323938363035362C34323938363537352C34323938383539342C34323939303632372C34323939303932322C34323939333437352C34323939333839352C34323939363138302C34323939373234312C34323939373635312C34333030303733332C34333030353234362C),
 (14,'LEPRE1.bApr07','chr1','-',42984632,43005486,42984954,43005229,15,0x34323938343633322C34323938353532392C34323938353938302C34323938363435372C34323938383434332C34323939303533312C34323939303739342C34323939333132362C34323939333432322C34323939333830352C34323939363034302C34323939373130392C34323939373435382C34333030303538302C34333030343736342C,0x34323938353131302C34323938353637302C34323938363035362C34323938363537352C34323938383539342C34323939303632372C34323939303932322C34323939333234382C34323939333437352C34323939333839352C34323939363138302C34323939373234312C34323939373634382C34333030303733332C34333030353438362C),
 (14,'LEPRE1.eApr07','chr1','-',42985593,43005234,42985600,43005229,12,0x34323938353539332C34323938353938302C34323938363435372C34323938383434332C34323939303533312C34323939303739342C34323939333132362C34323939333432322C34323939363034302C34323939373130392C34323939373435382C34333030343736342C,0x34323938353636362C34323938363035362C34323938363537352C34323938383539342C34323939303632372C34323939303932322C34323939333234382C34323939333437352C34323939363138302C34323939373234312C34323939373634382C34333030353233342C),
 (14,'LEPRE1.lApr07','chr1','-',42988043,42993194,42988321,42993193,4,0x34323938383034332C34323939303533312C34323939303739342C34323939333132362C,0x34323938383539342C34323939303632372C34323939303932322C34323939333139342C),
 (14,'ST3GAL3.vmApr07','chr1','+',43944080,44076505,43974520,44039631,6,0x34333934343038302C34333937343439302C34343033303335392C34343033393533392C34343035333134392C34343037363437372C,0x34333934343235342C34333937343633382C34343033303430372C34343033393739392C34343035333139322C34343037363530352C),
 (14,'ST3GAL3.tApr07','chr1','+',43945182,44168435,43974520,44137780,11,0x34333934353138322C34333937343439302C34343035333134392C34343037363437372C34343133323634312C34343133363439332C34343133373432362C34343133373736372C34343135383636322C34343135393034302C34343136383237372C,0x34333934353935312C34333937343633382C34343035333139322C34343037363537302C34343133323733362C34343133363535372C34343133373532322C34343133373938362C34343135383830392C34343135393138372C34343136383433352C),
 (14,'ST3GAL3.vhApr07','chr1','+',43945805,44117362,43974520,44117304,6,0x34333934353830352C34333937343439302C34343033303335392C34343035333134392C34343037363437372C34343131373238352C,0x34333934353935312C34333937343633382C34343033303430372C34343035333139322C34343037363537302C34343131373336322C),
 (14,'ST3GAL3.vfApr07','chr1','+',43945805,44169414,43974520,44096457,10,0x34333934353830352C34333937343439302C34343033303335392C34343035333134392C34343037363437372C34343039363339332C34343133323634312C34343133363439332C34343133373432362C34343136383339302C,0x34333934353935312C34333937343633382C34343033303430372C34343035333139322C34343037363537302C34343039363536372C34343133323733362C34343133363535372C34343133373532322C34343136393431342C),
 (14,'ST3GAL3.veApr07','chr1','+',43945805,44169418,43974520,44168461,6,0x34333934353830352C34333937343439302C34343035333134392C34343037363437372C34343133323634312C34343136383339302C,0x34333934353935312C34333937343633382C34343035333139322C34343037363537302C34343133323733362C34343136393431382C),
 (14,'ST3GAL3.vcApr07','chr1','+',43945805,44169418,43974520,44168461,7,0x34333934353830352C34333937343439302C34343033303335392C34343035333134392C34343037363437372C34343133323634312C34343136383339302C,0x34333934353935312C34333937343633382C34343033303430372C34343035333139322C34343037363537302C34343133323733362C34343136393431382C),
 (14,'ST3GAL3.vaApr07','chr1','+',43945805,44150288,44132660,44150134,12,0x34333934353830352C34333937343439302C34343033303335392C34343035333134392C34343037363437372C34343130383035302C34343133323634312C34343133363439332C34343133373432362C34343133373739392C34343134393432352C34343135303133312C,0x34333934353935312C34333937343633382C34343033303430372C34343035333139322C34343037363537302C34343130383131302C34343133323733362C34343133363535372C34343133373532322C34343133373938362C34343134393530322C34343135303238382C),
 (14,'ST3GAL3.uApr07','chr1','+',43945805,44169418,43974520,44168461,7,0x34333934353830352C34333937343439302C34343033303335392C34343035333134392C34343037363437372C34343133323634312C34343136383339302C,0x34333934353935312C34333937343638332C34343033303430372C34343035333139322C34343037363537302C34343133323733362C34343136393431382C),
 (14,'ST3GAL3.jApr07','chr1','+',43945805,44169418,43974520,44168480,10,0x34333934353830352C34333937343439302C34343033303335392C34343035333134392C34343037363437372C34343133323634312C34343133363439332C34343133373432362C34343133373739392C34343136383339302C,0x34333934353935312C34333937343633382C34343033303430372C34343035333139322C34343037363537302C34343133323733362C34343133363535372C34343133373532322C34343133373938362C34343136393431382C),
 (14,'ST3GAL3.fApr07','chr1','+',43945805,44169420,43974520,44168480,11,0x34333934353830352C34333937343439302C34343035333134392C34343037363437372C34343133323634312C34343133363439332C34343133373432362C34343133373739392C34343135383636322C34343135393034302C34343136383339302C,0x34333934353935312C34333937343633382C34343035333139322C34343037363537302C34343133323733362C34343133363535372C34343133373532322C34343133373938362C34343135383830392C34343135393138372C34343136393432302C),
 (14,'ST3GAL3.eApr07','chr1','+',43945805,44169418,43974520,44168480,12,0x34333934353830352C34333937343439302C34343033303335392C34343035333134392C34343037363437372C34343133323634312C34343133363439332C34343133373432362C34343133373739392C34343135383636322C34343135393034302C34343136383339302C,0x34333934353935312C34333937343633382C34343033303430372C34343035333139322C34343037363537302C34343133323733362C34343133363535372C34343133373532322C34343133373938362C34343135383830392C34343135393138372C34343136393431382C),
 (14,'ST3GAL3.dApr07','chr1','+',43945805,44169418,43974520,44168480,12,0x34333934353830352C34333937343439302C34343033303335392C34343035333134392C34343037363437372C34343133323634312C34343133363439332C34343133373432362C34343133373739392C34343135383636322C34343135393034302C34343136383339302C,0x34333934353935312C34333937343638332C34343033303430372C34343035333139322C34343037363537302C34343133323733362C34343133363535372C34343133373532322C34343133373938362C34343135383830392C34343135393138372C34343136393431382C),
 (14,'ST3GAL3.cApr07','chr1','+',43945805,44169418,43974520,44168480,12,0x34333934353830352C34333937343439302C34343035333134392C34343036323938392C34343037363437372C34343133323634312C34343133363439332C34343133373432362C34343133373739392C34343135383636322C34343135393034302C34343136383339302C,0x34333934353935312C34333937343633382C34343035333139322C34343036333135312C34343037363537302C34343133323733362C34343133363535372C34343133373532322C34343133373938362C34343135383830392C34343135393138372C34343136393431382C),
 (14,'ST3GAL3.bApr07','chr1','+',43945805,44169418,43974520,44168480,13,0x34333934353830352C34333937343439302C34343033303335392C34343035333134392C34343036323938392C34343037363437372C34343133323634312C34343133363439332C34343133373432362C34343133373739392C34343135383636322C34343135393034302C34343136383339302C,0x34333934353935312C34333937343633382C34343033303430372C34343035333139322C34343036333135312C34343037363537302C34343133323733362C34343133363535372C34343133373532322C34343133373938362C34343135383830392C34343135393138372C34343136393431382C),
 (14,'ST3GAL3.aApr07','chr1','+',43945805,44169418,43974520,44168480,13,0x34333934353830352C34333937343439302C34343033303335392C34343035333134392C34343036323938392C34343037363437372C34343133323634312C34343133363439332C34343133373432362C34343133373739392C34343135383636322C34343135393034302C34343136383339302C,0x34333934353935312C34333937343638332C34343033303430372C34343035333139322C34343036333135312C34343037363537302C34343133323733362C34343133363535372C34343133373532322C34343133373938362C34343135383830392C34343135393138372C34343136393431382C),
 (14,'ST3GAL3.rApr07','chr1','+',43945814,44168480,43974520,44137526,9,0x34333934353831342C34333937343439302C34343033303335392C34343035333134392C34343037363437372C34343133323634312C34343133363439332C34343133373432362C34343136383339302C,0x34333934353935312C34333937343633382C34343033303430372C34343035333139322C34343037363537302C34343133323733362C34343133363535372C34343133373534382C34343136383438302C),
 (14,'ST3GAL3.voApr07','chr1','+',43945815,44169396,0,0,9,0x34333934353831352C34333937343439302C34343033303335392C34343033393533392C34343035333134392C34343036333039302C34343036393931332C34343037363437372C34343136383435352C,0x34333934353935312C34333937343633382C34343033303430372C34343033393830332C34343035333139322C34343036333135312C34343037303035332C34343037363532302C34343136393339362C),
 (14,'ST3GAL3.vjApr07','chr1','+',43945894,44076570,43974520,44039631,6,0x34333934353839342C34333937343439302C34343033303335392C34343033393533392C34343035333134392C34343037363437372C,0x34333934353935312C34333937343638332C34343033303430372C34343033393830332C34343035333139322C34343037363537302C),
 (14,'ST3GAL3.gApr07','chr1','+',43974490,44169404,43974520,44168480,11,0x34333937343439302C34343033303335392C34343035333134392C34343037363437372C34343133323634312C34343133363439332C34343133373432362C34343133373739392C34343135383735322C34343135393034302C34343136383339302C,0x34333937343633382C34343033303430372C34343035333139322C34343037363537302C34343133323733362C34343133363535372C34343133373532322C34343133373938362C34343135383830392C34343135393138372C34343136393430342C),
 (14,'ST3GAL3.viApr07','chr1','+',43974520,44168480,43974520,44168442,4,0x34333937343532302C34343035333134392C34343037363437372C34343136383339302C,0x34333937343633382C34343035333139322C34343037363537302C34343136383438302C),
 (14,'ST3GAL3.vdApr07','chr1','+',43974520,44168480,43974520,44158721,8,0x34333937343532302C34343033303335392C34343035333134392C34343037363437372C34343133323634312C34343135383636322C34343135393034302C34343136383339302C,0x34333937343633382C34343033303430372C34343035333139322C34343037363537302C34343133323733362C34343135383830392C34343135393138372C34343136383438302C),
 (14,'ST3GAL3.vgApr07','chr1','+',43974520,44168480,43974520,44117639,10,0x34333937343532302C34343033303335392C34343035333134392C34343037363437372C34343131373539332C34343133323634312C34343133363439332C34343133373432362C34343133373739392C34343136383339302C,0x34333937343633382C34343033303430372C34343035333139322C34343037363537302C34343131373736362C34343133323733362C34343133363535372C34343133373532322C34343133373938362C34343136383438302C),
 (14,'ST3GAL3.sApr07','chr1','+',43974520,44168480,43974520,44137526,7,0x34333937343532302C34343035333134392C34343037363437372C34343133323634312C34343133363439332C34343133373432362C34343136383339302C,0x34333937343638332C34343035333139322C34343037363537302C34343133323733362C34343133363535372C34343133373534382C34343136383438302C),
 (14,'ST3GAL3.qApr07','chr1','+',43974520,44168480,43974520,44168442,7,0x34333937343532302C34343035333134392C34343037363437372C34343133323634312C34343133363439332C34343133373432362C34343136383339302C,0x34333937343633382C34343035333139322C34343037363537302C34343133323733362C34343133363535372C34343133373532322C34343136383438302C),
 (14,'ST3GAL3.pApr07','chr1','+',43974520,44168598,43974520,44137780,11,0x34333937343532302C34343033303335392C34343035333134392C34343037363437372C34343133323634312C34343133363439332C34343133373432362C34343133373736372C34343135383636322C34343135393034302C34343136383339302C,0x34333937343633382C34343033303430372C34343035333139322C34343037363537302C34343133323733362C34343133363535372C34343133373532322C34343133373938362C34343135383830392C34343135393138372C34343136383539382C),
 (14,'ST3GAL3.oApr07','chr1','+',43974520,44168480,43974520,44168442,7,0x34333937343532302C34343035333134392C34343037363437372C34343133323634312C34343133363439332C34343133373432362C34343136383339302C,0x34333937343638332C34343035333139322C34343037363537302C34343133323733362C34343133363535372C34343133373532322C34343136383438302C),
 (14,'ST3GAL3.vbApr07','chr1','+',43974520,44168480,44137881,44168480,8,0x34333937343532302C34343133323634312C34343133363439332C34343133373432362C34343133373736372C34343135383636322C34343135393034302C34343136383339302C,0x34333937343633382C34343133323733362C34343133363535372C34343133373532322C34343133373938362C34343135383830392C34343135393138372C34343136383438302C),
 (14,'ST3GAL3.mApr07','chr1','+',43974520,44168480,43974520,44159071,9,0x34333937343532302C34343035333134392C34343037363437372C34343133323634312C34343133363439332C34343133373432362C34343135383636322C34343135393034302C34343136383339302C,0x34333937343633382C34343035333139322C34343037363537302C34343133323733362C34343133363535372C34343133373532322C34343135383830392C34343135393138372C34343136383438302C),
 (14,'ST3GAL3.lApr07','chr1','+',43974520,44168480,43974520,44168480,7,0x34333937343532302C34343035333134392C34343133323634312C34343133363439332C34343133373432362C34343133373739392C34343136383339302C,0x34333937343633382C34343035333139322C34343133323733362C34343133363535372C34343133373532322C34343133373938362C34343136383438302C),
 (14,'ST3GAL3.kApr07','chr1','+',43974520,44168480,43974520,44168480,8,0x34333937343532302C34343035333134392C34343037363437372C34343133323634312C34343133363439332C34343133373432362C34343133373739392C34343136383339302C,0x34333937343633382C34343035333139322C34343037363537302C34343133323733362C34343133363535372C34343133373532322C34343133373938362C34343136383438302C),
 (14,'ST3GAL3.hApr07','chr1','+',43974520,44168480,43974522,44168480,9,0x34333937343532302C34343037363437372C34343133323634312C34343133363439332C34343133373432362C34343133373739392C34343135383636322C34343135393034302C34343136383339302C,0x34333937343633382C34343037363537302C34343133323733362C34343133363535372C34343133373532322C34343133373938362C34343135383830392C34343135393138372C34343136383438302C),
 (14,'ST3GAL3.iApr07','chr1','+',43974520,44168480,43974520,44168480,10,0x34333937343532302C34343033303335392C34343035333134392C34343133323634312C34343133363439332C34343133373432362C34343133373739392C34343135383636322C34343135393034302C34343136383339302C,0x34333937343633382C34343033303430372C34343035333139322C34343133323733362C34343133363535372C34343133373532322C34343133373938362C34343135383830392C34343135393138372C34343136383438302C),
 (14,'ST3GAL3.nApr07','chr1','+',44030364,44158809,44030364,44139052,9,0x34343033303336342C34343035333134392C34343037363437372C34343133323634312C34343133363439332C34343133373432362C34343133373739392C34343133393030372C34343135383636322C,0x34343033303430372C34343035333139322C34343037363537302C34343133323733362C34343133363535372C34343133373532322C34343133373938362C34343133393039322C34343135383830392C),
 (14,'EIF2B3.cApr07','chr1','-',45088183,45224840,45089258,45224838,12,0x34353038383138332C34353038383738302C34353131323933362C34353131333837362C34353131383037362C34353131393837302C34353133353631332C34353136343838362C34353137393736342C34353231363537332C34353231393237392C34353232343735312C,0x34353038383332302C34353038393236322C34353131333038352C34353131333935342C34353131383236372C34353131393939382C34353133353730332C34353136343939382C34353137393932342C34353231363731392C34353231393433362C34353232343834302C),
 (14,'EIF2B3.bApr07','chr1','-',45088724,45224869,45089209,45219427,12,0x34353038383732342C34353039353936322C34353131323933362C34353131333837362C34353131383037362C34353131393837302C34353133353631332C34353136343838362C34353137393736342C34353231363537332C34353231393237392C34353232343735312C,0x34353038393236322C34353039363036362C34353131333038352C34353131333935342C34353131383236372C34353131393939382C34353133353730332C34353136343939382C34353137393932342C34353231363731392C34353231393433362C34353232343836392C),
 (14,'MAST2.cApr07','chr1','+',46025245,46274370,46025376,46274325,6,0x34363032353234352C34363036323639312C34363036373639372C34363132303632322C34363135353539372C34363237333830312C,0x34363032353339312C34363036323833392C34363036373834302C34363132303635342C34363135353736382C34363237343337302C),
 (14,'MAST2.aApr07','chr1','+',46041871,46274490,46042154,46274325,29,0x34363034313837312C34363036323639312C34363036373639372C34363132303632322C34363139373634342C34363233353938322C34363234313036332C34363234343439392C34363234363535342C34363234383938382C34363235373835342C34363236303230382C34363236313136382C34363236313439312C34363236323033302C34363236333933352C34363236353938392C34363236373032362C34363236373732342C34363236383038392C34363236383338372C34363236383836352C34363236393236352C34363236393634392C34363237303433362C34363237303835342C34363237323036302C34363237323333312C34363237323739362C,0x34363034323333312C34363036323833392C34363036373834302C34363132303635342C34363139373733362C34363233363035382C34363234313134322C34363234343635342C34363234363633302C34363234393139382C34363235373935362C34363236303334312C34363236313233302C34363236313537372C34363236323233392C34363236343037342C34363236363132322C34363236373139322C34363236373832362C34363236383231322C34363236383439372C34363236393032302C34363236393534392C34363236393834342C34363237303636332C34363237303937372C34363237323139372C34363237323532352C34363237343439302C),
 (14,'MAST2.bApr07','chr1','+',46041897,46274375,46042154,46274325,29,0x34363034313839372C34363036323639312C34363036373639372C34363132303632322C34363139373634342C34363233353938322C34363234313036332C34363234343439392C34363234363535342C34363234383938382C34363235373835342C34363236303230382C34363236313136382C34363236313439312C34363236323033302C34363236333933352C34363236353938392C34363236373032362C34363236373732342C34363236383038392C34363236383338372C34363236383836352C34363236393236352C34363236393634392C34363237303433362C34363237303835342C34363237323036302C34363237323333342C34363237323739362C,0x34363034323333312C34363036323833392C34363036373834302C34363132303635342C34363139373733362C34363233363035382C34363234313134322C34363234343635342C34363234363633302C34363234393139382C34363235373935362C34363236303334312C34363236313233302C34363236313537372C34363236323233392C34363236343037342C34363236363132322C34363236373139322C34363236373832362C34363236383231322C34363236383439372C34363236393032302C34363236393534392C34363236393834342C34363237303636332C34363237303937372C34363237323139372C34363237323532352C34363237343337352C),
 (14,'MAST2.oApr07','chr1','+',46067732,46239477,46067789,46239242,5,0x34363036373733322C34363132303632322C34363139373634342C34363233353938322C34363233393231372C,0x34363036373834302C34363132303635342C34363139373733362C34363233363035382C34363233393437372C),
 (14,'MAST2.nApr07','chr1','+',46103335,46236051,46155637,46236050,6,0x34363130333333352C34363132303632322C34363133383133312C34363135353539372C34363139373634342C34363233353938322C,0x34363130333339382C34363132303635342C34363133383234372C34363135353739322C34363139373733362C34363233363035312C),
 (14,'MAST2.gApr07','chr1','+',46120628,46249368,46120628,46249225,7,0x34363132303632382C34363139373634342C34363233353938322C34363234313036332C34363234343439392C34363234363535342C34363234383938382C,0x34363132303635342C34363139373733362C34363233363035382C34363234313134322C34363234343635342C34363234363633302C34363234393336382C),
 (14,'CYP4X1.dApr07','chr1','+',47179087,47277969,47268266,47277795,8,0x34373137393038372C34373236383234382C34373236393639342C34373237313439392C34373237343036342C34373237343237352C34373237363931382C34373237373630302C,0x34373137393336372C34373236383339302C34373236393733392C34373237313632372C34373237343139322C34373237343433302C34373237373032352C34373237373936392C),
 (14,'LOC388630.bApr07','chr1','-',48231988,48234980,48231989,48234979,2,0x34383233313938382C34383233343934362C,0x34383233323835362C34383233343938302C),
 (15,'C1orf185.aApr07','chr1','+',51340487,51386340,51340493,51386031,5,0x35313334303438372C35313335303732332C35313335363932352C35313338333938332C35313338353732362C,0x35313334303530392C35313335303832392C35313335373036312C35313338343032302C35313338363334302C),
 (15,'ZFYVE9.aApr07','chr1','+',52380260,52584946,52471466,52584481,19,0x35323338303236302C35323435343632382C35323437313433302C35323437353734372C35323530323033322C35323530343931342C35323530363732322C35323531323732332C35323531363735312C35323531393932302C35323533313731322C35323533343135342C35323534323038302C35323537313032372C35323537323934372C35323537363033312C35323537383338352C35323538333032372C35323538343331392C,0x35323338303636332C35323435343733342C35323437313533362C35323437373835352C35323530323133322C35323530353039312C35323530363839322C35323531323834342C35323531363837342C35323532303037362C35323533313933372C35323533343233372C35323534323138352C35323537313137382C35323537333032382C35323537363139342C35323537383439312C35323538333230342C35323538343934362C),
 (15,'ZFYVE9.cApr07','chr1','+',52380633,52502307,52471466,52502143,5,0x35323338303633332C35323435343632382C35323437313433302C35323437353734372C35323530323033322C,0x35323338303636332C35323435343733342C35323437313533362C35323437373835352C35323530323330372C),
 (15,'ZFYVE9.bApr07','chr1','+',52380633,52584946,52471466,52584481,18,0x35323338303633332C35323435343632382C35323437313433302C35323437353734372C35323530323033322C35323530363732322C35323531323732332C35323531363735312C35323531393932302C35323533313731322C35323533343135342C35323534323038302C35323537313032372C35323537323934372C35323537363033312C35323537383338352C35323538333032372C35323538343331392C,0x35323338303636332C35323435343733342C35323437313533362C35323437373835352C35323530323133322C35323530363839322C35323531323834342C35323531363837342C35323532303037362C35323533313933372C35323533343233372C35323534323138352C35323537313137382C35323537333032382C35323537363139342C35323537383439312C35323538333230342C35323538343934362C),
 (15,'klarby.aApr07','chr1','+',53476838,53482852,0,0,3,0x35333437363833382C35333438303130362C35333438303639372C,0x35333437373630352C35333438303230352C35333438323835322C),
 (15,'SSBP3.aApr07','chr1','-',54463570,54644659,54465391,54644269,18,0x35343436333537302C35343436363531352C35343436363730392C35343436373030382C35343437373338392C35343437393136352C35343437393733342C35343438303432342C35343438313439352C35343438393837362C35343439303035342C35343439353338372C35343439363332392C35343531393639382C35343634303132312C35343634323833362C35343634333131382C35343634343231332C,0x35343436353432312C35343436363631372C35343436363733382C35343436373038372C35343437373436302C35343437393232302C35343437393737302C35343438303437332C35343438313536302C35343438393935332C35343439303132312C35343439353434372C35343439363431302C35343531393738382C35343634303230362C35343634323839382C35343634333139312C35343634343635392C),
 (15,'SSBP3.cApr07','chr1','-',54463693,54644680,54465391,54644269,17,0x35343436333639332C35343436363531352C35343436363730392C35343436373030382C35343437373338392C35343437393136352C35343437393733342C35343438303432342C35343438313439352C35343438393837362C35343439303035342C35343439353338372C35343531393639382C35343634303132312C35343634323833362C35343634333131382C35343634343231332C,0x35343436353432312C35343436363631372C35343436363733382C35343436373038372C35343437373436302C35343437393232302C35343437393737302C35343438303437332C35343438313536302C35343438393935332C35343439303132312C35343439353434372C35343531393738382C35343634303230362C35343634323839382C35343634333139312C35343634343638302C),
 (15,'SSBP3.eApr07','chr1','-',54464777,54595078,54465391,54519734,14,0x35343436343737372C35343436363531352C35343436363730392C35343436373030382C35343437373338392C35343437393136352C35343437393733342C35343438303432342C35343438313439352C35343438393837362C35343439303035342C35343439353338372C35343531393639382C35343539343637352C,0x35343436353432312C35343436363631372C35343436363733382C35343436373038372C35343437373436302C35343437393232302C35343437393737302C35343438303437332C35343438313536302C35343438393935332C35343439303132312C35343439353434372C35343531393738382C35343539353037382C),
 (15,'SSBP3.bApr07','chr1','-',54464782,54644567,54465391,54644269,17,0x35343436343738322C35343436363531352C35343436363730392C35343436373030382C35343437373338392C35343437393136352C35343437393733342C35343438303432342C35343438313439352C35343438393837362C35343439303035342C35343439363332392C35343531393639382C35343634303132312C35343634323833362C35343634333131382C35343634343231332C,0x35343436353432312C35343436363631372C35343436363733382C35343436373038372C35343437373436302C35343437393232302C35343437393737302C35343438303437332C35343438313536302C35343438393935332C35343439303132312C35343439363431302C35343531393738382C35343634303230362C35343634323839382C35343634333139312C35343634343536372C),
 (15,'SSBP3.hApr07','chr1','-',54464907,54643154,54464907,54643154,7,0x35343436343930372C35343439303035342C35343439353338372C35343531393639382C35343634303132312C35343634323833362C35343634333131382C,0x35343436343937382C35343439303132312C35343439353434372C35343531393738382C35343634303230362C35343634323839382C35343634333135342C),
 (15,'SSBP3.fApr07','chr1','-',54465079,54651725,54466606,54519734,16,0x35343436353037392C35343436363531352C35343436373030382C35343437373338392C35343437393136352C35343437393733342C35343438303432342C35343438313439352C35343438393837362C35343439303035342C35343439353338372C35343531393639382C35343634303132312C35343634323833362C35343634333131382C35343635313631362C,0x35343436353432312C35343436363631372C35343436373038372C35343437373436302C35343437393232302C35343437393737302C35343438303437332C35343438313536302C35343438393935332C35343439303132312C35343439353434372C35343531393738382C35343634303230362C35343634323839382C35343634333139312C35343635313732352C),
 (15,'SSBP3.dApr07','chr1','-',54465374,54563700,54465391,54563698,14,0x35343436353337342C35343436363531352C35343436363730392C35343436373030382C35343437373338392C35343437393136352C35343437393733342C35343438303432342C35343438313439352C35343438393837362C35343439303035342C35343439353338372C35343531393639382C35343536333632392C,0x35343436353432312C35343436363631372C35343436363733382C35343436373038372C35343437373436302C35343437393232302C35343437393737302C35343438303437332C35343438313536302C35343438393935332C35343439303132312C35343439353434372C35343531393738382C35343536333730302C),
 (15,'SSBP3.iApr07','chr1','-',54481449,54564732,54481491,54564604,6,0x35343438313434392C35343438393837362C35343439303035342C35343439353338372C35343531393639382C35343536343538362C,0x35343438313536302C35343438393935332C35343439303132312C35343439353434372C35343531393738382C35343536343733322C),
 (15,'SSBP3.jApr07','chr1','-',54481532,54574141,54493919,54519734,8,0x35343438313533322C35343438393837362C35343439303035342C35343439333835372C35343439353338372C35343439363332392C35343531393639382C35343537343035372C,0x35343438313536302C35343438393935332C35343439303132312C35343439333934362C35343439353434372C35343439363431302C35343531393738382C35343537343134312C),
 (15,'blupeebu.aApr07','chr1','+',54523665,54527274,54526845,54527226,2,0x35343532333636352C35343532343539392C,0x35343532333734332C35343532373237342C),
 (15,'DAB1.aApr07','chr1','-',57233038,58488799,57248955,57529290,17,0x35373233333033382C35373234383934302C35373234393430352C35373235333134332C35373236313739312C35373236343234312C35373330313134342C35373330373632302C35373330393238332C35373330393738322C35373331303534332C35373337343830332C35373338333535302C35373532393232332C35373838373835312C35383132323235382C35383438383439392C,0x35373233363338392C35373234393035312C35373234393533332C35373235333639322C35373236313930302C35373236343330342C35373330313230342C35373330373638362C35373330393332322C35373330393930322C35373331303637352C35373337343930322C35373338333639302C35373532393432362C35373838373932352C35383132323432322C35383438383739392C),
 (15,'DAB1.jApr07','chr1','-',57382259,58488772,0,0,6,0x35373338323235392C35373532393232332C35373838373835312C35383132323235382C35383230393034392C35383438383439392C,0x35373338333639302C35373532393432362C35373838373932352C35383132323432322C35383230393132352C35383438383737322C),
 (16,'FLJ10986.gApr07','chr1','+',59534896,60000988,59584529,59996249,14,0x35393533343839362C35393537383231372C35393538343530362C35393631373030382C35393639353232302C35393735303537302C35393739323338332C35393834363036322C35393836343234372C35393837363438372C35393839383437382C35393930353534322C35393939363139302C36303030303736322C,0x35393533353136372C35393537383332392C35393538343635382C35393631373039372C35393639353333362C35393735303639392C35393739323438372C35393834363137302C35393836343330392C35393837363633352C35393839383535332C35393930353636332C35393939363235322C36303030303938382C),
 (16,'FLJ10986.iApr07','chr1','+',59534973,60005935,59584529,59898491,11,0x35393533343937332C35393538343530362C35393631373030382C35393639353232302C35393735303537302C35393739323338332C35393834363036322C35393836343234372C35393839383437382C35393939363139302C36303030353434392C,0x35393533353136372C35393538343635382C35393631373039372C35393639353333362C35393735303639392C35393739323438372C35393834363137302C35393836343330392C35393839383535332C35393939363235322C36303030353933352C),
 (16,'FLJ10986.fApr07','chr1','+',59535213,60000975,59584529,60000844,15,0x35393533353231332C35393537383231372C35393538343530362C35393631373030382C35393639353232302C35393735303537302C35393739323338332C35393834363036322C35393836343234372C35393837363438372C35393839383437382C35393930353534322C35393931323239382C35393939363139302C36303030303736322C,0x35393533353431302C35393537383332392C35393538343635382C35393631373039372C35393639353333362C35393735303639392C35393739323438372C35393834363137302C35393836343330392C35393837363633352C35393839383535332C35393930353636332C35393931323339332C35393939363235322C36303030303937352C),
 (16,'FLJ10986.jApr07','chr1','+',59535244,59865114,59584529,59864313,9,0x35393533353234342C35393535393739352C35393538343530362C35393631373030382C35393639353232302C35393735303537302C35393739323338332C35393834363036322C35393836343234372C,0x35393533353431302C35393536303031302C35393538343635382C35393631373039372C35393639353333362C35393735303639392C35393739323438372C35393834363137302C35393836353131342C),
 (16,'FLJ10986.aApr07','chr1','+',59535244,60001245,59559809,60000844,17,0x35393533353234342C35393535393739352C35393537383231372C35393538343530362C35393631373030382C35393639353232302C35393735303537302C35393739323338332C35393834363036322C35393836343234372C35393837363438372C35393837393533392C35393839383437382C35393930353534322C35393931323239382C35393939363139302C36303030303736322C,0x35393533353431302C35393536303031302C35393537383332392C35393538343635382C35393631373039372C35393639353333362C35393735303639392C35393739323438372C35393834363137302C35393836343330392C35393837363633352C35393837393631312C35393839383535332C35393930353636332C35393931323339332C35393939363235322C36303030313234352C),
 (16,'FLJ10986.dApr07','chr1','+',59535272,59937654,59559809,59935919,17,0x35393533353237322C35393535333937392C35393535393739352C35393537383231372C35393538343530362C35393631373030382C35393639353232302C35393735303537302C35393739323338332C35393834363036322C35393836343234372C35393837363438372C35393839383437382C35393930353534322C35393931323239382C35393933353930372C35393933363934342C,0x35393533353431302C35393535333939362C35393536303031302C35393537383332392C35393538343635382C35393631373039372C35393639353333362C35393735303639392C35393739323438372C35393834363137302C35393836343330392C35393837363633352C35393839383535332C35393930353636332C35393931323339332C35393933363030302C35393933373635342C),
 (16,'FLJ10986.bApr07','chr1','+',59535328,60000992,59559809,60000844,16,0x35393533353332382C35393535393739352C35393537383231372C35393538343530362C35393631373030382C35393639353232302C35393735303537302C35393739323338332C35393834363036322C35393836343234372C35393837363438372C35393839383437382C35393930353534322C35393931323239382C35393939363139302C36303030303736322C,0x35393533353431302C35393536303031302C35393537383332392C35393538343635382C35393631373039372C35393639353333362C35393735303639392C35393739323438372C35393834363137302C35393836343330392C35393837363633352C35393839383535332C35393930353636332C35393931323339332C35393939363235322C36303030303939322C),
 (16,'FLJ10986.cApr07','chr1','+',59535356,60000960,59559809,60000844,16,0x35393533353335362C35393535393739352C35393537383231372C35393538343530362C35393631373030382C35393639353232302C35393735303537302C35393739323338362C35393834363036322C35393836343234372C35393837363438372C35393839383437382C35393930353534322C35393931323239382C35393939363139302C36303030303736322C,0x35393533353431302C35393536303031302C35393537383332392C35393538343635382C35393631373039372C35393639353333362C35393735303639392C35393739323438372C35393834363137302C35393836343330392C35393837363633352C35393839383535332C35393930353636332C35393931323339332C35393939363235322C36303030303936302C);
INSERT INTO `aceview_hg18_housekeeping` (`bin`,`name`,`chrom`,`strand`,`txStart`,`txEnd`,`cdsStart`,`cdsEnd`,`exonCount`,`exonStarts`,`exonEnds`) VALUES 
 (16,'FLJ10986.eApr07','chr1','+',59548347,60000988,59559809,60000844,14,0x35393534383334372C35393535393739352C35393631373030382C35393639353232302C35393735303537302C35393739323338332C35393834363036322C35393836343234372C35393837363438372C35393839383437382C35393930353534322C35393931323239382C35393939363139302C36303030303736322C,0x35393534383433362C35393536303031302C35393631373039372C35393639353333362C35393735303639392C35393739323438372C35393834363137302C35393836343330392C35393837363633352C35393839383535332C35393930353636332C35393931323339332C35393939363235322C36303030303938382C),
 (16,'FLJ10986.oApr07','chr1','+',59607183,59898675,59695290,59898491,8,0x35393630373138332C35393631373030382C35393639353232302C35393735303537302C35393739323338332C35393834363036322C35393836343234372C35393839383437382C,0x35393630373238302C35393631373039372C35393639353333362C35393735303639392C35393739323438372C35393834363137302C35393836343330392C35393839383637352C),
 (16,'FLJ10986.qApr07','chr1','+',59631467,59876492,59695290,59876491,7,0x35393633313436372C35393639353232302C35393735303537302C35393739323338332C35393834363036322C35393836343234372C35393837363438372C,0x35393633313535342C35393639353333362C35393735303639392C35393739323438372C35393834363137302C35393836343330392C35393837363439322C),
 (16,'FLJ10986.kApr07','chr1','+',59631521,59919274,59846138,59919067,12,0x35393633313532312C35393639353232302C35393735303537302C35393739323338332C35393834363036322C35393834383335312C35393836343234372C35393837363438372C35393839383437382C35393930353534322C35393931323239382C35393931383933382C,0x35393633313535342C35393639353333362C35393735303639392C35393739323438372C35393834363137302C35393834383337392C35393836343330392C35393837363633352C35393839383535332C35393930353636332C35393931323339332C35393931393237342C),
 (16,'FLJ10986.sApr07','chr1','+',59665566,59846161,59695290,59846161,5,0x35393636353536362C35393639353232302C35393735303537302C35393739323338332C35393834363036322C,0x35393636353639322C35393639353333362C35393735303639392C35393739323438372C35393834363136312C),
 (16,'FLJ10986.vcApr07','chr1','+',59753030,59876613,0,0,5,0x35393735333033302C35393739323338332C35393834363036322C35393836343239372C35393837363438372C,0x35393735333038352C35393739323438372C35393834363136332C35393836343330392C35393837363631332C),
 (16,'gorbey.eApr07','chr1','-',60767254,60878735,0,0,3,0x36303736373235342C36303837383237302C36303837383533312C,0x36303736373530392C36303837383338362C36303837383733352C),
 (16,'gorbey.cApr07','chr1','-',60778489,60878753,0,0,8,0x36303737383438392C36303738303535362C36303831313539372C36303832363330312C36303833333739372C36303833383338362C36303837383237302C36303837383533312C,0x36303737383639332C36303738303637312C36303831313637312C36303832363432322C36303833343633332C36303833383531302C36303837383338362C36303837383735332C),
 (16,'gorbey.aApr07','chr1','-',60780625,60878721,60834559,60878460,4,0x36303738303632352C36303832363239362C36303833333739372C36303837383237302C,0x36303738303637312C36303832363432322C36303833343633332C36303837383732312C),
 (16,'DOCK7.bApr07','chr1','-',62692982,62926557,62693672,62926556,49,0x36323639323938322C36323639353739362C36323731323234302C36323731333436362C36323731333936352C36323731343332352C36323731353935382C36323732353635362C36323732373139322C36323733303936322C36323733323533332C36323733333833392C36323733343539372C36323734323838382C36323734333934302C36323734363232302C36323734383833352C36323735313730322C36323735313937342C36323736363430392C36323736373533352C36323737333735312C36323737363134392C36323737373830332C36323737383031302C36323738303836362C36323738313931342C36323739303939302C36323739343038332C36323739373234372C36323739393837352C36323831353532302C36323831373038362C36323832313434322C36323832343736352C36323835363936342C36323835383135382C36323836333531372C36323836393439382C36323837313735362C36323837333033312C36323837343739352C36323838353934392C36323838363336342C36323838363637332C36323839313938332C36323839323234322C36323930313238332C36323932363438352C,0x36323639333731352C36323639353936342C36323731323334372C36323731333631302C36323731343230322C36323731343431352C36323731363038342C36323732353637312C36323732373332342C36323733313130362C36323733323732362C36323733333934302C36323733343735362C36323734333034312C36323734343037352C36323734363331372C36323734383933322C36323735313836352C36323735323135372C36323736363536342C36323736373730352C36323737333839312C36323737363332302C36323737373931372C36323737383135312C36323738303936322C36323738323030342C36323739313136302C36323739343234382C36323739373437392C36323739393936322C36323831353632322C36323831373232352C36323832313531332C36323832343838332C36323835373132372C36323835383235322C36323836333636302C36323836393636342C36323837313833372C36323837333138312C36323837343836322C36323838363033352C36323838363537372C36323838363830332C36323839323035322C36323839323431382C36323930313338392C36323932363535372C),
 (16,'DOCK7.aApr07','chr1','-',62693468,62926627,62693672,62926523,49,0x36323639333436382C36323639353739362C36323731323234302C36323731333436362C36323731333936352C36323731343332352C36323731353935382C36323732373139322C36323733303936322C36323733323533332C36323733333833392C36323733343539372C36323734323838382C36323734333934302C36323734363232302C36323734383833352C36323735313732392C36323735313937342C36323736363430392C36323736373533352C36323737333735312C36323737363134392C36323737373830332C36323737383031302C36323738303836362C36323738313931342C36323738333230352C36323739303939302C36323739343038332C36323739373234372C36323739393837352C36323831353532302C36323831373038362C36323832313434322C36323832343736352C36323835363936342C36323835383135382C36323836333531372C36323836393439382C36323837313735362C36323837333033312C36323837343739352C36323838353934392C36323838363336342C36323838363637332C36323839313938332C36323839323234322C36323930313238332C36323932363438352C,0x36323639333731352C36323639353936342C36323731323334372C36323731333631302C36323731343230322C36323731343431352C36323731363039332C36323732373332342C36323733313130362C36323733323732362C36323733333934302C36323733343735362C36323734333034312C36323734343037352C36323734363331372C36323734383933322C36323735313836352C36323735323135372C36323736363536342C36323736373730352C36323737333839312C36323737363332302C36323737373931372C36323737383135312C36323738303936322C36323738323030342C36323738333239382C36323739313136302C36323739343234382C36323739373437392C36323739393936322C36323831353632322C36323831373232352C36323832313531332C36323832343838332C36323835373132372C36323835383235322C36323836333636302C36323836393636342C36323837313833372C36323837333138312C36323837343836322C36323838363033352C36323838363537372C36323838363830332C36323839323035322C36323839323431382C36323930313338392C36323932363632372C),
 (16,'DOCK7.gApr07','chr1','-',62822361,62926557,62823038,62926523,16,0x36323832323336312C36323832343736352C36323835363936342C36323835383135382C36323836333531372C36323836393439382C36323837313735362C36323837333033312C36323837343739352C36323838353934392C36323838363336342C36323838363637332C36323839313938332C36323839323234322C36323930313238332C36323932363438352C,0x36323832333133372C36323832343838332C36323835373132372C36323835383235322C36323836333636302C36323836393636342C36323837313833372C36323837333138312C36323837343836322C36323838363033352C36323838363537372C36323838363830332C36323839323035322C36323839323431382C36323930313338392C36323932363535372C),
 (16,'RAVER2.aApr07','chr1','+',64982986,65072879,64982987,65069256,12,0x36343938323938362C36353030363932362C36353031353839332C36353031393635302C36353032373635382C36353034313234362C36353034333034332C36353034333236312C36353034353437362C36353035313030382C36353035323937342C36353036393130392C,0x36343938333639322C36353030363939332C36353031363336332C36353031393834322C36353032373738352C36353034313333322C36353034333130392C36353034333337362C36353034353734352C36353035313132302C36353035333131312C36353037323837392C),
 (16,'PDE4B.dApr07','chr1','+',66030781,66612850,66151622,66610949,16,0x36363033303738312C36363135313531352C36363438353733302C36363439353931372C36363439363036332C36363530343330382C36363537303737382C36363539333739372C36363539393838352C36363630313433382C36363630313637372C36363630333933372C36363630353936362C36363630363231332C36363630373035372C36363631303538332C,0x36363033303930312C36363135313632372C36363438353932352C36363439353935342C36363439363133342C36363530343335382C36363537303839312C36363539333839312C36363630303036342C36363630313533372C36363630313834322C36363630343033372C36363630363132312C36363630363333362C36363630373234302C36363631323835302C),
 (16,'PDE4B.bApr07','chr1','+',66030781,66612850,66151585,66610949,17,0x36363033303738312C36363135313531352C36363135363836372C36363438353733302C36363439353931372C36363439363036332C36363530343330382C36363537303737382C36363539333739372C36363539393838352C36363630313433382C36363630313637372C36363630333933372C36363630353936362C36363630363231332C36363630373035372C36363631303538332C,0x36363033303930312C36363135313632372C36363135373130362C36363438353932352C36363439353935342C36363439363133342C36363530343335382C36363537303839312C36363539333839312C36363630303036342C36363630313533372C36363630313834322C36363630343033372C36363630363132312C36363630363333362C36363630373234302C36363631323835302C),
 (16,'PDE4B.aApr07','chr1','+',66031280,66612850,66151585,66610949,17,0x36363033313238302C36363135313531352C36363135363836372C36363438353733302C36363439353931372C36363439363036332C36363530343330382C36363537303737382C36363539333739372C36363539393838352C36363630313433382C36363630313637372C36363630333933372C36363630353936362C36363630363231332C36363630373035372C36363631303538332C,0x36363033313531392C36363135313632372C36363135373130362C36363438353932352C36363439353935342C36363439363133342C36363530343335382C36363537303839312C36363539333839312C36363630303036342C36363630313533372C36363630313834322C36363630343033372C36363630363132312C36363630363333362C36363630373234302C36363631323835302C),
 (17,'LOC729620.dApr07','chr1','+',68070474,68355763,68070614,68338977,6,0x36383037303437342C36383331303037302C36383333373939392C36383333383936382C36383334303932352C36383335353732312C,0x36383037303730372C36383331303134342C36383333383036332C36383333393034352C36383334303939382C36383335353736332C),
 (17,'LOC729620.eApr07','chr1','+',68070493,68339043,68272971,68338977,5,0x36383037303439332C36383237323931372C36383331303037302C36383333373939392C36383333383936382C,0x36383037303730372C36383237333033342C36383331303134342C36383333383036332C36383333393034332C),
 (17,'LOC729620.kApr07','chr1','+',68070557,68355836,0,0,6,0x36383037303535372C36383139343432362C36383331303037302C36383333373939392C36383334303932352C36383335353732312C,0x36383037303730372C36383139343533332C36383331303134342C36383333383036332C36383334303939382C36383335353833362C),
 (17,'LOC729620.gApr07','chr1','+',68070574,68441258,0,0,10,0x36383037303537342C36383237323931372C36383331303037302C36383333363931332C36383333373939392C36383333383936382C36383335353732312C36383335393339352C36383337363536372C36383434303233392C,0x36383037303730372C36383237333033342C36383331303134342C36383333373130372C36383333383036332C36383333393034352C36383335363030332C36383335393531322C36383337363732312C36383434313235382C),
 (17,'LOC729620.aApr07','chr1','+',68070577,68355899,68272971,68355880,5,0x36383037303537372C36383237323931372C36383331303037302C36383333373939392C36383335353732312C,0x36383037303730372C36383237333033342C36383331303134342C36383333383036332C36383335353839392C),
 (17,'LOC729620.hApr07','chr1','+',68070579,68441258,0,0,9,0x36383037303537392C36383139343432362C36383331303037302C36383333363931332C36383333373939392C36383334303932352C36383335353732312C36383335393339352C36383434303233392C,0x36383037303730372C36383139343533332C36383331303134342C36383333373130372C36383333383036332C36383334303939382C36383335363030332C36383335393531322C36383434313235382C),
 (17,'LRRC7.dApr07','chr1','+',69916651,70360265,69954488,70276413,23,0x36393931363635312C36393935343431322C36393939383436312C37303033303331332C37303036343031382C37303037333035302C37303037363439372C37303136393737372C37303231383634392C37303232343531322C37303233323833312C37303235303036372C37303235313234342C37303235343733352C37303235363938392C37303235393237352C37303237363338332C37303238323232342C37303239313239362C37303331343334372C37303332373939372C37303334363032322C37303336303035302C,0x36393931363734392C36393935343439312C36393939383636342C37303033303433312C37303036343039372C37303037333134302C37303037363535342C37303136393834312C37303231383732342C37303232343635372C37303233323930342C37303235303139372C37303235313336302C37303235343830352C37303235373038392C37303235393430302C37303237383036342C37303238323336352C37303239313431362C37303331343536392C37303332383039302C37303334363039372C37303336303236352C),
 (17,'kesuyo.aApr07','chr1','-',69996576,70280531,0,0,6,0x36393939363537362C36393939383832352C36393939393437352C37303030343836332C37303237373039392C37303238303336382C,0x36393939373039312C36393939383932382C36393939393534302C37303030343934372C37303237373233352C37303238303533312C),
 (17,'LRRC7.aApr07','chr1','+',69998384,70361757,69998385,70360158,25,0x36393939383338342C37303033303331332C37303036343031382C37303037333035302C37303037363439372C37303136393737372C37303231383634392C37303232343531322C37303233323833312C37303235303036372C37303235313234342C37303235343733352C37303235363938392C37303235393237352C37303236313339362C37303236363434312C37303237343339312C37303237343731342C37303237363338332C37303238323232342C37303239313239362C37303331343334372C37303332373939372C37303334363032322C37303336303035302C,0x36393939383636342C37303033303433312C37303036343039372C37303037333134302C37303037363535342C37303136393834312C37303231383732342C37303232343635372C37303233323930342C37303235303139372C37303235313336302C37303235343830352C37303235373038392C37303235393430302C37303236313634352C37303236363634322C37303237343530332C37303237343839352C37303237383036342C37303238323336352C37303239313431362C37303331343536392C37303332383039302C37303334363039372C37303336313735372C),
 (17,'dawkley.bApr07','chr1','-',70252255,70269493,0,0,4,0x37303235323235352C37303235393531382C37303236303533322C37303236393430322C,0x37303235323431352C37303235393635302C37303236303636392C37303236393439332C),
 (17,'berkobo.aApr07','chr1','+',71284771,71305451,71284921,71287135,3,0x37313238343737312C37313238373038342C37313330353033362C,0x37313238353836302C37313238373235392C37313330353435312C),
 (17,'ZRANB2.bApr07','chr1','-',71301556,71319334,71303989,71319266,11,0x37313330313535362C37313330333934382C37313330353034362C37313330373534362C37313330393039372C37313331303339312C37313331303734322C37313331353036352C37313331363732372C37313331363932362C37313331393231302C,0x37313330333430382C37313330343032332C37313330353230352C37313330373633332C37313330393236372C37313331303532362C37313331303831392C37313331353134382C37313331363833362C37313331363937392C37313331393333342C),
 (17,'ZRANB2.aApr07','chr1','-',71301556,71319556,71303344,71319266,10,0x37313330313535362C37313330353034362C37313330373534362C37313330393039372C37313331303339312C37313331303734322C37313331353036352C37313331363732372C37313331363932362C37313331393231302C,0x37313330333430382C37313330353230352C37313330373633332C37313330393236372C37313331303532362C37313331303831392C37313331353134382C37313331363833362C37313331363937392C37313331393535362C),
 (17,'ZRANB2.cApr07','chr1','-',71301559,71319277,71305030,71319266,10,0x37313330313535392C37313330333934382C37313330373534362C37313330393039372C37313331303339312C37313331303734322C37313331353036352C37313331363732372C37313331363932362C37313331393231302C,0x37313330333430382C37313330353230352C37313330373633332C37313330393236372C37313331303532362C37313331303831392C37313331353134382C37313331363833362C37313331363937392C37313331393237372C),
 (17,'ZRANB2.jApr07','chr1','-',71301562,71305784,71305008,71305239,2,0x37313330313536322C37313330333934382C,0x37313330333430382C37313330353738342C),
 (17,'ZRANB2.dApr07','chr1','-',71301562,71319300,71307542,71319266,8,0x37313330313536322C37313330393039372C37313331303339312C37313331303734322C37313331353036352C37313331363732372C37313331363932362C37313331393231302C,0x37313330373633332C37313330393236372C37313331303532362C37313331303831392C37313331353134322C37313331363833362C37313331363937392C37313331393330302C),
 (17,'ZRANB2.eApr07','chr1','-',71301570,71319305,71309093,71319266,7,0x37313330313537302C37313331303339312C37313331303734322C37313331353036352C37313331363732372C37313331363932362C37313331393231302C,0x37313330393236372C37313331303532362C37313331303831392C37313331353134382C37313331363833362C37313331363937392C37313331393330352C),
 (17,'ZRANB2.hApr07','chr1','-',71301916,71319305,71304015,71319303,6,0x37313330313931362C37313330333337332C37313330333934382C37313330353034362C37313330373534362C37313331393234352C,0x37313330323231312C37313330333430382C37313330343032332C37313330353230352C37313330373633332C37313331393330352C),
 (17,'NEGR1.aApr07','chr1','-',71641212,72521111,71645716,72520765,8,0x37313634313231322C37313833313038372C37313834393239362C37313933363237382C37323031343434322C37323137333334392C37323532303538392C37323532313035322C,0x37313634353834312C37313833313233392C37313834393431372C37313933363431302C37323031343536382C37323137333538322C37323532303939332C37323532313131312C),
 (17,'NEGR1.cApr07','chr1','-',71917909,72520630,71917996,72520630,5,0x37313931373930392C37313933363237382C37323031343434322C37323137333334392C37323532303538392C,0x37313931383033342C37313933363431302C37323031343536382C37323137333538322C37323532303633302C),
 (17,'lupoybu.aApr07','chr1','-',72171289,72521991,72521659,72521989,3,0x37323137313238392C37323532313236362C37323532313438332C,0x37323137313838312C37323532313333332C37323532313939312C),
 (17,'NEGR1.gApr07','chr1','-',72173409,72520630,72173410,72520296,2,0x37323137333430392C37323532303233342C,0x37323137333538322C37323532303633302C),
 (17,'FPGTandTNNI3K.dApr07','chr1','+',74436484,74450336,74436511,74444104,4,0x37343433363438342C37343433373933352C37343433393538392C37343434323636322C,0x37343433363633322C37343433383130332C37343433393638322C37343435303333362C),
 (17,'FPGTandTNNI3K.aApr07','chr1','+',74436509,74782696,74436511,74782254,27,0x37343433363530392C37343433373933352C37343433393538392C37343437343337332C37343438373733302C37343438383934332C37343530393836392C37343536393732312C37343537343238322C37343538313131332C37343538313334362C37343539313533372C37343539323235312C37343630353532372C37343630363137392C37343630373239332C37343630373437382C37343630373636322C37343630383535392C37343637343335312C37343637343734352C37343637373736312C37343730313731322C37343732373436302C37343733303336382C37343737383530352C37343738323137372C,0x37343433363633322C37343433383130332C37343433393638322C37343437343438322C37343438373831362C37343438393034312C37343530393938302C37343536393832302C37343537343432312C37343538313235382C37343538313435312C37343539313633322C37343539323430312C37343630353631342C37343630363233362C37343630373338362C37343630373533362C37343630373835372C37343630383636342C37343637343430342C37343637343739382C37343637373839342C37343730313832322C37343732373532302C37343733303533382C37343737383538352C37343738323639362C),
 (17,'FPGTandTNNI3K.bApr07','chr1','+',74436510,74703197,74436511,74703014,24,0x37343433363531302C37343433373933352C37343433393538392C37343437343337332C37343438373733302C37343438383934332C37343530393836392C37343536393732312C37343537343238322C37343538313131332C37343538313334362C37343539313533372C37343539323235312C37343630353532372C37343630363137392C37343630373239332C37343630373437382C37343630373636322C37343630383535392C37343637343335312C37343637343734352C37343637373736312C37343730313731322C37343730323930362C,0x37343433363633322C37343433383130332C37343433393638322C37343437343438322C37343438373831362C37343438393034312C37343530393938302C37343536393832302C37343537343432312C37343538313235382C37343538313435312C37343539313633322C37343539323430312C37343630353631342C37343630363233362C37343630373338362C37343630373533362C37343630373835372C37343630383636342C37343637343430342C37343637343739382C37343637373839342C37343730313832322C37343730333139372C),
 (17,'FPGTandTNNI3K.eApr07','chr1','+',74436521,74614120,74436550,74613876,10,0x37343433363532312C37343433373933352C37343433393538392C37343630353532372C37343630363137392C37343630373239332C37343630373437382C37343630373636322C37343630383535392C37343631333833362C,0x37343433363633322C37343433383130332C37343433393638322C37343630353631342C37343630363233362C37343630373338362C37343630373533362C37343630373835372C37343630383636342C37343631343132302C),
 (17,'FPGTandTNNI3K.lApr07','chr1','+',74436525,74487790,74436550,74487736,6,0x37343433363532352C37343433373933352C37343433393538392C37343437343337332C37343437393037392C37343438373733302C,0x37343433363633322C37343433383130332C37343433393638322C37343437343438322C37343437393130372C37343438373739302C),
 (17,'FPGTandTNNI3K.nApr07','chr1','+',74436536,74478956,74436550,74478231,5,0x37343433363533362C37343433373933352C37343433393538392C37343437343337332C37343437383232372C,0x37343433363633322C37343433383130332C37343433393638322C37343437343438322C37343437383935362C),
 (18,'ST6GALNAC3.aApr07','chr1','+',76312975,76872871,76312977,76867079,5,0x37363331323937352C37363535323037372C37363635303238302C37363836353732342C37363836363839322C,0x37363331333135372C37363535323237322C37363635303639302C37363836353833322C37363837323837312C),
 (18,'ST6GALNAC3.bApr07','chr1','+',76313017,76815480,76313019,76815128,4,0x37363331333031372C37363535323037372C37363635303238302C37363831353131382C,0x37363331333135372C37363535323237322C37363635303639302C37363831353438302C),
 (18,'ST6GALNAC3.cApr07','chr1','+',76313105,76561457,76313139,76561341,3,0x37363331333130352C37363535323037372C37363536313135382C,0x37363331333135372C37363535323237322C37363536313435372C),
 (18,'ST6GALNAC3.dApr07','chr1','+',76339615,76650455,76339764,76650454,3,0x37363333393631352C37363535323037372C37363635303238302C,0x37363333393737392C37363535323237322C37363635303435352C),
 (18,'AK5.aApr07','chr1','+',77520244,77798242,77520586,77796943,14,0x37373532303234342C37373532353231332C37373533323036352C37373533353833312C37373533363130362C37373537383634392C37373634393235332C37373635353931312C37373732313538392C37373732343538302C37373735363833362C37373736303039392C37373737343131392C37373739363837342C,0x37373532303634362C37373532353430302C37373533323233332C37373533363030312C37373533363232302C37373537383834312C37373634393334342C37373635353938382C37373732313633322C37373732343632352C37373735373030302C37373736303231362C37373737343331312C37373739383234322C),
 (18,'AK5.bApr07','chr1','+',77520869,77798242,77525231,77796943,14,0x37373532303836392C37373532353231352C37373533323036352C37373533353833312C37373533363130362C37373537383634392C37373634393235332C37373635353931312C37373732313538392C37373732343538302C37373735363833362C37373736303039392C37373737343131392C37373739363837342C,0x37373532313838342C37373532353430302C37373533323233332C37373533363030312C37373533363232302C37373537383834312C37373634393334342C37373635353938382C37373732313633322C37373732343632352C37373735373030302C37373736303231362C37373737343331312C37373739383234322C),
 (18,'AK5.gApr07','chr1','+',77578677,77656122,77578679,77656003,3,0x37373537383637372C37373634393235332C37373635353931312C,0x37373537383834312C37373634393334342C37373635363132322C),
 (18,'AK5.fApr07','chr1','+',77578837,77796912,77649298,77796912,7,0x37373537383833372C37373634393235332C37373635353931312C37373732313538392C37373732343538302C37373737343131392C37373739363837342C,0x37373537383834312C37373634393334342C37373635353938382C37373732313633322C37373732343632352C37373737343331312C37373739363931322C),
 (18,'PTGFR.aApr07','chr1','+',78542155,78775396,78731016,78774960,4,0x37383534323135352C37383633373232332C37383733303934342C37383737343637382C,0x37383534323230332C37383633373239382C37383733313831342C37383737353339362C),
 (18,'LPHN2.vaApr07','chr1','+',81544427,81973602,0,0,5,0x38313534343432372C38313638333239332C38313831393134382C38313933383031392C38313937333336322C,0x38313534343738322C38313638333336322C38313831393235332C38313933383038312C38313937333630322C),
 (18,'LPHN2.fApr07','chr1','+',81544472,82230694,82075257,82229417,9,0x38313534343437322C38313638333239332C38313831373537322C38313831393134382C38323030303038332C38323037353135372C38323134353238392C38323137343939392C38323232383636322C,0x38313534343738322C38313638333336322C38313831373635332C38313831393235332C38323030303132352C38323037353333302C38323134353530332C38323137353130392C38323233303639342C),
 (18,'bloboy.aApr07','chr1','-',81752152,81795975,81752308,81753278,4,0x38313735323135322C38313735323930322C38313735333130372C38313739353933362C,0x38313735323331382C38313735323937392C38313735333436382C38313739353937352C),
 (19,'SSX2IP.gApr07','chr1','-',84884300,84953031,84884961,84909048,7,0x38343838343330302C38343930303735392C38343930323638372C38343930343339322C38343930373935312C38343930383931362C38343935323935302C,0x38343838353030312C38343930303830312C38343930323832332C38343930343530332C38343930383136342C38343930393038362C38343935333033312C),
 (19,'COL24A1.bApr07','chr1','-',85967503,86201520,85968816,86149674,35,0x38353936373530332C38353937333031392C38353937353636362C38353938323933362C38353938333731312C38363031333934342C38363031393439302C38363032313736362C38363032323338332C38363032323532392C38363032343632342C38363035353035382C38363035363330342C38363036313830362C38363036313935352C38363037363835352C38363037393439322C38363038303333382C38363038303631302C38363038353933352C38363038373632332C38363130363738392C38363130373035322C38363131323931392C38363131333534372C38363131353339322C38363132373833302C38363133343132382C38363133343239312C38363133343632362C38363134353436342C38363134363836382C38363134383232302C38363134393635302C38363139393531392C,0x38353936383936332C38353937333233352C38353937353737362C38353938333130352C38353938333737372C38363031333938302C38363031393534342C38363032313832392C38363032323433372C38363032323633372C38363032343733322C38363035353136362C38363035363335382C38363036313836302C38363036323030392C38363037363930392C38363037393534392C38363038303339322C38363038303636342C38363038363034332C38363038373637372C38363130363839372C38363130373130362C38363131323937332C38363131333630312C38363131353434362C38363132373838342C38363133343137332C38363133343333362C38363133343638302C38363134353531382C38363134363932322C38363134383237342C38363134393730342C38363230313532302C),
 (19,'COL24A1.aApr07','chr1','-',85967503,86395033,85968816,86394871,60,0x38353936373530332C38353937333031392C38353937353636362C38353938323933362C38353938333731312C38353939393636362C38353939393830312C38363031333934342C38363031393439302C38363032313736362C38363032323338332C38363032323532392C38363032343632342C38363035353035382C38363035363330342C38363036313830362C38363036313935352C38363037363835352C38363037393439322C38363038303333382C38363038303631302C38363038353933352C38363038373632332C38363130363738392C38363130373035322C38363131323931392C38363131333534372C38363131353339322C38363132373833302C38363133343132382C38363133343239312C38363133343632362C38363134353436342C38363134363836382C38363134383232302C38363134393635302C38363139393531392C38363230333237392C38363230383439372C38363230393631302C38363232353837312C38363235353432312C38363236303531302C38363236303830382C38363236313130332C38363236313232342C38363237303134382C38363237323134302C38363238353039352C38363238383339342C38363239363230312C38363239373339312C38363330313938352C38363332373434342C38363333303533372C38363335303833372C38363335333539352C38363336333131352C38363338343338392C38363339343631312C,0x38353936383936332C38353937333233352C38353937353737362C38353938333130352C38353938333737372C38353939393639332C38353939393833372C38363031333938302C38363031393534342C38363032313832392C38363032323433372C38363032323633372C38363032343733322C38363035353136362C38363035363335382C38363036313836302C38363036323030392C38363037363930392C38363037393534392C38363038303339322C38363038303636342C38363038363034332C38363038373637372C38363130363839372C38363130373130362C38363131323937332C38363131333630312C38363131353434362C38363132373838342C38363133343137332C38363133343333362C38363133343638302C38363134353531382C38363134363932322C38363134383237342C38363134393730342C38363139393536342C38363230333333332C38363230383534322C38363230393636342C38363232353932352C38363235353437352C38363236303536342C38363236303836322C38363236313134382C38363236313237382C38363237303139332C38363237323139342C38363238353134302C38363238383434382C38363239363234362C38363239373434352C38363330323033302C38363332373439382C38363333303539312C38363335303839312C38363335333634392C38363336343438352C38363338343435342C38363339353033332C),
 (19,'COL24A1.dApr07','chr1','-',85973175,85987209,85973175,85983771,5,0x38353937333137352C38353937353636362C38353938323933362C38353938333731312C38353938373035302C,0x38353937333233352C38353937353737362C38353938333130352C38353938333737372C38353938373230392C),
 (19,'GTF2B.aApr07','chr1','-',89090908,89130215,89091309,89125562,5,0x38393039303930382C38393039383431302C38393130323235312C38393132353533312C38393132393837372C,0x38393039313338342C38393039383535372C38393130323338352C38393132353633382C38393133303231352C),
 (19,'GTF2B.bApr07','chr1','-',89091058,89129888,89091483,89129770,7,0x38393039313035382C38393039353437362C38393039383135322C38393039383431302C38393130323235312C38393132353533312C38393132393735332C,0x38393039313631372C38393039353735382C38393039383238322C38393039383535372C38393130323338352C38393132353633382C38393132393838382C),
 (19,'GTF2B.dApr07','chr1','-',89095651,89129774,89097041,89129773,7,0x38393039353635312C38393039363935312C38393039383135322C38393039383431302C38393130323235312C38393132353533312C38393132393735332C,0x38393039353735382C38393039373035382C38393039383238322C38393039383535372C38393130323338352C38393132353633382C38393132393737342C),
 (19,'GTF2B.eApr07','chr1','-',89098139,89129834,89098141,89129770,5,0x38393039383133392C38393039383431302C38393130323235312C38393132353533312C38393132393735332C,0x38393039383238322C38393039383535372C38393130323338352C38393132353633382C38393132393833342C),
 (19,'GTF2B.gApr07','chr1','-',89098326,89129921,89098359,89102263,3,0x38393039383332362C38393130323235312C38393132393735332C,0x38393039383535372C38393130323338352C38393132393932312C),
 (19,'GTF2B.cApr07','chr1','-',89098349,89129888,89098359,89129887,4,0x38393039383334392C38393130323235312C38393132353533312C38393132393735332C,0x38393039383535372C38393130323338352C38393132353633382C38393132393838382C),
 (19,'GTF2B.iApr07','chr1','-',89098442,89129799,89098534,89129797,3,0x38393039383434322C38393132353533312C38393132393735332C,0x38393039383535372C38393132353633382C38393132393739392C),
 (19,'GTF2B.fApr07','chr1','-',89101682,89129836,89102098,89129770,3,0x38393130313638322C38393132353533312C38393132393735332C,0x38393130323338352C38393132353633382C38393132393833362C),
 (19,'LRRC8CandLRRC8D.aApr07','chr1','+',90059168,90178294,90171215,90173792,4,0x39303035393136382C39303038313738342C39303137313231332C39303137373734372C,0x39303035393433382C39303038313932392C39303137343735382C39303137383239342C),
 (19,'ZNF644.hApr07','chr1','-',91153435,91260508,91154942,91220476,4,0x39313135333433352C39313135363139362C39313232303435342C39313236303133342C,0x39313135353133352C39313135363239392C39313232303531352C39313236303530382C),
 (19,'ZNF644.aApr07','chr1','-',91153446,91260399,91154942,91220498,6,0x39313135333434362C39313135363139362C39313137353632392C39313137363431362C39313232303435342C39313236303133342C,0x39313135353133352C39313135363239392C39313137363233352C39313137393435342C39313232303531352C39313236303339392C),
 (19,'ZNF644.gApr07','chr1','-',91153456,91259654,91154942,91220476,4,0x39313135333435362C39313135363139362C39313232303435342C39313235393431372C,0x39313135353133352C39313135363239392C39313232303531352C39313235393635342C),
 (19,'ZNF644.nApr07','chr1','-',91154534,91260159,0,0,5,0x39313135343533342C39313135363139362C39313231313239372C39313232303435342C39313236303133342C,0x39313135353133352C39313135363239392C39313231313335382C39313232303531352C39313236303135392C),
 (19,'ZNF644.kApr07','chr1','-',91155047,91260150,91155047,91220476,4,0x39313135353034372C39313135363139362C39313232303435342C39313235393833332C,0x39313135353133352C39313135363239392C39313232303531352C39313236303135302C),
 (19,'ZNF644.qApr07','chr1','-',91155104,91260399,0,0,5,0x39313135353130342C39313135363139362C39313232303435342C39313235393833332C39313236303133342C,0x39313135353133352C39313135363239392C39313232303531352C39313235393934362C39313236303339392C),
 (19,'ZNF644.bApr07','chr1','-',91177811,91259653,91177812,91220498,3,0x39313137373831312C39313232303435342C39313235393431372C,0x39313137393435342C39313232303531352C39313235393635332C),
 (19,'ZNF644.cApr07','chr1','-',91178636,91260226,91178637,91258193,3,0x39313137383633362C39313235383132352C39313236303133342C,0x39313137393138312C39313235393334362C39313236303232362C),
 (19,'ZNF644.dApr07','chr1','-',91178934,91260168,91178934,91220498,3,0x39313137383933342C39313232303435342C39313235393833332C,0x39313137393435342C39313232303531352C39313236303136382C),
 (19,'ZNF644.fApr07','chr1','-',91179052,91260166,91179054,91220498,4,0x39313137393035322C39313232303435342C39313235393239312C39313236303133342C,0x39313137393435342C39313232303531352C39313235393334362C39313236303136362C),
 (19,'ZNF644.lApr07','chr1','-',91179110,91260172,91220504,91260172,4,0x39313137393131302C39313232303435342C39313235393230362C39313236303133342C,0x39313137393435342C39313232303531352C39313235393334362C39313236303137322C),
 (19,'ZNF644.mApr07','chr1','-',91219537,91260190,0,0,2,0x39313231393533372C39313236303133342C,0x39313232303531352C39313236303139302C),
 (20,'MTF2.aApr07','chr1','+',93317380,93377227,93317671,93375172,15,0x39333331373338302C39333334383337342C39333334383638392C39333335323833322C39333335333133322C39333335333631342C39333335363438392C39333335373437372C39333335383639332C39333336353337362C39333336373432322C39333337313834372C39333337323037322C39333337323233352C39333337343831342C,0x39333331373637362C39333334383537332C39333334383737312C39333335323932382C39333335333233332C39333335333736332C39333335363538352C39333335373534362C39333335383831372C39333336353434342C39333336373539332C39333337313935332C39333337323132352C39333337323334302C39333337373232372C),
 (20,'MTF2.oApr07','chr1','+',93317386,93348788,93317671,93348788,3,0x39333331373338362C39333334383337342C39333334383638392C,0x39333331373637362C39333334383537332C39333334383738382C),
 (20,'MTF2.gApr07','chr1','+',93317386,93371876,93348489,93371874,11,0x39333331373338362C39333334383337342C39333334383437312C39333334383638392C39333335323833322C39333335333133322C39333335333631342C39333335363438392C39333335373437372C39333335383639332C39333337313834372C,0x39333331373637362C39333334383339312C39333334383537332C39333334383737312C39333335323932382C39333335333233332C39333335333736332C39333335363538352C39333335373534362C39333335383831372C39333337313837362C),
 (20,'MTF2.dApr07','chr1','+',93317415,93375355,93352852,93375172,16,0x39333331373431352C39333332323837322C39333334383337342C39333334383638392C39333335323833322C39333335333133322C39333335333631342C39333335363438392C39333335373437372C39333335383639332C39333336353337362C39333336373432322C39333337313834372C39333337323037322C39333337323233352C39333337343831342C,0x39333331373637362C39333332333032382C39333334383537372C39333334383737352C39333335323932382C39333335333233332C39333335333736332C39333335363538352C39333335373534362C39333335383831372C39333336353434342C39333336373539332C39333337313935332C39333337323132352C39333337323334302C39333337353335352C),
 (20,'MTF2.bApr07','chr1','+',93317425,93375663,93348541,93375172,15,0x39333331373432352C39333334383337342C39333334383638392C39333335323833322C39333335333133322C39333335333631342C39333335363438392C39333335373437372C39333335383639332C39333336353337362C39333336373432322C39333337313834372C39333337323037322C39333337323233352C39333337343831342C,0x39333331373637362C39333334383537372C39333334383737312C39333335323932382C39333335333233332C39333335333736332C39333335363538352C39333335373534362C39333335383831372C39333336353434342C39333336373539332C39333337313935332C39333337323132352C39333337323334302C39333337353636332C),
 (20,'MTF2.eApr07','chr1','+',93317427,93371887,93352852,93371887,10,0x39333331373432372C39333335323833322C39333335333133322C39333335333631342C39333335363438392C39333335373437372C39333335383639332C39333336353337362C39333336373432322C39333337313834372C,0x39333331373637362C39333335323932382C39333335333233332C39333335333736332C39333335363538352C39333335373534362C39333335383831372C39333336353434342C39333336373539332C39333337313838372C),
 (20,'MTF2.fApr07','chr1','+',93317439,93375263,93317671,93365428,14,0x39333331373433392C39333334383337342C39333334383638392C39333335323833322C39333335333133322C39333335333631342C39333335363438392C39333335373437372C39333336353337362C39333336373432322C39333337313834372C39333337323037322C39333337323233352C39333337343831342C,0x39333331373637362C39333334383537332C39333334383737312C39333335323932382C39333335333233332C39333335333736332C39333335363538352C39333335373534362C39333336353434342C39333336373539332C39333337313935332C39333337323132352C39333337323334302C39333337353236332C),
 (20,'MTF2.cApr07','chr1','+',93317442,93375290,93317671,93375172,14,0x39333331373434322C39333334383337342C39333334383638392C39333335323833322C39333335333133322C39333335333631342C39333335363438392C39333335373437372C39333335383639332C39333336353337362C39333337313834372C39333337323037322C39333337323233352C39333337343831342C,0x39333331373637362C39333334383537332C39333334383737312C39333335323932382C39333335333233332C39333335333736332C39333335363538352C39333335373534362C39333335383831372C39333336353434342C39333337313935332C39333337323132352C39333337323334302C39333337353239302C),
 (20,'MTF2.jApr07','chr1','+',93317456,93358448,93348541,93357550,8,0x39333331373435362C39333334383337342C39333334383638392C39333335323833322C39333335333133322C39333335333631342C39333335363438392C39333335373437372C,0x39333331373637362C39333334383537372C39333334383737312C39333335323932382C39333335333233332C39333335333736332C39333335363538352C39333335383434382C),
 (20,'MTF2.hApr07','chr1','+',93317456,93358419,93317671,93357550,8,0x39333331373435362C39333334383337342C39333334383638392C39333335323833322C39333335333133322C39333335333631342C39333335363438392C39333335373437372C,0x39333331373637362C39333334383537332C39333334383737312C39333335323932382C39333335333233332C39333335333736332C39333335363538352C39333335383431392C),
 (20,'TMEM56andRWDD3.cApr07','chr1','+',95330657,95430442,95382045,95430012,7,0x39353333303635372C39353338323033342C39353338363834352C39353338383335312C39353338393436382C39353431313935392C39353432393639332C,0x39353333313032352C39353338323230302C39353338363933352C39353338383431302C39353338393536332C39353431323033332C39353433303434322C),
 (20,'TMEM56andRWDD3.eApr07','chr1','+',95355436,95435748,95382045,95430012,7,0x39353335353433362C39353338323033342C39353338363834352C39353338383335312C39353338393436382C39353431313935392C39353432393639332C,0x39353335353736312C39353338323230302C39353338363933352C39353338383431302C39353338393536332C39353431323033332C39353433353734382C),
 (20,'TMEM56andRWDD3.dApr07','chr1','+',95355582,95430145,95382045,95430012,8,0x39353335353538322C39353335393139382C39353338323033342C39353338363834352C39353338383335312C39353338393436382C39353431313935392C39353432393639332C,0x39353335353937312C39353335393332382C39353338323230302C39353338363933352C39353338383431302C39353338393536332C39353431323033332C39353433303134352C),
 (20,'TMEM56andRWDD3.iApr07','chr1','+',95356066,95483095,95382045,95482394,8,0x39353335363036362C39353338323033342C39353338363834352C39353338383335312C39353338393436382C39353431313935392C39353436393034352C39353438323335342C,0x39353335363233352C39353338323230302C39353338363933352C39353338383431302C39353338393536332C39353431323033332C39353436393133382C39353438333039352C),
 (20,'TMEM56andRWDD3.aApr07','chr1','+',95378814,95430121,95382045,95430012,5,0x39353337383831342C39353338323033342C39353338363834352C39353338383335312C39353432393731342C,0x39353337383838362C39353338323230302C39353338363933352C39353338383339342C39353433303132312C),
 (20,'TMEM56andRWDD3.rApr07','chr1','+',95389520,95485361,95389521,95485014,4,0x39353338393532302C39353431313935392C39353436393034352C39353438343839392C,0x39353338393536332C39353431323033332C39353436393133382C39353438353336312C),
 (20,'reyoro.aApr07','chr1','-',95401362,95472125,0,0,4,0x39353430313336322C39353434333233392C39353435393832392C39353437313834332C,0x39353430333334322C39353434333237372C39353435393937352C39353437323132352C),
 (20,'reyoro.cApr07','chr1','-',95403264,95472100,0,0,5,0x39353430333236342C39353431383437372C39353434333233392C39353435393832392C39353437313834332C,0x39353430333334322C39353431383530332C39353434333237372C39353435393937352C39353437323130302C),
 (20,'reyoro.dApr07','chr1','-',95412267,95472125,0,0,4,0x39353431323236372C39353434333233392C39353435393832392C39353437313834332C,0x39353431323332352C39353434333237372C39353435393937352C39353437323132352C),
 (20,'DPYD.aApr07','chr1','-',97315886,98159202,97317119,98159066,23,0x39373331353838362C39373332303437332C39373333363633322C39373433313231322C39373437323939352C39373534333430322C39373534343332302C39373631313730342C39373632303533362C39373638383230322C39373735333836392C39373738373730332C39373831313930332C39373833313336312C39373833333230322C39373931373233382C39373932393836302C39373933373439342C39373935393635332C39373937383533352C39383036363235372C39383132313430372C39383135393032372C,0x39373331373239302C39373332303631342C39373333363737362C39373433313339322C39373437333133382C39373534333532322C39373534343434312C39373631313738382C39373632303630352C39373638383336372C39373735343038352C39373738373838382C39373831323131342C39373833313533312C39373833333331302C39373931373332362C39373932393934322C39373933373639312C39373935393831352C39373937383632332C39383036363334302C39383132313531382C39383135393230322C),
 (20,'sawda.bApr07','chr1','+',97503556,97561099,0,0,4,0x39373530333535362C39373534343333322C39373534363533332C39373536303835302C,0x39373530333632312C39373534343435332C39373534363536382C39373536313039392C),
 (21,'LOC440597.bApr07','chr1','-',103733288,103840693,103733384,103748272,4,0x3130333733333238382C3130333734343439362C3130333734383130302C3130333834303630352C,0x3130333733333433342C3130333734343538332C3130333734383330362C3130333834303639332C),
 (21,'LOC440597.aApr07','chr1','-',103733963,103840671,103733966,103748272,5,0x3130333733333936332C3130333734343439362C3130333734383130302C3130333738343535312C3130333834303630352C,0x3130333733343032352C3130333734343538332C3130333734383330362C3130333738343630302C3130333834303637312C),
 (21,'VAV3.dApr07','chr1','-',107915298,108032648,107917475,108032576,10,0x3130373931353239382C3130373931383139312C3130373934303335362C3130373934363534312C3130373934373139312C3130373935343037352C3130373936313731312C3130373938363736332C3130383032373633322C3130383033323532352C,0x3130373931373531372C3130373931383334332C3130373934303438362C3130373934363632392C3130373934373330382C3130373935343131302C3130373936313737372C3130373938363930302C3130383032373637382C3130383033323634382C),
 (21,'VAV3.aApr07','chr1','-',107915298,108309296,107917475,108309014,27,0x3130373931353239382C3130373931383139312C3130373934303335362C3130373934363534312C3130373934373139312C3130373935343037352C3130373936313731312C3130373938363736332C3130383032373633322C3130383033323532352C3130383034383639342C3130383034393130342C3130383039333131322C3130383039333630362C3130383039353236312C3130383039393537312C3130383130313430352C3130383130343932382C3130383130393232302C3130383131303539312C3130383131323538352C3130383131343738302C3130383131363837392C3130383132313337352C3130383132333537382C3130383231393034352C3130383330383831302C,0x3130373931373531372C3130373931383334332C3130373934303438362C3130373934363632392C3130373934373330382C3130373935343131302C3130373936313737372C3130373938363930302C3130383032373637382C3130383033323535312C3130383034383739352C3130383034393230362C3130383039333232322C3130383039333733392C3130383039353334372C3130383039393635382C3130383130313437342C3130383130353032342C3130383130393332302C3130383131303639352C3130383131323635342C3130383131343837332C3130383131363938382C3130383132313434312C3130383132333633372C3130383231393136322C3130383330393239362C),
 (21,'VAV3.bApr07','chr1','-',107917313,108129769,107917475,108129641,26,0x3130373931373331332C3130373931383139312C3130373934303335362C3130373934363534312C3130373934373139312C3130373935343037352C3130373936313731312C3130373938363736332C3130383032373633322C3130383033323532352C3130383034383639342C3130383034393130342C3130383039333131322C3130383039333630362C3130383039353236312C3130383039393537312C3130383130313430352C3130383130343932382C3130383130393232302C3130383131303539312C3130383131323538352C3130383131343738302C3130383131363837392C3130383132313337352C3130383132333537382C3130383132393630322C,0x3130373931373531372C3130373931383334332C3130373934303438362C3130373934363632392C3130373934373330382C3130373935343131302C3130373936313737372C3130373938363930302C3130383032373637382C3130383033323535312C3130383034383739352C3130383034393230362C3130383039333232322C3130383039333733392C3130383039353334372C3130383039393635382C3130383130313437342C3130383130353032342C3130383130393332302C3130383131303639352C3130383131323635342C3130383131343837332C3130383131363938382C3130383132313434312C3130383132333633372C3130383132393736392C),
 (21,'VAV3.fApr07','chr1','-',107940458,108032638,107940459,107986889,7,0x3130373934303435382C3130373934363534312C3130373934373139312C3130373935343037352C3130373936313731312C3130373938363736332C3130383033323532352C,0x3130373934303438362C3130373934363632392C3130373934373330382C3130373935343131302C3130373936313737372C3130373938363930302C3130383033323633382C),
 (21,'VAV3.eApr07','chr1','-',107940458,108049155,107940459,108049154,8,0x3130373934303435382C3130373934363534312C3130373934373139312C3130373935343037352C3130373936313731312C3130373938363736332C3130383034383639342C3130383034393130342C,0x3130373934303438362C3130373934363632392C3130373934373330382C3130373935343131302C3130373936313737372C3130373938363930302C3130383034383739352C3130383034393135352C),
 (21,'VAV3.kApr07','chr1','-',107947241,108032648,107953626,107986889,6,0x3130373934373234312C3130373935333536382C3130373935343037352C3130373936313731312C3130373938363736332C3130383033323532352C,0x3130373934373330382C3130373935333638342C3130373935343131302C3130373936313737372C3130373938363930302C3130383033323634382C),
 (21,'VAV3.jApr07','chr1','-',107953958,108032672,107954071,108032576,5,0x3130373935333935382C3130373936313731312C3130373938363736332C3130383032373633322C3130383033323532352C,0x3130373935343131302C3130373936313737372C3130373938363930302C3130383032373637382C3130383033323637322C),
 (22,'smeyvorbo.aApr07','chr1','+',110069963,110119382,0,0,4,0x3131303036393936332C3131303037363331392C3131303038313038342C3131303131393231362C,0x3131303037303231332C3131303037363439352C3131303038313238362C3131303131393338322C),
 (22,'EPS8L3.aApr07','chr1','-',110094222,110108172,110094535,110105894,19,0x3131303039343232322C3131303039343830342C3131303039353432322C3131303039353739382C3131303039363133392C3131303039363833302C3131303039373236312C3131303130313136312C3131303130313632352C3131303130313934362C3131303130323038382C3131303130323436302C3131303130323636382C3131303130333230362C3131303130333338322C3131303130333832322C3131303130353633392C3131303130353836332C3131303130373936362C,0x3131303039343534372C3131303039343933372C3131303039353439362C3131303039353932372C3131303039363333382C3131303039363836352C3131303039373334332C3131303130313331302C3131303130313730302C3131303130323030382C3131303130323230332C3131303130323537362C3131303130323831312C3131303130333236322C3131303130333533322C3131303130333938312C3131303130353730342C3131303130353931382C3131303130383137322C),
 (22,'EPS8L3.cApr07','chr1','-',110094224,110108087,110094535,110105894,19,0x3131303039343232342C3131303039343830342C3131303039353432322C3131303039353739382C3131303039363133392C3131303039363833302C3131303039373236312C3131303130313136312C3131303130313632352C3131303130313934362C3131303130323038382C3131303130323436302C3131303130323636382C3131303130333230362C3131303130333338322C3131303130333832322C3131303130353633392C3131303130353836332C3131303130373936362C,0x3131303039343534372C3131303039343933372C3131303039353439362C3131303039353932372C3131303039363234382C3131303039363836352C3131303039373334332C3131303130313331302C3131303130313730302C3131303130323030382C3131303130323230332C3131303130323537362C3131303130323830382C3131303130333236322C3131303130333533322C3131303130333938312C3131303130353730342C3131303130353931382C3131303130383038372C),
 (22,'EPS8L3.bApr07','chr1','-',110094224,110108087,110094535,110105894,19,0x3131303039343232342C3131303039343830342C3131303039353432322C3131303039353739382C3131303039363133392C3131303039363833302C3131303039373236312C3131303130313136312C3131303130313632352C3131303130313934362C3131303130323038382C3131303130323436302C3131303130323636382C3131303130333230362C3131303130333338322C3131303130333832322C3131303130353633392C3131303130353836332C3131303130373936362C,0x3131303039343534372C3131303039343933372C3131303039353439362C3131303039353932372C3131303039363333382C3131303039363836352C3131303039373334332C3131303130313331302C3131303130313730302C3131303130323030382C3131303130323230332C3131303130323537362C3131303130323830382C3131303130333236322C3131303130333533322C3131303130333938312C3131303130353730342C3131303130353931382C3131303130383038372C),
 (22,'KCND3.bApr07','chr1','-',112119964,112333300,112120221,112326871,7,0x3131323131393936342C3131323132313137302C3131323132343336392C3131323132343833342C3131323133313038382C3131323332353736352C3131323333323839322C,0x3131323132303432332C3131323132313431382C3131323132343435392C3131323132343933362C3131323133313235312C3131323332363934332C3131323333333330302C),
 (22,'KCND3.aApr07','chr1','-',112119967,112333300,112120221,112326871,8,0x3131323131393936372C3131323132313137302C3131323132323538302C3131323132343336392C3131323132343833342C3131323133313038382C3131323332353736352C3131323333323839322C,0x3131323132303432332C3131323132313431382C3131323132323633372C3131323132343435392C3131323132343933362C3131323133313235312C3131323332363934332C3131323333333330302C),
 (22,'HIPK1.bApr07','chr1','+',114273395,114322014,114273397,114317657,16,0x3131343237333339352C3131343238343532362C3131343239363931302C3131343239383739352C3131343239393730372C3131343330303737312C3131343330313236382C3131343330323231302C3131343330363436312C3131343330373533312C3131343331303237342C3131343331313931302C3131343331323538362C3131343331343130302C3131343331353936382C3131343331373136382C,0x3131343237333637372C3131343238353630342C3131343239373033342C3131343239383931352C3131343239393739342C3131343330303935362C3131343330313433312C3131343330323433362C3131343330363538332C3131343330373636362C3131343331303431372C3131343331323039332C3131343331323739332C3131343331343334322C3131343331363039392C3131343332323031342C),
 (22,'HIPK1.cApr07','chr1','+',114273513,114316218,114273514,114316183,15,0x3131343237333531332C3131343238343532362C3131343239363931302C3131343239383739352C3131343239393730372C3131343330303737312C3131343330313236382C3131343330323231302C3131343330363436312C3131343330373533312C3131343331303237342C3131343331313931302C3131343331323538362C3131343331343130302C3131343331353936382C,0x3131343237333637372C3131343238353630342C3131343239373033342C3131343239383931352C3131343239393739342C3131343330303935362C3131343330313433312C3131343330323433362C3131343330363538332C3131343330373636362C3131343331303431372C3131343331323039332C3131343331323739332C3131343331343334322C3131343331363231382C),
 (22,'HIPK1.aApr07','chr1','+',114273797,114318110,114273798,114317657,16,0x3131343237333739372C3131343238343532362C3131343239363931302C3131343239383739352C3131343239393730372C3131343330303737312C3131343330313236382C3131343330323231302C3131343330363436312C3131343330373533312C3131343331303237342C3131343331313931302C3131343331323538362C3131343331343130302C3131343331353936382C3131343331373136382C,0x3131343237343038342C3131343238353630342C3131343239373033342C3131343239383931352C3131343239393739342C3131343330303935362C3131343330313433312C3131343330323433362C3131343330363538332C3131343330373636362C3131343331303431372C3131343331323039332C3131343331323739332C3131343331343334322C3131343331363039392C3131343331383131302C),
 (22,'SLC22A15.aApr07','chr1','+',116320641,116414198,116320642,116411252,12,0x3131363332303634312C3131363333363137342C3131363336333732352C3131363336343836342C3131363337313033362C3131363337353530392C3131363337393333302C3131363338313434362C3131363430363930352C3131363430383537392C3131363431303636332C3131363431313136322C,0x3131363332303835382C3131363333363338372C3131363336333835382C3131363336353032392C3131363337313136362C3131363337353732352C3131363337393437312C3131363338313533322C3131363430373032362C3131363430383635322C3131363431303835322C3131363431343139382C),
 (22,'SLC22A15.bApr07','chr1','+',116378881,116411409,116379190,116411252,6,0x3131363337383838312C3131363338313434362C3131363430363930352C3131363430383537392C3131363431303636332C3131363431313136322C,0x3131363337393437312C3131363338313533322C3131363430373032362C3131363430383635322C3131363431303835322C3131363431313430392C),
 (23,'SPAG17.aApr07','chr1','-',118297810,118529370,118307944,118529303,49,0x3131383239373831302C3131383330373934342C3131383331303735342C3131383331343230312C3131383331363030382C3131383331373537302C3131383332353431352C3131383332373935362C3131383332383832382C3131383333313937392C3131383333323235302C3131383333353030362C3131383333353536302C3131383333363631312C3131383333383535312C3131383334303531352C3131383334303734332C3131383334393535392C3131383335323138392C3131383335363337332C3131383336303131302C3131383336373434392C3131383336393338332C3131383337323431392C3131383337353833372C3131383338303931352C3131383338333433372C3131383338343837352C3131383338353934382C3131383339383134372C3131383339393837382C3131383431303839302C3131383431373939392C3131383431383638342C3131383432353234362C3131383432353536302C3131383433303036372C3131383433303831362C3131383433313031362C3131383433353735312C3131383433363037352C3131383433373330312C3131383434313831352C3131383434333735312C3131383434353838352C3131383435393435352C3131383439343638382C3131383439353337342C3131383532393231362C,0x3131383239383139352C3131383330383038342C3131383331303839392C3131383331343236322C3131383331363139332C3131383331373730372C3131383332353534372C3131383332383035392C3131383332383932382C3131383333323032372C3131383333323335302C3131383333353035322C3131383333353637342C3131383333363739342C3131383333383637362C3131383334303634362C3131383334303838392C3131383334393734382C3131383335323334342C3131383335363531382C3131383336303332382C3131383336373630392C3131383336393536322C3131383337323534302C3131383337363031332C3131383338313032392C3131383338333539302C3131383338343938372C3131383338363138382C3131383339383233392C3131383430303036302C3131383431313034352C3131383431383131332C3131383431383734362C3131383432353436352C3131383432353738382C3131383433303231382C3131383433303933302C3131383433313135342C3131383433353836342C3131383433363134382C3131383433373436332C3131383434313939372C3131383434333934362C3131383434363037322C3131383435393538372C3131383439343737352C3131383439353531352C3131383532393337302C),
 (23,'SPAG17.nApr07','chr1','-',118487771,118625426,0,0,8,0x3131383438373737312C3131383438393330352C3131383439303334312C3131383439343638382C3131383439353337342C3131383536373136362C3131383632333931332C3131383632353238372C,0x3131383438383138322C3131383438393435362C3131383439303437392C3131383439343737352C3131383439353531352C3131383536373234342C3131383632333937372C3131383632353432362C),
 (23,'fleyboy.gApr07','chr1','+',119484856,119620119,0,0,7,0x3131393438343835362C3131393438353839322C3131393439313039382C3131393439343731302C3131393630353539322C3131393630373034372C3131393631393333332C,0x3131393438343933392C3131393438353935392C3131393439313231352C3131393439343839322C3131393630353836322C3131393630373039302C3131393632303131392C),
 (23,'fleyboy.hApr07','chr1','+',119484870,119578319,0,0,5,0x3131393438343837302C3131393438353839322C3131393439313039382C3131393439343731302C3131393537373630332C,0x3131393438343933392C3131393438353935392C3131393439313231352C3131393439343839322C3131393537383331392C),
 (26,'PDE4DIP.bApr07','chr1','-',143562782,143706390,143563814,143706088,44,0x3134333536323738322C3134333536353532312C3134333536353837342C3134333536373039362C3134333536383137322C3134333536383936382C3134333537313131352C3134333537343637342C3134333537353439312C3134333537373136362C3134333537373934382C3134333537393237372C3134333538333035322C3134333538353233332C3134333538363033372C3134333538373333332C3134333538383339322C3134333539303339312C3134333539323039382C3134333539323738362C3134333539333830322C3134333539373435332C3134333630333835372C3134333631343433332C3134333631353938312C3134333631373431352C3134333631373737372C3134333632313232352C3134333632333233382C3134333632333438362C3134333632363830312C3134333632373932362C3134333632383835352C3134333632393137352C3134333633303138392C3134333633333139312C3134333633333534332C3134333633333837352C3134333633353034362C3134333635373938312C3134333636333535372C3134333636333932322C3134333636363537322C3134333730353934372C,0x3134333536333835362C3134333536353536382C3134333536363031332C3134333536373234302C3134333536383339392C3134333536393038352C3134333537313335352C3134333537343739392C3134333537353638312C3134333537373238362C3134333537383038302C3134333537393532392C3134333538333233382C3134333538353338362C3134333538363236312C3134333538373338352C3134333538383632382C3134333539303932302C3134333539323231382C3134333539323937392C3134333539343233382C3134333539373638362C3134333630333934362C3134333631343536312C3134333631363039342C3134333631373535332C3134333631373839342C3134333632313331372C3134333632333332302C3134333632333635312C3134333632363939362C3134333632383130362C3134333632383939332C3134333632393238392C3134333633303334382C3134333633333430342C3134333633333633362C3134333633333939352C3134333633353137382C3134333635383039392C3134333636333733332C3134333636343034362C3134333636363634392C3134333730363339302C),
 (26,'PDE4DIP.cApr07','chr1','-',143562784,143751358,143563814,143750966,46,0x3134333536323738342C3134333536353532312C3134333536353837342C3134333536373039362C3134333536383137322C3134333536383936382C3134333537313131352C3134333537343637342C3134333537353439312C3134333537373136362C3134333537373934382C3134333537393237372C3134333538353233332C3134333538363033372C3134333538373333332C3134333538383339322C3134333539303339312C3134333539323039382C3134333539323738362C3134333539343133322C3134333539373435332C3134333630333835372C3134333631343433332C3134333631353938312C3134333631373431352C3134333631373737372C3134333632313232352C3134333632333233382C3134333632333438362C3134333632363830312C3134333632373932362C3134333632383835352C3134333632393137352C3134333633303138392C3134333633333139312C3134333633333534332C3134333633333837352C3134333633353034362C3134333635373938312C3134333636333535372C3134333636333932322C3134333636363537322C3134333730353934372C3134333732373231362C3134333733323436382C3134333735303934362C,0x3134333536333835362C3134333536353536382C3134333536363031332C3134333536373234302C3134333536383339392C3134333536393038352C3134333537313335352C3134333537343739392C3134333537353638312C3134333537373238362C3134333537383038302C3134333537393532392C3134333538353338362C3134333538363236312C3134333538373338352C3134333538383632382C3134333539303932302C3134333539323231382C3134333539323937392C3134333539343233382C3134333539373638362C3134333630333934362C3134333631343536312C3134333631363039342C3134333631373535332C3134333631373839342C3134333632313331372C3134333632333332302C3134333632333635312C3134333632363939362C3134333632383130362C3134333632383939332C3134333632393238392C3134333633303334382C3134333633333430342C3134333633333633362C3134333633333939352C3134333633353137382C3134333635383039392C3134333636333733332C3134333636343034362C3134333636363634392C3134333730363035382C3134333732373336382C3134333733323532342C3134333735313335382C),
 (26,'PDE4DIP.aApr07','chr1','-',143562784,143706278,143563710,143706088,44,0x3134333536323738342C3134333536353532312C3134333536353837342C3134333536373039362C3134333536383137322C3134333536383936382C3134333537313131352C3134333537343637342C3134333537353439312C3134333537373136362C3134333537373934382C3134333537393237372C3134333538333035322C3134333538353233332C3134333538363033372C3134333538373333332C3134333538383339322C3134333539303339312C3134333539323039382C3134333539323738362C3134333539333830322C3134333539373435332C3134333630333835372C3134333631343433332C3134333631353938312C3134333631373431352C3134333631373737372C3134333632313232352C3134333632333233382C3134333632333438362C3134333632363830312C3134333632373932362C3134333632383835352C3134333632393137352C3134333633303138392C3134333633333139312C3134333633333534332C3134333633333837352C3134333633353034362C3134333635373938312C3134333636333535372C3134333636333932322C3134333636363537322C3134333730353934372C,0x3134333536333830302C3134333536353536382C3134333536363031332C3134333536373234302C3134333536383339392C3134333536393038352C3134333537313335352C3134333537343739392C3134333537353638312C3134333537373238362C3134333537383038302C3134333537393532392C3134333538333233382C3134333538353338362C3134333538363236312C3134333538373338352C3134333538383632382C3134333539303932302C3134333539323231382C3134333539323937392C3134333539343233382C3134333539373638362C3134333630333934362C3134333631343536312C3134333631363039342C3134333631373535332C3134333631373839342C3134333632313331372C3134333632333332302C3134333632333635312C3134333632363939362C3134333632383130362C3134333632383939332C3134333632393238392C3134333633303334382C3134333633333430342C3134333633333633362C3134333633333939352C3134333633353137382C3134333635383039392C3134333636333733332C3134333636343034362C3134333636363634392C3134333730363237382C),
 (26,'PDE4DIP.fApr07','chr1','-',143601947,143706379,143603570,143706088,23,0x3134333630313934372C3134333630333835372C3134333631343433332C3134333631353938312C3134333631373431352C3134333631373737372C3134333632313232352C3134333632333233382C3134333632333438362C3134333632363830312C3134333632373932362C3134333632383835352C3134333632393137352C3134333633303138392C3134333633333139312C3134333633333534332C3134333633333837352C3134333633353034362C3134333635373938312C3134333636333535372C3134333636333932322C3134333636363537322C3134333730353934372C,0x3134333630333537362C3134333630333934362C3134333631343536312C3134333631363039342C3134333631373535332C3134333631373839342C3134333632313331372C3134333632333332302C3134333632333635312C3134333632363939362C3134333632383130362C3134333632383939332C3134333632393238392C3134333633303334382C3134333633333430342C3134333633333633362C3134333633333939352C3134333633353137382C3134333635383039392C3134333636333733332C3134333636343034362C3134333636363634392C3134333730363337392C),
 (26,'PDE4DIP.eApr07','chr1','-',143601950,143706198,143603794,143706196,22,0x3134333630313935302C3134333631343433332C3134333631353938312C3134333631373431352C3134333631373737372C3134333632313232352C3134333632333233382C3134333632333438362C3134333632363830312C3134333632373932362C3134333632383835352C3134333632393137352C3134333633303138392C3134333633333139312C3134333633333534332C3134333633333837352C3134333633353034362C3134333635373938312C3134333636333535372C3134333636333932322C3134333636363537322C3134333730353934372C,0x3134333630333934362C3134333631343536312C3134333631363039342C3134333631373535332C3134333631373839342C3134333632313331372C3134333632333332302C3134333632333635312C3134333632363939362C3134333632383130362C3134333632383939332C3134333632393238392C3134333633303334382C3134333633333430342C3134333633333633362C3134333633333939352C3134333633353137382C3134333635383039392C3134333636333733332C3134333636343034362C3134333636363634392C3134333730363139382C),
 (26,'PDE4DIP.gApr07','chr1','-',143614056,143659962,143614386,143659958,18,0x3134333631343035362C3134333631353938312C3134333631373431352C3134333631373737372C3134333632313232352C3134333632333233382C3134333632333438362C3134333632363830312C3134333632373932362C3134333632383835352C3134333632393137352C3134333633303138392C3134333633333139312C3134333633333534332C3134333633333837352C3134333633353034362C3134333635373938312C3134333635393934312C,0x3134333631343536312C3134333631363039342C3134333631373535332C3134333631373839342C3134333632313331372C3134333632333332302C3134333632333635312C3134333632363939362C3134333632383130362C3134333632383939332C3134333632393238392C3134333633303334382C3134333633333430342C3134333633333633362C3134333633333939352C3134333633353137382C3134333635383039392C3134333635393936322C);
INSERT INTO `aceview_hg18_housekeeping` (`bin`,`name`,`chrom`,`strand`,`txStart`,`txEnd`,`cdsStart`,`cdsEnd`,`exonCount`,`exonStarts`,`exonEnds`) VALUES 
 (26,'blareybu.aApr07','chr1','+',144691178,144724238,144691180,144724077,4,0x3134343639313137382C3134343732323432392C3134343732333439372C3134343732343035302C,0x3134343639313333392C3134343732323630332C3134343732333631312C3134343732343233382C),
 (26,'jazerbo.aApr07-unspliced','chr1','+',144703247,144704134,144703675,144704056,1,0x3134343730333234372C,0x3134343730343133342C),
 (26,'FAM91A2.bApr07','chr1','+',147842378,147943908,147842966,147943373,3,0x3134373834323337382C3134373834343233312C3134373934333336392C,0x3134373834333332342C3134373834343238362C3134373934333930382C),
 (26,'FAM91A2.dApr07','chr1','+',147842804,147883410,147842805,147882411,4,0x3134373834323830342C3134373834333232362C3134373838323338382C3134373838333136392C,0x3134373834333031312C3134373834333332342C3134373838323733352C3134373838333431302C),
 (26,'FAM91A2.nApr07','chr1','+',147842974,147939357,0,0,3,0x3134373834323937342C3134373933363833322C3134373933383932342C,0x3134373834333332342C3134373933373037362C3134373933393335372C),
 (26,'FAM91A2.cApr07','chr1','+',147842985,147931613,147842987,147931108,2,0x3134373834323938352C3134373933313039312C,0x3134373834333332342C3134373933313631332C),
 (26,'FAM91A2.sApr07','chr1','+',147843091,147858312,0,0,3,0x3134373834333039312C3134373835373730312C3134373835383231322C,0x3134373834333332342C3134373835373836312C3134373835383331322C),
 (26,'FAM91A2.hApr07','chr1','+',147843091,147883245,147882488,147883198,3,0x3134373834333039312C3134373838323338382C3134373838333136392C,0x3134373834333332342C3134373838323733352C3134373838333234352C),
 (26,'FAM91A2.aApr07','chr1','+',147843098,147883410,147843401,147844112,3,0x3134373834333039382C3134373838323338382C3134373838333136392C,0x3134373834343238362C3134373838323835342C3134373838333431302C),
 (26,'FAM91A2.eApr07','chr1','+',147843106,147883410,147882488,147882815,2,0x3134373834333130362C3134373838323338382C,0x3134373834333332342C3134373838333431302C),
 (26,'FAM91A2.rApr07','chr1','+',147843113,147938435,0,0,3,0x3134373834333131332C3134373933363833322C3134373933383334352C,0x3134373834333332342C3134373933373037362C3134373933383433352C),
 (26,'FAM91A2.mApr07','chr1','+',147843113,147938975,147937073,147938973,4,0x3134373834333131332C3134373933363833322C3134373933383339352C3134373933383932342C,0x3134373834333332342C3134373933373037362C3134373933383438342C3134373933383937352C),
 (26,'FAM91A2.iApr07','chr1','+',147843113,147939017,147843236,147936905,4,0x3134373834333131332C3134373834343233312C3134373933363833322C3134373933383932342C,0x3134373834333332342C3134373834343238362C3134373933373037362C3134373933393031372C),
 (26,'FAM91A2.gApr07','chr1','+',147843113,147939256,147843236,147939133,2,0x3134373834333131332C3134373933383932342C,0x3134373834333332342C3134373933393235362C),
 (26,'FAM91A2.lApr07','chr1','+',147843201,147931610,147843203,147931040,2,0x3134373834333230312C3134373933303939302C,0x3134373834333332342C3134373933313631302C),
 (26,'FAM91A2.kApr07','chr1','+',147843216,147858516,147843218,147857729,4,0x3134373834333231362C3134373834343233312C3134373835373730312C3134373835383231322C,0x3134373834333332342C3134373834343238362C3134373835373836312C3134373835383531362C),
 (26,'GOLPH3L.aApr07','chr1','-',148885324,148936295,148887420,148933938,5,0x3134383838353332342C3134383930303931332C3134383930323733312C3134383933333735352C3134383933363039312C,0x3134383838373834382C3134383930313032382C3134383930323836332C3134383933333935302C3134383933363239352C),
 (26,'GOLPH3L.dApr07','chr1','-',148887443,148936210,148887444,148933938,4,0x3134383838373434332C3134383930303931332C3134383933333735352C3134383933363039312C,0x3134383838373834382C3134383930313032382C3134383933333935302C3134383933363231302C),
 (26,'GOLPH3L.bApr07','chr1','-',148887523,148936283,148887525,148933938,6,0x3134383838373532332C3134383930303931332C3134383930323733312C3134383933333230372C3134383933333735352C3134383933363039312C,0x3134383838373834382C3134383930313032382C3134383930323836332C3134383933333237332C3134383933333935302C3134383933363238332C),
 (26,'GOLPH3L.cApr07','chr1','-',148887561,148936248,148887561,148933938,5,0x3134383838373536312C3134383930303931332C3134383930323733312C3134383933333735352C3134383933363039312C,0x3134383838373834382C3134383930313032382C3134383930323836332C3134383933333934342C3134383933363234382C),
 (26,'GOLPH3L.gApr07','chr1','-',148887732,148936221,148887809,148933938,4,0x3134383838373733322C3134383930323733312C3134383933333735352C3134383933363039312C,0x3134383838373834382C3134383930323836332C3134383933333935302C3134383933363232312C),
 (26,'TNRC4.aApr07','chr1','-',149939158,149955901,149944140,149955120,13,0x3134393933393135382C3134393934343133302C3134393934343932312C3134393934353332332C3134393934353736382C3134393934363234342C3134393934363630362C3134393934363839312C3134393934383039372C3134393934383331392C3134393934383834322C3134393935333639332C3134393935343937352C,0x3134393934323534382C3134393934343236382C3134393934353036352C3134393934353436312C3134393934353833342C3134393934363339342C3134393934363734382C3134393934373033352C3134393934383137372C3134393934383434382C3134393934383839312C3134393935333737362C3134393935353930312C),
 (26,'smuporbo.aApr07','chr1','+',149940125,149947493,0,0,2,0x3134393934303132352C3134393934373231332C,0x3134393934303233382C3134393934373439332C),
 (26,'TNRC4.cApr07','chr1','-',149941494,149955895,149944140,149955120,13,0x3134393934313439342C3134393934343133302C3134393934343932312C3134393934353332332C3134393934353736382C3134393934363234342C3134393934363630362C3134393934363839312C3134393934383039372C3134393934383331392C3134393934383834322C3134393935333639332C3134393935343937352C,0x3134393934323534382C3134393934343236382C3134393934353036352C3134393934353435382C3134393934353833342C3134393934363339342C3134393934363734382C3134393934373033352C3134393934383137372C3134393934383434382C3134393934383839312C3134393935333737362C3134393935353839352C),
 (26,'TNRC4.eApr07','chr1','-',149941501,149955416,149944140,149954722,13,0x3134393934313530312C3134393934343133302C3134393934343932312C3134393934353332332C3134393934353736382C3134393934363234342C3134393934363630362C3134393934363839312C3134393934383039372C3134393934383331392C3134393934383834322C3134393935333639332C3134393935343731382C,0x3134393934323534382C3134393934343236382C3134393934353036352C3134393934353436312C3134393934353833342C3134393934363339342C3134393934363734382C3134393934373033352C3134393934383137372C3134393934383434382C3134393934383839312C3134393935333737362C3134393935353431362C),
 (26,'TNRC4.bApr07','chr1','-',149941504,149955901,149944140,149955120,14,0x3134393934313530342C3134393934343133302C3134393934343932312C3134393934353332332C3134393934353736382C3134393934363234342C3134393934363630362C3134393934363839312C3134393934383039372C3134393934383331392C3134393934383834322C3134393935333639332C3134393935343937352C3134393935353835342C,0x3134393934323534382C3134393934343236382C3134393934353036352C3134393934353436312C3134393934353833342C3134393934363339342C3134393934363734382C3134393934373033352C3134393934383137372C3134393934383434352C3134393934383839312C3134393935333737362C3134393935353638332C3134393935353930312C),
 (26,'TNRC4.dApr07','chr1','-',149941510,149955152,149944140,149955150,12,0x3134393934313531302C3134393934343133302C3134393934343932312C3134393934353332332C3134393934353736382C3134393934363630362C3134393934363839312C3134393934383039372C3134393934383331392C3134393934383834322C3134393935333639332C3134393935343937352C,0x3134393934323534382C3134393934343236382C3134393934353036352C3134393934353436312C3134393934353833342C3134393934363734382C3134393934373033352C3134393934383137372C3134393934383434382C3134393934383839312C3134393935333737362C3134393935353135322C),
 (26,'TNRC4.fApr07','chr1','-',149944140,149955506,149945058,149955120,12,0x3134393934343134302C3134393934343932312C3134393934353333342C3134393934353736382C3134393934363234342C3134393934363630362C3134393934363839312C3134393934383039372C3134393934383331392C3134393934383834322C3134393935333639332C3134393935343937352C,0x3134393934343236382C3134393934353036352C3134393934353436312C3134393934353833342C3134393934363339342C3134393934363734382C3134393934373033352C3134393934383137372C3134393934383434382C3134393934383839312C3134393935333737362C3134393935353530362C),
 (27,'KCNN3.aApr07','chr1','-',152943447,153109380,152947075,153109064,9,0x3135323934333434372C3135323934343837392C3135323935323536332C3135323935333937352C3135323936353031352C3135323937323130322C3135333031313037342C3135333036313138382C3135333130383133312C,0x3135323934333939372C3135323934373337322C3135323935323633332C3135323935343130332C3135323936353132362C3135323937323234342C3135333031313439332C3135333036313238342C3135333130393338302C),
 (27,'KCNN3.bApr07','chr1','-',152946508,153098964,152947075,153098812,8,0x3135323934363530382C3135323935323536332C3135323935333937352C3135323936353031352C3135323937323130322C3135333031313037342C3135333036313138382C3135333039383739342C,0x3135323934373337322C3135323935323633332C3135323935343130332C3135323936353132362C3135323937323234342C3135333031313439332C3135333036313238342C3135333039383936342C),
 (27,'KCNN3.cApr07','chr1','-',152947051,153107419,152947075,153061278,8,0x3135323934373035312C3135323935323536332C3135323935333937352C3135323936353031352C3135323937323130322C3135333031313037342C3135333036313138382C3135333130373034382C,0x3135323934373337322C3135323935323633332C3135323935343130332C3135323936353132362C3135323937323234342C3135333031313439332C3135333036313238342C3135333130373431392C),
 (27,'RIT1.cApr07','chr1','-',154134046,154147820,154136802,154147176,6,0x3135343133343034362C3135343134303732352C3135343134313134352C3135343134363836342C3135343134373037302C3135343134373635372C,0x3135343133373033332C3135343134303931372C3135343134313231392C3135343134363932312C3135343134373231392C3135343134373832302C),
 (27,'RIT1.dApr07','chr1','-',154136516,154147787,154136802,154146919,5,0x3135343133363531362C3135343134303732352C3135343134313134352C3135343134363836342C3135343134373635372C,0x3135343133373033332C3135343134303931372C3135343134313231392C3135343134363932312C3135343134373738372C),
 (27,'RIT1.aApr07','chr1','-',154136556,154142039,154136802,154141924,3,0x3135343133363535362C3135343134313437362C3135343134313736332C,0x3135343133363934332C3135343134313532332C3135343134323033392C),
 (27,'RIT1.bApr07','chr1','-',154136791,154147330,154136802,154147300,6,0x3135343133363739312C3135343134303732352C3135343134313134352C3135343134363836342C3135343134373037302C3135343134373239322C,0x3135343133373033332C3135343134303931372C3135343134313231392C3135343134363932312C3135343134373231392C3135343134373333302C),
 (27,'RIT1.eApr07','chr1','-',154137008,154147297,154137009,154147176,5,0x3135343133373030382C3135343134303732352C3135343134313134352C3135343134363836342C3135343134373037302C,0x3135343133373033332C3135343134303931372C3135343134313231392C3135343134363932312C3135343134373239372C),
 (27,'ARHGEF11.bApr07','chr1','-',155171255,155282086,155172415,155280746,40,0x3135353137313235352C3135353137333233312C3135353137333636342C3135353137343833332C3135353137353936332C3135353137363632322C3135353137373738372C3135353137383237392C3135353137393130352C3135353138303335302C3135353138303737332C3135353138313433342C3135353138323436302C3135353138333037372C3135353138333335312C3135353138333731392C3135353138343138342C3135353138343539362C3135353138343733342C3135353138373938382C3135353139313330372C3135353139323131382C3135353139323833352C3135353139343230372C3135353139353135372C3135353139353436312C3135353139363833332C3135353139383039322C3135353139393631382C3135353139393933352C3135353230343430322C3135353230353639372C3135353230363431332C3135353231333339382C3135353231343631392C3135353231353634342C3135353231363835322C3135353232303735342C3135353232323439372C3135353238303731342C,0x3135353137323437342C3135353137333432312C3135353137333931322C3135353137343932392C3135353137363332362C3135353137363834312C3135353137373834392C3135353137383430352C3135353137393139362C3135353138303531382C3135353138303834392C3135353138313631332C3135353138323537382C3135353138333230332C3135353138333433312C3135353138333836362C3135353138343337322C3135353138343634342C3135353138343931342C3135353138383131352C3135353139313333372C3135353139323231352C3135353139323938302C3135353139343233312C3135353139353238302C3135353139353535382C3135353139363837362C3135353139383139312C3135353139393732302C3135353230303031302C3135353230343534302C3135353230353737342C3135353230363435392C3135353231333437302C3135353231343739382C3135353231353730322C3135353231363930322C3135353232303835332C3135353232323538392C3135353238323038362C),
 (27,'ARHGEF11.aApr07','chr1','-',155171255,155281795,155172415,155280746,41,0x3135353137313235352C3135353137333233312C3135353137333636342C3135353137343833332C3135353137353936332C3135353137363632322C3135353137373738372C3135353137383237392C3135353137393130352C3135353138303335302C3135353138303737332C3135353138313433342C3135353138323436302C3135353138333037372C3135353138333335312C3135353138333731392C3135353138343138342C3135353138343539362C3135353138343733342C3135353138373938382C3135353139313330372C3135353139323131382C3135353139323833352C3135353139343230372C3135353139353135372C3135353139353436312C3135353139363833332C3135353139383039322C3135353139393631382C3135353139393933352C3135353230343430322C3135353230353639372C3135353230363431332C3135353230383131322C3135353231333339382C3135353231343631392C3135353231353634342C3135353231363835322C3135353232303735342C3135353232323439372C3135353238303731342C,0x3135353137323437342C3135353137333432312C3135353137333931322C3135353137343932392C3135353137363332362C3135353137363834312C3135353137373834392C3135353137383430352C3135353137393139362C3135353138303531382C3135353138303834392C3135353138313631332C3135353138323537382C3135353138333230332C3135353138333433312C3135353138333836362C3135353138343337322C3135353138343634342C3135353138343931342C3135353138383131352C3135353139313333372C3135353139323231352C3135353139323938302C3135353139343233312C3135353139353238302C3135353139353535382C3135353139363837362C3135353139383139312C3135353139393732302C3135353230303031302C3135353230343534302C3135353230353737342C3135353230363435392C3135353230383233322C3135353231333437302C3135353231343739382C3135353231353730322C3135353231363930322C3135353232303835332C3135353232323538392C3135353238313739352C),
 (27,'ARHGEF11.iApr07','chr1','-',155184833,155194360,155184835,155192973,5,0x3135353138343833332C3135353138373938382C3135353139323131382C3135353139323833352C3135353139343230372C,0x3135353138343931342C3135353138383131352C3135353139323231352C3135353139323938302C3135353139343336302C),
 (27,'ARHGEF11.mApr07','chr1','-',155187988,155192876,155187990,155192874,4,0x3135353138373938382C3135353139313330372C3135353139323131382C3135353139323833352C,0x3135353138383131352C3135353139313333372C3135353139323231382C3135353139323837362C),
 (27,'KIRREL.bApr07','chr1','+',156229686,156332484,156230090,156331534,13,0x3135363232393638362C3135363331323532362C3135363331343430342C3135363332343136382C3135363332343431392C3135363332343734302C3135363332353931352C3135363332363133312C3135363332373737312C3135363332393735322C3135363333303033362C3135363333303732362C3135363333313035372C,0x3135363233303134322C3135363331323637362C3135363331343535342C3135363332343237342C3135363332343536382C3135363332343836382C3135363332363034322C3135363332363233322C3135363332373937302C3135363332393836302C3135363333303137362C3135363333303830342C3135363333323438342C),
 (27,'KIRREL.aApr07','chr1','+',156230023,156336679,156230024,156331534,15,0x3135363233303032332C3135363331323532362C3135363331343430342C3135363332303833352C3135363332333030392C3135363332343136382C3135363332343431392C3135363332343734302C3135363332353931352C3135363332363133312C3135363332373737312C3135363332393735322C3135363333303033362C3135363333303732362C3135363333313035372C,0x3135363233303134322C3135363331323637362C3135363331343535342C3135363332303939332C3135363332333136302C3135363332343237342C3135363332343536382C3135363332343836382C3135363332363034322C3135363332363233322C3135363332373937302C3135363332393836302C3135363333303137362C3135363333303830342C3135363333363637392C),
 (27,'IFI16.aApr07','chr1','+',157236381,157291562,157251082,157291315,12,0x3135373233363338312C3135373234363431362C3135373235313037342C3135373235323238352C3135373235343634322C3135373235363735342C3135373236383933372C3135373238313731302C3135373238353834352C3135373238383039322C3135373238393934362C3135373239313233342C,0x3135373233363830392C3135373234363537352C3135373235313335392C3135373235323430312C3135373235353036352C3135373235363934332C3135373236393130352C3135373238313837382C3135373238363031332C3135373238383531322C3135373239303133382C3135373239313536322C),
 (27,'IFI16.dApr07','chr1','+',157242376,157291532,157251082,157291315,11,0x3135373234323337362C3135373234363431362C3135373235313037342C3135373235323238352C3135373235323934362C3135373235343634322C3135373235363735342C3135373236383933372C3135373238383039322C3135373238393934362C3135373239313233342C,0x3135373234323435352C3135373234363537352C3135373235313335392C3135373235323430312C3135373235333131342C3135373235353036352C3135373235363934332C3135373236393130352C3135373238383531322C3135373239303133382C3135373239313533322C),
 (27,'IFI16.bApr07','chr1','+',157246306,157291576,157251082,157291315,11,0x3135373234363330362C3135373235313037342C3135373235323238352C3135373235323934362C3135373235343634322C3135373235363735342C3135373236383933372C3135373238353834352C3135373238383039322C3135373238393934362C3135373239313233342C,0x3135373234363537352C3135373235313335392C3135373235323430312C3135373235333131342C3135373235353036352C3135373235363934332C3135373236393130352C3135373238363031332C3135373238383531322C3135373239303133382C3135373239313537362C),
 (27,'IFI16.cApr07','chr1','+',157246335,157291569,157251082,157288644,10,0x3135373234363333352C3135373235313037342C3135373235323238352C3135373235323934362C3135373235343634322C3135373235363735342C3135373236383933372C3135373238353834352C3135373238383039322C3135373239313233342C,0x3135373234363537352C3135373235313335392C3135373235323430312C3135373235333131342C3135373235353036352C3135373235363934332C3135373236393130352C3135373238363031332C3135373239303133382C3135373239313536392C),
 (27,'IFI16.fApr07','chr1','+',157256527,157291559,157256808,157291278,6,0x3135373235363532372C3135373236383933372C3135373238313731302C3135373238383039322C3135373238393934362C3135373239313233342C,0x3135373235363934332C3135373236393130352C3135373238313837382C3135373238383531322C3135373239303034302C3135373239313535392C),
 (27,'IFI16.iApr07','chr1','+',157268503,157291569,157268979,157291315,4,0x3135373236383530332C3135373238383039322C3135373238393934362C3135373239313233342C,0x3135373236393130352C3135373238383531322C3135373239303133382C3135373239313536392C),
 (27,'IGSF8.bApr07','chr1','-',158327753,158335357,158328236,158335355,8,0x3135383332373735332C3135383332383232312C3135383332383639352C3135383332393333372C3135383333303132332C3135383333313238322C3135383333343832322C3135383333353234372C,0x3135383332383034352C3135383332383335322C3135383332393130392C3135383332393734352C3135383333303538352C3135383333313636302C3135383333343933312C3135383333353335372C),
 (27,'IGSF8.aApr07','chr1','-',158327753,158335112,158328236,158335069,7,0x3135383332373735332C3135383332383232312C3135383332383639352C3135383332393333372C3135383333303132332C3135383333313238322C3135383333343832322C,0x3135383332383032322C3135383332383335322C3135383332393130392C3135383332393734352C3135383333303538352C3135383333313636302C3135383333353131322C),
 (27,'IGSF8.dApr07','chr1','-',158329682,158335267,158329727,158331658,4,0x3135383332393638322C3135383333303132332C3135383333313238322C3135383333353234372C,0x3135383332393734312C3135383333303538352C3135383333313734362C3135383333353236372C),
 (27,'IGSF8.fApr07','chr1','-',158330532,158335243,158330532,158334886,4,0x3135383333303533322C3135383333313238322C3135383333343832322C3135383333353231322C,0x3135383333303538352C3135383333313636302C3135383333343933312C3135383333353234332C),
 (28,'NOS1AP.bApr07','chr1','+',160306187,160604852,160306591,160603881,10,0x3136303330363138372C3136303339303831382C3136303532333735372C3136303533373036312C3136303536393433302C3136303538303234382C3136303539313630302C3136303539333337332C3136303630313831372C3136303630333436352C,0x3136303330363639362C3136303339303839302C3136303532333835302C3136303533373132302C3136303536393533392C3136303538303339302C3136303539313736372C3136303539333535302C3136303630313938332C3136303630343835322C),
 (28,'NOS1AP.aApr07','chr1','+',160306204,160604864,160306591,160603881,10,0x3136303330363230342C3136303339303831382C3136303532333735372C3136303533373034362C3136303536393433302C3136303538303234382C3136303539313630302C3136303539333337332C3136303630313831372C3136303630333436352C,0x3136303330363639362C3136303339303839302C3136303532333835302C3136303533373132302C3136303536393533392C3136303538303339302C3136303539313736372C3136303539333535302C3136303630313938332C3136303630343836342C),
 (28,'RGS5.hApr07','chr1','-',161389023,161558165,161389023,161485008,6,0x3136313338393032332C3136313339383332382C3136313430343637312C3136313438343934332C3136313534323634362C3136313535383033352C,0x3136313338393133302C3136313339383339302C3136313430343738322C3136313438353031322C3136313534323734332C3136313535383136352C),
 (28,'RGS5.iApr07','chr1','-',161389063,161558200,161389065,161542696,6,0x3136313338393036332C3136313339383332382C3136313430343637312C3136313534323634362C3136313534343935372C3136313535383033352C,0x3136313338393133302C3136313339383339302C3136313430343738322C3136313534323734332C3136313534353034352C3136313535383230302C),
 (28,'RGS5.rApr07','chr1','-',161398367,161558185,0,0,6,0x3136313339383336372C3136313430343637312C3136313534323634362C3136313534343935372C3136313535353539352C3136313535383033352C,0x3136313339383339302C3136313430343738322C3136313534323734332C3136313534353034352C3136313535353730352C3136313535383138352C),
 (28,'NUF2.jApr07','chr1','+',161477352,161514066,161503728,161512723,4,0x3136313437373335322C3136313530333638332C3136313531323433322C3136313531333530392C,0x3136313437373438332C3136313530333735382C3136313531323830362C3136313531343036362C),
 (28,'LMX1A.dApr07','chr1','-',163437727,163592101,163439740,163591420,9,0x3136333433373732372C3136333434313732342C3136333434333932332C3136333434363535392C3136333434393530312C3136333438353236382C3136333538383933362C3136333539313334342C3136333539313933302C,0x3136333433393930312C3136333434313839352C3136333434333939332C3136333434363633372C3136333434393637342C3136333438353530312C3136333538393132332C3136333539313434322C3136333539323130312C),
 (28,'LMX1A.bApr07','chr1','-',163437728,163591641,163439740,163591420,8,0x3136333433373732382C3136333434313732342C3136333434333932332C3136333434363535392C3136333434393530312C3136333438353236382C3136333538383933362C3136333539313334342C,0x3136333433393930312C3136333434313839352C3136333434333939332C3136333434363633372C3136333434393637342C3136333438353530312C3136333538393132332C3136333539313634312C),
 (28,'LMX1A.cApr07','chr1','-',163437728,163592575,163439740,163591420,9,0x3136333433373732382C3136333434313732342C3136333434333932332C3136333434363535392C3136333434393530312C3136333438353236382C3136333538383933362C3136333539313334342C3136333539323231352C,0x3136333433393930312C3136333434313839352C3136333434333939332C3136333434363633372C3136333434393637342C3136333438353530312C3136333538393132332C3136333539313434322C3136333539323537352C),
 (28,'spervorbo.aApr07','chr1','-',164623710,164688496,0,0,3,0x3136343632333731302C3136343638383136342C3136343638383432322C,0x3136343632343232312C3136343638383236392C3136343638383439362C),
 (28,'CD247.fApr07','chr1','-',165666500,165754500,165667541,165754326,8,0x3136353636363530302C3136353636383838342C3136353636393838302C3136353637313235392C3136353637343433302C3136353637353230342C3136353637363532342C3136353735343236382C,0x3136353636373630372C3136353636383932302C3136353636393933372C3136353637313239322C3136353637343531312C3136353637353236312C3136353637363632382C3136353735343530302C),
 (28,'CD247.bApr07','chr1','-',165666501,165754388,165670695,165754326,7,0x3136353636363530312C3136353636383838342C3136353636393838302C3136353637343433302C3136353637353230342C3136353637363532342C3136353735343236382C,0x3136353636373630372C3136353636383932302C3136353637313239352C3136353637343531312C3136353637353236312C3136353637363632382C3136353735343338382C),
 (28,'CD247.cApr07','chr1','-',165666504,165754450,165667541,165754449,8,0x3136353636363530342C3136353636383838342C3136353636393838302C3136353637313235392C3136353637343433302C3136353637353230342C3136353637363532342C3136353735343236382C,0x3136353636373630372C3136353636383932302C3136353636393933372C3136353637313239352C3136353637343531312C3136353637353236312C3136353637363632382C3136353735343435302C),
 (28,'CD247.eApr07','chr1','-',165666505,165754389,165667541,165684285,10,0x3136353636363530352C3136353636373433372C3136353636383838342C3136353636393838302C3136353637313235392C3136353637343433302C3136353637353230342C3136353637363532342C3136353638343230332C3136353735343236382C,0x3136353636363837342C3136353636373630372C3136353636383932302C3136353636393933372C3136353637313239352C3136353637343531312C3136353637353236312C3136353637363632382C3136353638343334382C3136353735343338392C),
 (28,'CD247.oApr07','chr1','-',165666518,165675513,165667541,165674445,6,0x3136353636363531382C3136353636383838342C3136353636393838302C3136353637313235392C3136353637343433302C3136353637353230342C,0x3136353636373630372C3136353636383932302C3136353636393933372C3136353637313239322C3136353637343531312C3136353637353531332C),
 (28,'CD247.nApr07','chr1','-',165666528,165675504,165667541,165674445,6,0x3136353636363532382C3136353636383838342C3136353636393838302C3136353637313235392C3136353637343433302C3136353637353230342C,0x3136353636373630372C3136353636383932302C3136353636393933372C3136353637313239352C3136353637343531312C3136353637353530342C),
 (28,'CD247.aApr07','chr1','-',165668014,165754451,165668359,165754326,7,0x3136353636383031342C3136353636393838302C3136353637313235392C3136353637343433302C3136353637353230342C3136353637363532342C3136353735343236382C,0x3136353636383932302C3136353636393933372C3136353637313239322C3136353637343531312C3136353637353236312C3136353637363632382C3136353735343435312C),
 (28,'CD247.jApr07','chr1','-',165669758,165754407,165669859,165754326,6,0x3136353636393735382C3136353637313235392C3136353637343433302C3136353637353230342C3136353637363532342C3136353735343236382C,0x3136353636393933372C3136353637313239322C3136353637343531312C3136353637353236312C3136353637363632382C3136353735343430372C),
 (28,'CD247.iApr07','chr1','-',165669764,165754407,165669859,165754326,6,0x3136353636393736342C3136353637313235392C3136353637343433302C3136353637353230342C3136353637363532342C3136353735343236382C,0x3136353636393933372C3136353637313239352C3136353637343531312C3136353637353236312C3136353637363632382C3136353735343430372C),
 (28,'CD247.kApr07','chr1','-',165669899,165754403,165669901,165684285,7,0x3136353636393839392C3136353637313235392C3136353637343433302C3136353637353230342C3136353637363532342C3136353638343230332C3136353735343236382C,0x3136353636393933372C3136353637313239322C3136353637343531312C3136353637353236312C3136353637363632382C3136353638343334382C3136353735343430332C),
 (28,'CD247.hApr07','chr1','-',165674313,165754452,165674313,165754326,4,0x3136353637343331332C3136353637353230342C3136353637363532342C3136353735343236382C,0x3136353637343531312C3136353637353236312C3136353637363632382C3136353735343435322C),
 (28,'CD247.lApr07','chr1','-',165674926,165754389,165675144,165754326,3,0x3136353637343932362C3136353637363532342C3136353735343236382C,0x3136353637353236312C3136353637363632382C3136353735343338392C),
 (28,'LOC441914.aApr07','chr1','+',166590275,166740869,166605067,166740534,3,0x3136363539303237352C3136363630343838342C3136363734303239302C,0x3136363539303438382C3136363630353331392C3136363734303836392C),
 (28,'LOC441914.bApr07','chr1','+',166590353,166779056,166590559,166590748,2,0x3136363539303335332C3136363737383538332C,0x3136363539303737322C3136363737393035362C),
 (28,'jeykobo.aApr07','chr1','-',166699975,166731506,166700141,166729971,5,0x3136363639393937352C3136363732313130342C3136363732313433342C3136363732393930372C3136363733313434392C,0x3136363730303233352C3136363732313136382C3136363732313539332C3136363732393938362C3136363733313530362C),
 (29,'KLHL20.gApr07','chr1','+',171873475,171969568,171873588,171951776,4,0x3137313837333437352C3137313930363939352C3137313935313736342C3137313936393437342C,0x3137313837333739362C3137313930373039362C3137313935313832382C3137313936393536382C),
 (29,'KLHL20.aApr07','chr1','+',171950675,172022593,171951805,172021008,12,0x3137313935303637352C3137313935313736342C3137313936393437342C3137313938373532352C3137313938383937342C3137313939313638342C3137313939323733372C3137323030313930372C3137323031303036362C3137323031313339352C3137323031373838342C3137323032303932332C,0x3137313935303834302C3137313935313832382C3137313937303034382C3137313938373638342C3137313938393036392C3137313939313830302C3137313939323932312C3137323030323035312C3137323031303230302C3137323031313630342C3137323031373939312C3137323032323539332C),
 (29,'KLHL20.bApr07','chr1','+',171950689,171970271,171950770,171970144,4,0x3137313935303638392C3137313935313238342C3137313935313736342C3137313936393437342C,0x3137313935303834302C3137313935313431362C3137313935313832382C3137313937303237312C),
 (29,'KLHL20.kApr07','chr1','+',171950701,171969686,171951798,171969515,4,0x3137313935303730312C3137313935313736342C3137313936323337322C3137313936393437342C,0x3137313935303834302C3137313935313832382C3137313936323533352C3137313936393638362C),
 (29,'KLHL20.cApr07','chr1','+',171950701,171969908,171951232,171969907,3,0x3137313935303730312C3137313935313736342C3137313936393437342C,0x3137313935313431362C3137313935313832382C3137313936393930382C),
 (29,'KLHL20.iApr07','chr1','+',171950729,171969630,171950770,171961016,5,0x3137313935303732392C3137313935313238342C3137313935313736342C3137313936303939312C3137313936393437342C,0x3137313935303834302C3137313935313431362C3137313935313832382C3137313936313130302C3137313936393633302C),
 (29,'KLHL20.fApr07','chr1','+',171951757,171969725,171951757,171969724,2,0x3137313935313735372C3137313936393437342C,0x3137313935313832382C3137313936393732352C),
 (29,'RABGAP1L.aApr07','chr1','+',172395180,173193950,172395181,173193665,21,0x3137323339353138302C3137323435343838352C3137323435363733322C3137323436363930352C3137323437373234332C3137323438363233352C3137323438383234302C3137323530383137342C3137323531313539332C3137323531343337332C3137323534303734362C3137323630363733392C3137323632393735352C3137323837333133352C3137323931393238322C3137323933353238352C3137323933373837332C3137323938383037332C3137333034373539322C3137333139333231362C3137333139333635302C,0x3137323339353431382C3137323435353035362C3137323435363932352C3137323436373131362C3137323437373431382C3137323438363339332C3137323438383335312C3137323530383234312C3137323531313639362C3137323531343534302C3137323534303838382C3137323630363833332C3137323632393930362C3137323837333234392C3137323931393335372C3137323933353431312C3137323933383031372C3137323938383131352C3137333034373732312C3137333139333330392C3137333139333935302C),
 (29,'RABGAP1L.bApr07','chr1','+',172474564,173193234,172477265,173193234,15,0x3137323437343536342C3137323437373234332C3137323438363233352C3137323438383234302C3137323530383137342C3137323531313539332C3137323531343337332C3137323534303734362C3137323630363733392C3137323931393238322C3137323933353238352C3137323933373837332C3137323938383037332C3137333034373539322C3137333139333231362C,0x3137323437343731302C3137323437373431382C3137323438363339332C3137323438383335312C3137323530383234312C3137323531313639362C3137323531343534302C3137323534303838382C3137323630363737382C3137323931393335372C3137323933353431312C3137323933383031372C3137323938383131352C3137333034373732312C3137333139333233342C),
 (29,'RABGAP1L.nApr07','chr1','+',172936173,173193280,172937927,173193279,5,0x3137323933363137332C3137323933373837332C3137323938383037332C3137333034373539322C3137333139333231362C,0x3137323933363530372C3137323933383031372C3137323938383131352C3137333034373732312C3137333139333238302C),
 (29,'RABGAP1L.qApr07','chr1','+',172936282,173193234,172937927,173193234,5,0x3137323933363238322C3137323933373837332C3137323938383037332C3137333034373539322C3137333139333231362C,0x3137323933363632362C3137323933383031372C3137323938383131352C3137333034373732312C3137333139333233342C),
 (29,'RABGAP1L.gApr07','chr1','+',172936295,173226159,172937927,173225761,11,0x3137323933363239352C3137323933373837332C3137323938383037332C3137333034373539322C3137333139333231362C3137333230353033362C3137333231313833372C3137333231343536362C3137333231383539332C3137333232343430302C3137333232353630382C,0x3137323933363632362C3137323933383031372C3137323938383131352C3137333034373732312C3137333139333330392C3137333230353134372C3137333231313934322C3137333231343635302C3137333231383636352C3137333232343539382C3137333232363135392C),
 (29,'RABGAP1L.iApr07','chr1','+',172936491,173226101,173193885,173225761,13,0x3137323933363439312C3137323933373837332C3137323938383037332C3137333034373539322C3137333131333135322C3137333139333231362C3137333139333635302C3137333230353033362C3137333231313833372C3137333231343536362C3137333231383539332C3137333232343430302C3137333232353630382C,0x3137323933363632362C3137323933383031372C3137323938383131352C3137333034373732312C3137333131333336362C3137333139333330392C3137333139333933332C3137333230353134372C3137333231313934322C3137333231343635302C3137333231383636352C3137333232343539382C3137333232363130312C),
 (29,'RABGAP1L.fApr07','chr1','+',172936740,173226347,172936903,173225761,11,0x3137323933363734302C3137323933373837332C3137323938383037332C3137333034373539322C3137333139333231362C3137333230353033362C3137333231313833372C3137333231343536362C3137333231383539332C3137333232343430302C3137333232353630382C,0x3137323933363930362C3137323933383031372C3137323938383131352C3137333034373732312C3137333139333330392C3137333230353134372C3137333231313934322C3137333231343635302C3137333231383636352C3137333232343539382C3137333232363334372C),
 (29,'ASTN1.bApr07','chr1','-',175093061,175400628,175093369,175400435,23,0x3137353039333036312C3137353130343630322C3137353131323239352C3137353131383631372C3137353132303039372C3137353132333832392C3137353133303332302C3137353136393931302C3137353137323032342C3137353137393634392C3137353138313638342C3137353138343934332C3137353139333433362C3137353139343130332C3137353230303932312C3137353235303534392C3137353235393136322C3137353236303334312C3137353236353339322C3137353236363536342C3137353236383231342C3137353239363833362C3137353430303135322C,0x3137353039333430392C3137353130343738362C3137353131323339362C3137353131383735332C3137353132303234392C3137353132333936332C3137353133303538392C3137353137303039392C3137353137323132392C3137353137393737372C3137353138313837392C3137353138353131302C3137353139333538372C3137353139343234312C3137353230303939362C3137353235303633342C3137353235393333302C3137353236303439312C3137353236353530302C3137353236363731312C3137353236383630382C3137353239373032342C3137353430303632382C),
 (29,'ASTN1.aApr07','chr1','-',175096691,175400636,175100042,175400435,23,0x3137353039363639312C3137353130343630322C3137353131323239352C3137353131383631372C3137353132303039372C3137353132333832392C3137353133303332302C3137353136393931302C3137353137323032342C3137353137393634392C3137353138313638342C3137353138343934332C3137353139333433362C3137353139343130332C3137353230303932312C3137353235303534392C3137353235393136322C3137353236303334312C3137353236353339322C3137353236363536342C3137353236383231342C3137353239363833362C3137353430303135322C,0x3137353130303238302C3137353130343738362C3137353131323339362C3137353131383735332C3137353132303234392C3137353132333936332C3137353133303538392C3137353137303039392C3137353137323132392C3137353137393737372C3137353138313837392C3137353138353131302C3137353139333538372C3137353139343234312C3137353230303939362C3137353235303633342C3137353235393333302C3137353236303439312C3137353236353530302C3137353236363731312C3137353236383630382C3137353239373032342C3137353430303633362C),
 (29,'ASTN1.cApr07','chr1','-',175104571,175400636,175104598,175400435,22,0x3137353130343537312C3137353131323239352C3137353131383631372C3137353132303039372C3137353132333832392C3137353133303332302C3137353136393931302C3137353137323032342C3137353137393634392C3137353138313638342C3137353138343934332C3137353139333433362C3137353139343130332C3137353230303932312C3137353235303534392C3137353235393136322C3137353236303334312C3137353236353339322C3137353236363536342C3137353236383231342C3137353239363833362C3137353430303135322C,0x3137353130343738362C3137353131323339362C3137353131383735332C3137353132303234392C3137353132333936332C3137353133303538392C3137353137303039392C3137353137323132392C3137353137393737372C3137353138313837392C3137353138353131302C3137353139333538372C3137353139343234312C3137353230303939362C3137353235303633342C3137353235393333302C3137353236303439312C3137353236353530302C3137353236363731312C3137353236383630382C3137353239373032342C3137353430303633362C),
 (30,'CEP350.bApr07','chr1','+',178190531,178350637,178221939,178346919,38,0x3137383139303533312C3137383232313932362C3137383232333030302C3137383232363236342C3137383232373831392C3137383233323331302C3137383233383933312C3137383234323231312C3137383234373638362C3137383234393630342C3137383235313630362C3137383235353730362C3137383235383435352C3137383236303137362C3137383236373037372C3137383236393631392C3137383237323638332C3137383237363839352C3137383237373431392C3137383237383831332C3137383237393830382C3137383238343239332C3137383238383732372C3137383238393530372C3137383239303137322C3137383239373937372C3137383330303837322C3137383331303737392C3137383331343232302C3137383331363237342C3137383331393737352C3137383332333333352C3137383332363437312C3137383332383337312C3137383333313238302C3137383333313739352C3137383333343632302C3137383334363735342C,0x3137383139303930302C3137383232323031322C3137383232333034342C3137383232363337392C3137383232373937392C3137383233323933332C3137383233393034352C3137383234323332352C3137383234373833332C3137383235303236332C3137383235313732382C3137383235363736372C3137383235383630362C3137383236303334302C3137383236373235322C3137383236393834302C3137383237323834372C3137383237373030362C3137383237373536302C3137383237383935302C3137383237393933312C3137383238343436332C3137383238383932342C3137383238393639322C3137383239303236302C3137383239383132342C3137383330313033302C3137383331303937392C3137383331343433322C3137383331363431392C3137383331393933362C3137383332333437352C3137383332363535342C3137383333303337342C3137383333313638382C3137383333313934322C3137383333343734332C3137383335303633372C),
 (30,'CEP350.aApr07','chr1','+',178190584,178350633,178221939,178346919,38,0x3137383139303538342C3137383232313932362C3137383232323939372C3137383232363236342C3137383232373831392C3137383233323331302C3137383233383933312C3137383234323231312C3137383234373638362C3137383234393630342C3137383235313630362C3137383235353730362C3137383235383435352C3137383236303137362C3137383236373037372C3137383236393631392C3137383237323638332C3137383237363839352C3137383237373431392C3137383237383831332C3137383237393830382C3137383238343239332C3137383238383732372C3137383238393530372C3137383239303137322C3137383239373937372C3137383330303837322C3137383331303737392C3137383331343232302C3137383331363237342C3137383331393737352C3137383332333333352C3137383332363437312C3137383332383337312C3137383333313238302C3137383333313739352C3137383333343632302C3137383334363735342C,0x3137383139303930302C3137383232323031322C3137383232333034342C3137383232363337392C3137383232373937392C3137383233323933332C3137383233393034352C3137383234323332352C3137383234373833332C3137383235303236332C3137383235313732382C3137383235363736372C3137383235383630362C3137383236303334302C3137383236373235322C3137383236393834302C3137383237323834372C3137383237373030362C3137383237373536302C3137383237383935302C3137383237393933312C3137383238343436332C3137383238383932342C3137383238393639322C3137383239303236302C3137383239383132342C3137383330313033302C3137383331303937392C3137383331343433322C3137383331363431392C3137383331393933362C3137383332333437352C3137383332363535342C3137383333303337342C3137383333313638382C3137383333313934322C3137383333343734332C3137383335303633332C),
 (30,'CEP350.dApr07','chr1','+',178227560,178272863,178232413,178272862,13,0x3137383232373536302C3137383233323331302C3137383233383933312C3137383234323231312C3137383234373638362C3137383234393630342C3137383235313630362C3137383235353730362C3137383235383435352C3137383236303137392C3137383236373037372C3137383236393631392C3137383237323638332C,0x3137383232373937392C3137383233323933332C3137383233393034352C3137383234323332352C3137383234373833332C3137383235303236332C3137383235313732382C3137383235363736372C3137383235383630362C3137383236303334302C3137383236373235322C3137383236393834302C3137383237323836332C),
 (30,'CEP350.eApr07','chr1','+',178232379,178320252,178232380,178319963,21,0x3137383233323337392C3137383235363237322C3137383235383435352C3137383236303137362C3137383236373037372C3137383236393631392C3137383237323638332C3137383237363839352C3137383237373431392C3137383237383831332C3137383237393830382C3137383238343239332C3137383238383732372C3137383238393530372C3137383239303137322C3137383239373937372C3137383330303837322C3137383331303737392C3137383331343232302C3137383331363237342C3137383331393737352C,0x3137383233323432302C3137383235363736372C3137383235383630362C3137383236303334302C3137383236373235322C3137383236393834302C3137383237323834372C3137383237373030362C3137383237373536302C3137383237383935302C3137383237393933312C3137383238343436332C3137383238383932342C3137383238393639322C3137383239303236302C3137383239383132342C3137383330313033302C3137383331303937392C3137383331343433322C3137383331363431392C3137383332303235322C),
 (30,'CEP350.mApr07','chr1','+',178256509,178260332,178256511,178260331,3,0x3137383235363530392C3137383235383435352C3137383236303235352C,0x3137383235363736372C3137383235383630362C3137383236303333322C),
 (30,'lylarbu.aApr07','chr1','+',181402053,181429111,0,0,2,0x3138313430323035332C3138313432383734302C,0x3138313430323132312C3138313432393131312C),
 (30,'C1orf26.bApr07','chr1','+',183392778,183527443,183396596,183526558,19,0x3138333339323737382C3138333339363538372C3138333430323332362C3138333430343039342C3138333431303132362C3138333431363134352C3138333431373730302C3138333431393939372C3138333432303439372C3138333432363330332C3138333433383430382C3138333434303435342C3138333434323337392C3138333435303236312C3138333435373630332C3138333436373333312C3138333530373037372C3138333531323335382C3138333532363432382C,0x3138333339323931392C3138333339363638302C3138333430323430372C3138333430343135332C3138333431303836382C3138333431363230352C3138333431373831322C3138333432303039392C3138333432303638362C3138333432363339372C3138333433383535342C3138333434303631382C3138333434323531382C3138333435303431302C3138333435373739312C3138333436373436332C3138333530373134342C3138333531323432332C3138333532373434332C),
 (30,'C1orf26.aApr07','chr1','+',183392919,183527535,183396596,183526558,19,0x3138333339323931392C3138333339363538372C3138333430323332362C3138333430343039342C3138333431303132362C3138333431363134352C3138333431373730302C3138333431393939372C3138333432303439372C3138333432363330332C3138333433383430382C3138333434303435342C3138333434323337392C3138333435303236312C3138333435373630332C3138333436373333312C3138333530373037372C3138333531323335382C3138333532363432382C,0x3138333339333036392C3138333339363638302C3138333430323430372C3138333430343135332C3138333431303836382C3138333431363230352C3138333431373831322C3138333432303039392C3138333432303638362C3138333432363339372C3138333433383535342C3138333434303631382C3138333434323531382C3138333435303431302C3138333435373739312C3138333436373436332C3138333530373134342C3138333531323432332C3138333532373533352C),
 (31,'nosayo.bApr07','chr1','+',185306317,185853512,0,0,3,0x3138353330363331372C3138353330383138322C3138353835323935392C,0x3138353330363636302C3138353330383337352C3138353835333531322C),
 (31,'tasayo.aApr07','chr1','+',187385438,187983393,0,0,3,0x3138373338353433382C3138373338363239352C3138373938323835312C,0x3138373338353633302C3138373338363531342C3138373938333339332C),
 (31,'DUF1725.354.dApr07','chr1','-',190727483,190864822,0,0,5,0x3139303732373438332C3139303830323839392C3139303832393335312C3139303836333039332C3139303836343633392C,0x3139303732373732322C3139303830323936392C3139303832393431302C3139303836333137342C3139303836343832322C),
 (31,'DUF1725.354.bApr07','chr1','-',190727494,190975219,190802943,190975217,4,0x3139303732373439342C3139303830323839392C3139303832393335312C3139303937353134332C,0x3139303732373732322C3139303830323936392C3139303832393431302C3139303937353231392C),
 (31,'DUF1725.354.cApr07','chr1','-',190753391,190975196,190802943,190975196,4,0x3139303735333339312C3139303830323839392C3139303832393335312C3139303937353134332C,0x3139303735333731362C3139303830323936392C3139303832393431302C3139303937353139362C),
 (32,'chormubu.bApr07','chr1','-',197041599,197173180,0,0,3,0x3139373034313539392C3139373133363136322C3139373137323937372C,0x3139373034333939352C3139373133363332312C3139373137333138302C),
 (32,'KIF21B.aApr07','chr1','-',199205136,199259451,199209845,199259134,34,0x3139393230353133362C3139393231303436342C3139393231313234392C3139393231323532362C3139393231323936322C3139393231353238352C3139393231363731302C3139393232303630392C3139393232323539342C3139393232323734362C3139393232343034362C3139393232343234332C3139393232343531362C3139393232353639322C3139393232353838382C3139393232363332362C3139393232363636372C3139393232373430372C3139393232383033322C3139393233313934362C3139393233343133342C3139393233353039392C3139393233353633332C3139393233363134302C3139393233363436372C3139393233373931312C3139393233393333362C3139393234303039302C3139393234303531362C3139393234313035382C3139393234313239352C3139393234343531392C3139393234353031362C3139393235393039332C,0x3139393230393934352C3139393231303636342C3139393231313432302C3139393231323634342C3139393231333132372C3139393231353436362C3139393231363834372C3139393232303732332C3139393232323636392C3139393232323935322C3139393232343130342C3139393232343239352C3139393232343638322C3139393232353739342C3139393232363038332C3139393232363437342C3139393232363930302C3139393232373437362C3139393232383134302C3139393233323134362C3139393233343332362C3139393233353231372C3139393233353731352C3139393233363335392C3139393233363533312C3139393233383130312C3139393233393533322C3139393234303230362C3139393234303638342C3139393234313139332C3139393234313434352C3139393234343730322C3139393234353233392C3139393235393435312C),
 (33,'ETNK2.bApr07','chr1','-',202366811,202387754,202367934,202387603,8,0x3230323336363831312C3230323337303236352C3230323337323835342C3230323337353738352C3230323337373036352C3230323338323339322C3230323338353435332C3230323338373334352C,0x3230323336383030372C3230323337303333392C3230323337333030302C3230323337353836392C3230323337373230382C3230323338323531352C3230323338353731332C3230323338373735342C),
 (33,'ETNK2.aApr07','chr1','-',202366813,202387936,202370274,202387603,8,0x3230323336363831332C3230323337303236352C3230323337323835342C3230323337353738352C3230323337373036352C3230323338323339322C3230323338353435332C3230323338373334352C,0x3230323336383030372C3230323337303434352C3230323337333030302C3230323337353836392C3230323337373230382C3230323338323531352C3230323338353731332C3230323338373933362C),
 (33,'ETNK2.cApr07','chr1','-',202366814,202387876,202366866,202387603,8,0x3230323336363831342C3230323336373937332C3230323337303236352C3230323337323835342C3230323337353738352C3230323337373036352C3230323338353435332C3230323338373334352C,0x3230323336363930322C3230323336383030372C3230323337303333392C3230323337333030302C3230323337353836392C3230323337373230382C3230323338353731332C3230323338373837362C),
 (33,'ETNK2.iApr07','chr1','-',202367706,202377063,202367934,202372914,5,0x3230323336373730362C3230323337303236352C3230323337323835342C3230323337353738352C3230323337363737352C,0x3230323336383030372C3230323337303333392C3230323337333030302C3230323337353836392C3230323337373036332C),
 (33,'ETNK2.fApr07','chr1','-',202367712,202377037,202367934,202377036,5,0x3230323336373731322C3230323337303236352C3230323337323835342C3230323337353738352C3230323337363936362C,0x3230323336383030372C3230323337303333392C3230323337333030302C3230323337353836392C3230323337373033372C),
 (33,'ETNK2.eApr07','chr1','-',202367915,202382741,202367934,202382499,6,0x3230323336373931352C3230323337303236352C3230323337323835342C3230323337353738352C3230323337373036352C3230323338323339322C,0x3230323336383030372C3230323337303333392C3230323337333030302C3230323337353836392C3230323337373230382C3230323338323734312C),
 (33,'ETNK2.kApr07','chr1','-',202367991,202377037,0,0,5,0x3230323336373939312C3230323337303236352C3230323337323835342C3230323337353738352C3230323337363737382C,0x3230323336383030372C3230323337303333392C3230323337333030302C3230323337353836392C3230323337373033372C),
 (33,'ETNK2.dApr07','chr1','-',202370298,202383331,202370300,202383329,6,0x3230323337303239382C3230323337323835342C3230323337353738352C3230323337373036352C3230323338323339322C3230323338333231302C,0x3230323337303333392C3230323337333030302C3230323337353836392C3230323337373230382C3230323338323531352C3230323338333333312C),
 (33,'ETNK2.hApr07','chr1','-',202372951,202377777,202372953,202377177,3,0x3230323337323935312C3230323337353738352C3230323337373036352C,0x3230323337333030302C3230323337353836392C3230323337373737372C),
 (33,'RIPK5.aApr07','chr1','-',203378254,203447322,203383308,203447286,13,0x3230333337383235342C3230333338333935352C3230333338363433302C3230333339333032332C3230333339353239372C3230333339353836342C3230333339373030382C3230333339373738362C3230333339383637332C3230333339393437332C3230333430343931332C3230333432333136382C3230333434373032312C,0x3230333338333439362C3230333338343039302C3230333338363534352C3230333339333133372C3230333339353433302C3230333339363032312C3230333339373133382C3230333339373936332C3230333339383735372C3230333339393730362C3230333430353538332C3230333432333535372C3230333434373332322C),
 (33,'RIPK5.bApr07','chr1','-',203378255,203447353,203383308,203447352,12,0x3230333337383235352C3230333338363433302C3230333339333032332C3230333339353239372C3230333339353836342C3230333339373030382C3230333339373738362C3230333339383637332C3230333339393437332C3230333430343931332C3230333432333136382C3230333434373032312C,0x3230333338333439362C3230333338363534352C3230333339333133372C3230333339353433302C3230333339363032312C3230333339373133382C3230333339373936332C3230333339383735372C3230333339393730362C3230333430353538332C3230333432333535372C3230333434373335332C),
 (33,'C1orf186.hApr07','chr1','-',204447150,204472738,0,0,7,0x3230343434373135302C3230343434373534342C3230343435313533302C3230343435343732372C3230343435353938392C3230343436363330302C3230343437323639312C,0x3230343434373238302C3230343434373539332C3230343435313737302C3230343435343937322C3230343435363133382C3230343436363432352C3230343437323733382C),
 (33,'C1orf186.lApr07','chr1','-',204454658,204472744,0,0,3,0x3230343435343635382C3230343435353938392C3230343437323639312C,0x3230343435343937322C3230343435363133382C3230343437323734342C),
 (33,'C1orf186.iApr07','chr1','-',204456032,204472756,0,0,4,0x3230343435363033322C3230343436333030362C3230343436363331322C3230343437323639312C,0x3230343435363133382C3230343436333337392C3230343436363432352C3230343437323735362C),
 (33,'flawbee.aApr07','chr1','+',205489034,205549080,205489093,205541750,4,0x3230353438393033342C3230353530343936342C3230353534313733372C3230353534383433342C,0x3230353438393131382C3230353530353030342C3230353534313837352C3230353534393038302C),
 (33,'yosuyo.aApr07','chr1','-',207515625,207675597,0,0,3,0x3230373531353632352C3230373535393131382C3230373637353431312C,0x3230373531363135312C3230373535393436312C3230373637353539372C),
 (33,'klerbee.bApr07','chr1','+',207607629,207619446,0,0,5,0x3230373630373632392C3230373630373835362C3230373630383338322C3230373631333336312C3230373631393339342C,0x3230373630373735322C3230373630373938302C3230373630383433372C3230373631333532322C3230373631393434362C),
 (33,'klerbee.aApr07','chr1','+',207612022,207619658,0,0,3,0x3230373631323032322C3230373631333336312C3230373631393339342C,0x3230373631323138322C3230373631333532322C3230373631393635382C),
 (33,'HHAT.bApr07','chr1','+',208568872,208916261,208588942,208914344,12,0x3230383536383837322C3230383538383839392C3230383630323831382C3230383632373433342C3230383634303433342C3230383634343433302C3230383635383132302C3230383730343437312C3230383735333131392C3230383832373836342C3230383836333439322C3230383931343235322C,0x3230383536393037312C3230383538393033332C3230383630323838362C3230383632373534382C3230383634303632392C3230383634343634362C3230383635383239322C3230383730343632322C3230383735333135352C3230383832383036362C3230383836333633372C3230383931363236312C),
 (33,'HHAT.aApr07','chr1','+',208569261,208916254,208588942,208914344,12,0x3230383536393236312C3230383538383839392C3230383630323831382C3230383632373433342C3230383634303433342C3230383634343433302C3230383635383132302C3230383730343437312C3230383735333131392C3230383832373836342C3230383836333439322C3230383931343235322C,0x3230383536393435302C3230383538393033332C3230383630323838362C3230383632373534382C3230383634303632392C3230383634343634362C3230383635383239322C3230383730343632322C3230383735333135352C3230383832383036362C3230383836333633372C3230383931363235342C),
 (33,'HHAT.cApr07','chr1','+',208602818,208704622,208602820,208704620,5,0x3230383630323831382C3230383632373433342C3230383634343433302C3230383635383132302C3230383730343437312C,0x3230383630323838362C3230383632373534382C3230383634343634362C3230383635383239322C3230383730343632322C),
 (33,'HHAT.pApr07','chr1','+',208609621,208863581,0,0,5,0x3230383630393632312C3230383632373433342C3230383735333131392C3230383832373836342C3230383836333439322C,0x3230383630393735302C3230383632373534382C3230383735333135352C3230383832383036362C3230383836333538312C),
 (33,'HHAT.oApr07','chr1','+',208609681,208830933,208609681,208753128,4,0x3230383630393638312C3230383632373433342C3230383735333131392C3230383832373836342C,0x3230383630393735302C3230383632373534382C3230383735333135352C3230383833303933332C),
 (34,'spanybu.aApr07','chr1','+',211732172,212108509,0,0,3,0x3231313733323137322C3231313738363234382C3231323130373933342C,0x3231313733323534312C3231313738363431312C3231323130383530392C),
 (34,'CENPF.aApr07','chr1','+',212843161,212904554,212853720,212903760,20,0x3231323834333136312C3231323835333637392C3231323835343739372C3231323835383533382C3231323835393039342C3231323836303632302C3231323836323034342C3231323836393031312C3231323837303439392C3231323837323434352C3231323837373833312C3231323837393838362C3231323838343532322C3231323838383634302C3231323839313637352C3231323839323739332C3231323839353230362C3231323839363839382C3231323839383831352C3231323930333535362C,0x3231323834333238372C3231323835333838322C3231323835343939342C3231323835383636302C3231323835393138362C3231323836303931322C3231323836323234372C3231323836393133372C3231323837303632382C3231323837323536382C3231323837373936372C3231323838333239302C3231323838373336362C3231323838383739332C3231323839313835322C3231323839323935352C3231323839353336392C3231323839373337352C3231323839383939342C3231323930343535342C),
 (34,'USH2A.aApr07','chr1','-',213862858,214663385,213865745,214662301,72,0x3231333836323835382C3231333836383737382C3231333837343432332C3231333837393131392C3231333838303532322C3231333838373438362C3231333838383439322C3231333839303535362C3231333931303933362C3231333931343036342C3231333932303131332C3231333936373939342C3231333938313333392C3231333938333134312C3231333939383535392C3231333939393632342C3231343030363634352C3231343031393830372C3231343032323030362C3231343032323730322C3231343032363633342C3231343033303032332C3231343033383837312C3231343035333730302C3231343035363936312C3231343037373935352C3231343038343235382C3231343038353738382C3231343130363937312C3231343131373732322C3231343131383732382C3231343132383339302C3231343134303033392C3231343134303731392C3231343137343538302C3231343230353238312C3231343231303538392C3231343233323938342C3231343233383835312C3231343234303336372C3231343238363339352C3231343238383439382C3231343331303036352C3231343331323835332C3231343331333036312C3231343331383035332C3231343332333432302C3231343332343636322C3231343332363638332C3231343332383937372C3231343333373034372C3231343431353231362C3231343433303138372C3231343433363531372C3231343433383237392C3231343433393539312C3231343434373233372C3231343435373335312C3231343437313931372C3231343438363534392C3231343439303836372C3231343532393234342C3231343533323133392C3231343536313834372C3231343536333433382C3231343536343133322C3231343536353236392C3231343536373535352C3231343630343931372C3231343635383437382C3231343636313831362C3231343636333137382C,0x3231333836353833352C3231333836393030302C3231333837343636382C3231333837393230332C3231333838303639392C3231333838373639352C3231333838383733312C3231333839303736362C3231333931313235382C3231333931353538312C3231333932303334312C3231333936383334392C3231333938313530322C3231333938333330302C3231333939383731372C3231333939393830382C3231343030363735332C3231343032303030362C3231343032323136312C3231343032323930302C3231343032363833392C3231343033303234372C3231343033393039302C3231343035333836392C3231343035373136302C3231343037383036382C3231343038343436312C3231343038353939382C3231343130373133352C3231343131373834352C3231343131393036332C3231343132393031392C3231343134303138322C3231343134303837302C3231343137343736302C3231343230353434342C3231343231303734312C3231343233333133322C3231343233393032332C3231343234303532372C3231343238363535372C3231343238383631322C3231343331303235372C3231343331323933342C3231343331333236352C3231343331383332372C3231343332333535312C3231343332343834322C3231343332363738352C3231343332393130342C3231343333373137382C3231343431353434372C3231343433303333322C3231343433363638372C3231343433383534392C3231343434303038362C3231343434373339362C3231343435373531352C3231343437323130312C3231343438373139312C3231343439313036332C3231343532393337352C3231343533323333352C3231343536313934312C3231343536333636302C3231343536343331372C3231343536353536342C3231343536373631392C3231343630353035302C3231343635383634342C3231343636323530352C3231343636333338352C),
 (34,'ESRRG.gApr07','chr1','-',214743202,215330260,214746903,214917443,9,0x3231343734333230322C3231343735393131362C3231343830343138332C3231343830373935322C3231343839303933372C3231343931373034302C3231353130353032352C3231353137393534362C3231353332393437312C,0x3231343734373134382C3231343735393338362C3231343830343334352C3231343830383036332C3231343839313035342C3231343931373435362C3231353130353134332C3231353137393633382C3231353333303236302C),
 (34,'ESRRG.dApr07','chr1','-',214743210,215199650,214746903,214917443,8,0x3231343734333231302C3231343735393131362C3231343830343138332C3231343830373935322C3231343839303933372C3231343931373034302C3231353137393534362C3231353139393532362C,0x3231343734373134382C3231343735393338362C3231343830343334352C3231343830383036332C3231343839313035342C3231343931373435362C3231353137393633382C3231353139393635302C),
 (34,'ESRRG.eApr07','chr1','-',214743210,215329599,214746903,214917443,8,0x3231343734333231302C3231343735393131362C3231343830343138332C3231343830373935322C3231343839303933372C3231343931373034302C3231353137393534362C3231353332393437312C,0x3231343734373134382C3231343735393338362C3231343830343334352C3231343830383036332C3231343839313035342C3231343931373435362C3231353137393633382C3231353332393539392C),
 (34,'ESRRG.bApr07','chr1','-',214743210,214963588,214746903,214963264,7,0x3231343734333231302C3231343735393131362C3231343830343138332C3231343830373935322C3231343839303933372C3231343931373034302C3231343936333230382C,0x3231343734373134382C3231343735393338362C3231343830343334352C3231343830383036332C3231343839313035342C3231343931373435362C3231343936333538382C),
 (34,'ESRRG.aApr07','chr1','-',214743218,214963417,214746903,214947394,8,0x3231343734333231382C3231343735393131362C3231343830343138332C3231343830373935322C3231343839303933372C3231343931373034302C3231343934373332332C3231343936333230382C,0x3231343734373134382C3231343735393338362C3231343830343336362C3231343830383036332C3231343839313035342C3231343931373435362C3231343934373435312C3231343936333431372C),
 (34,'ESRRG.iApr07','chr1','-',214745429,215316895,214746903,214917443,8,0x3231343734353432392C3231343735393131362C3231343830343138332C3231343830373935322C3231343931373034302C3231353130353032352C3231353234303231372C3231353331363831362C,0x3231343734373134382C3231343735393338362C3231343830343334352C3231343830383036332C3231343931373435362C3231353130353134332C3231353234303638392C3231353331363839352C),
 (34,'ESRRG.cApr07','chr1','-',214745454,214963416,214746903,214917443,8,0x3231343734353435342C3231343735393131362C3231343830343138332C3231343830373935322C3231343839303933372C3231343931373034302C3231343935353033382C3231343936333230382C,0x3231343734373134382C3231343735393338362C3231343830343334352C3231343830383036332C3231343839313035342C3231343931373435362C3231343935353231342C3231343936333431362C),
 (34,'ESRRG.fApr07','chr1','-',214745454,215179635,214746903,214917443,9,0x3231343734353435342C3231343735393131362C3231343830343138332C3231343830373935322C3231343839303933372C3231343931373034302C3231353130353032352C3231353137363632362C3231353137393534362C,0x3231343734373134382C3231343735393338362C3231343830343334352C3231343830383036332C3231343839313035342C3231343931373435362C3231353130353134332C3231353137363636342C3231353137393633352C),
 (34,'ESRRG.hApr07','chr1','-',214745454,215045219,214746903,214917443,7,0x3231343734353435342C3231343735393131362C3231343830343138332C3231343830373935322C3231343839303933372C3231343931373034302C3231353034343930372C,0x3231343734373134382C3231343735393338362C3231343830343334352C3231343830383036332C3231343839313035342C3231343931373435362C3231353034353231392C),
 (34,'ESRRG.jApr07','chr1','-',214759153,214963297,214759153,214917443,8,0x3231343735393135332C3231343830343138332C3231343830373935322C3231343839303933372C3231343931373034302C3231343935343438302C3231343935353033382C3231343936333230342C,0x3231343735393338362C3231343830343334352C3231343830383036332C3231343839313035342C3231343931373435362C3231343935343539392C3231343935353231342C3231343936333239372C),
 (34,'ESRRG.mApr07','chr1','-',214759240,215329819,0,0,6,0x3231343735393234302C3231343830343138332C3231343830373935322C3231353130353032352C3231353137393534362C3231353332393735312C,0x3231343735393338362C3231343830343334352C3231343830383036332C3231353130353134332C3231353137393633382C3231353332393831392C),
 (34,'ESRRG.nApr07','chr1','-',214804320,215318252,0,0,6,0x3231343830343332302C3231343830373935322C3231343934313338392C3231343934373332332C3231353137393534362C3231353331383130302C,0x3231343830343334352C3231343830383036332C3231343934313437342C3231343934373435312C3231353137393633382C3231353331383235322C),
 (34,'ESRRG.pApr07','chr1','-',214917115,215145341,0,0,3,0x3231343931373131352C3231353130353032352C3231353134353231322C,0x3231343931373435362C3231353130353134332C3231353134353334312C),
 (34,'ESRRG.vbApr07','chr1','-',214917139,215318247,0,0,3,0x3231343931373133392C3231353137393534362C3231353331383130302C,0x3231343931373435362C3231353137393633382C3231353331383234372C),
 (34,'ESRRG.kApr07','chr1','-',214917140,215329771,214917140,214917443,2,0x3231343931373134302C3231353332393437312C,0x3231343931373435362C3231353332393737312C),
 (34,'ESRRG.sApr07','chr1','-',214917165,214963381,0,0,3,0x3231343931373136352C3231343935343438302C3231343936333230382C,0x3231343931373435362C3231343935343539392C3231343936333338312C),
 (34,'ESRRG.qApr07','chr1','-',214917224,215329576,0,0,4,0x3231343931373232342C3231353137393534362C3231353330393635392C3231353332393437312C,0x3231343931373435362C3231353137393633382C3231353330393831372C3231353332393537362C),
 (34,'ESRRG.vaApr07','chr1','-',214917226,215330511,0,0,4,0x3231343931373232362C3231353130353032352C3231353137393534362C3231353333303339352C,0x3231343931373435362C3231353130353134332C3231353137393633382C3231353333303531312C);
INSERT INTO `aceview_hg18_housekeeping` (`bin`,`name`,`chrom`,`strand`,`txStart`,`txEnd`,`cdsStart`,`cdsEnd`,`exonCount`,`exonStarts`,`exonEnds`) VALUES 
 (34,'ESRRG.tApr07','chr1','-',214917263,215329576,0,0,5,0x3231343931373236332C3231353130353032352C3231353137393534362C3231353232353732322C3231353332393437312C,0x3231343931373435362C3231353130353134332C3231353137393633382C3231353232353738322C3231353332393537362C),
 (34,'ESRRG.veApr07','chr1','-',214917272,215330019,0,0,3,0x3231343931373237322C3231353137393534362C3231353332393735312C,0x3231343931373435362C3231353137393633382C3231353333303031392C),
 (34,'ESRRG.rApr07','chr1','-',214917292,214963390,0,0,4,0x3231343931373239322C3231343932313836302C3231343932363034362C3231343936333230382C,0x3231343931373435362C3231343932313939312C3231343932363135332C3231343936333339302C),
 (34,'ESRRG.oApr07','chr1','-',214917382,214963429,0,0,4,0x3231343931373338322C3231343935343438302C3231343935353033382C3231343936333230382C,0x3231343931373435362C3231343935343539392C3231343935353231342C3231343936333432392C),
 (34,'ESRRG.vdApr07','chr1','-',214947384,214963392,0,0,4,0x3231343934373338342C3231343935343438302C3231343935353033382C3231343936333230382C,0x3231343934373435312C3231343935343539392C3231343935353231342C3231343936333339322C),
 (34,'SPATA17.cApr07','chr1','+',215871284,216107553,215871343,216102819,11,0x3231353837313238342C3231353838383834362C3231353839313036312C3231353930383939372C3231353932333232322C3231353938313933392C3231363031343239382C3231363032323133382C3231363034313638322C3231363130323733382C3231363130363834322C,0x3231353837313431312C3231353838383933362C3231353839313134332C3231353930393034382C3231353932333332362C3231353938323036332C3231363031343530322C3231363032323238372C3231363034313831352C3231363130323832312C3231363130373535332C),
 (34,'SPATA17.gApr07','chr1','+',215871305,216107114,215871343,215910220,10,0x3231353837313330352C3231353838383834362C3231353839313036312C3231353930383939372C3231353931303139332C3231353932333232322C3231363034393334382C3231363035313838332C3231363130323733382C3231363130363937302C,0x3231353837313431312C3231353838383933362C3231353839313134332C3231353930393034382C3231353931303334392C3231353932333239332C3231363034393435302C3231363035323034352C3231363130323832312C3231363130373131342C),
 (34,'SPATA17.bApr07','chr1','+',215871308,216107127,215871343,216102819,11,0x3231353837313330382C3231353838383834362C3231353839313036312C3231353930383939372C3231353932333232322C3231353938313933392C3231363031343239382C3231363032323133382C3231363034313638322C3231363130323733382C3231363130363938362C,0x3231353837313431312C3231353838383933362C3231353839313134332C3231353930393034382C3231353932333332362C3231353938323036332C3231363031343530322C3231363032323238372C3231363034313831352C3231363130323832312C3231363130373132372C),
 (34,'SPATA17.eApr07','chr1','+',215936008,216022287,215981964,216022285,4,0x3231353933363030382C3231353938313933392C3231363031343239382C3231363032323133382C,0x3231353933363133392C3231353938323036332C3231363031343530322C3231363032323238372C),
 (34,'SPATA17.dApr07','chr1','+',215977805,216107115,215981964,216102819,9,0x3231353937373830352C3231353937393433372C3231353938313933392C3231363031343239382C3231363032323133382C3231363034313638322C3231363130323733382C3231363130363834322C3231363130363938362C,0x3231353937373933322C3231353937393535342C3231353938323036332C3231363031343530322C3231363032323238372C3231363034313831352C3231363130323832312C3231363130363837362C3231363130373131352C),
 (34,'SPATA17.aApr07','chr1','+',216001319,216107114,216001765,216102819,6,0x3231363030313331392C3231363031353434362C3231363032323133382C3231363034313638322C3231363130323733382C3231363130363938362C,0x3231363030313839372C3231363031353438362C3231363032323238372C3231363034313831352C3231363130323832312C3231363130373131342C),
 (35,'puber.bApr07','chr1','-',220153609,220218488,0,0,4,0x3232303135333630392C3232303135343338372C3232303135383535362C3232303231383332342C,0x3232303135333832332C3232303135343439362C3232303135383637372C3232303231383438382C),
 (35,'C1orf67.cApr07','chr1','+',223184066,223513562,223207027,223513561,10,0x3232333138343036362C3232333230363939342C3232333230393238332C3232333231343437372C3232333231383830332C3232333232313735352C3232333530343938372C3232333530363632352C3232333531323238342C3232333531333434352C,0x3232333138343136302C3232333230373130342C3232333230393432332C3232333231343632372C3232333231383933342C3232333232313738322C3232333530353033322C3232333530363734322C3232333531323434332C3232333531333536322C),
 (35,'C1orf67.sApr07','chr1','+',223340008,223372528,223340009,223372033,4,0x3232333334303030382C3232333335313434322C3232333337323030382C3232333337323230352C,0x3232333334303131342C3232333335313536342C3232333337323131332C3232333337323532382C),
 (35,'klykoybu.bApr07','chr1','+',224387704,224404533,0,0,3,0x3232343338373730342C3232343430323238322C3232343430343339392C,0x3232343338373737382C3232343430323339322C3232343430343533332C),
 (35,'CDC42BPA.aApr07','chr1','-',225244182,225572449,225248591,225571506,36,0x3232353234343138322C3232353234393134362C3232353235393331372C3232353237303430332C3232353237313235302C3232353237373538362C3232353238303337382C3232353238323938302C3232353238343733312C3232353238353632312C3232353238373635372C3232353238383937382C3232353238393739342C3232353239343435342C3232353330323235302C3232353332343130302C3232353332363533312C3232353332383138372C3232353332383538322C3232353333353231362C3232353334363230392C3232353335353331352C3232353336363633352C3232353336363939342C3232353337343132372C3232353338333433322C3232353339333839392C3232353339373236382C3232353339393831322C3232353430313638322C3232353431343836362C3232353434383130392C3232353435333838302C3232353436373435392C3232353530383338372C3232353537313332382C,0x3232353234383732332C3232353234393330342C3232353235393433352C3232353237303532312C3232353237313337342C3232353237373637312C3232353238303437362C3232353238333537342C3232353238343739342C3232353238353833382C3232353238373733392C3232353238393131382C3232353238393933312C3232353239343536302C3232353330323333342C3232353332343137372C3232353332363632332C3232353332383333362C3232353332383638382C3232353333353334312C3232353334363331352C3232353335353536332C3232353336363734362C3232353336373233372C3232353337343236312C3232353338333535352C3232353339343036362C3232353339373334382C3232353430303036312C3232353430313838332C3232353431343936302C3232353434383235382C3232353435333937362C3232353436373534332C3232353530383437392C3232353537323434392C),
 (35,'CDC42BPA.cApr07','chr1','-',225244188,225572449,225248591,225571506,35,0x3232353234343138382C3232353234393134362C3232353235393331372C3232353237303430332C3232353237313235302C3232353237373538362C3232353238303337382C3232353238323938302C3232353238343733312C3232353238353632312C3232353238373635372C3232353238383937382C3232353238393739342C3232353239343435342C3232353330323235302C3232353332343130302C3232353332363533312C3232353332383138372C3232353332383538322C3232353333353231362C3232353334363230392C3232353335353331352C3232353336363633352C3232353337343132372C3232353338333433322C3232353339333839392C3232353339373236382C3232353339393831322C3232353430313638322C3232353431343836362C3232353434383130392C3232353435333838302C3232353436373435392C3232353530383338372C3232353537313332382C,0x3232353234383732332C3232353234393330342C3232353235393433352C3232353237303532312C3232353237313337342C3232353237373637312C3232353238303437362C3232353238333537342C3232353238343739342C3232353238353833382C3232353238373733392C3232353238393131382C3232353238393933312C3232353239343536302C3232353330323333342C3232353332343137372C3232353332363632332C3232353332383333362C3232353332383638382C3232353333353334312C3232353334363331352C3232353335353536332C3232353336363734362C3232353337343236312C3232353338333535352C3232353339343036362C3232353339373334382C3232353430303036312C3232353430313838332C3232353431343936302C3232353434383235382C3232353435333937362C3232353436373534332C3232353530383437392C3232353537323434392C),
 (35,'CDC42BPA.bApr07','chr1','-',225247047,225572815,225248591,225571506,35,0x3232353234373034372C3232353234393134362C3232353235393331372C3232353237303430332C3232353237313235302C3232353237373538362C3232353238303337382C3232353238323938302C3232353238343733312C3232353238353632312C3232353238373635372C3232353238383937382C3232353238393739342C3232353239343435342C3232353332343130302C3232353332363533312C3232353332383138372C3232353332383538322C3232353333353231362C3232353334363230392C3232353335353331352C3232353336363633352C3232353336363939342C3232353337343132372C3232353338333433322C3232353339333839392C3232353339373236382C3232353339393831322C3232353430313638322C3232353431343836362C3232353434383130392C3232353435333838302C3232353436373435392C3232353530383338372C3232353537313332382C,0x3232353234383732332C3232353234393330342C3232353235393433352C3232353237303532312C3232353237313337342C3232353237373637312C3232353238303437362C3232353238333537342C3232353238343739342C3232353238353833382C3232353238373733392C3232353238393131382C3232353238393933312C3232353239343536302C3232353332343137372C3232353332363632332C3232353332383333362C3232353332383638382C3232353333353334312C3232353334363331352C3232353335353536332C3232353336363734362C3232353336373233372C3232353337343236312C3232353338333535352C3232353339343036362C3232353339373334382C3232353430303036312C3232353430313838332C3232353431343936302C3232353434383235382C3232353435333937362C3232353436373534332C3232353530383437392C3232353537323831352C),
 (35,'CDC42BPA.fApr07','chr1','-',225374153,225498324,225374154,225498221,7,0x3232353337343135332C3232353338333433322C3232353339333839392C3232353339373236382C3232353339393831322C3232353436373435392C3232353439383139372C,0x3232353337343236312C3232353338333535352C3232353339343036362C3232353339373334382C3232353339393837332C3232353436373534332C3232353439383332342C),
 (36,'C1orf96.bApr07','chr1','-',227523375,227545668,227527604,227544835,4,0x3232373532333337352C3232373532393130372C3232373534343436382C3232373534353238312C,0x3232373532373738312C3232373532393337362C3232373534343838332C3232373534353636382C),
 (36,'C1orf96.eApr07','chr1','-',227523385,227543003,227527604,227542795,3,0x3232373532333338352C3232373532393130372C3232373534323737302C,0x3232373532373738312C3232373532393337362C3232373534333030332C),
 (36,'C1orf96.aApr07','chr1','-',227525916,227545664,227529855,227545663,4,0x3232373532353931362C3232373532393130372C3232373534343436382C3232373534353238312C,0x3232373532373738312C3232373532393932382C3232373534343838332C3232373534353636342C),
 (36,'C1orf96.cApr07','chr1','-',227527493,227544923,227527604,227544923,4,0x3232373532373439332C3232373532393130372C3232373534343436382C3232373534343838332C,0x3232373532373738312C3232373532393337362C3232373534343537392C3232373534343932332C),
 (36,'C1orf96.dApr07','chr1','-',227529221,227544926,227529221,227544835,2,0x3232373532393232312C3232373534343436382C,0x3232373532393337362C3232373534343932362C),
 (36,'PGBD5.bApr07','chr1','-',228553353,228628098,228553353,228628096,3,0x3232383535333335332C3232383535393236322C3232383632373936362C,0x3232383535333436312C3232383535393639302C3232383632383039382C),
 (36,'SIPA1L2.aApr07','chr1','-',230600333,230833060,230601495,230717708,22,0x3233303630303333332C3233303630343736302C3233303630353831362C3233303630363439332C3233303631373836322C3233303632373935372C3233303633303737392C3233303633343631352C3233303634313437362C3233303634333635392C3233303634343133362C3233303634353937302C3233303634373839372C3233303636333235352C3233303636373230382C3233303637333733392C3233303638313939352C3233303638363136302C3233303639333234322C3233303639353839352C3233303731363232352C3233303833323739382C,0x3233303630313634322C3233303630343834322C3233303630353934302C3233303630363534372C3233303631373939342C3233303632383137372C3233303633303933332C3233303633343834302C3233303634313836352C3233303634333736332C3233303634343233372C3233303634363035342C3233303634383135352C3233303636333533302C3233303636373738352C3233303637333839372C3233303638323039392C3233303638363333352C3233303639333433312C3233303639363032392C3233303731373937372C3233303833333036302C),
 (36,'GNG4.eApr07','chr1','-',233777595,233880961,233782031,233813761,3,0x3233333737373539352C3233333831333636322C3233333838303437312C,0x3233333738323136302C3233333831333737312C3233333838303936312C),
 (36,'GNG4.dApr07','chr1','-',233780765,233879933,233782031,233813761,4,0x3233333738303736352C3233333831333636322C3233333832353332322C3233333837393538342C,0x3233333738323136302C3233333831333737312C3233333832353433342C3233333837393933332C),
 (36,'GNG4.bApr07','chr1','-',233781867,233880534,233782031,233813761,4,0x3233333738313836372C3233333831333636322C3233333832353332322C3233333838303437312C,0x3233333738323136302C3233333831333737312C3233333832353433342C3233333838303533342C),
 (36,'GNG4.fApr07','chr1','-',233782062,233879665,0,0,5,0x3233333738323036322C3233333831333636322C3233333832323731342C3233333832353332322C3233333837393538342C,0x3233333738323136302C3233333831333737312C3233333832323836322C3233333832353433342C3233333837393636352C),
 (37,'RYR2.aApr07','chr1','+',235272323,236063913,235272324,236062570,105,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
 (37,'CHRM3.gApr07','chr1','+',237616488,238116519,0,0,9,0x3233373631363438382C3233373732323633312C3233373737353536332C3233373836323134362C3233373930383130382C3233373934383731382C3233383035363737352C3233383035373137342C3233383131363031312C,0x3233373631373135302C3233373732323733302C3233373737353637322C3233373836323230392C3233373930383231312C3233373934383832322C3233383035373030342C3233383035373330312C3233383131363531392C),
 (37,'CHRM3.kApr07','chr1','+',237638028,238057208,0,0,6,0x3233373633383032382C3233373732323633312C3233373737353536332C3233373836323134362C3233373930383130382C3233383035373137342C,0x3233373633383137322C3233373732323733302C3233373737353637322C3233373836323230392C3233373930383231312C3233383035373230382C),
 (37,'CHRM3.eApr07','chr1','+',237843434,238137596,237843490,238057242,4,0x3233373834333433342C3233373930383130382C3233383035373137342C3233383133373335352C,0x3233373834333534312C3233373930383231312C3233383035373330312C3233383133373539362C),
 (37,'CHRM3.bApr07','chr1','+',237858995,238139537,238137374,238139147,5,0x3233373835383939352C3233373836323134362C3233373930383130382C3233383035373137342C3233383133373335352C,0x3233373835393436322C3233373836323230392C3233373930383231312C3233383035373330312C3233383133393533372C),
 (37,'CHRM3.dApr07','chr1','+',237949465,238137703,238137374,238137701,3,0x3233373934393436352C3233383035373137342C3233383133373335352C,0x3233373934393537372C3233383035373330312C3233383133373730332C),
 (37,'RGS7.bApr07','chr1','-',239005436,239587013,239006085,239585699,17,0x3233393030353433362C3233393033323832362C3233393033363036322C3233393034313834302C3233393034333534302C3233393034343633382C3233393034363233392C3233393035373032302C3233393039383530392C3233393039383639382C3233393039393937372C3233393136303633392C3233393136363532322C3233393231333030312C3233393332383538382C3233393538353632312C3233393538363832312C,0x3233393030363133362C3233393033323931362C3233393033363234392C3233393034313936362C3233393034333635312C3233393034343730302C3233393034363333382C3233393035373039352C3233393039383539312C3233393039383737352C3233393130303034322C3233393136303639312C3233393136363632392C3233393231333035322C3233393332383638352C3233393538353734392C3233393538373031332C),
 (37,'RGS7.dApr07','chr1','-',239005437,239098718,239030569,239098718,12,0x3233393030353433372C3233393033303536332C3233393033313337372C3233393033323832362C3233393033363036322C3233393034313834302C3233393034333534302C3233393034343633382C3233393034363233392C3233393035373032302C3233393039383530392C3233393039383639382C,0x3233393030363133362C3233393033303634342C3233393033313433312C3233393033323931362C3233393033363234392C3233393034313936362C3233393034333635312C3233393034343730302C3233393034363333382C3233393035373039352C3233393039383539312C3233393039383731382C),
 (37,'RGS7.aApr07','chr1','-',239005482,239587132,239006085,239585699,18,0x3233393030353438322C3233393033313337372C3233393033323832362C3233393033363036322C3233393034313834302C3233393034333534302C3233393034343633382C3233393034363233392C3233393035373032302C3233393039383530392C3233393039383639382C3233393039393937372C3233393136303633392C3233393136363532322C3233393231333030312C3233393332383538382C3233393538353632312C3233393538363832312C,0x3233393030363133362C3233393033313433312C3233393033323931362C3233393033363234392C3233393034313936362C3233393034333635312C3233393034343730302C3233393034363333382C3233393035373039352C3233393039383539312C3233393039383737352C3233393130303034322C3233393136303639312C3233393136363632392C3233393231333035322C3233393332383638352C3233393538353734392C3233393538373133322C),
 (37,'RGS7.cApr07','chr1','-',239005952,239213052,239030569,239213050,15,0x3233393030353935322C3233393033303536332C3233393033323832362C3233393033363036322C3233393034313834302C3233393034333534302C3233393034343633382C3233393034363233392C3233393035373032302C3233393039383530392C3233393039383639382C3233393039393937372C3233393136303633392C3233393136363532322C3233393231333030312C,0x3233393030363133362C3233393033303634342C3233393033323931362C3233393033363234392C3233393034313936362C3233393034333635312C3233393034343730302C3233393034363333382C3233393035373039352C3233393039383539312C3233393039383737352C3233393130303034322C3233393136303639312C3233393136363632392C3233393231333035322C),
 (37,'RGS7.eApr07','chr1','-',239043540,239166548,239043542,239166548,9,0x3233393034333534302C3233393034343633382C3233393034363233392C3233393035373032302C3233393039383530392C3233393039383638382C3233393039393937372C3233393136303633392C3233393136363532322C,0x3233393034333635312C3233393034343730302C3233393034363333382C3233393035373039352C3233393039383539312C3233393039383737352C3233393130303034322C3233393136303639312C3233393136363534382C),
 (37,'EXO1.lApr07','chr1','+',240115294,240125074,240115295,240124943,3,0x3234303131353239342C3234303132323434382C3234303132343932382C,0x3234303131353433322C3234303132323534352C3234303132353037342C),
 (37,'weykloy.bApr07','chr1','+',242147325,242254961,0,0,8,0x3234323134373332352C3234323230383333342C3234323233333330372C3234323233343938322C3234323233393934352C3234323234303632312C3234323234353838352C3234323235343839332C,0x3234323134373435312C3234323230383434342C3234323233333432352C3234323233353038332C3234323234303031372C3234323234303834352C3234323234353936362C3234323235343936312C),
 (37,'weykloy.aApr07','chr1','+',242147326,242277240,0,0,12,0x3234323134373332362C3234323230383333342C3234323233333330372C3234323233343938322C3234323233393934352C3234323234303632312C3234323235343839302C3234323235373136302C3234323237313335312C3234323237333334372C3234323237353135322C3234323237363831362C,0x3234323134373435312C3234323230383434342C3234323233333432352C3234323233353038332C3234323234303031372C3234323234303834352C3234323235343939342C3234323235373335392C3234323237313438302C3234323237333437342C3234323237353231362C3234323237373234302C),
 (38,'SMYD3.cApr07','chr1','-',243978980,244737266,243979487,244737142,12,0x3234333937383938302C3234333939333936352C3234343038383432302C3234343039333732332C3234343134353435342C3234343135373835352C3234343135393739342C3234343535373132352C3234343536303430342C3234343536353239312C3234343538343935352C3234343733363937382C,0x3234333937393538392C3234333939343037342C3234343038383539352C3234343039333831312C3234343134353536352C3234343135373935382C3234343135393836322C3234343535373236322C3234343536303436322C3234343536353339392C3234343538353031392C3234343733373236362C),
 (38,'SMYD3.dApr07','chr1','-',243979266,244647337,243979487,244585006,12,0x3234333937393236362C3234333939333936352C3234343038383432302C3234343039333732332C3234343134353435342C3234343135373835352C3234343135393739342C3234343535373132352C3234343536303430342C3234343536353239312C3234343538343935352C3234343634373232302C,0x3234333937393538392C3234333939343037342C3234343038383539352C3234343039333831312C3234343134353536352C3234343135373935382C3234343135393836322C3234343535373236322C3234343536303436322C3234343536353339392C3234343538353031392C3234343634373333372C),
 (38,'SMYD3.hApr07','chr1','-',243979267,244450597,243979573,244450597,7,0x3234333937393236372C3234343038383432302C3234343039333732332C3234343134353435342C3234343135373835352C3234343135393739342C3234343435303434372C,0x3234333937393538392C3234343038383539352C3234343039333831312C3234343134353536352C3234343135373935382C3234343135393836322C3234343435303539372C),
 (38,'SMYD3.eApr07','chr1','-',243979271,244585259,243979581,244585006,12,0x3234333937393237312C3234333939333936352C3234343038383431362C3234343039333732332C3234343134353435342C3234343135373835352C3234343135393739342C3234343535373132352C3234343536303430342C3234343536353239312C3234343538343935352C3234343538353130352C,0x3234333937393538392C3234333939343037342C3234343038383539352C3234343039333831312C3234343134353536352C3234343135373935382C3234343135393836322C3234343535373236322C3234343536303436322C3234343536353339392C3234343538353031392C3234343538353235392C),
 (38,'SMYD3.aApr07','chr1','-',243979272,244737163,243979581,244737163,9,0x3234333937393237322C3234333939333936352C3234333939383734392C3234343038383432302C3234343535373132352C3234343536303430342C3234343536353239312C3234343538343935352C3234343733363937382C,0x3234333937393538392C3234333939343037342C3234333939383831302C3234343038383536392C3234343535373236322C3234343536303436322C3234343536353339392C3234343538353031392C3234343733373136332C),
 (38,'SMYD3.bApr07','chr1','-',243979273,244326348,243979487,244159826,8,0x3234333937393237332C3234333939333936352C3234343038383432302C3234343039333733332C3234343134353435342C3234343135373835352C3234343135393739342C3234343332363136382C,0x3234333937393538392C3234333939343037342C3234343038383539352C3234343039333831312C3234343134353536352C3234343135373935382C3234343135393836322C3234343332363334382C),
 (38,'SMYD3.lApr07','chr1','-',243979274,244536057,244044336,244535960,9,0x3234333937393237342C3234333939333936352C3234343034343236362C3234343038383432302C3234343039333732332C3234343134353435342C3234343135373835352C3234343135393739342C3234343533353930302C,0x3234333937393538392C3234333939343037342C3234343034343334302C3234343038383539352C3234343039333831312C3234343134353536352C3234343135373935382C3234343135393836322C3234343533363035372C),
 (38,'SMYD3.iApr07','chr1','-',243979331,244557167,243979487,244557167,7,0x3234333937393333312C3234333939333936352C3234343038383432302C3234343039333732332C3234343135373835352C3234343135393739342C3234343535373132352C,0x3234333937393538392C3234333939343037342C3234343038383539352C3234343039333831312C3234343135373935382C3234343135393836322C3234343535373136372C),
 (38,'SMYD3.oApr07','chr1','-',244088419,244416871,244088419,244159826,6,0x3234343038383431392C3234343039333732332C3234343134353435342C3234343135373835352C3234343135393739342C3234343431363636372C,0x3234343038383539352C3234343039333831312C3234343134353536352C3234343135373935382C3234343135393836322C3234343431363837312C),
 (38,'SMYD3.pApr07','chr1','-',244282879,244713689,244282901,244585006,6,0x3234343238323837392C3234343535373132352C3234343536303430342C3234343536353239312C3234343538343935352C3234343731333335392C,0x3234343238323939342C3234343535373236322C3234343536303436322C3234343536353339392C3234343538353031392C3234343731333638392C),
 (38,'jeeleebo.aApr07','chr1','+',244303066,244318520,0,0,2,0x3234343330333036362C3234343331383433322C,0x3234343330333430342C3234343331383532302C),
 (38,'ZNF124.hApr07','chr1','-',245351900,245401930,245353792,245401802,4,0x3234353335313930302C3234353338383933302C3234353338393631312C3234353430313737322C,0x3234353335333739362C3234353338383939312C3234353338393733382C3234353430313933302C),
 (38,'ZNF124.jApr07','chr1','-',245351900,245401937,0,0,2,0x3234353335313930302C3234353430313930352C,0x3234353335333739362C3234353430313933372C),
 (38,'ZNF124.iApr07','chr1','-',245353427,245379875,245353781,245379875,3,0x3234353335333432372C3234353336383634302C3234353337393738322C,0x3234353335333739362C3234353336383638322C3234353337393837352C),
 (38,'ZNF124.nApr07','chr1','-',245353432,245379864,0,0,2,0x3234353335333433322C3234353337393738322C,0x3234353335333831362C3234353337393836342C),
 (38,'ZNF124.oApr07','chr1','-',245353439,245379830,0,0,2,0x3234353335333433392C3234353337393738322C,0x3234353335333739362C3234353337393833302C),
 (73,'spawrubo.aApr07','chr1','-',519921,533401,519921,533401,3,0x3531393932312C3532363634302C3533333139372C,0x3531393939392C3532363832302C3533333430312C),
 (73,'plapeybo.aApr07','chr1','-',651002,674513,651940,653062,14,0x3635313030322C3635323830362C3635353134302C3635373235392C3635383232332C3635383534392C3636303636352C3636313632392C3636313935352C3636343037362C3636353337312C3636383532382C3637313933372C3637343438302C,0x3635323239332C3635353034372C3635353139382C3635373435302C3635383435362C3635383630372C3636303835362C3636313836322C3636323031332C3636343236372C3636353432392C3636383539332C3637323036312C3637343531332C),
 (73,'plapeybo.hApr07','chr1','-',654530,663570,654574,663267,2,0x3635343533302C3636333232372C,0x3635343733352C3636333537302C),
 (73,'plapeybo.dApr07','chr1','-',655140,669598,664191,665374,10,0x3635353134302C3635373235392C3635383534392C3636303636352C3636313935352C3636343037362C3636353034352C3636353337312C3636383532382C3636393433372C,0x3635353139382C3635373435302C3635383630372C3636303835362C3636323031332C3636343236372C3636353237382C3636353432392C3636383539332C3636393539382C),
 (74,'UBE2J2.gApr07','chr1','-',1179150,1199128,1180445,1193235,7,0x313137393135302C313138313238372C313138323233342C313138323435302C313138383538382C313139333130342C313139383930382C,0x313138303733302C313138313336382C313138323337332C313138323535332C313138383632392C313139333233352C313139393132382C),
 (74,'UBE2J2.fApr07','chr1','-',1179150,1199085,1180445,1193235,7,0x313137393135302C313138313238372C313138323233342C313138323435302C313138383538382C313139333130342C313139383734312C,0x313138303733302C313138313336382C313138323337332C313138323535332C313138383632392C313139333233352C313139393038352C),
 (74,'UBE2J2.lApr07','chr1','-',1179154,1199096,1180445,1188604,6,0x313137393135342C313138313238372C313138323233342C313138323435302C313138383538382C313139383930382C,0x313138303733302C313138313336382C313138323337332C313138323535332C313138383632392C313139393039362C),
 (74,'UBE2J2.kApr07','chr1','-',1179154,1199096,1180445,1188604,7,0x313137393135342C313138313238372C313138323233342C313138323435302C313138383538382C313139323937352C313139383930382C,0x313138303733302C313138313336382C313138323337332C313138323535332C313138383632392C313139333233352C313139393039362C),
 (74,'UBE2J2.dApr07','chr1','-',1179154,1199096,1180445,1193235,8,0x313137393135342C313138313238372C313138323233342C313138323435302C313138383538382C313139303032352C313139333130342C313139383930382C,0x313138303733302C313138313336382C313138323337332C313138323535332C313138383632392C313139303037332C313139333233352C313139393039362C),
 (74,'UBE2J2.bApr07','chr1','-',1179156,1199093,1180445,1193180,8,0x313137393135362C313138313238372C313138323233342C313138323435302C313138383538382C313139313334302C313139333130342C313139383930382C,0x313138303733302C313138313336382C313138323337332C313138323535332C313138383632392C313139313533332C313139333233352C313139393039332C),
 (74,'CCNL2andAURKAIP1.bApr07','chr1','-',1299947,1324574,1299948,1316805,14,0x313239393934372C313331323437372C313331333031392C313331333139362C313331353437322C313331353730312C313331363030382C313331363533392C313331373932312C313331383633382C313332303633362C313332333437352C313332333833392C313332343236312C,0x313330303033332C313331323832352C313331333131322C313331333330382C313331353631342C313331353830362C313331363130382C313331363831382C313331383034362C313331383730332C313332303735372C313332333538352C313332333931342C313332343537342C),
 (74,'ATAD3A.fApr07','chr1','+',1430370,1448800,1441286,1448798,9,0x313433303337302C313434313235342C313434323535332C313434323935382C313434343136332C313434353338332C313434353739302C313434373938362C313434383735332C,0x313433303433342C313434313333312C313434323635352C313434333031382C313434343233332C313434353534392C313434353836302C313434383134322C313434383830302C),
 (74,'ATAD3A.aApr07','chr1','+',1437386,1455914,1437511,1454841,16,0x313433373338362C313434313235342C313434323535332C313434323935382C313434343136332C313434353338332C313434353739302C313434373938362C313434383735332C313434393038312C313434393531352C313435303438322C313435313730332C313435323430332C313435323933372C313435343436352C,0x313433373731362C313434313333312C313434323635352C313434333031382C313434343233332C313434353534392C313434353836302C313434383134322C313434383831302C313434393230372C313434393634302C313435303533342C313435313737342C313435323438312C313435333130352C313435353931342C),
 (74,'ATAD3A.cApr07','chr1','+',1437394,1459930,1437511,1459315,16,0x313433373339342C313434313235342C313434323535332C313434323935382C313434343136332C313434353338332C313434353739302C313434373938362C313434383735332C313434393038312C313434393531352C313435303438322C313435313730332C313435323933372C313435343436352C313435393136382C,0x313433373731362C313434313333312C313434323635352C313434333031382C313434343233332C313434353534392C313434353836302C313434383134322C313434383831302C313434393230372C313434393634302C313435303533342C313435313737342C313435333130352C313435343537342C313435393933302C),
 (74,'ATAD3A.eApr07','chr1','+',1437414,1448095,1437416,1448094,9,0x313433373431342C313433373536382C313434313235342C313434323535332C313434323935382C313434343136332C313434353338332C313434353739302C313434373938362C,0x313433373438322C313433373731362C313434313333312C313434323635352C313434333031382C313434343233332C313434353534392C313434353836302C313434383039352C),
 (74,'ATAD3A.hApr07','chr1','+',1437418,1444233,1437419,1444232,6,0x313433373431382C313433383035392C313434313236352C313434323535332C313434323935382C313434343136332C,0x313433373731362C313433383036352C313434313333312C313434323635352C313434333031382C313434343233332C),
 (74,'ATAD3A.bApr07','chr1','+',1437418,1459928,1437511,1459315,16,0x313433373431382C313434313235342C313434323430392C313434323935382C313434343136332C313434353338332C313434353739302C313434373938362C313434383735332C313434393038312C313434393531352C313435303438322C313435313730332C313435323933372C313435343436352C313435393136382C,0x313433373731362C313434313333312C313434323635352C313434333031382C313434343233332C313434353534392C313434353836302C313434383134322C313434383831302C313434393230372C313434393634302C313435303533342C313435313737342C313435333130352C313435343537342C313435393932382C),
 (74,'ATAD3A.jApr07','chr1','+',1437629,1445431,1441058,1445430,7,0x313433373632392C313434303837362C313434313235342C313434323535332C313434323935382C313434343136332C313434353338332C,0x313433373731362C313434313130312C313434313333312C313434323635352C313434333031382C313434343233332C313434353433312C),
 (74,'ATAD3A.dApr07','chr1','+',1437773,1459930,1437779,1459315,16,0x313433373737332C313434313235342C313434323535332C313434323935382C313434343136332C313434353338332C313434353739302C313434373938362C313434383735332C313434393038312C313434393531352C313435303438322C313435313730332C313435323933372C313435343436352C313435393136382C,0x313433373933332C313434313333312C313434323635352C313434333031382C313434343233332C313434353534392C313434353836302C313434383134322C313434383831302C313434393230372C313434393634302C313435303533342C313435313737342C313435333130352C313435343537342C313435393933302C),
 (74,'SLC35E2andCDC2L1andCDC2L2.aApr07','chr1','-',1560463,1645331,1560988,1645330,20,0x313536303436332C313536313136312C313536313535372C313536313930362C313536323132312C313536323330352C313536323633322C313536323938362C313536333732342C313536353530302C313536363237312C313536363838352C313536373132392C313536373630392C313537303334392C313633373634342C313634303632362C313634323839342C313634343030362C313634353234372C,0x313536313038312C313536313335312C313536313730362C313536323032332C313536323232392C313536323432372C313536323733382C313536333130382C313536333831352C313536353637362C313536363333372C313536373034342C313536373232352C313536373733322C313537303438362C313633373737372C313634303735342C313634333031302C313634343133302C313634353333312C),
 (75,'SKI.aApr07','chr1','+',2149993,2231512,2149993,2228064,7,0x323134393939332C323232343237362C323232343538332C323232353133382C323232353539312C323232373331382C323232373837352C,0x323135313033342C323232343430322C323232343639392C323232353430312C323232353838342C323232373534392C323233313531322C),
 (75,'geyvoybo.cApr07','chr1','+',2485947,2505835,0,0,7,0x323438353934372C323438363238322C323438373130392C323438383638322C323530323835382C323530343636382C323530353432332C,0x323438363030322C323438363535312C323438373239382C323438383837382C323530323934392C323530343739342C323530353833352C),
 (75,'geyvoybo.aApr07','chr1','+',2485967,2499165,2488230,2490390,6,0x323438353936372C323438363238322C323438383638322C323438393136342C323439303237352C323439383437312C,0x323438363030322C323438383235352C323438383837382C323438393335332C323439313138372C323439393136352C),
 (75,'PRDM16.gApr07','chr1','+',2975606,3093015,2975683,3092916,2,0x323937353630362C333039323534382C,0x323937353732302C333039333031352C),
 (76,'MEGF6.aApr07','chr1','-',3394358,3517919,3396951,3517917,37,0x333339343335382C333339373333352C333339393036322C333430303139342C333430303431392C333430303739342C333430313033362C333430323331332C333430333037382C333430333431312C333430333635362C333430343739342C333430353132312C333430353536312C333430363031312C333430363231392C333430373035362C333430373338392C333430373630302C333430383231392C333431313633312C333431313834352C333431323533312C333431343231382C333431343938312C333431353439382C333431363239332C333431373230362C333431373937332C333431383432392C333432303937332C333432313832352C333433303534372C333438363234382C333530313736312C333530383838392C333531373536312C,0x333339373031332C333339373338332C333339393139312C333430303332332C333430303534382C333430303932332C333430313136352C333430323434322C333430333230372C333430333534332C333430333738352C333430343932332C333430353235302C333430353639302C333430363134302C333430363334382C333430373138382C333430373531382C333430373733322C333430383334352C333431313736362C333431313938302C333431323636302C333431343334372C333431353131332C333431353636392C333431363431362C333431373332362C333431383131312C333431383535322C333432313039362C333432313935312C333433303637302C333438363335332C333530313837312C333530393032342C333531373931392C),
 (76,'MEGF6.bApr07','chr1','-',3396343,3437872,3396951,3437669,30,0x333339363334332C333339373333352C333339393036322C333430303139342C333430303739342C333430313033362C333430323331332C333430333037382C333430333635362C333430343739342C333430363031312C333430363231392C333430373035362C333430373338392C333430373630302C333430383231392C333431313633312C333431313834352C333431323533312C333431343231382C333431343938312C333431353439382C333431363239332C333431373230362C333431373937332C333431383432392C333432303937332C333432313832352C333433303534372C333433373530332C,0x333339373031332C333339373338332C333339393139312C333430303232312C333430303932332C333430313136352C333430323434322C333430333230372C333430333738352C333430343932332C333430363134302C333430363334382C333430373138382C333430373531382C333430373733322C333430383334352C333431313736362C333431313938302C333431323636302C333431343334372C333431353131332C333431353636392C333431363431362C333431373332362C333431383131312C333431383535322C333432313039362C333432313935312C333433303637302C333433373837322C),
 (76,'WDR8.aApr07','chr1','-',3537189,3556517,3537398,3556423,12,0x333533373138392C333533373838392C333533383633362C333533393832312C333534313432302C333534313538332C333534323336372C333534333431382C333534353137332C333535333038392C333535333833312C333535363335342C,0x333533373534312C333533383038312C333533383736322C333533393932372C333534313439382C333534313731382C333534323435342C333534333532322C333534353234362C333535333230362C333535333938342C333535363531372C),
 (76,'WDR8.kApr07','chr1','-',3537190,3546049,3543295,3545294,2,0x333533373139302C333534353137332C,0x333534333532322C333534363034392C),
 (76,'WDR8.bApr07','chr1','-',3537190,3556526,3537821,3556423,11,0x333533373139302C333533383633362C333533393832312C333534313432302C333534313538332C333534323336372C333534333431382C333534353137332C333535333038392C333535333833312C333535363335342C,0x333533383038312C333533383736322C333533393932372C333534313439382C333534313731382C333534323435342C333534333532322C333534353234362C333535333230362C333535333938342C333535363532362C),
 (76,'WDR8.cApr07','chr1','-',3537916,3556514,3537917,3556514,11,0x333533373931362C333533383633362C333533393832312C333534313432302C333534313538332C333534323336372C333534333431382C333534353137332C333535333038392C333535333832392C333535363335342C,0x333533383038312C333533383734312C333533393932372C333534313439382C333534313731382C333534323435342C333534333532322C333534353234362C333535333230362C333535333938342C333535363531342C),
 (76,'WDR8.dApr07','chr1','-',3538037,3559185,3539813,3559184,10,0x333533383033372C333533383633362C333534313432302C333534313538332C333534323336372C333534333431382C333534353137332C333535333038392C333535333833312C333535393133362C,0x333533383038312C333533393932372C333534313439382C333534313731382C333534323435342C333534333532322C333534353234362C333535333230362C333535333938342C333535393138352C),
 (76,'WDR8.eApr07','chr1','-',3538710,3556474,3538712,3556423,9,0x333533383731302C333533393832312C333534313432302C333534323336372C333534333431382C333534353137332C333535333038392C333535333833312C333535363335342C,0x333533383736322C333533393932372C333534313439382C333534323435342C333534333532322C333534353234362C333535333230362C333535333938342C333535363437342C),
 (76,'CCDC27.aApr07','chr1','+',3658822,3678069,3658905,3677947,12,0x333635383832322C333636303534312C333636313838302C333636333135362C333636373730342C333636393034332C333636393533312C333637303132392C333637323935382C333637333635362C333637363230362C333637373832342C,0x333635393232332C333636303636352C333636313939312C333636333331342C333636373835342C333636393133362C333636393839382C333637303236302C333637333033362C333637333836392C333637363331312C333637383036392C),
 (76,'C1orf174.aApr07','chr1','-',3795551,3806680,3796383,3801802,6,0x333739353535312C333739363939322C333739393330362C333830313731382C333830323031302C333830363539352C,0x333739363439372C333739373438312C333739393432302C333830313936362C333830323630372C333830363638302C),
 (76,'C1orf174.bApr07','chr1','-',3795552,3806714,3796383,3806610,4,0x333739353535322C333739363939322C333739393330362C333830363539352C,0x333739363439372C333739373438312C333739393432302C333830363731342C),
 (76,'C1orf174.dApr07','chr1','-',3797282,3806714,3799168,3806610,3,0x333739373238322C333739393136342C333830363539352C,0x333739373438312C333739393432302C333830363731342C),
 (76,'C1orf174.cApr07','chr1','-',3797973,3806685,3799168,3806610,3,0x333739373937332C333739393136342C333830363539352C,0x333739383230332C333739393432302C333830363638352C),
 (76,'C1orf174.eApr07','chr1','-',3798684,3806716,3799168,3806610,2,0x333739383638342C333830363539352C,0x333739393432302C333830363731362C),
 (77,'AJAP1.bApr07','chr1','+',4614651,4743711,4615345,4734419,6,0x343631343635312C343637313831392C343732393737322C343733323139392C343733343334362C343734323436342C,0x343631353337342C343637323631392C343732393836302C343733323434352C343733343437382C343734333731312C),
 (77,'AJAP1.aApr07','chr1','+',4614964,4737799,4615345,4734419,6,0x343631343936342C343637313831392C343732393737322C343733323139392C343733343334362C343733373332302C,0x343631353337342C343637323631392C343732393836302C343733323434352C343733343437382C343733373739392C),
 (78,'sheyrerbo.aApr07','chr1','-',5544355,5650901,5544840,5650798,3,0x353534343335352C353534353831362C353635303738372C,0x353534343930312C353534363030322C353635303930312C),
 (78,'sheyrerbo.bApr07','chr1','-',5561552,5650945,0,0,3,0x353536313535322C353537303031342C353635303738372C,0x353536313638382C353537303232322C353635303934352C),
 (78,'NPHP4.aApr07','chr1','-',5845456,5975126,5845911,5968936,30,0x353834353435362C353834363533362C353834363938342C353834373734382C353834393031392C353834393637362C353835303338362C353835353839382C353835373131372C353835373532302C353835393733392C353836323736302C353836393933322C353837333531342C353838373236332C353838373933382C353838383237382C353838393736312C353839313739382C353931303239352C353931353739332C353932393735302C353933303731362C353933353334362C353934343434302C353934393934352C353935313733332C353936303931362C353936383830312C353937343839302C,0x353834363035322C353834363638302C353834373136342C353834373932302C353834393130352C353834393736322C353835303534332C353835353938322C353835373330342C353835373734372C353835393934352C353836323838362C353837303131332C353837333637352C353838373435312C353838383133302C353838383433302C353838393836392C353839313836302C353931303433342C353931353937362C353932393837372C353933303839382C353933353438332C353934343539362C353935303031302C353935313930362C353936313036302C353936383937342C353937353132362C),
 (78,'NPHP4.bApr07','chr1','-',5845457,5975173,5845911,5910370,26,0x353834353435372C353834363533362C353834363938342C353834373734382C353834393031392C353834393637362C353835303338362C353835353839382C353835373131372C353835373532302C353835393733392C353836323736302C353836393933322C353837333531342C353838373236332C353838373933382C353838383237382C353931303239352C353931353739332C353932393735302C353933303731362C353933353334362C353934343434302C353934393934352C353935313733332C353937343839302C,0x353834363035322C353834363638302C353834373136342C353834373932302C353834393130352C353834393736322C353835303534332C353835353938322C353835373330342C353835373734372C353835393934352C353836323838362C353837303131332C353837333637352C353838373435312C353838383133302C353838383433302C353931303433342C353931353937362C353932393837372C353933303839382C353933353438332C353934343539362C353935303031302C353935313930362C353937353137332C),
 (78,'NPHP4.cApr07','chr1','-',5845459,5975121,5862151,5968936,33,0x353834353435392C353834363533362C353834363938342C353834373734382C353834393031392C353834393637362C353835303338362C353835353839382C353835373131372C353835373532302C353835383630302C353835393033322C353835393733392C353836313939322C353836323736302C353836393933322C353837333531342C353838373236332C353838373933382C353838383237382C353838393736312C353839313739382C353931303239352C353931353739332C353932393735302C353933303731362C353933353334362C353934343434302C353934393934352C353935313733332C353936303931362C353936383830312C353937343839302C,0x353834363035322C353834363638302C353834373136342C353834373932302C353834393130352C353834393736322C353835303534332C353835353938322C353835373330342C353835373734372C353835383732352C353835393137302C353835393934352C353836323237392C353836323838362C353837303131332C353837333637352C353838373435312C353838383133302C353838383432372C353838393836392C353839313836302C353931303433342C353931353937362C353932393837372C353933303839382C353933353438332C353934343539362C353935303031302C353935313930362C353936313036302C353936383937342C353937353132312C),
 (78,'KCNAB2.pApr07','chr1','+',5973574,6073066,6023215,6073064,10,0x353937333537342C363032333136332C363032343437372C363035353430312C363035363337392C363036343834312C363036373835302C363037303131332C363037313635342C363037333033352C,0x353937333639302C363032333239322C363032343531392C363035353434352C363035363431372C363036343932312C363036373839352C363037303135382C363037313639382C363037333036362C),
 (78,'KCNAB2.mApr07','chr1','+',5973967,6073093,6023215,6073091,10,0x353937333936372C363032333136332C363032343437372C363035353430312C363035363337392C363036343834312C363036373835302C363037303131332C363037313635342C363037333033352C,0x353937343230332C363032333239322C363032343531392C363035353434352C363035363431372C363036343932312C363036373839352C363037303135382C363037313639382C363037333039332C),
 (78,'KCNAB2.aApr07','chr1','+',5975248,6083839,6023215,6083689,12,0x353937353234382C363032333136332C363035353430312C363035363337392C363036343834312C363036373835302C363037303131332C363037313635342C363037333033352C363037373034362C363037373936392C363038333333362C,0x353937353433352C363032333239322C363035353434352C363035363431372C363036343932312C363036373839352C363037303135382C363037313639382C363037333132322C363037373133322C363037383035332C363038333833392C),
 (78,'KCNAB2.gApr07','chr1','+',5975257,6078028,6023215,6078026,12,0x353937353235372C363032333136332C363032343437372C363035353430312C363035363337392C363036343834312C363036373835302C363037303131332C363037313635342C363037333033352C363037373034362C363037373936392C,0x353937353433352C363032333239322C363032343531392C363035353434352C363035363431372C363036343932312C363036373839352C363037303135382C363037313639382C363037333132322C363037373133322C363037383032382C),
 (78,'KCNAB2.jApr07','chr1','+',5975318,6069009,6023215,6068961,10,0x353937353331382C353937383530392C363032333136332C363032343437372C363035353430312C363035363337392C363036343834312C363036373835302C363036383338362C363036383830342C,0x353937353433352C353937383733312C363032333239322C363032343531392C363035353434352C363035363431372C363036343932312C363036373839352C363036383434302C363036393030392C),
 (78,'KCNAB2.hApr07','chr1','+',5975323,6069010,6023215,6068696,9,0x353937353332332C363030313238312C363032333136332C363032343437372C363035353430312C363035363337392C363036343834312C363036373835302C363036383338362C,0x353937353433352C363030313438322C363032333239322C363032343531392C363035353434352C363035363431372C363036343932312C363036373839352C363036393031302C),
 (78,'KCNAB2.qApr07','chr1','+',5975350,6071654,6023215,6071652,9,0x353937353335302C363032333136332C363032343437372C363035353430312C363035363337392C363036343834312C363036373835302C363037303131332C363037313630362C,0x353937353433352C363032333239322C363032343531392C363035353434352C363035363431372C363036343932312C363036373839352C363037303135382C363037313635342C),
 (78,'KCNAB2.vdApr07','chr1','+',5975352,6056494,6023215,6056492,5,0x353937353335322C363032333136332C363032343437372C363035353430312C363035363337392C,0x353937353433352C363032333239322C363032343531392C363035353434352C363035363439342C),
 (78,'KCNAB2.oApr07','chr1','+',5975358,6071698,6023215,6071697,10,0x353937353335382C363032333136332C363032343437372C363035353430312C363035363337392C363036343834312C363036373835302C363036383338362C363037303131332C363037313635342C,0x353937353433352C363032333239322C363032343531392C363035353434352C363035363431372C363036343932312C363036373839352C363036383434302C363037303135382C363037313639382C),
 (78,'KCNAB2.iApr07','chr1','+',5975364,6077065,6023215,6077063,12,0x353937353336342C363032333136332C363032343437372C363035353430312C363035363337392C363036343834312C363036373835302C363037303131332C363037313635342C363037333033352C363037333930392C363037373034362C,0x353937353433352C363032333239322C363032343531392C363035353434352C363035363431372C363036343932312C363036373839352C363037303135382C363037313639382C363037333132322C363037333935342C363037373036352C),
 (78,'KCNAB2.eApr07','chr1','+',6008541,6083833,6023215,6081221,16,0x363030383534312C363032333136332C363032343437372C363035353430312C363035363337392C363036343834312C363036373835302C363037303131332C363037313635342C363037333033352C363037373034362C363037373936392C363037383137362C363037393238322C363037393931352C363038313133312C,0x363030393039322C363032333239322C363032343531392C363035353434352C363035363431372C363036343932312C363036373839352C363037303135382C363037313639382C363037333132322C363037373133322C363037383039302C363037383237312C363037393430332C363038303030342C363038333833332C),
 (78,'KCNAB2.fApr07','chr1','+',6008933,6083826,6023215,6081221,15,0x363030383933332C363032333136332C363035353430312C363035363337392C363036343834312C363036373835302C363037303131332C363037313635342C363037333033352C363037373034362C363037373936392C363037383137362C363037393238322C363037393931352C363038313133312C,0x363030393039322C363032333239322C363035353434352C363035363431372C363036343932312C363036373839352C363037303135382C363037313639382C363037333132322C363037373133322C363037383039302C363037383237312C363037393430332C363038303030342C363038333832362C),
 (78,'KCNAB2.cApr07','chr1','+',6008966,6081208,6023215,6080178,15,0x363030383936362C363032333136332C363032343437372C363035353430312C363035363337392C363036343834312C363036373835302C363037303131332C363037313635342C363037333033352C363037373034362C363037373936392C363037383137362C363037393238322C363037393931352C,0x363030393039322C363032333239322C363032343531392C363035353434352C363035363431372C363036343932312C363036373839352C363037303135382C363037313639382C363037333132322C363037373133322C363037383039302C363037383237312C363037393430332C363038313230382C),
 (78,'KCNAB2.vhApr07','chr1','+',6008981,6070158,0,0,8,0x363030383938312C363032333136332C363035353430312C363035363030302C363035363337392C363036343834312C363036373835302C363037303131332C,0x363030393039322C363032333239322C363035353434352C363035363033312C363035363431372C363036343932312C363036373839352C363037303135382C),
 (78,'KCNAB2.tApr07','chr1','+',6009020,6065092,6023215,6065057,5,0x363030393032302C363032333136332C363035353430312C363035363337392C363036343834312C,0x363030393039322C363032333239322C363035353434352C363035363431372C363036353039322C),
 (78,'KCNAB2.vcApr07','chr1','+',6009943,6067895,6023215,6067893,6,0x363030393934332C363032333136332C363035353430312C363035363337392C363036343834312C363036373835302C,0x363031303130362C363032333239322C363035353434352C363035363431372C363036343932312C363036373839352C),
 (78,'KCNAB2.dApr07','chr1','+',6016930,6083833,6023215,6081221,16,0x363031363933302C363032333136332C363032343437372C363035353430312C363035363337392C363036343834312C363036373835302C363037303131332C363037313635342C363037333033352C363037373034362C363037373936392C363037383137362C363037393238322C363037393931352C363038313133312C,0x363031373434312C363032333239322C363032343531392C363035353434352C363035363431372C363036343932312C363036373839352C363037303135382C363037313639382C363037333132322C363037373133322C363037383039302C363037383237312C363037393430332C363038303030342C363038333833332C),
 (78,'KCNAB2.vbApr07','chr1','+',6017324,6070147,6023215,6070147,8,0x363031373332342C363032333136332C363032343437372C363035353430312C363035363337392C363036343834312C363036373835302C363037303131332C,0x363031373631302C363032333239322C363032343531392C363035353434352C363035363431372C363036343932312C363036373839352C363037303134372C),
 (78,'KCNAB2.sApr07','chr1','+',6017626,6068438,6023215,6068438,8,0x363031373632362C363032333136332C363032343437372C363035353430312C363035363337392C363036343834312C363036373835302C363036383338362C,0x363031373831392C363032333239322C363032343531392C363035353434352C363035363431372C363036343932312C363036373839352C363036383433382C),
 (78,'KCNAB2.lApr07','chr1','+',6017654,6073118,6023215,6073118,10,0x363031373635342C363032333136332C363032343437372C363035353430312C363035363337392C363036343834312C363036373835302C363037303131332C363037313635342C363037333033352C,0x363031373831392C363032333239322C363032343531392C363035353434352C363035363431372C363036343932312C363036373839352C363037303135382C363037313639382C363037333131382C),
 (78,'KCNAB2.uApr07','chr1','+',6018585,6070155,6023215,6070153,8,0x363031383538352C363032333136332C363032343437372C363035353430312C363035363337392C363036343834312C363036373835302C363037303131332C,0x363031383639352C363032333239322C363032343531392C363035353434352C363035363431372C363036343932312C363036373839352C363037303135352C),
 (78,'KCNAB2.bApr07','chr1','+',6028568,6083841,6034183,6081221,16,0x363032383536382C363033343135372C363035353430312C363035363337392C363036343834312C363036373835302C363037303131332C363037313635342C363037333033352C363037333930392C363037373034362C363037373936392C363037383137362C363037393238322C363037393931352C363038313133312C,0x363032383833302C363033343430312C363035353434352C363035363431372C363036343932312C363036373839352C363037303135382C363037313639382C363037333132322C363037333935342C363037373133322C363037383039302C363037383237312C363037393430332C363038303030342C363038333834312C),
 (78,'KCNAB2.vjApr07','chr1','+',6028762,6070158,0,0,6,0x363032383736322C363035353430312C363035363337392C363036343834312C363036373835302C363037303131332C,0x363032393030342C363035353434352C363035363431372C363036343932312C363036373839352C363037303135382C),
 (78,'KCNAB2.nApr07','chr1','+',6028762,6078054,6064841,6078053,10,0x363032383736322C363035353430312C363035363337392C363036343834312C363036373835302C363037303131332C363037313635342C363037333033352C363037373034362C363037373936392C,0x363032383833302C363035353434352C363035363431372C363036343932312C363036373839352C363037303135382C363037313639382C363037333132322C363037373133322C363037383035342C),
 (78,'RPL22andCHD5.aApr07','chr1','-',6084433,6162781,6088926,6162670,42,0x363038343433332C363038383838302C363038393034312C363038393236322C363039323434312C363039333034302C363039343432312C363039343738362C363039353535352C363130333735312C363130343134302C363130363539342C363130373136332C363130373734362C363130383137302C363130383431322C363130393231382C363131303639322C363131313134352C363131313438342C363131323835302C363131343237372C363131363737342C363131373336342C363131373837362C363131393136332C363131393337342C363132343737342C363132353036302C363132363436392C363132363637302C363132383835382C363132393331312C363133313530302C363133313839322C363133333637382C363133353035382C363133373330362C363133383234352C363134313938322C363135303739362C363136323539312C,0x363038383037342C363038383933342C363038393135362C363038393432362C363039323633372C363039333137332C363039343533302C363039343932342C363039353634352C363130333838342C363130343232302C363130363735342C363130373330382C363130373838302C363130383235392C363130383530352C363130393339332C363131303836352C363131313235362C363131313731362C363131323937352C363131343339352C363131363930362C363131373530362C363131383035302C363131393238352C363131393531322C363132343937352C363132353235322C363132363537382C363132363830322C363132393037302C363132393531382C363133313732322C363133323035392C363133333830322C363133353138332C363133373534352C363133383336342C363134323136322C363135303932342C363136323738312C),
 (78,'RPL22andCHD5.nApr07','chr1','-',6142084,6182023,6142084,6164000,6,0x363134323038342C363135303739362C363136333931352C363137353537362C363138303239382C363138313432362C,0x363134323136322C363135303932342C363136343133332C363137353730312C363138303430332C363138323032332C),
 (78,'suyaro.aApr07-unspliced','chr1','-',6159758,6161094,6160102,6160954,1,0x363135393735382C,0x363136313039342C),
 (79,'ESPN.aApr07','chr1','+',6407434,6443591,6407602,6442793,13,0x363430373433342C363431303837322C363432323930302C363432333237322C363432333538302C363432373132372C363432383331302C363433313238372C363433343234392C363433343437392C363433393833302C363434303030372C363434323634352C,0x363430373839362C363431313036362C363432333038372C363432333435352C363432333731322C363432373332392C363432383538322C363433313733382C363433343339352C363433343734332C363433393931302C363434303031392C363434333539312C),
 (79,'TAS1R1.cApr07','chr1','+',6537574,6562404,6538020,6561482,4,0x363533373537342C363535333535352C363535373237372C363536313239392C,0x363533383231312C363535333836322C363535383033392C363536323430342C),
 (79,'TAS1R1.dApr07','chr1','+',6538020,6562404,6538020,6562085,5,0x363533383032302C363535333535352C363535393036312C363535393539362C363536313934322C,0x363533383231312C363535333836322C363535393237342C363535393731372C363536323430342C),
 (79,'TAS1R1.bApr07','chr1','+',6538020,6562404,6538020,6562231,5,0x363533383032302C363535333535352C363535393036312C363535393539362C363536313239392C,0x363533383231312C363535333836322C363535393237342C363535393731372C363536323430342C),
 (79,'TAS1R1.aApr07','chr1','+',6538020,6562404,6538020,6562231,6,0x363533383032302C363535333535352C363535373237372C363535393036312C363535393539362C363536313239392C,0x363533383231312C363535333836322C363535383033392C363535393237342C363535393731372C363536323430342C),
 (79,'TAS1R1.eApr07','chr1','+',6543310,6557918,6553859,6557916,4,0x363534333331302C363534353233322C363535333733312C363535373237372C,0x363534333431342C363534353236342C363535333836322C363535373931382C),
 (79,'TAS1R1.fApr07','chr1','+',6543342,6559207,6553598,6559205,3,0x363534333334322C363535333535352C363535393036312C,0x363534333434362C363535333836322C363535393230372C),
 (79,'CAMTA1.jApr07','chr1','+',6768092,6870841,6768093,6854412,5,0x363736383039322C363830323832372C363830373733382C363835343430332C363837303330302C,0x363736383232322C363830323839372C363830373835372C363835343438372C363837303834312C),
 (79,'CAMTA1.kApr07','chr1','+',6768094,6854696,6768096,6854412,4,0x363736383039342C363830323832372C363830373733382C363835343430332C,0x363736383232322C363830323839372C363830373835372C363835343639362C),
 (79,'CAMTA1.nApr07','chr1','+',6768099,6854700,6768101,6854412,3,0x363736383039392C363830373733382C363835343430332C,0x363736383232322C363830373835372C363835343730302C),
 (79,'CAMTA1.oApr07','chr1','+',6768109,6870848,6768110,6854412,4,0x363736383130392C363830373733382C363835343430332C363837303330302C,0x363736383232322C363830373835372C363835343438372C363837303834382C),
 (79,'CAMTA1.iApr07','chr1','+',6768137,6870848,6768138,6870372,4,0x363736383133372C363830323832372C363830373733382C363837303330302C,0x363736383232322C363830323839372C363830373835372C363837303834382C),
 (79,'CAMTA1.lApr07','chr1','+',6768161,6854663,6768162,6854412,4,0x363736383136312C363738393632392C363830373733382C363835343430332C,0x363736383232322C363738393733352C363830373835372C363835343636332C),
 (79,'CAMTA1.pApr07','chr1','+',6768200,6854667,6789702,6854412,5,0x363736383230302C363738393632392C363830323832372C363830373733382C363835343430332C,0x363736383232322C363738393733352C363830323839372C363830373835372C363835343636372C),
 (80,'CAMTA1.tApr07','chr1','+',7694398,7749560,0,0,4,0x373639343339382C373733353132322C373733383238342C373734393130352C,0x373639343934382C373733353138302C373733383331352C373734393536302C),
 (80,'CAMTA1.sApr07','chr1','+',7710957,7750393,0,0,3,0x373731303935372C373731353039342C373735303039392C,0x373731313535392C373731353133342C373735303339332C),
 (80,'CAMTA1.bApr07','chr1','+',7714673,7750490,7715108,7749169,12,0x373731343637332C373731383939302C373731393537372C373731393930312C373732303630352C373732373438312C373732383439312C373733303335362C373733323431372C373733333834352C373733353130352C373734393130352C,0x373731353234362C373731393138372C373731393635362C373732303231372C373732313132392C373732373636392C373732383733382C373733303432382C373733323433382C373733343033392C373733353138302C373735303439302C),
 (80,'CAMTA1.cApr07','chr1','+',7720155,7749169,7721021,7749169,8,0x373732303135352C373732303934342C373732373438312C373732383439312C373733303335362C373733333834352C373733353130352C373734393130352C,0x373732303231372C373732313132392C373732373636392C373732383733382C373733303432382C373733343033392C373733353138302C373734393136392C),
 (80,'CAMTA1.dApr07','chr1','+',7727560,7750498,7727562,7749169,6,0x373732373536302C373732383533332C373733303335362C373733333834352C373733353130352C373734393130352C,0x373732373636392C373732383733382C373733303432382C373733343033392C373733353138302C373735303439382C),
 (80,'UTS2.aApr07','chr1','-',7825325,7895881,7826589,7835650,8,0x373832353332352C373832393333382C373833303435302C373833323238362C373833333435382C373833353534372C373833353935332C373839353832372C,0x373832363539372C373832393431332C373833303532392C373833323333302C373833333536392C373833353736352C373833363135322C373839353838312C),
 (80,'UTS2.eApr07','chr1','-',7830261,7895903,7832247,7835966,5,0x373833303236312C373833323134372C373833333435382C373833353935332C373839353832372C,0x373833303831342C373833323333302C373833333536392C373833363135322C373839353930332C),
 (80,'UTS2.bApr07','chr1','-',7830261,7895834,7830412,7836078,6,0x373833303236312C373833323238362C373833333435382C373833353534372C373833353935332C373839353832372C,0x373833303532392C373833323333302C373833333536392C373833353537302C373833363135322C373839353833342C),
 (80,'ERRFI1.gApr07','chr1','-',7987050,8008934,0,0,3,0x373938373035302C373939383134312C383030383830342C,0x373938373230352C373939383333392C383030383933342C);
INSERT INTO `aceview_hg18_housekeeping` (`bin`,`name`,`chrom`,`strand`,`txStart`,`txEnd`,`cdsStart`,`cdsEnd`,`exonCount`,`exonStarts`,`exonEnds`) VALUES 
 (80,'ERRFI1.aApr07','chr1','-',7993318,8009005,7995856,7998266,4,0x373939333331382C373939373935342C373939383134312C383030383830342C,0x373939373034332C373939383033312C373939383333392C383030393030352C),
 (80,'ERRFI1.bApr07','chr1','-',7994373,8008934,7995856,7997020,3,0x373939343337332C373939383134312C383030383830342C,0x373939383033312C373939383333392C383030383933342C),
 (80,'ERRFI1.cApr07','chr1','-',7994381,8008903,0,0,3,0x373939343338312C373939373832312C383030383830342C,0x373939343933322C373939383333392C383030383930332C),
 (81,'RERE.eApr07','chr1','-',8447616,8736483,8448307,8638943,11,0x383434373631362C383437373730392C383438303035312C383439313237322C383532333835392C383533393132302C383534303036332C383539373230362C383630363935352C383633383631382C383733363037362C,0x383434383637302C383437373830392C383438303137362C383439313332312C383532333936342C383533393231372C383534303136392C383539373333322C383630373032362C383633393038372C383733363438332C),
 (81,'RERE.iApr07','chr1','-',8540092,8685865,8540094,8638943,4,0x383534303039322C383630363935352C383633383631382C383638353730302C,0x383534303136392C383630373032362C383633393038372C383638353836352C),
 (81,'RERE.jApr07','chr1','-',8638637,8707339,8638637,8638943,2,0x383633383633372C383730373230352C,0x383633393038372C383730373333392C),
 (81,'SLC2A5.aApr07','chr1','-',9019585,9052343,9020231,9052182,12,0x393031393538352C393032303534322C393032313037362C393032313437332C393032323139372C393032323434352C393032323730392C393032343433302C393033303235352C393034303039332C393034303739372C393035323134392C,0x393032303433352C393032303637302C393032313135322C393032313537352C393032323330382C393032323633332C393032323833352C393032343538332C393033303338302C393034303235342C393034303839362C393035323334332C),
 (81,'SLC2A5.bApr07','chr1','-',9021059,9052286,9021059,9024560,7,0x393032313035392C393032313437332C393032323139372C393032323434352C393032323730392C393032343433302C393035323134392C,0x393032313135322C393032313537352C393032323330382C393032323633332C393032323833352C393032343538332C393035323238362C),
 (81,'SLC2A5.kApr07','chr1','-',9022252,9076120,9022566,9052182,10,0x393032323235322C393032323434352C393032323730392C393033303334332C393034303039332C393034303739372C393035323134392C393036373635392C393037333633352C393037363035392C,0x393032323330382C393032323633332C393032323735332C393033303338302C393034303235342C393034303839362C393035323234302C393036373831322C393037333731312C393037363132302C),
 (81,'SLC2A5.cApr07','chr1','-',9022712,9071131,9022713,9052182,8,0x393032323731322C393032343433302C393033303235352C393034303039332C393034303739372C393035323134392C393036373635392C393037313031372C,0x393032323833352C393032343538332C393033303338302C393034303235342C393034303839362C393035323234302C393036373831322C393037313133312C),
 (81,'SLC2A5.dApr07','chr1','-',9022732,9054367,9022734,9052182,7,0x393032323733322C393032343433302C393033303235352C393034303039332C393034303739372C393035323134392C393035343331382C,0x393032323833352C393032343538332C393033303338302C393034303235342C393034303839362C393035323234302C393035343336372C),
 (81,'SLC2A5.eApr07','chr1','-',9022753,9054916,9022755,9052182,7,0x393032323735332C393032343433302C393033303235352C393034303039332C393034303739372C393035323134392C393035343639342C,0x393032323833352C393032343538332C393033303338302C393034303235342C393034303839362C393035323234302C393035343931362C),
 (81,'SLC2A5.fApr07','chr1','-',9024383,9076132,9024383,9052182,7,0x393032343338332C393033303235352C393034303039332C393034303739372C393035323134392C393036373635392C393037363035392C,0x393032343538332C393033303338302C393034303235342C393034303839362C393035323234302C393036373831322C393037363133322C),
 (81,'SLC2A5.gApr07','chr1','-',9024430,9055773,9024431,9052182,7,0x393032343433302C393033303235352C393034303039332C393034303739372C393035323134392C393035343934392C393035353732312C,0x393032343538332C393033303338302C393034303235342C393034303839362C393035323234302C393035353033312C393035353737332C),
 (81,'SLC2A5.iApr07','chr1','-',9024503,9071102,9024503,9052182,7,0x393032343530332C393033303235352C393034303039332C393034303739372C393035323134392C393036373635392C393037313031372C,0x393032343538332C393033303338302C393034303235342C393034303839362C393035323234302C393036373737322C393037313130322C),
 (81,'SLC2A5.jApr07','chr1','-',9024531,9071082,9024533,9052182,8,0x393032343533312C393033303235352C393034303039332C393034303739372C393035323134392C393035343934392C393036373635392C393037313031372C,0x393032343538332C393033303338302C393034303235342C393034303839362C393035323234302C393035353033312C393036373738382C393037313038322C),
 (81,'SLC2A5.nApr07','chr1','-',9024546,9052281,9032225,9052182,6,0x393032343534362C393033303235352C393033323232332C393034303132312C393034303739372C393035323134392C,0x393032343538332C393033303338302C393033323235312C393034303235342C393034303839362C393035323238312C),
 (81,'SLC2A5.lApr07','chr1','-',9030256,9071100,9030256,9052182,6,0x393033303235362C393034303039332C393034303739372C393035323134392C393036373635392C393037313031372C,0x393033303338302C393034303235342C393034303839362C393035323234302C393036373738382C393037313130302C),
 (81,'SLC2A5.mApr07','chr1','-',9030332,9052275,9030334,9051830,5,0x393033303333322C393034303039332C393034303739372C393035313832372C393035323134392C,0x393033303338302C393034303235342C393034303839362C393035313937372C393035323237352C),
 (81,'SLC2A5.qApr07','chr1','-',9031864,9052228,0,0,2,0x393033313836342C393035323134392C,0x393033323334332C393035323232382C),
 (81,'SLC2A5.oApr07','chr1','-',9040143,9052497,9040143,9052182,4,0x393034303134332C393034303739372C393035323134392C393035323334332C,0x393034303235342C393034303839362C393035323234302C393035323439372C),
 (81,'LOC727721.aApr07','chr1','-',9164484,9181551,9164648,9181197,3,0x393136343438342C393137393535372C393138303937382C,0x393136343934312C393137393632392C393138313535312C),
 (81,'SPSB1.aApr07','chr1','+',9275527,9352178,9275563,9350221,3,0x393237353532372C393333383338382C393335303039332C,0x393237353731372C393333393233312C393335323137382C),
 (82,'PIK3CD.jApr07','chr1','+',9634376,9711554,9634378,9693091,5,0x393633343337362C393634373234302C393637343131312C393639333036382C393731313133342C,0x393633343434372C393634373430332C393637343231362C393639333039352C393731313535342C),
 (82,'PIK3CD.bApr07','chr1','+',9634376,9713349,9693100,9709691,24,0x393633343337362C393637343131312C393639333036382C393639383138352C393639383439332C393639393038342C393639393630332C393730303138312C393730313333382C393730323536352C393730323735362C393730333235352C393730333338362C393730333737312C393730343038382C393730343430352C393730343631392C393730343838382C393730353137322C393730353736392C393730363631332C393730363932302C393730373434382C393730393535332C,0x393633343434372C393637343231362C393639333234312C393639383431342C393639383732332C393639393236342C393639393735332C393730303237312C393730313536302C393730323636322C393730323838372C393730333330362C393730333535342C393730333839332C393730343233322C393730343530352C393730343739382C393730353030312C393730353235312C393730353933372C393730363733372C393730373036362C393730373538312C393731333334392C),
 (82,'PIK3CD.dApr07','chr1','+',9634404,9711556,9693100,9710689,5,0x393633343430342C393639323734392C393639333036382C393639383138352C393731303536392C,0x393633343434372C393639323932352C393639333234312C393639383339382C393731313535362C),
 (82,'PIK3CD.cApr07','chr1','+',9672190,9700226,9693100,9698909,7,0x393637323139302C393637343131312C393639333036382C393639383138352C393639383439332C393639393630332C393730303138312C,0x393637323336362C393637343231362C393639333234312C393639383431342C393639393236342C393639393735332C393730303232362C),
 (82,'PIK3CD.aApr07','chr1','+',9692842,9709872,9693100,9709691,23,0x393639323834322C393639333036382C393639383138352C393639383439332C393639393038342C393639393730382C393730303138312C393730313333382C393730323536352C393730323735362C393730333037382C393730333338362C393730333737312C393730343038382C393730343430352C393730343631392C393730343838382C393730353137322C393730353736392C393730363631332C393730363932302C393730373434382C393730393535332C,0x393639323932352C393639333234312C393639383431342C393639383732332C393639393236342C393639393735332C393730303237312C393730313536302C393730323636322C393730323838372C393730333330362C393730333535342C393730333839332C393730343233322C393730343530352C393730343739382C393730353030312C393730353235312C393730353933372C393730363733372C393730373036362C393730373538312C393730393837322C),
 (82,'CLSTN1.cApr07','chr1','-',9711666,9832612,9713152,9756034,18,0x393731313636362C393731333835302C393731343430352C393731363034352C393731363631362C393731373539322C393731383131312C393731383532392C393732333733382C393732363532382C393732373033392C393733323130352C393733323430382C393733343131372C393733373735382C393733393132352C393735353931362C393833323438382C,0x393731333335302C393731343033352C393731343534312C393731363139312C393731363738372C393731373831392C393731383236302C393731383638372C393732333930312C393732363635302C393732373238382C393733323239312C393733323535382C393733343332362C393733373935342C393733393135352C393735363033392C393833323631322C),
 (82,'slorkoybu.cApr07','chr1','+',9828923,9833560,9831109,9833541,4,0x393832383932332C393833303936322C393833323031332C393833333333342C,0x393832393034302C393833313131322C393833323131392C393833333536302C),
 (82,'NMNAT1.cApr07','chr1','+',9925582,9965316,9954718,9965316,5,0x393932353538322C393935343636322C393935383233362C393936333637352C393936343934352C,0x393932353637302C393935343833332C393935383432302C393936333831352C393936353331362C),
 (82,'NMNAT1.dApr07','chr1','+',9926072,9964411,9954718,9963944,5,0x393932363037322C393935343636322C393935383233362C393936333637352C393936333930302C,0x393932363136302C393935343833332C393935383432302C393936333831352C393936343431312C),
 (82,'NMNAT1.bApr07','chr1','+',9926072,9968146,9954718,9965346,5,0x393932363037322C393935343636322C393935383233362C393936333637352C393936343934352C,0x393932363136302C393935343833332C393935383432302C393936333831352C393936383134362C),
 (82,'NMNAT1.eApr07','chr1','+',9926098,9963837,9954718,9963835,4,0x393932363039382C393935343636322C393935383233362C393936333637352C,0x393932363136302C393935343833332C393935383432302C393936333833372C),
 (82,'NMNAT1.aApr07','chr1','+',9954661,9965928,9954661,9965346,4,0x393935343636312C393935383233362C393936333637352C393936343934352C,0x393935343833332C393935383432302C393936333831352C393936353932382C),
 (82,'NMNAT1.fApr07','chr1','+',9958236,9965173,9958238,9965021,2,0x393935383233362C393936343934352C,0x393935383432302C393936353137332C),
 (82,'UBE4B.aApr07','chr1','+',10015603,10163890,10016315,10162601,28,0x31303031353630332C31303035343637322C31303037383130352C31303038333735322C31303038353539322C31303038383136302C31303038383834312C31303130303130332C31303130323135372C31303130343630362C31303130393433382C31303131323033362C31303131333134342C31303131333335392C31303131353031332C31303131373633322C31303131393731312C31303132373538342C31303132393630372C31303133313832382C31303133333937302C31303134313030302C31303134333738362C31303135303738302C31303135333738322C31303136313238382C31303136323036302C31303136323533392C,0x31303031363333392C31303035343835392C31303037383234312C31303038333834302C31303038353733372C31303038383338392C31303038393232382C31303130303234352C31303130323235382C31303130343732312C31303130393532322C31303131323039332C31303131333236312C31303131333435382C31303131353132372C31303131373833312C31303131393835302C31303132373638342C31303132393733352C31303133313932372C31303133343230362C31303134313132372C31303134333933312C31303135303931352C31303135333937342C31303136313436332C31303136323230372C31303136333839302C),
 (82,'UBE4B.bApr07','chr1','+',10015610,10163884,10016315,10162601,27,0x31303031353631302C31303035343637322C31303037383130352C31303038333735322C31303038353539322C31303038383136302C31303130303130332C31303130323135372C31303130343630362C31303130393433382C31303131323033362C31303131333134342C31303131333335392C31303131353031332C31303131373633322C31303131393731312C31303132373538342C31303132393630372C31303133313832382C31303133333937302C31303134313030302C31303134333738362C31303135303738302C31303135333738322C31303136313238382C31303136323036302C31303136323533392C,0x31303031363333392C31303035343835392C31303037383234312C31303038333834302C31303038353733372C31303038383338392C31303130303234352C31303130323235382C31303130343732312C31303130393532322C31303131323039332C31303131333236312C31303131333435382C31303131353132372C31303131373833312C31303131393835302C31303132373638342C31303132393733352C31303133313932372C31303133343230362C31303134313132372C31303134333933312C31303135303931352C31303135333937342C31303136313436332C31303136323230372C31303136333838342C),
 (82,'UBE4B.dApr07','chr1','+',10089116,10113458,10089118,10113458,9,0x31303038393131362C31303038393836362C31303130303130332C31303130323135372C31303130343630362C31303130393433382C31303131323033362C31303131333134342C31303131333335392C,0x31303038393232382C31303039303031392C31303130303234352C31303130323235382C31303130343732312C31303130393532322C31303131323039332C31303131333236312C31303131333435382C),
 (82,'KIF1B.fApr07','chr1','+',10193346,10364248,10214973,10359232,47,0x31303139333334362C31303231343839342C31303233383839312C31303234313133372C31303234343534392C31303235303032342C31303235303739362C31303235343134362C31303235343838352C31303235383037322C31303235383936352C31303236303633302C31303236353034342C31303237333732362C31303237343639312C31303237373733302C31303237383330342C31303237393232362C31303237393534312C31303237393831382C31303330323638372C31303330343335332C31303330363532382C31303330373430322C31303330383735352C31303331373136342C31303331393330312C31303331393731382C31303332303031352C31303332323431332C31303332343639342C31303332353837362C31303332383438392C31303333303430352C31303333313239332C31303333353237352C31303334333537332C31303334343333362C31303334353932372C31303334373734342C31303334383035332C31303335313131312C31303335333738352C31303335363936302C31303335373439382C31303335373839392C31303335393138392C,0x31303139333532332C31303231353037392C31303233383936382C31303234313331372C31303234343631352C31303235303230332C31303235303930382C31303235343232342C31303235343935312C31303235383134382C31303235393034342C31303236303737332C31303236353137382C31303237333830362C31303237343736372C31303237373831302C31303237383431312C31303237393331302C31303237393732322C31303237393839312C31303330323738312C31303330343530322C31303330363730372C31303330373534302C31303330393030342C31303331373238332C31303331393338372C31303331393834382C31303332303137382C31303332323530342C31303332343831332C31303332353933322C31303332383539382C31303333303437322C31303333313337382C31303333353338312C31303334333638382C31303334343437302C31303334353938392C31303334373839302C31303334383239332C31303335313138332C31303335333930372C31303335373131302C31303335373639312C31303335383031382C31303336343234382C),
 (82,'KIF1B.hApr07','chr1','+',10193417,10291242,10214973,10287292,21,0x31303139333431372C31303231343839342C31303233383839312C31303234313133372C31303234343534392C31303235303032342C31303235303739362C31303235343134362C31303235343838352C31303235383037322C31303235383936352C31303236303633302C31303236353034342C31303237333732362C31303237343639312C31303237373733302C31303237383330342C31303237393232362C31303237393534312C31303237393831382C31303238353830372C,0x31303139333532332C31303231353037392C31303233383936382C31303234313331372C31303234343631352C31303235303230332C31303235303930382C31303235343232342C31303235343935312C31303235383134382C31303235393034342C31303236303737332C31303236353137382C31303237333830362C31303237343736372C31303237373831302C31303237383431312C31303237393331302C31303237393732322C31303237393839312C31303239313234322C),
 (82,'KIF1B.aApr07','chr1','+',10193518,10364248,10193518,10361047,49,0x31303139333531382C31303231343839342C31303233383839312C31303234313133372C31303234343534392C31303235303032342C31303235303739362C31303235343134362C31303235343838352C31303235353635382C31303235383037322C31303235383936352C31303236303633302C31303236313734312C31303236343936362C31303237333732362C31303237343639312C31303237373733302C31303237383330342C31303237393232362C31303237393534312C31303237393831382C31303330323638372C31303330343335332C31303330363532382C31303330373430322C31303330383735352C31303331373136342C31303331393330312C31303331393731382C31303332303031352C31303332323431332C31303332343639342C31303332353837362C31303332383438392C31303333303430352C31303333313239332C31303333353237352C31303334333537332C31303334343333362C31303334353932372C31303334373734342C31303334383035332C31303335313131312C31303335333738352C31303335363936302C31303335373439382C31303335373839392C31303336303938332C,0x31303139333532332C31303231353037392C31303233383936382C31303234313331372C31303234343631352C31303235303230332C31303235303930382C31303235343232342C31303235343935312C31303235353637362C31303235383134382C31303235393034342C31303236303737332C31303236313738332C31303236353137382C31303237333830362C31303237343736372C31303237373831302C31303237383431312C31303237393331302C31303237393732322C31303237393839312C31303330323738312C31303330343530322C31303330363730372C31303330373534302C31303330393030342C31303331373238332C31303331393338372C31303331393834382C31303332303137382C31303332323530342C31303332343831332C31303332353933322C31303332383539382C31303333303437322C31303333313337382C31303333353338312C31303334333638382C31303334343437302C31303334353938392C31303334373839302C31303334383239332C31303335313138332C31303335333930372C31303335373131302C31303335373639312C31303335383031382C31303336343234382C),
 (82,'KIF1B.bApr07','chr1','+',10194260,10360582,10214973,10359232,49,0x31303139343236302C31303231343839342C31303233383839312C31303234313133372C31303234343534392C31303235303032342C31303235303739362C31303235343134362C31303235343838352C31303235353635382C31303235383037322C31303235383936352C31303236303633302C31303236313734312C31303236343936362C31303237333732362C31303237343639312C31303237373733302C31303237383330342C31303237393232362C31303237393534312C31303237393831382C31303330323638372C31303330343335332C31303330363532382C31303330373430322C31303330383735352C31303331373136342C31303331393330312C31303331393731382C31303332303031352C31303332323431332C31303332343639342C31303332353837362C31303332383438392C31303333303430352C31303333313239332C31303333353237352C31303334333537332C31303334343333362C31303334353932372C31303334373734342C31303334383035332C31303335313131312C31303335333738352C31303335363936302C31303335373439382C31303335373839392C31303335393138392C,0x31303139343338332C31303231353037392C31303233383936382C31303234313331372C31303234343631352C31303235303230332C31303235303930382C31303235343232342C31303235343935312C31303235353637362C31303235383134382C31303235393034342C31303236303737332C31303236313738332C31303236353137382C31303237333830362C31303237343736372C31303237373831302C31303237383431312C31303237393331302C31303237393732322C31303237393839312C31303330323738312C31303330343530322C31303330363730372C31303330373534302C31303330393030342C31303331373238332C31303331393338372C31303331393834382C31303332303137382C31303332323530342C31303332343831332C31303332353933322C31303332383539382C31303333303437322C31303333313337382C31303333353338312C31303334333638382C31303334343437302C31303334353938392C31303334373839302C31303334383239332C31303335313138332C31303335333930372C31303335373131302C31303335373639312C31303335383031382C31303336303538322C),
 (82,'KIF1B.gApr07','chr1','+',10213408,10289600,10214973,10287292,21,0x31303231333430382C31303231343839342C31303233383839312C31303234313133372C31303234343534392C31303235303032342C31303235303739362C31303235343134362C31303235343838352C31303235383037322C31303235383936352C31303236303633302C31303236353034342C31303237333732362C31303237343639312C31303237373733302C31303237383330342C31303237393232362C31303237393534312C31303237393831382C31303238353830372C,0x31303231333634322C31303231353037392C31303233383936382C31303234313331372C31303234343631352C31303235303230332C31303235303930382C31303235343232342C31303235343935312C31303235383134382C31303235393034342C31303236303737332C31303236353137382C31303237333830362C31303237343736372C31303237373831302C31303237383431312C31303237393331302C31303237393732322C31303237393839312C31303238393630302C),
 (82,'KIF1B.eApr07','chr1','+',10214973,10364241,10214973,10361047,47,0x31303231343937332C31303233383839312C31303234313133372C31303234343534392C31303235303032342C31303235303739362C31303235343134362C31303235343838352C31303235353635382C31303235383037322C31303235383936352C31303236303633302C31303236353034342C31303237333732362C31303237343639312C31303237373733302C31303237383330342C31303237393232362C31303237393534312C31303237393831382C31303330323638372C31303330343335332C31303330363532382C31303330373430322C31303330383735352C31303331373136342C31303331393330312C31303331393731382C31303332303031352C31303332323431332C31303332343639342C31303332353837362C31303332383438392C31303333303430352C31303333313239332C31303333353237352C31303334333537332C31303334343333362C31303334353932372C31303334373734342C31303334383035332C31303335313131312C31303335333738352C31303335363936302C31303335373439382C31303335373839392C31303336303938332C,0x31303231353037392C31303233383936382C31303234313331372C31303234343631352C31303235303230332C31303235303930382C31303235343232342C31303235343935312C31303235353637362C31303235383134382C31303235393034342C31303236303737332C31303236353137382C31303237333830362C31303237343736372C31303237373831302C31303237383431312C31303237393331302C31303237393732322C31303237393839312C31303330323738312C31303330343530322C31303330363730372C31303330373534302C31303330393030342C31303331373238332C31303331393338372C31303331393834382C31303332303137382C31303332323530342C31303332343831332C31303332353933322C31303332383539382C31303333303437322C31303333313337382C31303333353338312C31303334333638382C31303334343437302C31303334353938392C31303334373839302C31303334383239332C31303335313138332C31303335333930372C31303335373131302C31303335373639312C31303335383031382C31303336343234312C),
 (82,'KIF1B.dApr07','chr1','+',10214973,10364241,10214973,10361047,48,0x31303231343937332C31303233383839312C31303234313133372C31303234343534392C31303235303032342C31303235303739362C31303235343134362C31303235343838352C31303235353635382C31303235383037322C31303235383936352C31303236303633302C31303236313734312C31303236353034342C31303237333732362C31303237343639312C31303237373733302C31303237383330342C31303237393232362C31303237393534312C31303237393831382C31303330323638372C31303330343335332C31303330363532382C31303330373430322C31303330383735352C31303331373136342C31303331393330312C31303331393731382C31303332303031352C31303332323431332C31303332343639342C31303332353837362C31303332383438392C31303333303430352C31303333313239332C31303333353237352C31303334333537332C31303334343333362C31303334353932372C31303334373734342C31303334383035332C31303335313131312C31303335333738352C31303335363936302C31303335373439382C31303335373839392C31303336303938332C,0x31303231353037392C31303233383936382C31303234313331372C31303234343631352C31303235303230332C31303235303930382C31303235343232342C31303235343935312C31303235353637362C31303235383134382C31303235393034342C31303236303737332C31303236313738332C31303236353137382C31303237333830362C31303237343736372C31303237373831302C31303237383431312C31303237393331302C31303237393732322C31303237393839312C31303330323738312C31303330343530322C31303330363730372C31303330373534302C31303330393030342C31303331373238332C31303331393338372C31303331393834382C31303332303137382C31303332323530342C31303332343831332C31303332353933322C31303332383539382C31303333303437322C31303333313337382C31303333353338312C31303334333638382C31303334343437302C31303334353938392C31303334373839302C31303334383239332C31303335313138332C31303335333930372C31303335373131302C31303335373639312C31303335383031382C31303336343234312C),
 (82,'KIF1B.cApr07','chr1','+',10214973,10364241,10214973,10361047,47,0x31303231343937332C31303233383839312C31303234313133372C31303234343534392C31303235303032342C31303235303739362C31303235343134362C31303235343838352C31303235353635382C31303235383037322C31303235383936352C31303236303633302C31303236343936362C31303237333732362C31303237343639312C31303237373733302C31303237383330342C31303237393232362C31303237393534312C31303237393831382C31303330323638372C31303330343335332C31303330363532382C31303330373430322C31303330383735352C31303331373136342C31303331393330312C31303331393731382C31303332303031352C31303332323431332C31303332343639342C31303332353837362C31303332383438392C31303333303430352C31303333313239332C31303333353237352C31303334333537332C31303334343333362C31303334353932372C31303334373734342C31303334383035332C31303335313131312C31303335333738352C31303335363936302C31303335373439382C31303335373839392C31303336303938332C,0x31303231353037392C31303233383936382C31303234313331372C31303234343631352C31303235303230332C31303235303930382C31303235343232342C31303235343935312C31303235353637362C31303235383134382C31303235393034342C31303236303737332C31303236353137382C31303237333830362C31303237343736372C31303237373831302C31303237383431312C31303237393331302C31303237393732322C31303237393839312C31303330323738312C31303330343530322C31303330363730372C31303330373534302C31303330393030342C31303331373238332C31303331393338372C31303331393834382C31303332303137382C31303332323530342C31303332343831332C31303332353933322C31303332383539382C31303333303437322C31303333313337382C31303333353338312C31303334333638382C31303334343437302C31303334353938392C31303334373839302C31303334383239332C31303335313138332C31303335333930372C31303335373131302C31303335373639312C31303335383031382C31303336343234312C),
 (82,'storvorbo.aApr07','chr1','-',10322376,10359327,0,0,2,0x31303332323337362C31303335393238342C,0x31303332323737362C31303335393332372C),
 (82,'KIF1B.iApr07','chr1','+',10328244,10364244,10328512,10359232,9,0x31303332383234342C31303333303430352C31303333313239332C31303333353237352C31303335373037382C31303335373439382C31303335373839392C31303335393138392C31303336343134302C,0x31303332383539382C31303333303437322C31303333313337382C31303333353332302C31303335373131302C31303335373639312C31303335383031382C31303335393332312C31303336343234342C),
 (83,'CASZ1.aApr07','chr1','-',10619247,10779294,10621585,10676533,21,0x31303631393234372C31303632353530322C31303632353830332C31303632373536302C31303632383737312C31303633303434342C31303633313731332C31303633313932362C31303633333333352C31303633333538342C31303633363032302C31303633373036322C31303633383239322C31303633393238392C31303634313135312C31303634323334352C31303634373732362C31303637363531372C31303638383133352C31303734333334342C31303737393230372C,0x31303632323730332C31303632353634342C31303632353935352C31303632373733322C31303632383937302C31303633303738332C31303633313833362C31303633323038312C31303633333339392C31303633333732302C31303633363836322C31303633373233352C31303633383435372C31303633393338302C31303634313232302C31303634333138302C31303634383231352C31303637363535362C31303638383138382C31303734333530312C31303737393239342C),
 (83,'CASZ1.bApr07','chr1','-',10629849,10779335,10630440,10676533,16,0x31303632393834392C31303633313731332C31303633313932362C31303633333333352C31303633333538342C31303633363032302C31303633373036322C31303633383239322C31303633393238392C31303634313135312C31303634323334352C31303634373732362C31303637363531372C31303638383133352C31303734333334342C31303737393230372C,0x31303633303738332C31303633313833362C31303633323038312C31303633333339392C31303633333732302C31303633363836322C31303633373233352C31303633383435372C31303633393338302C31303634313232302C31303634333138302C31303634383231352C31303637363535362C31303638383138382C31303734333530312C31303737393333352C),
 (83,'TARDBP.kApr07','chr1','+',11003230,11013172,11003231,11005892,5,0x31313030333233302C31313030343736372C31313030353833362C31313030363934352C31313031323832312C,0x31313030333234332C31313030343839342C31313030353937332C31313030363937392C31313031333137322C),
 (83,'TARDBP.qApr07','chr1','+',11007713,11020632,0,0,2,0x31313030373731332C31313032303334322C,0x31313030373835322C31313032303633322C),
 (83,'MASP2.aApr07','chr1','-',11009166,11029882,11009528,11029851,11,0x31313030393136362C31313031323831392C31313031333339312C31313031373437312C31313032303333362C31313032353531382C31313032353938322C31313032383035312C31313032393139392C31313032393533342C31313032393834362C,0x31313031303239322C31313031323839342C31313031333532362C31313031373535302C31313032303435352C31313032353636362C31313032363137392C31313032383138332C31313032393337372C31313032393736332C31313032393838322C),
 (83,'forreybo.aApr07-unspliced','chr1','+',11009172,11010652,0,0,1,0x31313030393137322C,0x31313031303635322C),
 (83,'MASP2.bApr07','chr1','-',11009962,11025842,11009963,11025738,5,0x31313030393936322C31313031323831392C31313031333339312C31313032303333362C31313032353531382C,0x31313031303239322C31313031323839342C31313031333532362C31313032303435352C31313032353834322C),
 (83,'FRAP1.aApr07','chr1','-',11089174,11245200,11090128,11242053,58,0x31313038393137342C31313039303832342C31313039313933332C31313039323239322C31313039353439352C31313039363936312C31313039373435362C31313039383033392C31313039393634372C31313130333838392C31313130343632322C31313130373134312C31313130393236352C31313130393635332C31313131303236372C31313131303634372C31313131313039372C31313131313439382C31313131323338312C31313131333137322C31313131353732332C31313131363939342C31313132313934372C31313132323137362C31313132373239312C31313132373631312C31313132393331392C31313133323736392C31313133393739352C31313135303038352C31313138313930312C31313138323138342C31313138373230342C31313139313935352C31313139333435372C31313139343935352C31313139353433392C31313139363034322C31313139383739312C31313231313331312C31313231333536382C31313231333934332C31313231353037392C31313231363034312C31313231363738362C31313232303438362C31313232313034352C31313232323934362C31313232343139362C31313232353735372C31313233303236382C31313233303436322C31313233363438322C31313233383633352C31313233393537362C31313234313132382C31313234313839312C31313234353038382C,0x31313039303134342C31313039303933302C31313039323031342C31313039323337332C31313039353536312C31313039373039372C31313039373533312C31313039383131322C31313039393733302C31313130343031322C31313130343737302C31313130373237372C31313130393434302C31313130393738382C31313131303435302C31313131303737302C31313131313139362C31313131313539352C31313131323438322C31313131333432312C31313131353834312C31313131373131302C31313132323037392C31313132323330322C31313132373339392C31313132373638392C31313132393433352C31313133323837302C31313133393933352C31313135303136312C31313138323034372C31313138323334372C31313138373334372C31313139323130322C31313139333535302C31313139353131382C31313139353535322C31313139363231302C31313139383837382C31313231313536322C31313231333639382C31313231343037382C31313231353137322C31313231363133312C31313231363930392C31313232303639322C31313232313236312C31313232333139312C31313232343332352C31313232353934342C31313233303337372C31313233303733382C31313233363631372C31313233383833362C31313233393830392C31313234313233372C31313234323036372C31313234353230302C),
 (83,'FRAP1.iApr07','chr1','-',11129425,11182168,11131323,11150106,6,0x31313132393432352C31313133313238352C31313133323736392C31313133393739352C31313135303038352C31313138313930312C,0x31313132393433352C31313133313337392C31313133323837302C31313133393933352C31313135303136312C31313138323136382C),
 (83,'UBIAD1.bApr07','chr1','+',11255902,11277808,11256175,11277527,2,0x31313235353930322C31313237373531362C,0x31313235363730342C31313237373830382C),
 (83,'UBIAD1.cApr07','chr1','+',11256473,11278212,11256475,11274788,5,0x31313235363437332C31313236383238372C31313237343639322C31313237363131302C31313237373531362C,0x31313235363730342C31313236383337362C31313237343739312C31313237363237302C31313237383231322C),
 (83,'UBIAD1.dApr07','chr1','+',11256577,11278065,0,0,3,0x31313235363537372C31313236383238372C31313237373531362C,0x31313235363730342C31313236383337362C31313237383036352C),
 (84,'MAD2L2.fApr07','chr1','-',11657114,11674294,11657418,11663245,11,0x31313635373131342C31313635373732352C31313635383330312C31313635383638392C31313635393439312C31313636303138362C31313636323939362C31313636333230352C31313636333638322C31313636343338312C31313637343035362C,0x31313635373436302C31313635373831382C31313635383337352C31313635383738342C31313635393539322C31313636303235382C31313636333131352C31313636333235372C31313636343038322C31313636343636302C31313637343239342C),
 (84,'MAD2L2.dApr07','chr1','-',11657123,11674121,11657418,11674119,9,0x31313635373132332C31313635373732352C31313635383330312C31313635383638392C31313635393435322C31313636303138362C31313636323939362C31313636333230352C31313637343035362C,0x31313635373436302C31313635373831382C31313635383337352C31313635383738342C31313635393539322C31313636303235382C31313636333131352C31313636333235372C31313637343132312C),
 (84,'MAD2L2.aApr07','chr1','-',11657123,11674283,11657418,11674281,9,0x31313635373132332C31313635373732352C31313635383330312C31313635383638392C31313635393439312C31313636303138362C31313636323939362C31313636333230352C31313637343035362C,0x31313635373436302C31313635373831382C31313635383337352C31313635383738342C31313635393539322C31313636303235382C31313636333131352C31313636333235372C31313637343238332C),
 (84,'MAD2L2.hApr07','chr1','-',11657790,11674452,11657791,11674452,8,0x31313635373739302C31313635383330312C31313635383638392C31313635393439312C31313636303138362C31313636323939362C31313636333230352C31313637343339352C,0x31313635373831382C31313635383337352C31313635383738342C31313635393539322C31313636303235382C31313636333131352C31313636333235372C31313637343435322C),
 (84,'CLCN6.lApr07','chr1','+',11788698,11806387,11798543,11806386,7,0x31313738383639382C31313738393737342C31313739383438392C31313739393235382C31313830323133312C31313830353333382C31313830363335302C,0x31313738383834302C31313738393833342C31313739383535352C31313739393332342C31313830323139382C31313830353434352C31313830363338372C),
 (84,'CLCN6.aApr07','chr1','+',11788711,11825787,11788906,11822867,23,0x31313738383731312C31313738393737342C31313739383438392C31313739393235382C31313830323133312C31313830353333382C31313830363335302C31313830373132392C31313830383739392C31313830393733322C31313831303734392C31313831313130312C31313831313833392C31313831363135382C31313831363532302C31313831363837392C31313831373132372C31313831383631302C31313831393634322C31313831393938362C31313832303937382C31313832313137382C31313832323738362C,0x31313738383939332C31313738393833342C31313739383535352C31313739393332342C31313830323139382C31313830353434352C31313830363437372C31313830373139372C31313830383835382C31313830393836352C31313831303836332C31313831313236382C31313831313936362C31313831363238322C31313831363637342C31313831373033392C31313831373233342C31313831383739372C31313831393830302C31313832303134332C31313832313038362C31313832313330342C31313832353738372C),
 (84,'CLCN6.iApr07','chr1','+',11788794,11802339,11788906,11802263,5,0x31313738383739342C31313738393737342C31313739383438392C31313739393235382C31313830323133312C,0x31313738383939332C31313738393833342C31313739383535352C31313739393332342C31313830323333392C),
 (84,'CLCN6.jApr07','chr1','+',11788855,11803354,11788906,11803028,6,0x31313738383835352C31313738393737342C31313739383438392C31313739393235382C31313830323133312C31313830333030352C,0x31313738383939332C31313738393833342C31313739383535352C31313739393332342C31313830323139382C31313830333335342C),
 (84,'CLCN6.mApr07','chr1','+',11788887,11806429,11799288,11806428,7,0x31313738383838372C31313738393737342C31313739383438392C31313739393236322C31313830323133312C31313830353333382C31313830363335302C,0x31313738383939332C31313738393833342C31313739383535352C31313739393332342C31313830323139382C31313830353434352C31313830363432392C),
 (84,'CLCN6.fApr07','chr1','+',11788887,11806465,11788906,11806464,6,0x31313738383838372C31313738393737342C31313739393235382C31313830323133312C31313830353333382C31313830363335302C,0x31313738383939332C31313738393833342C31313739393332342C31313830323139382C31313830353434352C31313830363436352C),
 (84,'CLCN6.bApr07','chr1','+',11788903,11821695,11788903,11820066,22,0x31313738383930332C31313738393737342C31313739383438392C31313739393235382C31313830323133312C31313830353333382C31313830363335302C31313830373132392C31313830383739392C31313830393733322C31313831303734392C31313831313130312C31313831313833392C31313831363135382C31313831363532302C31313831363837392C31313831373132372C31313831383631302C31313831393634322C31313832303032302C31313832303937382C31313832313137382C,0x31313738383939332C31313738393833342C31313739383535352C31313739393332342C31313830323139382C31313830353434352C31313830363437372C31313830373139372C31313830383835382C31313830393836352C31313831303836332C31313831313236382C31313831313936362C31313831363238322C31313831363637342C31313831373033392C31313831373233342C31313831383739372C31313831393830302C31313832303134332C31313832313038362C31313832313639352C),
 (84,'CLCN6.eApr07','chr1','+',11788906,11810862,11788906,11810862,11,0x31313738383930362C31313738393737342C31313739383438392C31313739393235382C31313830323133312C31313830353333382C31313830363335302C31313830373132392C31313830383739392C31313830393735382C31313831303734392C,0x31313738383939332C31313738393833342C31313739383535352C31313739393332342C31313830323139382C31313830353434352C31313830363437372C31313830373139372C31313830383835382C31313830393836352C31313831303836322C),
 (84,'CLCN6.dApr07','chr1','+',11788906,11810862,11788906,11810862,11,0x31313738383930362C31313738393737342C31313739383438392C31313739393235382C31313830323133312C31313830353333382C31313830363335302C31313830373132392C31313830383739392C31313830393733322C31313831303734392C,0x31313738383939332C31313738393833342C31313739383535352C31313739393332342C31313830323139382C31313830353434352C31313830363437372C31313830373139372C31313830383836382C31313830393836352C31313831303836322C),
 (84,'CLCN6.cApr07','chr1','+',11788906,11816240,11788906,11811947,13,0x31313738383930362C31313738393737342C31313739383438392C31313739393235382C31313830323133312C31313830353333382C31313830363335302C31313830373132392C31313830383739392C31313830393733322C31313831303734392C31313831313833392C31313831363135382C,0x31313738383939332C31313738393833342C31313739383535352C31313739393332342C31313830323139382C31313830353434352C31313830363437372C31313830373139372C31313830383835382C31313830393836352C31313831303836332C31313831313936362C31313831363234302C),
 (84,'CLCN6.pApr07','chr1','+',11789456,11805378,11798543,11805376,5,0x31313738393435362C31313739383438392C31313739393235382C31313830323133312C31313830353333382C,0x31313738393833342C31313739383535352C31313739393332342C31313830323139382C31313830353337382C),
 (84,'PLOD1.cApr07','chr1','+',11916847,11946412,11930639,11946284,11,0x31313931363834372C31313933303631392C31313933323431362C31313933333030302C31313933353236362C31313933373437332C31313933393536302C31313934303438352C31313934313135392C31313934333238392C31313934363137352C,0x31313931363936372C31313933303731312C31313933323535302C31313933333136342C31313933353337392C31313933373533372C31313933393635382C31313934303538372C31313934313239312C31313934333431312C31313934363431322C),
 (84,'PLOD1.aApr07','chr1','+',11917164,11958191,11917423,11957452,19,0x31313931373136342C31313933303631392C31313933323431362C31313933333030302C31313933353236362C31313933373437332C31313933393536302C31313934303438352C31313934313135392C31313934333238392C31313934363137352C31313934363831382C31313934373238372C31313934383132332C31313934383839342C31313934393633302C31313935333331332C31313935353531352C31313935373239362C,0x31313931373439392C31313933303731312C31313933323535302C31313933333136342C31313933353337392C31313933373533372C31313933393635382C31313934303538372C31313934313239312C31313934333431312C31313934363238302C31313934363934342C31313934373432392C31313934383233372C31313934383936302C31313934393733352C31313935333436302C31313935353634312C31313935383139312C),
 (84,'PLOD1.dApr07','chr1','+',11917333,11941290,11930639,11941288,9,0x31313931373333332C31313931383534342C31313933303631392C31313933323431362C31313933333030302C31313933353236362C31313933373437332C31313933393536302C31313934313135352C,0x31313931373439392C31313931383539392C31313933303731312C31313933323535302C31313933333136342C31313933353337392C31313933373533372C31313933393635382C31313934313239302C),
 (84,'PLOD1.bApr07','chr1','+',11917357,11958191,11917423,11957983,18,0x31313931373335372C31313932373136352C31313933303631392C31313933323431362C31313933333030302C31313933353236362C31313933373437332C31313933393536302C31313934303438352C31313934313233342C31313934333238392C31313934363137352C31313934363831382C31313934373238372C31313934383132332C31313934383839342C31313934393633302C31313935373932362C,0x31313931373439392C31313932373330362C31313933303731312C31313933323535302C31313933333136342C31313933353337392C31313933373533372C31313933393635382C31313934303538372C31313934313239312C31313934333431312C31313934363238302C31313934363934342C31313934373432392C31313934383233372C31313934383936302C31313934393733352C31313935383139312C),
 (84,'PLOD1.fApr07','chr1','+',11917378,11939615,11917423,11939613,7,0x31313931373337382C31313933303631392C31313933323338392C31313933333030302C31313933353236362C31313933373437332C31313933393536302C,0x31313931373439392C31313933303731312C31313933323535302C31313933333136342C31313933353337392C31313933373533372C31313933393631352C),
 (84,'PLOD1.eApr07','chr1','+',11917386,11940587,11917423,11940587,8,0x31313931373338362C31313933303631392C31313933323431362C31313933333030302C31313933353236362C31313933373437332C31313933393733332C31313934303438352C,0x31313931373439392C31313933303731312C31313933323535302C31313933333136342C31313933353337392C31313933373533372C31313933393833372C31313934303538372C),
 (84,'PLOD1.nApr07','chr1','+',11917402,11958186,11917402,11957466,3,0x31313931373430322C31313933303631392C31313935373436302C,0x31313931373439392C31313933303731312C31313935383138362C),
 (84,'PLOD1.hApr07','chr1','+',11917630,11933129,11917794,11933127,4,0x31313931373633302C31313933303631392C31313933323431362C31313933333030302C,0x31313931373833312C31313933303731312C31313933323535302C31313933333132392C),
 (84,'TNFRSF8.aApr07','chr1','+',12046020,12126851,12046242,12125175,15,0x31323034363032302C31323036373130372C31323037393734342C31323038373032322C31323039323230392C31323039323638342C31323039343534312C31323039383232302C31323130353932372C31323130363335382C31323130383539342C31323130383832362C31323131383233312C31323132303837322C31323132343933302C,0x31323034363330352C31323036373139352C31323037393836312C31323038373137352C31323039323330302C31323039323834382C31323039343635382C31323039383337332C31323130363032312C31323130363437312C31323130383639362C31323130383838302C31323131383235372C31323132313038302C31323132363835312C),
 (84,'TNFRSF1B.bApr07','chr1','+',12149645,12190568,12149647,12189664,9,0x31323134393634352C31323137333630302C31323137343431372C31323137353037342C31323137353530362C31323137363539382C31323137373232372C31323138343631302C31323138393338332C,0x31323134393831332C31323137333732392C31323137343536372C31323137353136382C31323137353734322C31323137363637362C31323137373236322C31323138343831352C31323139303536382C),
 (84,'TNFRSF1B.aApr07','chr1','+',12149646,12191872,12149648,12189664,10,0x31323134393634362C31323137313433392C31323137333630302C31323137343431372C31323137353037342C31323137353530362C31323137363539382C31323137373232372C31323138343631302C31323138393338332C,0x31323134393831332C31323137313533392C31323137333732392C31323137343536372C31323137353136382C31323137353734322C31323137363637362C31323137373236322C31323138343831352C31323139313837322C),
 (84,'VPS13D.aApr07','chr1','+',12212697,12494686,12216910,12491665,70,0x31323231323639372C31323231363833342C31323232353135362C31323232363838392C31323232373138302C31323233313836362C31323233363336352C31323233383937362C31323233393633302C31323234303537382C31323234333333362C31323234333539312C31323234343534342C31323234393532342C31323235303438382C31323235313334392C31323235333633372C31323235353634362C31323235383436382C31323236323134322C31323236353334382C31323237303836362C31323237333634312C31323237363136372C31323238313834352C31323238373134392C31323239313037342C31323239343039372C31323239343435362C31323239363735382C31323330303731352C31323330323134302C31323330343435322C31323330353137392C31323330363334392C31323331303239312C31323331323437322C31323331353836392C31323331383334382C31323332303837342C31323332343432332C31323332353534322C31323332383031372C31323332393234382C31323333313436362C31323333313830372C31323333363631372C31323333383534322C31323333393034312C31323334313130312C31323334353336322C31323334353731342C31323335313130392C31323335323130382C31323335363339312C31323336313036382C31323336323132382C31323336353632312C31323336373930352C31323336383833302C31323338323832342C31323338343234372C31323338363436342C31323339373732362C31323339393239392C31323433383634302C31323434323834322C31323438303134302C31323438393439332C31323439313533332C,0x31323231323736342C31323231373030372C31323232353233342C31323232373038302C31323232373236312C31323233313938332C31323233363437302C31323233393134372C31323233393733312C31323234303734372C31323234333433382C31323234333739332C31323234343732342C31323234393635352C31323235303536342C31323235313532302C31323235333736382C31323235353737392C31323236303638322C31323236323239342C31323236363338302C31323237303935372C31323237333736382C31323237363334382C31323238323032382C31323238373337322C31323239313238352C31323239343236392C31323239343536392C31323239363937312C31323330303938312C31323330323237342C31323330343630382C31323330353339302C31323330363432342C31323331303439382C31323331323536322C31323331363031302C31323331383437312C31323332303934392C31323332343532392C31323332353639352C31323332383135332C31323332393239362C31323333313631372C31323333323031382C31323333363836352C31323333383733342C31323333393136382C31323334313234342C31323334353439332C31323334353839302C31323335313233332C31323335323334342C31323335363530302C31323336313233322C31323336323233372C31323336353830312C31323336383031392C31323336383938302C31323338323937342C31323338343334342C31323338363631332C31323339373836312C31323339393436372C31323433383737332C31323434333033382C31323438303237322C31323438393733342C31323439343638362C),
 (84,'VPS13D.bApr07','chr1','+',12212699,12494686,12216910,12491665,69,0x31323231323639392C31323231363833342C31323232353135362C31323232363838392C31323232373138302C31323233313836362C31323233363336352C31323233383937362C31323233393633302C31323234303537382C31323234333333362C31323234333539312C31323234343534342C31323234393532342C31323235303438382C31323235313334392C31323235333633372C31323235353634362C31323235383436382C31323236323134322C31323236353334382C31323237303836362C31323237333634312C31323237363136372C31323238313834352C31323238373134392C31323239313037342C31323239343039372C31323239343435362C31323239363735382C31323330303731352C31323330323134302C31323330343435322C31323330353137392C31323330363334392C31323331303239312C31323331323437322C31323331353836392C31323331383334382C31323332343432332C31323332353534322C31323332383031372C31323332393234382C31323333313436362C31323333313830372C31323333363631372C31323333383534322C31323333393034312C31323334313130312C31323334353336322C31323334353731342C31323335313130392C31323335323130382C31323335363339312C31323336313036382C31323336323132382C31323336353632312C31323336373930352C31323336383833302C31323338323832342C31323338343234372C31323338363436342C31323339373732362C31323339393239392C31323433383634302C31323434323834322C31323438303134302C31323438393439332C31323439313533332C,0x31323231323736342C31323231373030372C31323232353233342C31323232373038302C31323232373236312C31323233313938332C31323233363437302C31323233393134372C31323233393733312C31323234303734372C31323234333433382C31323234333739332C31323234343732342C31323234393635352C31323235303536342C31323235313532302C31323235333736382C31323235353737392C31323236303638322C31323236323239342C31323236363338302C31323237303935372C31323237333736382C31323237363334382C31323238323032382C31323238373337322C31323239313238352C31323239343236392C31323239343536392C31323239363937312C31323330303938312C31323330323237342C31323330343630382C31323330353339302C31323330363432342C31323331303439382C31323331323536322C31323331363031302C31323331383437312C31323332343532392C31323332353639352C31323332383135332C31323332393239362C31323333313631372C31323333323031382C31323333363836352C31323333383733342C31323333393136382C31323334313234342C31323334353439332C31323334353839302C31323335313233332C31323335323334342C31323335363530302C31323336313233322C31323336323233372C31323336353830312C31323336383031392C31323336383938302C31323338323937342C31323338343334342C31323338363631332C31323339373836312C31323339393436372C31323433383737332C31323434333033382C31323438303237322C31323438393733342C31323439343638362C),
 (84,'VPS13D.cApr07','chr1','+',12258759,12493088,12258761,12491665,52,0x31323235383735392C31323236323134322C31323236353334382C31323237303836362C31323237333634312C31323237363136372C31323238313834352C31323238373134392C31323239313037342C31323239343039372C31323239343435362C31323239363735382C31323330303731352C31323330323134302C31323330343435322C31323330353137392C31323330363334392C31323331303239312C31323331323437322C31323331353836392C31323331383334382C31323332303837342C31323332343432362C31323332353534322C31323332383031372C31323332393234382C31323333313436362C31323333313830372C31323333363631372C31323333383534322C31323333393034312C31323334313130312C31323334353336322C31323334353731342C31323335313130392C31323335323130382C31323335363339312C31323336313036382C31323336323132382C31323336353632312C31323336373930352C31323336383833302C31323338323832342C31323338343234372C31323338363436342C31323339373732362C31323339393239392C31323433383634302C31323434323834322C31323438303134302C31323438393439332C31323439313533332C,0x31323236303638322C31323236323239342C31323236363338302C31323237303935372C31323237333736382C31323237363334382C31323238323032382C31323238373337322C31323239313238352C31323239343236392C31323239343536392C31323239363937312C31323330303938312C31323330323237342C31323330343630382C31323330353339302C31323330363432342C31323331303439382C31323331323536322C31323331363031302C31323331383437312C31323332303934392C31323332343532392C31323332353639352C31323332383135332C31323332393239362C31323333313631372C31323333323031382C31323333363836352C31323333383733342C31323333393136382C31323334313234342C31323334353439332C31323334353839302C31323335313233332C31323335323334342C31323335363530302C31323336313233322C31323336323233372C31323336353830312C31323336383031392C31323336383938302C31323338323937342C31323338343334342C31323338363631332C31323339373836312C31323339393436372C31323433383737332C31323434333033382C31323438303237322C31323438393733342C31323439333038382C),
 (84,'VPS13D.dApr07','chr1','+',12281925,12370456,12281926,12331628,32,0x31323238313932352C31323238373134392C31323239313037342C31323239343039372C31323239343435362C31323239363735382C31323330303731352C31323330323134302C31323330343435322C31323330353137392C31323330363334392C31323331303239312C31323331323437322C31323331353836392C31323331383334382C31323332343432332C31323332353534322C31323332383031372C31323332393234382C31323333313436362C31323333363631372C31323333383534322C31323333393034312C31323334313130312C31323334353336322C31323334353731342C31323335313130392C31323335323130382C31323335363339312C31323336313036382C31323336323132382C31323336393934392C,0x31323238323032382C31323238373337322C31323239313238352C31323239343236392C31323239343536392C31323239363937312C31323330303938312C31323330323237342C31323330343630382C31323330353339302C31323330363432342C31323331303439382C31323331323536322C31323331363031302C31323331383437312C31323332343532392C31323332353639352C31323332383135332C31323332393239362C31323333323031382C31323333363836352C31323333383733342C31323333393136382C31323334313234342C31323334353439332C31323334353839302C31323335313233332C31323335323334342C31323335363530302C31323336313233322C31323336323136302C31323337303435362C),
 (84,'VPS13D.gApr07','chr1','+',12318364,12331654,12318365,12331628,6,0x31323331383336342C31323332343432362C31323332353534322C31323332383031372C31323332393234382C31323333313436362C,0x31323331383437312C31323332343532392C31323332353639352C31323332383135332C31323332393239362C31323333313635342C),
 (84,'VPS13D.eApr07','chr1','+',12350310,12492076,12350311,12480212,19,0x31323335303331302C31323335313130392C31323335323130382C31323335363339312C31323336313036382C31323336323132382C31323336353632312C31323336373930352C31323336383833302C31323338323832342C31323338343234372C31323338363436342C31323339373732362C31323339393239392C31323433383634302C31323434323838312C31323438303134302C31323438393439332C31323439313533332C,0x31323335303334332C31323335313233332C31323335323334342C31323335363530302C31323336313233322C31323336323233372C31323336353830312C31323336383031392C31323336383938302C31323338323937342C31323338343334342C31323338363631332C31323339373836312C31323339393436372C31323433383731342C31323434333033382C31323438303237322C31323438393733342C31323439323037362C),
 (84,'VPS13D.kApr07','chr1','+',12407121,12489531,12438676,12489530,5,0x31323430373132312C31323433383634302C31323434323834322C31323438303134302C31323438393439332C,0x31323430373230392C31323433383737332C31323434333033382C31323438303237322C31323438393533312C),
 (84,'VPS13D.vdApr07','chr1','+',12444243,12482590,0,0,3,0x31323434343234332C31323438303235302C31323438323038312C,0x31323434343831352C31323438303237322C31323438323539302C),
 (84,'VPS13D.rApr07','chr1','+',12447559,12493067,12447827,12489561,4,0x31323434373535392C31323438303134302C31323438393439332C31323439313533332C,0x31323434373839312C31323438303237322C31323438393733342C31323439333036372C),
 (85,'PRAMEF5.aApr07','chr1','+',13232405,13241644,13237477,13241320,4,0x31333233323430352C31333233373435352C31333233383433302C31333234303735382C,0x31333233323438332C31333233373736342C31333233393031322C31333234313634342C),
 (85,'PRAMEF16.aApr07','chr1','+',13367840,13370847,13367840,13370715,3,0x31333336373834302C31333336383535332C31333337303135362C,0x31333336383135372C31333336393133322C31333337303834372C),
 (86,'glawbaw.aApr07','chr1','-',14548036,14619055,0,0,5,0x31343534383033362C31343534393935302C31343538393736382C31343539303534312C31343631383537362C,0x31343534383436302C31343535303130372C31343538393833342C31343539303636312C31343631393035352C),
 (87,'KIAA1026.bApr07','chr1','+',14797770,15267240,14797771,15259604,7,0x31343739373737302C31353135393736362C31353233333833312C31353234333037312C31353235353137332C31353235393235342C31353236343731322C,0x31343739383330362C31353135393935382C31353233333936382C31353234333234322C31353235353336332C31353236323730352C31353236373234302C),
 (87,'KIAA1026.cApr07','chr1','+',14797788,15264880,14797789,15264880,9,0x31343739373738382C31343739383036352C31353135393736362C31353233333833312C31353234333037312C31353235353137332C31353235393235342C31353236323635342C31353236343731322C,0x31343739373939332C31343739383330362C31353135393935382C31353233333936382C31353234333234322C31353235353336332C31353235393338352C31353236323730352C31353236343838302C),
 (87,'KIAA1026.aApr07','chr1','+',14797799,15317130,14797801,15313718,15,0x31343739373739392C31353135393736362C31353233333833312C31353234333037312C31353235353137332C31353235393235342C31353236323635342C31353236343731322C31353239333236322C31353239333839372C31353330303632352C31353330323434312C31353330333130352C31353331313530392C31353331333535332C,0x31343739383330362C31353135393935382C31353233333936382C31353234333234322C31353235353336332C31353235393338352C31353236323730352C31353236343833362C31353239333436382C31353239343031362C31353330303835372C31353330323534332C31353330333237322C31353331313632342C31353331373133302C),
 (87,'KIAA1026.eApr07','chr1','+',15123211,15265643,15123447,15264880,8,0x31353132333231312C31353135393736362C31353233333833312C31353234333037312C31353235353137332C31353235393235342C31353236323635342C31353236343731322C,0x31353132333635352C31353135393935382C31353233333936382C31353234333234322C31353235353336332C31353235393338352C31353236323730352C31353236353634332C),
 (87,'KIAA1026.dApr07','chr1','+',15128881,15264880,15128883,15264880,8,0x31353132383838312C31353135393736362C31353233333833312C31353234333037312C31353235353137332C31353235393235342C31353236323635342C31353236343731322C,0x31353132393132372C31353135393935382C31353233333936382C31353234333234322C31353235353336332C31353235393338352C31353236323730352C31353236343838302C),
 (87,'KIAA1026.fApr07','chr1','+',15145001,15264880,15159822,15264880,8,0x31353134353030312C31353135393736362C31353233333833312C31353234333037312C31353235353137332C31353235393235342C31353236323635342C31353236343731322C,0x31353134353235362C31353135393935382C31353233333936382C31353234333234322C31353235353336332C31353235393338352C31353236323730352C31353236343838302C),
 (87,'KIAA1026.gApr07','chr1','+',15159766,15264969,15159768,15264729,7,0x31353135393736362C31353233333833312C31353234333037312C31353235353137332C31353235393235342C31353236323635342C31353236343731322C,0x31353135393935382C31353233333936382C31353234333234322C31353235353336332C31353235393338302C31353236323730352C31353236343936392C),
 (87,'C1orf126.bApr07','chr1','-',15315034,15351529,15317963,15351496,5,0x31353331353033342C31353331373430392C31353332303035342C31353332333331302C31353335313337332C,0x31353331363839302C31353331373938372C31353332303134322C31353332333435362C31353335313532392C),
 (87,'C1orf126.aApr07','chr1','-',15315035,15351549,15319774,15351547,6,0x31353331353033352C31353331373430392C31353331393635392C31353332303035342C31353332333331302C31353335313337332C,0x31353331363839302C31353331373938372C31353331393738302C31353332303134322C31353332333435362C31353335313534392C),
 (87,'FHAD1.tApr07','chr1','+',15435651,15488496,15435807,15488496,4,0x31353433353635312C31353435303835332C31353437313430352C31353438383438312C,0x31353433353834342C31353435303936302C31353437313631322C31353438383439362C),
 (87,'FHAD1.sApr07','chr1','+',15446316,15471681,15450867,15471681,3,0x31353434363331362C31353435303835332C31353437313430352C,0x31353434363437382C31353435303936302C31353437313638312C),
 (87,'FHAD1.mApr07','chr1','+',15446357,15486072,15446357,15486071,4,0x31353434363335372C31353435303835332C31353437313430352C31353438363033322C,0x31353434363437382C31353435303936302C31353437313631322C31353438363037322C),
 (87,'FHAD1.oApr07','chr1','+',15446357,15495845,15450867,15495843,4,0x31353434363335372C31353435303835332C31353438383438312C31353439353736362C,0x31353434363437382C31353435303936302C31353438383734392C31353439353834352C),
 (87,'FHAD1.jApr07','chr1','+',15446357,15488838,15450867,15488838,4,0x31353434363335372C31353435303835332C31353437313430352C31353438383438312C,0x31353434363437382C31353435303936302C31353437313631322C31353438383833382C),
 (87,'FHAD1.dApr07','chr1','+',15446357,15599445,15495780,15599298,18,0x31353434363335372C31353435303835332C31353437313430352C31353438383438312C31353439353731322C31353530373639352C31353531323133392C31353531353436302C31353531363930362C31353532363134312C31353532373335392C31353532383432382C31353533383536332C31353534303831382C31353534343136352C31353534343439382C31353539363437382C31353539393137392C,0x31353434363437382C31353435303936302C31353437313631322C31353438383734392C31353439353837362C31353530373831392C31353531323237302C31353531353535302C31353531373031312C31353532363232352C31353532373531322C31353532383632342C31353533383633342C31353534303937312C31353534343237332C31353534343531352C31353539363533322C31353539393434352C),
 (87,'FHAD1.kApr07','chr1','+',15579783,15599363,15579783,15587455,8,0x31353537393738332C31353538303331332C31353538313131302C31353538373133332C31353538373432382C31353539323138322C31353539363337392C31353539393033362C,0x31353537393837392C31353538303533342C31353538313237362C31353538373231342C31353538373530352C31353539323330302C31353539363533322C31353539393336332C),
 (87,'FHAD1.vbApr07','chr1','+',15589765,15599364,0,0,3,0x31353538393736352C31353539363337392C31353539393137392C,0x31353539303334362C31353539363533322C31353539393336342C),
 (88,'DDI2andRSC1A1.aApr07','chr1','+',15829484,15861362,15858950,15860804,8,0x31353832393438342C31353833323532302C31353833323837392C31353834323630332C31353834383830312C31353835303738372C31353835353639382C31353835383931382C,0x31353832393634332C31353833323634372C31353833323936312C31353834323733322C31353834383930352C31353835303937372C31353835353736312C31353836313336322C),
 (88,'SPEN.aApr07','chr1','+',16046917,16140056,16047149,16138509,15,0x31363034363931372C31363037313839372C31363037353238332C31363130383430322C31363131303138322C31363131353230392C31363131383030372C31363131383438352C31363131393935312C31363132313333302C31363132373137322C31363133363234342C31363133363839332C31363133373739392C31363133383337372C,0x31363034373233322C31363037323231382C31363037353736302C31363130383536332C31363131303338332C31363131353336312C31363131383133332C31363131383539392C31363132303036352C31363132313433312C31363133353334382C31363133363732372C31363133373038382C31363133373935382C31363134303035362C),
 (88,'SPEN.bApr07','chr1','+',16072583,16122178,16073196,16121769,10,0x31363037323538332C31363037353238332C31363130383430352C31363131303138322C31363131353230392C31363131383030372C31363131383438352C31363131393935312C31363132313333302C31363132313732392C,0x31363037333437372C31363037353736302C31363130383536332C31363131303338332C31363131353336312C31363131383133332C31363131383539392C31363132303036352C31363132313433312C31363132323137382C),
 (88,'CLCNKB.aApr07','chr1','+',16242818,16256390,16243574,16255998,20,0x31363234323831382C31363234333536372C31363234343633392C31363234353631362C31363234363938362C31363234373432342C31363234373538352C31363234383230312C31363234383639392C31363234383839362C31363234393539372C31363234393935362C31363235303535392C31363235303739312C31363235313237392C31363235323732302C31363235343531362C31363235343735362C31363235353530332C31363235353935302C,0x31363234323936322C31363234333637342C31363234343736382C31363234353734352C31363234373132362C31363234373530322C31363234373636342C31363234383332372C31363234383738342C31363234383939382C31363234393638322C31363235303133302C31363235303632392C31363235303930322C31363235313439332C31363235323835342C31363235343630352C31363235343834302C31363235353539302C31363235363339302C),
 (88,'CLCNKB.bApr07','chr1','+',16247844,16256389,16248053,16255998,13,0x31363234373834342C31363234383639392C31363234383839362C31363234393539372C31363234393935362C31363235303535392C31363235303739312C31363235313237392C31363235323732302C31363235343531362C31363235343735392C31363235353530332C31363235353935302C,0x31363234383332372C31363234383738342C31363234383939382C31363234393638322C31363235303133302C31363235303632392C31363235303930322C31363235313439332C31363235323835342C31363235343630352C31363235343834302C31363235353539302C31363235363338392C),
 (88,'FBXO42.aApr07','chr1','-',16445883,16551570,16449751,16514500,10,0x31363434353838332C31363435313336392C31363435323137372C31363435323731362C31363435343739322C31363435353638372C31363439333836342C31363530343838342C31363531343235302C31363535313333362C,0x31363435303836372C31363435313438362C31363435323233342C31363435323831332C31363435343930332C31363435353834312C31363439333939392C31363530353030312C31363531343531372C31363535313537302C),
 (88,'FBXO42.eApr07','chr1','-',16449111,16551526,16449751,16514500,6,0x31363434393131312C31363435343830382C31363435353638372C31363439333836342C31363531343235302C31363535313333362C,0x31363434393937362C31363435343930332C31363435353834312C31363439333939392C31363531343531372C31363535313532362C),
 (88,'FBXO42.bApr07','chr1','-',16449652,16551561,16449751,16504972,12,0x31363434393635322C31363435313336392C31363435323137372C31363435323731362C31363435343739322C31363435353638372C31363439333836342C31363530343838342C31363530393331372C31363531343235302C31363531353531382C31363535313333362C,0x31363435303836372C31363435313438362C31363435323233342C31363435323831332C31363435343930332C31363435353834312C31363439333939392C31363530353030312C31363530393433392C31363531343531372C31363531353733392C31363535313536312C),
 (88,'FBXO42.dApr07','chr1','-',16451217,16551553,16451345,16514500,10,0x31363435313231372C31363435323137372C31363435323731362C31363435343739322C31363435353638372C31363439333836342C31363530343838342C31363531343235302C31363531353531382C31363535313333362C,0x31363435313438362C31363435323233342C31363435323831332C31363435343930332C31363435353834312C31363439333939392C31363530353030312C31363531343531372C31363531353635332C31363535313535332C);
INSERT INTO `aceview_hg18_housekeeping` (`bin`,`name`,`chrom`,`strand`,`txStart`,`txEnd`,`cdsStart`,`cdsEnd`,`exonCount`,`exonStarts`,`exonEnds`) VALUES 
 (88,'FBXO42.fApr07','chr1','-',16491341,16551570,16493853,16514500,6,0x31363439313334312C31363530343838342C31363531343235302C31363531353531382C31363532373738392C31363535313333362C,0x31363439333939392C31363530353030312C31363531343531372C31363531353635332C31363532373836332C31363535313537302C),
 (88,'FBXO42.hApr07','chr1','-',16493888,16551551,16493889,16514500,5,0x31363439333838382C31363530343838342C31363531343235302C31363531353531382C31363535313333362C,0x31363439333939392C31363530353030312C31363531343531372C31363531353635302C31363535313535312C),
 (88,'FBXO42.pApr07','chr1','-',16514407,16551532,0,0,4,0x31363531343430372C31363531353531382C31363532373738392C31363535313333362C,0x31363531343531372C31363531353635302C31363532373836332C31363535313533322C),
 (88,'FBXO42.oApr07','chr1','-',16514450,16551526,0,0,4,0x31363531343435302C31363531353531382C31363532373738392C31363535313333362C,0x31363531343531372C31363531353635302C31363532373933312C31363535313532362C),
 (88,'FBXO42.nApr07','chr1','-',16514457,16551545,0,0,3,0x31363531343435372C31363531353531382C31363535313333362C,0x31363531343531372C31363531353830392C31363535313534352C),
 (88,'FBXO42.mApr07','chr1','-',16514470,16551561,0,0,3,0x31363531343437302C31363531353531382C31363535313333362C,0x31363531343531372C31363531353830372C31363535313536312C),
 (88,'NECAP2.aApr07','chr1','+',16639753,16659529,16639843,16658078,7,0x31363633393735332C31363634323731332C31363634363935312C31363634373134312C31363634383137342C31363635303931392C31363635373932332C,0x31363633393933352C31363634323831342C31363634373035362C31363634373232332C31363634383238332C31363635313039372C31363635393532392C),
 (88,'NECAP2.bApr07','chr1','+',16639790,16659169,16639843,16657972,8,0x31363633393739302C31363634323731332C31363634363935312C31363634373134312C31363634383137342C31363635303931392C31363635343839392C31363635373932332C,0x31363633393933352C31363634323831342C31363634373035362C31363634373232332C31363634383238332C31363635313039372C31363635343937352C31363635393136392C),
 (88,'NECAP2.gApr07','chr1','+',16639806,16659159,16639843,16648313,7,0x31363633393830362C31363634323731332C31363634363935312C31363634373134312C31363634383137342C31363635343839392C31363635373932332C,0x31363633393933352C31363634323831342C31363634373035362C31363634373232332C31363635313039372C31363635343937352C31363635393135392C),
 (88,'NECAP2.eApr07','chr1','+',16639806,16651097,16639843,16651096,6,0x31363633393830362C31363634323731332C31363634363935312C31363634373134312C31363634383137342C31363635303931392C,0x31363633393835372C31363634323831342C31363634373035362C31363634373232332C31363634383238332C31363635313039372C),
 (88,'NECAP2.dApr07','chr1','+',16639822,16654975,16639843,16654973,7,0x31363633393832322C31363634323731332C31363634363935312C31363634373134312C31363634383137342C31363635303931392C31363635343839332C,0x31363633393835372C31363634323831342C31363634373035362C31363634373232332C31363634383238332C31363635313036392C31363635343937352C),
 (88,'NECAP2.iApr07','chr1','+',16639823,16647432,16639843,16647184,5,0x31363633393832332C31363634323731332C31363634363935312C31363634373134312C31363634373333302C,0x31363633393933352C31363634323831342C31363634373032342C31363634373232332C31363634373433322C),
 (88,'NECAP2.cApr07','chr1','+',16639824,16659160,16639843,16657972,9,0x31363633393832342C31363634323731332C31363634363935312C31363634373134312C31363634383137342C31363635303931392C31363635343839392C31363635373932332C31363635383335352C,0x31363633393933352C31363634323831342C31363634373035362C31363634373232332C31363634383238332C31363635313039372C31363635343937352C31363635383134342C31363635393136302C),
 (88,'NECAP2.fApr07','chr1','+',16639826,16658028,16639843,16649302,9,0x31363633393832362C31363634323731332C31363634363935312C31363634373134312C31363634383137342C31363634393230362C31363635303931392C31363635343839392C31363635373932332C,0x31363633393933352C31363634323831342C31363634373035362C31363634373232332C31363634383238332C31363634393332332C31363635313039372C31363635343937352C31363635383032382C),
 (88,'NECAP2.jApr07','chr1','+',16639828,16659159,16639843,16658515,4,0x31363633393832382C31363634363935312C31363635383332342C31363635383933342C,0x31363633393933352C31363634363936382C31363635383731352C31363635393135392C),
 (89,'ank.45.aApr07','chr1','-',16890299,16919239,16890301,16919239,11,0x31363839303239392C31363839353531322C31363839353836302C31363839383530372C31363839383934302C31363930313738322C31363930333032342C31363930363336392C31363930363632362C31363930363937332C31363931393034352C,0x31363839303337362C31363839353737362C31363839363030362C31363839383730332C31363839393130322C31363930323035342C31363930333232362C31363930363530312C31363930363830392C31363930373136302C31363931393233392C),
 (89,'ank.45.bApr07','chr1','-',16905006,16909966,16905349,16909764,4,0x31363930353030362C31363930363633372C31363930363937332C31363930393736312C,0x31363930353534352C31363930363830392C31363930373136302C31363930393936362C),
 (89,'ank.45.cApr07','chr1','-',16906612,16909700,16906614,16909625,3,0x31363930363631322C31363930363937332C31363930393532312C,0x31363930363830392C31363930373136302C31363930393730302C),
 (89,'CROCC.aApr07','chr1','+',17121031,17172061,17121100,17171528,37,0x31373132313033312C31373132313734342C31373132333430362C31373132383932372C31373132393230352C31373132393336372C31373132393531302C31373133303337322C31373133353731382C31373133363732322C31373133373438312C31373133373939302C31373133383937352C31373134333138312C31373134343534332C31373134353334302C31373134353834322C31373134373431322C31373134373838302C31373135303033342C31373135323338332C31373135333330342C31373135333831352C31373135343339332C31373135353037382C31373135373636342C31373135393833392C31373136343830342C31373136353038302C31373136353438392C31373136373238342C31373136383139372C31373136383836362C31373136393333342C31373136393731372C31373137303534362C31373137313434312C,0x31373132313136302C31373132313838302C31373132333536312C31373132393131332C31373132393238392C31373132393432392C31373132393637362C31373133303437392C31373133353935352C31373133363831392C31373133373536352C31373133383232342C31373133393137352C31373134333336342C31373134343638382C31373134353438372C31373134363037332C31373134373630362C31373134383030382C31373135303230342C31373135323536332C31373135333433392C31373135333935392C31373135343633322C31373135353233382C31373135373833322C31373136303231322C31373136343937342C31373136353230312C31373136353635332C31373136373530302C31373136383432322C31373136393031362C31373136393533352C31373136393834392C31373137303732392C31373137323036312C),
 (89,'CROCC.bApr07','chr1','+',17135870,17172061,17144643,17171528,27,0x31373133353837302C31373133363732322C31373133373939302C31373133383937352C31373134333138312C31373134353334302C31373134353834322C31373134373431322C31373134373838302C31373135303033342C31373135323338332C31373135333330342C31373135333831352C31373135343339332C31373135353037382C31373135373636342C31373135393833392C31373136343830342C31373136353038302C31373136353438392C31373136373238342C31373136383139372C31373136383836362C31373136393333342C31373136393731372C31373137303534362C31373137313434312C,0x31373133353935352C31373133363831392C31373133383232342C31373133393137352C31373134343638382C31373134353438372C31373134363037332C31373134373630362C31373134383030382C31373135303230342C31373135323536332C31373135333433392C31373135333935392C31373135343633322C31373135353233382C31373135373833322C31373136303231322C31373136343937342C31373136353230312C31373136353635332C31373136373530302C31373136383432322C31373136393031362C31373136393533352C31373136393834392C31373137303730382C31373137323036312C),
 (89,'CROCC.eApr07','chr1','+',17164641,17171963,17164990,17171528,6,0x31373136343634312C31373136353438392C31373136373238342C31373136393333342C31373136393731372C31373137313434312C,0x31373136353230312C31373136353635332C31373136373530302C31373136393533352C31373136393834392C31373137313936332C),
 (89,'CROCC.jApr07','chr1','+',17169899,17172040,17170336,17171528,2,0x31373136393839392C31373137313434312C,0x31373137303732392C31373137323034302C),
 (89,'CROCC.mApr07-unspliced','chr1','+',17170370,17170860,17170372,17170747,1,0x31373137303337302C,0x31373137303836302C),
 (89,'PADI2.aApr07','chr1','-',17265841,17318534,17268125,17318453,16,0x31373236353834312C31373236393136392C31373237303438372C31373237333933372C31373237343736302C31373237383334352C31373238313632362C31373238323830372C31373238333638302C31373238353630322C31373239313438392C31373239323634382C31373239343939302C31373330323036382C31373330333935392C31373331383336312C,0x31373236383335392C31373236393239382C31373237303537332C31373237343033312C31373237343930352C31373237383439372C31373238313733342C31373238323931392C31373238333738342C31373238353738312C31373239313631352C31373239323736362C31373239353035322C31373330323134312C31373330343134332C31373331383533342C),
 (89,'PADI2.bApr07','chr1','-',17278108,17318517,17278341,17318453,11,0x31373237383130382C31373238313632362C31373238323830372C31373238333638302C31373238353630322C31373239313438392C31373239323634382C31373239343939302C31373330323036382C31373330333935392C31373331383336312C,0x31373237383439372C31373238313733342C31373238323931392C31373238333738342C31373238353738312C31373239313631352C31373239323736362C31373239353035322C31373330323134312C31373330343134332C31373331383531372C),
 (89,'PADI1.aApr07','chr1','+',17403877,17445089,17404299,17443325,16,0x31373430333837372C31373432313337312C31373432323730322C31373432333434382C31373432343839322C31373432353131342C31373432373730362C31373432383032392C31373432393136362C31373432393635332C31373433313930302C31373433363339352C31373433373639372C31373433383738352C31373433393731362C31373434333039312C,0x31373430343339312C31373432313535322C31373432323737352C31373432333531302C31373432353031302C31373432353234302C31373432373837392C31373432383133332C31373432393239302C31373432393736312C31373433323035322C31373433363534302C31373433373739312C31373433383836352C31373433393834322C31373434353038392C),
 (89,'PADI1.dApr07','chr1','+',17432362,17439806,17436411,17439806,5,0x31373433323336322C31373433363339352C31373433373639372C31373433383738352C31373433393731362C,0x31373433323532302C31373433363534302C31373433373739312C31373433383836352C31373433393830362C),
 (89,'PADI1.gApr07','chr1','+',17432437,17443177,17438820,17443175,5,0x31373433323433372C31373433373639372C31373433383738352C31373433393731362C31373434333039312C,0x31373433323532302C31373433373739312C31373433383836352C31373433393834322C31373434333137372C),
 (90,'ACTL8.aApr07','chr1','+',17954395,18026145,18022090,18025601,3,0x31373935343339352C31383032323036362C31383032343834382C,0x31373935343538362C31383032323433382C31383032363134352C),
 (90,'IGSF21.aApr07','chr1','+',18306827,18577564,18307209,18577407,10,0x31383330363832372C31383432363937382C31383439303934362C31383533333937322C31383536313139352C31383536343330332C31383537353339302C31383537353838302C31383537363437332C31383537373333362C,0x31383330373237392C31383432373039312C31383439313036382C31383533343039312C31383536313331312C31383536343737382C31383537353437362C31383537363037332C31383537363531322C31383537373536342C),
 (90,'IGSF21.cApr07','chr1','+',18477925,18575472,18477926,18575470,6,0x31383437373932352C31383439303934362C31383533333937322C31383536313139352C31383536343330332C31383537353339302C,0x31383437373936352C31383439313036382C31383533343039312C31383536313331312C31383536343737382C31383537353437322C),
 (91,'samara.aApr07','chr1','-',19103231,19155218,19107641,19155218,9,0x31393130333233312C31393130393432322C31393131303436342C31393131313034332C31393131353938332C31393131373434322C31393131383735382C31393132303134312C31393135343734382C,0x31393130373734372C31393130393535332C31393131303535372C31393131313136342C31393131363132332C31393131373538332C31393131383835342C31393132303230322C31393135353231382C),
 (91,'samara.bApr07','chr1','-',19107565,19154779,19107641,19154777,8,0x31393130373536352C31393130393432322C31393131303436342C31393131313034332C31393131353938332C31393131383735382C31393132303134312C31393135343734382C,0x31393130373734372C31393130393535332C31393131303535372C31393131313136342C31393131363132332C31393131383835342C31393132303230322C31393135343737392C),
 (91,'ZUBR1.aApr07','chr1','-',19273586,19409405,19273912,19409404,106,0x31393237333538362C31393237353832302C31393237373035362C31393238303432392C31393238333538342C31393238353232352C31393238353735392C31393238363839362C31393238373833392C31393239313839392C31393239323339332C31393239333032392C31393239333938362C31393239343632352C31393239353630332C31393239363237332C31393239383637372C31393239393435362C31393330303630302C31393330333136342C31393330333636352C31393330343132382C31393330343831332C31393330353634392C31393330353931372C31393330393137362C31393330393436302C31393330393832322C31393331313630342C31393331323737392C31393331333032352C31393331333839312C31393331343437382C31393331363330312C31393331363930332C31393331373935322C31393331383633372C31393331393236302C31393332303236392C31393332313031342C31393332313931332C31393332333632312C31393332353532362C31393332363730332C31393332373239312C31393332383035382C31393333373038372C31393333383136332C31393333393836382C31393334303432372C31393334303732372C31393334333036302C31393334333836362C31393334343837332C31393334353930362C31393334373037332C31393334373634332C31393334393635372C31393335303732332C31393335313339332C31393335323338312C31393335323834382C31393335333939382C31393335343532312C31393335353335312C31393335353834372C31393335363839352C31393335393139312C31393335393939372C31393336303636392C31393336303930372C31393336313530302C31393336323834342C31393336333333332C31393336333837392C31393336343332392C31393336343733362C31393336363130322C31393336373130372C31393336383531352C31393336393834322C31393337313934342C31393337323236312C31393337323531392C31393337333339392C31393337343033342C31393337353637322C31393337363534312C31393337383133312C31393338323839312C31393338333039362C31393338343137392C31393338353632302C31393338363234342C31393338363532312C31393339313236382C31393339313536312C31393339323531332C31393339363232312C31393339363735302C31393339373032372C31393339373632312C31393339373837392C31393339383733312C31393430303739382C31393430393135332C,0x31393237333937372C31393237353938332C31393237373134372C31393238303635342C31393238333737392C31393238353335312C31393238353930322C31393238373031302C31393238383035382C31393239313939392C31393239323536372C31393239333232302C31393239343130362C31393239343733332C31393239353733312C31393239363336312C31393239383735382C31393239393635342C31393330303732322C31393330333333382C31393330333734372C31393330343237302C31393330343932332C31393330353830372C31393330363034372C31393330393330342C31393330393534352C31393330393931332C31393331313934382C31393331323930382C31393331333135312C31393331343033302C31393331343731382C31393331363439352C31393331363939312C31393331383033382C31393331383738322C31393331393432392C31393332303531352C31393332313039332C31393332323134312C31393332333737312C31393332353733362C31393332363832302C31393332373339392C31393332383135352C31393333373236322C31393333383330312C31393333393937332C31393334303630352C31393334303835382C31393334333137322C31393334333938382C31393334353031342C31393334363038312C31393334373230382C31393334373730372C31393334393837342C31393335303934302C31393335313535372C31393335323538332C31393335333032302C31393335343135362C31393335343734392C31393335353530342C31393335363030362C31393335373037382C31393335393336322C31393336303232382C31393336303831372C31393336303937382C31393336313639322C31393336323930382C31393336333532322C31393336343037382C31393336343433302C31393336343833382C31393336363331322C31393336373236352C31393336383631332C31393336393936342C31393337323137342C31393337323338372C31393337323730322C31393337333532382C31393337343131342C31393337353830382C31393337363832342C31393337383330312C31393338323937372C31393338333235362C31393338343336372C31393338353733382C31393338363338322C31393338363632312C31393339313435392C31393339313632312C31393339323633382C31393339363334362C31393339363839322C31393339373133302C31393339373736312C31393339383030392C31393339383833352C31393430303839362C31393430393430352C),
 (91,'PQLC2.cApr07','chr1','+',19511406,19533562,19511408,19527724,10,0x31393531313430362C31393531313830392C31393531363638302C31393532333731332C31393532343537352C31393532353332352C31393532353631312C31393532363330372C31393532373635322C31393533303330332C,0x31393531313433392C31393531313937302C31393531363932322C31393532333834332C31393532343636332C31393532353436382C31393532353730342C31393532363439332C31393532383030392C31393533333536322C),
 (91,'CAPZB.bApr07','chr1','-',19537853,19684606,19538610,19684519,9,0x31393533373835332C31393534333433382C31393534343236372C31393535353731352C31393535363530322C31393537373632302C31393538343538352C31393631383734312C31393638343531362C,0x31393533383639382C31393534333531352C31393534343333332C31393535353833322C31393535363634342C31393537373733342C31393538343730372C31393631383833312C31393638343630362C),
 (91,'CAPZB.aApr07','chr1','-',19537855,19684713,19541842,19684711,10,0x31393533373835352C31393534313833322C31393534333433382C31393534343236372C31393535353731352C31393535363530322C31393537373632302C31393538343538352C31393631383734312C31393638343531362C,0x31393533383639382C31393534313934352C31393534333531352C31393534343333332C31393535353833322C31393535363634342C31393537373733342C31393538343730372C31393631383833312C31393638343731332C),
 (91,'CAPZB.cApr07','chr1','-',19537856,19684593,19538647,19647995,9,0x31393533373835362C31393534343236372C31393535353731352C31393535363530322C31393537373632302C31393538343538352C31393631383734312C31393634373931342C31393638343531362C,0x31393533383639382C31393534343333332C31393535353833322C31393535363634342C31393537373733342C31393538343730372C31393631383833312C31393634383431312C31393638343539332C),
 (91,'CAPZB.mApr07','chr1','-',19538437,19684557,19555795,19684555,8,0x31393533383433372C31393534333433382C31393534343236372C31393535353731352C31393537373632302C31393538343538352C31393631383734312C31393638343531362C,0x31393533383639382C31393534333531352C31393534343333332C31393535353833322C31393537373733342C31393538343730372C31393631383833312C31393638343535372C),
 (91,'CAPZB.qApr07','chr1','-',19544267,19684599,19556579,19684519,7,0x31393534343236372C31393535353731352C31393535363530322C31393537373635382C31393538343538352C31393631383734312C31393638343531362C,0x31393534343333332C31393535353833322C31393535363538322C31393537373733342C31393538343730372C31393631383833312C31393638343539392C),
 (91,'CAPZB.eApr07','chr1','-',19555718,19684303,19555718,19683360,6,0x31393535353731382C31393535363530322C31393537373632302C31393538343538352C31393631383734312C31393638333237302C,0x31393535353833322C31393535363634342C31393537373733342C31393538343730372C31393631383833312C31393638343330332C),
 (91,'CAPZB.gApr07','chr1','-',19555735,19684619,19555736,19684618,5,0x31393535353733352C31393535363530322C31393537373632302C31393538343538352C31393638343531362C,0x31393535353833322C31393535363634342C31393537373733342C31393538343730372C31393638343631392C),
 (91,'CAPZB.oApr07','chr1','-',19573255,19684569,19573526,19684519,5,0x31393537333235352C31393537373632302C31393538343538352C31393631383734312C31393638343531362C,0x31393537333533362C31393537373733342C31393538343730372C31393631383833312C31393638343536392C),
 (91,'CAPZB.rApr07','chr1','-',19609007,19683378,19613581,19683360,4,0x31393630393030372C31393631333530312C31393631383734312C31393638333237302C,0x31393630393237322C31393631333539302C31393631383833312C31393638333337382C),
 (91,'nurarbo.aApr07','chr1','-',19790882,19795913,19790931,19795911,2,0x31393739303838322C31393739353739302C,0x31393739303936362C31393739353931332C),
 (92,'PLA2G5.oApr07','chr1','+',20227488,20338212,0,0,5,0x32303232373438382C32303235383731312C32303238333930302C32303238353136322C32303333383139342C,0x32303232373738392C32303235383737322C32303238333935302C32303238353330372C32303333383231322C),
 (92,'PLA2G2D.aApr07','chr1','-',20311000,20318637,20313193,20318635,4,0x32303331313030302C32303331343538362C32303331353431322C32303331383533382C,0x32303331333333392C32303331343639332C32303331353535372C32303331383633372C),
 (92,'PLA2G2D.bApr07','chr1','-',20313006,20318615,20313335,20318578,3,0x32303331333030362C32303331353431322C32303331383533382C,0x32303331333333392C32303331353535372C32303331383631352C),
 (92,'peyrarbo.cApr07','chr1','-',20559668,20628283,0,0,12,0x32303535393636382C32303536313232332C32303537323637342C32303537363436302C32303537373339302C32303537383035322C32303539373536322C32303539383535392C32303630303031342C32303630343635342C32303630353236362C32303632373636332C,0x32303536313132312C32303536313437342C32303537323831382C32303537363538392C32303537373531322C32303537383130362C32303539373836372C32303539383632392C32303630303036372C32303630343737342C32303630353334392C32303632383238332C),
 (92,'peyrarbo.eApr07','chr1','-',20559867,20627873,0,0,6,0x32303535393836372C32303536313232332C32303537323637342C32303630343635342C32303630353236362C32303632373636332C,0x32303536313132312C32303536313437342C32303537323831382C32303630343737342C32303630353334392C32303632373837332C),
 (92,'peyrarbo.fApr07','chr1','-',20572031,20630314,0,0,6,0x32303537323033312C32303539373739352C32303539383535392C32303630343635342C32303630353236362C32303633303235362C,0x32303537323234302C32303539373831382C32303539383632392C32303630343737342C32303630353334392C32303633303331342C),
 (92,'PINK1.aApr07','chr1','+',20832534,20851807,20832628,20849771,9,0x32303833323533342C32303833363932312C32303833383937312C32303834333536392C32303834343633392C32303834373538342C32303834383037342C32303834393531332C32303835313639342C,0x32303833333031352C32303833373230392C32303833393037322C32303834333735322C32303834343830332C32303834373731322C32303834383331312C32303835303736392C32303835313830372C),
 (92,'PINK1.cApr07','chr1','+',20838099,20850396,20839004,20847793,5,0x32303833383039392C32303834333536392C32303834343633392C32303834373538342C32303834393531332C,0x32303833393037322C32303834333735322C32303834343830332C32303834383331312C32303835303339362C),
 (93,'EIF4G3.cApr07','chr1','-',21005549,21375927,21006398,21375874,34,0x32313030353534392C32313030393831372C32313031323233372C32313031363437312C32313032343137392C32313032363639362C32313032383232362C32313033393933352C32313034383439342C32313035303333372C32313035323633392C32313035343035372C32313035363438322C32313035393436342C32313036313330372C32313036333535352C32313036343139352C32313037383430322C32313038353238302C32313039323539362C32313039343434372C32313039383737362C32313130333936322C32313134303537302C32313134393038322C32313136383535332C32313137323038312C32313137393431332C32313138303132372C32313230313739322C32313234393934352C32313238383231372C32313337353235342C32313337353830312C,0x32313030363538302C32313030393936342C32313031323331392C32313031363631382C32313032343237382C32313032363737382C32313032383335322C32313034303130382C32313034383631302C32313035303535382C32313035323735372C32313035343135312C32313035363537372C32313035393539372C32313036313431322C32313036333739322C32313036343334322C32313037383630302C32313038353435312C32313039323731362C32313039343538312C32313039393032332C32313130343035312C32313134313431302C32313134393139312C32313136383637362C32313137323137392C32313137393532382C32313138303330372C32313230313838382C32313235303037342C32313238383239332C32313337353433382C32313337353932372C),
 (93,'EIF4G3.dApr07','chr1','-',21005554,21310463,21006398,21310429,32,0x32313030353535342C32313030393831372C32313031323233372C32313031363437312C32313032343137392C32313032363639362C32313032383232362C32313033393933352C32313034383439342C32313035303333372C32313035323633392C32313035343035372C32313035363438322C32313035393436342C32313036313330372C32313036333535352C32313036343139352C32313037383430322C32313038353238302C32313039323539362C32313039343434372C32313039383737362C32313130333936322C32313134303537302C32313134393038322C32313136383535332C32313137323038312C32313137393431332C32313138303132372C32313230313739322C32313234393934352C32313331303430322C,0x32313030363538302C32313030393936342C32313031323331392C32313031363631382C32313032343237382C32313032363737382C32313032383335322C32313034303130382C32313034383631302C32313035303535382C32313035323735372C32313035343135312C32313035363537372C32313035393539372C32313036313431322C32313036333739322C32313036343334322C32313037383630302C32313038353435312C32313039323731362C32313039343538312C32313039393032332C32313130343035312C32313134313431302C32313134393139312C32313136383637362C32313137323137392C32313137393532382C32313138303330372C32313230313838382C32313235303037342C32313331303436332C),
 (93,'EIF4G3.bApr07','chr1','-',21005557,21375938,21006398,21375874,35,0x32313030353535372C32313030393831372C32313031323233372C32313031363437312C32313032343137392C32313032363639362C32313032383232362C32313033393933352C32313034383439342C32313035303333372C32313035323633392C32313035343035372C32313035363438322C32313035393436342C32313036313330372C32313036333535352C32313036343139352C32313037383430322C32313038353238302C32313039323539362C32313039343434372C32313039383737362C32313130333936322C32313134303537302C32313134393038322C32313136383535332C32313137323038312C32313137393431332C32313138303132372C32313138313436372C32313230313739322C32313234393934352C32313238383231372C32313337353235342C32313337353830312C,0x32313030363538302C32313030393936342C32313031323331392C32313031363631382C32313032343237382C32313032363737382C32313032383335322C32313034303130382C32313034383631302C32313035303535382C32313035323735372C32313035343135312C32313035363537372C32313035393539372C32313036313431322C32313036333739322C32313036343334322C32313037383630302C32313038353435312C32313039323731362C32313039343538312C32313039393032332C32313130343035312C32313134313431302C32313134393138382C32313136383637362C32313137323137392C32313137393532382C32313138303330372C32313138313438382C32313230313838382C32313235303037342C32313238383239332C32313337353433382C32313337353933382C),
 (93,'EIF4G3.eApr07','chr1','-',21005732,21375962,21006398,21375874,33,0x32313030353733322C32313030393831372C32313031323233372C32313031363437312C32313032343137392C32313032363639362C32313032383232362C32313033393933352C32313034383439342C32313035303333372C32313035323633392C32313035343035372C32313035363438322C32313035393436342C32313036313330372C32313036333535352C32313036343139352C32313037383430322C32313038353238302C32313039323539362C32313039343434372C32313039383737362C32313130333936322C32313134393038322C32313136383535332C32313137323038312C32313137393431332C32313138303132372C32313230313739322C32313234393934352C32313238383231372C32313331303430322C32313337353830312C,0x32313030363538302C32313030393936342C32313031323331392C32313031363631382C32313032343237382C32313032363737382C32313032383335322C32313034303130382C32313034383631302C32313035303535382C32313035323735372C32313035343135312C32313035363537372C32313035393539372C32313036313431322C32313036333739322C32313036343334322C32313037383630302C32313038353435312C32313039323731362C32313039343538312C32313039393032332C32313130343035312C32313134393139312C32313136383637362C32313137323137392C32313137393532382C32313138303330372C32313230313838382C32313235303037342C32313238383239332C32313331303436332C32313337353936322C),
 (93,'EIF4G3.aApr07','chr1','-',21005873,21375927,21006398,21375874,35,0x32313030353837332C32313030393831372C32313031323233372C32313031363437312C32313032343137392C32313032363639362C32313032383232362C32313033393933352C32313034383439342C32313035303333372C32313035323633392C32313035343035372C32313035363438322C32313035393436342C32313036313330372C32313036333535352C32313036343139352C32313037383430322C32313038353238302C32313039313639382C32313039323539362C32313039343434372C32313039383737362C32313130333936322C32313134303537302C32313134393038322C32313136383535332C32313137323038312C32313137393431332C32313138303132372C32313230313739322C32313234393934352C32313238383231372C32313337353235342C32313337353830312C,0x32313030363538302C32313030393936342C32313031323331392C32313031363631382C32313032343237382C32313032363737382C32313032383335322C32313034303130382C32313034383631302C32313035303535382C32313035323735372C32313035343135312C32313035363537372C32313035393539372C32313036313431322C32313036333739322C32313036343334322C32313037383630302C32313038353435312C32313039313830392C32313039323731362C32313039343538312C32313039393032332C32313130343035312C32313134313431302C32313134393138382C32313136383637362C32313137323137392C32313137393532382C32313138303330372C32313230313838382C32313235303037342C32313238383239332C32313337353433382C32313337353932372C),
 (93,'EIF4G3.hApr07','chr1','-',21006374,21375988,21006398,21375740,8,0x32313030363337342C32313030393831372C32313031323233372C32313031363437312C32313234393934382C32313238383231372C32313331303430322C32313337353235342C,0x32313030363538302C32313030393936342C32313031323331392C32313031363537382C32313235303037342C32313238383239332C32313331303435322C32313337353938382C),
 (93,'EIF4G3.sApr07','chr1','-',21085418,21140599,21085444,21103983,6,0x32313038353431382C32313039323539362C32313039343434372C32313039383837392C32313130333936322C32313134303537302C,0x32313038353435312C32313039323731362C32313039343538312C32313039393032332C32313130343035312C32313134303539392C),
 (93,'EIF4G3.lApr07','chr1','-',21092430,21140475,21092566,21140462,5,0x32313039323433302C32313039343434372C32313039383737362C32313130333936322C32313134303333382C,0x32313039323731362C32313039343538312C32313039393032332C32313130343035312C32313134303437352C),
 (93,'EIF4G3.fApr07','chr1','-',21140323,21373824,21140455,21367065,15,0x32313134303332332C32313134303537302C32313134393038322C32313136383535332C32313137323038312C32313137393431332C32313138303132372C32313139363638302C32313230313739322C32313234393934352C32313238383231372C32313331303430322C32313336373034302C32313336383734332C32313337333738392C,0x32313134303437352C32313134313431302C32313134393139312C32313136383637362C32313137323137392C32313137393532382C32313138303330372C32313139363731332C32313230313838382C32313235303037342C32313238383239332C32313331303436332C32313336373131392C32313336383830312C32313337333832342C),
 (93,'EIF4G3.iApr07','chr1','-',21140326,21373834,21140455,21288220,9,0x32313134303332362C32313134303537302C32313138303139362C32313139363638302C32313230313739322C32313234393934352C32313238383231372C32313336383731382C32313337333738392C,0x32313134303437352C32313134303935372C32313138303330372C32313139363731332C32313230313838382C32313235303037342C32313238383239332C32313336383830312C32313337333833342C),
 (93,'EIF4G3.gApr07','chr1','-',21140326,21373848,21140455,21288220,11,0x32313134303332362C32313134303537302C32313134393038322C32313136383535332C32313137323038312C32313137393431332C32313138303132372C32313230313739322C32313234393934352C32313238383231372C32313337333738392C,0x32313134303437352C32313134313431302C32313134393138382C32313136383637362C32313137323137392C32313137393532382C32313138303330372C32313230313838382C32313235303037342C32313238383239332C32313337333834382C),
 (93,'EIF4G3.kApr07','chr1','-',21168553,21373834,21168553,21288220,11,0x32313136383535332C32313137323038312C32313137393431332C32313138303132372C32313230303237382C32313230313739322C32313234393934352C32313238383231372C32313331303430322C32313336383731382C32313337333738392C,0x32313136383637362C32313137323137392C32313137393532382C32313138303330372C32313230303339322C32313230313838382C32313235303037342C32313238383239332C32313331303436332C32313336383830312C32313337333833342C),
 (93,'EIF4G3.uApr07','chr1','-',21180155,21373848,21180157,21288220,7,0x32313138303135352C32313139363638302C32313230313739322C32313234393934352C32313238383231372C32313331303430322C32313337333738392C,0x32313138303330372C32313139363731332C32313230313838382C32313235303037342C32313238383239332C32313331303436332C32313337333834382C),
 (93,'EIF4G3.mApr07','chr1','-',21180192,21375962,21180193,21375874,6,0x32313138303139322C32313230313739322C32313234393934352C32313238383231372C32313337353235342C32313337353830312C,0x32313138303330372C32313230313836372C32313235303037342C32313238383239332C32313337353433382C32313337353936322C),
 (93,'EIF4G3.nApr07','chr1','-',21180303,21375338,21180304,21375337,6,0x32313138303330332C32313230303237382C32313230313739322C32313234393934352C32313238383231372C32313337353235342C,0x32313138303330372C32313230303339322C32313230313838382C32313235303037342C32313238383239332C32313337353333382C),
 (93,'EIF4G3.rApr07','chr1','-',21196680,21375350,21196680,21375349,5,0x32313139363638302C32313230313739322C32313234393934352C32313238383231372C32313337353235342C,0x32313139363731332C32313230313838382C32313235303037342C32313238383239332C32313337353335302C),
 (93,'EIF4G3.tApr07','chr1','-',21200336,21375962,21200395,21375874,6,0x32313230303333362C32313230313739322C32313234393934352C32313238383231372C32313331303430322C32313337353830312C,0x32313230303430342C32313230313836372C32313235303037342C32313238383239332C32313331303436332C32313337353936322C),
 (93,'EIF4G3.vgApr07','chr1','-',21310020,21375962,0,0,2,0x32313331303032302C32313337353830312C,0x32313331303436332C32313337353936322C),
 (93,'palarbo.aApr07','chr1','+',21358547,21368726,0,0,2,0x32313335383534372C32313336383239332C,0x32313335383537392C32313336383732362C),
 (93,'ECE1.cApr07','chr1','-',21416325,21544622,21419034,21544458,19,0x32313431363332352C32313432303832362C32313432343332392C32313432363233382C32313432373031302C32313433323633372C32313433343932392C32313433353832352C32313433373231332C32313434343036382C32313434363330302C32313435353032362C32313435363630342C32313435373737322C32313435393335302C32313437313737382C32313437383237302C32313438393134392C32313534343435352C,0x32313431393231312C32313432303932322C32313432343532302C32313432363330362C32313432373132312C32313433323734312C32313433353030372C32313433353932342C32313433373332342C32313434343138332C32313434363434332C32313435353231382C32313435363637302C32313435373931392C32313435393437322C32313437313939312C32313437383431322C32313438393233362C32313534343632322C),
 (93,'ECE1.hApr07','chr1','-',21459384,21509453,21459386,21489236,5,0x32313435393338342C32313437313737382C32313437383237302C32313438393134392C32313530393339352C,0x32313435393437322C32313437313939312C32313437383431322C32313438393233362C32313530393435332C),
 (93,'ECE1.jApr07','chr1','-',21471825,21498078,21471827,21497905,4,0x32313437313832352C32313437383237302C32313438393134392C32313439373839362C,0x32313437313939312C32313437383431322C32313438393233362C32313439383037382C),
 (93,'ECE1.nApr07','chr1','-',21471914,21544217,21471914,21489236,4,0x32313437313931342C32313437383237302C32313438393134392C32313534343031362C,0x32313437313939312C32313437383431322C32313438393233362C32313534343231372C),
 (93,'nasiyo.aApr07','chr1','+',21492369,21498982,21493135,21497203,3,0x32313439323336392C32313439333031332C32313439373130362C,0x32313439323832332C32313439333239302C32313439383938322C),
 (93,'NBPF2P.aApr07','chr1','-',21622186,21626937,21623699,21626882,5,0x32313632323138362C32313632343534372C32313632353331332C32313632363130312C32313632363836332C,0x32313632333934332C32313632343539392C32313632353438362C32313632363135332C32313632363933372C),
 (93,'ALPL.iApr07','chr1','+',21708064,21762304,21753161,21762303,5,0x32313730383036342C32313735333035372C32313735393730352C32313736303137362C32313736323138392C,0x32313730383139312C32313735333232322C32313735393832352C32313736303239322C32313736323330342C),
 (93,'ALPL.aApr07','chr1','+',21708450,21777495,21708479,21776728,12,0x32313730383435302C32313735333035372C32313735393730352C32313736303137362C32313736323138392C32313736333132302C32313736373138332C32313736393338342C32313737323734342C32313737343831322C32313737353630312C32313737363436322C,0x32313730383539372C32313735333232322C32313735393832352C32313736303239322C32313736323336342C32313736333239362C32313736373332372C32313736393435342C32313737323837392C32313737353030342C32313737353732312C32313737373439352C),
 (93,'ALPL.cApr07','chr1','+',21708479,21777489,21759809,21777489,6,0x32313730383437392C32313735393730352C32313736303137362C32313736323138392C32313736333132302C32313737363936392C,0x32313730383539372C32313735393832352C32313736303239322C32313736323336342C32313736333238382C32313737373438392C),
 (93,'ALPL.bApr07','chr1','+',21750329,21777486,21753161,21776728,12,0x32313735303332392C32313735333035372C32313735393730352C32313736303137362C32313736323138392C32313736333132302C32313736373138332C32313736393338342C32313737323734342C32313737343831322C32313737353630312C32313737363436322C,0x32313735303530382C32313735333232322C32313735393832352C32313736303239322C32313736323336342C32313736333239362C32313736373332372C32313736393435342C32313737323837392C32313737353030342C32313737353732312C32313737373438362C),
 (93,'ALPL.jApr07','chr1','+',21750345,21762288,21753161,21762288,5,0x32313735303334352C32313735333035372C32313735393730352C32313736303137362C32313736323138392C,0x32313735303432322C32313735333232322C32313735393832352C32313736303239322C32313736323238382C),
 (93,'ALPL.mApr07','chr1','+',21750400,21759757,0,0,4,0x32313735303430302C32313735333035372C32313735363431352C32313735393730352C,0x32313735303530382C32313735333232322C32313735363632342C32313735393735372C),
 (93,'USP48.aApr07','chr1','-',21877377,21982278,21878496,21982037,27,0x32313837373337372C32313837393838372C32313838363237302C32313838393035332C32313839343134352C32313930303537372C32313930323539312C32313930333334312C32313930343830362C32313930353230352C32313930353534362C32313930353832332C32313931343436382C32313932303131352C32313932303732392C32313932323937372C32313932373634392C32313932383738332C32313933353532352C32313934363134362C32313934373231372C32313935303538362C32313935313630362C32313935323037312C32313935353632352C32313935363734322C32313938313930332C,0x32313837383531392C32313837393931342C32313838363331392C32313838393137392C32313839343330312C32313930303638322C32313930323639382C32313930333437322C32313930343931372C32313930353236372C32313930353636392C32313930353934382C32313931343533372C32313932303234362C32313932303834342C32313932333137352C32313932373739392C32313932383931322C32313933353730352C32313934363232392C32313934373335312C32313935303639352C32313935313733312C32313935323139392C32313935353738322C32313935363836332C32313938323237382C),
 (93,'USP48.eApr07','chr1','-',21877976,21924536,21878496,21923242,15,0x32313837373937362C32313837393838372C32313838363237302C32313838393035332C32313930303537372C32313930323539312C32313930333334312C32313930343830362C32313930353230352C32313930353534362C32313930353832332C32313931343436382C32313932303131352C32313932303732392C32313932323937372C,0x32313837383531392C32313837393931342C32313838363331392C32313838393137392C32313930303638322C32313930323639382C32313930333437322C32313930343931372C32313930353236372C32313930353636392C32313930353934382C32313931343533372C32313932303234332C32313932303834342C32313932343533362C),
 (93,'USP48.cApr07','chr1','-',21877982,21982251,21878496,21982037,26,0x32313837373938322C32313837393838372C32313838363237302C32313838393035332C32313839343134352C32313930303537372C32313930323539312C32313930333334312C32313930343830362C32313930353230352C32313930353534362C32313930353832332C32313931343436382C32313932303131352C32313932303732392C32313932373634392C32313932383738332C32313933353532352C32313934363134362C32313934373231372C32313935303538362C32313935313630362C32313935323037312C32313935353632352C32313935363734322C32313938313930332C,0x32313837383531392C32313837393931342C32313838363331392C32313838393137392C32313839343330312C32313930303638322C32313930323639382C32313930333437322C32313930343931372C32313930353236372C32313930353636392C32313930353934382C32313931343533372C32313932303234362C32313932303834342C32313932373739392C32313932383931322C32313933353730352C32313934363232392C32313934373335312C32313935303639352C32313935313733312C32313935323139392C32313935353738322C32313935363836332C32313938323235312C),
 (93,'USP48.bApr07','chr1','-',21878453,21982071,21878496,21982070,26,0x32313837383435332C32313837393838372C32313838363237302C32313838393035332C32313930303537372C32313930323539312C32313930333334312C32313930343830362C32313930353230352C32313930353534362C32313930353832332C32313931343436382C32313932303131352C32313932303732392C32313932323937372C32313932373634392C32313932383738332C32313933353532352C32313934363134362C32313934373231372C32313935303538362C32313935313630362C32313935323037312C32313935353632352C32313935363734322C32313938313930332C,0x32313837383531392C32313837393931342C32313838363331392C32313838393137392C32313930303638322C32313930323639382C32313930333437322C32313930343931372C32313930353236372C32313930353636392C32313930353934382C32313931343533372C32313932303234362C32313932303834342C32313932333137352C32313932373739392C32313932383931322C32313933353730352C32313934363232392C32313934373335312C32313935303639352C32313935313733312C32313935323139392C32313935353738322C32313935363836332C32313938323037312C),
 (93,'USP48.jApr07','chr1','-',21884920,21903695,21886238,21900679,5,0x32313838343932302C32313838393035332C32313839343134352C32313930303537372C32313930333334312C,0x32313838363331392C32313838393137392C32313839343330312C32313930303638322C32313930333639352C),
 (94,'CDC42.fApr07','chr1','+',22224585,22290630,22277558,22290597,6,0x32323232343538352C32323237373530382C32323238303830312C32323238353531382C32323238353734382C32323239303530372C,0x32323232343732332C32323237373636332C32323238303837342C32323238353632382C32323238353934362C32323239303633302C),
 (94,'CDC42.iApr07','chr1','+',22251698,22290167,22277558,22289112,6,0x32323235313639382C32323237373530382C32323238303830312C32323238353531382C32323238353734382C32323238393032322C,0x32323235313832322C32323237373636332C32323238303837342C32323238353632382C32323238353934362C32323239303136372C),
 (94,'CDC42.jApr07','chr1','+',22251706,22292026,22277558,22290597,7,0x32323235313730362C32323237333137332C32323237373530382C32323238303830312C32323238353531382C32323238353734382C32323239303530372C,0x32323235313832322C32323237333239392C32323237373636332C32323238303837342C32323238353632382C32323238353934362C32323239323032362C),
 (94,'CDC42.kApr07','chr1','+',22251706,22292029,22277558,22290597,6,0x32323235313730362C32323237373530382C32323238303830312C32323238353531382C32323238353734382C32323239303530372C,0x32323235313832322C32323237373636332C32323238303837342C32323238353632382C32323238353934362C32323239323032392C),
 (94,'CDC42.lApr07','chr1','+',22251789,22286280,22277558,22285961,5,0x32323235313738392C32323237373530382C32323238303830312C32323238353531382C32323238353734382C,0x32323235313832322C32323237373636332C32323238303837342C32323238353632382C32323238363238302C),
 (94,'CDC42.oApr07','chr1','+',22251791,22285805,22277558,22285805,6,0x32323235313739312C32323236383330302C32323237373530382C32323238303830312C32323238353531382C32323238353734382C,0x32323235313832322C32323236383339382C32323237373636332C32323238303837342C32323238353632382C32323238353830352C),
 (94,'CDC42.mApr07','chr1','+',22252376,22290681,22277558,22290517,6,0x32323235323337362C32323237373530382C32323238303830312C32323238353531382C32323238353734382C32323239303531312C,0x32323235323531332C32323237373636332C32323238303837342C32323238353632382C32323238353934362C32323239303638312C),
 (94,'CDC42.dApr07','chr1','+',22262831,22289243,22277558,22289112,7,0x32323236323833312C32323237333137332C32323237373530382C32323238303830312C32323238353531382C32323238353734382C32323238393032322C,0x32323236333131352C32323237333239392C32323237373636332C32323238303837342C32323238353632382C32323238353934362C32323238393234332C),
 (94,'CDC42.gApr07','chr1','+',22275426,22290669,22277558,22290597,6,0x32323237353432362C32323237373530382C32323238303830312C32323238353531382C32323238353734382C32323239303530372C,0x32323237353434312C32323237373636332C32323238303837342C32323238353632382C32323238353934362C32323239303636392C),
 (94,'CDC42.aApr07','chr1','+',22275426,22290691,22277608,22290597,7,0x32323237353432362C32323237373530382C32323237373738352C32323238303830312C32323238353531382C32323238353734382C32323239303530372C,0x32323237353434312C32323237373636332C32323237373936312C32323238303837342C32323238353632382C32323238353934362C32323239303639312C),
 (94,'CDC42.cApr07','chr1','+',22275429,22289169,22277558,22289112,6,0x32323237353432392C32323237373530382C32323238303830312C32323238353531382C32323238353734382C32323238393032322C,0x32323237353434312C32323237373636332C32323238303837342C32323238353632382C32323238353934362C32323238393136392C),
 (94,'CDC42.hApr07','chr1','+',22277497,22290750,22277558,22290597,5,0x32323237373439372C32323238303830312C32323238353531382C32323238353734382C32323239303530372C,0x32323237373636332C32323238303837342C32323238353632382C32323238353934362C32323239303735302C),
 (94,'CDC42.eApr07','chr1','+',22277506,22289169,22277558,22289112,5,0x32323237373530362C32323238303830312C32323238353531382C32323238353734382C32323238393032322C,0x32323237373636332C32323238303837342C32323238353632382C32323238353934362C32323238393136392C),
 (94,'CDC42.bApr07','chr1','+',22277506,22289087,22277608,22289085,6,0x32323237373530362C32323237373738352C32323238303830312C32323238353531382C32323238353734382C32323238393032322C,0x32323237373636332C32323237373936312C32323238303837342C32323238353632382C32323238353934362C32323238393038372C),
 (94,'CDC42.nApr07','chr1','+',22280316,22290847,22280828,22290597,5,0x32323238303331362C32323238303832302C32323238353531382C32323238353734382C32323239303530372C,0x32323238303738302C32323238303837342C32323238353632382C32323238353934362C32323239303834372C),
 (94,'ZBTB40.cApr07','chr1','+',22650931,22705321,22689028,22705320,7,0x32323635303933312C32323635313733382C32323638383935392C32323639303437392C32323730303537312C32323730313337382C32323730353132382C,0x32323635313038342C32323635323032362C32323638393732352C32323639303631332C32323730303736342C32323730313532312C32323730353332312C),
 (94,'ZBTB40.aApr07','chr1','+',22650931,22730237,22689028,22725476,18,0x32323635303933312C32323638383935392C32323639303437392C32323730303537312C32323730313337382C32323730353132382C32323730373038302C32323730373630392C32323730383137392C32323731303235382C32323731303735352C32323731323030332C32323731363337392C32323731393134302C32323732303537352C32323732313435362C32323732333239372C32323732353238312C,0x32323635313038342C32323638393732352C32323639303631332C32323730303736342C32323730313532312C32323730353332312C32323730373231372C32323730373831312C32323730383331332C32323731303432372C32323731313231342C32323731323231302C32323731363534342C32323731393335352C32323732303733382C32323732313534332C32323732333532342C32323733303233372C),
 (94,'ZBTB40.bApr07','chr1','+',22651058,22726442,22689028,22725476,16,0x32323635313035382C32323638383935392C32323639303437392C32323730353132382C32323730373038302C32323730373630392C32323730383137392C32323731303235382C32323731303735352C32323731323030332C32323731363337392C32323731393134302C32323732303537352C32323732313435362C32323732333239372C32323732353238312C,0x32323635313038342C32323638393732352C32323639303631332C32323730353332312C32323730373231372C32323730373831312C32323730383331332C32323731303432372C32323731313231342C32323731323231302C32323731363534342C32323731393335352C32323732303733382C32323732313534332C32323732333532342C32323732363434322C),
 (95,'LUZP1.aApr07','chr1','-',23281526,23367925,23287974,23293341,5,0x32333238313532362C32333239303236392C32333330383130312C32333330383636342C32333336373834352C,0x32333238383133332C32333239333436302C32333330383230372C32333330383733302C32333336373932352C),
 (95,'LUZP1.bApr07','chr1','-',23288857,23377094,23290179,23293341,4,0x32333238383835372C32333330383130312C32333336373834352C32333337363537302C,0x32333239333436302C32333330383230372C32333336383130342C32333337373039342C),
 (95,'LUZP1.cApr07','chr1','-',23289506,23367902,23289969,23293341,3,0x32333238393530362C32333239303236392C32333336373834352C,0x32333238393937382C32333239333436302C32333336373930322C),
 (95,'TCEA3.bApr07','chr1','-',23579542,23623851,23580545,23623713,11,0x32333537393534322C32333538333432352C32333538363335322C32333539323935382C32333539363632342C32333539363837312C32333630373734332C32333631363332382C32333631363938332C32333631383135362C32333632333634342C,0x32333538303535342C32333538333439372C32333538363439392C32333539333131332C32333539363638312C32333539373033352C32333630373830362C32333631363437302C32333631373038392C32333631383231392C32333632333835312C),
 (95,'TCEA3.aApr07','chr1','-',23580454,23596369,23582750,23596258,3,0x32333538303435342C32333538323730352C32333539353830362C,0x32333538303535342C32333538333132342C32333539363336392C),
 (95,'E2F2.aApr07','chr1','-',23705506,23730334,23708958,23729872,7,0x32333730353530362C32333731353431332C32333731383039342C32333731393939312C32333732303931352C32333732333436312C32333732393632302C,0x32333730393232372C32333731353630362C32333731383230392C32333732303135302C32333732313133352C32333732333536372C32333733303333342C),
 (95,'E2F2.cApr07','chr1','-',23720026,23730328,23720132,23723561,4,0x32333732303032362C32333732303931352C32333732333436312C32333733303137322C,0x32333732303134382C32333732313133352C32333732333536372C32333733303332382C),
 (95,'E2F2.bApr07','chr1','-',23720934,23729993,23720935,23729993,2,0x32333732303933342C32333732393632302C,0x32333732313133352C32333732393939332C),
 (95,'nusiyo.aApr07','chr1','+',23721009,23726852,23726134,23726846,3,0x32333732313030392C32333732363030382C32333732363438332C,0x32333732313036342C32333732363134392C32333732363835322C),
 (95,'C1orf128.aApr07','chr1','+',23977463,23987703,23977592,23986453,6,0x32333937373436332C32333937383531342C32333937383934302C32333938343735312C32333938353339312C32333938363335312C,0x32333937373739302C32333937383535382C32333937393031382C32333938343835362C32333938353530302C32333938373730332C),
 (95,'C1orf128.bApr07','chr1','+',23977495,23986453,23977611,23986453,5,0x32333937373439352C32333937383934302C32333938343735312C32333938353339312C32333938363335312C,0x32333937373739302C32333937393031382C32333938343835362C32333938353530302C32333938363435332C),
 (95,'C1orf128.gApr07','chr1','+',23978521,23986789,23978523,23986370,4,0x32333937383532312C32333937383934302C32333938343735312C32333938363335312C,0x32333937383535382C32333937393031382C32333938343835362C32333938363738392C),
 (95,'C1orf128.eApr07','chr1','+',23983724,23987307,23984770,23986453,4,0x32333938333732342C32333938343735312C32333938353339312C32333938363335312C,0x32333938343338382C32333938343835362C32333938353530302C32333938373330372C),
 (96,'chaby.bApr07','chr1','+',24209599,24285876,0,0,6,0x32343230393539392C32343232323734332C32343233393932362C32343234313335332C32343236333132332C32343238353832362C,0x32343230393635322C32343232323833382C32343234303031392C32343234313432322C32343236333335302C32343238353837362C),
 (96,'IL28RA.aApr07','chr1','-',24353221,24386352,24356206,24386325,7,0x32343335333232312C32343335383132382C32343335383535302C32343336303631382C32343336383439332C32343337393830372C32343338363236372C,0x32343335363936382C32343335383235392C32343335383731302C32343336303736312C32343336383637382C32343337393933312C32343338363335322C),
 (96,'IL28RA.dApr07','chr1','-',24353233,24386338,24356903,24386325,6,0x32343335333233332C32343335383535302C32343336303631382C32343336383439332C32343337393830372C32343338363236372C,0x32343335363936382C32343335383731302C32343336303736312C32343336383637382C32343337393933312C32343338363333382C),
 (96,'IL28RA.bApr07','chr1','-',24353233,24386338,24356206,24386325,7,0x32343335333233332C32343335383132382C32343335383535302C32343336303631382C32343336383439332C32343337393830372C32343338363236372C,0x32343335363838312C32343335383235392C32343335383731302C32343336303736312C32343336383637382C32343337393933312C32343338363333382C),
 (96,'IL28RA.gApr07','chr1','-',24353250,24386714,24368663,24386570,5,0x32343335333235302C32343336303637342C32343336383439332C32343337393830372C32343338363535392C,0x32343335333636332C32343336303736312C32343336383637382C32343337393933312C32343338363731342C),
 (96,'IL28RA.cApr07','chr1','-',24356803,24386338,24356803,24386338,6,0x32343335363830332C32343335383132382C32343335383535302C32343336303631382C32343336383439332C32343338363236372C,0x32343335363936382C32343335383235392C32343335383731302C32343336303736312C32343336383637382C32343338363333382C),
 (96,'IL28RA.eApr07','chr1','-',24358552,24387036,24358554,24386906,5,0x32343335383535322C32343336303631382C32343336383439332C32343337393830372C32343338363837382C,0x32343335383731302C32343336303736312C32343336383637382C32343337393933312C32343338373033362C),
 (96,'IL28RA.fApr07','chr1','-',24360454,24386325,24360492,24386325,4,0x32343336303435342C32343336383439332C32343337393830372C32343338363236372C,0x32343336303736312C32343336383637382C32343337393933312C32343338363332352C),
 (96,'cherby.aApr07','chr1','-',24506632,24520978,24509881,24520978,5,0x32343530363633322C32343530373235342C32343530393735312C32343531303935352C32343532303734322C,0x32343530363835372C32343530373339322C32343530393839342C32343531313036392C32343532303937382C),
 (96,'NPAL3.hApr07','chr1','+',24612437,24668206,24612800,24655223,10,0x32343631323433372C32343633393234382C32343634313133312C32343634343236312C32343634383535372C32343635353231342C32343635373936342C32343635393535372C32343636333130322C32343636383036322C,0x32343631323835312C32343633393331372C32343634313330332C32343634343332312C32343634383730332C32343635353335302C32343635383035332C32343635393632312C32343636333139372C32343636383230362C),
 (96,'NPAL3.fApr07','chr1','+',24612601,24660619,24618624,24660155,5,0x32343631323630312C32343631383336372C32343633393234382C32343634313133312C32343636303035302C,0x32343631323835312C32343631383731372C32343633393331372C32343634313330332C32343636303631392C),
 (96,'NPAL3.aApr07','chr1','+',24614827,24672163,24618624,24668262,12,0x32343631343832372C32343631383336372C32343633393234382C32343634313133312C32343634343236312C32343634383535372C32343635323438342C32343635353231342C32343635373936342C32343635393535372C32343636333130322C32343636383036322C,0x32343631343938312C32343631383731372C32343633393331372C32343634313330332C32343634343332312C32343634383730332C32343635323538312C32343635353335302C32343635383035332C32343635393632312C32343636333139372C32343637323136332C),
 (96,'NPAL3.bApr07','chr1','+',24614832,24672049,24614891,24671862,11,0x32343631343833322C32343633393234382C32343634313133312C32343634343236312C32343634383535372C32343635323438342C32343635353231342C32343635373936342C32343635393535372C32343636333130322C32343637313734362C,0x32343631343938312C32343633393331372C32343634313330332C32343634343332312C32343634383730332C32343635323538312C32343635353335302C32343635383035332C32343635393632312C32343636333139372C32343637323034392C),
 (96,'NPAL3.dApr07','chr1','+',24614860,24665783,24639191,24663144,13,0x32343631343836302C32343631353130312C32343631383336372C32343633393136362C32343634313133312C32343634343236312C32343634383535372C32343635323438342C32343635353231342C32343635363831302C32343635373936342C32343635393535372C32343636333130322C,0x32343631343938312C32343631353337362C32343631383731372C32343633393331372C32343634313330332C32343634343332312C32343634383730332C32343635323538312C32343635353335302C32343635363931302C32343635383035332C32343635393632312C32343636353738332C),
 (96,'NPAL3.mApr07','chr1','+',24614880,24648590,24614891,24618484,3,0x32343631343838302C32343631383336372C32343634383535372C,0x32343631343938312C32343631383731372C32343634383539302C),
 (96,'NPAL3.eApr07','chr1','+',24614880,24670655,24641215,24668262,13,0x32343631343838302C32343631383336372C32343633323138302C32343633393234382C32343634313133312C32343634343236312C32343634383535372C32343635323438342C32343635353231342C32343635373936342C32343635393535372C32343636333130322C32343636383036322C,0x32343631343938312C32343631383731372C32343633323239302C32343633393331372C32343634313330332C32343634343332312C32343634383730332C32343635323538312C32343635353335302C32343635383035332C32343635393632312C32343636333139372C32343637303635352C),
 (96,'NPAL3.iApr07','chr1','+',24614882,24648567,24614891,24643125,6,0x32343631343838322C32343633393234382C32343634313133312C32343634333131312C32343634343236312C32343634383535372C,0x32343631343938312C32343633393331372C32343634313330332C32343634333236312C32343634343332312C32343634383536372C),
 (96,'NPAL3.cApr07','chr1','+',24614888,24665420,24618624,24665166,12,0x32343631343838382C32343631383336372C32343633393234382C32343634313133312C32343634343236312C32343634383535372C32343635323438342C32343635353231342C32343635373936342C32343635393535372C32343636333130322C32343636353038302C,0x32343631343938312C32343631383731372C32343633393331372C32343634313330332C32343634343332312C32343634383730332C32343635323538312C32343635353335302C32343635383035332C32343635393632312C32343636333139372C32343636353432302C),
 (96,'NPAL3.gApr07','chr1','+',24614889,24653900,24618624,24653174,8,0x32343631343838392C32343631383336372C32343633393234382C32343634313133312C32343634343236312C32343634383535372C32343635323438342C32343635333133302C,0x32343631343938312C32343631383731372C32343633393331372C32343634313330332C32343634343332312C32343634383730332C32343635323538312C32343635333930302C),
 (96,'C1orf130.aApr07','chr1','+',24755153,24808406,24794508,24804825,4,0x32343735353135332C32343739343530312C32343830303031372C32343830343638332C,0x32343735353234372C32343739343539302C32343830303130322C32343830383430362C),
 (96,'CLIC4.eApr07','chr1','+',24943176,25039896,24996873,25039895,6,0x32343934333137362C32343939363831392C32353031333137312C32353032363038372C32353033383933372C32353033393835302C,0x32343934333330322C32343939363932392C32353031333239372C32353032363139342C32353033393131392C32353033393839362C),
 (96,'CLIC4.aApr07','chr1','+',24944391,25043619,24944631,25040015,6,0x32343934343339312C32343939363831392C32353031333137312C32353032363038372C32353033383933372C32353033393835302C,0x32343934343730332C32343939363932392C32353031333239372C32353032363139342C32353033393131392C32353034333631392C),
 (96,'CLIC4.hApr07','chr1','+',24944458,25039020,24996873,25039020,6,0x32343934343435382C32343939323235342C32343939363831392C32353031333137312C32353032363038372C32353033383933372C,0x32343934343730332C32343939323239312C32343939363932392C32353031333239372C32353032363139342C32353033393032302C),
 (96,'CLIC4.cApr07','chr1','+',24944466,25041385,24944631,25040015,6,0x32343934343436362C32343939363836362C32353031333137312C32353032363038372C32353033383933372C32353033393835302C,0x32343934343639302C32343939363932392C32353031333239372C32353032363139342C32353033393131392C32353034313338352C),
 (96,'CLIC4.lApr07','chr1','+',24944472,25041274,24996829,25041170,4,0x32343934343437322C32343939363831392C32353034303037362C32353034313134342C,0x32343934343730332C32343939363833322C32353034303135352C32353034313237342C),
 (96,'CLIC4.fApr07','chr1','+',24944484,25039119,24944631,25039119,4,0x32343934343438342C32343939363831392C32353032363038372C32353033383933372C,0x32343934343730332C32343939363932392C32353032363139342C32353033393131392C),
 (96,'CLIC4.bApr07','chr1','+',24944494,25039028,24944495,25039026,6,0x32343934343439342C32343938303931312C32343939363831392C32353031333137312C32353032363038372C32353033383933372C,0x32343934343730332C32343938313032372C32343939363932392C32353031333239372C32353032363139342C32353033393032382C),
 (96,'CLIC4.gApr07','chr1','+',24944525,25039094,24944665,25039092,4,0x32343934343532352C32353031333137312C32353032363038372C32353033383933372C,0x32343934343730332C32353031333239372C32353032363139342C32353033393039342C),
 (96,'CLIC4.iApr07','chr1','+',24944525,25038981,24996873,25038981,6,0x32343934343532352C32343936333931382C32343939363831392C32353031333137312C32353032363038372C32353033383933372C,0x32343934343730332C32343936333934392C32343939363932392C32353031333239372C32353032363139342C32353033383938312C),
 (97,'bloby.bApr07','chr1','-',25242784,25312197,0,0,3,0x32353234323738342C32353330323933302C32353331313935362C,0x32353234323931342C32353330333034392C32353331323139372C),
 (97,'SYF2.bApr07','chr1','-',25421353,25431600,25422343,25431599,6,0x32353432313335332C32353432343037392C32353432363531392C32353432373139352C32353433313138312C32353433313532312C,0x32353432323530392C32353432343137382C32353432363631302C32353432373331332C32353433313238392C32353433313630302C),
 (97,'SYF2.aApr07','chr1','-',25421353,25431602,25422343,25431545,7,0x32353432313335332C32353432343037392C32353432363531392C32353432373139352C32353432383037352C32353433313138312C32353433313532312C,0x32353432323530392C32353432343137382C32353432363631302C32353432373331332C32353432383230312C32353433313238392C32353433313630322C),
 (97,'SYF2.cApr07','chr1','-',25424120,25431510,25424120,25431187,5,0x32353432343132302C32353432363531392C32353432373139352C32353432383037352C32353433313138312C,0x32353432343137382C32353432363631302C32353432373331332C32353432383230312C32353433313531302C),
 (97,'TMEM50A.bApr07','chr1','+',25537375,25561439,25539564,25559783,7,0x32353533373337352C32353533393535312C32353534323033382C32353535303730332C32353535313935392C32353535353837302C32353535393733372C,0x32353533373533342C32353533393635372C32353534323135312C32353535303737312C32353535323035322C32353535353933312C32353536313433392C),
 (97,'TMEM50A.fApr07','chr1','+',25537383,25560050,0,0,6,0x32353533373338332C32353533393535312C32353535303730332C32353535313935392C32353535353837302C32353535393733372C,0x32353533373533342C32353533393635372C32353535303737312C32353535323035322C32353535353933312C32353536303035302C),
 (97,'TMEM50A.gApr07','chr1','+',25537388,25559993,0,0,4,0x32353533373338382C32353535303730332C32353535353837302C32353535393733372C,0x32353533373533342C32353535303737312C32353535353933312C32353535393939332C),
 (97,'TMEM50A.eApr07','chr1','+',25537397,25561346,25551988,25559783,5,0x32353533373339372C32353535303730332C32353535313935392C32353535353837302C32353535393733372C,0x32353533373533342C32353535303737312C32353535323035322C32353535353933312C32353536313334362C),
 (97,'TMEM50A.dApr07','chr1','+',25537400,25561423,25539564,25559783,6,0x32353533373430302C32353533393535312C32353534323033382C32353535303730332C32353535353837302C32353535393733372C,0x32353533373533342C32353533393635372C32353534323135312C32353535303737312C32353535353933312C32353536313432332C),
 (97,'RHCE.gApr07','chr1','-',25551883,25619874,25561604,25601808,8,0x32353535313838332C32353536313438312C32353536393534342C32353537343432362C32353538343738382C32353538383035332C32353630313637332C32353631393731362C,0x32353535323034362C32353536313633312C32353536393631382C32353537343530362C32353538343932322C32353538383139312C32353630313832342C32353631393837342C),
 (97,'RHCE.aApr07','chr1','-',25556213,25619950,25561604,25619864,10,0x32353535363231332C32353536393534342C32353537343432362C32353538343738382C32353538383035332C32353538393832362C32353539313037312C32353630313637332C32353630373736302C32353631393731362C,0x32353536313633312C32353536393631382C32353537343530362C32353538343932322C32353538383139312C32353538393939332C32353539313231392C32353630313832342C32353630373934372C32353631393935302C),
 (97,'TMEM57.aApr07','chr1','+',25629935,25699287,25630176,25697544,11,0x32353632393933352C32353634353833392C32353634373838352C32353635333333362C32353635353733302C32353635373436382C32353638333139332C32353638343639302C32353638383235302C32353639303438372C32353639373334312C,0x32353633303235362C32353634353938312C32353634383031322C32353635333436302C32353635353930392C32353635373937302C32353638333335322C32353638343837332C32353638383337312C32353639303636322C32353639393238372C),
 (97,'TMEM57.dApr07','chr1','+',25630067,25697809,25630176,25697544,6,0x32353633303036372C32353638333139332C32353638343639302C32353638383235302C32353639303438372C32353639373334312C,0x32353633303235362C32353638333335322C32353638343837332C32353638383337312C32353639303636322C32353639373830392C),
 (97,'TMEM57.bApr07','chr1','+',25630067,25697812,25630176,25697544,9,0x32353633303036372C32353634353833392C32353634373838352C32353635333333362C32353638333139332C32353638343639302C32353638383235302C32353639303438372C32353639373334312C,0x32353633303235362C32353634353938312C32353634383031322C32353635333436302C32353638333335322C32353638343837332C32353638383337312C32353639303636322C32353639373831322C),
 (97,'TMEM57.cApr07','chr1','+',25657305,25690518,25657488,25690435,5,0x32353635373330352C32353638333139332C32353638343639302C32353638383235302C32353639303432332C,0x32353635373937302C32353638333335322C32353638343837332C32353638383337312C32353639303531382C);
INSERT INTO `aceview_hg18_housekeeping` (`bin`,`name`,`chrom`,`strand`,`txStart`,`txEnd`,`cdsStart`,`cdsEnd`,`exonCount`,`exonStarts`,`exonEnds`) VALUES 
 (97,'keyrobo.aApr07','chr1','-',25683814,25743627,0,0,4,0x32353638333831342C32353731333939332C32353733383734312C32353734333432372C,0x32353638333934322C32353731343131362C32353733383833332C32353734333632372C),
 (97,'TMEM57.eApr07','chr1','+',25684848,25697808,25688256,25697544,4,0x32353638343834382C32353638383235302C32353639303533392C32353639373334312C,0x32353638343837332C32353638383337312C32353639303636322C32353639373830382C),
 (97,'MAN1C1.bApr07','chr1','+',25815866,25985285,25816545,25982928,12,0x32353831353836362C32353838353531372C32353934353734352C32353934383333322C32353935323536312C32353935373636392C32353936323935312C32353937303733342C32353937373138322C32353938303031372C32353938313636322C32353938323932312C,0x32353831373431352C32353838353631342C32353934353836312C32353934383431332C32353935323635362C32353935373738372C32353936333034352C32353937303835302C32353937373430322C32353938303139302C32353938313737382C32353938353238352C),
 (97,'MAN1C1.aApr07','chr1','+',25816545,25983532,25816545,25982867,12,0x32353831363534352C32353838353531372C32353934353734352C32353934383333322C32353935323536312C32353935373636392C32353936323935312C32353937303733342C32353937373138322C32353938303031372C32353938313636322C32353938323734302C,0x32353831373431352C32353838353631342C32353934353836312C32353934383431332C32353935323635362C32353935373738372C32353936333034352C32353937303835302C32353937373430322C32353938303139302C32353938313737382C32353938333533322C),
 (97,'MAN1C1.dApr07','chr1','+',25816927,25983525,25885517,25982867,13,0x32353831363932372C32353835333331392C32353838353531372C32353934353734352C32353934383333322C32353935323536312C32353935373636392C32353936323935312C32353937303733342C32353937373138322C32353938303031372C32353938313636322C32353938323734302C,0x32353831373431352C32353835333434342C32353838353631342C32353934353836312C32353934383431332C32353935323635362C32353935373738372C32353936333034352C32353937303835302C32353937373430322C32353938303139302C32353938313737382C32353938333532352C),
 (97,'MAN1C1.cApr07','chr1','+',25908676,25983519,25909012,25982867,11,0x32353930383637362C32353934353734352C32353934383333322C32353935323536312C32353935373636392C32353936323935312C32353937303733342C32353937373138322C32353938303031372C32353938313636322C32353938323734302C,0x32353930393232332C32353934353836312C32353934383431332C32353935323635362C32353935373738372C32353936333034352C32353937303835302C32353937373430322C32353938303139302C32353938313737382C32353938333531392C),
 (97,'C1orf215.aApr07','chr1','-',26083258,26091684,26083583,26083853,2,0x32363038333235382C32363039313539312C,0x32363038343934372C32363039313638342C),
 (98,'CCDC21andSH3BGRL3.aApr07','chr1','+',26433230,26480599,26438861,26476371,15,0x32363433333233302C32363433383833392C32363434333234332C32363435343234382C32363435363637342C32363435373232302C32363435383639342C32363436373536302C32363436383533372C32363437303039312C32363437313039382C32363437343034312C32363437353631322C32363437363231302C32363437393834322C,0x32363433333338382C32363433383931362C32363434333339362C32363435343934332C32363435363830382C32363435373333382C32363435383838302C32363436373731332C32363436383639322C32363437303138352C32363437313134392C32363437343134392C32363437353833382C32363437393238312C32363438303539392C),
 (98,'CCDC21andSH3BGRL3.bApr07','chr1','+',26433280,26480601,26443351,26476371,15,0x32363433333238302C32363433383833392C32363434333234332C32363435363637342C32363435373232302C32363435383639342C32363436373536302C32363436383533372C32363437303039312C32363437313039382C32363437343034312C32363437353631322C32363437363231332C32363437393834322C32363438303133352C,0x32363433333338382C32363433383931362C32363434333339362C32363435363830382C32363435373333382C32363435383838302C32363436373731332C32363436383639322C32363437303138352C32363437313134392C32363437343134392C32363437353833382C32363437393238312C32363438303031302C32363438303630312C),
 (98,'CCDC21andSH3BGRL3.cApr07','chr1','+',26468361,26477888,26470146,26476371,7,0x32363436383336312C32363436383533372C32363437303039312C32363437313039382C32363437343034312C32363437353631322C32363437363231302C,0x32363436383434322C32363436383639322C32363437303138352C32363437313134392C32363437343134392C32363437353833382C32363437373838382C),
 (98,'RPS6KA1.aApr07','chr1','+',26728817,26774106,26728998,26773279,22,0x32363732383831372C32363733363030322C32363734353934342C32363734363236362C32363735303437342C32363735303732312C32363735323436382C32363735333239312C32363735333637332C32363735343232382C32363735343631342C32363735353733312C32363735363037352C32363735373838342C32363735393830332C32363736303132322C32363736303538322C32363737303532362C32363737303932362C32363737313235332C32363737323330312C32363737333135362C,0x32363732393036312C32363733363034372C32363734363036312C32363734363334382C32363735303535352C32363735303830312C32363735323537352C32363735333332392C32363735333831362C32363735343239392C32363735343730332C32363735353739362C32363735363137382C32363735383031352C32363735393932392C32363736303231322C32363736303734312C32363737303638382C32363737313030332C32363737313337312C32363737323433392C32363737343130362C),
 (98,'RPS6KA1.hApr07','chr1','+',26728839,26774101,26728841,26752579,6,0x32363732383833392C32363733363030322C32363735303437342C32363735303732312C32363735323436382C32363737333535362C,0x32363732393036312C32363733363034372C32363735303535352C32363735303830312C32363735333136322C32363737343130312C),
 (98,'RPS6KA1.mApr07','chr1','+',26728841,26746288,26729878,26746287,5,0x32363732383834312C32363732393832322C32363733363030322C32363734353934342C32363734363236362C,0x32363732393036312C32363732393938302C32363733363034372C32363734363036312C32363734363238382C),
 (98,'RPS6KA1.jApr07','chr1','+',26728847,26750581,26728998,26750578,5,0x32363732383834372C32363733363030322C32363734353934342C32363734363236362C32363735303437342C,0x32363732393036312C32363733363034372C32363734363036312C32363734363334382C32363735303538312C),
 (98,'RPS6KA1.dApr07','chr1','+',26728848,26774069,26728998,26754303,12,0x32363732383834382C32363733363030322C32363734353934342C32363734363236362C32363735303437342C32363735303732312C32363735323436382C32363735333239312C32363735333637332C32363735343232382C32363737323331382C32363737333135362C,0x32363732393036312C32363733363034372C32363734363036312C32363734363334382C32363735303535352C32363735303830312C32363735323537352C32363735333332392C32363735333831362C32363735343331382C32363737323433392C32363737343036392C),
 (98,'PIGVandZDHHC18.vcApr07','chr1','+',26987061,27031558,0,0,3,0x32363938373036312C32363938393833362C32373033313532342C,0x32363938373334362C32363938393937312C32373033313535382C),
 (98,'NUDC.fApr07','chr1','+',27099315,27141852,27110220,27141851,7,0x32373039393331352C32373130313335392C32373131303230352C32373132333136362C32373134303533342C32373134303833302C32373134313733372C,0x32373039393437382C32373130313434342C32373131303331332C32373132333234342C32373134303733382C32373134303839362C32373134313835322C),
 (98,'NUDC.cApr07','chr1','+',27120799,27145925,27120926,27145259,9,0x32373132303739392C32373132333136362C32373134303533342C32373134303833302C32373134313733372C32373134313934382C32373134343436372C32373134343634352C32373134353230372C,0x32373132313030372C32373132333234342C32373134303733382C32373134303839362C32373134313835342C32373134323134332C32373134343535312C32373134343736342C32373134353932352C),
 (98,'NUDC.bApr07','chr1','+',27120809,27145331,27120926,27145259,9,0x32373132303830392C32373132333136362C32373134303533342C32373134303833302C32373134313733342C32373134313934382C32373134343436372C32373134343634352C32373134353230372C,0x32373132313030372C32373132333234342C32373134303733382C32373134303839362C32373134313835342C32373134323134332C32373134343535312C32373134343736342C32373134353333312C),
 (98,'NUDC.aApr07','chr1','+',27120819,27145973,27120926,27145259,10,0x32373132303831392C32373132333136362C32373133333332362C32373134303533342C32373134303833302C32373134313733372C32373134313934382C32373134343436372C32373134343634352C32373134353230372C,0x32373132313030372C32373132333234342C32373133333439372C32373134303733382C32373134303839362C32373134313835342C32373134323134332C32373134343535312C32373134343736342C32373134353937332C),
 (98,'NUDC.eApr07','chr1','+',27120834,27145270,27120926,27141878,7,0x32373132303833342C32373132333136362C32373134303533342C32373134303833302C32373134313733372C32373134343436372C32373134343634352C,0x32373132313030372C32373132333234342C32373134303733382C32373134303839362C32373134323134332C32373134343535312C32373134353237302C),
 (98,'NUDC.dApr07','chr1','+',27120853,27145554,27120926,27145259,8,0x32373132303835332C32373134303533342C32373134303833302C32373134313733372C32373134313934382C32373134343436372C32373134343634352C32373134353230372C,0x32373132313030372C32373134303733382C32373134303839362C32373134313835342C32373134323134332C32373134343535312C32373134343736342C32373134353535342C),
 (98,'NUDC.gApr07','chr1','+',27120992,27141974,27120992,27140900,4,0x32373132303939322C32373132333136362C32373134303533342C32373134313934382C,0x32373132313030372C32373132333234342C32373134313835342C32373134313937342C),
 (98,'NUDC.hApr07','chr1','+',27121219,27141840,27123232,27141839,5,0x32373132313231392C32373132333136362C32373134303533342C32373134303833302C32373134313733372C,0x32373132313537302C32373132333234342C32373134303733382C32373134303839362C32373134313834302C),
 (99,'C1orf160.aApr07','chr1','+',27521237,27535478,27521239,27534544,6,0x32373532313233372C32373532393739372C32373533313134372C32373533333033352C32373533333232382C32373533343435362C,0x32373532313436392C32373532393838322C32373533313137392C32373533333133322C32373533333335392C32373533353437382C),
 (99,'C1orf160.mApr07','chr1','+',27521305,27535477,27521335,27531183,5,0x32373532313330352C32373532393739372C32373533313134372C32373533333232382C32373533343435362C,0x32373532313436392C32373532393838322C32373533333133322C32373533333335392C32373533353437372C),
 (99,'C1orf160.eApr07','chr1','+',27521306,27535478,27521308,27533769,7,0x32373532313330362C32373532393739372C32373533313134372C32373533333033352C32373533333232382C32373533333734342C32373533343435362C,0x32373532313436392C32373532393838322C32373533313137392C32373533333133322C32373533333335392C32373533333833322C32373533353437382C),
 (99,'C1orf160.iApr07','chr1','+',27521324,27535477,27531156,27534544,7,0x32373532313332342C32373532393739372C32373533303036322C32373533313134372C32373533333033352C32373533333232382C32373533343435362C,0x32373532313436392C32373532393838322C32373533303231352C32373533313137392C32373533333133322C32373533333335392C32373533353437372C),
 (99,'C1orf160.kApr07','chr1','+',27521330,27531637,27521332,27531555,4,0x32373532313333302C32373532393739372C32373533313134372C32373533313532342C,0x32373532313436392C32373532393838322C32373533313137392C32373533313633372C),
 (99,'C1orf160.hApr07','chr1','+',27521333,27535448,27521334,27533769,6,0x32373532313333332C32373533313134372C32373533333033352C32373533333232382C32373533333734342C32373533343435362C,0x32373532313436392C32373533313137392C32373533333133322C32373533333335392C32373533333833322C32373533353434382C),
 (99,'C1orf160.dApr07','chr1','+',27521339,27534802,27521341,27534544,6,0x32373532313333392C32373532393739372C32373533313134372C32373533333033352C32373533333232382C32373533343435362C,0x32373532313436392C32373532393838322C32373533313137392C32373533333133322C32373533333335302C32373533343830322C),
 (99,'C1orf160.nApr07','chr1','+',27521354,27533071,27521356,27530101,6,0x32373532313335342C32373532393739372C32373533303036322C32373533303331382C32373533313134372C32373533333033352C,0x32373532313436392C32373532393838322C32373533303231352C32373533303437372C32373533313137392C32373533333037312C),
 (99,'C1orf160.gApr07','chr1','+',27521367,27535477,27521374,27533363,5,0x32373532313336372C32373532393739372C32373533313134372C32373533333033352C32373533333232382C,0x32373532313436392C32373532393838322C32373533313137392C32373533333133322C32373533353437372C),
 (99,'C1orf160.fApr07','chr1','+',27521367,27533614,27521411,27533363,3,0x32373532313336372C32373532393739372C32373533333033352C,0x32373532313436392C32373532393838322C32373533333631342C),
 (99,'C1orf160.cApr07','chr1','+',27521378,27534623,27521407,27534544,7,0x32373532313337382C32373532393739372C32373533313134372C32373533323433382C32373533333033352C32373533333232382C32373533343435362C,0x32373532313436392C32373532393838322C32373533313137392C32373533323531332C32373533333133322C32373533333335392C32373533343632332C),
 (99,'C1orf160.lApr07','chr1','+',27521379,27534727,27531156,27533769,8,0x32373532313337392C32373532393739372C32373533303036322C32373533313134372C32373533333033352C32373533333232382C32373533333734342C32373533343435362C,0x32373532313436392C32373532393838322C32373533303231352C32373533313137392C32373533333133322C32373533333335392C32373533333833322C32373533343732372C),
 (99,'C1orf160.bApr07-unspliced','chr1','+',27521383,27525611,27524280,27524874,1,0x32373532313338332C,0x32373532353631312C),
 (99,'WASF2.aApr07','chr1','-',27602880,27689257,27607269,27627987,9,0x32373630323838302C32373630383737322C32373631313635322C32373631333931332C32373631353036352C32373631373335362C32373631383034312C32373632373835372C32373638393038332C,0x32373630373432372C32373630393238372C32373631313830382C32373631343034342C32373631353138332C32373631373531302C32373631383137362C32373632383033302C32373638393235372C),
 (99,'WASF2.cApr07','chr1','-',27627651,27689245,27627798,27627987,2,0x32373632373635312C32373638393038332C,0x32373632383033302C32373638393234352C),
 (99,'AHDC1.aApr07','chr1','-',27733344,27802691,27746401,27751213,6,0x32373733333334342C32373734363335382C32373735313938392C32373735323137312C32373735373830332C32373830323439342C,0x32373733343031342C32373735313238372C32373735323032372C32373735323238332C32373735373938312C32373830323639312C),
 (99,'AHDC1.bApr07','chr1','-',27733400,27802948,27733797,27750832,9,0x32373733333430302C32373734393937322C32373735313133362C32373735313938392C32373735323137312C32373735373430322C32373735373830332C32373830323439342C32373830323832352C,0x32373733333935312C32373735303934382C32373735313238372C32373735323032372C32373735323338382C32373735373632382C32373735373938312C32373830323539322C32373830323934382C),
 (99,'AHDC1.hApr07','chr1','-',27750765,27802734,0,0,7,0x32373735303736352C32373735313133362C32373735313938392C32373735323137312C32373735373430322C32373735373830332C32373830323439342C,0x32373735303934382C32373735313238372C32373735323032372C32373735323238332C32373735373632382C32373735373938312C32373830323733342C),
 (99,'AHDC1.fApr07','chr1','-',27751824,27802512,27752012,27802510,4,0x32373735313832342C32373735323137312C32373735373830332C32373830323439342C,0x32373735323032372C32373735323238332C32373735373938312C32373830323531322C),
 (99,'AHDC1.gApr07','chr1','-',27752238,27802587,27757615,27802585,4,0x32373735323233382C32373735373430322C32373735373830332C32373830323439342C,0x32373735323430322C32373735373632382C32373735373938312C32373830323538372C),
 (99,'PPP1R8.cApr07','chr1','+',28029834,28050771,28029933,28049544,7,0x32383032393833342C32383033313835332C32383033373739362C32383034303131312C32383034323238332C32383034363132352C32383034393139302C,0x32383032393938392C32383033313931342C32383033373935302C32383034303333322C32383034323432382C32383034363139302C32383035303737312C),
 (99,'PPP1R8.aApr07','chr1','+',28029898,28050774,28030270,28050750,8,0x32383032393839382C32383033313835332C32383033373739362C32383034303131312C32383034323238332C32383034363132352C32383034393139302C32383035303633372C,0x32383033303436342C32383033313931342C32383033373935302C32383034303333322C32383034323432382C32383034363139302C32383034393531322C32383035303737342C),
 (99,'PPP1R8.bApr07','chr1','+',28029912,28050774,28030270,28049544,7,0x32383032393931322C32383033313835332C32383033373739362C32383034303131312C32383034323238332C32383034363132352C32383034393139302C,0x32383033303334342C32383033313931342C32383033373935302C32383034303333322C32383034323432382C32383034363139302C32383035303737342C),
 (99,'PPP1R8.gApr07','chr1','+',28029923,28050626,28030270,28042339,6,0x32383032393932332C32383033313835332C32383033373739362C32383034323238332C32383034363132352C32383034393139302C,0x32383033303436342C32383033313931342C32383033373935302C32383034323432382C32383034363139302C32383035303632362C),
 (99,'EYA3.aApr07','chr1','-',28169438,28287794,28173563,28257124,18,0x32383136393433382C32383137373437312C32383138373633322C32383138383739342C32383139323439372C32383139363431372C32383139393035372C32383230333433332C32383231303034342C32383231323230382C32383231363235312C32383232363838362C32383233343634312C32383233373933362C32383234313636382C32383234373438302C32383235373039312C32383238373632312C,0x32383137333634342C32383137373537322C32383138373735342C32383138383930392C32383139323635382C32383139363437362C32383139393134372C32383230333531372C32383231303138342C32383231323339322C32383231363333372C32383232373032342C32383233343737382C32383233383030332C32383234313734382C32383234373532342C32383235373139322C32383238373739342C),
 (100,'ATPIF1.cApr07','chr1','+',28435240,28445997,28435242,28445735,3,0x32383433353234302C32383433353435382C32383434353638362C,0x32383433353336382C32383433353535302C32383434353939372C),
 (100,'dawbey.aApr07','chr1','-',28438843,28445728,28439362,28445728,2,0x32383433383834332C32383434353637332C,0x32383433393732372C32383434353732382C),
 (100,'PHACTR4.jApr07','chr1','+',28568651,28664847,28606545,28664847,6,0x32383536383635312C32383539313933392C32383630363530372C32383635383138322C32383635393330392C32383636343738322C,0x32383536383932332C32383539323033392C32383630363536312C32383635383335362C32383635393339302C32383636343834372C),
 (100,'PHACTR4.sApr07','chr1','+',28568683,28658337,0,0,5,0x32383536383638332C32383630363530372C32383633323032382C32383635363932392C32383635383138322C,0x32383536383932332C32383630363536312C32383633323134342C32383635363935372C32383635383333372C),
 (100,'PHACTR4.aApr07','chr1','+',28568683,28698172,28606545,28695648,14,0x32383536383638332C32383630363530372C32383635383138322C32383635393330392C32383636343738322C32383636353437392C32383637323635322C32383637353230352C32383637393534392C32383638383236382C32383639303034392C32383639303734382C32383639323131332C32383639353633322C,0x32383536383932332C32383630363536312C32383635383335362C32383635393339302C32383636343934372C32383636353836362C32383637333235302C32383637353339302C32383637393730332C32383638383332342C32383639303131312C32383639303838362C32383639323139302C32383639383137322C),
 (100,'PHACTR4.rApr07','chr1','+',28568694,28606924,0,0,2,0x32383536383639342C32383630363530372C,0x32383536383932332C32383630363932342C),
 (100,'PHACTR4.bApr07','chr1','+',28568716,28696929,28658214,28695648,15,0x32383536383731362C32383630363530372C32383633323032382C32383635383138322C32383635393330392C32383636343738322C32383636353437392C32383637323635322C32383637353230352C32383637393534392C32383638383236382C32383639303034392C32383639303734382C32383639323131332C32383639353633322C,0x32383536383932332C32383630363536312C32383633323134342C32383635383335362C32383635393339302C32383636343934372C32383636353836362C32383637333235302C32383637353339302C32383637393730332C32383638383332342C32383639303131312C32383639303838362C32383639323139302C32383639363932392C),
 (100,'PHACTR4.lApr07','chr1','+',28568745,28659349,28591976,28659315,6,0x32383536383734352C32383539313933392C32383630363530372C32383635363932392C32383635383138322C32383635393330392C,0x32383536383932332C32383539323033392C32383630363536312C32383635363935332C32383635383335362C32383635393334392C),
 (100,'PHACTR4.nApr07','chr1','+',28568746,28664840,28568890,28658330,6,0x32383536383734362C32383630363530372C32383634363531342C32383635383138322C32383635393330392C32383636343738322C,0x32383536383932332C32383630363536312C32383634363538382C32383635383335362C32383635393339302C32383636343834302C),
 (100,'PHACTR4.fApr07','chr1','+',28568809,28665600,28658214,28665598,7,0x32383536383830392C32383630363530372C32383635363932392C32383635383138322C32383635393330392C32383636343738322C32383636353437392C,0x32383536383932332C32383630363536312C32383635363935372C32383635383335362C32383635393339302C32383636343934372C32383636353630302C),
 (100,'PHACTR4.iApr07','chr1','+',28568820,28665500,28658214,28665499,5,0x32383536383832302C32383635383138322C32383635393330392C32383636343738322C32383636353437392C,0x32383536383932332C32383635383335362C32383635393339302C32383636343934372C32383636353530302C),
 (100,'PHACTR4.hApr07','chr1','+',28568822,28665541,28658214,28665541,8,0x32383536383832322C32383630363530372C32383633323032382C32383635363932392C32383635383138322C32383635393330392C32383636343738322C32383636353437392C,0x32383536383932332C32383630363536312C32383633323134342C32383635363935332C32383635383335362C32383635393339302C32383636343934372C32383636353534312C),
 (100,'PHACTR4.kApr07','chr1','+',28568837,28664894,28658214,28664892,5,0x32383536383833372C32383633323032382C32383635383138322C32383635393330392C32383636343738322C,0x32383536383932332C32383633323134342C32383635383335362C32383635393339302C32383636343839342C),
 (100,'PHACTR4.cApr07','chr1','+',28568837,28696628,28606545,28696221,8,0x32383536383833372C32383630363530372C32383635363932392C32383635383138322C32383635393330392C32383636343738322C32383636353437392C32383639363035352C,0x32383536383932332C32383630363536312C32383635363935332C32383635383335362C32383635393339302C32383636343934372C32383636353636382C32383639363632382C),
 (100,'PHACTR4.uApr07','chr1','+',28568857,28658238,0,0,6,0x32383536383835372C32383537373735392C32383539313933392C32383630363530372C32383635363932392C32383635383138322C,0x32383536383932332C32383537373932382C32383539323033392C32383630363536312C32383635363935332C32383635383233382C),
 (100,'larobo.aApr07','chr1','-',28695599,28717438,28695628,28717437,3,0x32383639353539392C32383731353637312C32383731373331312C,0x32383639353832302C32383731353734392C32383731373433382C),
 (100,'TAF12.aApr07','chr1','-',28788226,28842184,28788848,28823116,8,0x32383738383232362C32383738393337352C32383830343437302C32383831323334352C32383831373035312C32383832313031322C32383832333034342C32383834323039302C,0x32383738383837332C32383738393438352C32383830343535392C32383831323436302C32383831373132392C32383832313236342C32383832333132392C32383834323138342C),
 (100,'TAF12.dApr07','chr1','-',28802188,28842204,28802637,28821180,6,0x32383830323138382C32383830343437302C32383831323334352C32383831373035312C32383832313031322C32383834323039302C,0x32383830323637332C32383830343535392C32383831323436302C32383831373132392C32383832313236342C32383834323230342C),
 (100,'TAF12.cApr07','chr1','-',28802514,28847353,28802637,28847351,6,0x32383830323531342C32383830343437302C32383831323334352C32383831373035312C32383832313031322C32383834373330332C,0x32383830323637332C32383830343535392C32383831323436302C32383831373132392C32383832313236342C32383834373335332C),
 (100,'TAF12.eApr07','chr1','-',28804504,28842146,28804506,28821180,5,0x32383830343530342C32383831323334352C32383831373035312C32383832313031322C32383834313735332C,0x32383830343535392C32383831323436302C32383831373132392C32383832313236342C32383834323134362C),
 (100,'TAF12.iApr07','chr1','-',28817117,28842180,0,0,3,0x32383831373131372C32383832313031322C32383834323039302C,0x32383831373132392C32383832313236342C32383834323138302C),
 (100,'YTHDF2.bApr07','chr1','+',28935723,28968874,28936219,28968051,5,0x32383933353732332C32383933363735362C32383933373335372C32383934313530312C32383936383032372C,0x32383933363234362C32383933363738312C32383933373433372C32383934333038352C32383936383837342C),
 (100,'YTHDF2.gApr07','chr1','+',28935958,28968345,28936219,28968051,4,0x32383933353935382C32383933363735362C32383933373335372C32383936383032372C,0x32383933363234362C32383933363738312C32383933373433372C32383936383334352C),
 (100,'YTHDF2.aApr07','chr1','+',28935986,28968874,28936690,28968051,4,0x32383933353938362C32383933373335372C32383934313530312C32383936383032372C,0x32383933363738312C32383933373433372C32383934333038352C32383936383837342C),
 (100,'YTHDF2.cApr07','chr1','+',28936059,28968828,28936219,28968051,5,0x32383933363035392C32383933363735362C32383933373335372C32383934313530312C32383936383032372C,0x32383933363234362C32383933363738312C32383933373432382C32383934333038352C32383936383832382C),
 (100,'YTHDF2.jApr07','chr1','+',28964323,28968663,0,0,2,0x32383936343332332C32383936383032372C,0x32383936343339392C32383936383636332C),
 (100,'EPB41.dApr07','chr1','+',29086189,29319138,29186692,29314896,18,0x32393038363138392C32393138363534362C32393139323432382C32393139363331332C32393231303936332C32393231343739302C32393231373332322C32393232393439382C32393233323139312C32393233343932342C32393233383335322C32393235323230322C32393236343038302C32393239363930352C32393330383433342C32393331313436362C32393331343739372C32393331353931372C,0x32393038363330392C32393138373030342C32393139323634312C32393139363431382C32393231313030362C32393231343836362C32393231373534312C32393232393538362C32393233323334342C32393233353032322C32393233383532352C32393235323431312C32393236343235372C32393239373033342C32393330383533362C32393331313534372C32393331343930322C32393331393133382C),
 (100,'EPB41.kApr07','chr1','+',29086202,29186970,29186536,29186968,3,0x32393038363230322C32393039323837372C32393138363532392C,0x32393038363330392C32393039323933362C32393138363937302C),
 (100,'EPB41.cApr07','chr1','+',29086202,29316211,29086202,29314896,17,0x32393038363230322C32393138363532392C32393139323432382C32393231303936332C32393231343739302C32393231373332322C32393232393439382C32393233323139312C32393233343932342C32393233383335322C32393235323230322C32393236343038302C32393239363930352C32393330383433342C32393331313436362C32393331343739372C32393331353931372C,0x32393038363330392C32393138373030342C32393139323634312C32393231313030362C32393231343836362C32393231373534312C32393232393538362C32393233323334342C32393233353032322C32393233383532352C32393235323431312C32393236343235372C32393239373033342C32393330383533362C32393331313534372C32393331343930322C32393331363231312C),
 (100,'EPB41.aApr07','chr1','+',29113673,29314896,29186536,29314896,20,0x32393131333637332C32393138363532392C32393139323432382C32393139363331332C32393231303936332C32393231343739302C32393231373332322C32393232393439382C32393233323139312C32393233343932342C32393233383335322C32393235323230322C32393235373638372C32393235373930392C32393235393532302C32393236343038302C32393239363930352C32393330383433342C32393331313436362C32393331343739372C,0x32393131333836372C32393138373030342C32393139323634312C32393139363431382C32393231313030362C32393231343836362C32393231373534312C32393232393538362C32393233323334342C32393233353032322C32393233383532352C32393235323431312C32393235373734342C32393235373935312C32393235393538332C32393236343235372C32393239373033342C32393330383533362C32393331313534372C32393331343839362C),
 (100,'EPB41.bApr07','chr1','+',29113736,29320362,29186536,29314896,19,0x32393131333733362C32393138363532392C32393139323432382C32393139363331332C32393231303936332C32393231343739302C32393231373332322C32393232393439382C32393233323139312C32393233343932342C32393233383335322C32393235323230322C32393235393532302C32393236343038302C32393239363930352C32393330383433342C32393331313436362C32393331343739372C32393331353931372C,0x32393131333836372C32393138373030342C32393139323634312C32393139363431382C32393231313030362C32393231343836362C32393231373534312C32393232393538362C32393233323334342C32393233353032322C32393233383532352C32393235323431312C32393235393538332C32393236343235372C32393239373033342C32393330383533362C32393331313534372C32393331343930322C32393332303336322C),
 (100,'EPB41.eApr07','chr1','+',29186529,29316211,29186985,29314896,20,0x32393138363532392C32393138383435342C32393139323432382C32393139363331332C32393231303936332C32393231343739302C32393231373332322C32393232393439382C32393233323139312C32393233343932342C32393233383335322C32393235323230322C32393235373638372C32393235393532302C32393236343038302C32393239363930352C32393330383433342C32393331313436362C32393331343739372C32393331353931372C,0x32393138373030342C32393138383533342C32393139323634312C32393139363431382C32393231313030362C32393231343836362C32393231373534312C32393232393538362C32393233323334342C32393233353032322C32393233383532352C32393235323431312C32393235373734342C32393235393538332C32393236343235372C32393239373033342C32393330383533362C32393331313534372C32393331343930322C32393331363231312C),
 (100,'EPB41.fApr07','chr1','+',29186543,29316211,29186985,29314896,18,0x32393138363534332C32393138383435342C32393139323432382C32393139363331332C32393231303936332C32393231343739302C32393231373332322C32393232393439382C32393233323139312C32393233343932342C32393233383335322C32393235323230322C32393235393532302C32393236343038302C32393239363930352C32393331313436362C32393331343739372C32393331353931372C,0x32393138373030342C32393138383533342C32393139323634312C32393139363431382C32393231313030362C32393231343836362C32393231373534312C32393232393538362C32393233323334342C32393233353032322C32393233383532352C32393235323431312C32393235393538332C32393236343235372C32393239373033342C32393331313534372C32393331343930322C32393331363231312C),
 (100,'EPB41.gApr07','chr1','+',29186802,29316493,29186803,29314896,15,0x32393138363830322C32393231303936332C32393231343739302C32393231373332322C32393232393439382C32393233323139312C32393233343932342C32393233383335322C32393235323230322C32393236343038302C32393239363930352C32393330383433342C32393331313436362C32393331343739372C32393331353931372C,0x32393138373030342C32393231313030362C32393231343836362C32393231373534312C32393232393538362C32393233323334342C32393233353032322C32393233383532352C32393235323431312C32393236343235372C32393239373033342C32393330383533362C32393331313534372C32393331343930322C32393331363439332C),
 (100,'EPB41.hApr07','chr1','+',29217486,29297003,29217488,29297001,9,0x32393231373438362C32393232393439382C32393233323139312C32393233343932342C32393233383335322C32393235323230352C32393236343038302C32393239353235332C32393239363930352C,0x32393231373534312C32393232393538362C32393233323334342C32393233353032322C32393233383532352C32393235323431312C32393236343235372C32393239353730332C32393239373030332C),
 (101,'PTPRU.aApr07','chr1','+',29435612,29525768,29435614,29524760,31,0x32393433353631322C32393435343337332C32393435373630332C32393435383335392C32393435383534372C32393435383936382C32393435393730382C32393437343534362C32393437383131302C32393437383535342C32393437393133372C32393438313737342C32393438333033382C32393438333832392C32393439303936372C32393530323935332C32393530333837322C32393530343435302C32393530363232372C32393530393834322C32393531303535342C32393531303734312C32393531313635302C32393531343437302C32393531353130302C32393531363834362C32393531393738332C32393532323436392C32393532323733352C32393532343238392C32393532343639372C,0x32393433353831362C32393435343530352C32393435373837352C32393435383434312C32393435383636332C32393435393134332C32393436303030322C32393437343835352C32393437383232302C32393437383735362C32393437393234302C32393438323034382C32393438333037352C32393438333936382C32393439313132352C32393530333134342C32393530333934382C32393530343532372C32393530363234352C32393530393837392C32393531303635322C32393531303835382C32393531313830352C32393531343630362C32393531353235302C32393531373032302C32393531393932342C32393532323539352C32393532323838372C32393532343432352C32393532353736382C),
 (101,'PTPRU.bApr07','chr1','+',29435619,29525905,29435620,29524760,30,0x32393433353631392C32393435343337332C32393435373630332C32393435383335392C32393435383534372C32393435383936382C32393435393730382C32393437343534362C32393437383131302C32393437383535342C32393437393133372C32393438313737342C32393438333033382C32393438333832392C32393439303936372C32393530323935332C32393530333837322C32393530343435302C32393530393834322C32393531303535342C32393531303734312C32393531313635302C32393531343437302C32393531353130302C32393531363834362C32393531393738332C32393532323436392C32393532323732392C32393532343238392C32393532343639372C,0x32393433353831362C32393435343530352C32393435373837352C32393435383434312C32393435383636332C32393435393134332C32393436303030322C32393437343835352C32393437383232302C32393437383735362C32393437393234302C32393438323034382C32393438333037352C32393438333936382C32393439313132352C32393530333134342C32393530333934382C32393530343532372C32393530393837392C32393531303635322C32393531303835382C32393531313830352C32393531343630362C32393531353235302C32393531373032302C32393531393932342C32393532323539352C32393532323838372C32393532343432352C32393532353930352C),
 (101,'PTPRU.cApr07','chr1','+',29478649,29522752,29478650,29522751,19,0x32393437383634392C32393437393133372C32393438313737342C32393438333033382C32393438333832392C32393438383738312C32393439303936372C32393530323935332C32393530333837322C32393530343435302C32393530393834322C32393531303535342C32393531303734312C32393531313635302C32393531343437302C32393531353130302C32393531363834362C32393531393738332C32393532323436392C,0x32393437383735362C32393437393234302C32393438323034382C32393438333037352C32393438333936382C32393438383831312C32393439313132352C32393530333134342C32393530333934382C32393530343532372C32393530393837392C32393531303634332C32393531303835382C32393531313830352C32393531343630362C32393531353235302C32393531373032302C32393531393932342C32393532323735322C),
 (101,'PTPRU.dApr07','chr1','+',29482036,29510582,29482036,29510580,11,0x32393438323033362C32393438333033382C32393438333832392C32393438383738312C32393439303936372C32393530323935332C32393530333837322C32393530343435302C32393530363232372C32393530393834322C32393531303535342C,0x32393438323034382C32393438333037352C32393438333936382C32393438383831312C32393439313132352C32393530333134342C32393530333934382C32393530343532372C32393530363234352C32393530393837392C32393531303538322C),
 (101,'PTPRU.gApr07','chr1','+',29482819,29503139,29483882,29503138,4,0x32393438323831392C32393438333832392C32393439303936372C32393530323935332C,0x32393438333037352C32393438333936382C32393439313132352C32393530333133392C),
 (101,'nosuyo.aApr07','chr1','+',29829971,29925637,29829971,29925459,3,0x32393832393937312C32393932343535322C32393932353330332C,0x32393833303039362C32393932343631392C32393932353633372C),
 (101,'deeda.aApr07','chr1','-',30259386,30283046,0,0,7,0x33303235393338362C33303236303637372C33303236323135332C33303237303435382C33303237343732332C33303238323230352C33303238323933312C,0x33303235393934332C33303236303732392C33303236323335352C33303237303631372C33303237343932342C33303238323433372C33303238333034362C),
 (101,'deeda.bApr07','chr1','-',30270476,30302907,0,0,4,0x33303237303437362C33303237343732332C33303239383435332C33303330323735382C,0x33303237303631372C33303237343932342C33303239383535342C33303330323930372C),
 (102,'PUM1.dApr07','chr1','-',31176937,31311151,31178644,31305000,22,0x33313137363933372C33313138323037362C33313138363538342C33313138373433312C33313139303737392C33313139353536362C33313139373636372C33313139393134372C33313231303130372C33313231313431352C33313231323630302C33313231333738372C33313232303038342C33313232353439352C33313232363734352C33313233373832332C33313234303438372C33313235313238362C33313235323432372C33313237343232392C33313330343633372C33313331313034392C,0x33313137383737362C33313138323236392C33313138363730362C33313138373535372C33313139303931372C33313139353639352C33313139373739372C33313139393431352C33313231303334342C33313231313731322C33313231323734342C33313231333932362C33313232303233362C33313232353539372C33313232363833392C33313233383039342C33313234303635342C33313235313436352C33313235323533362C33313237343239382C33313330353031312C33313331313135312C),
 (102,'PUM1.cApr07','chr1','-',31176939,31311157,31178644,31305000,22,0x33313137363933392C33313138323037362C33313138363538342C33313138373433312C33313139303737392C33313139353536302C33313139373636372C33313139393134372C33313231303130372C33313231313431352C33313231323630302C33313231333738372C33313232303038342C33313232353439352C33313232363734352C33313233373832332C33313234303438372C33313235313238362C33313235323432372C33313237343232392C33313330343633372C33313331313034392C,0x33313137383737362C33313138323236392C33313138363730362C33313138373535372C33313139303931372C33313139353639352C33313139373739372C33313139393431352C33313231303334342C33313231313731322C33313231323734342C33313231333932362C33313232303233362C33313232353539372C33313232363833392C33313233383039342C33313234303635342C33313235313436352C33313235323533362C33313237343239382C33313330353031312C33313331313135372C),
 (102,'PUM1.bApr07','chr1','-',31178186,31311150,31178644,31305000,22,0x33313137383138362C33313138323037362C33313138363538342C33313138373433312C33313139303737392C33313139353536302C33313139373636372C33313139393134372C33313231303130372C33313231313431352C33313231323630302C33313231333738372C33313232303038342C33313232353439352C33313232363734352C33313233373832332C33313234303438372C33313235313238362C33313235323432372C33313237343232392C33313330343633372C33313331313034392C,0x33313137383737362C33313138323236392C33313138363730362C33313138373535372C33313139303931372C33313139353639352C33313139373739372C33313139393431352C33313231303334342C33313231313731322C33313231323734342C33313231333932362C33313232303233362C33313232353631322C33313232363833392C33313233383039342C33313234303635342C33313235313436352C33313235323533332C33313237343239382C33313330353031312C33313331313135302C),
 (102,'PUM1.jApr07','chr1','-',31178277,31311157,31211631,31274289,13,0x33313137383237372C33313231313630312C33313231323533322C33313231333738372C33313232303038342C33313232353439352C33313232363734352C33313235313238362C33313235323432372C33313237343232392C33313330303734362C33313330343633372C33313331313034392C,0x33313137383735342C33313231313731322C33313231323734342C33313231333932362C33313232303233362C33313232353539372C33313232363833392C33313235313436352C33313235323533362C33313237343239382C33313330303831342C33313330353031312C33313331313135372C),
 (102,'PUM1.eApr07','chr1','-',31178277,31311118,31178644,31305000,22,0x33313137383237372C33313138323037362C33313138363538342C33313138373433312C33313139303737392C33313139353536302C33313139373636372C33313139393134372C33313231303130372C33313231313431352C33313231323630302C33313231333738372C33313232303038342C33313232353439352C33313232363734352C33313233373832332C33313234303438372C33313235313238362C33313235323432372C33313237343232392C33313330343633372C33313331313034392C,0x33313137383737362C33313138323236392C33313138363730362C33313138373535372C33313139303931372C33313139353639352C33313139373739372C33313139393431352C33313231303334342C33313231313633312C33313231323734342C33313231333932362C33313232303233362C33313232353630302C33313232363833392C33313233383039342C33313234303635342C33313235313436352C33313235323533362C33313237343239382C33313330353031312C33313331313131382C),
 (102,'PUM1.aApr07','chr1','-',31178283,31311358,31178644,31311219,22,0x33313137383238332C33313138323037362C33313138363538342C33313138373433312C33313139303737392C33313139353536302C33313139373636372C33313139393134372C33313231303130372C33313231313431352C33313231323630302C33313231333738372C33313232303038342C33313232353439352C33313232363734352C33313233373832332C33313234303438372C33313235313238362C33313235323432372C33313237343232392C33313330343633372C33313331313132322C,0x33313137383737362C33313138323236392C33313138363730362C33313138373535372C33313139303931372C33313139353639352C33313139373739372C33313139393431352C33313231303334342C33313231313731322C33313231323734342C33313231333932362C33313232303233362C33313232353539372C33313232363833392C33313233383039342C33313234303635342C33313235313436352C33313235323533362C33313237343239382C33313330353031312C33313331313335382C),
 (102,'PUM1.gApr07','chr1','-',31178293,31311241,31178644,31311219,10,0x33313137383239332C33313231323635382C33313231333738372C33313232303038342C33313232363734352C33313233373832332C33313234303438372C33313237343232392C33313330343633372C33313331313132322C,0x33313137383735342C33313231323734342C33313231333932362C33313232303233362C33313232363833392C33313233383039342C33313234303635342C33313237343239382C33313330353031312C33313331313234312C),
 (102,'PUM1.hApr07','chr1','-',31178300,31311128,31178644,31304735,12,0x33313137383330302C33313138323037362C33313138363538342C33313138373433312C33313139303737392C33313233373837342C33313234303438372C33313235313238362C33313235323432372C33313237343232392C33313330343733322C33313331313034392C,0x33313137383737362C33313138323236392C33313138363730362C33313138373535372C33313139303930302C33313233383039342C33313234303635342C33313235313436352C33313235323533362C33313237343239382C33313330353031312C33313331313132382C),
 (102,'PUM1.iApr07','chr1','-',31178303,31311131,31178644,31305000,9,0x33313137383330332C33313138323037362C33313138363538342C33313138373433312C33313233373832392C33313234303438372C33313237343232392C33313330343633372C33313331313034392C,0x33313137383737362C33313138323236392C33313138363730362C33313138373535342C33313233383039342C33313234303635342C33313237343239382C33313330353031312C33313331313133312C),
 (102,'PUM1.fApr07','chr1','-',31178310,31251372,31178644,31251370,17,0x33313137383331302C33313138323037362C33313138363538342C33313138373433312C33313139303737392C33313139353536362C33313139373636372C33313139393134372C33313231313431352C33313231323630302C33313231333738372C33313232303038342C33313232353439352C33313232363734352C33313233373832332C33313234303438372C33313235313238362C,0x33313137383737362C33313138323236392C33313138363730362C33313138373535372C33313139303931372C33313139353639352C33313139373739372C33313139393431352C33313231313731322C33313231323734342C33313231333932362C33313232303233362C33313232353630302C33313232363833392C33313233383039342C33313234303635342C33313235313337322C),
 (102,'PUM1.lApr07','chr1','-',31178465,31211815,31178644,31199179,9,0x33313137383436352C33313138323037362C33313138363538342C33313139303737392C33313139353536302C33313139373636372C33313139393134372C33313231303130372C33313231313431352C,0x33313137383737362C33313138323236392C33313138363730362C33313139303931372C33313139353639352C33313139373739372C33313139393235322C33313231303334342C33313231313831352C),
 (103,'ZCCHC17.cApr07','chr1','+',31542429,31610393,31555532,31609627,8,0x33313534323432392C33313535353437372C33313536343534322C33313538323630382C33313538343339302C33313539323037332C33313539343236322C33313630393436352C,0x33313534323530392C33313535353539382C33313536343630302C33313538323730392C33313538343438322C33313539323137342C33313539343430382C33313631303339332C),
 (103,'ZCCHC17.eApr07','chr1','+',31542431,31610337,31563628,31609627,9,0x33313534323433312C33313535353437372C33313536333630302C33313536343534322C33313538323630382C33313538343339302C33313539323037332C33313539343236322C33313630393436352C,0x33313534323530392C33313535353539382C33313536333637302C33313536343630302C33313538323730392C33313538343438322C33313539323137342C33313539343430382C33313631303333372C),
 (103,'ZCCHC17.gApr07','chr1','+',31542440,31594473,31564548,31594456,6,0x33313534323434302C33313536343534322C33313538323630382C33313538343339302C33313539323037332C33313539343236322C,0x33313534323530392C33313536343630302C33313538323730392C33313538343438322C33313539323137342C33313539343437332C),
 (103,'ZCCHC17.fApr07','chr1','+',31542441,31609602,31555532,31609600,8,0x33313534323434312C33313535353437372C33313536343534322C33313538323630382C33313538343339302C33313539323037332C33313539343236322C33313630393436352C,0x33313534323634372C33313535353539382C33313536343630302C33313538323730392C33313538343438322C33313539323137342C33313539343430382C33313630393630322C),
 (103,'ZCCHC17.lApr07','chr1','+',31542465,31594335,31564561,31594333,7,0x33313534323436352C33313535353437372C33313536333630302C33313536343534322C33313538343339302C33313539323037332C33313539343236322C,0x33313534323530392C33313535353539382C33313536333637302C33313536343630302C33313538343438322C33313539323137342C33313539343333352C),
 (103,'ZCCHC17.hApr07','chr1','+',31542465,31609860,31555532,31609655,6,0x33313534323436352C33313535353437372C33313536343534322C33313538323630382C33313538343339302C33313630393436352C,0x33313534323530392C33313535353539382C33313536343630302C33313538323730392C33313538343438322C33313630393836302C),
 (103,'ZCCHC17.iApr07','chr1','+',31542466,31610367,31563628,31609655,7,0x33313534323436362C33313535353437372C33313536333630302C33313536343534322C33313538323630382C33313538343339302C33313630393436352C,0x33313534323530392C33313535353539382C33313536333637302C33313536343630302C33313538323730392C33313538343438322C33313631303336372C),
 (103,'ZCCHC17.aApr07','chr1','+',31542474,31611480,31550128,31609488,10,0x33313534323437342C33313535303035302C33313535353437372C33313536343534322C33313538323630382C33313538343339302C33313539323037332C33313539343236322C33313630333339382C33313630393436352C,0x33313534323530392C33313535303137322C33313535353539382C33313536343630302C33313538323730392C33313538343438322C33313539323137342C33313539343430382C33313630333535382C33313631313438302C),
 (103,'ZCCHC17.jApr07','chr1','+',31542475,31609565,31564561,31609564,7,0x33313534323437352C33313535353437372C33313536343534322C33313538343339302C33313539323037332C33313539343236322C33313630393436352C,0x33313534323530392C33313535353539382C33313536343630302C33313538343438322C33313539323137342C33313539343430382C33313630393536352C),
 (103,'ZCCHC17.kApr07','chr1','+',31542478,31609895,31555532,31609488,7,0x33313534323437382C33313535353437372C33313536343534322C33313538323630382C33313538343339302C33313539323037332C33313630393436352C,0x33313534323530392C33313535353539382C33313536343630302C33313538323730392C33313538343438322C33313539323137342C33313630393839352C),
 (103,'ZCCHC17.bApr07','chr1','+',31542567,31610367,31542569,31609627,7,0x33313534323536372C33313536343534322C33313538323630382C33313538343339302C33313539323037332C33313539343236322C33313630393436352C,0x33313534323634372C33313536343630302C33313538323730392C33313538343438322C33313539323137342C33313539343430382C33313631303336372C),
 (103,'ZCCHC17.dApr07','chr1','+',31563598,31609599,31563598,31609597,7,0x33313536333539382C33313536343534322C33313538323630382C33313538343339302C33313539323037332C33313539343236322C33313630393436352C,0x33313536333637302C33313536343630302C33313538323730392C33313538343438322C33313539323137342C33313539343430382C33313630393539392C),
 (103,'foyda.aApr07','chr1','-',31578500,31592233,0,0,3,0x33313537383530302C33313538323533352C33313539323031312C,0x33313537383631362C33313538323633362C33313539323233332C),
 (103,'florkoybo.aApr07','chr1','+',31716564,31727592,0,0,3,0x33313731363536342C33313732333636362C33313732373531332C,0x33313731363636382C33313732333832332C33313732373539322C),
 (103,'tunira.aApr07-unspliced','chr1','-',31717877,31720494,31719964,31720153,1,0x33313731373837372C,0x33313732303439342C),
 (103,'BAI2.aApr07','chr1','-',31965304,32002234,31965607,31995409,33,0x33313936353330342C33313936363231322C33313936363336392C33313936363738352C33313936383938372C33313937303330322C33313937303730342C33313937313135392C33313937333337302C33313937333736372C33313937343031342C33313937343530382C33313937343736302C33313937353631362C33313937353833392C33313937363338372C33313937363737342C33313937373031392C33313937373439352C33313937383131332C33313937383239372C33313937383533342C33313937393536302C33313937393831312C33313937393938372C33313938303234302C33313938313032352C33313938323338302C33313938323833352C33313939343138362C33313939353338382C33313939353536392C33323030323037312C,0x33313936353739332C33313936363236392C33313936363436382C33313936363832312C33313936393630372C33313937303334322C33313937303830302C33313937313333312C33313937333436392C33313937333835332C33313937343038312C33313937343537382C33313937343931312C33313937353731392C33313937353934332C33313937363531342C33313937363831382C33313937373132352C33313937373832332C33313937383232322C33313937383336362C33313937383732392C33313937393636372C33313937393931332C33313938303135352C33313938303430352C33313938313139302C33313938323534352C33313938323931392C33313939353030332C33313939353436392C33313939353639392C33323030323233342C),
 (103,'BAI2.bApr07','chr1','-',31965305,32002223,31965607,31995409,33,0x33313936353330352C33313936363231322C33313936363336392C33313936363738352C33313936383938372C33313937303330322C33313937303730342C33313937313135392C33313937333337302C33313937333736372C33313937343031342C33313937343530382C33313937343736302C33313937353631362C33313937353833392C33313937363338372C33313937363737342C33313937373031392C33313937373439352C33313937383131332C33313937383239372C33313937383533342C33313937393536302C33313937393831312C33313937393938372C33313938303234302C33313938313032352C33313938323338302C33313938323833352C33313939343138362C33313939353338382C33313939353536392C33323030323037312C,0x33313936353739332C33313936363236392C33313936363436352C33313936363832312C33313936393630372C33313937303334322C33313937303830302C33313937313333312C33313937333436392C33313937333835332C33313937343038312C33313937343537382C33313937343931312C33313937353731392C33313937353934332C33313937363531342C33313937363831382C33313937373132352C33313937373832332C33313937383232322C33313937383336362C33313937383732392C33313937393636372C33313937393931332C33313938303135352C33313938303430352C33313938313139302C33313938323534352C33313938323931392C33313939353030332C33313939353436392C33313939353639392C33323030323232332C),
 (103,'BAI2.qApr07','chr1','-',31965306,31999213,0,0,6,0x33313936353330362C33313936363231322C33313936363336392C33313939353430342C33313939353536392C33313939383837302C,0x33313936353739332C33313936363236392C33313936363338332C33313939353436392C33313939353639392C33313939393231332C),
 (103,'BAI2.gApr07','chr1','-',31979815,31994456,31979815,31994385,6,0x33313937393831352C33313937393938372C33313938303234302C33313938323338302C33313938323833352C33313939343138362C,0x33313937393931332C33313938303135352C33313938303430352C33313938323534352C33313938323931392C33313939343435362C),
 (103,'BAI2.nApr07','chr1','-',31980295,31981860,31980295,31981773,3,0x33313938303239352C33313938313032352C33313938313634362C,0x33313938303430352C33313938313139302C33313938313836302C),
 (103,'BAI2.fApr07','chr1','-',31980316,32002250,31980316,31994988,5,0x33313938303331362C33313938313032352C33313938323833352C33313939343138362C33323030323037312C,0x33313938303430352C33313938313139302C33313938323931392C33313939353030332C33323030323235302C),
 (103,'KPNA6.kApr07','chr1','+',32346214,32395381,32346318,32395184,3,0x33323334363231342C33323339323737352C33323339353034302C,0x33323334363332322C33323339323930392C33323339353338312C),
 (103,'KPNA6.aApr07','chr1','+',32346225,32414756,32346318,32409082,14,0x33323334363232352C33323339323737352C33323339353034302C33323339353533332C33323339363435342C33323339373538372C33323339383830322C33323430303133342C33323430303534382C33323430313432322C33323430343239322C33323430353335362C33323430383036392C33323430383839342C,0x33323334363332322C33323339323930392C33323339353133332C33323339353633332C33323339363534392C33323339373731392C33323339383839312C33323430303233342C33323430303731322C33323430313530312C33323430343431382C33323430353438342C33323430383234382C33323431343735362C),
 (103,'KPNA6.dApr07','chr1','+',32346235,32411361,32400162,32409082,14,0x33323334363233352C33323339323737352C33323339353034302C33323339353533332C33323339363435342C33323339373538372C33323339383830362C33323430303133342C33323430303534382C33323430313432322C33323430343239322C33323430353335362C33323430383036392C33323430383839342C,0x33323334363332322C33323339323930392C33323339353131352C33323339353633332C33323339363534392C33323339373731392C33323339383839312C33323430303233342C33323430303731322C33323430313530312C33323430343431382C33323430353438342C33323430383234382C33323431313336312C),
 (103,'KPNA6.fApr07','chr1','+',32346246,32397719,32392780,32397719,6,0x33323334363234362C33323339323737372C33323339353034302C33323339353533332C33323339363435342C33323339373538372C,0x33323334363332322C33323339323930392C33323339353133332C33323339353633332C33323339363534392C33323339373731392C),
 (103,'KPNA6.iApr07','chr1','+',32346266,32397626,32378049,32397626,7,0x33323334363236362C33323337373934322C33323339323737372C33323339353034302C33323339353533332C33323339363435342C33323339373538372C,0x33323334363332322C33323337383035322C33323339323930392C33323339353133332C33323339353633332C33323339363534392C33323339373632362C),
 (103,'KPNA6.gApr07','chr1','+',32346269,32397690,32392780,32397689,7,0x33323334363236392C33323336343235382C33323339323737352C33323339353034302C33323339353533332C33323339363435342C33323339373538372C,0x33323334363332322C33323336343430332C33323339323930392C33323339353133332C33323339353633332C33323339363534392C33323339373639302C),
 (103,'KPNA6.eApr07','chr1','+',32346694,32398828,32392780,32398826,7,0x33323334363639342C33323339323737352C33323339353034302C33323339353533332C33323339363435342C33323339373538372C33323339383830322C,0x33323334363832322C33323339323930392C33323339353133332C33323339353633332C33323339363534392C33323339373731392C33323339383832382C),
 (104,'klarbu.aApr07','chr1','+',32633026,32645980,0,0,2,0x33323633333032362C33323634353839392C,0x33323633333332302C33323634353938302C),
 (104,'RP1-27O5.1andZBTB8.aApr07','chr1','+',32703245,32838569,32708812,32774716,10,0x33323730333234352C33323730383737312C33323731393037382C33323732333238382C33323737343330302C33323737343637322C33323739313634362C33323833313131382C33323833333234312C33323833383237342C,0x33323730333239332C33323730393830332C33323731393235372C33323732333532302C33323737343339332C33323737343735322C33323739313732382C33323833313934322C33323833333431312C33323833383536392C),
 (104,'RBBP4.cApr07','chr1','+',32889329,32918694,32889494,32917893,12,0x33323838393332392C33323839303130342C33323839353631342C33323930363431322C33323930363932362C33323930373135392C33323930373431382C33323930373637332C33323931303633372C33323931303832392C33323931303937382C33323931373832372C,0x33323838393531302C33323839303234392C33323839353736302C33323930363538362C33323930373034322C33323930373332302C33323930373534352C33323930373735312C33323931303731342C33323931303838372C33323931313038392C33323931383639342C),
 (104,'RBBP4.aApr07','chr1','+',32889330,32921116,32889494,32918002,13,0x33323838393333302C33323839303130312C33323839353631342C33323930363431322C33323930363932362C33323930373135392C33323930373431382C33323930373637332C33323931303633372C33323931303832392C33323931303937382C33323931313634362C33323931373832372C,0x33323838393531302C33323839303234392C33323839353736302C33323930363538362C33323930373034322C33323930373332302C33323930373534352C33323930373735312C33323931303731342C33323931303838372C33323931313038392C33323931313736382C33323932313131362C),
 (104,'RBBP4.fApr07','chr1','+',32889360,32911147,32906498,32911101,10,0x33323838393336302C33323839303130312C33323930363431322C33323930363932362C33323930373135392C33323930373431382C33323930373637332C33323931303633372C33323931303832392C33323931303937382C,0x33323838393531302C33323839303234392C33323930363538362C33323930373034322C33323930373332302C33323930373534352C33323930373735312C33323931303731342C33323931303838372C33323931313134372C),
 (104,'RBBP4.hApr07','chr1','+',32889398,32906767,32889398,32906618,4,0x33323838393339382C33323839303130312C33323839353631342C33323930363431322C,0x33323838393531302C33323839303234392C33323839353736302C33323930363736372C),
 (104,'RBBP4.eApr07','chr1','+',32889399,32918841,32895651,32917893,12,0x33323838393339392C33323839303130312C33323839353631392C33323930363431322C33323930373233322C33323930373431382C33323930373637332C33323931303633372C33323931303832392C33323931303937382C33323931373832372C33323931383731332C,0x33323838393531302C33323839303234392C33323839353736302C33323930363538362C33323930373332302C33323930373534352C33323930373735312C33323931303731342C33323931303838372C33323931313038392C33323931383030352C33323931383834312C),
 (104,'RBBP4.iApr07','chr1','+',32889403,32907290,32889404,32907211,5,0x33323838393430332C33323839303130312C33323930363530372C33323930363932362C33323930373135392C,0x33323838393531302C33323839303234392C33323930363538362C33323930373034322C33323930373239302C),
 (104,'RBBP4.bApr07','chr1','+',32889403,32918845,32889494,32917893,12,0x33323838393430332C33323839303130312C33323839353631342C33323930363431322C33323930363932362C33323930373135392C33323930373431382C33323930373637332C33323931303633372C33323931303832392C33323931303937382C33323931373832372C,0x33323838393531302C33323839303234392C33323839353736302C33323930363538362C33323930373034322C33323930373332302C33323930373534352C33323930373735312C33323931303731342C33323931303838372C33323931313038392C33323931383834352C),
 (104,'RBBP4.dApr07','chr1','+',32889421,32918845,32889494,32918734,12,0x33323838393432312C33323839303130312C33323839353631342C33323930363431322C33323930363932362C33323930373135392C33323930373431382C33323930373637332C33323931303633372C33323931303832392C33323931303937382C33323931383731332C,0x33323838393531302C33323839303234392C33323839353736302C33323930363538362C33323930373034322C33323930373332302C33323930373534352C33323930373735312C33323931303731342C33323931303838372C33323931313038392C33323931383834352C),
 (104,'RBBP4.nApr07','chr1','+',32889435,32906525,32889494,32900438,5,0x33323838393433352C33323839303130312C33323839353631342C33323930303433332C33323930363431322C,0x33323838393531302C33323839303234392C33323839353736302C33323930303532352C33323930363532352C),
 (104,'RBBP4.oApr07','chr1','+',32889438,32900522,32889440,32895674,4,0x33323838393433382C33323839303130312C33323839353631392C33323930303433332C,0x33323838393531302C33323839303234392C33323839353736302C33323930303532322C),
 (104,'RBBP4.gApr07','chr1','+',32889542,32907039,32889544,32907039,5,0x33323838393534322C33323839303130312C33323839353631342C33323930363431322C33323930363932362C,0x33323838393632302C33323839303234392C33323839353736302C33323930363538362C33323930373033392C),
 (104,'RBBP4.kApr07','chr1','+',32889622,32906469,32889785,32906468,4,0x33323838393632322C33323839303130312C33323839353631342C33323930363431322C,0x33323838393930332C33323839303234392C33323839353736302C33323930363436392C),
 (104,'YARS.aApr07','chr1','-',33012961,33056347,33014168,33055432,13,0x33333031323936312C33333031373536392C33333031383237322C33333031393233352C33333032303539312C33333032343534392C33333032353132372C33333032393334392C33333033353935302C33333034343636392C33333034383737382C33333034393039382C33333035353337352C,0x33333031343237392C33333031373731312C33333031383436362C33333031393333332C33333032303732372C33333032343633352C33333032353236332C33333032393434322C33333033363033312C33333034343739392C33333034383935342C33333034393234352C33333035363334372C),
 (104,'YARS.iApr07','chr1','-',33013422,33049835,33013507,33049137,5,0x33333031333432322C33333033353938382C33333034343636392C33333034383737382C33333034393039382C,0x33333031333634372C33333033363033312C33333034343739392C33333034383935342C33333034393833352C),
 (104,'YARS.bApr07','chr1','-',33013425,33055572,33017700,33044741,11,0x33333031333432352C33333031373536392C33333031383239342C33333031393233352C33333032303539312C33333032343534392C33333032353132372C33333032393334392C33333033353935302C33333034343636392C33333035353337352C,0x33333031343237392C33333031373731312C33333031383436362C33333031393333332C33333032303732372C33333032343633352C33333032353236332C33333032393434322C33333033363033312C33333034343739392C33333035353537322C),
 (104,'YARS.cApr07','chr1','-',33014133,33055517,33025068,33055432,12,0x33333031343133332C33333031373536392C33333031383237322C33333031393233352C33333032303539312C33333032343534392C33333032393334392C33333033353935302C33333034343636392C33333034383737382C33333034393039382C33333035353337352C,0x33333031343237392C33333031373731312C33333031383436362C33333031393333332C33333032303732372C33333032353236332C33333032393434322C33333033363033312C33333034343739392C33333034383935342C33333034393234352C33333035353531372C),
 (104,'YARS.eApr07','chr1','-',33019235,33055567,33020692,33055432,8,0x33333031393233352C33333032303539312C33333032353132372C33333032393334392C33333033353935302C33333034343636392C33333034383737382C33333035353337352C,0x33333031393333332C33333032303732372C33333032353236332C33333032393434322C33333033363033312C33333034343739392C33333034383935342C33333035353536372C),
 (104,'YARS.dApr07','chr1','-',33019275,33055532,33025068,33055432,9,0x33333031393237352C33333032303539312C33333032343534392C33333032343938382C33333032393334392C33333034343636392C33333034383737382C33333034393039382C33333035353337352C,0x33333031393333332C33333032303732372C33333032343633352C33333032353236332C33333032393434322C33333034343739392C33333034383935342C33333034393234352C33333035353533322C),
 (104,'YARS.nApr07','chr1','-',33020188,33036402,33029402,33036061,5,0x33333032303138382C33333032343630312C33333032393334392C33333033353737392C33333033353935302C,0x33333032303732372C33333032353236332C33333032393434322C33333033353832362C33333033363430322C),
 (104,'YARS.jApr07','chr1','-',33028830,33055599,33029292,33048836,6,0x33333032383833302C33333033353935302C33333034343636392C33333034383737342C33333034393039382C33333035353337352C,0x33333032393434322C33333033363033312C33333034343739392C33333034383935342C33333034393234352C33333035353539392C),
 (104,'TMEM54.iApr07','chr1','-',33132782,33165405,0,0,7,0x33333133323738322C33333133333439322C33333133333734322C33333136313632372C33333136343331312C33333136343932382C33333136353237322C,0x33333133333036372C33333133333632372C33333133333737302C33333136313734392C33333136343436382C33333136353035392C33333136353430352C),
 (104,'AK2.lApr07','chr1','-',33252087,33319183,33252710,33262704,6,0x33333235323038372C33333235393738302C33333236323632392C33333236393733312C33333331383338362C33333331393130382C,0x33333235323738322C33333235393839312C33333236323735352C33333236393834392C33333331383439392C33333331393138332C),
 (104,'ADC.oApr07','chr1','+',33319429,33470767,33319429,33470767,6,0x33333331393432392C33333331393537352C33333333343839342C33333333363235342C33333436393539342C33333437303633332C,0x33333331393438322C33333331393639362C33333333353035372C33333333363336372C33333436393636312C33333437303736372C),
 (105,'CSMD2.bApr07','chr1','-',33752185,34404030,33757704,34404001,70,0x33333735323138352C33333735373635312C33333735373939382C33333735393634392C33333736313439332C33333736333036382C33333736353338322C33333737313233362C33333737313938322C33333737353230382C33333737353632322C33333737383731312C33333737393331362C33333738303930362C33333738343232332C33333738383336332C33333830353737392C33333830373536302C33333830393731382C33333831303639322C33333831353438322C33333831383933392C33333832313832382C33333832343639302C33333832353237342C33333833393035312C33333834303535352C33333834333436382C33333834343034392C33333834393232372C33333835323639302C33333835353039322C33333835353638352C33333836303335332C33333836313535362C33333836323730352C33333836333233372C33333836343637322C33333837313630382C33333837333430302C33333837343534362C33333838343833342C33333839303530392C33333839363133322C33333930313037362C33333933313131362C33333933363933392C33333933383730332C33333934373237352C33333935323737332C33333935343437322C33333936323338332C33333936323730332C33333936333533362C33333936343733342C33333937373332372C33333938313436372C33343031303735362C33343032363738372C33343033303631302C33343034383933302C33343035373930302C33343035383635362C33343036333838342C33343038353037312C33343135363238312C33343137333934372C33343237303738312C33343332373136342C33343430333933342C,0x33333735343735372C33333735373836342C33333735383133372C33333735393733372C33333736313630362C33333736333233302C33333736353434352C33333737313431362C33333737323039342C33333737353238322C33333737353739362C33333737383838352C33333737393439362C33333738313038332C33333738343430362C33333738383533372C33333830353935332C33333830373733342C33333830393931332C33333831303837382C33333831353637312C33333831393038362C33333832323031372C33333832343830342C33333832353335352C33333833393139372C33333834303733332C33333834333635372C33333834343137352C33333834393433372C33333835323830372C33333835353136322C33333835353830342C33333836303435382C33333836313635332C33333836323833302C33333836333434312C33333836343736382C33333837313732322C33333837333531372C33333837343734312C33333838353032322C33333839303634382C33333839363332342C33333930313237392C33333933313234332C33333933373133312C33333933383836302C33333934373434352C33333935323936322C33333935343638382C33333936323530302C33333936323839322C33333936333732342C33333936343837332C33333937373532322C33333938313739342C33343031303933392C33343032363930302C33343033303731342C33343034393035322C33343035383032352C33343035383734342C33343036333936322C33343038353138342C33343135363438392C33343137343134322C33343237303839342C33343332373338312C33343430343033302C),
 (105,'CSMD2.aApr07','chr1','-',33752192,34403467,33757704,34403465,71,0x33333735323139322C33333735373635312C33333735373939382C33333735393634392C33333736313439332C33333736333036382C33333736353338322C33333737313233362C33333737313938322C33333737353230382C33333737353632322C33333737383731312C33333737393331362C33333738303930362C33333738343232332C33333738383336332C33333739353932302C33333739373438362C33333830353737392C33333830373536302C33333830393731382C33333831303639322C33333831353438322C33333831383933392C33333832313832382C33333832343639302C33333832353237342C33333833393035312C33333834303535352C33333834333436382C33333834393232372C33333835323639302C33333835353039322C33333835353638352C33333836303335332C33333836313535362C33333836323730352C33333836333233372C33333836343637322C33333837313630382C33333837333430302C33333837343534362C33333838343833342C33333839303530392C33333839363133322C33333930313037362C33333933313131362C33333933363933392C33333933383730332C33333934373237352C33333935323737332C33333935343437322C33333936323338332C33333936323730332C33333936333533362C33333936343733342C33333937373332372C33333938313436372C33343031303735362C33343032363738372C33343033303631302C33343034383933302C33343035373930302C33343035383635362C33343036333838342C33343038353037312C33343135363238312C33343137333934372C33343237303738312C33343332373136342C33343430333039382C,0x33333735343735372C33333735373836342C33333735383133372C33333735393733372C33333736313630362C33333736333233302C33333736353434352C33333737313431362C33333737323039342C33333737353238322C33333737353739362C33333737383838352C33333737393439362C33333738313038332C33333738343430362C33333738383533372C33333739363130392C33333739373636302C33333830363032382C33333830373733342C33333830393931332C33333831303837382C33333831353637312C33333831393038362C33333832323031372C33333832343830342C33333832353335352C33333833393139372C33333834303733332C33333834333635372C33333834393433372C33333835323830372C33333835353136322C33333835353830342C33333836303435382C33333836313635332C33333836323833302C33333836333434312C33333836343736382C33333837313732322C33333837333531372C33333837343734312C33333838353032322C33333839303634382C33333839363332342C33333930313237392C33333933313234332C33333933373133312C33333933383836302C33333934373434352C33333935323936322C33333935343638382C33333936323530302C33333936323839322C33333936333732342C33333936343837332C33333937373532322C33333938313739342C33343031303933392C33343032363930302C33343033303731342C33343034393035322C33343035383032352C33343035383734342C33343036333936322C33343038353138342C33343135363438392C33343137343134322C33343237303839342C33343332373338312C33343430333436372C);
INSERT INTO `aceview_hg18_housekeeping` (`bin`,`name`,`chrom`,`strand`,`txStart`,`txEnd`,`cdsStart`,`cdsEnd`,`exonCount`,`exonStarts`,`exonEnds`) VALUES 
 (105,'CSMD2.cApr07','chr1','-',33829993,33947691,33830647,33947470,24,0x33333832393939332C33333833393035312C33333834303535352C33333834333436382C33333834393232372C33333835323639302C33333835353039322C33333835353638352C33333836303335332C33333836313535362C33333836323730352C33333836333233372C33333836343637322C33333837313630382C33333837333430302C33333837343534362C33333838343833342C33333839303530392C33333839363133322C33333930313037362C33333933313131362C33333933363933392C33333933383730332C33333934373237352C,0x33333833303637362C33333833393139372C33333834303733332C33333834333635372C33333834393433372C33333835323830372C33333835353136322C33333835353830342C33333836303435382C33333836313635332C33333836323833302C33333836333434312C33333836343736382C33333837313732322C33333837333531372C33333837343734312C33333838353032322C33333839303634382C33333839363332342C33333930313237392C33333933313234332C33333933373133312C33333933383836302C33333934373639312C),
 (106,'C1orf212.fApr07','chr1','-',34950972,35097924,0,0,5,0x33343935303937322C33343935343335362C33343935363435352C33353039333935382C33353039373836342C,0x33343935323830382C33343935343637372C33343935363539372C33353039343137302C33353039373932342C),
 (106,'GJB5.aApr07','chr1','+',34993234,34996700,34995518,34996340,2,0x33343939333233342C33343939353439342C,0x33343939333338332C33343939363730302C),
 (106,'DLGAP3.aApr07','chr1','-',35099592,35167773,35104270,35143571,12,0x33353039393539322C33353130353233352C33353130353732332C33353130363739322C33353132333136352C33353132333636352C33353132343235392C33353133373835362C33353133383235352C33353134323436342C33353134353534322C33353136373633382C,0x33353130343438392C33353130353337392C33353130353831352C33353130373237372C33353132333235312C33353132333937392C33353132343437332C33353133373932392C33353133383436312C33353134333632322C33353134353632352C33353136373737332C),
 (106,'DLGAP3.bApr07','chr1','-',35123838,35129926,35123839,35124368,3,0x33353132333833382C33353132343235392C33353132393430302C,0x33353132333937392C33353132343437332C33353132393932362C),
 (106,'ZMYM6.bApr07','chr1','-',35219713,35269925,35222109,35268827,17,0x33353231393731332C33353232313935342C33353233303432312C33353234323135352C33353234333331392C33353234353133382C33353234363933392C33353234383633342C33353234383934352C33353235303037372C33353235303631382C33353235323838342C33353235333137352C33353235373534302C33353235383537302C33353236383733342C33353236393831382C,0x33353232303330372C33353232323133352C33353233303537352C33353234323139332C33353234333436302C33353234353238362C33353234373131322C33353234383738352C33353234393232342C33353235303139332C33353235303736392C33353235333037362C33353235333335302C33353235373739302C33353235383635352C33353236383930312C33353236393932352C),
 (106,'ZMYM6.aApr07','chr1','-',35224352,35270161,35225291,35268827,16,0x33353232343335322C33353233303432312C33353234323135352C33353234333331392C33353234353133382C33353234363933392C33353234383633342C33353234383934352C33353235303037372C33353235303631382C33353235323838342C33353235333137352C33353235373534302C33353235383537302C33353236383733342C33353237303030322C,0x33353232373132332C33353233303537352C33353234323139332C33353234333436302C33353234353238362C33353234373131322C33353234383738352C33353234393232342C33353235303139332C33353235303736392C33353235333037362C33353235333335302C33353235373739302C33353235383635352C33353236383930312C33353237303136312C),
 (106,'ZMYM6.dApr07','chr1','-',35224355,35269902,35228446,35253196,15,0x33353232343335352C33353233303432312C33353234323135352C33353234333331392C33353234353133382C33353234363933392C33353234383633342C33353234383934352C33353235303037372C33353235303631382C33353235323838342C33353235333137352C33353235383537302C33353236383733342C33353236393831382C,0x33353232383439392C33353233303537352C33353234323139332C33353234333436302C33353234353238362C33353234373131322C33353234383738352C33353234393232342C33353235303139332C33353235303736392C33353235333037362C33353235333335302C33353235383635352C33353236383934342C33353236393930322C),
 (106,'ZMYM6.gApr07','chr1','-',35253175,35269852,35253175,35268827,5,0x33353235333137352C33353235373534302C33353235383537302C33353236383733342C33353236393731332C,0x33353235333335302C33353235373739302C33353235383635352C33353236383930312C33353236393835322C),
 (106,'ZMYM6.jApr07','chr1','-',35255431,35270156,35257455,35268827,4,0x33353235353433312C33353235383537302C33353236383733342C33353237303030322C,0x33353235373739302C33353235383635352C33353236383930312C33353237303135362C),
 (106,'ZMYM6.tApr07','chr1','-',35255436,35270034,0,0,3,0x33353235353433362C33353235383537302C33353237303030322C,0x33353235373739302C33353235383635352C33353237303033342C),
 (106,'ZMYM6.hApr07','chr1','-',35256698,35269877,35257455,35268827,5,0x33353235363639382C33353235383537302C33353236383733342C33353236393435342C33353236393831382C,0x33353235373739302C33353235383635352C33353236383930312C33353236393532352C33353236393837372C),
 (106,'ZMYM6.iApr07','chr1','-',35257278,35269840,35257455,35268827,4,0x33353235373237382C33353235383537302C33353236383733342C33353236393831382C,0x33353235373739302C33353235383635352C33353236383930312C33353236393834302C),
 (106,'ZMYM6.nApr07','chr1','-',35257593,35270039,35257593,35268827,5,0x33353235373539332C33353235383537302C33353236383733342C33353236393435342C33353237303030322C,0x33353235373739302C33353235383635352C33353236383930312C33353236393532352C33353237303033392C),
 (106,'ZMYM6.oApr07','chr1','-',35257624,35269859,35257626,35268827,4,0x33353235373632342C33353235383537302C33353236383733342C33353236393738352C,0x33353235373739302C33353235383635352C33353236383930312C33353236393835392C),
 (106,'ZMYM6.pApr07','chr1','-',35257687,35269859,35257689,35268827,3,0x33353235373638372C33353235383537302C33353236383733342C,0x33353235373739302C33353235383635352C33353236393835392C),
 (106,'ZMYM6.sApr07','chr1','-',35257729,35269877,35257731,35268827,4,0x33353235373732392C33353235383537302C33353236383733342C33353236393435342C,0x33353235373739302C33353235383635352C33353236383930312C33353236393837372C),
 (107,'KIAA0319L.aApr07','chr1','-',35671673,35795593,35673081,35795561,21,0x33353637313637332C33353637393233342C33353638303433332C33353638313039332C33353638323334382C33353638363336302C33353638383035342C33353638383534352C33353638393831352C33353639313734342C33353639323534392C33353639343230302C33353639383439322C33353730303830382C33353730343739352C33353730393035302C33353731323939322C33353731373135332C33353734343739392C33353739323533372C33353739353339342C,0x33353637333236392C33353637393332362C33353638303532342C33353638313231362C33353638323439312C33353638363532302C33353638383139332C33353638383639372C33353638393936342C33353639313837372C33353639323637332C33353639343432392C33353639383632352C33353730303930312C33353730343838332C33353730393134382C33353731333039342C33353731373430302C33353734353332332C33353739323730372C33353739353539332C),
 (107,'KIAA0319L.bApr07','chr1','-',35671679,35795591,35679205,35795561,20,0x33353637313637392C33353638303433332C33353638313039332C33353638323334382C33353638363336302C33353638383035342C33353638383534352C33353638393831352C33353639313734342C33353639323534392C33353639343230302C33353639383439322C33353730303830382C33353730343739352C33353730393035302C33353731323939322C33353731373135332C33353734343739392C33353739323533372C33353739353339342C,0x33353637393332362C33353638303532342C33353638313231362C33353638323439312C33353638363532302C33353638383139332C33353638383639372C33353638393936342C33353639313837372C33353639323637332C33353639343432392C33353639383632352C33353730303930312C33353730343838332C33353730393134382C33353731333039342C33353731373430302C33353734353332332C33353739323730372C33353739353539312C),
 (107,'KIAA0319L.cApr07','chr1','-',35673114,35793175,35682378,35792679,20,0x33353637333131342C33353637393233342C33353638303433332C33353638313039332C33353638323334382C33353638383035342C33353638383534352C33353638393831352C33353639313734342C33353639323534392C33353639343230302C33353639383439322C33353730303830382C33353730343739352C33353730393035302C33353731323939322C33353731373135332C33353734343739392C33353739323533372C33353739333038372C,0x33353637333236392C33353637393332362C33353638303532342C33353638313231362C33353638323439312C33353638383139332C33353638383639372C33353638393936342C33353639313837372C33353639323637332C33353639343432392C33353639383632352C33353730303930312C33353730343838332C33353730393134382C33353731333039342C33353731373430302C33353734353332332C33353739323730372C33353739333137352C),
 (107,'KIAA0319L.fApr07','chr1','-',35698492,35795592,35698494,35792679,8,0x33353639383439322C33353730303830382C33353730343739352C33353730393035302C33353731373135332C33353734343739392C33353739323533372C33353739353534392C,0x33353639383632352C33353730303930312C33353730343838332C33353730393134382C33353731373430302C33353734353332332C33353739323730372C33353739353539322C),
 (107,'KIAA0319L.gApr07','chr1','-',35698524,35795800,35698524,35795798,6,0x33353639383532342C33353730303830382C33353731323939322C33353731373135332C33353734343739392C33353739353733372C,0x33353639383632352C33353730303930312C33353731333039342C33353731373430302C33353734353332332C33353739353830302C),
 (107,'KIAA0319L.eApr07','chr1','-',35702693,35795573,35703054,35795573,8,0x33353730323639332C33353730343739352C33353730393035302C33353731323939322C33353731373135332C33353734343739392C33353739323533372C33353739353339342C,0x33353730333131362C33353730343838332C33353730393134382C33353731333039342C33353731373430302C33353734353332332C33353739323730372C33353739353537332C),
 (107,'KIAA0319L.kApr07','chr1','-',35704843,35795574,35704844,35795573,5,0x33353730343834332C33353730393035302C33353731323939322C33353739323533372C33353739353339342C,0x33353730343838332C33353730393134382C33353731333039342C33353739323730372C33353739353537342C),
 (107,'KIAA0319L.mApr07','chr1','-',35708965,35795590,35745313,35795561,6,0x33353730383936352C33353731323939322C33353734343739392C33353737363635332C33353739323533372C33353739353339342C,0x33353730393134382C33353731333039342C33353734353332332C33353737363737312C33353739323730372C33353739353539302C),
 (107,'KIAA0319L.oApr07','chr1','-',35709051,35795607,35717308,35795561,5,0x33353730393035312C33353731323939322C33353731373135332C33353739323533372C33353739353339342C,0x33353730393134382C33353731333039342C33353731373430302C33353739323730372C33353739353630372C),
 (107,'KIAA0319L.qApr07','chr1','-',35717183,35795590,35717400,35795561,3,0x33353731373138332C33353739323533372C33353739353339342C,0x33353731373431372C33353739323730372C33353739353539302C),
 (107,'KIAA0319L.lApr07','chr1','-',35745174,35796010,35745174,35796008,4,0x33353734353137342C33353739323533372C33353739353339342C33353739363030312C,0x33353734353332332C33353739323730372C33353739353536362C33353739363031302C),
 (107,'KIAA0319L.rApr07','chr1','-',35771283,35795790,35771490,35795761,3,0x33353737313238332C33353739323533372C33353739353733372C,0x33353737313632392C33353739323730372C33353739353739302C),
 (107,'EIF2C3.eApr07','chr1','+',36168906,36221601,36169614,36220840,7,0x33363136383930362C33363136393431362C33363138333837392C33363230353134322C33363231303231312C33363231313536322C33363232303830382C,0x33363136383938362C33363136393633332C33363138343035312C33363230353236332C33363231303432302C33363231313639392C33363232313630312C),
 (107,'EIF2C3.dApr07','chr1','+',36169264,36223858,36169614,36220840,7,0x33363136393236342C33363138333837392C33363230353134322C33363231303231312C33363231313536322C33363232303830382C33363232323635372C,0x33363136393633332C33363138343035312C33363230353236332C33363231303432302C33363231313639392C33363232303930302C33363232333835382C),
 (107,'EIF2C3.bApr07','chr1','+',36169359,36294653,36242572,36293933,17,0x33363136393335392C33363138333837392C33363231303231312C33363234323532382C33363234363837372C33363234373038342C33363234373636322C33363235313831372C33363235323130322C33363236353330312C33363237323336312C33363237343336342C33363237373937372C33363237383439342C33363238313633342C33363239333133332C33363239333832342C,0x33363136393633332C33363138343035312C33363231303432302C33363234323636332C33363234363936352C33363234373233322C33363234373738322C33363235313934302C33363235323233362C33363236353438362C33363237323532312C33363237343435352C33363237383137322C33363237383632392C33363238313733362C33363239333333332C33363239343635332C),
 (107,'EIF2C3.aApr07','chr1','+',36169359,36296161,36169614,36293933,20,0x33363136393335392C33363138333837392C33363230353134322C33363231303231312C33363231313536322C33363234323532382C33363234363837372C33363234373038342C33363234373636322C33363235313831372C33363235323130322C33363236353330312C33363237323336312C33363237343336342C33363237373937372C33363237383439342C33363238313633342C33363239333133332C33363239333832342C33363239363036322C,0x33363136393633332C33363138343035312C33363230353236332C33363231303432302C33363231313639392C33363234323636332C33363234363936352C33363234373233322C33363234373738322C33363235313934302C33363235323233362C33363236353438362C33363237323532312C33363237343435352C33363237383137322C33363237383632392C33363238313733362C33363239333333332C33363239343937342C33363239363136312C),
 (108,'GRIK3.aApr07','chr1','-',37039200,37272615,37040038,37272614,16,0x33373033393230302C33373034333137342C33373034343239312C33373035353234372C33373035373932332C33373036333739302C33373037393932332C33373038383439382C33373039313830322C33373039373239352C33373039383033312C33373130373933352C33373131303337352C33373131383832312C33373132393130372C33373237323138312C,0x33373034303233332C33373034333432352C33373034343531342C33373035353436352C33373035383034322C33373036343031342C33373038303132372C33373038383631322C33373039313931302C33373039373433392C33373039383230352C33373130373938392C33373131303535372C33373131393037392C33373132393238342C33373237323631352C),
 (108,'GRIK3.bApr07','chr1','-',37042805,37272317,37043120,37272317,15,0x33373034323830352C33373034343239312C33373035353234372C33373035373932332C33373036333739302C33373037393932332C33373038383439382C33373039313830322C33373039373239352C33373039383033312C33373130373933352C33373131303337352C33373131383832312C33373132393130372C33373237323138312C,0x33373034333432352C33373034343531342C33373035353436352C33373035383034322C33373036343031342C33373038303132372C33373038383631322C33373039313931302C33373039373433392C33373039383230352C33373130373938392C33373131303535372C33373131393037392C33373132393238342C33373237323331372C),
 (108,'GRIK3.dApr07','chr1','-',37087861,37097324,37088057,37097322,4,0x33373038373836312C33373038383439382C33373039313830322C33373039373239352C,0x33373038383136382C33373038383631322C33373039313931302C33373039373332342C),
 (108,'stukley.aApr07','chr1','-',37341883,37390837,37341955,37390636,3,0x33373334313838332C33373338373434392C33373339303631392C,0x33373334323036362C33373338373631322C33373339303833372C),
 (108,'stukley.bApr07','chr1','-',37341885,37390837,37341905,37390626,2,0x33373334313838352C33373339303631392C,0x33373334323036362C33373339303833372C),
 (109,'INPP5B.cApr07','chr1','-',38098951,38185280,38100629,38184567,20,0x33383039383935312C33383131313138382C33383131323235312C33383131333836342C33383131363434362C33383131383334332C33383132313036352C33383132333839362C33383132353134362C33383132353630392C33383132363530312C33383132373831352C33383132393631362C33383137303137312C33383137383934362C33383138313839382C33383138323035342C33383138343031342C33383138343531302C33383138353234382C,0x33383130303638392C33383131313432342C33383131323431342C33383131333937352C33383131363538322C33383131383435332C33383132313137372C33383132343038342C33383132353236332C33383132353732342C33383132363630332C33383132373938332C33383132393731332C33383137303331322C33383137393035372C33383138313932382C33383138323135322C33383138343130392C33383138343539332C33383138353238302C),
 (109,'INPP5B.bApr07','chr1','-',38098955,38170007,38100573,38169971,18,0x33383039383935352C33383130323537302C33383130343031392C33383130343731372C33383130363735392C33383131313138382C33383131323235312C33383131333836342C33383131363434362C33383131383334332C33383132313036352C33383132333839362C33383132353134362C33383132353630392C33383132363530312C33383132373831352C33383132393631362C33383136393933312C,0x33383130303638392C33383130323638322C33383130343134372C33383130343830322C33383130363837332C33383131313432342C33383131323431342C33383131333937352C33383131363538322C33383131383435332C33383132313137372C33383132343038342C33383132353236332C33383132353732342C33383132363630332C33383132373938332C33383132393731332C33383137303030372C),
 (109,'INPP5B.aApr07','chr1','-',38098955,38185316,38100573,38184567,24,0x33383039383935352C33383130323537302C33383130343031392C33383130343731372C33383130363735392C33383131313138382C33383131323235312C33383131333836342C33383131363434362C33383131383334332C33383132313036352C33383132333839362C33383132353134362C33383132353630392C33383132363530312C33383132373831352C33383132393631362C33383137303137312C33383137383934362C33383138313839382C33383138323035342C33383138343031342C33383138343531302C33383138353234382C,0x33383130303638392C33383130323638322C33383130343134372C33383130343830322C33383130363837332C33383131313432342C33383131323431342C33383131333937352C33383131363538322C33383131383435332C33383132313137372C33383132343038342C33383132353236332C33383132353732342C33383132363630332C33383132373938332C33383132393731332C33383137303331322C33383137393035372C33383138313932382C33383138323135322C33383138343130392C33383138343539332C33383138353331362C),
 (109,'INPP5B.eApr07','chr1','-',38127896,38185308,38127898,38184567,9,0x33383132373839362C33383132393631362C33383137303137312C33383137383934362C33383138313839382C33383138323035342C33383138343031342C33383138343531302C33383138353234382C,0x33383132373938332C33383132393731332C33383137303331322C33383137393035312C33383138313932382C33383138323135322C33383138343130392C33383138343539332C33383138353330382C),
 (109,'warubo.bApr07','chr1','+',38665616,38734292,0,0,2,0x33383636353631362C33383733343038392C,0x33383636353838312C33383733343239322C),
 (109,'warubo.aApr07','chr1','+',38665635,38684116,0,0,2,0x33383636353633352C33383638333732342C,0x33383636353838312C33383638343131362C),
 (110,'CH.0.dApr07','chr1','+',39319574,39341240,39319678,39341107,4,0x33393331393537342C33393332313632312C33393332323432352C33393334303936312C,0x33393331393830322C33393332313637362C33393332323639372C33393334313234302C),
 (110,'CH.0.bApr07','chr1','+',39319613,39521680,39319614,39521678,9,0x33393331393631332C33393332323432352C33393436393434302C33393438383237322C33393439323535362C33393439363139342C33393532303436362C33393532313434372C33393532313636372C,0x33393331393830322C33393332323639372C33393436393530322C33393438383336322C33393439323633342C33393439363238372C33393532303633332C33393532313536302C33393532313638302C),
 (110,'CH.0.gApr07','chr1','+',39319676,39342636,39319678,39341107,5,0x33393331393637362C33393332313632312C33393332323432352C33393334303936312C33393334323132342C,0x33393331393830322C33393332313637362C33393332323639372C33393334313137332C33393334323633362C),
 (110,'CH.0.eApr07','chr1','+',39319676,39341985,39319678,39341309,3,0x33393331393637362C33393332323432352C33393334303936312C,0x33393331393830322C33393332323639372C33393334313938352C),
 (110,'CH.0.cApr07','chr1','+',39343687,39492881,39343687,39492748,4,0x33393334333638372C33393436393434302C33393438383237322C33393439323535362C,0x33393334333937362C33393436393530322C33393438383336322C33393439323838312C),
 (110,'CH.0.iApr07','chr1','+',39442951,39492634,39443281,39492634,4,0x33393434323935312C33393436393434302C33393438383237322C33393439323535362C,0x33393434333339302C33393436393530322C33393438383336322C33393439323633342C),
 (110,'MACF1andKIAA0754.cApr07','chr1','+',39520459,39724699,39520460,39724053,87,0x33393532303435392C33393532313434372C33393532313636372C33393532323332342C33393532323539312C33393532333334312C33393532333535352C33393532333836322C33393532353534342C33393533303136382C33393533313032342C33393533313731362C33393533333330342C33393533343034352C33393533353837382C33393533383436382C33393534313138322C33393534373832382C33393534383530332C33393534393038392C33393535333737312C33393535343634392C33393535353437322C33393535363731312C33393535373932322C33393536303836362C33393536313136382C33393536323435312C33393536323930342C33393536353437362C33393538373733362C33393538393034332C33393539313236352C33393539353633332C33393539363935352C33393539373339392C33393539393035312C33393539393631382C33393630363430362C33393630383238382C33393631303733372C33393631373436312C33393631383530322C33393632303231312C33393632333639322C33393632353434352C33393636303633322C33393636303938382C33393636323238362C33393636353731332C33393636363231392C33393636373530302C33393636383038352C33393636383936302C33393637303739332C33393637313330362C33393637323637322C33393637333831362C33393637343734302C33393637363033352C33393637373533322C33393637393236312C33393637393438322C33393638303231302C33393638303430352C33393638303637302C33393638303937322C33393638313730342C33393638323932302C33393638353639302C33393638353935302C33393638363239312C33393638363835322C33393638393331302C33393639303431342C33393639303934322C33393639313936352C33393639333136372C33393639363632382C33393639373334342C33393639383839302C33393730303134312C33393730313837302C33393730363837332C33393731383035362C33393732323835392C33393732333739362C,0x33393532303633332C33393532313536302C33393532313737342C33393532323434342C33393532323638372C33393532333436392C33393532333634392C33393532343031372C33393532353832312C33393533303239372C33393533313130322C33393533313837382C33393533333430392C33393533343134312C33393533363030342C33393533383632312C33393534313333372C33393534373935352C33393534383638372C33393534393235392C33393535333935302C33393535343738382C33393535353636362C33393535363837342C33393535383030362C33393536303937342C33393536313236372C33393536323630342C33393536323939332C33393536353631322C33393538373838362C33393538393237372C33393539313439302C33393539363135322C33393539373133322C33393539373532332C33393539393236302C33393539393933362C33393630363537332C33393630383434352C33393631303835352C33393631373730332C33393631383633322C33393632303431312C33393632343138382C33393632363931372C33393636303739342C33393636313135392C33393636323435332C33393636353837332C33393636363534362C33393636373538352C33393636383332372C33393636393136372C33393637303931332C33393637313431342C33393637323839312C33393637343032302C33393637343734392C33393637363236372C33393637373735392C33393637393338342C33393637393538342C33393638303331322C33393638303537392C33393638303832362C33393638313137302C33393638313833332C33393638333039342C33393638353834362C33393638363135372C33393638363431312C33393638373032322C33393638393437302C33393639303630392C33393639313037312C33393639323130392C33393639333335362C33393639363734392C33393639373530382C33393639393035332C33393730303239362C33393730313934352C33393730363939312C33393731383236382C33393732323938392C33393732343639392C),
 (110,'MACF1andKIAA0754.bApr07','chr1','+',39520459,39725396,39520460,39724053,88,0x33393532303435392C33393532313434372C33393532313636372C33393532323332342C33393532323539312C33393532333334312C33393532333535352C33393532333836322C33393532353534342C33393533303136382C33393533313032342C33393533313731362C33393533333330342C33393533343034352C33393533353837382C33393533383436382C33393534313138322C33393534373832382C33393534383530332C33393534393038392C33393535333737312C33393535343634392C33393535353437322C33393535363731312C33393535373932322C33393536303836362C33393536313136382C33393536323435312C33393536323930342C33393536353437362C33393538373733362C33393538393034332C33393539313236352C33393539353633332C33393539363935352C33393539373339392C33393539393035312C33393539393631382C33393630363430362C33393630383238382C33393631303733372C33393631363731392C33393631373436312C33393631383530322C33393632303231312C33393632333639322C33393632353434352C33393636303633322C33393636303938382C33393636323238362C33393636353731332C33393636363231392C33393636373530302C33393636383038352C33393636383936302C33393637303739332C33393637313330362C33393637323637322C33393637333831362C33393637343734302C33393637363033352C33393637373533322C33393637393236312C33393637393438322C33393638303231302C33393638303430352C33393638303637302C33393638303937322C33393638313730342C33393638323932302C33393638353639302C33393638353935302C33393638363239312C33393638363835322C33393638393331302C33393639303431342C33393639303934322C33393639313936352C33393639333136372C33393639363632382C33393639373334342C33393639383839302C33393730303134312C33393730313837302C33393730363837332C33393731383035362C33393732323835392C33393732333739362C,0x33393532303633332C33393532313536302C33393532313737342C33393532323434342C33393532323638372C33393532333436392C33393532333634392C33393532343031372C33393532353832312C33393533303239372C33393533313130322C33393533313837382C33393533333430392C33393533343134312C33393533363030342C33393533383632312C33393534313333372C33393534373935352C33393534383638372C33393534393235392C33393535333935302C33393535343738382C33393535353636362C33393535363837342C33393535383030362C33393536303937342C33393536313236372C33393536323630342C33393536323939332C33393536353631322C33393538373838362C33393538393237372C33393539313439302C33393539363135322C33393539373133322C33393539373532332C33393539393236302C33393539393933362C33393630363537332C33393630383434352C33393631303835352C33393631363738322C33393631373730332C33393631383633322C33393632303431312C33393632343138382C33393632363931372C33393636303739342C33393636313135392C33393636323435332C33393636353837332C33393636363534362C33393636373538352C33393636383332372C33393636393136372C33393637303931332C33393637313431342C33393637323839312C33393637343032302C33393637343734392C33393637363236372C33393637373735392C33393637393338342C33393637393538342C33393638303331322C33393638303537392C33393638303832362C33393638313137302C33393638313833332C33393638333039342C33393638353834362C33393638363135372C33393638363431312C33393638373032322C33393638393437302C33393639303630392C33393639313037312C33393639323130392C33393639333335362C33393639363734392C33393639373530382C33393639393035332C33393730303239362C33393730313934352C33393730363939312C33393731383236382C33393732323938392C33393732353339362C),
 (110,'MACF1andKIAA0754.dApr07','chr1','+',39538472,39725241,39541272,39724053,71,0x33393533383437322C33393534313138322C33393534373832382C33393534383530332C33393534393038392C33393535333737312C33393535343634392C33393535353437322C33393535363731312C33393535373932322C33393536303836362C33393536313136382C33393536323435312C33393536323930342C33393536353437362C33393538373733362C33393538393034332C33393539313236352C33393539353633332C33393539363935352C33393539373339392C33393539393035312C33393539393631382C33393630363430362C33393630383238382C33393631303733372C33393631373436312C33393631383530322C33393632303231312C33393632333639322C33393632353434352C33393636303633322C33393636303938382C33393636323238362C33393636353731332C33393636373530302C33393636383038352C33393636383936302C33393637303739332C33393637313330362C33393637323637322C33393637333831362C33393637343734302C33393637363033352C33393637373533322C33393637393236312C33393637393438322C33393638303231302C33393638303430352C33393638303637302C33393638303937322C33393638313730342C33393638323932302C33393638353639302C33393638353935302C33393638363239312C33393638363835322C33393638393331302C33393639303431342C33393639303934322C33393639313936352C33393639333136372C33393639363632382C33393639373334342C33393639383839302C33393730303134312C33393730313837302C33393730363837332C33393731383035362C33393732323835392C33393732333739362C,0x33393533383632312C33393534313333372C33393534373935352C33393534383638372C33393534393235392C33393535333935302C33393535343738382C33393535353636362C33393535363837342C33393535383030362C33393536303937342C33393536313236372C33393536323630342C33393536323939332C33393536353631322C33393538373838362C33393538393237372C33393539313439302C33393539363135322C33393539373133322C33393539373532332C33393539393236302C33393539393933362C33393630363537332C33393630383434352C33393631303835352C33393631373730332C33393631383633322C33393632303431312C33393632343138382C33393632363931372C33393636303739342C33393636313135392C33393636323435332C33393636353837332C33393636373538352C33393636383332372C33393636393136372C33393637303931332C33393637313431342C33393637323839312C33393637343032302C33393637343734392C33393637363236372C33393637373735392C33393637393338342C33393637393538342C33393638303331322C33393638303537392C33393638303832362C33393638313137302C33393638313833332C33393638333039342C33393638353834362C33393638363135372C33393638363431312C33393638373032322C33393638393437302C33393639303630392C33393639313037312C33393639323130392C33393639333335362C33393639363734392C33393639373530382C33393639393035332C33393730303239362C33393730313934352C33393730363939312C33393731383236382C33393732323938392C33393732353234312C),
 (110,'MACF1andKIAA0754.eApr07','chr1','+',39538572,39611732,39538573,39610881,26,0x33393533383537322C33393534313138322C33393534373832382C33393534383530332C33393534393038392C33393535333737312C33393535343634392C33393535353437322C33393535363731312C33393535373932322C33393536303836362C33393536313136382C33393536323435312C33393536323930342C33393536353437362C33393538373733362C33393538393034332C33393539313236352C33393539353633332C33393539363935352C33393539373339392C33393539393035312C33393539393631382C33393630363430362C33393630383238382C33393631303733372C,0x33393533383632312C33393534313333372C33393534373935352C33393534383638372C33393534393235392C33393535333935302C33393535343738382C33393535353636362C33393535363837342C33393535383030362C33393536303937342C33393536313236372C33393536323630342C33393536323939332C33393536353631322C33393538373838362C33393538393237372C33393539313439302C33393539363135322C33393539373133322C33393539373532332C33393539393236302C33393539393933362C33393630363537332C33393630383434352C33393631313733322C),
 (110,'MACF1andKIAA0754.aApr07','chr1','+',39569396,39725376,39569527,39724053,64,0x33393536393339362C33393537353434302C33393537383736302C33393537393036322C33393538353233352C33393538373733362C33393538393034332C33393539313236352C33393539353633332C33393539363935352C33393539373339392C33393539393035312C33393539393631382C33393630363430362C33393630383238382C33393631303733372C33393631363731392C33393631373436312C33393631383530322C33393632303231312C33393632333639322C33393632353434352C33393636303633322C33393636303938382C33393636323238362C33393636353731332C33393636363231392C33393636373530302C33393636383038352C33393636383936302C33393637303739332C33393637313330362C33393637323637322C33393637333831362C33393637343734302C33393637363033352C33393637373533322C33393637393236312C33393637393438322C33393638303231302C33393638303430352C33393638303637302C33393638303937322C33393638313730342C33393638323932302C33393638353639302C33393638353935302C33393638363239312C33393638363835322C33393638393331302C33393639303431342C33393639303934322C33393639313936352C33393639333136372C33393639363632382C33393639373334342C33393639383839302C33393730303134312C33393730313837302C33393730333335332C33393730363837332C33393731383035362C33393732323835392C33393732333739362C,0x33393537343931322C33393537353539302C33393537383937362C33393537393231322C33393538353436392C33393538373838362C33393538393237372C33393539313439302C33393539363135322C33393539373133322C33393539373532332C33393539393236302C33393539393933362C33393630363537332C33393630383434352C33393631303835352C33393631363738322C33393631373730332C33393631383633322C33393632303431312C33393632343138382C33393632363931372C33393636303739342C33393636313135392C33393636323435332C33393636353837332C33393636363534362C33393636373538352C33393636383332372C33393636393136372C33393637303931332C33393637313431342C33393637323839312C33393637343032302C33393637343734392C33393637363236372C33393637373735392C33393637393338342C33393637393538342C33393638303331322C33393638303537392C33393638303832362C33393638313137302C33393638313833332C33393638333039342C33393638353834362C33393638363135372C33393638363431312C33393638373032322C33393638393437302C33393639303630392C33393639313037312C33393639323130392C33393639333335362C33393639363734392C33393639373530382C33393639393035332C33393730303239362C33393730313934352C33393730333337312C33393730363939312C33393731383236382C33393732323938392C33393732353337362C),
 (110,'MACF1andKIAA0754.gApr07','chr1','+',39690694,39724479,39690969,39724053,14,0x33393639303639342C33393639313936352C33393639333136372C33393639363632382C33393639373334342C33393639383037362C33393639383839302C33393730303134312C33393730313837302C33393730363837332C33393731383035362C33393731393137382C33393732323835392C33393732333739362C,0x33393639313037312C33393639323130392C33393639333335362C33393639363734392C33393639373530382C33393639383039312C33393639393035332C33393730303239362C33393730313934352C33393730363939312C33393731383236382C33393731393238392C33393732323938392C33393732343437392C),
 (110,'MACF1andKIAA0754.hApr07','chr1','+',39697478,39723933,39697478,39723933,11,0x33393639373437382C33393639383037392C33393639383839302C33393730303134312C33393730313837302C33393730333335332C33393730363837332C33393731383035362C33393731393137382C33393732323835392C33393732333739362C,0x33393639373530382C33393639383039312C33393639393035332C33393730303239362C33393730313934352C33393730333337312C33393730363939312C33393731383236382C33393731393238392C33393732323938392C33393732333933332C),
 (110,'MACF1andKIAA0754.iApr07','chr1','+',39700257,39725228,39700257,39724053,6,0x33393730303235372C33393730313837302C33393730363835352C33393731383035362C33393732323835392C33393732333739362C,0x33393730303239362C33393730313934352C33393730363939312C33393731383236382C33393732323938392C33393732353232382C),
 (110,'MACF1andKIAA0754.uApr07','chr1','+',39700279,39718253,39700281,39718253,5,0x33393730303237392C33393730313837302C33393730363837332C33393730373830352C33393731383035362C,0x33393730303239362C33393730313934352C33393730363939312C33393730373837342C33393731383235332C),
 (110,'MACF1andKIAA0754.qApr07','chr1','+',39700280,39718376,39700281,39718358,4,0x33393730303238302C33393730313837302C33393730363837332C33393731383035362C,0x33393730303239362C33393730313934352C33393730363939312C33393731383337362C),
 (110,'MACF1andKIAA0754.jApr07','chr1','+',39706008,39724154,39706924,39724053,5,0x33393730363030382C33393730363837332C33393731383035362C33393732323835392C33393732333739362C,0x33393730363433342C33393730363939312C33393731383236382C33393732323938392C33393732343135342C),
 (110,'MACF1andKIAA0754.lApr07','chr1','+',39706852,39724479,39706924,39723081,4,0x33393730363835322C33393731383035362C33393731393137382C33393732323835392C,0x33393730363939312C33393731383236382C33393731393238392C33393732343437392C),
 (110,'MACF1andKIAA0754.oApr07','chr1','+',39706901,39725246,39706903,39723081,3,0x33393730363930312C33393731383035362C33393732323835392C,0x33393730363939312C33393731383236382C33393732353234362C),
 (111,'PPIE.sApr07','chr1','+',39930440,39991553,39980177,39987189,11,0x33393933303434302C33393937333732362C33393937383432332C33393937393632342C33393938303135332C33393938313437342C33393938323038322C33393938333633332C33393938373136332C33393939313136382C33393939313534352C,0x33393933303834372C33393937333838342C33393937383532322C33393937393636382C33393938303138302C33393938313535362C33393938323138332C33393938333735372C33393938373334372C33393939313331312C33393939313535332C),
 (111,'TRIT1.aApr07','chr1','-',40079294,40121764,40080002,40121750,11,0x34303037393239342C34303038323335392C34303038323738392C34303038353437382C34303038353830362C34303038363234342C34303038383337372C34303039303938392C34303039323232382C34303039353533352C34303132313537362C,0x34303038303137322C34303038323437372C34303038323839392C34303038353535362C34303038353931392C34303038363335362C34303038383532302C34303039313133352C34303039323332372C34303039353637362C34303132313736342C),
 (111,'TRIT1.bApr07','chr1','-',40079310,40121751,40080002,40121750,10,0x34303037393331302C34303038323335392C34303038323738392C34303038353830362C34303038363234342C34303038383337372C34303039303938392C34303039323232382C34303039353533352C34303132313537362C,0x34303038303137322C34303038323437372C34303038323839392C34303038353931392C34303038363335362C34303038383532302C34303039313133352C34303039323332372C34303039353637362C34303132313735312C),
 (111,'TRIT1.cApr07','chr1','-',40079313,40121732,40080002,40121732,9,0x34303037393331332C34303038323335392C34303038323738392C34303038353437382C34303038353830362C34303038363234342C34303038383337372C34303039303938392C34303132313537362C,0x34303038303137322C34303038323437372C34303038323839392C34303038353535362C34303038353931392C34303038363335302C34303038383532302C34303039313133352C34303132313733322C),
 (111,'TRIT1.eApr07','chr1','-',40079315,40121763,40086002,40121750,11,0x34303037393331352C34303038323335392C34303038323738392C34303038353437382C34303038353830362C34303038363234342C34303038383337372C34303039303938392C34303039323232382C34303039353533352C34303132313537362C,0x34303038303137322C34303038323437372C34303038323839392C34303038353535362C34303038363030362C34303038363335362C34303038383532302C34303039313133352C34303039323332372C34303039353637362C34303132313736332C),
 (111,'TRIT1.dApr07','chr1','-',40079326,40121762,40080002,40092266,10,0x34303037393332362C34303038323335392C34303038323738392C34303038353437382C34303038353830362C34303038363234342C34303038383337372C34303039323232382C34303039353533352C34303132313537362C,0x34303038303137322C34303038323437372C34303038323839392C34303038353535362C34303038353931392C34303038363335362C34303038383532302C34303039323332372C34303039353637362C34303132313736322C),
 (111,'TRIT1.hApr07','chr1','-',40079337,40121764,40080002,40086321,8,0x34303037393333372C34303038323335392C34303038323738392C34303038353437382C34303038353830362C34303038363234342C34303038383337372C34303132313537362C,0x34303038303137322C34303038323437372C34303038323839392C34303038353535362C34303038353931392C34303038363335362C34303038383532302C34303132313736342C),
 (111,'TRIT1.vfApr07','chr1','-',40079945,40121756,0,0,4,0x34303037393934352C34303038323335392C34303038323738392C34303132313537362C,0x34303038303137322C34303038323437372C34303038323839392C34303132313735362C),
 (111,'TRIT1.vkApr07','chr1','-',40079972,40121693,0,0,2,0x34303037393937322C34303132313537362C,0x34303038303137322C34303132313639332C),
 (111,'TRIT1.mApr07','chr1','-',40079972,40121693,40080002,40086260,6,0x34303037393937322C34303038323335392C34303038323738392C34303038353437382C34303038363234342C34303132313537362C,0x34303038303137322C34303038323437372C34303038323839392C34303038353535362C34303038363335362C34303132313639332C),
 (111,'TRIT1.nApr07','chr1','-',40079972,40121693,40080002,40086260,7,0x34303037393937322C34303038323335392C34303038323738392C34303038353437382C34303038363234342C34303038383338312C34303132313537362C,0x34303038303137322C34303038323437372C34303038323839392C34303038353535362C34303038363335362C34303038383532302C34303132313639332C),
 (111,'TRIT1.oApr07','chr1','-',40079972,40121693,40080002,40086260,9,0x34303037393937322C34303038323335392C34303038323738392C34303038353437382C34303038363234342C34303038383338312C34303039323232382C34303039353533352C34303132313537362C,0x34303038303137322C34303038323437372C34303038323839392C34303038353535362C34303038363335362C34303038383532302C34303039323332372C34303039353637362C34303132313639332C),
 (111,'TRIT1.kApr07','chr1','-',40079972,40121693,40080002,40085837,10,0x34303037393937322C34303038323335392C34303038323738392C34303038353437382C34303038353830362C34303038363234342C34303038383338312C34303039323232382C34303039353533352C34303132313537362C,0x34303038303137322C34303038323437372C34303038323839392C34303038353535362C34303038353931352C34303038363335362C34303038383532302C34303039323332372C34303039353637362C34303132313639332C),
 (111,'TRIT1.lApr07','chr1','-',40079972,40121693,40080002,40085837,10,0x34303037393937322C34303038323335392C34303038323738392C34303038353437382C34303038353830362C34303038363234342C34303038383337372C34303039323232382C34303039353533352C34303132313537362C,0x34303038303137322C34303038323437372C34303038323839392C34303038353535362C34303038353931352C34303038363335362C34303038383532302C34303039323332372C34303039353637362C34303132313639332C),
 (111,'TRIT1.gApr07','chr1','-',40079972,40121693,40080002,40086321,8,0x34303037393937322C34303038323335392C34303038323738392C34303038353437382C34303038353830362C34303038363234342C34303038383338312C34303132313537362C,0x34303038303137322C34303038323437372C34303038323839392C34303038353535362C34303038353931392C34303038363335362C34303038383532302C34303132313639332C),
 (111,'TRIT1.jApr07','chr1','-',40079972,40121693,40080002,40086321,11,0x34303037393937322C34303038323335392C34303038323738392C34303038353437382C34303038353830362C34303038363234342C34303038383338312C34303039303938392C34303039323232382C34303039353533352C34303132313537362C,0x34303038303137322C34303038323437372C34303038323839392C34303038353535362C34303038353931392C34303038363335362C34303038383532302C34303039313133352C34303039323332372C34303039353637362C34303132313639332C),
 (111,'TRIT1.iApr07','chr1','-',40079972,40121760,40080002,40086321,10,0x34303037393937322C34303038323335392C34303038323738392C34303038353437382C34303038353830362C34303038363234342C34303038383338312C34303039323232382C34303039353533352C34303132313537362C,0x34303038303137322C34303038323437372C34303038323839392C34303038353535362C34303038353931392C34303038363335362C34303038383532302C34303039323332372C34303039353637362C34303132313736302C),
 (111,'TRIT1.fApr07','chr1','-',40079972,40121693,40080002,40086321,7,0x34303037393937322C34303038323335392C34303038323738392C34303038353437382C34303038353830362C34303038363234342C34303132313537362C,0x34303038303137322C34303038323437372C34303038323839392C34303038353535362C34303038353931392C34303038363335362C34303132313639332C),
 (111,'TRIT1.veApr07','chr1','-',40085478,40121734,0,0,8,0x34303038353437382C34303038353830362C34303038363234342C34303038383338312C34303039323232382C34303039353533352C34303131343332302C34303132313537362C,0x34303038353535362C34303038353931392C34303038363335362C34303038383532302C34303039323332372C34303039353637362C34303131343339312C34303132313733342C),
 (111,'TRIT1.sApr07','chr1','-',40085852,40121762,40086350,40095607,8,0x34303038353835322C34303038363234342C34303038383338312C34303039303938392C34303039323232382C34303039353533352C34303130313034362C34303132313537362C,0x34303038363030362C34303038363335362C34303038383532302C34303039313133352C34303039323332372C34303039353637362C34303130313139342C34303132313736322C),
 (111,'TRIT1.qApr07','chr1','-',40086299,40121753,40086350,40121750,4,0x34303038363239392C34303038383338312C34303039303938392C34303132313537362C,0x34303038363335362C34303038383532302C34303039313133352C34303132313735332C),
 (111,'TRIT1.tApr07','chr1','-',40088362,40121752,40088502,40121750,4,0x34303038383336322C34303039323232382C34303039353533352C34303132313537362C,0x34303038383532302C34303039323332372C34303039353637362C34303132313735322C),
 (111,'TRIT1.rApr07','chr1','-',40091068,40121762,40091162,40121750,4,0x34303039313036382C34303039323232382C34303039353533352C34303132313537362C,0x34303039313231302C34303039323332372C34303039353637362C34303132313736322C),
 (111,'ZMPSTE24.aApr07','chr1','+',40496309,40532444,40496530,40530928,10,0x34303439363330392C34303439393039372C34303530363034342C34303530363637372C34303530383233332C34303531303135322C34303531393630312C34303532343138332C34303532393131322C34303533303730332C,0x34303439363635332C34303439393234342C34303530363133312C34303530363739342C34303530383338362C34303531303239342C34303531393738362C34303532343238382C34303532393235362C34303533323434342C),
 (111,'ZMPSTE24.cApr07','chr1','+',40496453,40510184,40496530,40510182,5,0x34303439363435332C34303439393039372C34303530363034342C34303530363637372C34303531303135322C,0x34303439363635332C34303439393234342C34303530363133312C34303530363739342C34303531303138342C),
 (111,'ZMPSTE24.gApr07','chr1','+',40496477,40506683,40496530,40501131,5,0x34303439363437372C34303439393039372C34303530313039322C34303530363034342C34303530363637372C,0x34303439363635332C34303439393234342C34303530313234322C34303530363133312C34303530363638332C),
 (111,'ZMPSTE24.eApr07','chr1','+',40496498,40506128,40496502,40499111,4,0x34303439363439382C34303439373630382C34303439393039372C34303530363034342C,0x34303439363635332C34303439373739312C34303439393234342C34303530363132382C),
 (111,'SMAP1L.lApr07','chr1','+',40583092,40651490,40646914,40651418,5,0x34303538333039322C34303634343939342C34303634363931312C34303634383031352C34303635313237342C,0x34303538333136392C34303634353132382C34303634363939372C34303634383039342C34303635313439302C),
 (111,'SMAP1L.eApr07','chr1','+',40583105,40653556,40600640,40653556,8,0x34303538333130352C34303630303535382C34303634343939342C34303634363931312C34303634383031352C34303635313237342C34303635323431372C34303635333533302C,0x34303538333136392C34303630303639352C34303634353132382C34303634363939372C34303634383039342C34303635313336312C34303635323439392C34303635333535362C),
 (111,'SMAP1L.dApr07','chr1','+',40600592,40653605,40600692,40653604,8,0x34303630303539322C34303631343030352C34303634343939342C34303634363931312C34303634383031352C34303635313237342C34303635323431372C34303635333533302C,0x34303630303639352C34303631343037352C34303634353132382C34303634363939372C34303634383039342C34303635313336312C34303635323439392C34303635333630352C),
 (111,'SMAP1L.aApr07','chr1','+',40611930,40661590,40611983,40660360,10,0x34303631313933302C34303634343939342C34303634363931312C34303634383031352C34303635313237342C34303635323431372C34303635333533302C34303635343433342C34303635353033382C34303636303233342C,0x34303631323438322C34303634353132382C34303634363939372C34303634383039342C34303635313336312C34303635323439392C34303635333634302C34303635343630302C34303635353335352C34303636313539302C),
 (111,'SMAP1L.jApr07','chr1','+',40612019,40641979,40612172,40641977,2,0x34303631323031392C34303634313934322C,0x34303631323438322C34303634313937392C),
 (111,'SMAP1L.bApr07','chr1','+',40612900,40661585,40612954,40660360,10,0x34303631323930302C34303634343939342C34303634363931312C34303634383031352C34303635313237342C34303635323431372C34303635333533302C34303635343433342C34303635353033382C34303636303233342C,0x34303631323936372C34303634353132382C34303634363939372C34303634383039342C34303635313336312C34303635323439392C34303635333634302C34303635343630302C34303635353335352C34303636313538352C),
 (111,'SMAP1L.iApr07','chr1','+',40619638,40651333,40641980,40651331,6,0x34303631393633382C34303634313934322C34303634343939342C34303634363931312C34303634383031352C34303635313237342C,0x34303631393639322C34303634323030352C34303634353132382C34303634363939372C34303634383039342C34303635313333332C),
 (111,'C1orf176andZNF684.aApr07','chr1','+',40747022,40786427,40771425,40785719,7,0x34303734373032322C34303734373939312C34303736393530332C34303737313430312C34303737383834342C34303737393837332C34303738343832302C,0x34303734373133362C34303734383034392C34303737303034362C34303737313434302C34303737383937312C34303737393936392C34303738363432372C),
 (111,'starvorbo.aApr07','chr1','-',40753827,40770234,0,0,4,0x34303735333832372C34303735353235332C34303736393439302C34303736393734362C,0x34303735343337382C34303735353433312C34303736393631342C34303737303233342C),
 (112,'KCNQ4.bApr07','chr1','+',41022270,41076947,41022352,41076782,13,0x34313032323237302C34313035353532332C34313035363432322C34313035363736332C34313035373630352C34313035383133332C34313035383432332C34313036303537322C34313036393334322C34313037313237322C34313037333232352C34313037353932332C34313037363536392C,0x34313032323636362C34313035353631342C34313035363534392C34313035363933392C34313035373733312C34313035383234342C34313035383531392C34313036303636312C34313036393536332C34313037313337322C34313037333335372C34313037363035332C34313037363934372C),
 (112,'KCNQ4.aApr07','chr1','+',41022270,41078711,41022352,41076782,14,0x34313032323237302C34313035353532332C34313035363432322C34313035363736332C34313035373630352C34313035383133332C34313035383432332C34313036303537322C34313036323335352C34313036393334322C34313037313237322C34313037333232352C34313037353932332C34313037363536392C,0x34313032323636362C34313035353631342C34313035363534392C34313035363933392C34313035373733312C34313035383234342C34313035383531392C34313036303636312C34313036323531372C34313036393536332C34313037313337322C34313037333335372C34313037363035332C34313037383731312C),
 (112,'SCMH1.aApr07','chr1','-',41265455,41480427,41266452,41390933,18,0x34313236353435352C34313236363834322C34313237323234312C34313237353632302C34313238343636352C34313238363934382C34313330383835332C34313331333437372C34313335313534312C34313335353138302C34313338313133362C34313338393837322C34313339303835372C34313339373938332C34313339393133332C34313339393632322C34313432343337392C34313438303331372C,0x34313236363537382C34313236363938352C34313237323330372C34313237353830302C34313238343835372C34313238373134392C34313330383938302C34313331333731302C34313335313738352C34313335353236392C34313338313337312C34313338393934332C34313339313030302C34313339383139322C34313339393135372C34313339393639312C34313432343530392C34313438303432372C),
 (112,'SCMH1.dApr07','chr1','-',41265457,41480374,41266452,41397989,15,0x34313236353435372C34313236363834322C34313237353632302C34313238343636352C34313238363934382C34313330383835332C34313331333437372C34313335313534312C34313335353138302C34313338313133362C34313339373938332C34313339393133332C34313339393632322C34313432343337392C34313438303331372C,0x34313236363537382C34313236363938352C34313237353830302C34313238343835372C34313238373134392C34313330383938302C34313331333731302C34313335313738352C34313335353236392C34313338313337312C34313339383139322C34313339393135372C34313339393639312C34313432343530392C34313438303337342C),
 (112,'SCMH1.eApr07','chr1','-',41265459,41480401,41266452,41381335,14,0x34313236353435392C34313236363834322C34313237353632302C34313238343636352C34313238363934382C34313330383835332C34313331333437372C34313335313534312C34313335353138302C34313338313133362C34313339393133332C34313339393632322C34313432343337392C34313438303331372C,0x34313236363537382C34313236363938352C34313237353830302C34313238343835372C34313238373134392C34313330383938302C34313331333731302C34313335313738352C34313335353236392C34313338313337312C34313339393135372C34313339393639312C34313432343530392C34313438303430312C),
 (112,'SCMH1.gApr07','chr1','-',41265460,41398178,41279739,41313630,11,0x34313236353436302C34313236363431352C34313236363834322C34313237323234312C34313237353632302C34313237393536392C34313238343637362C34313238363934382C34313330383835332C34313331333437372C34313339373938332C,0x34313236353733342C34313236363537382C34313236363938352C34313237323330372C34313237353830302C34313237393832342C34313238343835372C34313238373134392C34313330383938302C34313331333731302C34313339383137382C),
 (112,'SCMH1.fApr07','chr1','-',41265463,41480377,41266452,41381335,16,0x34313236353436332C34313236363834322C34313237353632302C34313238343636352C34313238363934382C34313330383835332C34313331333437372C34313335313534312C34313335353138302C34313338313133362C34313338393837322C34313339373938332C34313339393133332C34313339393632322C34313432343337392C34313438303331372C,0x34313236363537382C34313236363938352C34313237353830302C34313238343835372C34313238373134392C34313330383938302C34313331333731302C34313335313738352C34313335353236392C34313338313337312C34313338393934332C34313339383139322C34313339393135372C34313339393639312C34313432343530392C34313438303337372C),
 (112,'SCMH1.bApr07','chr1','-',41265463,41480401,41266452,41424392,15,0x34313236353436332C34313236363834322C34313237353632302C34313238343636352C34313238363934382C34313330383835332C34313331333437372C34313335313534312C34313335353138302C34313338313133362C34313338393837322C34313339393133332C34313339393632322C34313432343337392C34313438303331372C,0x34313236363537382C34313236363938352C34313237353830302C34313238343835372C34313238373134392C34313330383938302C34313331333731302C34313335313738352C34313335353236392C34313338313337312C34313338393934332C34313339393135372C34313339393639312C34313432343530392C34313438303430312C),
 (112,'SCMH1.cApr07','chr1','-',41265481,41401286,41266452,41381335,15,0x34313236353438312C34313236363834322C34313237323234312C34313237353632302C34313238343636352C34313238363934382C34313330383835332C34313331333437372C34313335313534312C34313335353138302C34313338313133362C34313338393837322C34313339393133332C34313339393632322C34313430313033372C,0x34313236363537382C34313236363938352C34313237323330372C34313237353830302C34313238343835372C34313238373134392C34313330383938302C34313331333731302C34313335313738352C34313335353236392C34313338313337312C34313338393934332C34313339393135372C34313339393639312C34313430313238362C),
 (112,'SCMH1.kApr07','chr1','-',41279574,41480375,41351785,41390933,14,0x34313237393537342C34313238343636352C34313238363934382C34313330383835332C34313335313534312C34313335353138302C34313338313133362C34313338393837322C34313339303835372C34313339373938332C34313339393133332C34313339393632322C34313432343337392C34313438303331372C,0x34313237393832342C34313238343835372C34313238373134392C34313330383938302C34313335313831322C34313335353236392C34313338313337312C34313338393934332C34313339313030302C34313339383139322C34313339393135342C34313339393639312C34313432343530392C34313438303337352C),
 (112,'SCMH1.jApr07','chr1','-',41347915,41480370,41351785,41390933,10,0x34313334373931352C34313335313534312C34313335353138302C34313338313133362C34313338393837322C34313339303835372C34313339393133332C34313339393632322C34313432343337392C34313438303331372C,0x34313334373937332C34313335313831322C34313335353236392C34313338313337312C34313338393934332C34313339313030302C34313339393135372C34313339393639312C34313432343530392C34313438303337302C),
 (112,'SCMH1.oApr07','chr1','-',41381229,41480337,41381230,41424392,6,0x34313338313232392C34313338393837322C34313339393133332C34313339393632322C34313432343337392C34313438303331372C,0x34313338313337312C34313338393934332C34313339393135342C34313339393639312C34313432343530392C34313438303333372C),
 (112,'SCMH1.vaApr07','chr1','-',41381346,41424402,0,0,7,0x34313338313334362C34313338343332302C34313338393837322C34313339373938332C34313339393133332C34313339393632322C34313432343337392C,0x34313338313337312C34313338343434342C34313338393934332C34313339383139322C34313339393135372C34313339393639312C34313432343430322C),
 (112,'SCMH1.sApr07','chr1','-',41384325,41480363,0,0,8,0x34313338343332352C34313338393837322C34313339303835372C34313339373938332C34313339393133332C34313339393632322C34313432343337392C34313438303331372C,0x34313338343434342C34313338393934332C34313339313030302C34313339383139322C34313339393135372C34313339393639312C34313432343530392C34313438303336332C),
 (112,'SCMH1.uApr07','chr1','-',41389886,41480372,0,0,6,0x34313338393838362C34313339303835372C34313339373938332C34313339393133332C34313339393632322C34313438303331372C,0x34313338393934332C34313339313030302C34313339383139322C34313339393135372C34313339393639312C34313438303337322C),
 (112,'SCMH1.vdApr07','chr1','-',41401215,41480346,0,0,3,0x34313430313231352C34313432343337392C34313438303331372C,0x34313430313233382C34313432343530392C34313438303334362C),
 (112,'gorpla.aApr07','chr1','+',41480644,41572772,41480726,41572717,2,0x34313438303634342C34313537323637312C,0x34313438303936352C34313537323737322C),
 (112,'HIVEP3.bApr07','chr1','-',41744622,41939259,41748708,41823055,8,0x34313734343632322C34313735313037332C34313735363635392C34313736323939322C34313831333830312C34313831373939342C34313836373030362C34313933393137332C,0x34313734393532342C34313735323030382C34313735363734362C34313736333136382C34313831333934372C34313832333537362C34313836373230352C34313933393235392C),
 (112,'HIVEP3.cApr07','chr1','-',41748487,41818157,41748708,41813856,5,0x34313734383438372C34313735313037332C34313735363635392C34313831333830312C34313831373939342C,0x34313734393532342C34313735323030382C34313735363734362C34313831333934372C34313831383135372C),
 (112,'HIVEP3.eApr07','chr1','-',41782295,41815659,41782511,41815513,3,0x34313738323239352C34313831333830312C34313831353439352C,0x34313738323534382C34313831333934372C34313831353635392C),
 (113,'HIVEP3.hApr07','chr1','-',42085444,42274183,0,0,4,0x34323038353434342C34323038373132382C34323135363637302C34323237343036342C,0x34323038363730332C34323038373334372C34323135363738322C34323237343138332C),
 (113,'HIVEP3.iApr07','chr1','-',42086167,42274198,0,0,4,0x34323038363136372C34323038373132382C34323135363637302C34323237343036342C,0x34323038363730332C34323038373239332C34323135363738322C34323237343139382C),
 (113,'FOXJ3.cApr07','chr1','-',42414792,42573223,42417967,42549351,15,0x34323431343739322C34323432303137342C34323432363939342C34323432373536302C34323432393536302C34323433333134372C34323433373335392C34323434343031392C34323436363134302C34323530333337322C34323531363630352C34323534393330372C34323535333630332C34323536313934312C34323537333138322C,0x34323431383038332C34323432303238322C34323432373138362C34323432373636322C34323432393937372C34323433333332322C34323433373438382C34323434343132312C34323436363232342C34323530333434372C34323531363933302C34323534393336382C34323535333731332C34323536323038352C34323537333232332C),
 (113,'FOXJ3.aApr07','chr1','-',42414800,42573490,42417967,42549351,13,0x34323431343830302C34323432303137342C34323432363939342C34323432373536302C34323432393536302C34323433333134372C34323433373335392C34323434343031392C34323436363134302C34323530333337322C34323531363630352C34323534393330372C34323537333331362C,0x34323431383038332C34323432303238322C34323432373138362C34323432373636322C34323432393937372C34323433333332322C34323433373438382C34323434343132312C34323436363232342C34323530333434372C34323531363933302C34323534393336382C34323537333439302C),
 (113,'FOXJ3.bApr07','chr1','-',42417598,42574138,42417967,42549351,13,0x34323431373539382C34323432303137342C34323432363939342C34323432373536302C34323432393536302C34323433333134372C34323433373335392C34323434343031392C34323436363134302C34323530333337322C34323531363630352C34323534393330372C34323537333838332C,0x34323431383038332C34323432303238322C34323432373138362C34323432373636322C34323432393937372C34323433333332322C34323433373438382C34323434343132312C34323436363232342C34323530333434372C34323531363933302C34323534393336382C34323537343133382C),
 (113,'FOXJ3.dApr07','chr1','-',42429663,42573490,42429663,42549351,8,0x34323432393636332C34323433333134372C34323433373335392C34323436363134302C34323530333337322C34323531363630352C34323534393330372C34323537333331362C,0x34323432393937372C34323433333332322C34323433373438382C34323436363232342C34323530333434372C34323531363933302C34323534393336382C34323537333439302C),
 (113,'FOXJ3.gApr07','chr1','-',42466195,42573478,42466197,42516929,5,0x34323436363139352C34323530333337322C34323531363630352C34323534393330372C34323537333331362C,0x34323436363232342C34323530333434372C34323531373034322C34323534393336382C34323537333437382C),
 (113,'PPCSandRP4-692D3.1.kApr07','chr1','+',42701547,42776227,42718809,42773188,8,0x34323730313534372C34323731383731382C34323732303932302C34323732383431352C34323733353335352C34323733373037352C34323737333134362C34323737343733332C,0x34323730323135362C34323731383832342C34323732313037342C34323732383438372C34323733353437312C34323733373137342C34323737333234372C34323737363232372C),
 (113,'PPCSandRP4-692D3.1.cApr07','chr1','+',42701611,42892448,42815328,42892286,23,0x34323730313631312C34323731313337392C34323731383731382C34323732303932302C34323732383431352C34323733353335352C34323733373037352C34323737333134362C34323737343733332C34323738333636372C34323739343431332C34323739363339362C34323830343535332C34323831353237372C34323831393631372C34323832373537382C34323834393233352C34323837353439342C34323838303733302C34323838323935302C34323838343339322C34323839313633332C34323839323037352C,0x34323730313931352C34323731313536312C34323731383832342C34323732313037342C34323732383438372C34323733353437312C34323733373137342C34323737333234372C34323737343835392C34323738333833372C34323739343636332C34323739363533342C34323830343733332C34323831353438372C34323831393737322C34323832373734312C34323834393334382C34323837353633362C34323838303836372C34323838333036352C34323838343537352C34323839313730312C34323839323434382C),
 (113,'PPCSandRP4-692D3.1.pApr07','chr1','+',42701783,42737174,42720977,42737174,5,0x34323730313738332C34323732303932302C34323732383431352C34323733353335352C34323733373037352C,0x34323730313931352C34323732313037342C34323732383438372C34323733353437312C34323733373137342C),
 (113,'PPCSandRP4-692D3.1.bApr07','chr1','+',42728186,42892448,42759472,42892286,15,0x34323732383138362C34323733353335352C34323733373037352C34323735393432302C34323830343535332C34323831353237372C34323831393631372C34323832373537382C34323834393233352C34323837353439342C34323838303733302C34323838323935302C34323838343339322C34323839313633332C34323839323037352C,0x34323732383438372C34323733353437312C34323733373137342C34323735393531342C34323830343733332C34323831353438372C34323831393737322C34323832373734312C34323834393334382C34323837353633362C34323838303836372C34323838333036352C34323838343537352C34323839313730312C34323839323434382C),
 (113,'PPCSandRP4-692D3.1.aApr07','chr1','+',42772128,42892598,42774742,42892286,16,0x34323737323132382C34323737343733332C34323737373433302C34323738333636372C34323739343431332C34323830343535332C34323831353237372C34323831393631372C34323832373537382C34323834393233352C34323837353439342C34323838303733302C34323838323935302C34323838343339322C34323839313633332C34323839323037352C,0x34323737323230392C34323737343835392C34323737373536382C34323738333833372C34323739343636332C34323830343733332C34323831353438372C34323831393737322C34323832373734312C34323834393334382C34323837353633362C34323838303836372C34323838333036352C34323838343537352C34323839313730312C34323839323539382C),
 (113,'PPCSandRP4-692D3.1.viApr07','chr1','+',42849296,42883065,0,0,3,0x34323834393239362C34323838303733302C34323838323935302C,0x34323834393334382C34323838303836372C34323838333036352C),
 (114,'moyboy.aApr07','chr1','+',43095879,43127051,43095948,43124952,4,0x34333039353837392C34333130383334322C34333131383631312C34333132343932392C,0x34333039353936362C34333130383431392C34333131383639312C34333132373035312C),
 (114,'hCG_23177.cApr07','chr1','+',43358320,43394654,43383506,43394571,6,0x34333335383332302C34333338333132322C34333338333338342C34333338393031382C34333339313038352C34333339343436332C,0x34333335383533302C34333338333236322C34333338333535352C34333338393037382C34333339313138392C34333339343635342C),
 (114,'hCG_23177.eApr07','chr1','+',43358422,43394654,43358422,43394571,3,0x34333335383432322C34333338393031382C34333339343436332C,0x34333335383533302C34333338393037382C34333339343635342C),
 (114,'C1orf84andKIAA0467.iApr07','chr1','+',43628142,43651049,43628226,43647759,6,0x34333632383134322C34333634313433342C34333634313835382C34333634323633372C34333634373735302C34333635303234382C,0x34333632383235332C34333634313536302C34333634323033322C34333634323830382C34333634383537392C34333635313034392C),
 (114,'C1orf84andKIAA0467.bApr07','chr1','+',43628142,43667889,43628226,43664715,27,0x34333632383134322C34333634313433342C34333634313835382C34333634323633372C34333635333333392C34333635343231372C34333635343739322C34333635373939312C34333635383431302C34333635393030362C34333635393433312C34333636303334302C34333636303733372C34333636313032362C34333636313335362C34333636323437342C34333636333034312C34333636333337302C34333636333733312C34333636343039322C34333636343239352C34333636343639352C34333636343937322C34333636353331332C34333636353533382C34333636353738372C34333636363439372C,0x34333632383235332C34333634313536302C34333634323033322C34333634323830382C34333635333437312C34333635343335392C34333635343839392C34333635383230322C34333635383538312C34333635393234312C34333635393536312C34333636303438332C34333636303839302C34333636313134312C34333636313537342C34333636323639302C34333636333132302C34333636333436352C34333636333930302C34333636343230372C34333636343430392C34333636343739362C34333636353036372C34333636353433372C34333636353730332C34333636363337362C34333636373838392C),
 (114,'C1orf84andKIAA0467.hApr07','chr1','+',43628199,43648812,43628199,43647759,5,0x34333632383139392C34333634313433342C34333634313835382C34333634323633372C34333634373735302C,0x34333632383235332C34333634313536302C34333634323033322C34333634323830382C34333634383831322C),
 (114,'PTPRF.jApr07','chr1','+',43763352,43818319,43783333,43817543,9,0x34333736333335322C34333736363931342C34333737363435352C34333738333238382C34333739313734392C34333739323035372C34333830373834372C34333831373036372C34333831373433332C,0x34333736333530312C34333736373031342C34333737363533352C34333738333432342C34333739313839352C34333739323139392C34333830383033362C34333831373137382C34333831383331392C);
INSERT INTO `aceview_hg18_housekeeping` (`bin`,`name`,`chrom`,`strand`,`txStart`,`txEnd`,`cdsStart`,`cdsEnd`,`exonCount`,`exonStarts`,`exonEnds`) VALUES 
 (114,'PTPRF.vgApr07','chr1','+',43763442,43791777,0,0,5,0x34333736333434322C34333736363931342C34333737363435352C34333738333238382C34333739313734392C,0x34333736333531352C34333736373031342C34333737363533352C34333738333432342C34333739313737372C),
 (114,'PTPRF.iApr07','chr1','+',43764295,43818336,43783333,43817543,8,0x34333736343239352C34333736363931342C34333737363435352C34333738333238382C34333739313734392C34333739323035372C34333830373834372C34333831373036372C,0x34333736343430332C34333736373031342C34333737363533352C34333738333432342C34333739313839352C34333739323139392C34333830383033362C34333831383333362C),
 (114,'PTPRF.veApr07','chr1','+',43766819,43791797,0,0,4,0x34333736363831392C34333737363435352C34333738333238382C34333739313734392C,0x34333736373031342C34333737363533352C34333738333432342C34333739313739372C),
 (114,'PTPRF.bApr07','chr1','+',43769133,43861930,43783333,43860261,33,0x34333736393133332C34333737363435352C34333738333238382C34333739313734392C34333739323035372C34333830373834372C34333831373036372C34333832363938382C34333832393232392C34333833303036392C34333833303731342C34333833363030352C34333833363937372C34333834313637332C34333834313836382C34333834333136302C34333834333434372C34333834333738362C34333834343439372C34333834353037312C34333834373634302C34333835313837352C34333835353730322C34333835353939332C34333835363838372C34333835373330352C34333835373534352C34333835373933372C34333835383335322C34333835383731312C34333835393039352C34333835393335342C34333836303139322C,0x34333736393334382C34333737363533352C34333738333432342C34333739313839352C34333739323139392C34333830383033362C34333831373137382C34333832373235382C34333832393831312C34333833303230362C34333833303835392C34333833363331312C34333833373137312C34333834313739312C34333834323434372C34333834333235382C34333834333730312C34333834333838302C34333834343731362C34333834353232362C34333834373735362C34333835313937332C34333835353832362C34333835363136392C34333835373030372C34333835373436302C34333835373833312C34333835383131362C34333835383437392C34333835383833372C34333835393235302C34333835393439302C34333836313933302C),
 (114,'PTPRF.aApr07','chr1','+',43769133,43861930,43783333,43860261,34,0x34333736393133332C34333737363435352C34333738333238382C34333739313734392C34333739323035372C34333830373834372C34333831373036372C34333832363938382C34333832393232392C34333833303036392C34333833303731342C34333833363030352C34333833363937372C34333834303332382C34333834313637332C34333834313836382C34333834333136302C34333834333434372C34333834333738362C34333834343439372C34333834353037312C34333834373634302C34333835313837352C34333835353730322C34333835353939332C34333835363838372C34333835373330352C34333835373534352C34333835373933372C34333835383335322C34333835383731312C34333835393039352C34333835393335342C34333836303139322C,0x34333736393334382C34333737363533352C34333738333432342C34333739313839352C34333739323139392C34333830383033362C34333831373137382C34333832373235382C34333832393831312C34333833303230362C34333833303835392C34333833363331312C34333833373137312C34333834303335352C34333834313739312C34333834323434372C34333834333235382C34333834333730312C34333834333838302C34333834343731362C34333834353232362C34333834373735362C34333835313937332C34333835353832362C34333835363136392C34333835373030372C34333835373436302C34333835373833312C34333835383131362C34333835383437392C34333835383833372C34333835393235302C34333835393439302C34333836313933302C),
 (114,'PTPRF.hApr07','chr1','+',43769154,43818336,43783333,43817543,8,0x34333736393135342C34333737363435352C34333738333238382C34333739313734392C34333739323035372C34333830373834372C34333831343136372C34333831373036372C,0x34333736393334382C34333737363533352C34333738333432342C34333739313839352C34333739323139392C34333830383033362C34333831343138352C34333831383333362C),
 (114,'JMJD2A.aApr07','chr1','+',43888392,43944014,43891433,43942628,22,0x34333838383339322C34333839313339342C34333839333834382C34333839383535352C34333930313135312C34333930333935332C34333930343730392C34333930353231312C34333930363032392C34333930373335372C34333930393736322C34333932313934312C34333932373137312C34333932393130322C34333932393735332C34333933303531332C34333933323235312C34333933323936362C34333933363130302C34333934313837342C34333934323237372C34333934323438372C,0x34333838383531302C34333839313537312C34333839343032342C34333839383637302C34333930313334352C34333930343030332C34333930343831332C34333930353334392C34333930363237372C34333930373535372C34333931303133332C34333932323036322C34333932373335332C34333932393330372C34333932393833302C34333933303536392C34333933323336302C34333933333135322C34333933363237312C34333934313939342C34333934323337302C34333934343031342C),
 (115,'plalybo.aApr07','chr1','+',44282186,44343234,0,0,7,0x34343238323138362C34343238343330352C34343238363631362C34343238393230382C34343239393339302C34343333393831382C34343334313537362C,0x34343238323237302C34343238343338312C34343238363734352C34343238393735332C34343239393438362C34343333393837342C34343334333233342C),
 (115,'plalybo.dApr07','chr1','+',44286635,44314671,0,0,3,0x34343238363633352C34343238393534382C34343331343334392C,0x34343238363734352C34343238393739302C34343331343637312C),
 (115,'plalybo.cApr07','chr1','+',44286650,44314675,0,0,4,0x34343238363635302C34343238393534382C34343331333039362C34343331343334392C,0x34343238363734352C34343238393735332C34343331333232322C34343331343637352C),
 (115,'plalybo.fApr07','chr1','+',44286699,44352171,0,0,5,0x34343238363639392C34343238393534382C34343333393831382C34343335313439332C34343335323037392C,0x34343238363734352C34343238393735332C34343333393837342C34343335313635302C34343335323137312C),
 (115,'plalybo.bApr07','chr1','+',44289373,44314727,0,0,2,0x34343238393337332C34343331343334392C,0x34343238393735332C34343331343732372C),
 (115,'plalybo.gApr07','chr1','+',44289530,44314408,0,0,2,0x34343238393533302C34343331343334392C,0x34343238393739302C34343331343430382C),
 (115,'PRNPIP.rApr07','chr1','-',44412833,44593525,44413034,44557961,8,0x34343431323833332C34343431323936332C34343532333039332C34343534363536382C34343535313432372C34343535373838362C34343539313130382C34343539333531382C,0x34343431323838302C34343431333035352C34343532333136362C34343534363636302C34343535313438372C34343535383030332C34343539313138342C34343539333532352C),
 (115,'PRNPIP.bApr07','chr1','-',44459328,44593525,44459816,44593489,9,0x34343435393332382C34343438363139372C34343532333039332C34343534363536382C34343535313432372C34343535373838362C34343537373330332C34343539313130382C34343539333135302C,0x34343435393839392C34343438363239372C34343532333136362C34343534363636302C34343535313438372C34343535383030332C34343537373538312C34343539313138342C34343539333532352C),
 (115,'PRNPIP.sApr07','chr1','-',44459350,44593530,44459816,44593530,4,0x34343435393335302C34343438363139372C34343532333039332C34343539333531302C,0x34343435393839392C34343438363239372C34343532333136362C34343539333533302C),
 (115,'PRNPIP.eApr07','chr1','-',44459350,44593537,44480181,44593536,10,0x34343435393335302C34343438303137332C34343438363139372C34343532333039332C34343534363536382C34343535313432372C34343535373838362C34343537373330332C34343539313130382C34343539333531382C,0x34343435393839392C34343438303333392C34343438363239372C34343532333136362C34343534363636302C34343535313438372C34343535383030332C34343537373538312C34343539313138342C34343539333533372C),
 (115,'PRNPIP.jApr07','chr1','-',44459352,44593485,44459869,44577558,7,0x34343435393335322C34343532333039332C34343534363536382C34343535313432372C34343535373838362C34343537373330332C34343539333135302C,0x34343435393839392C34343532333136362C34343534363636302C34343535313438372C34343535383030332C34343537373538312C34343539333438352C),
 (115,'PRNPIP.aApr07','chr1','-',44459372,44593492,44459816,44593492,10,0x34343435393337322C34343438363139372C34343532323234342C34343532333039332C34343534363536382C34343535313432372C34343535373838362C34343537373330332C34343539313130382C34343539333135302C,0x34343435393839392C34343438363239372C34343532323332382C34343532333136362C34343534363636302C34343535313438372C34343535383030332C34343537373538312C34343539313138342C34343539333439322C),
 (115,'PRNPIP.fApr07','chr1','-',44459386,44593501,44459816,44577558,8,0x34343435393338362C34343438363139372C34343532333039332C34343534363536382C34343535313432372C34343535373838362C34343537373330332C34343539333135302C,0x34343435393839392C34343438363239372C34343532333136362C34343534363636302C34343535313438372C34343535383030332C34343537373538312C34343539333530312C),
 (115,'PRNPIP.oApr07','chr1','-',44459392,44593527,44459816,44557961,8,0x34343435393339322C34343438363139372C34343532333039332C34343534363536382C34343535313432372C34343535373838362C34343539313130382C34343539333531382C,0x34343435393839392C34343438363239372C34343532333136362C34343534363636302C34343535313438372C34343535383030332C34343539313138342C34343539333532372C),
 (115,'PRNPIP.cApr07','chr1','-',44459398,44593521,44459816,44593521,9,0x34343435393339382C34343438363139372C34343532333039332C34343534363536382C34343535313432372C34343535373838362C34343537373330332C34343539313130382C34343539333531382C,0x34343435393839392C34343438363239372C34343532333136362C34343534363636302C34343535313438372C34343535383030332C34343537373538312C34343539313138342C34343539333532312C),
 (115,'PRNPIP.qApr07','chr1','-',44459594,44593542,44459816,44593542,6,0x34343435393539342C34343438363139372C34343532333039332C34343534363536382C34343535313432372C34343539333531382C,0x34343435393839392C34343438363239372C34343532333136362C34343534363636302C34343535313438372C34343539333534322C),
 (115,'PRNPIP.hApr07','chr1','-',44459744,44591531,44459869,44591202,7,0x34343435393734342C34343532333039332C34343534363536382C34343535313432372C34343535373838362C34343537373330332C34343539313130382C,0x34343435393839392C34343532333136362C34343534363636302C34343535313438372C34343535383030332C34343537373538312C34343539313533312C),
 (115,'PRNPIP.gApr07','chr1','-',44459751,44593530,44459816,44577558,8,0x34343435393735312C34343438363139372C34343532333039332C34343534363536382C34343535313432372C34343535373838362C34343537373330332C34343539333531382C,0x34343435393839392C34343438363239372C34343532333136362C34343534363636302C34343535313438372C34343535383030332C34343537373538312C34343539333533302C),
 (115,'PRNPIP.dApr07','chr1','-',44485846,44593510,44486120,44593510,6,0x34343438353834362C34343532333039332C34343534363536382C34343535313432372C34343535373838362C34343539333135302C,0x34343438363239372C34343532333136362C34343534363636302C34343535313438372C34343535383030332C34343539333531302C),
 (115,'PRNPIP.lApr07','chr1','-',44525087,44593528,44525142,44577558,6,0x34343532353038372C34343534363536382C34343535313432372C34343535373838362C34343537373330332C34343539333531382C,0x34343532353135322C34343534363636302C34343535313438372C34343535383030332C34343537373538312C34343539333532382C),
 (115,'PRNPIP.tApr07','chr1','-',44546568,44591295,44546570,44557961,4,0x34343534363536382C34343535313432372C34343535373838362C34343539313130382C,0x34343534363636302C34343535313438372C34343535383030332C34343539313239352C),
 (115,'PRNPIP.kApr07','chr1','-',44546568,44591145,44546570,44591145,5,0x34343534363536382C34343535313432372C34343535373838362C34343537373330332C34343539313130382C,0x34343534363636302C34343535313438372C34343535383030332C34343537373537352C34343539313134352C),
 (115,'PRNPIP.pApr07','chr1','-',44557918,44593473,44557950,44593471,3,0x34343535373931382C34343539313130382C34343539333135302C,0x34343535383030332C34343539313138342C34343539333437332C),
 (115,'C1orf164.aApr07','chr1','+',44643418,44889982,44650356,44889034,15,0x34343634333431382C34343635303233392C34343835323432332C34343836313030302C34343836343535352C34343837303630312C34343837333830332C34343837343238382C34343838323935362C34343838333235332C34343838333437392C34343838333636382C34343838373931392C34343838383134312C34343838383936322C,0x34343634333738352C34343635303938312C34343835323535362C34343836313034362C34343836343635372C34343837303634342C34343837333834372C34343837343432312C34343838333035332C34343838333334302C34343838333533352C34343838333734372C34343838383032382C34343838383231362C34343838393938322C),
 (115,'C1orf164.bApr07','chr1','+',44643512,44889985,44650356,44889034,15,0x34343634333531322C34343635303233392C34343835323432332C34343836313030302C34343836343535352C34343837303630312C34343837333830332C34343837343238382C34343838323935362C34343838333235332C34343838333437392C34343838333636382C34343838373931392C34343838383134312C34343838383936322C,0x34343634333738392C34343635303938312C34343835323535362C34343836313034362C34343836343635372C34343837303634342C34343837333834372C34343837343432312C34343838333035332C34343838333334302C34343838333533352C34343838333734372C34343838383032382C34343838383231362C34343838393938352C),
 (115,'TMEM53.fApr07','chr1','-',44874105,44960297,44874668,44960295,5,0x34343837343130352C34343838333631382C34343839383433322C34343934353536392C34343936303231372C,0x34343837343731362C34343838333732332C34343839383535342C34343934353634382C34343936303239372C),
 (115,'MGC33556.iApr07','chr1','+',44912947,44963617,44962816,44963617,9,0x34343931323934372C34343932373933342C34343933313138362C34343934323334372C34343936323338302C34343936323537382C34343936333032302C34343936333339342C34343936333534392C,0x34343931333133322C34343932383133332C34343933313237392C34343934323433322C34343936323530332C34343936323932372C34343936333039382C34343936333437362C34343936333631372C),
 (115,'MGC33556.bApr07','chr1','+',44912976,44963850,44927956,44962655,10,0x34343931323937362C34343932373933342C34343933353336302C34343933363332312C34343933393138312C34343934323334372C34343936323338302C34343936323537382C34343936333033322C34343936333534392C,0x34343931333133322C34343932383136322C34343933353432392C34343933363438382C34343933393337382C34343934323433322C34343936323530332C34343936323932372C34343936333437362C34343936333835302C),
 (115,'MGC33556.aApr07','chr1','+',44913013,44964367,44927956,44963662,13,0x34343931333031332C34343932373336372C34343932373933342C34343933353336302C34343933363332312C34343933393138312C34343934323334372C34343936323338302C34343936323537382C34343936323739372C34343936333032302C34343936333339342C34343936333534392C,0x34343931333133322C34343932373438332C34343932383136322C34343933353432392C34343933363438382C34343933393337382C34343934323433322C34343936323530332C34343936323635312C34343936323932372C34343936333039382C34343936333437362C34343936343336372C),
 (115,'MGC33556.cApr07','chr1','+',44913016,44963557,44913122,44963405,7,0x34343931333031362C34343933393138312C34343934323334372C34343936323338302C34343936323537382C34343936333133342C34343936333534392C,0x34343931333133322C34343933393337382C34343934323433322C34343936323530332C34343936323635312C34343936333437362C34343936333535372C),
 (115,'MGC33556.oApr07','chr1','+',44913035,44962602,0,0,6,0x34343931333033352C34343932383030302C34343933393138312C34343934323334372C34343936323338302C34343936323537382C,0x34343931333133322C34343932383133332C34343933393337382C34343934323433322C34343936323530332C34343936323630322C),
 (115,'TMEM53.kApr07','chr1','-',44926813,44970440,44939660,44960277,5,0x34343932363831332C34343933393434302C34343934353536392C34343936303231372C34343937303236302C,0x34343932363835372C34343933393835342C34343934353634382C34343936303239382C34343937303434302C),
 (115,'MGC33556.gApr07','chr1','+',44928092,44962639,44928093,44962639,5,0x34343932383039322C34343933393138312C34343934323334372C34343936323338302C34343936323539352C,0x34343932383133332C34343933393337382C34343934323433322C34343936323530332C34343936323633392C),
 (115,'MGC33556.mApr07','chr1','+',44939231,44963232,0,0,3,0x34343933393233312C34343936323338302C34343936323537382C,0x34343933393337382C34343936323530332C34343936333233322C),
 (116,'EIF2B3.aApr07','chr1','-',45089116,45224849,45089209,45224847,11,0x34353038393131362C34353039353936322C34353131323933362C34353131383037362C34353131393837302C34353133353631332C34353136343838362C34353137393736342C34353231363537332C34353231393237392C34353232343735312C,0x34353038393236322C34353039363036362C34353131333038352C34353131383236372C34353131393939382C34353133353730332C34353136343939382C34353137393932342C34353231363731392C34353231393433362C34353232343834392C),
 (116,'EIF2B3.dApr07','chr1','-',45112780,45224980,45112899,45219427,10,0x34353131323738302C34353131333837362C34353131383037362C34353131393837302C34353133353631332C34353136343838362C34353137393736342C34353231363537332C34353231393237392C34353232343735312C,0x34353131333038352C34353131333935342C34353131383236372C34353131393939382C34353133353730332C34353136343939382C34353137393932342C34353231363731392C34353231393433362C34353232343938302C),
 (116,'EIF2B3.gApr07','chr1','-',45163217,45224853,45208281,45224853,8,0x34353136333231372C34353136343838362C34353137393736342C34353230383233362C34353231303733352C34353231363537332C34353231393237392C34353232343735312C,0x34353136333534392C34353136343939382C34353137393932342C34353230383330332C34353231303833332C34353231363731392C34353231393433362C34353232343835332C),
 (116,'EIF2B3.fApr07','chr1','-',45174263,45224837,45174352,45224835,6,0x34353137343236332C34353137353531352C34353137393736342C34353231363537332C34353231393237392C34353232343735312C,0x34353137343335352C34353137353630372C34353137393932342C34353231363731392C34353231393433362C34353232343833372C),
 (116,'EIF2B3.eApr07','chr1','-',45178887,45224860,45178888,45224859,5,0x34353137383838372C34353137393736342C34353231363537332C34353231393237392C34353232343735312C,0x34353137393032352C34353137393932342C34353231363731392C34353231393433362C34353232343836302C),
 (116,'EIF2B3.hApr07','chr1','-',45179818,45224858,45179898,45224856,5,0x34353137393831382C34353230383233362C34353231363537332C34353231393237392C34353232343735312C,0x34353137393932342C34353230383330332C34353231363731392C34353231393433362C34353232343835382C),
 (116,'EIF2B3.iApr07','chr1','-',45196821,45224900,45197019,45219427,4,0x34353139363832312C34353231363537332C34353231393237392C34353232343735312C,0x34353139373136362C34353231363731392C34353231393433362C34353232343930302C),
 (116,'EIF2B3.jApr07','chr1','-',45216348,45224842,45216537,45224841,3,0x34353231363334382C34353231393237392C34353232343735312C,0x34353231363731392C34353231393433362C34353232343834322C),
 (116,'ZSWIM5.aApr07','chr1','-',45254653,45444884,45256712,45444882,14,0x34353235343635332C34353235383332342C34353235383838332C34353237323537302C34353237333934362C34353237343239372C34353237373139342C34353237383635302C34353238313437372C34353238393333322C34353239363836372C34353239383335372C34353332363133392C34353434343031342C,0x34353235373537352C34353235383430362C34353235393034372C34353237323732382C34353237343038322C34353237343535382C34353237373333322C34353237383739372C34353238313635342C34353238393531322C34353239373031382C34353239383530362C34353332363439362C34353434343838342C),
 (116,'ZSWIM5.bApr07','chr1','-',45326333,45544468,0,0,3,0x34353332363333332C34353534323138352C34353534343337322C,0x34353332363439362C34353534323331362C34353534343436382C),
 (116,'TESK2.aApr07','chr1','-',45581929,45729426,45583098,45696044,11,0x34353538313932392C34353538343133352C34353538343935312C34353538353233372C34353538353836372C34353538363137362C34353539333536312C34353632343137302C34353635393938332C34353639353832322C34353732393131302C,0x34353538333831372C34353538343235332C34353538353033382C34353538353332312C34353538353935322C34353538363235392C34353539333730382C34353632343231392C34353636303130352C34353639363133302C34353732393432362C),
 (116,'TESK2.bApr07','chr1','-',45582141,45729424,45583098,45696044,12,0x34353538323134312C34353538343133352C34353538353233372C34353538353836372C34353538363137362C34353539333536312C34353632343137302C34353635393938332C34353639353832322C34353731333336352C34353732363833322C34353732393131302C,0x34353538333831372C34353538343235332C34353538353332312C34353538353935322C34353538363235392C34353539333730382C34353632343231392C34353636303130352C34353639363133302C34353731333430372C34353732363836332C34353732393432342C),
 (116,'TESK2.cApr07','chr1','-',45585867,45729421,45596697,45696044,9,0x34353538353836372C34353538363137362C34353539333536312C34353539363633302C34353632343137302C34353635393938332C34353639353832322C34353732363833322C34353732393131302C,0x34353538353935322C34353538363235392C34353539333730382C34353539363730392C34353632343231392C34353636303130352C34353639363133302C34353732363836332C34353732393432312C),
 (116,'MMACHC.aApr07','chr1','+',45738311,45750252,45738591,45747474,5,0x34353733383331312C34353734353631342C34353734363437302C34353734373035342C34353734383738372C,0x34353733383637322C34353734353830392C34353734363632332C34353734373630362C34353735303235322C),
 (116,'GPBP1L1.aApr07','chr1','-',45865562,45925036,45866514,45897346,13,0x34353836353536322C34353836373833342C34353836383734302C34353837313734372C34353837323335342C34353837383436382C34353838303638352C34353839323830312C34353839333434382C34353839373238362C34353839383434322C34353932333833342C34353932343637302C,0x34353836363636372C34353836373933372C34353836383836352C34353837313930362C34353837323439352C34353837383636322C34353838303735382C34353839333038382C34353839333537382C34353839373430312C34353839393438342C34353932333837392C34353932353033362C),
 (116,'GPBP1L1.cApr07','chr1','-',45866381,45926371,45866514,45872356,7,0x34353836363338312C34353836373833342C34353836383734302C34353837313734372C34353837323335332C34353839383738352C34353932363234312C,0x34353836363636372C34353836373933372C34353836383836352C34353837313933342C34353837323439352C34353839393438342C34353932363337312C),
 (116,'rarparbu.aApr07-unspliced','chr1','-',45874828,45877145,0,0,1,0x34353837343832382C,0x34353837373134352C),
 (117,'MAST2.kApr07-unspliced','chr1','+',46267145,46271014,46269326,46269689,1,0x34363236373134352C,0x34363237313031342C),
 (117,'MAST2.lApr07','chr1','+',46267423,46268744,46267714,46268503,3,0x34363236373432332C34363236383038392C34363236383338372C,0x34363236373832362C34363236383231322C34363236383734342C),
 (117,'PIK3R3.eApr07','chr1','-',46294088,46414753,46294212,46414730,8,0x34363239343038382C34363239373831332C34363330303138372C34363330343331322C34363330353136392C34363331353737332C34363331383930302C34363431343438362C,0x34363239343233302C34363239373838332C34363330303333302C34363330343433382C34363330353335302C34363331353837322C34363331393030392C34363431343735332C),
 (117,'PIK3R3.hApr07','chr1','-',46304327,46414746,46304425,46414730,4,0x34363330343332372C34363331353737332C34363331383930302C34363431343438362C,0x34363330343433382C34363331353837322C34363331393030392C34363431343734362C),
 (117,'PIK3R3.jApr07','chr1','-',46304430,46413206,46304432,46318983,5,0x34363330343433302C34363330353136392C34363331353737332C34363331383930302C34363431333039352C,0x34363330343433382C34363330353335302C34363331353837322C34363331393030392C34363431333230362C),
 (117,'LRRC41.aApr07','chr1','-',46516652,46541867,46517123,46541581,10,0x34363531363635322C34363531373434302C34363531373735302C34363531383435302C34363531383635342C34363531393338332C34363532333632302C34363533353832312C34363533363534322C34363534313338322C,0x34363531373334332C34363531373531362C34363531373837332C34363531383534392C34363531383831392C34363531393634342C34363532343735382C34363533353839322C34363533363632392C34363534313836372C),
 (117,'LRRC41.bApr07','chr1','-',46516659,46538739,46517700,46535848,8,0x34363531363635392C34363531373434302C34363531383435302C34363531383635342C34363531393338332C34363532333632302C34363533353832312C34363533363534322C,0x34363531373334332C34363531373837332C34363531383534392C34363531383831392C34363531393634342C34363532343735382C34363533353839322C34363533383733392C),
 (117,'LRRC41.jApr07','chr1','-',46518753,46541445,46519614,46541443,5,0x34363531383735332C34363531393338332C34363533353832312C34363533363534322C34363534313338322C,0x34363531383831392C34363531393634342C34363533353839322C34363533363632392C34363534313434352C),
 (117,'LRRC41.fApr07','chr1','-',46519200,46536591,46519243,46535840,3,0x34363531393230302C34363533353832312C34363533363534322C,0x34363531393634342C34363533353839322C34363533363539312C),
 (117,'LRRC41.cApr07','chr1','-',46522425,46541443,46523483,46541410,4,0x34363532323432352C34363533353832312C34363533363534322C34363534313338322C,0x34363532343735382C34363533353839322C34363533363632392C34363534313434332C),
 (117,'LRRC41.lApr07','chr1','-',46524333,46541446,46524690,46541410,3,0x34363532343333332C34363533363534322C34363534313338322C,0x34363532343735382C34363533363632392C34363534313434362C),
 (117,'LRRC41.dApr07','chr1','-',46524373,46541140,46524374,46541094,4,0x34363532343337332C34363533353832312C34363533363534322C34363534313032312C,0x34363532343735382C34363533353839322C34363533363632392C34363534313134302C),
 (117,'LRRC41.kApr07','chr1','-',46524397,46541445,46535812,46541443,4,0x34363532343339372C34363533353831312C34363533363534322C34363534313338322C,0x34363532343735382C34363533353839322C34363533363632392C34363534313434352C),
 (117,'teroro.aApr07','chr1','+',46776955,46808514,0,0,8,0x34363737363935352C34363737393138382C34363738313935322C34363739363438332C34363739373932382C34363830313737302C34363830363436342C34363830363734302C,0x34363737373035332C34363737393236382C34363738323032372C34363739363630312C34363739383037302C34363830313833352C34363830363535362C34363830383531342C),
 (117,'woyby.bApr07','chr1','+',46912294,46930354,46912441,46930142,3,0x34363931323239342C34363932343933312C34363933303133322C,0x34363931323437382C34363932353032322C34363933303335342C),
 (117,'woyby.aApr07','chr1','+',46912386,46930357,46912441,46930142,4,0x34363931323338362C34363932303433392C34363932343933312C34363933303133322C,0x34363931323437382C34363932303532332C34363932353032322C34363933303335372C),
 (117,'KIAA0494andATPAF1.aApr07','chr1','-',46913415,46957414,46916719,46956346,11,0x34363931333431352C34363932313535382C34363932323734392C34363932353034322C34363932363631312C34363932373834352C34363933303038352C34363933343830392C34363934363136342C34363935343535332C34363935363136312C,0x34363931363839352C34363932313638342C34363932323836312C34363932353132392C34363932363830332C34363932373935302C34363933303139362C34363933343930382C34363934363331302C34363935343730322C34363935373431342C),
 (117,'KIAA0494andATPAF1.fApr07','chr1','-',46916368,46934860,46916719,46934860,7,0x34363931363336382C34363932313535382C34363932323734392C34363932353034322C34363932373834352C34363933303038352C34363933343830392C,0x34363931363839352C34363932313638342C34363932323836312C34363932353132392C34363932373935302C34363933303139362C34363933343836302C),
 (117,'KIAA0494andATPAF1.iApr07','chr1','-',46916665,46925375,46916719,46925129,4,0x34363931363636352C34363932313535382C34363932323734392C34363932353034322C,0x34363931363839352C34363932313638342C34363932323836312C34363932353337352C),
 (117,'KIAA0494andATPAF1.eApr07','chr1','-',46921498,46954582,46921502,46954581,8,0x34363932313439382C34363932323734392C34363932353034322C34363932373834352C34363933303038352C34363933343830392C34363934363136342C34363935343535332C,0x34363932313638342C34363932323836312C34363932353132392C34363932373935302C34363933303139362C34363933343930382C34363934363331302C34363935343538322C),
 (117,'KIAA0494andATPAF1.bApr07','chr1','-',46922421,46956865,46922657,46956346,9,0x34363932323432312C34363932353034322C34363932363631312C34363932373834352C34363933303038352C34363933343830392C34363934363136342C34363935343535332C34363935363136312C,0x34363932323836312C34363932353132392C34363932363830332C34363932373935302C34363933303139362C34363933343930382C34363934363331302C34363935343730322C34363935363836352C),
 (117,'CYP4B1.aApr07','chr1','+',47037254,47057369,47037340,47057073,12,0x34373033373235342C34373034393036362C34373034393339382C34373035303735342C34373035313734302C34373035323136372C34373035323436372C34373035333333322C34373035353330362C34373035363232332C34373035363338392C34373035363838392C,0x34373033373532302C34373034393230382C34373034393434332C34373035303838322C34373035313836352C34373035323332322C34373035323537342C34373035333532332C34373035353434302C34373035363238382C34373035363437322C34373035373336392C),
 (117,'CYP4B1.bApr07','chr1','+',47037304,47057672,47037340,47057073,12,0x34373033373330342C34373034393036362C34373034393339382C34373035303735342C34373035313734302C34373035323137302C34373035323436372C34373035333333322C34373035353330362C34373035363232332C34373035363338392C34373035363838392C,0x34373033373532302C34373034393230382C34373034393434332C34373035303838322C34373035313836352C34373035323332322C34373035323537342C34373035333532332C34373035353434302C34373035363238382C34373035363437322C34373035373637322C),
 (117,'CYP4B1.eApr07','chr1','+',47037305,47055616,47050876,47055571,8,0x34373033373330352C34373034393036362C34373035303735342C34373035313734302C34373035323137302C34373035323436372C34373035333333322C34373035353330362C,0x34373033373532302C34373034393434332C34373035303838322C34373035313836352C34373035323332322C34373035323537342C34373035333532332C34373035353631362C),
 (117,'CYP4B1.dApr07','chr1','+',47037322,47057608,47037340,47053501,12,0x34373033373332322C34373034393036362C34373034393339382C34373035303735342C34373035313734302C34373035323234302C34373035323436372C34373035333333322C34373035353330362C34373035363232332C34373035363338392C34373035363838392C,0x34373033373532302C34373034393230382C34373034393434332C34373035303838322C34373035313836352C34373035323332322C34373035323537342C34373035333532332C34373035353434302C34373035363238382C34373035363437322C34373035373630382C),
 (117,'CYP4B1.cApr07','chr1','+',47037340,47057073,47037340,47057073,11,0x34373033373334302C34373034393036362C34373035303735342C34373035313734302C34373035323136372C34373035323436372C34373035333333322C34373035353330362C34373035363232332C34373035363338392C34373035363838392C,0x34373033373532302C34373034393230382C34373035303838322C34373035313836352C34373035323332322C34373035323537342C34373035333532332C34373035353434302C34373035363238382C34373035363437322C34373035373037332C),
 (117,'CYP4B1.gApr07','chr1','+',47052202,47107648,47052204,47107146,4,0x34373035323230322C34373035323436372C34373035333333322C34373130373038382C,0x34373035323332322C34373035323537342C34373035333532332C34373130373634382C),
 (118,'CYP4Z1.aApr07','chr1','+',47305633,47356579,47305749,47356193,12,0x34373330353633332C34373330363838302C34373331383838312C34373332303539322C34373332323837382C34373332333038322C34373333323832342C34373333373335322C34373334343338362C34373335333738372C34373335343930382C34373335363032342C,0x34373330353932362C34373330373032322C34373331383932362C34373332303732302C34373332333030332C34373332333233372C34373333323932382C34373333373534332C34373334343532302C34373335333835322C34373335343939312C34373335363537392C),
 (118,'CMPK.aApr07','chr1','+',47572055,47617100,47572057,47615004,6,0x34373537323035352C34373630363732372C34373631313231332C34373631333136372C34373631333435352C34373631343936322C,0x34373537323337352C34373630363837342C34373631313336362C34373631333234342C34373631333535322C34373631373130302C),
 (118,'CMPK.bApr07','chr1','+',47572065,47615014,47572066,47613494,5,0x34373537323036352C34373630363732372C34373631313231332C34373631333435352C34373631343936322C,0x34373537323337352C34373630363837342C34373631313336362C34373631333535322C34373631353031342C),
 (118,'CMPK.dApr07','chr1','+',47572137,47597135,47572138,47596562,2,0x34373537323133372C34373539363535362C,0x34373537323337352C34373539373133352C),
 (118,'CMPK.cApr07','chr1','+',47572200,47613167,47572204,47611402,4,0x34373537323230302C34373630363732372C34373631313231332C34373631323532362C,0x34373537323337352C34373630363837342C34373631313737342C34373631333136372C),
 (118,'LOC388630.aApr07','chr1','-',48003928,48232832,48004033,48232832,5,0x34383030333932382C34383031363734392C34383033323834342C34383033393733312C34383233323239322C,0x34383030343334392C34383031363830332C34383033333031392C34383033393837382C34383233323833322C),
 (119,'poloy.bApr07','chr1','-',48334350,48366206,0,0,2,0x34383333343335302C34383336363136362C,0x34383333343834392C34383336363230362C),
 (119,'poloy.aApr07','chr1','-',48339973,48400130,0,0,5,0x34383333393937332C34383336363136362C34383336363731382C34383339373830372C34383430303035372C,0x34383334303230392C34383336363238302C34383336363833322C34383339373931352C34383430303133302C),
 (119,'SPATA6.dApr07','chr1','-',48499649,48641010,48499902,48640891,8,0x34383439393634392C34383534343034352C34383539333932382C34383539373834342C34383632333536372C34383633333532352C34383633373630392C34383634303838382C,0x34383439393932372C34383534343133372C34383539343032382C34383539383032392C34383632333630382C34383633333631332C34383633373930332C34383634313031302C),
 (119,'SPATA6.cApr07','chr1','-',48499649,48639108,48499902,48639040,9,0x34383439393634392C34383530333030312C34383534343034352C34383539333937362C34383539373834342C34383632333536372C34383633333532352C34383633373630392C34383633393033312C,0x34383439393932372C34383530333037332C34383534343133372C34383539343032382C34383539383032392C34383632333630382C34383633333631332C34383633373930332C34383633393130382C),
 (119,'SPATA6.aApr07','chr1','-',48533631,48710462,48536971,48710267,13,0x34383533333633312C34383534343034352C34383539333932382C34383539373834342C34383632333536372C34383633333532352C34383633373630392C34383634323036302C34383634393732322C34383635313336382C34383638393831302C34383639313235322C34383731303231362C,0x34383533373135322C34383534343133372C34383539343032382C34383539383032392C34383632333630382C34383633333631332C34383633373930332C34383634323134312C34383634393834372C34383635313431302C34383638393835392C34383639313339302C34383731303436322C),
 (119,'SPATA6.bApr07','chr1','-',48536109,48710269,48536971,48710267,13,0x34383533363130392C34383534343034352C34383539333937362C34383539373834342C34383632333536372C34383633333532352C34383633373630392C34383634323036302C34383634393732322C34383635313336382C34383638393831302C34383639313235322C34383731303231362C,0x34383533373135322C34383534343133372C34383539343032382C34383539383032392C34383632333630382C34383633333631332C34383633373930332C34383634323134312C34383634393834372C34383635313431302C34383638393835392C34383639313339302C34383731303236392C),
 (119,'SPATA6.eApr07','chr1','-',48623581,48710403,48623582,48710402,6,0x34383632333538312C34383633333532352C34383633373630392C34383634323036302C34383639313235322C34383731303231362C,0x34383632333630382C34383633333631332C34383633373930332C34383634323134312C34383639313339302C34383731303430332C),
 (119,'AGBL4.aApr07','chr1','-',48771113,48919160,48772431,48919144,9,0x34383737313131332C34383737333134382C34383737373930302C34383832353236322C34383832393039312C34383837323735312C34383839313539352C34383930313431302C34383931393038302C,0x34383737323535322C34383737333137352C34383737373939372C34383832353432352C34383832393234342C34383837323836332C34383839313731302C34383930313530302C34383931393136302C),
 (119,'AGBL4.bApr07','chr1','-',48822128,48901500,48825167,48901498,5,0x34383832323132382C34383832393039312C34383837323735312C34383839313539352C34383930313431302C,0x34383832353432352C34383832393234342C34383837323836332C34383839313731302C34383930313530302C),
 (120,'wyreybo.aApr07','chr1','-',49283842,50262171,49283842,50262055,5,0x34393238333834322C34393438343032382C34393933353537312C35303038393635342C35303236323032312C,0x34393238343035392C34393438343132332C34393933353639362C35303038393737372C35303236323137312C),
 (120,'wyreybo.cApr07','chr1','-',49283882,50262212,49283884,50089672,4,0x34393238333838322C34393438343032382C35303038393635342C35303236323032312C,0x34393238343035392C34393438343132332C35303038393737372C35303236323231322C),
 (120,'slaboy.aApr07','chr1','+',49413067,49425843,0,0,2,0x34393431333036372C34393432353530302C,0x34393431333334312C34393432353834332C),
 (120,'sluboy.aApr07','chr1','-',49612459,49710344,0,0,4,0x34393631323435392C34393636313332312C34393730383035372C34393731303235342C,0x34393631323630332C34393636313339332C34393730383236352C34393731303334342C),
 (120,'wyreybo.bApr07','chr1','-',49765486,50089777,49765806,50089775,3,0x34393736353438362C34393933353537312C35303038393635342C,0x34393736353836332C34393933353639362C35303038393737372C),
 (121,'FAF1.aApr07','chr1','-',50677698,51198524,50679699,51198383,19,0x35303637373639382C35303731333732332C35303732383834372C35303732393938302C35303737333632382C35303737373835312C35303830353333362C35303832303837372C35303832313931312C35303832323934342C35303833343338302C35303839333730312C35303934343034352C35303937373132322C35303938323934332C35313032363235392C35313033393839302C35313039363138382C35313139383032362C,0x35303637393738332C35303731333933392C35303732383932352C35303733303036312C35303737333731372C35303737373938382C35303830353439312C35303832303935392C35303832313937352C35303832333037312C35303833343437362C35303839333738382C35303934343135312C35303937373231342C35303938333033352C35313032363436352C35313033393933372C35313039363235372C35313139383532342C),
 (121,'FAF1.kApr07','chr1','-',50677705,50774726,0,0,3,0x35303637373730352C35303731333732332C35303737333731312C,0x35303637393738332C35303731333835342C35303737343732362C),
 (121,'FAF1.bApr07','chr1','-',50679522,51198053,50679699,51198053,14,0x35303637393532322C35303731333732332C35303732383834372C35303732393938302C35303737333632382C35303737373835312C35303830353333362C35303832303837372C35303937373132322C35303938323934332C35313032363235392C35313033393839302C35313039363138382C35313139383032362C,0x35303637393738332C35303731333933392C35303732383932352C35303733303036312C35303737333731372C35303737373938382C35303830353439312C35303832303935392C35303937373231342C35303938333033352C35313032363436352C35313033393933372C35313039363235372C35313139383035332C),
 (121,'FAF1.cApr07','chr1','-',50679535,50944310,50690345,50944120,14,0x35303637393533352C35303639303035322C35303731333732332C35303732383834372C35303732393938302C35303737333632382C35303737373835312C35303830353333362C35303832303837372C35303832313931312C35303832323934342C35303833343338302C35303839333730312C35303934343034352C,0x35303637393738332C35303639303435332C35303731333933392C35303732383932352C35303733303036312C35303737333731372C35303737373938382C35303830353439312C35303832303935392C35303832313937352C35303832333037312C35303833343437362C35303839333738382C35303934343331302C),
 (121,'FAF1.fApr07','chr1','-',50730023,50872485,50730033,50872404,7,0x35303733303032332C35303830353333362C35303832303837372C35303832313931312C35303832323934342C35303833343338302C35303837323430312C,0x35303733303036312C35303830353439312C35303832303935392C35303832313937352C35303832333037312C35303833343437362C35303837323438352C),
 (121,'FAF1.gApr07','chr1','-',50815688,50943484,50815688,50834476,7,0x35303831353638382C35303832303837372C35303832313931312C35303832323934342C35303833343338302C35303839333730312C35303934333436302C,0x35303831353738312C35303832303935392C35303832313937352C35303832333037312C35303833343437362C35303839333738382C35303934333438342C),
 (121,'FAF1.dApr07','chr1','-',50821880,51169767,50821907,51169717,11,0x35303832313838302C35303832323934342C35303833343338302C35303839333730312C35303934343034352C35303937373132322C35303938323934332C35313032363235392C35313033393839302C35313039363138382C35313136393638342C,0x35303832313937352C35303832333037312C35303833343437362C35303839333738382C35303934343135312C35303937373231342C35303938333033352C35313032363436352C35313033393933372C35313039363235372C35313136393736372C),
 (121,'FAF1.oApr07','chr1','-',51019272,51166211,0,0,5,0x35313031393237322C35313032363235392C35313033393839302C35313039363138382C35313136353939382C,0x35313031393330342C35313032363436352C35313033393933372C35313039363235372C35313136363231312C),
 (121,'FAF1.nApr07','chr1','-',51026213,51166521,0,0,4,0x35313032363231332C35313033393839302C35313039363138382C35313136353939382C,0x35313032363436352C35313033393933372C35313039363235372C35313136363532312C),
 (121,'FAF1.hApr07','chr1','-',51026234,51198080,51026236,51198080,4,0x35313032363233342C35313033393839302C35313039363138382C35313139383032362C,0x35313032363436352C35313033393933372C35313039363235372C35313139383038302C),
 (121,'snaboy.aApr07','chr1','+',51215785,51297162,51215965,51297160,3,0x35313231353738352C35313239353536382C35313239373133302C,0x35313231363235392C35313239353632352C35313239373136322C),
 (121,'snaboy.bApr07','chr1','+',51216165,51309305,0,0,8,0x35313231363136352C35313232383930372C35313233393731302C35313239353536382C35313239373133302C35313239393038362C35313239393632342C35313330393138342C,0x35313231363235392C35313232393032392C35313233393832392C35313239353632352C35313239373330332C35313239393333302C35313239393736322C35313330393330352C),
 (122,'RNF11.aApr07','chr1','+',51474533,51511799,51475016,51509582,3,0x35313437343533332C35313530383231352C35313530393431302C,0x35313437353133392C35313530383338352C35313531313739392C),
 (122,'RNF11.dApr07','chr1','+',51474598,51511686,51475047,51509582,3,0x35313437343539382C35313530393431302C35313531303737392C,0x35313437353133392C35313530393737372C35313531313638362C),
 (122,'EPS15.aApr07','chr1','-',51592513,51757613,51594959,51757491,25,0x35313539323531332C35313539393433302C35313630323132352C35313630343231322C35313633323634302C35313633373239312C35313633393137372C35313634303639342C35313634313637382C35313634343136342C35313634363339342C35313634373739342C35313636303034352C35313637383630362C35313638333134382C35313638353231392C35313638363330352C35313639393335302C35313730313933322C35313730333532302C35313730363733322C35313730393934392C35313731313131382C35313731393533322C35313735373435382C,0x35313539353130362C35313539393631352C35313630323238382C35313630343238392C35313633323730372C35313633373432352C35313633393231332C35313634303738352C35313634313739322C35313634343336382C35313634363539322C35313634373935362C35313636303131382C35313637383639322C35313638333330352C35313638353336352C35313638363339352C35313639393431302C35313730323035382C35313730333538362C35313730363832382C35313730393939372C35313731313230382C35313731393537342C35313735373631332C),
 (122,'EPS15.cApr07','chr1','-',51592944,51660417,51594959,51660216,13,0x35313539323934342C35313539393433302C35313630323132352C35313630343231322C35313633323634302C35313633373239312C35313633393137372C35313634303639342C35313634313637382C35313634343136342C35313634363339342C35313634373739342C35313636303034352C,0x35313539353130362C35313539393631352C35313630323238382C35313630343238392C35313633323730372C35313633373432352C35313633393231332C35313634303738352C35313634313739322C35313634343336382C35313634363539322C35313634373935362C35313636303431372C),
 (122,'EPS15.bApr07','chr1','-',51593484,51757503,51594959,51757491,23,0x35313539333438342C35313539393433302C35313630323132352C35313630343231322C35313633323634302C35313633373239312C35313633393137372C35313634303639342C35313634313637382C35313634373739342C35313636303034352C35313637383630362C35313638333134382C35313638353231392C35313638363330352C35313639393335302C35313730313933322C35313730333532302C35313730363733322C35313730393934392C35313731313131382C35313731393533322C35313735373435382C,0x35313539353130362C35313539393631352C35313630323238382C35313630343238392C35313633323730372C35313633373432352C35313633393231332C35313634303738352C35313634313739322C35313634373935362C35313636303131382C35313637383639322C35313638333330352C35313638353336352C35313638363339352C35313639393431302C35313730323035382C35313730333538362C35313730363832382C35313730393939372C35313731313230382C35313731393537342C35313735373530332C),
 (122,'EPS15.gApr07','chr1','-',51632371,51645384,51635468,51644368,8,0x35313633323337312C35313633353337302C35313633373239312C35313633393137372C35313634303639342C35313634313637382C35313634343136342C35313634353337362C,0x35313633323730372C35313633353437312C35313633373432352C35313633393231332C35313634303738352C35313634313739322C35313634343336382C35313634353338342C),
 (122,'EPS15.hApr07','chr1','-',51641748,51660328,51641750,51660216,4,0x35313634313734382C35313634363339342C35313634373739342C35313636303034352C,0x35313634313739322C35313634363539322C35313634373935362C35313636303332382C),
 (122,'shareybo.cApr07','chr1','+',51756568,51799221,0,0,2,0x35313735363536382C35313739393134312C,0x35313735363734332C35313739393232312C),
 (122,'shareybo.bApr07','chr1','+',51756641,51799873,0,0,3,0x35313735363634312C35313739393134342C35313739393733302C,0x35313735363730362C35313739393238332C35313739393837332C),
 (122,'OSBPL9.bApr07','chr1','+',51815439,52026729,51855316,52026049,26,0x35313831353433392C35313833363338332C35313835323536342C35313835353133332C35313839303235302C35313930373639332C35313935323236322C35313938333739352C35313938343936392C35313938363632382C35313938383430342C35313939383934392C35323030303132362C35323030343038312C35323031303332392C35323031303836342C35323031353039322C35323031393432332C35323032303831382C35323032323137342C35323032323532332C35323032323730312C35323032343036372C35323032343738352C35323032353631322C35323032353937342C,0x35313831353531362C35313833363435332C35313835323637392C35313835353438312C35313839303330312C35313930373737322C35313935323333392C35313938333839312C35313938353031372C35313938363635382C35313938383435352C35313939393034302C35323030303233312C35323030343234312C35323031303434322C35323031303938332C35323031353137382C35323031393539352C35323032303930332C35323032323238352C35323032323538372C35323032323834322C35323032343134362C35323032343837372C35323032353734382C35323032363732392C),
 (122,'OSBPL9.aApr07','chr1','+',51815445,52027479,51855316,52026049,25,0x35313831353434352C35313835353133332C35313839303235302C35313930373639332C35313935323236322C35313937383430322C35313938333739352C35313938343936392C35313938363632382C35313938383430342C35313939383934392C35323030303132362C35323030343038312C35323031303332392C35323031303836342C35323031353039322C35323031393432332C35323032303831382C35323032323137342C35323032323532332C35323032323730312C35323032343036372C35323032343738352C35323032353631322C35323032353937342C,0x35313831353531362C35313835353438312C35313839303330312C35313930373737322C35313935323333392C35313937383437312C35313938333839312C35313938353031372C35313938363635382C35313938383435352C35313939393034302C35323030303233312C35323030343234312C35323031303434322C35323031303938332C35323031353137382C35323031393539352C35323032303930332C35323032323238352C35323032323538372C35323032323834322C35323032343134362C35323032343837372C35323032353734382C35323032373437392C),
 (122,'OSBPL9.cApr07','chr1','+',51855332,52026780,51855370,52026049,24,0x35313835353333322C35313839303235302C35313930373639332C35313935323236322C35313938333739352C35313938343936392C35313938363632382C35313938383430342C35313939343537392C35313939383934392C35323030303132362C35323030343038312C35323031303332392C35323031303836342C35323031353039322C35323031393432332C35323032303831382C35323032323137342C35323032323532332C35323032323730312C35323032343036372C35323032343738352C35323032353631322C35323032353937342C,0x35313835353438312C35313839303330312C35313930373737322C35313935323333392C35313938333839312C35313938353031372C35313938363635382C35313938383435352C35313939343631382C35313939393034302C35323030303233312C35323030343234312C35323031303434322C35323031303938332C35323031353137382C35323031393539352C35323032303930332C35323032323238352C35323032323538372C35323032323834322C35323032343134362C35323032343837372C35323032353734382C35323032363738302C),
 (122,'OSBPL9.fApr07','chr1','+',51855345,52026729,51988407,52026049,23,0x35313835353334352C35313839303235302C35313935323236322C35313938333739352C35313938343936392C35313938363632382C35313938383430342C35313939343537392C35313939383934392C35323030303132362C35323030343038312C35323031303332392C35323031303836342C35323031353039322C35323031393432332C35323032303831382C35323032323137342C35323032323532332C35323032323730312C35323032343036372C35323032343738352C35323032353631322C35323032353937342C,0x35313835353438312C35313839303330312C35313935323333392C35313938333839312C35313938353031372C35313938363635382C35313938383435352C35313939343631382C35313939393034302C35323030303233312C35323030343234312C35323031303434322C35323031303938332C35323031353137382C35323031393539352C35323032303930332C35323032323238352C35323032323538372C35323032323834322C35323032343134362C35323032343837372C35323032353734382C35323032363732392C),
 (122,'OSBPL9.lApr07','chr1','+',51855346,52026724,51999012,52026325,15,0x35313835353334362C35313839303235302C35313935323236322C35313937383430322C35313938333739352C35313938343936392C35313938363632382C35313938383430342C35313939333738302C35313939383934392C35323030303132362C35323030343038312C35323031303332392C35323031303836342C35323032363233342C,0x35313835353438312C35313839303330312C35313935323333392C35313937383437312C35313938333839312C35313938353031372C35313938363635382C35313938383435352C35313939333933342C35313939393034302C35323030303233312C35323030343234312C35323031303434322C35323031303931392C35323032363732342C),
 (122,'OSBPL9.tApr07','chr1','+',51855352,51952588,51855370,51952420,4,0x35313835353335322C35313839303235302C35313930373639332C35313935323236322C,0x35313835353438312C35313839303330312C35313930373737322C35313935323538382C),
 (122,'OSBPL9.vuApr07','chr1','+',51855355,51994650,0,0,8,0x35313835353335352C35313839303235302C35313935323236322C35313938333739352C35313938343936392C35313938363632382C35313938383430342C35313939343537392C,0x35313835353438312C35313839303330312C35313935323333392C35313938333839312C35313938353031372C35313938363635382C35313938383435352C35313939343635302C),
 (122,'OSBPL9.voApr07','chr1','+',51855355,52000170,0,0,8,0x35313835353335352C35313839303235302C35313935323236322C35313938333739352C35313938343936392C35313938383430342C35313939383934392C35323030303132362C,0x35313835353438312C35313839303330312C35313935323333392C35313938333839312C35313938353031372C35313938383435352C35313939393034302C35323030303137302C),
 (122,'OSBPL9.vfApr07','chr1','+',51855355,51983807,51890262,51983807,7,0x35313835353335352C35313837393038322C35313839303235302C35313930373639332C35313935323236322C35313937383430322C35313938333739352C,0x35313835353438312C35313837393138362C35313839303330312C35313930373737322C35313935323333392C35313937383437312C35313938333830372C),
 (122,'OSBPL9.vkApr07','chr1','+',51855355,52000226,0,0,9,0x35313835353335352C35313839303235302C35313935323236322C35313938333739352C35313938343936392C35313938363632382C35313938383430342C35313939383934392C35323030303132362C,0x35313835353438312C35313839303330312C35313935323333392C35313938333839312C35313938353031372C35313938363635382C35313938383435352C35313939393034302C35323030303232362C),
 (122,'OSBPL9.pApr07','chr1','+',51855355,52026724,51855370,51998949,16,0x35313835353335352C35313839303235302C35313930373639332C35313935323236322C35313938333739352C35313938343936392C35313938383430342C35313939343537392C35313939383932352C35323030303132362C35323030343038312C35323031303332392C35323031303836342C35323031353039322C35323031393432332C35323032363138322C,0x35313835353438312C35313839303330312C35313930373737322C35313935323333392C35313938333839312C35313938353031372C35313938383435352C35313939343631382C35313939393034302C35323030303233312C35323030343234312C35323031303434322C35323031303938332C35323031353137382C35323031393436372C35323032363732342C),
 (122,'OSBPL9.nApr07','chr1','+',51855359,51994909,51855370,51994633,9,0x35313835353335392C35313839303235302C35313930373639332C35313935323236322C35313938333739352C35313938343936392C35313938363632382C35313938383430342C35313939343537392C,0x35313835353438312C35313839303330312C35313930373737322C35313935323333392C35313938333839312C35313938353031372C35313938363635382C35313938383435352C35313939343930392C),
 (122,'OSBPL9.gApr07','chr1','+',51855366,52026643,51855370,52022752,23,0x35313835353336362C35313839303235302C35313930373639332C35313935323236322C35313938333739352C35313938343936392C35313938363632382C35313938383430342C35313939383934392C35323030303132362C35323030343038312C35323031303332392C35323031303836342C35323031353039322C35323031393432332C35323032303831382C35323032323137342C35323032323532332C35323032323730312C35323032343036372C35323032343738352C35323032353631322C35323032353937342C,0x35313835353438312C35313839303330312C35313930373737322C35313935323333392C35313938333839312C35313938353031372C35313938363635382C35313938383435352C35313939393034302C35323030303233312C35323030343234312C35323031303434322C35323031303938332C35323031353137382C35323031393539352C35323032303930332C35323032323238352C35323032323539312C35323032323834322C35323032343134362C35323032343837372C35323032353734382C35323032363634332C),
 (122,'OSBPL9.dApr07','chr1','+',51855368,52026724,51855370,52026049,23,0x35313835353336382C35313930373639332C35313935323236322C35313938333739352C35313938343936392C35313938363632382C35313938383430342C35313939343537392C35313939383934392C35323030303132362C35323030343038312C35323031303332392C35323031303836342C35323031353039322C35323031393432332C35323032303831382C35323032323137342C35323032323532332C35323032323730312C35323032343036372C35323032343738352C35323032353631322C35323032353937342C,0x35313835353438312C35313930373737322C35313935323333392C35313938333839312C35313938353031372C35313938363635382C35313938383435352C35313939343631382C35313939393034302C35323030303233312C35323030343234312C35323031303434322C35323031303938332C35323031353137382C35323031393539352C35323032303930332C35323032323238352C35323032323538372C35323032323834322C35323032343134362C35323032343837372C35323032353734382C35323032363732342C),
 (122,'OSBPL9.oApr07','chr1','+',51855373,52019928,51855373,52004132,14,0x35313835353337332C35313839303235302C35313930373639332C35313935323236322C35313938333739352C35313938343936392C35313938363632382C35313938383430342C35323030343038312C35323031303332392C35323031303836342C35323031353039322C35323031393432332C35323031393834372C,0x35313835353438312C35313839303330312C35313930373737322C35313935323333392C35313938333839312C35313938353031372C35313938363635382C35313938383435352C35323030343234312C35323031303434322C35323031303938332C35323031353137382C35323031393539352C35323031393932382C),
 (122,'OSBPL9.vtApr07','chr1','+',51861260,51985017,0,0,6,0x35313836313236302C35313930373639332C35313931313732382C35313935323236322C35313938333739352C35313938343936392C,0x35313836313431352C35313930373737322C35313931313833312C35313935323333392C35313938333839312C35313938353031372C),
 (122,'NRD1.aApr07','chr1','-',52026853,52117070,52027495,52116875,33,0x35323032363835332C35323032373832372C35323032383739322C35323032393135392C35323032393833372C35323033303330352C35323033303633362C35323033323733312C35323033333038322C35323033363530382C35323033383831352C35323034323037332C35323034333736392C35323034353035332C35323034373537342C35323034383534302C35323035303235332C35323035323239342C35323035323831302C35323035323935322C35323035343537312C35323035363332352C35323035383035392C35323035393735372C35323036313932332C35323036333534362C35323036363035352C35323037323237362C35323037343339302C35323037343632382C35323037353734362C35323037383438352C35323131363533342C,0x35323032373639332C35323032373931372C35323032383930392C35323032393235302C35323032393932312C35323033303335382C35323033303638342C35323033323837302C35323033333131342C35323033363637312C35323033383934332C35323034323232342C35323034333832312C35323034353137332C35323034373636312C35323034383636342C35323035303335382C35323035323334392C35323035323836392C35323035333037332C35323035343634392C35323035363339352C35323035383133332C35323035393831352C35323036323034362C35323036333634322C35323036363132392C35323037323433302C35323037343437322C35323037343639382C35323037353838302C35323037383737342C35323131373037302C),
 (122,'NRD1.cApr07','chr1','-',52027451,52116300,52027495,52078719,33,0x35323032373435312C35323032373832372C35323032383739322C35323032393135392C35323032393833372C35323033303330352C35323033303633362C35323033323733312C35323033333038322C35323033363530382C35323033383831352C35323034323037332C35323034333736392C35323034353035332C35323034373537342C35323034383534302C35323035303235332C35323035323239342C35323035323831302C35323035323935322C35323035343537312C35323035363332352C35323035383035392C35323035393735372C35323036313932332C35323036333534362C35323036363035352C35323037323237362C35323037343339302C35323037343632382C35323037353734362C35323037383438352C35323131363234322C,0x35323032373639332C35323032373931372C35323032383930392C35323032393235302C35323032393932312C35323033303335382C35323033303638342C35323033323837302C35323033333131342C35323033363637312C35323033383934332C35323034323232342C35323034333832312C35323034353137332C35323034373636312C35323034383636342C35323035303335382C35323035323334392C35323035323836392C35323035333037332C35323035343634392C35323035363339352C35323035383133332C35323035393831352C35323036323034362C35323036333634322C35323036363132392C35323037323433302C35323037343437322C35323037343639382C35323037353838302C35323037383737342C35323131363330302C),
 (122,'NRD1.dApr07','chr1','-',52027465,52085001,52027495,52074391,32,0x35323032373436352C35323032373832372C35323032383739322C35323032393135392C35323032393833372C35323033303330352C35323033303633362C35323033323733312C35323033333038322C35323033363530382C35323033383831352C35323034323037332C35323034333736392C35323034353035332C35323034373537342C35323034383534302C35323035303235332C35323035323239342C35323035323831302C35323035323935322C35323035343537312C35323035363332352C35323035383035392C35323035393735372C35323036313932332C35323036333534362C35323036363035352C35323037323237362C35323037343338382C35323037343632382C35323037383438352C35323038343734352C,0x35323032373639332C35323032373931372C35323032383930392C35323032393235302C35323032393932312C35323033303335382C35323033303638342C35323033323837302C35323033333131342C35323033363637312C35323033383934332C35323034323232342C35323034333832312C35323034353137332C35323034373636312C35323034383636342C35323035303335382C35323035323334392C35323035323836392C35323035333037332C35323035343634392C35323035363339352C35323035383133332C35323035393831352C35323036323034362C35323036333634322C35323036363132392C35323037323433302C35323037343437322C35323037343639382C35323037383737342C35323038353030312C),
 (122,'NRD1.bApr07','chr1','-',52027465,52117001,52027495,52116875,31,0x35323032373436352C35323032373832372C35323032383739322C35323032393135392C35323032393833372C35323033303330352C35323033303633362C35323033323733312C35323033333038322C35323033363530382C35323033383831352C35323034323037332C35323034333736392C35323034353035332C35323034373537342C35323034383534302C35323035303235332C35323035323239342C35323035323831302C35323035323935322C35323035343537312C35323035363332352C35323035383035392C35323035393735372C35323036313932332C35323036333534362C35323036363035352C35323037323237362C35323037343339302C35323037383438352C35323131363533342C,0x35323032373639332C35323032373931372C35323032383930392C35323032393235302C35323032393932312C35323033303335382C35323033303638342C35323033323837302C35323033333131342C35323033363637312C35323033383934332C35323034323232342C35323034333832312C35323034353137332C35323034373636312C35323034383636342C35323035303335382C35323035323334392C35323035323836392C35323035333037332C35323035343634392C35323035363339352C35323035383133332C35323035393831352C35323036323034362C35323036333634322C35323036363132392C35323037323433302C35323037343437322C35323037383737342C35323131373030312C),
 (122,'NRD1.hApr07','chr1','-',52027469,52042116,52027670,52042115,12,0x35323032373436392C35323032373832332C35323032383739322C35323032393135392C35323032393833372C35323033303330352C35323033303633362C35323033323733312C35323033333038322C35323033363530382C35323033383831352C35323034323037332C,0x35323032373639332C35323032373931372C35323032383930392C35323032393235302C35323032393932312C35323033303335382C35323033303638342C35323033323837302C35323033333131342C35323033363637312C35323033383934332C35323034323131362C),
 (122,'NRD1.gApr07','chr1','-',52027529,52039359,52027531,52038880,12,0x35323032373532392C35323032373832372C35323032383739322C35323032393135392C35323032393833372C35323033303330352C35323033303633362C35323033323733312C35323033333038322C35323033363530382C35323033383831352C35323033393131362C,0x35323032373639332C35323032373931372C35323032383930392C35323032393235302C35323032393932312C35323033303335382C35323033303638342C35323033323837302C35323033333131342C35323033363637312C35323033383934332C35323033393335392C),
 (122,'NRD1.vcApr07','chr1','-',52030665,52039342,52030666,52033108,5,0x35323033303636352C35323033323733312C35323033333038322C35323033383831352C35323033393131362C,0x35323033303638342C35323033323837302C35323033333131342C35323033383934332C35323033393334322C),
 (122,'plapawbu.bApr07','chr1','+',52032308,52036760,52032309,52036390,2,0x35323033323330382C35323033363231342C,0x35323033323333342C35323033363736302C),
 (122,'RAB3B.aApr07','chr1','-',52146215,52228899,52158186,52228898,6,0x35323134363231352C35323135383138362C35323137313537372C35323137353535332C35323231353134392C35323232383831312C,0x35323134363235362C35323135383337342C35323137313730322C35323137353637322C35323231353337372C35323232383839392C),
 (122,'RAB3B.bApr07','chr1','-',52151749,52229023,52158186,52215377,5,0x35323135313734392C35323137313537372C35323137353535332C35323231353134392C35323232383831312C,0x35323135383337342C35323137313730322C35323137353637322C35323231353337372C35323232393032332C),
 (122,'RAB3B.cApr07','chr1','-',52158114,52202171,52158186,52202096,4,0x35323135383131342C35323137313537372C35323137353535332C35323230323038372C,0x35323135383337342C35323137313730322C35323137353637322C35323230323137312C),
 (122,'BTF3L4.bApr07','chr1','+',52294384,52326984,52298107,52325018,6,0x35323239343338342C35323239383039342C35323330333038342C35323332313539392C35323332343337312C35323332343937312C,0x35323239343633392C35323239383136312C35323330333139382C35323332313830312C35323332343433312C35323332363938342C),
 (122,'BTF3L4.jApr07','chr1','+',52294453,52325007,0,0,7,0x35323239343435332C35323239383039342C35323239383638372C35323330333038342C35323332313539392C35323332343337312C35323332343937312C,0x35323239343633392C35323239383136312C35323239383931392C35323330333139382C35323332313830312C35323332343433312C35323332353030372C),
 (122,'BTF3L4.fApr07','chr1','+',52294524,52325671,52298107,52324980,5,0x35323239343532342C35323239383039342C35323330333038342C35323332343337312C35323332343937312C,0x35323239343633392C35323239383136312C35323330333139382C35323332343433312C35323332353637312C),
 (122,'BTF3L4.lApr07','chr1','+',52294533,52325134,0,0,5,0x35323239343533332C35323330333038342C35323330333534362C35323332343337312C35323332343937312C,0x35323239343633392C35323330333139382C35323330333636382C35323332343433312C35323332353133342C),
 (122,'BTF3L4.eApr07','chr1','+',52294533,52326691,52321605,52325018,5,0x35323239343533332C35323330333038342C35323332313539392C35323332343337312C35323332343937312C,0x35323239343633392C35323330333139382C35323332313830312C35323332343433312C35323332363639312C),
 (122,'BTF3L4.hApr07','chr1','+',52294574,52303559,52298107,52303204,3,0x35323239343537342C35323239383039342C35323330333038342C,0x35323239343633392C35323239383136312C35323330333535392C),
 (122,'BTF3L4.dApr07','chr1','+',52294576,52321760,52298107,52309553,5,0x35323239343537362C35323239383039342C35323330333038342C35323330393430392C35323332313539392C,0x35323239343633392C35323239383136312C35323330333139382C35323330393538372C35323332313736302C),
 (122,'BTF3L4.cApr07','chr1','+',52294583,52324971,52298107,52324439,5,0x35323239343538332C35323239383039342C35323330333038342C35323332313539392C35323332343337312C,0x35323239343633392C35323239383136312C35323330333139382C35323332313830312C35323332343937312C),
 (122,'BTF3L4.iApr07','chr1','+',52294592,52325270,52294594,52324980,4,0x35323239343539322C35323330333038342C35323332343337312C35323332343937312C,0x35323239343633392C35323330333139382C35323332343433312C35323332353237302C),
 (122,'BTF3L4.gApr07','chr1','+',52294594,52339916,52294595,52339523,4,0x35323239343539342C35323239383039342C35323330333038342C35323333393436362C,0x35323239343633392C35323239383136312C35323330333139382C35323333393931362C),
 (122,'BTF3L4.aApr07','chr1','+',52296514,52326651,52298107,52325018,7,0x35323239363531342C35323239383039342C35323330333038342C35323332313539392C35323332343337312C35323332343937312C35323332353638332C,0x35323239363532352C35323239383136312C35323330333139382C35323332313830312C35323332343433312C35323332353437372C35323332363635312C),
 (123,'ZFYVE9.dApr07','chr1','+',52534154,52573467,52534156,52573039,4,0x35323533343135342C35323534323038302C35323537313032372C35323537323934372C,0x35323533343233372C35323534323138352C35323537313137382C35323537333436372C);
INSERT INTO `aceview_hg18_housekeeping` (`bin`,`name`,`chrom`,`strand`,`txStart`,`txEnd`,`cdsStart`,`cdsEnd`,`exonCount`,`exonStarts`,`exonEnds`) VALUES 
 (123,'ZCCHC11.aApr07','chr1','-',52661534,52791506,52662194,52764540,30,0x35323636313533342C35323636333630382C35323636393237322C35323637333632342C35323637353031342C35323637363437392C35323638343034362C35323638343231362C35323638343532342C35323638343834392C35323639363539352C35323639393339332C35323639393737322C35323639393937312C35323730333332392C35323730363434302C35323731303231312C35323731333039312C35323731353936372C35323731393638322C35323732303036332C35323732373136382C35323732383939312C35323733313837302C35323733333638362C35323733353236352C35323734373835352C35323735343135302C35323736333832322C35323739313139302C,0x35323636323236322C35323636333736372C35323636393732302C35323637333732352C35323637353233382C35323637363539352C35323638343132392C35323638343236342C35323638343730322C35323638343932372C35323639363730392C35323639393438332C35323639393837362C35323730303032392C35323730333433332C35323730363532372C35323731303336322C35323731333739352C35323731363134322C35323731393839352C35323732303138332C35323732373239352C35323732393036312C35323733313932322C35323733333737352C35323733353434332C35323734373937322C35323735343331342C35323736343633332C35323739313530362C),
 (123,'ZCCHC11.cApr07','chr1','-',52661537,52791331,52662194,52764540,30,0x35323636313533372C35323636333630382C35323636393237322C35323637333632342C35323637353031342C35323637363437392C35323638343034362C35323638343231362C35323638343532342C35323638343834392C35323639363539352C35323639393339332C35323639393737322C35323639393937312C35323730333332392C35323730363434302C35323731303231312C35323731333039312C35323731353936372C35323731393638322C35323732303036332C35323732373136382C35323732383939312C35323733313837302C35323733333638362C35323733353236352C35323734373835352C35323735343135302C35323736333832322C35323739313139302C,0x35323636323236322C35323636333736372C35323636393732302C35323637333732352C35323637353232332C35323637363539352C35323638343132392C35323638343236342C35323638343730322C35323638343932372C35323639363730392C35323639393438332C35323639393837362C35323730303032392C35323730333433332C35323730363532372C35323731303336322C35323731333739352C35323731363134322C35323731393839352C35323732303138332C35323732373239352C35323732393036312C35323733313932322C35323733333737352C35323733353434332C35323734373937322C35323735343331342C35323736343633332C35323739313333312C),
 (123,'ZCCHC11.bApr07','chr1','-',52661537,52791722,52662194,52764540,31,0x35323636313533372C35323636333630382C35323636393237322C35323637333632342C35323637353031342C35323637363437392C35323638343034362C35323638343231362C35323638343532342C35323638343834392C35323639363539352C35323639393339332C35323639393737322C35323639393937312C35323730333332392C35323730363434302C35323731303231312C35323731333039312C35323731353936372C35323731393638322C35323732303036332C35323732373136382C35323732383939312C35323733313837302C35323733333638362C35323733353236352C35323734373835352C35323735343135302C35323736333832322C35323739313139302C35323739313639322C,0x35323636323236322C35323636333736372C35323636393732302C35323637333732352C35323637353233352C35323637363539352C35323638343132392C35323638343236342C35323638343730322C35323638343932372C35323639363730392C35323639393438332C35323639393837362C35323730303032392C35323730333433332C35323730363532372C35323731303336322C35323731333739352C35323731363134322C35323731393839352C35323732303138332C35323732373239352C35323732393036312C35323733313932322C35323733333737352C35323733353434332C35323734373937322C35323735343331342C35323736343633332C35323739313335302C35323739313732322C),
 (123,'ZCCHC11.eApr07','chr1','-',52661688,52699847,52662037,52699847,6,0x35323636313638382C35323638343235302C35323638343532342C35323638343834392C35323639393339332C35323639393737322C,0x35323636323131332C35323638343236342C35323638343730322C35323638343932372C35323639393438332C35323639393834372C),
 (123,'ZCCHC11.dApr07','chr1','-',52684052,52764190,52701941,52764189,23,0x35323638343035322C35323638343231362C35323638343532342C35323638343834392C35323639363539352C35323639393339332C35323639393737322C35323639393937312C35323730333332392C35323730363434302C35323731303231312C35323731333039312C35323731353936372C35323731393638322C35323732303036332C35323732373136382C35323732383939312C35323733313837302C35323733333638362C35323733353236352C35323734373835352C35323735343135302C35323736333832322C,0x35323638343132392C35323638343236342C35323638343730322C35323638343932372C35323639363730392C35323639393438332C35323639393837362C35323730323033372C35323730333433332C35323730363532372C35323731303336322C35323731333739352C35323731363134322C35323731393839352C35323732303138332C35323732373239352C35323732393036312C35323733313932322C35323733333737352C35323733353434332C35323734373937322C35323735343331342C35323736343139302C),
 (123,'ZYG11A.cApr07','chr1','+',53080770,53133408,53099008,53131217,14,0x35333038303737302C35333039323732342C35333039383939302C35333130323234302C35333130343736322C35333130353739382C35333130353938362C35333131353934312C35333131363138342C35333131393733302C35333132343039322C35333132353231352C35333133313034312C35333133323330342C,0x35333038313233332C35333039323839302C35333039393133312C35333130323431372C35333130343832372C35333130353839382C35333130363033372C35333131363130332C35333131363232392C35333131393932352C35333132343135342C35333132353331332C35333133323035312C35333133333430382C),
 (123,'ZYG11A.aApr07','chr1','+',53080995,53132465,53081143,53132440,8,0x35333038303939352C35333039323732342C35333039353235372C35333039383939302C35333130323234302C35333130343736322C35333130353739382C35333133323332372C,0x35333038313233332C35333039323839302C35333039363030392C35333039393133312C35333130323431372C35333130343832372C35333130353834372C35333133323436352C),
 (123,'ZYG11A.bApr07','chr1','+',53081196,53132465,53081197,53132440,6,0x35333038313139362C35333039323732342C35333039353235372C35333039383939302C35333130323234302C35333133323333332C,0x35333038313233332C35333039323839302C35333039363030392C35333039393133312C35333130323338372C35333133323436352C),
 (123,'SCP2.bApr07','chr1','+',53165527,53289678,53165527,53231537,17,0x35333136353532372C35333138303035352C35333138363236382C35333138393031342C35333139323939392C35333139393736322C35333231333032382C35333231343934322C35333231363437362C35333231383635352C35333232363238382C35333233313531372C35333235333134392C35333236363232382C35333237373137362C35333238363131372C35333238383836382C,0x35333136353732352C35333138303131332C35333138363334302C35333138393134362C35333139333036342C35333139393838392C35333231333039322C35333231353032392C35333231363632372C35333231383830332C35333232363339362C35333233343236302C35333235333330332C35333236363333312C35333237373330362C35333238363139372C35333238393637382C),
 (123,'SCP2.cApr07','chr1','+',53165535,53232490,53165656,53231537,11,0x35333136353533352C35333138303035352C35333138363236382C35333139323939392C35333139393736322C35333231333032382C35333231343934322C35333231363437362C35333231383635352C35333232363238382C35333233313531372C,0x35333136353732352C35333138303131332C35333138363334302C35333139333036342C35333139393838392C35333231333039322C35333231353032392C35333231363632372C35333231383830332C35333232363339362C35333233323439302C),
 (123,'SCP2.aApr07','chr1','+',53165535,53289962,53165536,53288964,16,0x35333136353533352C35333138303035352C35333138363236382C35333138393031342C35333139323939392C35333139393736322C35333231333032382C35333231343934322C35333231363437362C35333231383635352C35333232363238382C35333235333134392C35333236363232382C35333237373137362C35333238363131372C35333238383836382C,0x35333136353732352C35333138303131332C35333138363334302C35333138393134362C35333139333036342C35333139393838392C35333231333039322C35333231353032392C35333231363632372C35333231383830332C35333232363339362C35333235333330332C35333236363333312C35333237373330362C35333238363139372C35333238393936322C),
 (123,'SCP2.fApr07','chr1','+',53187892,53216512,53189058,53216510,7,0x35333138373839322C35333138393031342C35333139323939392C35333139393736322C35333231333032382C35333231343934322C35333231363437362C,0x35333138373935312C35333138393134362C35333139333036342C35333139393838392C35333231333039322C35333231353032392C35333231363531322C),
 (123,'SLC1A7.aApr07','chr1','-',53325442,53380883,53326268,53380709,11,0x35333332353434322C35333332373133362C35333332383035392C35333332383837312C35333333303831332C35333333313732302C35333334313630352C35333334333939312C35333335333031372C35333337323630392C35333338303537342C,0x35333332363438372C35333332373233392C35333332383139342C35333332393036362C35333333313034372C35333333313832302C35333334313832382C35333334343033342C35333335333233332C35333337323638392C35333338303838332C),
 (123,'SLC1A7.dApr07','chr1','-',53346187,53380878,53346848,53380709,4,0x35333334363138372C35333335333031372C35333337323630392C35333338303537342C,0x35333334363839342C35333335333233332C35333337323638392C35333338303837382C),
 (124,'GLIS1.aApr07','chr1','-',53744491,53972464,53744879,53972165,10,0x35333734343439312C35333734373338302C35333734383130392C35333735323838352C35333735383839342C35333736333033372C35333736383035312C35333833323336382C35333833383336312C35333937323136322C,0x35333734353033372C35333734373534382C35333734383238382C35333735333034322C35333735393032372C35333736333134382C35333736383231332C35333833333235312C35333833383533392C35333937323436342C),
 (124,'DIO1.mApr07','chr1','+',54129491,54144463,0,0,5,0x35343132393439312C35343133323537342C35343134313331372C35343134323932362C35343134343335352C,0x35343132393535352C35343133323830382C35343134313532372C35343134333037302C35343134343436332C),
 (124,'DIO1.kApr07','chr1','+',54130417,54144555,54132600,54142967,4,0x35343133303431372C35343133323537342C35343134323932362C35343134343335352C,0x35343133303533372C35343133323830382C35343134333037302C35343134343535352C),
 (124,'DIO1.gApr07','chr1','+',54132445,54149354,54142976,54148260,4,0x35343133323434352C35343134323932362C35343134343335352C35343134383139312C,0x35343133323830382C35343134333037302C35343134343535352C35343134393335342C),
 (124,'DIO1.cApr07','chr1','+',54132447,54149347,54132471,54142967,3,0x35343133323434372C35343134323932362C35343134383139312C,0x35343133323830382C35343134333037302C35343134393334372C),
 (124,'DIO1.aApr07','chr1','+',54132448,54149347,54132471,54148260,3,0x35343133323434382C35343134343335352C35343134383139312C,0x35343133323830382C35343134343535352C35343134393334372C),
 (124,'DIO1.eApr07','chr1','+',54132449,54148284,54142976,54148260,4,0x35343133323434392C35343134323932362C35343134343335352C35343134383139312C,0x35343133323639392C35343134333037302C35343134343535352C35343134383238342C),
 (124,'DIO1.fApr07','chr1','+',54132449,54149347,54142976,54148260,4,0x35343133323434392C35343134323932362C35343134343335352C35343134383139312C,0x35343133323631362C35343134333037302C35343134343535352C35343134393334372C),
 (124,'DIO1.bApr07','chr1','+',54132453,54143115,54132471,54142967,2,0x35343133323435332C35343134323932362C,0x35343133323830382C35343134333131352C),
 (124,'DIO1.dApr07','chr1','+',54132469,54148260,54142976,54148260,5,0x35343133323436392C35343133323639392C35343134323932362C35343134343335352C35343134383139312C,0x35343133323631362C35343133323830382C35343134333037302C35343134343535352C35343134383236302C),
 (124,'DIO1.lApr07','chr1','+',54132471,54148260,54132471,54142947,3,0x35343133323437312C35343134323932362C35343134383139312C,0x35343133323639392C35343134333037302C35343134383236302C),
 (124,'DIO1.hApr07','chr1','+',54132471,54148260,54132471,54148196,2,0x35343133323437312C35343134383139312C,0x35343133323830382C35343134383236302C),
 (124,'DIO1.jApr07','chr1','+',54132471,54148260,54132473,54142967,5,0x35343133323437312C35343133323637312C35343134323932362C35343134343335352C35343134383139312C,0x35343133323534372C35343133323830382C35343134333037302C35343134343535352C35343134383236302C),
 (124,'DIO1.iApr07','chr1','+',54132471,54148260,54132801,54148260,4,0x35343133323437312C35343133323639392C35343134343335352C35343134383139312C,0x35343133323631362C35343133323830382C35343134343535352C35343134383236302C),
 (124,'CDCP2.pApr07','chr1','-',54379484,54410954,0,0,3,0x35343337393438342C35343338323832392C35343431303836332C,0x35343337393639342C35343338333037342C35343431303935342C),
 (124,'CDCP2.kApr07','chr1','-',54381652,54438333,54391436,54433858,8,0x35343338313635322C35343339313130342C35343339313335362C35343432323432312C35343432353931322C35343433333637392C35343433343632392C35343433383233362C,0x35343338333037342C35343339313236372C35343339313434322C35343432323532362C35343432363030302C35343433333937362C35343433343735322C35343433383333332C),
 (125,'slerby.aApr07','chr1','+',54654516,54659121,54654518,54659104,2,0x35343635343531362C35343635383835392C,0x35343635343534332C35343635393132312C),
 (125,'ACOT11andC1orf175andTTC4.tApr07','chr1','+',54780497,54835605,54822984,54835605,7,0x35343738303439372C35343832323931352C35343832343039352C35343833303830362C35343833323230312C35343833323831362C35343833353531392C,0x35343738303639382C35343832333132332C35343832343136352C35343833303836372C35343833323330302C35343833323935322C35343833353630352C),
 (125,'ACOT11andC1orf175andTTC4.lApr07','chr1','+',54780518,54848385,54830861,54847373,15,0x35343738303531382C35343832323931352C35343833303830362C35343833323230312C35343833323831362C35343833353531392C35343833373535362C35343833393532392C35343834303932392C35343834323133312C35343834323630362C35343834333333362C35343834353339342C35343834363230322C35343834373231372C,0x35343738303639382C35343832333132332C35343833303836372C35343833323330302C35343833323935322C35343833353637362C35343833373637362C35343833393637342C35343834303938352C35343834323139382C35343834323639302C35343834333437302C35343834353532362C35343834363332392C35343834383338352C),
 (125,'ACOT11andC1orf175andTTC4.hApr07','chr1','+',54786395,54877453,54786570,54872990,17,0x35343738363339352C35343832323931352C35343832343039352C35343833303830362C35343833323230312C35343833323831362C35343833353531392C35343833373535362C35343833393532392C35343834303932392C35343834323133312C35343834323630362C35343834333333362C35343834353339342C35343834363230322C35343836383939342C35343837323934382C,0x35343738363630332C35343832333132332C35343832343136352C35343833303836372C35343833323330302C35343833323935322C35343833353637362C35343833373637362C35343833393637342C35343834303938352C35343834323139382C35343834323639302C35343834333437302C35343834353532362C35343834363332392C35343836393134372C35343837373435332C),
 (125,'ACOT11andC1orf175andTTC4.iApr07','chr1','+',54786488,54849689,54786570,54847373,16,0x35343738363438382C35343832323931352C35343832343039352C35343833303830362C35343833323230312C35343833323831362C35343833353531392C35343833373535362C35343833393532392C35343834303932392C35343834323133312C35343834323630362C35343834333333362C35343834353339342C35343834363230322C35343834373231372C,0x35343738363630332C35343832333132332C35343832343136352C35343833303836372C35343833323330302C35343833323935322C35343833353637362C35343833373637362C35343833393637342C35343834303938352C35343834323139382C35343834323639302C35343834333437302C35343834353532362C35343834363332392C35343834393638392C),
 (125,'ACOT11andC1orf175andTTC4.bApr07','chr1','+',54880031,54948527,54891187,54948448,24,0x35343838303033312C35343839303230392C35343839313131332C35343930333432372C35343930373131342C35343930383735372C35343930393036302C35343931313335312C35343931313936312C35343931323237362C35343931373030322C35343931373532332C35343931383135312C35343932303931362C35343932343531382C35343933303638342C35343933333633362C35343933383539302C35343933393430332C35343934303335302C35343934303838332C35343934343639352C35343934373237342C35343934383230362C,0x35343838303232392C35343839303234342C35343839323431382C35343930333530312C35343930373139382C35343930383833372C35343930393139302C35343931313434372C35343931323036362C35343931323431322C35343931373131352C35343931373730302C35343931383330362C35343932313035352C35343932343730392C35343933303832322C35343933333735312C35343933383732322C35343933393538332C35343934303530362C35343934313030362C35343934343739382C35343934373333372C35343934383532372C),
 (125,'ACOT11andC1orf175andTTC4.fApr07','chr1','+',54880046,54979996,54912276,54955821,33,0x35343838303034362C35343839303230392C35343839313131332C35343930333432372C35343930373131342C35343930383735372C35343930393036302C35343931313335312C35343931313936312C35343931323236302C35343931373030322C35343931373532332C35343931383135312C35343932303931362C35343932343531382C35343933303638342C35343933333633362C35343933383538312C35343933393430332C35343934303335302C35343934343639352C35343934373237342C35343935333738332C35343935343836302C35343935353735322C35343935393432332C35343936303933352C35343936363630362C35343936393734362C35343936393931352C35343937313838392C35343937353834322C35343937393637312C,0x35343838303232392C35343839303234342C35343839323431382C35343930333530312C35343930373139382C35343930383833372C35343930393139302C35343931313434372C35343931323036362C35343931323431322C35343931373131352C35343931373730302C35343931383330362C35343932313035352C35343932343730392C35343933303832322C35343933333735312C35343933383732322C35343933393538332C35343934303439372C35343934343739382C35343934373333372C35343935333837312C35343935343937382C35343935353931342C35343935393530312C35343936313036302C35343936363639332C35343936393831302C35343936393936312C35343937313937312C35343937353932352C35343937393939362C),
 (125,'ACOT11andC1orf175andTTC4.eApr07','chr1','+',54880047,54980568,54912276,54955821,33,0x35343838303034372C35343839303130342C35343839313131332C35343839373337352C35343930333432372C35343930373131342C35343930383735372C35343930393036302C35343931313335312C35343931313936312C35343931323236302C35343931373030322C35343931373532332C35343931383135312C35343932303931362C35343932343531382C35343933303638342C35343933333633362C35343933383538312C35343933393430332C35343934303335302C35343934303838332C35343934343639352C35343935333738332C35343935343836302C35343935353735322C35343935393432332C35343936303933352C35343936363630362C35343936393734362C35343937313838392C35343937353834322C35343937393637312C,0x35343838303232392C35343839303234342C35343839323431382C35343839373435302C35343930333530312C35343930373139382C35343930383833372C35343930393139302C35343931313434372C35343931323036362C35343931323431322C35343931373131352C35343931373730302C35343931383330362C35343932313035352C35343932343730392C35343933303832322C35343933333735312C35343933383732322C35343933393538332C35343934303530362C35343934313030362C35343934343739382C35343935333837312C35343935343937382C35343935353931342C35343935393530312C35343936313036302C35343936363639332C35343936393936312C35343937313937312C35343937353932352C35343938303536382C),
 (125,'ACOT11andC1orf175andTTC4.aApr07','chr1','+',54880062,54980492,54891187,54955821,33,0x35343838303036322C35343839303230392C35343839313131332C35343930333432372C35343930373131342C35343930383735372C35343930393036302C35343931313335312C35343931313936312C35343931323237362C35343931373030322C35343931373532332C35343931383135312C35343932303931362C35343932343531382C35343933303638342C35343933333633362C35343933383538312C35343933393430332C35343934303335302C35343934303838332C35343934343639352C35343934373237342C35343935333738332C35343935343836302C35343935353735322C35343935393432332C35343936303933352C35343936363630362C35343936393734362C35343937313838392C35343937353834322C35343937393637312C,0x35343838303232392C35343839303234342C35343839323431382C35343930333530312C35343930373139382C35343930383833372C35343930393139302C35343931313434372C35343931323036362C35343931323431322C35343931373131352C35343931373730302C35343931383330362C35343932313035352C35343932343730392C35343933303832322C35343933333735312C35343933383732322C35343933393538332C35343934303530362C35343934313030362C35343934343739382C35343934373333372C35343935333837312C35343935343937382C35343935353931342C35343935393530312C35343936313036302C35343936363639332C35343936393936312C35343937313937312C35343937353932352C35343938303439322C),
 (125,'ACOT11andC1orf175andTTC4.dApr07','chr1','+',54880206,54948520,54912276,54948448,24,0x35343838303230362C35343839303230392C35343839313131332C35343930333432372C35343930373131342C35343930383735372C35343930393036302C35343931313335312C35343931313936312C35343931323236302C35343931373030322C35343931373532332C35343931383135312C35343932303931362C35343932343531382C35343933303638342C35343933333633362C35343933383538312C35343933393430332C35343934303335302C35343934303838332C35343934343639352C35343934373237342C35343934383230362C,0x35343838303232332C35343839303234342C35343839323431382C35343930333530312C35343930373139382C35343930383833372C35343930393139302C35343931313434372C35343931323036362C35343931323431322C35343931373131352C35343931373730302C35343931383330362C35343932313035352C35343932343730392C35343933303832322C35343933333735312C35343933383732322C35343933393538332C35343934303530362C35343934313030362C35343934343739382C35343934373333372C35343934383532302C),
 (125,'ACOT11andC1orf175andTTC4.gApr07','chr1','+',54889497,54948527,54891187,54912344,21,0x35343838393439372C35343839313131332C35343930333432372C35343930373131342C35343930383735372C35343930393036302C35343931313335312C35343931313936312C35343931323236302C35343931373030322C35343931373532332C35343932303931362C35343933303638342C35343933333633362C35343933383538312C35343933393430332C35343934303335302C35343934303838332C35343934343639352C35343934373237342C35343934383230362C,0x35343839303234342C35343839323431382C35343930333530312C35343930373139382C35343930383833372C35343930393139302C35343931313434372C35343931323036362C35343931323431322C35343931373131352C35343931373730302C35343932313035352C35343933303832322C35343933333735312C35343933383732322C35343933393538332C35343934303530362C35343934313030362C35343934343739382C35343934373333372C35343934383532372C),
 (125,'ACOT11andC1orf175andTTC4.cApr07','chr1','+',54891149,54948527,54891187,54938420,24,0x35343839313134392C35343930333432372C35343930373131342C35343930383735372C35343930393036302C35343931313335312C35343931313936312C35343931323237362C35343931373030322C35343931373532332C35343931383135312C35343932303931362C35343932343531382C35343933303638342C35343933333633362C35343933353931332C35343933383332392C35343933383538312C35343933393430332C35343934303335302C35343934303838332C35343934343639352C35343934373237342C35343934383230362C,0x35343839323431382C35343930333530312C35343930373139382C35343930383833372C35343930393139302C35343931313434372C35343931323036362C35343931323431322C35343931373131352C35343931373730302C35343931383330362C35343932313035352C35343932343730392C35343933303832322C35343933333735312C35343933353935312C35343933383439322C35343933383732322C35343933393538332C35343934303530362C35343934313030362C35343934343739382C35343934373333372C35343934383532372C),
 (125,'ACOT11andC1orf175andTTC4.mApr07','chr1','+',54892347,54948527,54924560,54948448,20,0x35343839323334372C35343930333432372C35343930373131342C35343930393036302C35343931313335312C35343931313936312C35343931323237362C35343931373030322C35343931373532332C35343931383135312C35343932343531382C35343933303638342C35343933333633362C35343933383539302C35343933393430332C35343934303335302C35343934303838332C35343934343639352C35343934373237342C35343934383230362C,0x35343839323431382C35343930333530312C35343930373139382C35343930393139302C35343931313434372C35343931323036362C35343931323431322C35343931373131352C35343931373730302C35343931383330362C35343932343730392C35343933303832322C35343933333735312C35343933383732322C35343933393538332C35343934303530362C35343934313030362C35343934343739382C35343934373333372C35343934383532372C),
 (125,'C1orf177.bApr07','chr1','+',55044324,55080803,55044377,55079937,11,0x35353034343332342C35353034353235362C35353034353738362C35353034363134392C35353035303035342C35353035303330362C35353035323037342C35353035333137342C35353035353234392C35353037393837362C35353038303036312C,0x35353034343438312C35353034353334342C35353034353935312C35353034363237322C35353035303139322C35353035303435302C35353035323233362C35353035333330302C35353035353338332C35353037393936332C35353038303830332C),
 (125,'C1orf177.aApr07','chr1','+',55044362,55080524,55044377,55080134,10,0x35353034343336322C35353034353235362C35353034353738362C35353034363134392C35353035303035342C35353035303330362C35353035323037342C35353035333137342C35353035353234392C35353038303036312C,0x35353034343438312C35353034353334342C35353034353935312C35353034363237322C35353035303139322C35353035303435302C35353035323233362C35353035333330302C35353035353338332C35353038303532342C),
 (125,'TMEM61.cApr07','chr1','+',55125075,55224543,55125297,55224543,2,0x35353132353037352C35353232343335372C,0x35353132353339362C35353232343534332C),
 (125,'USP24.bApr07','chr1','-',55304619,55324800,55310068,55324340,14,0x35353330343631392C35353330363939322C35353331303036362C35353331303537372C35353331313034362C35353331323038382C35353331333731372C35353331353439352C35353331363739382C35353331373739382C35353331393538322C35353332313533322C35353332323033322C35353332343230322C,0x35353330353136392C35353330373336382C35353331303138352C35353331303636342C35353331313132322C35353331323136372C35353331333738342C35353331353536312C35353331363931322C35353331373932302C35353331393638352C35353332313632352C35353332323134392C35353332343830302C),
 (125,'USP24.aApr07','chr1','-',55304619,55416367,55307305,55416366,67,0x35353330343631392C35353331303037342C35353331303537372C35353331313034362C35353331323038382C35353331333731372C35353331353439352C35353331363739382C35353331373739382C35353331393538322C35353332313533322C35353332323033322C35353332343230322C35353332373838372C35353333303238332C35353333313038312C35353333323139372C35353333333531352C35353333343735382C35353333353231322C35353333353835382C35353333363230332C35353333363733362C35353333383033312C35353333393039392C35353333393834342C35353334323133362C35353334343430362C35353334353439392C35353334383434352C35353335383835362C35353335393639362C35353336313730372C35353336323732392C35353336333538302C35353336333932332C35353336373733372C35353337303830352C35353337323333302C35353337323538382C35353337353737352C35353337363036362C35353337363836382C35353337373230342C35353337393837362C35353338313030322C35353338313233392C35353338323338372C35353338343235382C35353338353138392C35353338353930392C35353338363732332C35353339323133302C35353339323337392C35353339323633312C35353339323933312C35353339353230382C35353339353531362C35353339373133382C35353339373837312C35353430303435392C35353430343134352C35353430343832382C35353430393831362C35353431303633372C35353431343633362C35353431363232372C,0x35353330373336382C35353331303138352C35353331303636342C35353331313132322C35353331323136372C35353331333738342C35353331353536312C35353331363931322C35353331373932302C35353331393638352C35353332313632352C35353332323134392C35353332343239392C35353332383030312C35353333303338372C35353333313137372C35353333323334382C35353333333635372C35353333343838332C35353333353433332C35353333353937382C35353333363334352C35353333363831392C35353333383133302C35353333393232352C35353333393936342C35353334323238312C35353334343532342C35353334353639312C35353334383530372C35353335393031372C35353335393736372C35353336313836332C35353336323838392C35353336333830392C35353336343031392C35353336373833352C35353337303936312C35353337323432342C35353337323637342C35353337353934392C35353337363136352C35353337363937392C35353337373237312C35353337393939322C35353338313035362C35353338313338302C35353338323436342C35353338343337302C35353338353332312C35353338363035392C35353338363833312C35353339323137382C35353339323534312C35353339323732372C35353339333033392C35353339353331322C35353339353633312C35353339373239372C35353339373934362C35353430303532352C35353430343231312C35353430343836342C35353430393933392C35353431303738312C35353431343730342C35353431363336372C),
 (125,'USP24.eApr07','chr1','-',55307349,55312743,55307350,55311208,4,0x35353330373334392C35353331303037342C35353331303537372C35353331313034362C,0x35353330373336382C35353331303138352C35353331303636342C35353331323734332C),
 (125,'USP24.dApr07','chr1','-',55309533,55313760,55309694,55313760,6,0x35353330393533332C35353331303037342C35353331303537372C35353331313034362C35353331323038382C35353331333731372C,0x35353330393735312C35353331303138352C35353331303636342C35353331313132322C35353331323136372C35353331333736302C),
 (126,'FLJ45337.aApr07','chr1','+',55819298,55973263,55969633,55970380,3,0x35353831393239382C35353835333138312C35353936393434302C,0x35353831393435352C35353835333236332C35353937333236332C),
 (126,'bleypeybo.cApr07','chr1','+',56062044,56118165,0,0,6,0x35363036323034342C35363037303532342C35363038353638392C35363130363335382C35363130393637392C35363131373635332C,0x35363036323136322C35363037303638362C35363038353739382C35363130363531342C35363130393731392C35363131383136352C),
 (126,'bleypeybo.eApr07','chr1','+',56062064,56199452,0,0,5,0x35363036323036342C35363037303532342C35363039393435392C35363130313139322C35363139393333342C,0x35363036323136322C35363037303638362C35363039393530352C35363130313332302C35363139393435322C),
 (126,'bleypeybo.dApr07','chr1','+',56062067,56106505,0,0,5,0x35363036323036372C35363037303532342C35363038353638392C35363130313139322C35363130363335382C,0x35363036323136322C35363037303638362C35363038353739382C35363130313332302C35363130363530352C),
 (126,'bleypeybo.bApr07','chr1','+',56081638,56106369,56085729,56106369,4,0x35363038313633382C35363038353638392C35363039393435392C35363130363335382C,0x35363038313939382C35363038353739382C35363039393530352C35363130363336392C),
 (126,'sheeboy.aApr07','chr1','-',56486540,56496832,0,0,3,0x35363438363534302C35363439313931322C35363439363632382C,0x35363438373436312C35363439323135332C35363439363833322C),
 (127,'PPAP2B.aApr07','chr1','-',56731524,56818247,56734810,56817472,7,0x35363733313532342C35363733323532372C35363735303233352C35363736323038322C35363736323533362C35363737353231342C35363831373133382C,0x35363733313935302C35363733343933362C35363735303431322C35363736323134302C35363736323831342C35363737353337322C35363831383234372C),
 (127,'PPAP2B.bApr07','chr1','-',56734693,56817398,56734810,56817396,3,0x35363733343639332C35363735303233352C35363831373133382C,0x35363733343933362C35363735303431322C35363831373339382C),
 (127,'PPAP2B.cApr07','chr1','-',56734733,56762166,56734810,56762166,3,0x35363733343733332C35363735303233352C35363736323038322C,0x35363733343933362C35363735303431322C35363736323136362C),
 (127,'PRKAA2.aApr07','chr1','+',56883578,56953596,56883648,56945974,9,0x35363838333537382C35363931323634312C35363932393635342C35363933303631382C35363933323032352C35363933343139352C35363934323233312C35363934343335322C35363934353733352C,0x35363838333734322C35363931323738332C35363932393734382C35363933303736332C35363933323131332C35363933343432302C35363934323733362C35363934343437392C35363935333539362C),
 (127,'C1orf168.aApr07','chr1','-',56957065,57057631,56957931,57057551,20,0x35363935373036352C35363935383238322C35363935383433332C35363936313834382C35363936343735372C35363937353334372C35363937363838352C35363937383935372C35363938303432312C35363938323238362C35363938323431322C35363938393330342C35363939323039392C35363939343135362C35363939363937362C35373030363038392C35373032353433352C35373032373233332C35373033303331362C35373035373534322C,0x35363935373935332C35363935383331362C35363935383539302C35363936313934322C35363936343834342C35363937353430382C35363937363931342C35363937393035362C35363938303438322C35363938323332372C35363938323532372C35363938393436342C35363939323139362C35363939343138382C35363939373031312C35373030363139392C35373032353436392C35373032373339352C35373033313036342C35373035373633312C),
 (127,'C1orf168.bApr07','chr1','-',56964799,57057956,56970152,56989428,14,0x35363936343739392C35363937303135322C35363937353334372C35363937363838352C35363937383935372C35363938303432312C35363938323238362C35363938323431322C35363938393330342C35373030363038392C35373032353433352C35373032373233332C35373033303331362C35373035373534322C,0x35363936343834342C35363937303232382C35363937353430382C35363937363931342C35363937393035362C35363938303438322C35363938323332372C35363938323532372C35363938393436342C35373030363139392C35373032353436392C35373032373339352C35373033313036342C35373035373935362C),
 (127,'C8A.aApr07','chr1','+',57093028,57156482,57093162,57155977,11,0x35373039333032382C35373130353836392C35373131333230392C35373131343332322C35373131393730352C35373132313734312C35373132343138372C35373134343932372C35373134363231362C35373135303636332C35373135353832352C,0x35373039333233392C35373130353936332C35373131333335342C35373131343437302C35373131393839352C35373132313934322C35373132343432382C35373134353035332C35373134363337342C35373135303838362C35373135363438322C),
 (127,'DAB1.dApr07','chr1','-',57235477,57545625,57248955,57529290,14,0x35373233353437372C35373234383934302C35373234393430352C35373235333134332C35373236313739312C35373236343234312C35373237313738332C35373330313134342C35373330393738322C35373331303534332C35373337343830332C35373338333535302C35373532393232332C35373534353131382C,0x35373233363338392C35373234393035312C35373234393533332C35373235333639322C35373236313930302C35373236343330342C35373237313833342C35373330313230342C35373330393930322C35373331303637352C35373337343930322C35373338333639302C35373532393432362C35373534353632352C),
 (127,'DAB1.fApr07','chr1','-',57236166,57663575,57248955,57663070,6,0x35373233363136362C35373234383934302C35373234393430352C35373235333134332C35373636323837382C35373636333532382C,0x35373233363338392C35373234393035312C35373234393533332C35373235333232332C35373636333338352C35373636333537352C),
 (127,'DAB1.bApr07','chr1','-',57236166,57661460,57248955,57529290,15,0x35373233363136362C35373234383934302C35373234393430352C35373235333134332C35373236313739312C35373236343234312C35373330313135302C35373330373632302C35373330393238332C35373330393738322C35373331303534332C35373337343830332C35373338333535302C35373532393232332C35373636313237362C,0x35373233363338392C35373234393035312C35373234393533332C35373235333639322C35373236313930302C35373236343330342C35373330313230342C35373330373638362C35373330393332322C35373330393930322C35373331303637352C35373337343930322C35373338333639302C35373532393432362C35373636313436302C),
 (127,'DAB1.eApr07','chr1','-',57236276,57662350,57248955,57529290,13,0x35373233363237362C35373234383934302C35373234393430352C35373235333134332C35373236313739312C35373236343234312C35373237313634362C35373237313738332C35373330313134342C35373337343830332C35373338333535302C35373532393232332C35373636323138392C,0x35373233363338392C35373234393035312C35373234393533332C35373235333639322C35373236313930302C35373236343330342C35373237313639342C35373237313833342C35373330313230342C35373337343930322C35373338333639302C35373532393432362C35373636323335302C),
 (127,'DAB1.cApr07','chr1','-',57236285,57662679,57248955,57529290,15,0x35373233363238352C35373234383934302C35373234393430352C35373235333134332C35373236313739312C35373236343234312C35373237313634362C35373237313738332C35373330313134342C35373330393738322C35373331303534332C35373337343830332C35373338333535302C35373532393232332C35373636323435332C,0x35373233363338392C35373234393035312C35373234393533332C35373235333639322C35373236313930302C35373236343330342C35373237313639342C35373237313833342C35373330313230342C35373330393930322C35373331303637352C35373337343930322C35373338333639302C35373532393432362C35373636323637392C),
 (127,'DAB1.hApr07','chr1','-',57253649,57301777,57253651,57264274,4,0x35373235333634392C35373236313739312C35373236343234312C35373330313134342C,0x35373235333639322C35373236313930302C35373236343330342C35373330313737372C),
 (128,'DAB1.kApr07','chr1','-',58064326,58122345,0,0,2,0x35383036343332362C35383132323235382C,0x35383036343731352C35383132323334352C),
 (128,'kasuyo.aApr07','chr1','+',58191994,58228522,0,0,3,0x35383139313939342C35383139333831322C35383232383233332C,0x35383139323030362C35383139343336332C35383232383532322C),
 (128,'sparrubo.aApr07','chr1','-',58492066,58650660,0,0,4,0x35383439323036362C35383530303731392C35383531353538382C35383635303534342C,0x35383439323138392C35383530303834302C35383531353933322C35383635303636302C),
 (129,'sima.aApr07','chr1','+',59023421,59139256,59023563,59134581,5,0x35393032333432312C35393133313830342C35393133343531362C35393133373330362C35393133383730392C,0x35393032333536362C35393133313937372C35393133343634352C35393133373434302C35393133393235362C),
 (129,'sima.bApr07','chr1','+',59023423,59137748,0,0,2,0x35393032333432332C35393133373330362C,0x35393032333536352C35393133373734382C),
 (129,'LOC729467.bApr07','chr1','-',59370195,59385067,59371511,59385066,3,0x35393337303139352C35393337313439302C35393338343933352C,0x35393337313030362C35393337313539302C35393338353036372C),
 (129,'LOC729467.aApr07','chr1','-',59370881,59436882,59370969,59436563,3,0x35393337303838312C35393337313439302C35393433363434322C,0x35393337313030362C35393337313539302C35393433363838322C),
 (129,'FLJ10986.lApr07','chr1','+',59535047,59695336,59559809,59695335,6,0x35393533353034372C35393535393739352C35393537383231372C35393538343530362C35393631373030382C35393639353232302C,0x35393533353136372C35393536303031302C35393537383332392C35393538343635382C35393631373039372C35393639353333362C),
 (129,'FLJ10986.tApr07','chr1','+',59535092,59695372,59584529,59695359,5,0x35393533353039322C35393537383231372C35393538343530362C35393631373030382C35393639353232302C,0x35393533353136372C35393537383332392C35393538343635382C35393631373039372C35393639353337322C),
 (129,'FLJ10986.mApr07','chr1','+',59535369,59750875,59535370,59750785,5,0x35393533353336392C35393538343530362C35393631373030382C35393639353232302C35393735303537302C,0x35393533353431302C35393538343635382C35393631373039372C35393639353333362C35393735303837352C),
 (130,'FLJ10986.hApr07','chr1','+',59792177,60000988,59792481,60000844,10,0x35393739323137372C35393739323338332C35393834363036322C35393836343234372C35393837363438372C35393839383437382C35393930353534322C35393931323239382C35393939363139302C36303030303736322C,0x35393739323231372C35393739323438372C35393834363137302C35393836343330392C35393837363633352C35393839383535332C35393930353636332C35393931323339332C35393939363235322C36303030303938382C),
 (130,'FLJ10986.vaApr07','chr1','+',59891727,60000982,59905569,60000844,6,0x35393839313732372C35393839383437382C35393930353534322C35393931323239382C35393939363139302C36303030303736322C,0x35393839313737392C35393839383535332C35393930353636332C35393931323339332C35393939363235322C36303030303938322C),
 (130,'CYP2J2.aApr07','chr1','-',60131567,60165033,60131910,60165006,9,0x36303133313536372C36303133393232342C36303134333133302C36303134363034352C36303134383034332C36303134393836372C36303135303432312C36303135343139372C36303136343739362C,0x36303133323038392C36303133393336332C36303134333331382C36303134363138372C36303134383232302C36303135303032382C36303135303537312C36303135343336302C36303136353033332C),
 (130,'CYP2J2.cApr07','chr1','-',60131575,60165021,60139298,60165006,8,0x36303133313537352C36303133393232342C36303134363034352C36303134383034332C36303134393836372C36303135303432312C36303135343139372C36303136343739362C,0x36303133323038392C36303133393336332C36303134363138372C36303134383232302C36303135303032382C36303135303537312C36303135343336302C36303136353032312C),
 (130,'CYP2J2.bApr07','chr1','-',60131602,60165021,60142758,60165006,10,0x36303133313630322C36303133393232342C36303134323632352C36303134333133302C36303134363034352C36303134383034332C36303134393836372C36303135303432312C36303135343139372C36303136343739362C,0x36303133323038392C36303133393336332C36303134323737362C36303134333331382C36303134363138372C36303134383232302C36303135303032382C36303135303537312C36303135343336302C36303136353032312C),
 (130,'CYP2J2.eApr07','chr1','-',60148170,60165014,60148172,60154261,5,0x36303134383137302C36303134393836372C36303135303432312C36303135343139372C36303136343738302C,0x36303134383232302C36303135303032382C36303135303537312C36303135343336302C36303136353031342C),
 (130,'CYP2J2.hApr07','chr1','-',60150461,60206245,0,0,4,0x36303135303436312C36303135343139372C36303230323634322C36303230363139362C,0x36303135303537312C36303135343336302C36303230323931312C36303230363234352C),
 (130,'CYP2J2.iApr07','chr1','-',60150512,60164986,0,0,4,0x36303135303531322C36303135343139372C36303136343130382C36303136343739362C,0x36303135303537312C36303135343336302C36303136343237382C36303136343938362C),
 (130,'CYP2J2.gApr07','chr1','-',60154197,60206245,60154198,60202625,3,0x36303135343139372C36303230323631392C36303230363139362C,0x36303135343336302C36303230323931312C36303230363234352C),
 (130,'CYP2J2.jApr07','chr1','-',60154221,60206228,0,0,3,0x36303135343232312C36303230323634362C36303230363139362C,0x36303135343336302C36303230323931312C36303230363232382C),
 (130,'C1orf87.aApr07','chr1','-',60228653,60312020,60228932,60310903,12,0x36303232383635332C36303233353836382C36303233393333362C36303234383635312C36303236333636302C36303237313733352C36303237363235312C36303237383137362C36303237393235302C36303239333436332C36303331303739362C36303331313934392C,0x36303232393039332C36303233363037362C36303233393431362C36303234383731362C36303236333735382C36303237313930312C36303237363336372C36303237383434302C36303237393339312C36303239333639382C36303331303933302C36303331323032302C),
 (130,'C1orf87.bApr07','chr1','-',60235949,60311996,60235950,60311994,7,0x36303233353934392C36303233393333362C36303234383635312C36303236333636302C36303239333436332C36303331303739362C36303331313934392C,0x36303233363037362C36303233393431362C36303234383731362C36303236333735382C36303239333639382C36303331303933302C36303331313939362C),
 (130,'kisuyo.aApr07','chr1','-',60580725,60728778,60580784,60728501,2,0x36303538303732352C36303732383338372C,0x36303538303839382C36303732383737382C),
 (131,'riyuro.bApr07','chr1','-',60897890,61063840,60967915,61063762,6,0x36303839373839302C36303930313234342C36303936373833342C36303937303730362C36303937313732332C36313036333539352C,0x36303839393733302C36303930313238352C36303936373932372C36303937303736382C36303937313738322C36313036333834302C),
 (131,'riyuro.aApr07','chr1','-',60899443,61106215,60899593,61064777,5,0x36303839393434332C36303930313234342C36313036333539352C36313036343638312C36313130363137362C,0x36303839393733302C36303930313238352C36313036333634352C36313036343834352C36313130363231352C),
 (131,'riyuro.cApr07','chr1','-',60915587,61106215,60967915,61064777,7,0x36303931353538372C36303936373833342C36303937303730362C36303937313732332C36313036333539352C36313036343638312C36313130363137362C,0x36303931353637322C36303936373932372C36303937303736382C36303937313738322C36313036333634352C36313036343834352C36313130363231352C),
 (131,'riyuro.dApr07','chr1','-',60967882,61106246,60967915,61064777,7,0x36303936373838322C36303937303730362C36303937313732332C36313036333539352C36313036343638312C36313036393836372C36313130363137362C,0x36303936373932372C36303937303736382C36303937313738322C36313036333634352C36313036343834352C36313036393938352C36313130363234362C),
 (131,'NFIA.dApr07','chr1','+',61292084,61597534,61327061,61597533,6,0x36313239323038342C36313332363430382C36313531353737392C36313537303831382C36313539303730392C36313539373430362C,0x36313239323134362C36313332373134392C36313531353833382C36313537303834362C36313539303832372C36313539373533342C),
 (131,'NFIA.cApr07','chr1','+',61320026,61694146,61320027,61693580,10,0x36313332303032362C36313531353737392C36313537303737312C36313539303730392C36313539373430362C36313632313439362C36313634323336332C36313634343832312C36313637373731302C36313639333536322C,0x36313332303137352C36313531353834352C36313537303834362C36313539303832372C36313539373533342C36313632313632352C36313634323534322C36313634343938372C36313637373737382C36313639343134362C),
 (131,'NFIA.eApr07','chr1','+',61320122,61371282,61320203,61370971,4,0x36313332303132322C36313332313032302C36313332363430382C36313337303935342C,0x36313332303330372C36313332313037382C36313332363934302C36313337313238322C),
 (131,'NFIA.aApr07','chr1','+',61320498,61696544,61321051,61693580,11,0x36313332303439382C36313332363430382C36313531353737392C36313537303737312C36313539303730392C36313539373430362C36313632313439362C36313634323336332C36313634343832312C36313636343732342C36313639333536322C,0x36313332313037382C36313332363934302C36313531353834352C36313537303834362C36313539303832372C36313539373533342C36313632313632352C36313634323534322C36313634343938372C36313636343831362C36313639363534342C),
 (131,'NFIA.bApr07','chr1','+',61320881,61694658,61321051,61693639,10,0x36313332303838312C36313332363430382C36313531353737392C36313537303737312C36313539303730392C36313539373430362C36313632313439362C36313634323336332C36313634343832312C36313639333536322C,0x36313332313037382C36313332363934302C36313531353834352C36313537303834362C36313539303832372C36313539373533342C36313632313632352C36313634323534322C36313634343938372C36313639343635382C),
 (131,'luzawbo.aApr07-unspliced','chr1','+',61341323,61341749,0,0,1,0x36313334313332332C,0x36313334313734392C),
 (131,'NFIA.fApr07','chr1','+',61441790,61642486,61590777,61642485,8,0x36313434313739302C36313531353737392C36313537303737312C36313539303730392C36313539373430362C36313632313439362C36313632343133302C36313634323336332C,0x36313434313831382C36313531353834352C36313537303834362C36313539303832372C36313539373533342C36313632313632352C36313632343138342C36313634323438362C),
 (132,'INADL.cApr07','chr1','+',61980739,62353185,62001152,62352510,34,0x36313938303733392C36323030313131372C36323030313237322C36323030343533382C36323030373534322C36323030393639302C36323031333436352C36323032363031332C36323032393630372C36323033333732362C36323033353534362C36323033393838322C36323034333730372C36323034363733332C36323036313230342C36323036353638312C36323037313931332C36323039343238392C36323039393831302C36323130323439372C36323131333530322C36323132323439362C36323133373834322C36323133393534312C36323134363633312C36323135323834362C36323136353938392C36323232383432372C36323235363131352C36323237363233362C36323238393232352C36323331373730392C36323332323737342C36323335323331322C,0x36313938303831352C36323030313137342C36323030313433392C36323030343733332C36323030373638322C36323030393838362C36323031333539342C36323032363233322C36323032393730372C36323033333831382C36323033353638382C36323034303032392C36323034333738342C36323034363739302C36323036313333392C36323036353834332C36323037323034352C36323039343439392C36323039393932372C36323130323839332C36323131333632362C36323132323636382C36323133373931342C36323133393731392C36323134363734322C36323135323932342C36323136363038392C36323232383632342C36323235363230372C36323237363330392C36323238393331382C36323331373832372C36323332323930382C36323335333138352C),
 (132,'INADL.bApr07','chr1','+',61980739,62355655,62001152,62355505,38,0x36313938303733392C36323030313131372C36323030313237322C36323030343533382C36323030373534322C36323030393639302C36323031333436352C36323032363031332C36323032393630372C36323033333732362C36323033353534362C36323033393838322C36323034333730372C36323034363733332C36323036313230342C36323036353638312C36323037313931332C36323039343238392C36323039393831302C36323130323439372C36323131333530322C36323132323439362C36323133373834322C36323133393534312C36323134363633312C36323135323834362C36323136353938392C36323232383432372C36323235363131352C36323237363233362C36323238393232352C36323331373730392C36323332323737342C36323333383537382C36323334363639362C36323335323331322C36323335343739312C36323335353339312C,0x36313938303831352C36323030313137342C36323030313433392C36323030343733332C36323030373638322C36323030393838362C36323031333539342C36323032363233322C36323032393730372C36323033333831382C36323033353638382C36323034303032392C36323034333738342C36323034363739302C36323036313333392C36323036353834332C36323037323034352C36323039343439392C36323039393932372C36323130323839332C36323131333632362C36323132323636382C36323133373931342C36323133393731392C36323134363734322C36323135323932342C36323136363038392C36323232383632342C36323235363230372C36323237363330392C36323238393331382C36323331373832372C36323332323930382C36323333383636382C36323334363738302C36323335323530362C36323335343933392C36323335353635352C),
 (132,'INADL.aApr07','chr1','+',61980739,62402180,62001152,62399195,43,0x36313938303733392C36323030313131372C36323030313237322C36323030343533382C36323030373534322C36323030393639302C36323031333436352C36323032363031332C36323032393630372C36323033333732362C36323033353534362C36323033393838322C36323034333730372C36323034363733332C36323036313230342C36323036353638312C36323037313931332C36323039343238392C36323039393831302C36323130323439372C36323131333530322C36323132323439362C36323133373834322C36323133393534312C36323134363633312C36323135323834362C36323136353938392C36323232383432372C36323235363131352C36323237363233362C36323238393232352C36323331373730392C36323332323737342C36323334363639362C36323335323331322C36323335343739312C36323335353339312C36323335393434302C36323336313238302C36323336363233312C36323336373130302C36323338363534332C36323339393136372C,0x36313938303831352C36323030313137342C36323030313433392C36323030343733332C36323030373638322C36323030393838362C36323031333539342C36323032363233322C36323032393730372C36323033333831382C36323033353638382C36323034303032392C36323034333738342C36323034363739302C36323036313333392C36323036353834332C36323037323034352C36323039343439392C36323039393932372C36323130323839332C36323131333632362C36323132323636382C36323133373931342C36323133393731392C36323134363734322C36323135323932342C36323136363038392C36323232383632342C36323235363230372C36323237363330392C36323238393331382C36323331373832372C36323332323930382C36323334363738302C36323335323530362C36323335343933392C36323335353437382C36323335393535352C36323336313331382C36323336363335342C36323336373230352C36323338363635302C36323430323138302C),
 (132,'INADL.dApr07','chr1','+',62029529,62401766,62035642,62361308,37,0x36323032393532392C36323033333732362C36323033353534362C36323033393838322C36323034333730372C36323034363733332C36323036313230342C36323036353638312C36323037313931332C36323039343238392C36323039393831302C36323130323439372C36323131333530322C36323132323439362C36323133373834322C36323133393534312C36323134363633312C36323135323834362C36323136353938392C36323232383432372C36323235363131352C36323237363233362C36323238393232352C36323331373730392C36323332323737342C36323334363639362C36323335323331322C36323335343739312C36323335353339312C36323335393434352C36323336313238302C36323336363233312C36323336373130302C36323338363534332C36323339313631372C36323339393136372C36323430313134322C,0x36323032393730372C36323033333831382C36323033353638382C36323034303032392C36323034333738342C36323034363739302C36323036313333392C36323036353834332C36323037323034352C36323039343439392C36323039393932372C36323130323839332C36323131333632362C36323132323636382C36323133373931342C36323133393731392C36323134363734322C36323135323932342C36323136363038392C36323232383632342C36323235363230372C36323237363330392C36323238393331382C36323331373832372C36323332323930382C36323334363738302C36323335323530362C36323335343933392C36323335353437382C36323335393535352C36323336313331382C36323336363335342C36323336373230352C36323338363635302C36323339313734312C36323339393634392C36323430313736362C),
 (132,'INADL.eApr07','chr1','+',62113591,62353185,62113592,62352510,15,0x36323131333539312C36323132323439362C36323133373834322C36323133393534312C36323134363633312C36323135323834362C36323136353938392C36323232383432372C36323235363131352C36323237363233362C36323238393232352C36323331373730392C36323332323737342C36323334363639362C36323335323331322C,0x36323131333632362C36323132323636382C36323133373931342C36323133393731392C36323134363734322C36323135323932342C36323136363038392C36323232383632342C36323235363230372C36323237363330392C36323238393331382C36323331373832372C36323332323930382C36323334363738302C36323335333138352C),
 (132,'INADL.fApr07','chr1','+',62190124,62317827,62190649,62317826,6,0x36323139303132342C36323232383432372C36323235363131352C36323237363233362C36323238393232352C36323331373730392C,0x36323139303637312C36323232383632342C36323235363230372C36323237363330392C36323238393331382C36323331373832372C),
 (132,'INADL.hApr07','chr1','+',62194438,62317744,62194495,62317742,6,0x36323139343433382C36323232383432372C36323235363131352C36323237363233362C36323238393232352C36323331373730392C,0x36323139343530352C36323232383632342C36323235363230372C36323237363330392C36323238393331382C36323331373734342C),
 (132,'INADL.iApr07','chr1','+',62211601,62289318,62211657,62289318,5,0x36323231313630312C36323232383432372C36323235363131352C36323237363233362C36323238393232352C,0x36323231313730302C36323232383632342C36323235363230372C36323237363330392C36323238393331382C),
 (132,'INADL.qApr07','chr1','+',62211628,62322784,62211657,62276308,6,0x36323231313632382C36323232383432372C36323237363233362C36323238393232352C36323331373730392C36323332323737342C,0x36323231313730302C36323232383632342C36323237363330392C36323238393331382C36323331373832372C36323332323738342C),
 (132,'rarkoybu.bApr07','chr1','+',62390089,62391291,0,0,2,0x36323339303038392C36323339313136312C,0x36323339303637372C36323339313239312C),
 (132,'ANKRD38.cApr07','chr1','-',62475406,62557559,62476536,62519824,9,0x36323437353430362C36323438353733312C36323439313332362C36323530313335312C36323530343939312C36323530363534362C36323530393733372C36323531393830382C36323535373336342C,0x36323437363634312C36323438353933322C36323439313436392C36323530313537312C36323530353037392C36323530363736352C36323530393834392C36323531393839342C36323535373535392C),
 (132,'ANKRD38.aApr07','chr1','-',62475408,62557673,62476536,62519824,10,0x36323437353430382C36323438353733312C36323439313332362C36323530313335312C36323530343939312C36323530363534362C36323530393733372C36323531313436332C36323531393830382C36323535373336342C,0x36323437363634312C36323438353933322C36323439313436392C36323530313537312C36323530353037392C36323530363736352C36323530393834392C36323531333334372C36323531393839342C36323535373637332C),
 (132,'DOCK7.dApr07','chr1','-',62693262,62892048,62693672,62892048,45,0x36323639333236322C36323639353739362C36323731323234302C36323731333436362C36323731333936352C36323731343332352C36323731353935382C36323732373139322C36323733303936322C36323733323533332C36323733333833392C36323733343539372C36323734323838382C36323734333934302C36323734363232302C36323734383833352C36323735313732392C36323735313937342C36323736363430392C36323736373533352C36323737333735312C36323737363134392C36323737373830332C36323737383031302C36323738303836362C36323738313931342C36323739303939302C36323739343038332C36323739373234372C36323739393837352C36323831353532302C36323831373038362C36323832313434322C36323832343736352C36323835363936342C36323835383135382C36323836333531372C36323836393439382C36323837313735362C36323837333033312C36323837343739352C36323838353934392C36323838363336342C36323838363637332C36323839313938332C,0x36323639333731352C36323639353936342C36323731323334372C36323731333631302C36323731343230322C36323731343431352C36323731363039332C36323732373332342C36323733313130362C36323733323732362C36323733333934302C36323733343735362C36323734333034312C36323734343037352C36323734363331372C36323734383933322C36323735313836352C36323735323135372C36323736363536342C36323736373730352C36323737333839312C36323737363332302C36323737373931372C36323737383135312C36323738303936322C36323738323030342C36323739313136302C36323739343234382C36323739373437392C36323739393936322C36323831353632322C36323831373232352C36323832313531332C36323832343838332C36323835373132372C36323835383235322C36323836333636302C36323836393636342C36323837313833372C36323837333138312C36323837343836322C36323838363033352C36323838363537372C36323838363830332C36323839323034382C),
 (132,'DOCK7.eApr07','chr1','-',62693269,62794228,62693672,62794228,30,0x36323639333236392C36323639353739362C36323731323234302C36323731333436362C36323731333936352C36323731343332352C36323731353935382C36323732353635362C36323732373139322C36323733303936322C36323733323533332C36323733333833392C36323733343539372C36323734323838382C36323734333934302C36323734363232302C36323734383833352C36323735313732392C36323735313937342C36323736363430392C36323736373533352C36323737333735312C36323737363134392C36323737373830332C36323737383031302C36323738303836362C36323738313931342C36323738333230352C36323739303939302C36323739343038332C,0x36323639333731352C36323639353936342C36323731323334372C36323731333631302C36323731343230322C36323731343431352C36323731363038342C36323732353637312C36323732373332342C36323733313130362C36323733323732362C36323733333934302C36323733343735362C36323734333034312C36323734343037352C36323734363331372C36323734383933322C36323735313836352C36323735323135372C36323736363536342C36323736373730352C36323737333839312C36323737363332302C36323737373931372C36323737383135312C36323738303936322C36323738323030342C36323738333239382C36323739313136302C36323739343232382C),
 (132,'DOCK7.cApr07','chr1','-',62693672,62892048,62693672,62892048,46,0x36323639333637322C36323639353739362C36323731323234302C36323731333436362C36323731333936352C36323731343332352C36323731353935382C36323732353635362C36323732373139322C36323733303936322C36323733323533332C36323733333833392C36323733343539372C36323734323838382C36323734333934302C36323734363232302C36323734383833352C36323735313732392C36323735313937342C36323736363430392C36323736373533352C36323737333735312C36323737363134392C36323737373830332C36323737383031302C36323738303836362C36323738313931342C36323739303939302C36323739343038332C36323739373234372C36323739393837352C36323831353532302C36323831373038362C36323832313434322C36323832343736352C36323835363936342C36323835383135382C36323836333531372C36323836393439382C36323837313735362C36323837333033312C36323837343739352C36323838353934392C36323838363336342C36323838363637332C36323839313938332C,0x36323639333731352C36323639353936342C36323731323334372C36323731333631302C36323731343230322C36323731343431352C36323731363038342C36323732353637312C36323732373332342C36323733313130362C36323733323732362C36323733333934302C36323733343735362C36323734333034312C36323734343037352C36323734363331372C36323734383933322C36323735313836352C36323735323135372C36323736363536342C36323736373730352C36323737333839312C36323737363332302C36323737373931372C36323737383135312C36323738303936322C36323738323030342C36323739313136302C36323739343234382C36323739373437392C36323739393936322C36323831353632322C36323831373232352C36323832313531332C36323832343838332C36323835373132372C36323835383235322C36323836333636302C36323836393636342C36323837313833372C36323837333138312C36323837343836322C36323838363033352C36323838363537372C36323838363830332C36323839323034382C),
 (132,'DOCK7.lApr07','chr1','-',62781897,62791160,62781899,62791158,2,0x36323738313839372C36323739303939302C,0x36323738323030342C36323739313136302C),
 (133,'ATG4C.kApr07','chr1','+',62992648,63054854,63042045,63054853,4,0x36323939323634382C36333034313937372C36333034333433302C36333035343833332C,0x36323939333132332C36333034323132312C36333034333531342C36333035343835342C),
 (133,'ATG4C.gApr07','chr1','+',63022099,63055051,63042045,63055051,4,0x36333032323039392C36333034313937372C36333034333433302C36333035343833332C,0x36333032323233362C36333034323132312C36333034333531342C36333035353035312C),
 (133,'ATG4C.cApr07','chr1','+',63022365,63103772,63042045,63102418,11,0x36333032323336352C36333034313937372C36333034333433302C36333035343833332C36333035373236332C36333035393339372C36333036373239382C36333037323239362C36333037333033342C36333037393638362C36333130323235302C,0x36333032323438342C36333034323132312C36333034333531342C36333035353036372C36333035373539342C36333035393436382C36333036373433352C36333037323337352C36333037333131312C36333037393830362C36333130333737322C),
 (133,'ATG4C.bApr07','chr1','+',63022375,63103522,63042045,63102418,11,0x36333032323337352C36333034313937372C36333034333433302C36333035343833332C36333035373236332C36333035393339372C36333036373239382C36333037323239362C36333037333033342C36333037393638362C36333130323235302C,0x36333032323533322C36333034323132312C36333034333531342C36333035353036372C36333035373539342C36333035393436382C36333036373433352C36333037323337352C36333037333131312C36333037393830362C36333130333532322C),
 (133,'ATG4C.iApr07','chr1','+',63022394,63055044,63042045,63055042,4,0x36333032323339342C36333034313938312C36333034333433302C36333035343833332C,0x36333032323438342C36333034323132312C36333034333531342C36333035353034342C),
 (133,'ATG4C.dApr07','chr1','+',63022396,63080273,63042045,63079836,10,0x36333032323339362C36333034323033362C36333034333433302C36333035343833332C36333035373236332C36333035393339372C36333036373239382C36333037323239362C36333037333033342C36333037393638362C,0x36333032323533322C36333034323132312C36333034333531342C36333035353036372C36333035373539342C36333035393436382C36333036373433352C36333037323337352C36333037333131312C36333038303237332C),
 (133,'ATG4C.aApr07','chr1','+',63022408,63102600,63042045,63102418,11,0x36333032323430382C36333034313938312C36333034333433302C36333035343833332C36333035373236332C36333035393339372C36333036373432362C36333037323239362C36333037333033342C36333037393638362C36333130323235302C,0x36333032323533322C36333034323132312C36333034333531342C36333035353036372C36333035373539342C36333035393436342C36333036373433352C36333037323337352C36333037333131312C36333037393830362C36333130323630302C),
 (133,'ATG4C.hApr07','chr1','+',63023266,63055042,63042045,63055042,4,0x36333032333236362C36333034313937372C36333034333433302C36333035343833332C,0x36333032333338342C36333034323132312C36333034333531342C36333035353034322C),
 (133,'ATG4C.eApr07','chr1','+',63023405,63057438,63042045,63057436,5,0x36333032333430352C36333034313937372C36333034333433302C36333035343833332C36333035373236332C,0x36333032333531392C36333034323132312C36333034333531342C36333035353036372C36333035373433382C),
 (133,'sorbor.aApr07','chr1','-',63306233,63391030,0,0,5,0x36333330363233332C36333330363639352C36333330373436312C36333331373135382C36333339303931372C,0x36333330363334392C36333330363739362C36333330373537312C36333331373239312C36333339313033302C),
 (133,'cheyrobo.bApr07','chr1','-',63428247,63555516,0,0,5,0x36333432383234372C36333433363937342C36333534323935332C36333535343230372C36333535353331362C,0x36333432383738332C36333433373236302C36333534333030352C36333535343334362C36333535353531362C),
 (133,'ITGB3BP.kApr07','chr1','-',63678623,63761493,63685065,63761392,9,0x36333637383632332C36333638353036342C36333639323137362C36333639323633382C36333639333134382C36333731373032322C36333732383334312C36333734363738362C36333736313338372C,0x36333637393336322C36333638353131352C36333639323233332C36333639323733322C36333639333232372C36333731373039322C36333732383437372C36333734363832392C36333736313439332C),
 (133,'ITGB3BP.oApr07','chr1','-',63679028,63761452,63685065,63693223,7,0x36333637393032382C36333638353036342C36333639323137362C36333639323633382C36333639333134382C36333734363738362C36333736313338372C,0x36333637393336322C36333638353131352C36333639323233332C36333639323733322C36333639333232372C36333734363832392C36333736313435322C),
 (133,'ITGB3BP.vbApr07','chr1','-',63679029,63831980,0,0,9,0x36333637393032392C36333638353036342C36333638353832332C36333639323137362C36333732383336312C36333734363738362C36333736363133372C36333736373338392C36333833313738332C,0x36333637393336322C36333638353131352C36333638353837332C36333639323232302C36333732383437372C36333734363832392C36333736363232392C36333736373434352C36333833313938302C),
 (133,'ITGB3BP.eApr07','chr1','-',63679029,63761489,63685844,63761488,10,0x36333637393032392C36333638353036342C36333638353832332C36333639323137362C36333639323633382C36333639333134382C36333731373032322C36333732383334312C36333734363738362C36333736313338372C,0x36333637393336322C36333638353131352C36333638353837332C36333639323233332C36333639323733322C36333639333232372C36333731373039322C36333732383437372C36333734363832392C36333736313438392C),
 (133,'ITGB3BP.mApr07','chr1','-',63679030,63761460,63679300,63693223,7,0x36333637393033302C36333639323137362C36333639323633382C36333639333134382C36333639353339322C36333734363738362C36333736313338372C,0x36333637393336322C36333639323233332C36333639323733322C36333639333232372C36333639363633322C36333734363832392C36333736313436302C),
 (133,'ITGB3BP.bApr07','chr1','-',63679032,63761486,63685065,63761485,10,0x36333637393033322C36333638353036342C36333639323137362C36333639323633382C36333639333134382C36333731373032322C36333732383334312C36333734363738362C36333734383332332C36333736313338372C,0x36333637393336322C36333638353131352C36333639323233332C36333639323733322C36333639333232372C36333731373039322C36333732383437372C36333734363832392C36333734383434302C36333736313438362C),
 (133,'ITGB3BP.nApr07','chr1','-',63679151,63761433,63685065,63693223,8,0x36333637393135312C36333638353036342C36333639323137362C36333639323633382C36333639333134382C36333731373032322C36333734363738362C36333736313338372C,0x36333637393336322C36333638353131352C36333639323233332C36333639323733322C36333639333232372C36333731373039322C36333734363832392C36333736313433332C);
INSERT INTO `aceview_hg18_housekeeping` (`bin`,`name`,`chrom`,`strand`,`txStart`,`txEnd`,`cdsStart`,`cdsEnd`,`exonCount`,`exonStarts`,`exonEnds`) VALUES 
 (133,'ITGB3BP.dApr07','chr1','-',63679166,63761511,63685065,63761510,8,0x36333637393136362C36333638353036342C36333639323137362C36333639323633382C36333639333134382C36333731373032322C36333732383334312C36333736313338372C,0x36333637393336322C36333638353131352C36333639323233332C36333639323733322C36333639333232372C36333731373039322C36333732383437372C36333736313531312C),
 (133,'ITGB3BP.jApr07','chr1','-',63679196,63761454,63679300,63761392,8,0x36333637393139362C36333639323137362C36333639323633382C36333639333134382C36333731373032322C36333732383334312C36333734363738362C36333736313338372C,0x36333637393336322C36333639323233332C36333639323733322C36333639333232372C36333731373039322C36333732383437372C36333734363832392C36333736313435342C),
 (133,'ITGB3BP.sApr07','chr1','-',63679244,63761473,63685844,63693223,9,0x36333637393234342C36333638353036342C36333638353832332C36333639323137362C36333639323633382C36333639333134382C36333731373032322C36333734363738362C36333736313338372C,0x36333637393336322C36333638353131352C36333638353837332C36333639323233332C36333639323733322C36333639333232372C36333731373039322C36333734363832392C36333736313437332C),
 (133,'ITGB3BP.rApr07','chr1','-',63680752,63761452,63702203,63761392,10,0x36333638303735322C36333638353036342C36333639323137362C36333639323633382C36333639333134382C36333730323130372C36333731373032322C36333732383334312C36333734363738362C36333736313338372C,0x36333638313435342C36333638353131352C36333639323233332C36333639323733322C36333639333232372C36333730323230372C36333731373039322C36333732383437372C36333734363832392C36333736313435322C),
 (133,'ITGB3BP.aApr07','chr1','-',63685064,63761766,63685065,63761764,9,0x36333638353036342C36333638353832332C36333639323137362C36333639323633382C36333639333134382C36333731373032322C36333732383334312C36333734363738362C36333736313338372C,0x36333638353131352C36333638353836382C36333639323233332C36333639323733322C36333639333232372C36333731373039322C36333732383437372C36333734363832392C36333736313736362C),
 (133,'ITGB3BP.cApr07','chr1','-',63686148,63761400,63688036,63761400,8,0x36333638363134382C36333639323137362C36333639323633382C36333639333134382C36333731373032322C36333732383334312C36333734363738362C36333736313231322C,0x36333638383037342C36333639323233332C36333639323733322C36333639333232372C36333731373039322C36333732383437372C36333734363832392C36333736313430302C),
 (133,'ITGB3BP.pApr07','chr1','-',63687719,63746825,63688036,63693223,6,0x36333638373731392C36333639323137362C36333639323633382C36333639333134382C36333731373032322C36333734363738362C,0x36333638383037342C36333639323233332C36333639323733322C36333639333232372C36333731373039322C36333734363832352C),
 (133,'ITGB3BP.qApr07','chr1','-',63687723,63746829,63688036,63693223,5,0x36333638373732332C36333639323137362C36333639323633382C36333639333134382C36333734363738362C,0x36333638383037342C36333639323233332C36333639323733322C36333639333232372C36333734363832392C),
 (133,'ITGB3BP.iApr07','chr1','-',63690042,63761441,63690246,63761392,8,0x36333639303034322C36333639323137362C36333639323633382C36333639333134382C36333731373032322C36333732383334312C36333734363738362C36333736313338372C,0x36333639303332332C36333639323233332C36333639323733322C36333639333232372C36333731373039322C36333732383437372C36333734363832392C36333736313434312C),
 (133,'ITGB3BP.gApr07','chr1','-',63691736,63761484,63692168,63761482,7,0x36333639313733362C36333639323633382C36333639333134382C36333731373032322C36333732383334312C36333734363738362C36333736313338372C,0x36333639323233332C36333639323733322C36333639333232372C36333731373039322C36333732383437372C36333734363832392C36333736313438342C),
 (133,'ITGB3BP.tApr07','chr1','-',63691873,63761470,63692168,63693223,5,0x36333639313837332C36333639323633382C36333639333134382C36333734363738362C36333736313338372C,0x36333639323233332C36333639323733322C36333639333232372C36333734363832392C36333736313437302C),
 (133,'ITGB3BP.fApr07','chr1','-',63692034,63761514,63692055,63761513,7,0x36333639323033342C36333639323137362C36333639323633382C36333639333134382C36333731373032322C36333732383334312C36333736313338372C,0x36333639323039302C36333639323233332C36333639323733322C36333639333232372C36333731373039322C36333732383437372C36333736313531342C),
 (133,'ITGB3BP.lApr07','chr1','-',63695255,63761486,63696586,63761485,5,0x36333639353235352C36333731373032322C36333732383334312C36333734363738362C36333736313338372C,0x36333639363633322C36333731373039322C36333732383437372C36333734363832392C36333736313438362C),
 (133,'PGM1.aApr07','chr1','+',63831479,63898508,63831513,63897934,11,0x36333833313437392C36333836373638332C36333836383230302C36333836393931352C36333837333038372C36333837343439322C36333837363934332C36333838363737352C36333838393932372C36333839323539302C36333839373834342C,0x36333833313939332C36333836373834362C36333836383334372C36333837303034312C36333837333237382C36333837343634372C36333837373035392C36333838363931312C36333839303131312C36333839323732352C36333839383530382C),
 (133,'ITGB3BP.hApr07-unspliced','chr1','-',63831705,63832279,63831705,63832278,1,0x36333833313730352C,0x36333833323237392C),
 (134,'ROR1.aApr07','chr1','+',64012272,64417715,64012676,64417126,9,0x36343031323237322C36343234373536342C36343238373935302C36343238383934352C36343337353633392C36343337383337392C36343338303637352C36343339373235312C36343431353639382C,0x36343031323736372C36343234373633362C36343238383233382C36343238383937362C36343337353736372C36343337383639372C36343338303932312C36343339373436332C36343431373731352C),
 (134,'ROR1.bApr07','chr1','+',64012277,64382041,64012676,64380929,7,0x36343031323237372C36343234373536342C36343238373935302C36343238383934352C36343337353633392C36343337383337392C36343338303637352C,0x36343031323736372C36343234373633362C36343238383233382C36343238383937362C36343337353736372C36343337383639372C36343338323034312C),
 (134,'ROR1.cApr07','chr1','+',64013547,64375767,64013618,64375766,5,0x36343031333534372C36343234373536342C36343238373935302C36343238383934352C36343337353633392C,0x36343031333637332C36343234373633362C36343238383233382C36343238383937362C36343337353736372C),
 (134,'ronara.dApr07','chr1','-',64343599,64409567,0,0,5,0x36343334333539392C36343334383932302C36343334393135332C36343335313839392C36343430393437392C,0x36343334353331302C36343334393036342C36343334393232382C36343335323036322C36343430393536372C),
 (134,'ronara.cApr07','chr1','-',64345141,64409617,64349022,64409512,4,0x36343334353134312C36343334383932302C36343334393135332C36343430393437392C,0x36343334353331302C36343334393036342C36343334393232382C36343430393631372C),
 (134,'ROR1.dApr07','chr1','+',64350563,64380752,64375721,64380752,4,0x36343335303536332C36343337353633392C36343337383337392C36343338303637352C,0x36343335303631332C36343337353736372C36343337383639372C36343338303735322C),
 (134,'UBE2U.bApr07','chr1','+',64441284,64505370,64442321,64505368,10,0x36343434313238342C36343434333930392C36343434353033342C36343434393031322C36343435333038352C36343435393132392C36343437303833312C36343437393932322C36343439383837332C36343530353239342C,0x36343434323338372C36343434333939312C36343434353132372C36343434393131302C36343435333230332C36343435393137382C36343437303932302C36343438303030342C36343439383936352C36343530353337302C),
 (134,'UBE2U.dApr07','chr1','+',64459135,64505649,64459135,64505479,4,0x36343435393133352C36343437393932322C36343439383837332C36343530353239342C,0x36343435393137382C36343438303030342C36343439383936352C36343530353634392C),
 (134,'CACHD1.aApr07','chr1','+',64709062,64931329,64709063,64929832,27,0x36343730393036322C36343738383836342C36343832303432362C36343834313037362C36343836373632352C36343837303836392C36343837323331342C36343838303039302C36343838363037312C36343839303433312C36343839323032382C36343839323935362C36343839363937352C36343930313936352C36343930323736382C36343930343332372C36343930393833342C36343931313432382C36343931313631382C36343931333637312C36343931343136372C36343931353136352C36343931363432392C36343931373836352C36343931393532382C36343932303237352C36343932393539332C,0x36343730393231332C36343738383932372C36343832303537352C36343834313138332C36343836373735322C36343837313031342C36343837323533312C36343838303234302C36343838363330352C36343839303538312C36343839323135322C36343839333037342C36343839373134342C36343930323130382C36343930323935302C36343930343433382C36343930393935372C36343931313532382C36343931313733352C36343931333833322C36343931343235342C36343931353238322C36343931363538312C36343931383032372C36343931393630362C36343932303337372C36343933313332392C),
 (134,'CACHD1.jApr07','chr1','+',64744181,64797946,0,0,3,0x36343734343138312C36343738383836342C36343739363737372C,0x36343734343735382C36343738383932372C36343739373934362C),
 (134,'CACHD1.cApr07','chr1','+',64744195,64931324,64872413,64929832,26,0x36343734343139352C36343738383836342C36343832303432362C36343834313037362C36343836373632352C36343837323331342C36343838303039302C36343838363037312C36343839303433312C36343839323032382C36343839323935362C36343839363937352C36343930313936352C36343930323736382C36343930343332372C36343930393833342C36343931313432382C36343931313631382C36343931333637312C36343931343136372C36343931353136352C36343931363432392C36343931373836352C36343931393532382C36343932303237352C36343932393539332C,0x36343734343735382C36343738383932372C36343832303537352C36343834313138332C36343836373735322C36343837323533312C36343838303234302C36343838363330352C36343839303538312C36343839323135322C36343839333037342C36343839373134342C36343930323130382C36343930323935302C36343930343433382C36343930393935372C36343931313532382C36343931313733352C36343931333833322C36343931343235342C36343931353238322C36343931363538312C36343931383032372C36343931393630362C36343932303337372C36343933313332342C),
 (134,'CACHD1.bApr07','chr1','+',64801942,64931329,64867639,64929832,27,0x36343830313934322C36343832303432362C36343834313037362C36343835313735382C36343836373632352C36343837303836392C36343837323331342C36343838303039302C36343838363037312C36343839303433312C36343839323032382C36343839323935362C36343839363937352C36343930313936352C36343930323736382C36343930343332372C36343930393833342C36343931313432382C36343931313631382C36343931333637312C36343931343136372C36343931353136352C36343931363432392C36343931373836352C36343931393532382C36343932303237352C36343932393539332C,0x36343830323131352C36343832303537352C36343834313138332C36343835313738392C36343836373735322C36343837313031342C36343837323533312C36343838303234302C36343838363330352C36343839303538312C36343839323135322C36343839333037342C36343839373134342C36343930323130382C36343930323935302C36343930343433382C36343930393935372C36343931313532382C36343931313733352C36343931333833322C36343931343235342C36343931353238322C36343931363538312C36343931383032372C36343931393630362C36343932303337372C36343933313332392C),
 (135,'SLC2A3P2andJAK1.aApr07','chr1','-',65071493,65204830,65072832,65124535,25,0x36353037313439332C36353037333636362C36353037343336382C36353037363230322C36353037363733352C36353037373837332C36353037393531352C36353037393732312C36353038323333342C36353038333032342C36353038333738332C36353038343931392C36353038353830322C36353038393037342C36353039333737392C36353039353932362C36353039383337352C36353130333035372C36353130353133362C36353130373538312C36353131313634302C36353131373239352C36353132313534372C36353132343532392C36353230343630332C,0x36353037323932382C36353037333737372C36353037343438362C36353037363337352C36353037363836302C36353037383036362C36353037393631302C36353037393837322C36353038323438362C36353038333136302C36353038333931312C36353038353030372C36353038353934362C36353038393138312C36353039333936392C36353039363035302C36353039383533332C36353130333234332C36353130353437392C36353130373734352C36353131313739342C36353131373431392C36353132313734362C36353132343631322C36353230343833302C),
 (135,'SLC2A3P2andJAK1.hApr07','chr1','-',65111648,65205180,65111649,65124535,5,0x36353131313634382C36353131373239352C36353132313534372C36353132343532392C36353230353135312C,0x36353131313739342C36353131373431392C36353132313734362C36353132343631322C36353230353138302C),
 (135,'SLC2A3P2andJAK1.iApr07','chr1','-',65111671,65178408,65111673,65124535,5,0x36353131313637312C36353131373239352C36353132313534372C36353132343532392C36353137383334362C,0x36353131313739342C36353131373431392C36353132313734362C36353132343631322C36353137383430382C),
 (135,'SLC2A3P2andJAK1.lApr07','chr1','-',65111736,65305996,65111736,65124535,5,0x36353131313733362C36353131373239352C36353132313534372C36353132343532392C36353330353837342C,0x36353131313739342C36353131373431392C36353132313734362C36353132343631322C36353330353939362C),
 (135,'SLC2A3P2andJAK1.oApr07','chr1','-',65111776,65205207,65111778,65124535,6,0x36353131313737362C36353131373239352C36353132313534372C36353132343532392C36353139353230302C36353230353135312C,0x36353131313739342C36353131373431392C36353132313734362C36353132343630392C36353139353238382C36353230353230372C),
 (135,'SLC2A3P2andJAK1.mApr07','chr1','-',65114222,65227878,65114683,65124535,5,0x36353131343232322C36353131373239352C36353132313534372C36353132343532392C36353232373730352C,0x36353131343734342C36353131373431392C36353132313734362C36353132343631322C36353232373837382C),
 (135,'AK3L1andAK3L2.aApr07','chr1','+',65385760,65470420,65385760,65464448,6,0x36353338353736302C36353338363534382C36353432383938302C36353435373032342C36353436333032322C36353436343333332C,0x36353338353933362C36353338363832332C36353432393130302C36353435373139372C36353436333134312C36353437303432302C),
 (135,'AK3L1andAK3L2.eApr07','chr1','+',65385909,65464753,65385911,65464448,5,0x36353338353930392C36353432383938302C36353435373032342C36353436333032322C36353436343333332C,0x36353338353933362C36353432393130302C36353435373139372C36353436333134312C36353436343735332C),
 (135,'AK3L1andAK3L2.gApr07','chr1','+',65385941,65464372,65428991,65464370,5,0x36353338353934312C36353432383938302C36353435373032342C36353436333032322C36353436343333332C,0x36353338363033342C36353432393130302C36353435373139372C36353436333134312C36353436343337322C),
 (135,'AK3L1andAK3L2.bApr07','chr1','+',65385941,65465765,65386678,65464448,6,0x36353338353934312C36353338363534382C36353432383938302C36353435373032342C36353436333032322C36353436343333332C,0x36353338363332382C36353338363832332C36353432393130302C36353435373139372C36353436333134312C36353436353736352C),
 (135,'AK3L1andAK3L2.cApr07','chr1','+',65386434,65465767,65386678,65464448,5,0x36353338363433342C36353432383938302C36353435373032342C36353436333032322C36353436343333332C,0x36353338363832332C36353432393130302C36353435373139372C36353436333134312C36353436353736372C),
 (135,'AK3L1andAK3L2.fApr07','chr1','+',65387271,65464710,65428991,65464448,5,0x36353338373237312C36353432383938302C36353435373032342C36353436333032322C36353436343333332C,0x36353338373431312C36353432393130302C36353435373139372C36353436333134312C36353436343731302C),
 (135,'AK3L1andAK3L2.dApr07','chr1','+',65404202,65464571,65404202,65464448,5,0x36353430343230322C36353432383938302C36353435373032342C36353436333032322C36353436343333332C,0x36353430343239302C36353432393130302C36353435373139372C36353436333134312C36353436343537312C),
 (135,'DNAJC6.gApr07','chr1','+',65486489,65604461,65602922,65604461,5,0x36353438363438392C36353538333838312C36353630323930352C36353630343135352C36353630343331382C,0x36353438363537342C36353538333939342C36353630333035362C36353630343230352C36353630343436312C),
 (135,'DNAJC6.cApr07','chr1','+',65492733,65624029,65492733,65624028,7,0x36353439323733332C36353630323930352C36353630343135352C36353630343331382C36353631373637322C36353632323436332C36353632333938322C,0x36353439323932302C36353630333035362C36353630343230352C36353630343436372C36353631373739352C36353632323539372C36353632343032392C),
 (135,'DNAJC6.bApr07','chr1','+',65502994,65654140,65503181,65651296,19,0x36353530323939342C36353630323930352C36353630343135352C36353630343331382C36353631373637322C36353632323436332C36353632333938322C36353632353038322C36353632363630362C36353632373532362C36353632373831372C36353633303730312C36353633333136382C36353633373038332C36353634303033312C36353634343134302C36353634363931312C36353634393532302C36353635313139342C,0x36353530333230332C36353630333035362C36353630343230352C36353630343436372C36353631373739352C36353632323539372C36353632343137372C36353632353230302C36353632363638362C36353632373732302C36353632373839382C36353633313133362C36353633333330332C36353633373135322C36353634303135312C36353634343430342C36353634373035342C36353634393639372C36353635343134302C),
 (135,'DNAJC6.dApr07','chr1','+',65503011,65618174,65602922,65617876,6,0x36353530333031312C36353538333838312C36353630323930352C36353630343135352C36353630343331382C36353631373637322C,0x36353530333230332C36353538333939342C36353630333035362C36353630343230352C36353630343436372C36353631383137342C),
 (135,'DNAJC6.fApr07','chr1','+',65503042,65622544,65604320,65622544,5,0x36353530333034322C36353630343135352C36353630343331382C36353631373637322C36353632323436332C,0x36353530333230332C36353630343230352C36353630343436372C36353631373739352C36353632323534342C),
 (135,'beyboy.aApr07','chr1','-',65517726,65544792,65517992,65544792,2,0x36353531373732362C36353534343730332C,0x36353531383134392C36353534343739322C),
 (135,'LEPROT.hApr07','chr1','+',65658840,65674278,65658842,65670190,4,0x36353635383834302C36353636333537332C36353636383133322C36353637303037332C,0x36353635393031312C36353636333634392C36353636383331392C36353637343237382C),
 (135,'LEPROT.lApr07','chr1','+',65658854,65670335,65658854,65670203,3,0x36353635383835342C36353636333537332C36353637303037332C,0x36353635393031312C36353636333634392C36353637303333352C),
 (135,'LEPROT.fApr07','chr1','+',65658905,65873701,65803836,65871440,20,0x36353635383930352C36353636333537332C36353830333831362C36353830383734332C36353831303539362C36353833303932372C36353833343731382C36353833363933302C36353833393636322C36353834303131332C36353834333330382C36353834373032332C36353834383231372C36353834383438342C36353835343237382C36353835363233342C36353835383139382C36353835393632332C36353836313137362C36353837313432322C,0x36353635393031312C36353636333634392C36353830333837362C36353830393037332C36353831303732302C36353833313133362C36353833343836342C36353833373037352C36353833393935332C36353834303233312C36353834333530382C36353834373137322C36353834383337372C36353834383536372C36353835343439352C36353835363431372C36353835383239342C36353835393732392C36353836313235322C36353837333730312C),
 (135,'LEPROT.bApr07','chr1','+',65658905,65868693,65803836,65868676,20,0x36353635383930352C36353636333537332C36353830333831362C36353830383734332C36353831303539362C36353833303932372C36353833343731382C36353833363933302C36353833393636322C36353834303131332C36353834333330382C36353834373032332C36353834383231372C36353834383438342C36353835343237382C36353835363233342C36353835383139382C36353835393632332C36353836313137362C36353836383437322C,0x36353635393031312C36353636333634392C36353830333837362C36353830393037332C36353831303732302C36353833313133362C36353833343836342C36353833373037352C36353833393935332C36353834303233312C36353834333530382C36353834373137322C36353834383337372C36353834383536372C36353835343439352C36353835363431372C36353835383239342C36353835393732392C36353836313235322C36353836383639332C),
 (135,'LEPROT.aApr07','chr1','+',65658905,65875764,65803836,65875286,20,0x36353635383930352C36353636333537332C36353830333831362C36353830383734332C36353831303539362C36353833303932372C36353833343731382C36353833363933302C36353833393636322C36353834303131332C36353834333330382C36353834373032332C36353834383231372C36353834383438342C36353835343237382C36353835363233342C36353835383139382C36353835393632332C36353836313137362C36353837343436312C,0x36353635393031312C36353636333634392C36353830333837362C36353830393037332C36353831303732302C36353833313133362C36353833343836342C36353833373037352C36353833393935332C36353834303233312C36353834333530382C36353834373137322C36353834383337372C36353834383536372C36353835343439352C36353835363431372C36353835383239342C36353835393732392C36353836313235322C36353837353736342C),
 (135,'LEPROT.iApr07','chr1','+',65663573,65875373,65803836,65874507,5,0x36353636333537332C36353830333831362C36353830383734332C36353831303539362C36353837343436312C,0x36353636333634392C36353830333837362C36353830393037332C36353831303732302C36353837353337332C),
 (135,'LEPROT.cApr07','chr1','+',65763438,65868678,65803836,65868676,19,0x36353736333433382C36353830333831362C36353830383734332C36353831303539362C36353833303932372C36353833343731382C36353833363933302C36353833393636322C36353834303131332C36353834333330382C36353834373032332C36353834383231372C36353834383438342C36353835343237382C36353835363233342C36353835383139382C36353835393632332C36353836313137362C36353836383437322C,0x36353736343038392C36353830333837362C36353830393037332C36353831303732302C36353833313133362C36353833343836342C36353833373037352C36353833393935332C36353834303233312C36353834333530382C36353834373137322C36353834383337372C36353834383536372C36353835343439352C36353835363431372C36353835383239342C36353835393732392C36353836313235322C36353836383637382C),
 (135,'LEPROT.eApr07','chr1','+',65764012,65871530,65803836,65871440,19,0x36353736343031322C36353830333831362C36353830383734332C36353831303539362C36353833303932372C36353833343731382C36353833363933302C36353833393636322C36353834303131332C36353834333330382C36353834373032332C36353834383231372C36353834383438342C36353835343237382C36353835363233342C36353835383139382C36353835393632332C36353836313137362C36353837313432322C,0x36353736343038392C36353830333837362C36353830393037332C36353831303732302C36353833313133362C36353833343836342C36353833373037352C36353833393935332C36353834303233312C36353834333530382C36353834373137322C36353834383337372C36353834383536372C36353835343439352C36353835363431372C36353835383239342C36353835393732392C36353836313235322C36353837313533302C),
 (135,'LEPROT.dApr07','chr1','+',65764012,65864505,65803836,65864441,19,0x36353736343031322C36353830333831362C36353830383734332C36353831303539362C36353833303932372C36353833343731382C36353833363933302C36353833393636322C36353834303131332C36353834333330382C36353834373032332C36353834383231372C36353834383438342C36353835343237382C36353835363233342C36353835383139382C36353835393632332C36353836313137362C36353836343339332C,0x36353736343038392C36353830333837362C36353830393037332C36353831303732302C36353833313133362C36353833343836342C36353833373037352C36353833393935332C36353834303233312C36353834333530382C36353834373137322C36353834383337372C36353834383536372C36353835343439352C36353835363431372C36353835383239342C36353835393732392C36353836313235322C36353836343530352C),
 (136,'PDE4B.cApr07','chr1','+',66230317,66612850,66231177,66610949,15,0x36363233303331372C36363438353733302C36363439353931372C36363439363036332C36363530343330382C36363537303737382C36363539333739372C36363539393838352C36363630313433382C36363630313637372C36363630333933372C36363630353936362C36363630363231332C36363630373035372C36363631303538332C,0x36363233313431332C36363438353932352C36363439353935342C36363439363133342C36363530343335382C36363537303839312C36363539333839312C36363630303036342C36363630313533372C36363630313834322C36363630343033372C36363630363132312C36363630363333362C36363630373234302C36363631323835302C),
 (136,'PDE4B.tApr07','chr1','+',66230962,66570891,66231177,66570779,2,0x36363233303936322C36363537303737362C,0x36363233313431332C36363537303839312C),
 (136,'PDE4B.qApr07','chr1','+',66231006,66485845,66231177,66287126,3,0x36363233313030362C36363238373039352C36363438353733302C,0x36363233313431332C36363238373136312C36363438353834352C),
 (136,'PDE4B.nApr07','chr1','+',66231400,66593868,66485893,66593866,7,0x36363233313430302C36363438353733302C36363439353931372C36363439363036332C36363530343330382C36363537303738312C36363539333739372C,0x36363233313431332C36363438353932352C36363439353935342C36363439363133342C36363530343335382C36363537303839312C36363539333836382C),
 (136,'PDE4B.kApr07','chr1','+',66390581,66570861,66390798,66570861,6,0x36363339303538312C36363438353733302C36363439353931372C36363439363036332C36363530343330382C36363537303737382C,0x36363339303830332C36363438353932352C36363439353935342C36363439363133342C36363530343335382C36363537303836312C),
 (136,'PDE4B.hApr07','chr1','+',66568999,66601722,66570801,66601722,6,0x36363536383939392C36363537303737382C36363539333739372C36363539393838352C36363630313433382C36363630313637372C,0x36363536393131302C36363537303839312C36363539333839312C36363630303036342C36363630313533372C36363630313732322C),
 (136,'PDE4B.iApr07','chr1','+',66570020,66601531,66570801,66601531,5,0x36363537303032302C36363537303737382C36363539333739372C36363539393838352C36363630313433382C,0x36363537303533302C36363537303839312C36363539333839312C36363630303036342C36363630313533312C),
 (136,'PDE4B.eApr07','chr1','+',66570118,66612850,66570660,66610949,10,0x36363537303131382C36363539333739372C36363539393838352C36363630313433382C36363630313637372C36363630333933372C36363630353936362C36363630363231332C36363630373035372C36363631303538332C,0x36363537303839312C36363539333839312C36363630303036342C36363630313533372C36363630313834322C36363630343033372C36363630363132312C36363630363333362C36363630373234302C36363631323835302C),
 (136,'PDE4B.lApr07','chr1','+',66570420,66601505,66570801,66601504,5,0x36363537303432302C36363537303738312C36363539333739372C36363539393838352C36363630313433382C,0x36363537303533302C36363537303839312C36363539333839312C36363630303036342C36363630313530352C),
 (136,'SGIP1.nApr07','chr1','+',66765716,66881151,66772629,66881149,7,0x36363736353731362C36363737323531362C36363836343131372C36363837313334302C36363837343231342C36363837383034372C36363838313038302C,0x36363736353837322C36363737323633392C36363836343138312C36363837313336352C36363837343238362C36363837383130342C36363838313135312C),
 (136,'SGIP1.hApr07','chr1','+',66765734,66928802,66772629,66928646,15,0x36363736353733342C36363737323531362C36363836343131372C36363837313334302C36363837343231342C36363837383034372C36363838313038302C36363838313831342C36363930393236352C36363931303231342C36363931313535312C36363931353237342C36363931373934382C36363932373431382C36363932383436302C,0x36363736353837322C36363737323633392C36363836343138312C36363837313336352C36363837343238362C36363837383130342C36363838313133352C36363838313939302C36363930393239302C36363931303236362C36363931313633372C36363931353336372C36363931383032332C36363932373534362C36363932383830322C),
 (136,'SGIP1.aApr07','chr1','+',66771648,66982645,66772629,66981366,25,0x36363737313634382C36363737323531362C36363836343131372C36363837313334302C36363837323335302C36363837383034372C36363838313038302C36363838313831342C36363930393236352C36363931303231342C36363931313535312C36363931353237342C36363931373934382C36363932303133392C36363932323337372C36363932373431382C36363932383436302C36363933333730342C36363935373536342C36363936373533342C36363937323031382C36363937373630352C36363937383932382C36363937393534322C36363938313334332C,0x36363737313637382C36363737323633392C36363836343138312C36363837313336352C36363837323433342C36363837383130342C36363838313133352C36363838313939302C36363930393239302C36363931303236362C36363931313633372C36363931353336372C36363931383032332C36363932303634302C36363932323435382C36363932373534362C36363932383538372C36363933333736342C36363935373637362C36363936373639302C36363937323135312C36363937373830382C36363937383939332C36363937393730372C36363938323634352C),
 (136,'SGIP1.eApr07','chr1','+',66771840,66944337,66772629,66944014,14,0x36363737313834302C36363737323531362C36363836343131372C36363837313334302C36363837343231372C36363837383034372C36363838313038302C36363838313831342C36363930393236352C36363931303231342C36363931313535312C36363931353237342C36363931373934382C36363934333837392C,0x36363737313934332C36363737323633392C36363836343138312C36363837313336352C36363837343238362C36363837383130342C36363838313133352C36363838313939302C36363930393239302C36363931303236362C36363931313633372C36363931353336372C36363931373935352C36363934343333372C),
 (136,'SGIP1.cApr07','chr1','+',66771862,66983366,66772629,66981366,22,0x36363737313836322C36363737323531362C36363836343131372C36363837313334302C36363837383034372C36363838313038302C36363838313831342C36363930393236352C36363931303231342C36363931313535312C36363931353237342C36363931373934382C36363932373431382C36363932383436302C36363933323730392C36363935373536342C36363936373533342C36363937323031382C36363937373630352C36363937383932382C36363937393534322C36363938313334332C,0x36363737313934332C36363737323633392C36363836343138312C36363837313336352C36363837383130342C36363838313133352C36363838313939302C36363930393239302C36363931303236362C36363931313633372C36363931353336372C36363931383032332C36363932373534362C36363932383538372C36363933323737352C36363935373637362C36363936373639302C36363937323135312C36363937373830382C36363937383939332C36363937393730372C36363938333336362C),
 (136,'SGIP1.gApr07','chr1','+',66771863,66983355,66772629,66932795,23,0x36363737313836332C36363737323531362C36363836343131372C36363837313334302C36363837343231342C36363837383034372C36363838313038302C36363838313831342C36363930393236352C36363931303231342C36363931313535312C36363931353237342C36363931373934382C36363932373431382C36363932383436302C36363933323730392C36363935373536342C36363936373533342C36363937323031382C36363937373630352C36363937383932382C36363937393534322C36363938313334332C,0x36363737313934332C36363737323633392C36363836343138312C36363837313336352C36363837343238362C36363837383130342C36363838313133352C36363838313939302C36363930393239302C36363931303236362C36363931313633372C36363931353336372C36363931383032332C36363932373534362C36363932383538372C36363933333736342C36363935373637362C36363936373639302C36363937323135312C36363937373830382C36363937383939332C36363937393730372C36363938333335352C),
 (136,'SGIP1.dApr07','chr1','+',66771864,66983356,66772629,66981366,22,0x36363737313836342C36363737323531362C36363836343131372C36363837313334302C36363837383034372C36363838313038302C36363838313831342C36363930393236352C36363931303231342C36363931313535312C36363931353237342C36363931373934382C36363932373431382C36363932383436302C36363933333730342C36363935373536342C36363936373533342C36363937323031382C36363937373630352C36363937383932382C36363937393534322C36363938313334332C,0x36363737323136302C36363737323633392C36363836343138312C36363837313336352C36363837383130342C36363838313133352C36363838313939302C36363930393239302C36363931303236362C36363931313633372C36363931353336372C36363931383032332C36363932373534362C36363932383538372C36363933333736342C36363935373637362C36363936373639302C36363937323135312C36363937373830382C36363937383939332C36363937393730372C36363938333335362C),
 (136,'SGIP1.vcApr07','chr1','+',66771875,66864325,0,0,4,0x36363737313837352C36363737323531362C36363832383734302C36363836343131372C,0x36363737313934332C36363737323633392C36363832383837372C36363836343332352C),
 (136,'SGIP1.veApr07','chr1','+',66771920,66864413,0,0,3,0x36363737313932302C36363737323531362C36363836343131372C,0x36363737313934332C36363737323633392C36363836343431332C),
 (136,'SGIP1.sApr07','chr1','+',66772227,66846951,0,0,4,0x36363737323232372C36363832383734302C36363834343731302C36363834363631312C,0x36363737323633392C36363832383837372C36363834343735322C36363834363935312C),
 (136,'SGIP1.fApr07','chr1','+',66772227,66928802,66772629,66928646,15,0x36363737323232372C36363836343131372C36363837313334302C36363837343231372C36363837383034372C36363838313038302C36363838313831342C36363930393236352C36363931303231342C36363931313535312C36363931353237342C36363931373934382C36363932303133392C36363932373431382C36363932383436302C,0x36363737323633392C36363836343138312C36363837313336352C36363837343238362C36363837383130342C36363838313133352C36363838313939302C36363930393239302C36363931303236362C36363931313633372C36363931353336372C36363931383032332C36363932303634302C36363932373534362C36363932383830322C),
 (136,'SGIP1.bApr07','chr1','+',66772346,66983996,66772629,66981366,23,0x36363737323334362C36363836343131372C36363837313334302C36363837343231342C36363837383034372C36363838313038302C36363838313831342C36363930393236352C36363931303231342C36363931313535312C36363931353237342C36363931373934382C36363932303133392C36363932373431382C36363932383436302C36363933333730342C36363935373536342C36363936373533342C36363937323031382C36363937373630352C36363937383932382C36363937393534322C36363938313334332C,0x36363737323633392C36363836343138312C36363837313336352C36363837343238362C36363837383130342C36363838313133352C36363838313939302C36363930393239302C36363931303236362C36363931313633372C36363931353336372C36363931383032332C36363932303634302C36363932373534362C36363932383538372C36363933333736342C36363935373637362C36363936373639302C36363937323135312C36363937373830382C36363937383939332C36363937393730372C36363938333939362C),
 (136,'SGIP1.oApr07','chr1','+',66772405,66864959,66864373,66864604,2,0x36363737323430352C36363836343131372C,0x36363737323633392C36363836343935392C),
 (136,'SGIP1.iApr07','chr1','+',66772426,66915367,66772629,66915366,10,0x36363737323432362C36363836343131372C36363837313334302C36363837383034372C36363838313038302C36363838313831342C36363930393236352C36363931303231342C36363931313535312C36363931353237342C,0x36363737323633392C36363836343138312C36363837313336352C36363837383130342C36363838313133352C36363838313939302C36363930393239302C36363931303236362C36363931313633372C36363931353336372C),
 (136,'SGIP1.kApr07','chr1','+',66772445,66917990,66772629,66910265,10,0x36363737323434352C36363836343131372C36363837313334302C36363837383034372C36363838313038302C36363838313831342C36363931303231342C36363931313535312C36363931353237342C36363931373934382C,0x36363737323633392C36363836343138312C36363837313336352C36363837383130342C36363838313133352C36363838313939302C36363931303236362C36363931313633372C36363931353336372C36363931373939302C),
 (136,'SGIP1.uApr07','chr1','+',66772448,66850874,0,0,2,0x36363737323434382C36363835303332372C,0x36363737323633392C36363835303837342C),
 (137,'SLC35D1.aApr07','chr1','-',67237603,67292667,67242610,67292284,12,0x36373233373630332C36373234373335352C36373235383633392C36373235393830352C36373238303530362C36373238353533352C36373238383035322C36373238383730332C36373239303238322C36373239313034312C36373239313232362C36373239323038312C,0x36373234323731392C36373234373433382C36373235383731382C36373235393837332C36373238303539392C36373238353633382C36373238383132312C36373238383737352C36373239303335302C36373239313132382C36373239313236302C36373239323636372C),
 (137,'C1orf141.bApr07','chr1','-',67330665,67373219,67331275,67365511,8,0x36373333303636352C36373333333530352C36373333343532322C36373335333632322C36373336343032322C36373336353433362C36373336393431322C36373337333230302C,0x36373333313837352C36373333333639322C36373333343539322C36373335333733352C36373336343138302C36373336353532382C36373336393439382C36373337333231392C),
 (137,'C1orf141.dApr07','chr1','-',67331222,67373230,67331850,67351963,10,0x36373333313232322C36373333343532322C36373334313530382C36373334393834372C36373335313838342C36373335333632322C36373336343032322C36373336353433362C36373336393431322C36373337333230302C,0x36373333313837352C36373333343539322C36373334313635332C36373334393931352C36373335323032372C36373335333733352C36373336343138302C36373336353532382C36373336393439382C36373337333233302C),
 (137,'C1orf141.cApr07','chr1','-',67333505,67373214,67333505,67365511,9,0x36373333333530352C36373333343532322C36373334313530382C36373334393834372C36373335333632322C36373336343032322C36373336353433362C36373336393431322C36373337333230302C,0x36373333333639322C36373333343539322C36373334313635332C36373334393931352C36373335333733352C36373336343138302C36373336353532382C36373336393439382C36373337333231342C),
 (137,'C1orf141.eApr07','chr1','-',67334310,67373247,67334582,67365511,5,0x36373333343331302C36373336343032322C36373336353433362C36373336393431322C36373337333230302C,0x36373333343539322C36373336343138302C36373336353532382C36373336393439382C36373337333234372C),
 (137,'IL12RB2.aApr07','chr1','+',67545622,67635171,67558639,67634360,16,0x36373534353632322C36373535383630332C36373535393837322C36373536353030352C36373536363437302C36373536373835372C36373536383933302C36373537363839342C36373538393134302C36373630363039352C36373631303730362C36373631303839352C36373631383235362C36373632343834392C36373632383239392C36373633333831372C,0x36373534363233382C36373535383731352C36373536303136302C36373536353132302C36373536363635352C36373536383030302C36373536393038312C36373537363937342C36373538393336302C36373630363239362C36373631303830352C36373631313035342C36373631383339342C36373632343934302C36373632383339392C36373633353137312C),
 (137,'IL12RB2.dApr07','chr1','+',67610937,67633999,67610984,67633851,4,0x36373631303933372C36373631383235362C36373632343834392C36373633333831372C,0x36373631313035342C36373631383339342C36373632343934302C36373633333939392C),
 (137,'IL12RB2.cApr07','chr1','+',67618198,67634034,67618198,67634033,4,0x36373631383139382C36373632343834392C36373632383239392C36373633333831372C,0x36373631383339342C36373632343934302C36373632383339392C36373633343033342C),
 (137,'GNG12.eApr07','chr1','-',67939736,68072049,67943721,67945957,4,0x36373933393733362C36373934353836342C36383031353732382C36383037313631342C,0x36373934333834372C36373934353938332C36383031353737382C36383037323034392C),
 (137,'GNG12.cApr07','chr1','-',67943411,68070391,67943721,67945957,4,0x36373934333431312C36373934353836342C36383031353732382C36383037303038392C,0x36373934333834372C36373934353938332C36383031353737382C36383037303339312C),
 (137,'GNG12.bApr07','chr1','-',67943448,68030004,67943721,67945957,4,0x36373934333434382C36373934353836342C36383031353732382C36383032393931332C,0x36373934333834372C36373934353938332C36383031353737382C36383033303030342C),
 (137,'GNG12.dApr07','chr1','-',67943644,68071728,67943721,67945957,5,0x36373934333634342C36373934353836342C36373935393237362C36383031353732382C36383037313631342C,0x36373934333834372C36373934353938332C36373935393337312C36383031353737382C36383037313732382C),
 (137,'GNG12.gApr07','chr1','-',68014865,68071708,0,0,2,0x36383031343836352C36383037313631342C,0x36383031353737382C36383037313730382C),
 (138,'DIRAS3.aApr07','chr1','-',68284166,68289901,68284878,68289231,4,0x36383238343136362C36383238383831382C36383238393135342C36383238393639352C,0x36383238353633332C36383238393036392C36383238393236382C36383238393930312C),
 (138,'GPR177.bApr07','chr1','-',68336730,68471270,68336902,68470570,12,0x36383333363733302C36383337363035302C36383338323833392C36383338343133392C36383338363430362C36383338363833332C36383338383435382C36383339313738372C36383339333336392C36383339373339332C36383433323232352C36383437303436342C,0x36383333373032342C36383337363230342C36383338323932332C36383338343238332C36383338363437302C36383338363933312C36383338383632372C36383339313932342C36383339333533312C36383339373531382C36383433323439322C36383437313237302C),
 (138,'GPR177.aApr07','chr1','-',68336739,68470817,68336902,68470570,12,0x36383333363733392C36383337363035302C36383338323833392C36383338343133392C36383338363430362C36383338363833332C36383338383435382C36383339313738372C36383339333336392C36383339373339332C36383433323232352C36383437303436342C,0x36383333373032342C36383337363230342C36383338323932332C36383338343238332C36383338363437302C36383338363933312C36383338383632372C36383339313932342C36383339333533312C36383339373531382C36383433323439382C36383437303831372C),
 (138,'GPR177.cApr07','chr1','-',68363628,68470854,68364496,68470570,12,0x36383336333632382C36383337363035302C36383338323833392C36383338343133392C36383338363430362C36383338363833332C36383338383435382C36383339313738372C36383339333336392C36383339373339332C36383433323232352C36383437303436342C,0x36383336343630362C36383337363230342C36383338323932332C36383338343238332C36383338363437302C36383338363933312C36383338383632372C36383339313932342C36383339333533312C36383339373531382C36383433323439382C36383437303835342C),
 (138,'GPR177.eApr07','chr1','-',68363763,68471320,68364496,68470570,12,0x36383336333736332C36383337363035302C36383338323833392C36383338343133392C36383338363430362C36383338363833332C36383338383435382C36383339313738372C36383339333336392C36383339373339332C36383437303436342C36383437303933302C,0x36383336343630362C36383337363230342C36383338323932332C36383338343238332C36383338363437302C36383338363933312C36383338383632372C36383339313932342C36383339333533312C36383339373531382C36383437303831372C36383437313332302C),
 (138,'GPR177.dApr07','chr1','-',68380870,68470811,68381070,68470570,11,0x36383338303837302C36383338323833392C36383338343133392C36383338363430362C36383338363833332C36383338383435382C36383339313738372C36383339333336392C36383339373339332C36383433323232352C36383437303436342C,0x36383338313133332C36383338323932332C36383338343238332C36383338363437302C36383338363933312C36383338383632372C36383339313932342C36383339333533312C36383339373531382C36383433323439382C36383437303831312C),
 (138,'GPR177.kApr07','chr1','-',68388605,68469958,68388605,68397498,5,0x36383338383630352C36383339313738372C36383339333336392C36383339373339332C36383436393835382C,0x36383338383632372C36383339313932342C36383339333533312C36383339373531382C36383436393935382C),
 (138,'GPR177.iApr07','chr1','-',68391824,68470793,68391825,68470775,5,0x36383339313832342C36383339333336392C36383339373339332C36383433323232352C36383437303634332C,0x36383339313932342C36383339333533312C36383339373531382C36383433323235392C36383437303739332C),
 (138,'GPR177.hApr07','chr1','-',68391896,68471288,68391897,68432469,5,0x36383339313839362C36383339333336392C36383339373339332C36383433323232352C36383437303933302C,0x36383339313932342C36383339333533312C36383339373531382C36383433323439382C36383437313238382C),
 (138,'GPR177.jApr07','chr1','-',68393442,68471390,68393444,68432469,4,0x36383339333434322C36383339373339332C36383433323232352C36383437313332332C,0x36383339333533312C36383339373531382C36383433323439382C36383437313339302C),
 (138,'GPR177.fApr07','chr1','-',68393499,68470797,68393501,68470775,5,0x36383339333439392C36383339373339332C36383433323232352C36383436363439312C36383437303436342C,0x36383339333533312C36383339373531382C36383433323439382C36383436363532362C36383437303739372C),
 (138,'GPR177.pApr07','chr1','-',68397454,68470095,68424858,68432469,4,0x36383339373435342C36383432343831302C36383433323232352C36383436393937332C,0x36383339373531382C36383432343932302C36383433323439382C36383437303039352C),
 (138,'RPE65.aApr07','chr1','-',68667032,68688425,68668046,68688176,14,0x36383636373033322C36383636393333352C36383636393535322C36383636393734312C36383637363435372C36383637373231322C36383637373436312C36383637373833312C36383637393132332C36383638323830312C36383638333034362C36383638343938302C36383638363839342C36383638383136352C,0x36383636383139382C36383636393434372C36383636393634372C36383636393835362C36383637363538372C36383637373335322C36383637373539342C36383637373931332C36383637393237312C36383638323934332C36383638333135342C36383638353133312C36383638363937372C36383638383432352C),
 (138,'RPE65.bApr07','chr1','-',68677437,68688197,68677437,68688176,8,0x36383637373433372C36383637373833312C36383637393132332C36383638323830312C36383638333034362C36383638343938302C36383638363839342C36383638383136352C,0x36383637373539342C36383637373931332C36383637393237312C36383638323934332C36383638333135342C36383638353133312C36383638363937372C36383638383139372C),
 (138,'RPE65.cApr07','chr1','-',68679189,68688220,68679190,68686946,5,0x36383637393138392C36383638323830312C36383638343938302C36383638363839342C36383638383136352C,0x36383637393237312C36383638323934332C36383638353133312C36383638373034352C36383638383232302C),
 (139,'bawkley.aApr07','chr1','+',69294168,69423274,0,0,5,0x36393239343136382C36393332333435302C36393332363738352C36393432313034302C36393432333035362C,0x36393239343331382C36393332333536392C36393332363833332C36393432313133322C36393432333237342C),
 (139,'LRRC7.eApr07','chr1','+',69805401,70113275,69806910,70111744,8,0x36393830353430312C36393931363635312C36393939383436312C37303033303331332C37303036343031382C37303037333035302C37303037363439372C37303131313733372C,0x36393830363931332C36393931363734392C36393939383636342C37303033303433312C37303036343039372C37303037333134302C37303037363535342C37303131333237352C),
 (139,'LRRC7.gApr07','chr1','+',69805455,69962858,69806910,69962522,3,0x36393830353435352C36393931363635312C36393936323531392C,0x36393830363931332C36393931363734392C36393936323835382C),
 (140,'LRRC40.aApr07','chr1','-',70383069,70443946,70384070,70443811,15,0x37303338333036392C37303338363735372C37303338393339382C37303339303730332C37303339333935392C37303339373630302C37303431313733352C37303431313839322C37303431343038302C37303431373132312C37303431393335362C37303432333035352C37303432353533352C37303432373336322C37303434333636302C,0x37303338343137362C37303338363934332C37303338393437362C37303339303831342C37303339343036372C37303339373730392C37303431313738312C37303431313938302C37303431343235332C37303431373236342C37303431393438302C37303432333138352C37303432353630392C37303432373534342C37303434333934362C),
 (140,'LRRC40.eApr07','chr1','-',70383076,70443862,0,0,6,0x37303338333037362C37303431373231352C37303431393335362C37303432313630322C37303432333035352C37303434333636302C,0x37303338333539392C37303431373236342C37303431393438302C37303432313636312C37303432333138352C37303434333836322C),
 (140,'LRRC40.dApr07-unspliced','chr1','-',70383518,70386056,70384403,70384622,1,0x37303338333531382C,0x37303338363035362C),
 (140,'fakley.aApr07','chr1','+',70385391,70390215,0,0,3,0x37303338353339312C37303338363135392C37303339303031382C,0x37303338353436362C37303338363237362C37303339303231352C),
 (140,'ANKRD13C.bApr07','chr1','-',70497255,70593005,70500987,70592679,12,0x37303439373235352C37303530393132362C37303531323939302C37303531353033352C37303533303635382C37303533343430302C37303533393033342C37303534343439342C37303535323031352C37303535333735312C37303537343332382C37303539323234392C,0x37303530313131382C37303530393232372C37303531333038392C37303531353131352C37303533303832302C37303533343533322C37303533393137392C37303534343536312C37303535323036312C37303535333833372C37303537343337302C37303539333030352C),
 (140,'ANKRD13C.cApr07','chr1','-',70498856,70530822,70500987,70530706,5,0x37303439383835362C37303530393132362C37303531323939302C37303531353033352C37303533303635382C,0x37303530313131382C37303530393232372C37303531333038392C37303531353131352C37303533303832322C),
 (140,'ANKRD13C.gApr07','chr1','-',70499507,70530768,70501057,70530706,4,0x37303439393530372C37303530303437372C37303531353033352C37303533303635382C,0x37303530303034302C37303530313131382C37303531353131352C37303533303736382C),
 (140,'ANKRD13C.aApr07','chr1','-',70500137,70593064,70500987,70592679,13,0x37303530303133372C37303530393132362C37303531323939302C37303531353033352C37303533303635382C37303533343430302C37303533393033342C37303534343439342C37303535323031352C37303535333735312C37303536333132332C37303537343332382C37303539323234392C,0x37303530313131382C37303530393232372C37303531333038392C37303531353131352C37303533303832302C37303533343533322C37303533393137392C37303534343536312C37303535323036312C37303535333833372C37303536333232382C37303537343337302C37303539333036342C),
 (140,'ANKRD13C.dApr07','chr1','-',70500563,70530787,70501057,70530787,5,0x37303530303536332C37303530393132362C37303531323939302C37303531353033352C37303533303635382C,0x37303530313037342C37303530393232372C37303531333038392C37303531353131352C37303533303738372C),
 (140,'ANKRD13C.fApr07','chr1','-',70500876,70592328,70515044,70592328,7,0x37303530303837362C37303530393132362C37303531323939302C37303531353033352C37303536333132332C37303537343332382C37303539323234392C,0x37303530313131382C37303530393232372C37303531333038392C37303531353131352C37303536333232382C37303537343337302C37303539323332382C),
 (140,'geekley.bApr07','chr1','+',70941934,71052167,0,0,5,0x37303934313933342C37303939383633372C37303939393439342C37313032333435362C37313035313632312C,0x37303934323037332C37303939383733392C37303939393537322C37313032333639392C37313035323136372C),
 (140,'PTGER3.gApr07','chr1','-',71090621,71286079,71100639,71285848,5,0x37313039303632312C37313130303537352C37313130373531342C37313235303537352C37313238343935312C,0x37313039313133302C37313130303636382C37313130373539302C37313235303735352C37313238363037392C),
 (140,'PTGER3.lApr07','chr1','-',71090623,71286079,71091109,71285848,3,0x37313039303632332C37313235303537352C37313238343935312C,0x37313039313133302C37313235303735352C37313238363037392C),
 (140,'PTGER3.kApr07','chr1','-',71090623,71286084,71091109,71285848,4,0x37313039303632332C37313139323033332C37313235303537352C37313238343935312C,0x37313039313133302C37313139323036302C37313235303735352C37313238363038342C),
 (140,'PTGER3.hApr07','chr1','-',71090623,71286079,71192056,71285848,5,0x37313039303632332C37313139323033332C37313231323536372C37313235303537352C37313238343935312C,0x37313039313133302C37313139323036302C37313231323635392C37313235303735352C37313238363037392C),
 (140,'PTGER3.fApr07','chr1','-',71090623,71286079,71100639,71285848,6,0x37313039303632332C37313130303537352C37313130373531342C37313139323033332C37313235303537352C37313238343935312C,0x37313039313133302C37313130303636382C37313130373539302C37313139323036302C37313235303735352C37313238363037392C),
 (140,'PTGER3.bApr07','chr1','-',71090623,71286079,71100639,71285848,6,0x37313039303632332C37313130303537352C37313130333935392C37313139323033332C37313235303537352C37313238343935312C,0x37313039313133302C37313130303636382C37313130343130342C37313139323036302C37313235303735352C37313238363037392C),
 (140,'PTGER3.nApr07','chr1','-',71090710,71192060,71090972,71192058,3,0x37313039303731302C37313132343534382C37313139323033332C,0x37313039313133302C37313132343539392C37313139323036302C),
 (140,'PTGER3.aApr07','chr1','-',71121517,71285869,71122219,71285869,5,0x37313132313531372C37313132343534382C37313139323033332C37313235303537352C37313238343935312C,0x37313132323335342C37313132343539392C37313139323036302C37313235303735352C37313238353836392C),
 (140,'PTGER3.eApr07','chr1','-',71121988,71285904,71192056,71285902,6,0x37313132313938382C37313132343534382C37313139323033332C37313231323536372C37313235303537352C37313238343935312C,0x37313132323333302C37313132343539392C37313139323036302C37313231323635392C37313235303735352C37313238353930342C),
 (140,'PTGER3.cApr07','chr1','-',71122026,71285869,71122219,71285869,4,0x37313132323032362C37313139323033332C37313235303537352C37313238343935312C,0x37313132323335342C37313139323036302C37313235303735352C37313238353836392C),
 (141,'kleyrorbo.bApr07','chr1','+',71319594,71475995,0,0,4,0x37313331393539342C37313332393933342C37313436313332372C37313437353430302C,0x37313331393638342C37313332393937352C37313436313338352C37313437353939352C),
 (141,'kleyrorbo.aApr07','chr1','+',71319673,71490390,0,0,7,0x37313331393637332C37313332393933342C37313333313430332C37313436313332372C37313437353430302C37313438393237312C37313438393933322C,0x37313331393638342C37313332393937352C37313333313532322C37313436313338352C37313437353436362C37313438393332392C37313439303339302C),
 (141,'plororbo.bApr07','chr1','+',71606320,71727789,0,0,4,0x37313630363332302C37313633393939332C37313730313630312C37313732373232332C,0x37313630363335392C37313634303135302C37313730313737322C37313732373738392C),
 (141,'NEGR1.bApr07','chr1','-',71641212,72339205,71645716,72173374,7,0x37313634313231322C37313833313038372C37313834393239362C37313933363237382C37323031343434322C37323137333334392C37323333393031352C,0x37313634353834312C37313833313233392C37313834393431372C37313933363431302C37323031343536382C37323137333538322C37323333393230352C),
 (141,'NEGR1.fApr07','chr1','-',71645529,71849423,71645716,71849382,3,0x37313634353532392C37313833313038372C37313834393239362C,0x37313634353834312C37313833313233392C37313834393432332C),
 (141,'NEGR1.eApr07','chr1','-',71645603,71876546,71645716,71876519,4,0x37313634353630332C37313833313038372C37313834393239362C37313837363437392C,0x37313634353834312C37313833313233392C37313834393431372C37313837363534362C),
 (141,'NEGR1.dApr07','chr1','-',71645714,71944339,71645716,71944322,5,0x37313634353731342C37313833313038372C37313834393239362C37313933363237382C37313934343330362C,0x37313634353834312C37313833313233392C37313834393431372C37313933363431302C37313934343333392C),
 (142,'kosuyo.aApr07','chr1','+',72875225,72907415,0,0,5,0x37323837353232352C37323838363437382C37323839333236332C37323930363230392C37323930373136352C,0x37323837353234362C37323838363630362C37323839333330332C37323930363332372C37323930373431352C),
 (142,'choyrobo.aApr07','chr1','+',73003301,73029551,0,0,7,0x37333030333330312C37333031333534322C37333031363534332C37333031383337372C37333032313934302C37333032343839372C37333032393333352C,0x37333030333335312C37333031333831352C37333031363632382C37333031383536342C37333032323135342C37333032353235322C37333032393535312C),
 (143,'skorrorbo.aApr07','chr1','+',73873486,73947852,73873486,73947505,3,0x37333837333438362C37333933383032312C37333934373431342C,0x37333837333531322C37333933383131342C37333934373835322C),
 (143,'LRRC44.aApr07','chr1','-',74264286,74436415,74322455,74421956,10,0x37343236343238362C37343237393936322C37343331323933322C37343331363932362C37343332303138392C37343334373636352C37343339343030342C37343432303830392C37343432313730372C37343433363236372C,0x37343236353234312C37343238303230352C37343331333036322C37343331363939302C37343332323438382C37343334373832352C37343339343133382C37343432313133332C37343432313935362C37343433363431352C),
 (144,'FPGTandTNNI3K.cApr07','chr1','+',74473652,74782705,74473723,74782254,25,0x37343437333635322C37343437343337332C37343438373733302C37343438383934332C37343530393836392C37343536393732312C37343537343238322C37343538313131332C37343538313334362C37343539313533372C37343539323235312C37343630353532372C37343630363137392C37343630373239332C37343630373437382C37343630373636322C37343630383535392C37343637343335312C37343637343734352C37343637373736312C37343730313731322C37343732373436302C37343733303336382C37343737383530352C37343738323137372C,0x37343437333736332C37343437343438322C37343438373831362C37343438393034312C37343530393938302C37343536393832302C37343537343432312C37343538313235382C37343538313435312C37343539313633322C37343539323430312C37343630353631342C37343630363233362C37343630373338362C37343630373533362C37343630373835372C37343630383636342C37343637343430342C37343637343739382C37343637373839342C37343730313832322C37343732373532302C37343733303533382C37343737383538352C37343738323730352C),
 (144,'FPGTandTNNI3K.fApr07','chr1','+',74504566,74591632,74504566,74591631,7,0x37343530343536362C37343530393836392C37343536393732312C37343537343238322C37343538313131332C37343538313334362C37343539313533372C,0x37343530343631312C37343530393938302C37343536393832302C37343537343432312C37343538313235382C37343538313435312C37343539313633322C),
 (144,'FPGTandTNNI3K.vaApr07','chr1','+',74574399,74584446,0,0,4,0x37343537343339392C37343538313131332C37343538313334362C37343538343134392C,0x37343537343432312C37343538313235382C37343538313435312C37343538343434362C),
 (144,'lorkley.aApr07','chr1','-',74579853,74617070,0,0,4,0x37343537393835332C37343630343835342C37343630373236302C37343631363936372C,0x37343538303235392C37343630343939382C37343630373339312C37343631373037302C),
 (144,'C1orf173.aApr07','chr1','-',74806382,74912009,74809388,74911998,15,0x37343830363338322C37343830393337302C37343831353136362C37343832373930322C37343833373936362C37343834343837322C37343835303839342C37343835393030352C37343836393938342C37343837343535312C37343837393630322C37343838313239382C37343838343933382C37343838373439332C37343931313736382C,0x37343830383731312C37343831313736332C37343831353230382C37343832383335322C37343833383230332C37343834353137342C37343835313038312C37343835393138362C37343837303230302C37343837343731302C37343837393733312C37343838313337302C37343838353036342C37343838373538372C37343931323030392C),
 (144,'markley.bApr07','chr1','+',74815701,74864369,0,0,3,0x37343831353730312C37343835333437372C37343835393636372C,0x37343831353738312C37343835333536382C37343836343336392C),
 (144,'C1orf173.cApr07','chr1','-',74827598,74873132,74827885,74872948,7,0x37343832373539382C37343833373936362C37343834343837322C37343835303839342C37343835393030352C37343836393938342C37343837323933362C,0x37343832383335322C37343833383230332C37343834353137342C37343835313038312C37343835393138362C37343837303230302C37343837333133322C),
 (144,'markley.cApr07','chr1','+',74827600,74860606,0,0,3,0x37343832373630302C37343835333437372C37343835393636372C,0x37343832383137392C37343835333536382C37343836303630362C),
 (144,'TYW3.cApr07','chr1','+',74971415,75004517,74971516,75002385,6,0x37343937313431352C37343937343831332C37343937363936312C37343938373032322C37343939303536332C37353030323136352C,0x37343937313639302C37343937343839342C37343937373036302C37343938373039342C37343939303639372C37353030343531372C),
 (144,'TYW3.lApr07','chr1','+',74971446,75002262,0,0,6,0x37343937313434362C37343937343831332C37343937363936312C37343938373032322C37343939303536332C37353030323136352C,0x37343937313830332C37343937343839342C37343937373036302C37343938373039342C37343939303639372C37353030323236322C),
 (144,'TYW3.gApr07','chr1','+',74971447,74989686,74971516,74989629,5,0x37343937313434372C37343937343831332C37343937363936312C37343938373032322C37343938393632302C,0x37343937313639302C37343937343839342C37343937373036302C37343938373039342C37343938393638362C),
 (144,'TYW3.dApr07','chr1','+',74971469,75002261,74972415,75002259,7,0x37343937313436392C37343937323338392C37343937343831332C37343937363936312C37343938373032322C37343939303536332C37353030323136352C,0x37343937313639302C37343937323435342C37343937343839342C37343937373036302C37343938373039342C37343939303639372C37353030323236312C),
 (144,'TYW3.bApr07','chr1','+',74971503,75004949,74971516,75002385,7,0x37343937313530332C37343937343831332C37343937353935332C37343937363936312C37343938373032322C37343939303536332C37353030323136352C,0x37343937313639302C37343937343839342C37343937363031332C37343937373036302C37343938373039342C37343939303639372C37353030343934392C),
 (144,'smarorbo.aApr07','chr1','-',75366103,75371333,0,0,2,0x37353336363130332C37353337313038352C,0x37353336363532362C37353337313333332C),
 (145,'LOC646425.bApr07','chr1','-',75876439,75961314,0,0,5,0x37353837363433392C37353837383531322C37353934373239372C37353935383632312C37353936313239322C,0x37353837373331332C37353838303736352C37353934373434332C37353935383637382C37353936313331342C),
 (145,'ACADM_.fApr07','chr1','+',75971793,76033362,76024544,76032923,16,0x37353937313739332C37353937333036332C37353937383235322C37353938343037382C37353938373639312C37353938383732332C37363030373434392C37363032343330352C37363032353736392C37363032373433312C37363032383232342C37363032393535372C37363032393733332C37363033303435332C37363033323335362C37363033323738322C,0x37353937313930312C37353937333134342C37353937383338332C37353938343138372C37353938373833322C37353938383831392C37363030373531352C37363032343534372C37363032353837372C37363032373632392C37363032383333302C37363032393631302C37363032393834342C37363033303537392C37363033323530362C37363033333336322C),
 (145,'LOC729766.aApr07','chr1','+',76279963,76304501,76280038,76304438,2,0x37363237393936332C37363330343331302C,0x37363238303137312C37363330343530312C),
 (146,'LOC729708.aApr07-unspliced','chr1','+',76938022,76939279,76938061,76938811,1,0x37363933383032322C,0x37363933393237392C),
 (146,'ST6GALNAC5.aApr07','chr1','+',77105714,77303995,77105948,77301479,5,0x37373130353731342C37373130363736392C37373238323437362C37373238383533302C37373330313234372C,0x37373130353936332C37373130373031352C37373238323838362C37373238383633382C37373330333939352C),
 (146,'PIGK.dApr07','chr1','-',77327253,77457703,77330646,77457675,8,0x37373332373235332C37373336303534372C37373339323732312C37373339393536372C37373339393836362C37373430323131382C37373430343939312C37373435373538322C,0x37373333303736332C37373336303633322C37373339323839342C37373339393637382C37373339393938342C37373430323231352C37373430353130332C37373435373730332C),
 (146,'PIGK.bApr07','chr1','-',77327253,77457719,77330646,77457675,11,0x37373332373235332C37373336303534372C37373339323732312C37373339393536372C37373339393836362C37373430323131382C37373430343939312C37373430373533322C37373434343931322C37373434383730382C37373435373538322C,0x37373333303736332C37373336303633322C37373339323839342C37373339393637382C37373339393938342C37373430323231352C37373430353130332C37373430373636382C37373434353030342C37373434383736322C37373435373731392C),
 (146,'PIGK.aApr07','chr1','-',77329978,77457699,77330646,77457675,8,0x37373332393937382C37373339323732382C37373339393536372C37373339393836362C37373430323131382C37373430343939312C37373434383730382C37373435373538322C,0x37373333303736332C37373339323839342C37373339393637382C37373339393938342C37373430323231352C37373430353130332C37373434383736322C37373435373639392C),
 (146,'PIGK.gApr07','chr1','-',77330215,77360634,77330646,77360634,2,0x37373333303231352C37373336303534372C,0x37373333303736332C37373336303633342C),
 (146,'PIGK.jApr07','chr1','-',77330417,77478720,0,0,2,0x37373333303431372C37373437383537392C,0x37373333303736332C37373437383732302C),
 (147,'AK5.dApr07','chr1','+',77609650,77774168,77609650,77774167,8,0x37373630393635302C37373634393235332C37373635353931312C37373732313538392C37373732343538302C37373735363833362C37373736303039392C37373737343131392C,0x37373630393734302C37373634393334342C37373635353938382C37373732313633322C37373732343632352C37373735373030302C37373736303231362C37373737343136382C),
 (147,'AK5.mApr07','chr1','+',77721403,77797002,77721625,77774246,5,0x37373732313430332C37373732343538302C37373735363833362C37373737343139302C37373739363837342C,0x37373732313633322C37373732343632352C37373735363835372C37373737343331312C37373739373030322C),
 (147,'ZZZ3.aApr07','chr1','-',77799488,77921647,77803912,77871627,14,0x37373739393438382C37373830343335332C37373830363630342C37373831343334302C37373831373034362C37373831373739392C37373831393237302C37373832303034382C37373832303235312C37373832323738392C37373837303132322C37373837393635362C37373837393739342C37373932313531302C,0x37373830343035372C37373830343435342C37373830363733392C37373831343439332C37373831373134322C37373831373930312C37373831393334322C37373832303136312C37373832303339392C37373832323932382C37373837313637382C37373837393731392C37373837393932382C37373932313634372C),
 (147,'ZZZ3.dApr07','chr1','-',77800688,77920927,77801037,77879697,9,0x37373830303638382C37373831373836312C37373831393237302C37373832303034382C37373832303235312C37373832323738392C37373837393635362C37373837393739342C37373932303835372C,0x37373830313130302C37373831373930312C37373831393334322C37373832303136342C37373832303339392C37373832323932382C37373837393731392C37373837393932382C37373932303932372C),
 (147,'ZZZ3.bApr07','chr1','-',77802776,77920940,77819198,77871627,11,0x37373830323737362C37373830343335332C37373830363630342C37373831343334302C37373831373034362C37373831373739392C37373832303034382C37373832303235312C37373832323738392C37373837303132322C37373932303835372C,0x37373830343035372C37373830343435342C37373830363733392C37373831343439332C37373831373134322C37373831393334322C37373832303136342C37373832303339392C37373832323932382C37373837313637382C37373932303934302C),
 (147,'ZZZ3.cApr07','chr1','-',77802777,77921667,77803201,77921629,10,0x37373830323737372C37373830343431322C37373830363630342C37373831343334302C37373831373739392C37373831393237302C37373832303034382C37373832303235312C37373832323738392C37373932313533342C,0x37373830333231392C37373830343435342C37373830363733392C37373831343439332C37373831373930312C37373831393334322C37373832303136312C37373832303339392C37373832323932382C37373932313636372C),
 (147,'ZZZ3.eApr07','chr1','-',77802781,77921692,77803912,77877744,14,0x37373830323738312C37373830343335332C37373830363630342C37373831343334302C37373831373034362C37373831373739392C37373831393237302C37373832303034382C37373832303235312C37373832323738392C37373837373732312C37373837393635362C37373837393739342C37373932313533342C,0x37373830343035372C37373830343435342C37373830363733392C37373831343439332C37373831373134322C37373831373930312C37373831393334322C37373832303136342C37373832303339392C37373832323932382C37373837373837352C37373837393731392C37373837393932382C37373932313639322C),
 (147,'ZZZ3.sApr07','chr1','-',77820159,77870326,0,0,4,0x37373832303135392C37373832303235312C37373832323738392C37373837303130372C,0x37373832303136342C37373832303339392C37373832323932382C37373837303332362C),
 (147,'ZZZ3.rApr07','chr1','-',77822893,77879811,0,0,5,0x37373832323839332C37373837313338372C37373837373732312C37373837393635362C37373837393739342C,0x37373832323932382C37373837313637382C37373837373837352C37373837393731392C37373837393831312C);
INSERT INTO `aceview_hg18_housekeeping` (`bin`,`name`,`chrom`,`strand`,`txStart`,`txEnd`,`cdsStart`,`cdsEnd`,`exonCount`,`exonStarts`,`exonEnds`) VALUES 
 (147,'USP33.aApr07','chr1','-',77934257,77998151,77935589,77983735,25,0x37373933343235372C37373933363133352C37373933393634312C37373935303031392C37373935313437322C37373935323838362C37373935343031342C37373935363133392C37373935363836382C37373935393434342C37373936303130332C37373936303239362C37373936313630332C37373936333839342C37373936363536372C37373936383133322C37373936383839302C37373937323631392C37373937343332382C37373937373533372C37373937393134392C37373937393634382C37373937393838392C37373938333639332C37373939373931352C,0x37373933353734372C37373933363230342C37373933393734342C37373935303132382C37373935313535342C37373935333035362C37373935343134312C37373935363332302C37373935363931342C37373935393437382C37373936303139382C37373936303436392C37373936313731362C37373936343033352C37373936363938352C37373936383231312C37373936393030342C37373937323638392C37373937343433312C37373937373639302C37373937393231322C37373937393730322C37373938303032312C37373938333837322C37373939383135312C),
 (147,'USP33.bApr07','chr1','-',77934259,77998151,77935589,77979970,24,0x37373933343235392C37373933363133352C37373933393634312C37373935303031392C37373935313437322C37373935323838362C37373935343031342C37373935363133392C37373935363836382C37373935393434342C37373936303130332C37373936303239362C37373936313630332C37373936333839342C37373936363536372C37373936383133322C37373936383839302C37373937323631392C37373937343332382C37373937373533372C37373937393134392C37373937393634382C37373937393838392C37373939373931352C,0x37373933353734372C37373933363230342C37373933393734342C37373935303132382C37373935313535342C37373935333035362C37373935343134312C37373935363332302C37373935363931342C37373935393437382C37373936303139382C37373936303436392C37373936313731362C37373936343033352C37373936363938352C37373936383231312C37373936393030342C37373937323638392C37373937343433312C37373937373639302C37373937393231322C37373937393730322C37373938303032312C37373939383135312C),
 (147,'USP33.fApr07','chr1','-',77949923,77997962,77950007,77983735,17,0x37373934393932332C37373935313437322C37373935323838362C37373935343031342C37373935363133392C37373935363836382C37373935393434342C37373936303130332C37373937323632372C37373937343332382C37373937373533372C37373937393134392C37373937393634382C37373937393838392C37373938333639332C37373938343637312C37373939373931352C,0x37373935303132382C37373935313535342C37373935333035362C37373935343134312C37373935363332302C37373935363931342C37373935393437382C37373936303136352C37373937323638392C37373937343433312C37373937373639302C37373937393231322C37373937393730322C37373938303032312C37373938333837322C37373938343832392C37373939373936322C),
 (147,'USP33.dApr07','chr1','-',77949924,77998125,77950007,77983735,22,0x37373934393932342C37373935313437322C37373935323838362C37373935343031342C37373935363133392C37373935363836382C37373935393434342C37373936303130332C37373936303239362C37373936313630332C37373936333839342C37373936363536372C37373936383133322C37373936383839302C37373937323631392C37373937343332382C37373937373533372C37373937393134392C37373937393634382C37373937393838392C37373938333639332C37373939373931352C,0x37373935303132382C37373935313535342C37373935333035362C37373935343134312C37373935363332302C37373935363931342C37373935393437382C37373936303137342C37373936303436392C37373936313731362C37373936343033352C37373936363938352C37373936383231312C37373936393030342C37373937323638392C37373937343433312C37373937373639302C37373937393231322C37373937393730322C37373938303032312C37373938333837322C37373939383132352C),
 (147,'USP33.cApr07','chr1','-',77949927,77997997,77950007,77997996,21,0x37373934393932372C37373935313437322C37373935323838362C37373935343031342C37373935363133392C37373935363836382C37373935393434342C37373936303130332C37373936303239362C37373936313630332C37373936333839342C37373936363536372C37373936383133322C37373936383839302C37373937323631392C37373937343332382C37373937373533372C37373937393134392C37373937393634382C37373937393838392C37373939373931352C,0x37373935303132382C37373935313535342C37373935333035362C37373935343134312C37373935363332302C37373935363931342C37373935393437382C37373936303139382C37373936303436392C37373936313731362C37373936343033352C37373936363938352C37373936383231312C37373936393030342C37373937323638392C37373937343433312C37373937373639302C37373937393231322C37373937393730322C37373938303032312C37373939373939372C),
 (147,'USP33.eApr07','chr1','-',77955917,77997917,77956086,77980021,17,0x37373935353931372C37373935363836382C37373935393434342C37373936303130332C37373936303239362C37373936313630332C37373936333839342C37373936363536372C37373936383133322C37373936383839302C37373937323631392C37373937343332382C37373937373533372C37373937393134392C37373937393634382C37373937393838392C37373939373931352C,0x37373935363332302C37373935363931342C37373935393437382C37373936303137342C37373936303436392C37373936313731362C37373936343033352C37373936363938352C37373936383231312C37373936393030342C37373937323638392C37373937343433312C37373937373639302C37373937393231322C37373937393730322C37373938303032312C37373939373931372C),
 (147,'USP33.vfApr07','chr1','-',77977550,77998088,0,0,5,0x37373937373535302C37373937393134392C37373937393634342C37373937393838392C37373939373931352C,0x37373937373639302C37373937393231322C37373937393730322C37373938303032312C37373939383038382C),
 (147,'USP33.jApr07','chr1','-',77977578,77998106,77977579,77983735,6,0x37373937373537382C37373937393134392C37373937393634382C37373937393838392C37373938333639332C37373939373937332C,0x37373937373639302C37373937393231322C37373937393730322C37373938303032312C37373938333837322C37373939383130362C),
 (147,'USP33.sApr07','chr1','-',77977583,77998118,77979183,77979970,5,0x37373937373538332C37373937393134392C37373937393634382C37373937393838392C37373939373937332C,0x37373937373639302C37373937393230372C37373937393730322C37373938303032312C37373939383131382C),
 (147,'USP33.nApr07','chr1','-',77977599,77998118,77977600,77979970,5,0x37373937373539392C37373937393134392C37373937393634382C37373937393838392C37373939373937332C,0x37373937373639302C37373937393231322C37373937393730322C37373938303032312C37373939383131382C),
 (147,'USP33.tApr07','chr1','-',77977603,77998142,77979183,77979970,5,0x37373937373630332C37373937393134392C37373937393634382C37373937393838392C37373939373931352C,0x37373937373639302C37373937393230372C37373937393730322C37373938303032312C37373939383134322C),
 (147,'USP33.lApr07','chr1','-',77977649,77997660,77977651,77983735,6,0x37373937373634392C37373937393134392C37373937393634382C37373937393838392C37373938333639332C37373939373632302C,0x37373937373639302C37373937393231322C37373937393730322C37373938303032312C37373938333931312C37373939373636302C),
 (147,'DNAJB4.bApr07','chr1','+',78217445,78255586,78217447,78254519,3,0x37383231373434352C37383235313332322C37383235343238352C,0x37383231373536352C37383235313839312C37383235353538362C),
 (147,'DNAJB4.cApr07','chr1','+',78217501,78251786,78217502,78251786,4,0x37383231373530312C37383231393437362C37383233313032352C37383235313332322C,0x37383231373536352C37383231393537342C37383233313133382C37383235313738362C),
 (147,'DNAJB4.gApr07','chr1','+',78217540,78251443,78217879,78251350,3,0x37383231373534302C37383233313032352C37383235313332322C,0x37383231373839312C37383233313133382C37383235313434332C),
 (147,'DNAJB4.dApr07','chr1','+',78217540,78251624,78243382,78251624,3,0x37383231373534302C37383234333335312C37383235313332322C,0x37383231373536352C37383234333539332C37383235313632342C),
 (147,'DNAJB4.eApr07','chr1','+',78218455,78251624,78243382,78251624,3,0x37383231383435352C37383234333335312C37383235313332322C,0x37383231383539342C37383234333539332C37383235313632342C),
 (147,'DNAJB4.aApr07','chr1','+',78242418,78256237,78243382,78254519,3,0x37383234323431382C37383235313332322C37383235343238352C,0x37383234333539332C37383235313839312C37383235363233372C),
 (147,'DNAJB4.fApr07','chr1','+',78243206,78254568,78243382,78254308,2,0x37383234333230362C37383235343238352C,0x37383234333539332C37383235343536382C),
 (147,'raseyo.aApr07','chr1','+',78467871,78532162,0,0,6,0x37383436373837312C37383438383435352C37383438393736352C37383533303735312C37383533313335302C37383533313836322C,0x37383436383030312C37383438393238322C37383439303134392C37383533303930332C37383533313534392C37383533323136322C),
 (147,'raseyo.bApr07','chr1','+',78467892,78607733,0,0,6,0x37383436373839322C37383438383435352C37383438393736352C37383538303739372C37383630363830392C37383630373535352C,0x37383436383030312C37383438383634352C37383439303134392C37383538303931322C37383630373030302C37383630373733332C),
 (148,'PTGFR.bApr07','chr1','+',78729247,78778974,78731016,78774960,3,0x37383732393234372C37383733303934342C37383737343637382C,0x37383732393530392C37383733313831342C37383737383937342C),
 (148,'PTGFR.cApr07','chr1','+',78729311,78775285,78731016,78770510,5,0x37383732393331312C37383733303934342C37383733363134362C37383737303438352C37383737343637382C,0x37383732393530392C37383733313831342C37383733363231372C37383737303632362C37383737353238352C),
 (148,'PTGFR.dApr07','chr1','+',78729311,78778974,78731016,78774703,4,0x37383732393331312C37383733303934342C37383733363134362C37383737343637382C,0x37383732393530392C37383733313831342C37383733363231372C37383737383937342C),
 (148,'PTGFR.gApr07','chr1','+',78752804,78775129,0,0,3,0x37383735323830342C37383735333230382C37383737343637382C,0x37383735323839392C37383735333237312C37383737353132392C),
 (148,'PTGFR.fApr07','chr1','+',78752807,78775351,78774684,78774960,2,0x37383735323830372C37383737343637382C,0x37383735323839392C37383737353335312C),
 (148,'PTGFR.eApr07','chr1','+',78753085,78775135,78774684,78774960,2,0x37383735333038352C37383737343637382C,0x37383735333237312C37383737353133352C),
 (148,'ELTD1.aApr07','chr1','-',79128032,79245092,79129426,79244927,15,0x37393132383033322C37393132393739362C37393133313337302C37393135353930362C37393135363130322C37393135383435352C37393135393838352C37393136353135382C37393137343536372C37393137363037392C37393137363337322C37393137373436302C37393138343534362C37393234333334322C37393234343930352C,0x37393132393438392C37393132393936352C37393133313436322C37393135353937332C37393135363332332C37393135383635392C37393136303035392C37393136353336342C37393137343638342C37393137363236332C37393137363535322C37393137373533312C37393138343639392C37393234333439322C37393234353039322C),
 (148,'ELTD1.dApr07','chr1','-',79176234,79426755,79176236,79184619,5,0x37393137363233342C37393137363337322C37393137373436302C37393138343534362C37393432363631352C,0x37393137363236332C37393137363535322C37393137373533312C37393138343639392C37393432363735352C),
 (148,'ELTD1.hApr07','chr1','-',79176481,79426672,0,0,6,0x37393137363438312C37393137373436302C37393138343534362C37393333333735352C37393335313333342C37393432363631352C,0x37393137363535322C37393137373533312C37393138343639392C37393333333839302C37393335313432332C37393432363637322C),
 (150,'jorbu.bApr07','chr1','+',80774027,80885060,80774166,80884846,3,0x38303737343032372C38303838323439372C38303838343833352C,0x38303737343231352C38303838323632362C38303838353036302C),
 (150,'jorbu.cApr07','chr1','+',80774075,80885061,0,0,4,0x38303737343037352C38303737383836312C38303838323439372C38303838343833352C,0x38303737343231352C38303737383930392C38303838323632362C38303838353036312C),
 (151,'LPHN2.aApr07','chr1','+',81938042,82229698,82075257,82229417,21,0x38313933383034322C38323030303038332C38323037353135372C38323134353238392C38323137343939392C38323138313234302C38323138383436302C38323138393238392C38323139303232382C38323139343134382C38323230343332392C38323230343637352C38323230363239372C38323230373434392C38323230383538352C38323231303132332C38323231383134302C38323232303037392C38323232323835342C38323232333533302C38323232383636322C,0x38313933383038312C38323030303132352C38323037353333302C38323134353530332C38323137353130392C38323138323034312C38323138383735342C38323138393339332C38323139303431342C38323139343333322C38323230343435352C38323230343838312C38323230363437312C38323230373635392C38323230383830362C38323231303139302C38323231383233322C38323232303234382C38323232323938332C38323232333632372C38323232393639382C),
 (151,'LPHN2.dApr07','chr1','+',82038669,82230468,82075257,82228674,19,0x38323033383636392C38323037353135372C38323134353238392C38323137343939392C38323138313234302C38323138383436302C38323138393238392C38323139303232382C38323139343134382C38323230343332392C38323230343637352C38323230363239372C38323230373434392C38323230383538352C38323231303132332C38323231383134302C38323232303037392C38323232323835342C38323232383636322C,0x38323033383738352C38323037353333302C38323134353530332C38323137353130392C38323138323034312C38323138383735342C38323138393339332C38323139303431342C38323139343333322C38323230343435352C38323230343838312C38323230363437312C38323230373635392C38323230383830362C38323231303139302C38323231383233322C38323232303234382C38323232323938332C38323233303436382C),
 (151,'LPHN2.cApr07','chr1','+',82038669,82230468,82075257,82227952,22,0x38323033383636392C38323037353135372C38323134353238392C38323137343939392C38323138313234302C38323138383436302C38323138393238392C38323139303232382C38323139343134382C38323230343332392C38323230343637352C38323230363239372C38323230373434392C38323230383538352C38323231303132332C38323231383134302C38323232303037392C38323232323835342C38323232333533302C38323232353536302C38323232373932382C38323232383636322C,0x38323033383738352C38323037353333302C38323134353530332C38323137353130392C38323138323034312C38323138383735342C38323138393339332C38323139303431342C38323139343333322C38323230343435352C38323230343838312C38323230363437312C38323230373635392C38323230383830362C38323231303139302C38323231383233322C38323232303234382C38323232323938332C38323232333632372C38323232353631332C38323232373938312C38323233303436382C),
 (151,'LPHN2.bApr07','chr1','+',82038669,82231010,82075257,82229417,20,0x38323033383636392C38323037353135372C38323134353238392C38323137343939392C38323138313234302C38323138383436302C38323138393238392C38323139303232382C38323139343134382C38323230343332392C38323230343637352C38323230363239372C38323230373434392C38323230383538352C38323231303132332C38323231383134302C38323232303037392C38323232323835342C38323232333533302C38323232383636322C,0x38323033383738352C38323037353333302C38323134353530332C38323137353130392C38323138323034312C38323138383735342C38323138393339332C38323139303431342C38323139343333322C38323230343435352C38323230343838312C38323230363437312C38323230373635392C38323230383830362C38323231303139302C38323231383233322C38323232303234382C38323232323938332C38323232333632372C38323233313031302C),
 (151,'LPHN2.pApr07','chr1','+',82039210,82145485,82075257,82145483,3,0x38323033393231302C38323037353135372C38323134353238392C,0x38323033393334312C38323037353333302C38323134353438352C),
 (151,'LPHN2.jApr07','chr1','+',82040416,82181377,82075257,82181377,5,0x38323034303431362C38323037353135372C38323134353238392C38323137343939392C38323138313234302C,0x38323034303530322C38323037353333302C38323134353530332C38323137353130392C38323138313337372C),
 (152,'stoybaw.aApr07','chr1','+',83141453,83405086,0,0,11,0x38333134313435332C38333134353733382C38333233303133302C38333233343938352C38333233353734332C38333331343431312C38333332343438322C38333333323037312C38333333353133352C38333339383837362C38333430343937342C,0x38333134323039342C38333134353835332C38333233303235312C38333233353034372C38333233353836302C38333331343439352C38333332343538352C38333333323235342C38333333353234382C38333339383933372C38333430353038362C),
 (152,'stoybaw.bApr07','chr1','+',83190942,83235832,0,0,3,0x38333139303934322C38333233343938352C38333233353734332C,0x38333139313130382C38333233353034372C38333233353833322C),
 (152,'fyroybo.bApr07','chr1','-',83256934,83502415,0,0,6,0x38333235363933342C38333235373430312C38333235393531362C38333334313137322C38333437303237362C38333530313835372C,0x38333235373238312C38333235373439322C38333235393639392C38333334313237352C38333437303337362C38333530323431352C),
 (153,'TTLL7.aApr07','chr1','-',84103294,84237421,84108232,84190482,21,0x38343130333239342C38343132313233332C38343132383539312C38343134323334392C38343134343539392C38343134353732362C38343134393433352C38343135353837342C38343135373936392C38343135393335372C38343135393531372C38343136373430362C38343137313837382C38343137363132322C38343138303733332C38343138353339342C38343138363839382C38343138383133352C38343139303131352C38343139303435372C38343233373230312C,0x38343130383335332C38343132313430372C38343132383735322C38343134323433302C38343134343733342C38343134353933322C38343134393633342C38343135353936312C38343135383130352C38343135393433312C38343135393636352C38343136373530312C38343137323033372C38343137363238372C38343138303935302C38343138353535332C38343138363936362C38343138383235372C38343139303234372C38343139303635382C38343233373432312C),
 (153,'TTLL7.gApr07','chr1','-',84107873,84237207,84155906,84180868,21,0x38343130373837332C38343132313233332C38343132383539312C38343134323334392C38343134343539392C38343134353732362C38343134393433352C38343135353837342C38343135373936392C38343135393335372C38343135393531372C38343136373430362C38343137313837382C38343137363132322C38343138303733332C38343138343237302C38343138353339342C38343138363839382C38343139303131352C38343139303435372C38343233373230312C,0x38343130383335332C38343132313430372C38343132383735322C38343134323433302C38343134343733342C38343134353933322C38343134393633342C38343135353935372C38343135383130352C38343135393433312C38343135393636352C38343136373530312C38343137323033372C38343137363238372C38343138303935302C38343138343638332C38343138353535332C38343138383235372C38343139303234372C38343139303635382C38343233373230372C),
 (153,'TTLL7.fApr07','chr1','-',84107971,84167474,84108232,84159371,8,0x38343130373937312C38343132313233332C38343134393534302C38343135353837342C38343135373936392C38343135393335372C38343135393532312C38343136373430362C,0x38343130383335332C38343132313430302C38343134393633342C38343135353936312C38343135383130352C38343135393433312C38343135393636352C38343136373437342C),
 (153,'TTLL7.iApr07','chr1','-',84107971,84237380,84158843,84176275,22,0x38343130373937312C38343132313233332C38343132353434372C38343132383539312C38343134323334392C38343134343539392C38343134353732362C38343134393433352C38343135353837342C38343135373936392C38343135383739332C38343135393335372C38343135393531372C38343136373430362C38343137313837382C38343137363132322C38343138353339342C38343138363839382C38343138383133352C38343139303131352C38343139303435372C38343233373230312C,0x38343130383335332C38343132313430372C38343132353535352C38343132383735322C38343134323433302C38343134343733342C38343134353933322C38343134393633342C38343135353937352C38343135383130352C38343135383838362C38343135393433312C38343135393636352C38343136373530312C38343137323033372C38343137363238372C38343138353535332C38343138363936362C38343138383235372C38343139303234372C38343139303635382C38343233373338302C),
 (153,'TTLL7.eApr07','chr1','-',84107971,84237363,84151266,84190482,28,0x38343130373937312C38343131383136332C38343131383533312C38343132303933392C38343132313233332C38343132353434372C38343132383539312C38343134303432342C38343134323334392C38343134343539392C38343134353732362C38343134393433352C38343135303731342C38343135313230332C38343135353837342C38343135373936392C38343135393335372C38343135393531372C38343136373430362C38343137313837382C38343137363132322C38343138303733332C38343138353339342C38343138363839382C38343138383133352C38343139303131352C38343139303435372C38343233373230312C,0x38343130383234382C38343131383235342C38343131383536352C38343132313037322C38343132313430372C38343132353535352C38343132383735322C38343134303531312C38343134323433302C38343134343733342C38343134353933322C38343134393633342C38343135303737342C38343135313331312C38343135353936312C38343135383130352C38343135393433312C38343135393636352C38343136373530312C38343137323033372C38343137363238372C38343138303935302C38343138353535332C38343138363936362C38343138383235372C38343139303234372C38343139303635382C38343233373336332C),
 (153,'TTLL7.dApr07','chr1','-',84107971,84237426,84125545,84237426,16,0x38343130373937312C38343132303933392C38343132313233332C38343132353434372C38343132383539312C38343134323334392C38343134343539392C38343134353732362C38343134393433352C38343135353837342C38343135373936392C38343135393335372C38343135393531372C38343136373430362C38343137313837382C38343233373230312C,0x38343130383335332C38343132313035382C38343132313430372C38343132353535352C38343132383735322C38343134323433302C38343134343733342C38343134353933322C38343134393633342C38343135353936312C38343135383130352C38343135393433312C38343135393636352C38343136373530312C38343137323033372C38343233373432362C),
 (153,'TTLL7.cApr07','chr1','-',84107971,84190652,84144776,84190482,20,0x38343130373937312C38343132313233332C38343132383539312C38343134323334392C38343134343539392C38343134353732362C38343134393433352C38343135353837342C38343135373936392C38343135393335372C38343135393531372C38343136373430362C38343137313837382C38343137363132322C38343138303733332C38343138353339342C38343138363839382C38343138383133352C38343139303131352C38343139303435372C,0x38343130383335332C38343132313430372C38343132383735322C38343134323433302C38343134343739342C38343134353933322C38343134393633342C38343135353936312C38343135383130352C38343135393433312C38343135393636352C38343136373530312C38343137323033372C38343137363238372C38343138303935302C38343138353535332C38343138363936362C38343138383235372C38343139303234372C38343139303635322C),
 (153,'TTLL7.bApr07','chr1','-',84108034,84237403,84125545,84190482,24,0x38343130383033342C38343132303933392C38343132313233332C38343132333334362C38343132353434372C38343132383539312C38343134323334392C38343134343539392C38343134353732362C38343134393433352C38343135353837342C38343135373936392C38343135393335372C38343135393531372C38343136373430362C38343137313837382C38343137363132322C38343138303733332C38343138353339342C38343138363839382C38343138383133352C38343139303131352C38343139303435372C38343233373230312C,0x38343130383335332C38343132313035382C38343132313430372C38343132333336352C38343132353535352C38343132383735322C38343134323433302C38343134343733342C38343134353933322C38343134393633342C38343135353936312C38343135383130352C38343135393433312C38343135393636352C38343136373530312C38343137323033372C38343137363238372C38343138303935302C38343138353535332C38343138363936362C38343138383235372C38343139303234372C38343139303635382C38343233373430332C),
 (153,'PRKACB.dApr07','chr1','+',84316304,84476769,84316596,84473576,10,0x38343331363330342C38343431373434372C38343432303437302C38343432323330372C38343432333337302C38343433343838362C38343433353939392C38343434303935332C38343435323432332C38343437333435302C,0x38343331363634322C38343431373530392C38343432303539392C38343432323430362C38343432333435332C38343433353031332C38343433363039352C38343434313037362C38343435323538382C38343437363736392C),
 (153,'PRKACB.hApr07','chr1','+',84316332,84443710,84316596,84442761,9,0x38343331363333322C38343431373434372C38343432303437302C38343432323330372C38343432333337302C38343433343838362C38343433353939392C38343434303935332C38343434323735322C,0x38343331363634322C38343431373530392C38343432303539392C38343432323430362C38343432333435332C38343433353031332C38343433363039352C38343434313037362C38343434333731302C),
 (153,'PRKACB.vpApr07','chr1','+',84316350,84473736,0,0,2,0x38343331363335302C38343437333435302C,0x38343331363634322C38343437333733362C),
 (153,'PRKACB.vjApr07','chr1','+',84316350,84422333,84316596,84422331,6,0x38343331363335302C38343431313539392C38343431333330332C38343431373434372C38343432303437302C38343432323330372C,0x38343331363634322C38343431313632332C38343431333332372C38343431373530392C38343432303539392C38343432323333332C),
 (153,'PRKACB.vgApr07','chr1','+',84316350,84422378,84316596,84422376,5,0x38343331363335302C38343431333330332C38343431373434372C38343432303437302C38343432323330372C,0x38343331363634322C38343431333332372C38343431373530392C38343432303539392C38343432323337382C),
 (153,'PRKACB.vfApr07','chr1','+',84316395,84434916,84316596,84434914,5,0x38343331363339352C38343431373434372C38343432303437302C38343432333337302C38343433343838362C,0x38343331363634322C38343431373530392C38343432303539392C38343432333435332C38343433343931362C),
 (153,'PRKACB.aApr07','chr1','+',84382539,84477951,84382632,84473576,10,0x38343338323533392C38343431373434372C38343432303437302C38343432323330372C38343432333337302C38343433343838362C38343433353939392C38343434303935332C38343435323432332C38343437333435302C,0x38343338323831392C38343431373530392C38343432303539392C38343432323430362C38343432333435332C38343433353031332C38343433363039352C38343434313037362C38343435323538382C38343437373935312C),
 (153,'PRKACB.fApr07','chr1','+',84382544,84443537,84382632,84442761,9,0x38343338323534342C38343431373434372C38343432303437302C38343432323330372C38343432333337302C38343433343838362C38343433353939392C38343434303935332C38343434323735322C,0x38343338323831392C38343431373530392C38343432303539392C38343432323430362C38343432333435332C38343433353031332C38343433363039352C38343434313037362C38343434333533372C),
 (153,'PRKACB.vcApr07','chr1','+',84382546,84420599,84382632,84420599,4,0x38343338323534362C38343431343036392C38343431373434372C38343432303437302C,0x38343338323831392C38343431343037382C38343431373530392C38343432303539392C),
 (153,'PRKACB.sApr07','chr1','+',84382546,84434903,84382632,84434902,5,0x38343338323534362C38343431373434372C38343432303437302C38343432333337302C38343433343838362C,0x38343338323831392C38343431373530392C38343432303539392C38343432333435332C38343433343930332C),
 (153,'PRKACB.vhApr07','chr1','+',84382595,84434967,84420536,84434965,7,0x38343338323539352C38343339353630352C38343431373434372C38343432303437302C38343432323330372C38343432333337302C38343433343838362C,0x38343338323831392C38343339353637362C38343431373530392C38343432303539392C38343432323430362C38343432333435332C38343433343936372C),
 (153,'PRKACB.qApr07','chr1','+',84386386,84434943,84386415,84434941,6,0x38343338363338362C38343431373434372C38343432303437302C38343432323330372C38343432333337302C38343433343838362C,0x38343338363530362C38343431373530392C38343432303539392C38343432323430362C38343432333435332C38343433343934332C),
 (153,'PRKACB.vbApr07','chr1','+',84402580,84423445,84403277,84423445,8,0x38343430323538302C38343430333230352C38343431333330332C38343431343036392C38343431373434372C38343432303437302C38343432323330372C38343432333337302C,0x38343430323639332C38343430333238342C38343431333332372C38343431343037382C38343431373530392C38343432303539392C38343432323430362C38343432333434352C),
 (153,'PRKACB.oApr07','chr1','+',84402580,84434987,84402683,84434986,9,0x38343430323538302C38343431313539392C38343431333330332C38343431343036392C38343431373434372C38343432303437302C38343432323330372C38343432333337302C38343433343838362C,0x38343430323639332C38343431313632332C38343431333332372C38343431343037382C38343431373530392C38343432303539392C38343432323430362C38343432333435332C38343433343938372C),
 (153,'PRKACB.iApr07','chr1','+',84402582,84441076,84402683,84441076,8,0x38343430323538322C38343431373434372C38343432303437302C38343432323330372C38343432333337302C38343433343838362C38343433353939392C38343434303935332C,0x38343430323639332C38343431373530392C38343432303539392C38343432323430362C38343432333435332C38343433353031332C38343433363039352C38343434313037362C),
 (153,'PRKACB.rApr07','chr1','+',84402590,84434961,84402683,84434959,8,0x38343430323539302C38343431333330332C38343431343036392C38343431373434372C38343432303437302C38343432323330372C38343432333337302C38343433343838362C,0x38343430323639332C38343431333332372C38343431343037382C38343431373530392C38343432303539392C38343432323430362C38343432333435332C38343433343936312C),
 (153,'PRKACB.vaApr07','chr1','+',84402606,84422406,84410729,84422406,8,0x38343430323630362C38343431303731302C38343431313539392C38343431333330332C38343431343036392C38343431373434372C38343432303437302C38343432323330372C,0x38343430323639332C38343431303739302C38343431313632332C38343431333332372C38343431343037382C38343431373530392C38343432303539392C38343432323430362C),
 (153,'PRKACB.cApr07','chr1','+',84402612,84476760,84402683,84473576,12,0x38343430323631322C38343431313539392C38343431333330332C38343431373434372C38343432303437302C38343432323330372C38343432333337302C38343433343838362C38343433353939392C38343434303935332C38343435323432332C38343437333435302C,0x38343430323639332C38343431313632332C38343431333332372C38343431373530392C38343432303539392C38343432323430362C38343432333435332C38343433353031332C38343433363039352C38343434313037362C38343435323538382C38343437363736302C),
 (153,'PRKACB.tApr07','chr1','+',84402653,84434922,84403277,84434920,10,0x38343430323635332C38343430333230352C38343431313539392C38343431333330332C38343431343036392C38343431373434372C38343432303437302C38343432323330372C38343432333337302C38343433343838362C,0x38343430323639332C38343430333238342C38343431313632332C38343431333332372C38343431343037382C38343431373530392C38343432303539392C38343432323430362C38343432333435332C38343433343932322C),
 (153,'PRKACB.jApr07','chr1','+',84402659,84436095,84402659,84436095,8,0x38343430323635392C38343431333330332C38343431373434372C38343432303437302C38343432323330372C38343432333337302C38343433343838362C38343433353939392C,0x38343430323639332C38343431333332372C38343431373530392C38343432303539392C38343432323430362C38343432333435332C38343433353031332C38343433363039352C),
 (153,'PRKACB.kApr07','chr1','+',84402659,84436087,84403277,84436086,10,0x38343430323635392C38343430333230352C38343431313539392C38343431333330332C38343431373434372C38343432303437302C38343432323330372C38343432333337302C38343433343838362C38343433353939392C,0x38343430323639332C38343430333238342C38343431313632332C38343431333332372C38343431373530392C38343432303539392C38343432323430362C38343432333435332C38343433353031332C38343433363038372C),
 (153,'PRKACB.vdApr07','chr1','+',84402749,84436012,84420536,84436011,9,0x38343430323734392C38343431313539392C38343431333330332C38343431373434372C38343432303437302C38343432323330372C38343432333337302C38343433343838362C38343433353939392C,0x38343430323831322C38343431313632332C38343431333332372C38343431373530392C38343432303539392C38343432323430362C38343432333435332C38343433353031332C38343433363031322C),
 (153,'PRKACB.bApr07','chr1','+',84402919,84476769,84403277,84473576,13,0x38343430323931392C38343431313539392C38343431333330332C38343431343036392C38343431373434372C38343432303437302C38343432323330372C38343432333337302C38343433343838362C38343433353939392C38343434303935332C38343435323432332C38343437333435302C,0x38343430333238342C38343431313632332C38343431333332372C38343431343037382C38343431373530392C38343432303539392C38343432323430362C38343432333435332C38343433353031332C38343433363039352C38343434313037362C38343435323538382C38343437363736392C),
 (153,'PRKACB.eApr07','chr1','+',84402928,84475419,84403277,84473576,11,0x38343430323932382C38343431313539392C38343431333330332C38343431373434372C38343432303437302C38343432333337302C38343433343838362C38343433353939392C38343434303935332C38343435323432332C38343437333435302C,0x38343430333238342C38343431313632332C38343431333332372C38343431373530392C38343432303539392C38343432333435332C38343433353031332C38343433363039352C38343434313037362C38343435323538382C38343437353431392C),
 (153,'PRKACB.mApr07','chr1','+',84402944,84436064,84403277,84436062,9,0x38343430323934342C38343431313539392C38343431333330332C38343431373434372C38343432303437302C38343432323330372C38343432333337302C38343433343838362C38343433353939392C,0x38343430333238342C38343431313632332C38343431333332372C38343431373530392C38343432303539392C38343432323430362C38343432333435332C38343433353031332C38343433363036342C),
 (153,'PRKACB.uApr07','chr1','+',84402946,84434902,84403277,84434902,8,0x38343430323934362C38343431333330332C38343431343036392C38343431373434372C38343432303437302C38343432323330372C38343432333337302C38343433343838362C,0x38343430333238342C38343431333332372C38343431343037382C38343431373530392C38343432303539392C38343432323430362C38343432333435332C38343433343930322C),
 (153,'PRKACB.nApr07','chr1','+',84402956,84436083,84403277,84436083,7,0x38343430323935362C38343431373434372C38343432303437302C38343432323330372C38343432333337302C38343433343838362C38343433353939392C,0x38343430333238342C38343431373530392C38343432303539392C38343432323430362C38343432333435332C38343433353031332C38343433363038332C),
 (153,'PRKACB.gApr07','chr1','+',84402965,84443565,84403277,84442761,12,0x38343430323936352C38343431313539392C38343431333330332C38343431343036392C38343431373434372C38343432303437302C38343432323330372C38343432333337302C38343433343838362C38343433353939392C38343434303935332C38343434323734392C,0x38343430333238342C38343431313632332C38343431333332372C38343431343037382C38343431373530392C38343432303539392C38343432323430362C38343432333435332C38343433353031332C38343433363039352C38343434313037362C38343434333536352C),
 (153,'PRKACB.voApr07','chr1','+',84402969,84417483,0,0,5,0x38343430323936392C38343431313539392C38343431333330332C38343431353636342C38343431373434372C,0x38343430333238342C38343431313632332C38343431333332372C38343431353835342C38343431373438332C),
 (153,'PRKACB.viApr07','chr1','+',84402983,84422365,84403251,84422364,6,0x38343430323938332C38343431313539392C38343431333330332C38343431373434372C38343432303437302C38343432323330372C,0x38343430333236342C38343431313632332C38343431333332372C38343431373530392C38343432303539392C38343432323336352C),
 (153,'PRKACB.veApr07','chr1','+',84403070,84423420,84403277,84423418,6,0x38343430333037302C38343431333331382C38343431373434372C38343432303437302C38343432323330372C38343432333337302C,0x38343430333238342C38343431333332372C38343431373530392C38343432303539392C38343432323430362C38343432333432302C),
 (153,'PRKACB.pApr07','chr1','+',84403169,84435013,84403277,84435013,7,0x38343430333136392C38343431333330332C38343431373434372C38343432303437302C38343432323330372C38343432333337302C38343433343838362C,0x38343430333238342C38343431333332372C38343431373530392C38343432303539392C38343432323430362C38343432333435332C38343433353031332C),
 (153,'SAMD13.dApr07','chr1','+',84536637,84589067,84536828,84588045,4,0x38343533363633372C38343534313437332C38343536333930372C38343538373930312C,0x38343533363833382C38343534313535382C38343536343031392C38343538393036372C),
 (153,'SAMD13.bApr07','chr1','+',84537824,84588078,84537824,84588045,4,0x38343533373832342C38343534313437332C38343536333930372C38343538373930312C,0x38343533373931352C38343534313535382C38343536343031392C38343538383037382C),
 (153,'SAMD13.fApr07','chr1','+',84539875,84588278,84541505,84588045,4,0x38343533393837352C38343534313437332C38343536333930372C38343538373930312C,0x38343534303037322C38343534313535382C38343536343031392C38343538383237382C),
 (153,'SAMD13.jApr07','chr1','+',84539927,84541895,0,0,2,0x38343533393932372C38343534313437332C,0x38343534303037322C38343534313839352C),
 (153,'SAMD13.iApr07','chr1','+',84539993,84542157,0,0,2,0x38343533393939332C38343534313437332C,0x38343534303238352C38343534323135372C),
 (153,'SAMD13.gApr07','chr1','+',84540921,84589069,84541505,84588045,4,0x38343534303932312C38343534313437332C38343536333930372C38343538373930312C,0x38343534303936312C38343534313535382C38343536343031392C38343538393036392C),
 (153,'SAMD13.eApr07','chr1','+',84541304,84588201,84541505,84588045,4,0x38343534313330342C38343534313437332C38343536333930372C38343538373930312C,0x38343534313337312C38343534313535382C38343536343031392C38343538383230312C),
 (153,'CTBSandGNG5.eApr07','chr1','-',84736148,84812218,84740115,84804190,7,0x38343733363134382C38343734303039362C38343830313532372C38343830323030352C38343830343131312C38343830383835322C38343831323138362C,0x38343733363831392C38343734303234312C38343830313638392C38343830323130332C38343830343238332C38343830383939312C38343831323231382C),
 (153,'SPATA1.aApr07','chr1','+',84744561,84807240,84754564,84791395,16,0x38343734343536312C38343735343439332C38343735383835352C38343736303636302C38343736333936362C38343736343131352C38343737313133302C38343737313937392C38343738323437322C38343738333930342C38343738373035362C38343738383730322C38343739313330352C38343739343138302C38343830343133312C38343830363635332C,0x38343734343638392C38343735343636362C38343735383936322C38343736303737382C38343736343032302C38343736343334342C38343737313234352C38343737323033372C38343738323537352C38343738343033302C38343738373233352C38343738383830312C38343739313339352C38343739343235302C38343830353138302C38343830373234302C),
 (153,'SPATA1.fApr07','chr1','+',84782472,84804459,84782472,84791395,5,0x38343738323437322C38343738373035362C38343739313330352C38343739343138302C38343830343133312C,0x38343738323537352C38343738373233352C38343739313339352C38343739343235302C38343830343435392C),
 (153,'CTBSandGNG5.dApr07','chr1','-',84791890,84812701,84793269,84804190,7,0x38343739313839302C38343739323631372C38343830313532372C38343830323030352C38343830343131312C38343830383835322C38343831323138362C,0x38343739323338302C38343739333437302C38343830313638392C38343830323130332C38343830343238332C38343830383939312C38343831323730312C),
 (153,'CTBSandGNG5.bApr07','chr1','-',84792699,84812735,84793269,84812734,7,0x38343739323639392C38343830313532372C38343830323030352C38343830343131312C38343830383230312C38343830383835322C38343831323530392C,0x38343739333437302C38343830313638392C38343830323130332C38343830343238332C38343830383431302C38343830383939312C38343831323733352C),
 (153,'CTBSandGNG5.cApr07','chr1','-',84793108,84812691,84793269,84808895,7,0x38343739333130382C38343830313532372C38343830323030352C38343830343131312C38343830383230312C38343830383835322C38343831323138362C,0x38343739333437302C38343830313638392C38343830323130332C38343830343238332C38343830383431302C38343830383939312C38343831323639312C),
 (153,'CTBSandGNG5.aApr07','chr1','-',84793164,84859301,84793269,84857078,6,0x38343739333136342C38343830313532372C38343830323030352C38343833363233342C38343835373030332C38343835393032372C,0x38343739333437302C38343830313638392C38343830323035342C38343833363336372C38343835373135352C38343835393330312C),
 (153,'CTBSandGNG5.gApr07','chr1','-',84801591,84812691,84801593,84804190,5,0x38343830313539312C38343830323030352C38343830343131312C38343830383835322C38343831323530392C,0x38343830313638392C38343830323130332C38343830343238332C38343830383939312C38343831323639312C),
 (153,'CTBSandGNG5.jApr07','chr1','-',84802170,84821601,84804272,84820614,5,0x38343830323137302C38343830343131312C38343830383835322C38343832303534382C38343832313132372C,0x38343830323138352C38343830343238332C38343830383939312C38343832303632392C38343832313630312C),
 (154,'EDG7.aApr07','chr1','-',85049872,85131467,85052116,85104391,3,0x38353034393837322C38353130333635352C38353133313238362C,0x38353035323434322C38353130343430392C38353133313436372C),
 (154,'EDG7.bApr07','chr1','-',85052187,85104409,85103685,85104391,3,0x38353035323138372C38353130333635352C38353130333935392C,0x38353035323434322C38353130333831342C38353130343430392C),
 (154,'MCOLN2.bApr07','chr1','-',85163853,85235384,85185347,85235143,12,0x38353136333835332C38353136373832382C38353136393633322C38353137363032352C38353137363235312C38353138353330332C38353139303531332C38353139303731362C38353139343730312C38353139363739392C38353230333831392C38353233353036362C,0x38353136343939322C38353136373935302C38353136393833392C38353137363134382C38353137363335332C38353138353335302C38353139303631302C38353139303830312C38353139343835352C38353139363937332C38353230333937392C38353233353338342C),
 (154,'MCOLN2.aApr07','chr1','-',85163853,85235393,85164955,85235143,14,0x38353136333835332C38353136373832382C38353136393633322C38353137363032352C38353137363235312C38353137373832332C38353137393134392C38353138353330332C38353139303531332C38353139303731362C38353139343730312C38353139363739392C38353230333831392C38353233353036362C,0x38353136343939322C38353136373935302C38353136393833392C38353137363134382C38353137363335332C38353137373937332C38353137393236322C38353138353430332C38353139303631302C38353139303830312C38353139343835352C38353139363937332C38353230333937392C38353233353339332C),
 (154,'MCOLN2.cApr07','chr1','-',85190791,85235383,85190793,85203972,5,0x38353139303739312C38353139343730312C38353139363739392C38353230333831392C38353233353237382C,0x38353139303830312C38353139343835352C38353139363937332C38353230333937392C38353233353338332C),
 (154,'WDR63.aApr07','chr1','+',85237416,85371408,85237572,85371269,23,0x38353233373431362C38353331303139382C38353331313332342C38353331393530342C38353332303537302C38353332323831362C38353332343130312C38353332383338362C38353333313732382C38353333323730312C38353333343230312C38353333353833392C38353333363830302C38353334323739342C38353334363330332C38353334383331382C38353335353939392C38353336303032312C38353336323339312C38353336343738312C38353336363937382C38353336383236302C38353337313132352C,0x38353233373630392C38353331303237362C38353331313336332C38353331393638362C38353332303637352C38353332323936362C38353332343330312C38353332383530332C38353333313931392C38353333323832362C38353333343239312C38353333353932362C38353333363932392C38353334323836382C38353334363434382C38353334383430362C38353335363133302C38353336303038352C38353336323532322C38353336343938362C38353336373037302C38353336383338332C38353337313430382C),
 (154,'WDR63.bApr07','chr1','+',85300569,85371408,85310212,85371269,23,0x38353330303536392C38353331303139382C38353331313332342C38353331393530342C38353332303537302C38353332323831362C38353332343130312C38353332383338362C38353333313732382C38353333323730312C38353333343230312C38353333353833392C38353333363830302C38353334323739342C38353334363330332C38353334383331382C38353335353939392C38353336303032312C38353336323339312C38353336343738312C38353336363937382C38353336383236302C38353337313132352C,0x38353330303735372C38353331303237362C38353331313336332C38353331393638362C38353332303637352C38353332323936362C38353332343330312C38353332383530332C38353333313931392C38353333323832362C38353333343239312C38353333353932362C38353333363932392C38353334323836382C38353334363434382C38353334383430362C38353335363133302C38353336303038352C38353336323532322C38353336343938362C38353336373037302C38353336383338332C38353337313430382C),
 (154,'WDR63.cApr07','chr1','+',85300612,85371411,85310212,85371269,22,0x38353330303631322C38353331303139382C38353331313332342C38353331393530342C38353332303537302C38353332323831362C38353332343130312C38353333313732382C38353333323730312C38353333343230312C38353333353833392C38353333363830302C38353334323739342C38353334363330332C38353334383331382C38353335353939392C38353336303032312C38353336323339312C38353336343738312C38353336363937382C38353336383236302C38353337313132352C,0x38353330303735372C38353331303237362C38353331313336332C38353331393638362C38353332303637352C38353332323936362C38353332343330312C38353333313931392C38353333323832362C38353333343239312C38353333353932362C38353333363932392C38353334323836382C38353334363434382C38353334383430362C38353335363133302C38353336303038352C38353336323532322C38353336343938362C38353336373037302C38353336383338332C38353337313431312C),
 (154,'LOC646626.dApr07','chr1','+',85514986,85638234,0,0,5,0x38353531343938362C38353531353931312C38353631353033362C38353631383634342C38353633363732372C,0x38353531353036382C38353531363030392C38353631353130362C38353631383833362C38353633383233342C),
 (154,'LOC646626.eApr07','chr1','+',85515942,85686395,0,0,3,0x38353531353934322C38353631353033362C38353638363036382C,0x38353531363030392C38353631353130362C38353638363339352C),
 (154,'DDAH1.aApr07','chr1','-',85556750,85703478,85559722,85703316,6,0x38353535363735302C38353536333031302C38353538383638352C38353538393737362C38353539373031382C38353730333031332C,0x38353535393833392C38353536333135342C38353538383830352C38353538393835302C38353539373131382C38353730333437382C),
 (154,'DDAH1.cApr07','chr1','-',85556751,85816545,85559722,85597112,7,0x38353535363735312C38353536333031302C38353538383638352C38353538393737362C38353539373031382C38353733343433362C38353831363235342C,0x38353535393833392C38353536333135342C38353538383830352C38353538393835302C38353539373131382C38353733343535322C38353831363534352C),
 (154,'DDAH1.bApr07','chr1','-',85559660,85816442,85559722,85816272,6,0x38353535393636302C38353536333031302C38353538383638352C38353538393737362C38353539373031382C38353831363235342C,0x38353535393833392C38353536333135342C38353538383830352C38353538393835302C38353539373131382C38353831363434322C),
 (154,'DDAH1.dApr07','chr1','-',85559752,85642710,85559752,85642654,6,0x38353535393735322C38353536333031302C38353538383638352C38353538393737362C38353539373031382C38353634323635312C,0x38353535393833392C38353536333135342C38353538383830352C38353538393835302C38353539373131382C38353634323731302C),
 (154,'DDAH1.eApr07','chr1','-',85559780,85618160,85559782,85597112,6,0x38353535393738302C38353536333031302C38353538383638352C38353538393737362C38353539373031382C38353631383035382C,0x38353535393833392C38353536333135342C38353538383830352C38353538393835302C38353539373131382C38353631383136302C),
 (154,'DDAH1.gApr07','chr1','-',85563138,85618723,85563139,85597112,5,0x38353536333133382C38353538383638352C38353538393737362C38353539373031382C38353631373835312C,0x38353536333135342C38353538383830352C38353538393835302C38353539373131382C38353631383732332C),
 (154,'DDAH1.fApr07','chr1','-',85588050,85816426,85588137,85816272,5,0x38353538383035302C38353538383638352C38353538393737362C38353539373031382C38353831363235342C,0x38353538383136342C38353538383830352C38353538393835302C38353539373131382C38353831363432362C),
 (154,'DDAH1.hApr07','chr1','-',85588695,85760006,85588697,85597112,5,0x38353538383639352C38353538393737362C38353539373031382C38353733343433362C38353735393838392C,0x38353538383830352C38353538393835302C38353539373131382C38353733343535322C38353736303030362C),
 (154,'DDAH1.mApr07','chr1','-',85589803,85816467,0,0,5,0x38353538393830332C38353539373031382C38353539383731392C38353733343433362C38353831363235342C,0x38353538393835302C38353539373131382C38353539383830382C38353733343535322C38353831363436372C),
 (154,'DDAH1.kApr07','chr1','-',85712758,85816410,0,0,3,0x38353731323735382C38353733343433362C38353831363235342C,0x38353731333036352C38353733343535322C38353831363431302C),
 (154,'DDAH1.pApr07','chr1','-',85720553,85816277,0,0,4,0x38353732303535332C38353732363536312C38353733343433362C38353831363235342C,0x38353732303739352C38353732363636312C38353733343535322C38353831363237372C),
 (154,'DDAH1.qApr07','chr1','-',85720557,85733046,0,0,3,0x38353732303535372C38353732363536312C38353733323939392C,0x38353732303739352C38353732363636312C38353733333034362C),
 (154,'DDAH1.jApr07','chr1','-',85720557,85816502,0,0,5,0x38353732303535372C38353732363536312C38353733323939392C38353733343433362C38353831363235342C,0x38353732303739352C38353732363636312C38353733333033322C38353733343535322C38353831363530322C),
 (155,'swarbo.bApr07','chr1','-',86809451,86931474,0,0,4,0x38363830393435312C38363838363230372C38363838383531302C38363933313433332C,0x38363830393637392C38363838363331382C38363838383635322C38363933313437342C),
 (156,'HS2ST1.dApr07','chr1','+',87152917,87336716,87153307,87336210,5,0x38373135323931372C38373331313230342C38373332323436342C38373333303830312C38373333363130382C,0x38373135333433312C38373331313434332C38373332323535302C38373333303934302C38373333363731362C),
 (156,'HS2ST1.aApr07','chr1','+',87152946,87348411,87153307,87342967,7,0x38373135323934362C38373331313230342C38373332323436342C38373333303830312C38373333363130382C38373334313730322C38373334323734302C,0x38373135333433312C38373331313434332C38373332323535302C38373333303934302C38373333363230362C38373334313836302C38373334383431312C),
 (156,'HS2ST1.jApr07','chr1','+',87152949,87196778,87153141,87196777,2,0x38373135323934392C38373139363731302C,0x38373135333433312C38373139363737382C),
 (156,'HS2ST1.lApr07','chr1','+',87194755,87330859,87311254,87330859,5,0x38373139343735352C38373139363731302C38373331313230342C38373332323436342C38373333303830312C,0x38373139343834332C38373139363737382C38373331313434332C38373332323535302C38373333303835392C),
 (156,'HS2ST1.bApr07','chr1','+',87231274,87407472,87231352,87406447,8,0x38373233313237342C38373331313230342C38373332323436342C38373333303830312C38373333363130382C38373334313730322C38373337313838342C38373430363430362C,0x38373233313339382C38373331313434332C38373332323535302C38373333303934302C38373333363230362C38373334313836302C38373337313938392C38373430373437322C),
 (157,'beybar.aApr07','chr1','-',88137729,88541234,0,0,5,0x38383133373732392C38383530373534332C38383530393830332C38383534303137392C38383534313034362C,0x38383133383235312C38383530373631352C38383530393932332C38383534303239362C38383534313233342C),
 (157,'riseyo.aApr07','chr1','-',88199713,88215004,0,0,3,0x38383139393731332C38383230333336362C38383231343733312C,0x38383230303232362C38383230333637372C38383231353030342C),
 (157,'borbar.aApr07','chr1','-',88775783,88923042,0,0,5,0x38383737353738332C38383737383735372C38383739353137342C38383830383235372C38383932323834322C,0x38383737363334362C38383737383933302C38383739353331392C38383830383436362C38383932333034322C),
 (157,'PKN2.aApr07','chr1','+',88922415,89074526,88922851,89071719,22,0x38383932323431352C38383937393235382C38383939383439322C38393030383632322C38393030393639312C38393030393933332C38393032323930392C38393032343337342C38393034323636312C38393034333131362C38393034333736372C38393034343136312C38393034353538332C38393034353739392C38393034353935342C38393035313832372C38393036303231312C38393036323538302C38393036363735312C38393037313031342C38393037313334372C38393037313531352C,0x38383932323839392C38383937393535392C38383939383634372C38393030383734302C38393030393833372C38393031303135302C38393032333039352C38393032343438342C38393034323830352C38393034333139322C38393034333934322C38393034343238382C38393034353731342C38393034353837352C38393034363034362C38393035323030342C38393036303237342C38393036323635372C38393036363839342C38393037313132322C38393037313432382C38393037343532362C),
 (157,'PKN2.cApr07','chr1','+',88922735,89045421,88922851,89044081,12,0x38383932323733352C38383937393235382C38383939383439322C38393030383632322C38393030393639312C38393030393933332C38393032323930392C38393032343337342C38393034323636312C38393034333131362C38393034333736372C38393034353236362C,0x38383932323839392C38383937393535392C38383939383634372C38393030383734302C38393030393833372C38393031303135302C38393032333039352C38393032343438342C38393034323830352C38393034333139322C38393034353133332C38393034353432312C),
 (157,'PKN2.fApr07','chr1','+',88922834,88998705,88922836,88998704,3,0x38383932323833342C38383937393235382C38383939383439322C,0x38383932323839392C38383937393535392C38383939383730352C),
 (157,'PKN2.bApr07','chr1','+',88922843,89071790,88922845,89071719,21,0x38383932323834332C38383937393235382C38383939383439322C38393030383632322C38393030393639312C38393030393933332C38393032323930392C38393032343337342C38393034333131362C38393034333736372C38393034343136312C38393034353538332C38393034353739392C38393034353935342C38393035313832372C38393036303231312C38393036323538302C38393036363735312C38393037313031342C38393037313334372C38393037313531352C,0x38383932323839392C38383937393535392C38383939383634372C38393030383734302C38393030393833372C38393031303135302C38393032333039352C38393032343438342C38393034333139322C38393034333934322C38393034343238382C38393034353731342C38393034353837352C38393034363034362C38393035323030342C38393036303237342C38393036323635372C38393036363839342C38393037313132322C38393037313432382C38393037313739302C),
 (157,'PKN2.gApr07','chr1','+',88923449,89008634,88979327,89008634,5,0x38383932333434392C38383932393939342C38383937393235382C38383939383439322C38393030383632322C,0x38383932333436382C38383933303035312C38383937393535392C38383939383634372C38393030383633342C),
 (158,'GBP3.aApr07','chr1','-',89244936,89261150,89245994,89258992,11,0x38393234343933362C38393234373231372C38393234373636322C38393234393137342C38393235303031372C38393235313435352C38393235323335332C38393235323831372C38393235333535372C38393235383830322C38393236303935342C,0x38393234363132332C38393234373431312C38393234373736352C38393234393338372C38393235303239382C38393235313639382C38393235323535302C38393235323932372C38393235333638352C38393235393031342C38393236313135302C),
 (158,'GBP3.cApr07','chr1','-',89244947,89261060,89247760,89258992,9,0x38393234343934372C38393234373231372C38393234373636322C38393235313435352C38393235323335332C38393235323831372C38393235333535372C38393235383830322C38393236303935342C,0x38393234363132332C38393234373431312C38393234373736352C38393235313639382C38393235323535302C38393235323932372C38393235333638352C38393235393031342C38393236313036302C),
 (158,'GBP3.bApr07','chr1','-',89245062,89261110,89245994,89252701,11,0x38393234353036322C38393234373231372C38393234373636322C38393234393137342C38393235303031372C38393235313435352C38393235323335332C38393235323637352C38393235333535372C38393235383830322C38393236303935342C,0x38393234363132332C38393234373431312C38393234373736352C38393234393338372C38393235303239382C38393235313639382C38393235323535302C38393235323932372C38393235333638352C38393235393031342C38393236313131302C),
 (158,'GBP3.gApr07','chr1','-',89252372,89261136,89252372,89253638,4,0x38393235323337322C38393235323831372C38393235333535372C38393236303935342C,0x38393235323535302C38393235323932372C38393235333638352C38393236313133362C),
 (158,'GBP3.kApr07','chr1','-',89252881,89261164,0,0,5,0x38393235323838312C38393235333535372C38393235383339362C38393235383830322C38393236303935342C,0x38393235323932372C38393235333638352C38393235383438322C38393235393031342C38393236313136342C),
 (158,'GBP3.hApr07','chr1','-',89253590,89261127,89253591,89258992,4,0x38393235333539302C38393235383430302C38393235383830322C38393236303935342C,0x38393235333638352C38393235383438322C38393235393031342C38393236313132372C),
 (158,'GBP3.iApr07','chr1','-',89258570,89261021,89258701,89258992,2,0x38393235383537302C38393236303935342C,0x38393235393031342C38393236313032312C),
 (158,'GBP7andGBP2.aApr07','chr1','-',89370021,89414310,89370419,89410206,11,0x38393337303032312C38393337313532382C38393337393831362C38393338353833372C38393338373536322C38393338383630302C38393339303533382C38393339303933382C38393430333030312C38393431303031362C38393431343139312C,0x38393337303637342C38393337313732322C38393337393931392C38393338363035302C38393338373834332C38393338383834362C38393339303733352C38393339313034382C38393430333132392C38393431303232352C38393431343331302C),
 (158,'LOC729936.bApr07','chr1','+',89645696,89659794,89658384,89659725,5,0x38393634353639362C38393634383434362C38393635383333372C38393635393232372C38393635393630312C,0x38393634353930352C38393634383635352C38393635383436352C38393635393333372C38393635393739342C),
 (158,'LOC729936.eApr07','chr1','+',89645719,89660056,89658384,89659350,4,0x38393634353731392C38393634383434362C38393635383333372C38393635393232372C,0x38393634353930352C38393634383635352C38393635383436352C38393636303035362C),
 (158,'LOC729936.hApr07','chr1','+',89645831,89662486,0,0,5,0x38393634353833312C38393634383434362C38393635383333372C38393635393232372C38393636323430342C,0x38393634353930352C38393634383635352C38393635383436352C38393635393336372C38393636323438362C),
 (158,'LOC729936.aApr07','chr1','+',89648604,89659784,89648606,89659649,4,0x38393634383630342C38393635383333372C38393635393232372C38393635393631322C,0x38393634383635352C38393635383436352C38393635393333372C38393635393738342C),
 (158,'LRRC8B.kApr07','chr1','+',89762373,89820934,0,0,6,0x38393736323337332C38393738383036312C38393830363339332C38393830363538352C38393831373733372C38393832303737312C,0x38393736323733342C38393738383131382C38393830363435342C38393830363634302C38393831373833352C38393832303933342C),
 (158,'LRRC8B.aApr07','chr1','+',89762971,89831459,89820797,89831190,4,0x38393736323937312C38393831373733372C38393832303737312C38393833303931372C,0x38393736333136392C38393831373833352C38393832323933362C38393833313435392C),
 (158,'LRRC8B.fApr07','chr1','+',89762977,89821034,89762978,89806626,6,0x38393736323937372C38393736353130382C38393830363339332C38393830363538352C38393831373733372C38393832303737312C,0x38393736333136392C38393736353133332C38393830363435342C38393830363634302C38393831373833352C38393832313033342C),
 (158,'LRRC8B.hApr07','chr1','+',89763016,89817770,89763017,89796926,7,0x38393736333031362C38393736353130382C38393738383036312C38393739363835372C38393830363339332C38393830363538352C38393831373733372C,0x38393736333136392C38393736353133332C38393738383131382C38393739373138332C38393830363435342C38393830363634302C38393831373737302C),
 (158,'LRRC8B.gApr07','chr1','+',89763017,89821139,89763019,89806626,6,0x38393736333031372C38393738383036312C38393830363339332C38393830363538352C38393831373733372C38393832303737312C,0x38393736333136392C38393738383131382C38393830363435342C38393830363634302C38393831373833352C38393832313133392C),
 (158,'LRRC8B.cApr07','chr1','+',89763025,89831525,89820797,89831190,8,0x38393736333032352C38393736353130382C38393738383036312C38393830363339332C38393830363538352C38393831373733372C38393832303737312C38393833303931372C,0x38393736333136392C38393736353133332C38393738383131382C38393830363435342C38393830363634302C38393831373833352C38393832323933362C38393833313532352C),
 (158,'LRRC8B.lApr07','chr1','+',89763028,89821203,0,0,5,0x38393736333032382C38393830363339332C38393830363538352C38393831373733372C38393832303737312C,0x38393736333136392C38393830363435342C38393830363634302C38393831373833352C38393832313230332C),
 (158,'LRRC8B.dApr07','chr1','+',89763044,89835446,89820797,89831190,8,0x38393736333034342C38393738383036312C38393739363835372C38393830363339332C38393830363538352C38393831373733372C38393832303737312C38393833303931372C,0x38393736333136392C38393738383131382C38393739373138332C38393830363435342C38393830363634302C38393831373833352C38393832323933362C38393833353434362C),
 (158,'LRRC8CandLRRC8D.gApr07','chr1','+',89871218,90002649,0,0,4,0x38393837313231382C38393932343631362C38393939373030332C39303030303134392C,0x38393837313436392C38393932343735382C38393939373038372C39303030323634392C),
 (158,'LRRC8CandLRRC8D.cApr07','chr1','+',89871240,89957682,89924620,89953129,3,0x38393837313234302C38393932343631362C38393935303835352C,0x38393837313436392C38393932343735382C38393935373638322C),
 (158,'LRRC8CandLRRC8D.nApr07','chr1','+',89871287,90171395,0,0,4,0x38393837313238372C38393932343631362C39303038313738342C39303137313231332C,0x38393837313436392C38393932343735382C39303038313932392C39303137313339352C),
 (158,'LRRC8CandLRRC8D.fApr07','chr1','+',89871327,89946795,89924685,89946793,4,0x38393837313332372C38393932343631362C38393934343434382C38393934363637342C,0x38393837313436392C38393932343735382C38393934343534372C38393934363739352C),
 (159,'roseyo.aApr07','chr1','-',90438631,90658240,0,0,5,0x39303433383633312C39303434363238352C39303531393736372C39303633383930342C39303635383132322C,0x39303433393230322C39303434363338392C39303531393939352C39303633393032332C39303635383234302C),
 (160,'stymawbo.aApr07','chr1','+',91330945,91363601,0,0,2,0x39313333303934352C39313336333332302C,0x39313333303937352C39313336333630312C),
 (160,'HFM1.aApr07','chr1','-',91498907,91643015,91499434,91639227,39,0x39313439383930372C39313530303338352C39313530303632352C39313530343136312C39313530353838392C39313531313835362C39313531323837342C39313531343737322C39313531353132362C39313535313439332C39313535323130312C39313535333935392C39313535343234352C39313535343533352C39313535373232322C39313535373433372C39313536313039342C39313536313233372C39313536323831392C39313538313537342C39313538353537332C39313538383838322C39313538393639332C39313539303635302C39313539313139352C39313539313430302C39313631333530322C39313631333637312C39313631363136392C39313631363534372C39313631373230372C39313631383234382C39313631393035362C39313632333333312C39313632333731392C39313633323233372C39313633343433372C39313633393135362C39313634323934322C,0x39313439393530342C39313530303533372C39313530303733372C39313530343235322C39313530363030302C39313531313936302C39313531323935342C39313531343838382C39313531353230372C39313535313634302C39313535323230352C39313535343131372C39313535343332392C39313535343632312C39313535373335342C39313535373533352C39313536313134322C39313536313334342C39313536323931312C39313538313635352C39313538353632312C39313538393031362C39313538393738382C39313539303739362C39313539313239372C39313539313434342C39313631333539312C39313631333837322C39313631363332382C39313631363632352C39313631373335392C39313631383338312C39313631393132372C39313632333337392C39313632333937392C39313633323534372C39313633343535302C39313633393235342C39313634333031352C),
 (160,'HFM1.gApr07','chr1','-',91613671,91639237,91613671,91639214,5,0x39313631333637312C39313631363136392C39313631363534372C39313631373230372C39313633393135362C,0x39313631333837322C39313631363332382C39313631363632352C39313631373335392C39313633393233372C),
 (160,'HFM1.fApr07','chr1','-',91615587,91642953,91616611,91639227,11,0x39313631353538372C39313631363534372C39313631373230332C39313631383234382C39313631393035362C39313632333333312C39313632333731392C39313633323233372C39313633343433372C39313633393135362C39313634323934322C,0x39313631363332382C39313631363632352C39313631373335392C39313631383338312C39313631393132372C39313632333337392C39313632333937392C39313633323534372C39313633343535302C39313633393235342C39313634323935332C),
 (160,'HFM1.eApr07','chr1','-',91615903,91642953,91616148,91642951,11,0x39313631353930332C39313631363534372C39313631373230372C39313631383234382C39313631393035362C39313632333333312C39313632333731392C39313633323233372C39313633343433372C39313633393135362C39313634323934322C,0x39313631363332382C39313631363632352C39313631373335392C39313631383338312C39313631393132372C39313632333337392C39313632333937392C39313633323534372C39313633343535302C39313633393235342C39313634323935332C),
 (160,'HFM1.iApr07','chr1','-',91618312,91642968,91618312,91639227,6,0x39313631383331322C39313631393035362C39313632333333312C39313632333731392C39313633393135362C39313634323934322C,0x39313631383338312C39313631393132372C39313632333337392C39313632333937392C39313633393235342C39313634323936382C),
 (160,'CDC7.cApr07','chr1','+',91738959,91758424,91739861,91758423,10,0x39313733383935392C39313733393739382C39313734353939382C39313734363430362C39313734393734312C39313734393932352C39313735313230322C39313735323936332C39313735333933382C39313735383237342C,0x39313733393032322C39313733393937362C39313734363038322C39313734363534322C39313734393833352C39313735303036382C39313735313435322C39313735333134322C39313735343032312C39313735383432342C),
 (160,'CDC7.bApr07','chr1','+',91738993,91763909,91739861,91762580,12,0x39313733383939332C39313733393739382C39313734353939382C39313734363430362C39313734393734312C39313734393932352C39313735313230322C39313735323039322C39313735323936332C39313735333933382C39313735383237342C39313736323138352C,0x39313733393039332C39313733393937362C39313734363038322C39313734363534322C39313734393833352C39313735303036382C39313735313435322C39313735323138382C39313735333134322C39313735343032312C39313735383432342C39313736333930392C),
 (160,'CDC7.dApr07','chr1','+',91738994,91763907,91739861,91751539,9,0x39313733383939342C39313734353939382C39313734363430362C39313734393734312C39313734393932352C39313735313230322C39313735333933382C39313735383237342C39313736323138352C,0x39313733393937362C39313734363038322C39313734363534322C39313734393833352C39313735303036382C39313735333134322C39313735343032312C39313735383432342C39313736333930372C),
 (160,'CDC7.aApr07','chr1','+',91739014,91763907,91739861,91762580,12,0x39313733393031342C39313733393833322C39313734353939382C39313734363430362C39313734393734312C39313734393932352C39313735313230322C39313735323039322C39313735323936332C39313735333933382C39313735383237342C39313736323138352C,0x39313733393039332C39313733393937362C39313734363038322C39313734363534322C39313734393833352C39313735303036382C39313735313435322C39313735323138382C39313735333134322C39313735343032312C39313735383432342C39313736333930372C),
 (160,'HSP90B3P.aApr07','chr1','+',91873155,91882488,91873155,91881923,3,0x39313837333135352C39313838303530392C39313838303931382C,0x39313837333233332C39313838303738382C39313838323438382C),
 (160,'TGFBR3.aApr07','chr1','-',91918487,92124423,91921883,92099676,17,0x39313931383438372C39313933333831362C39313933363233332C39313934363830372C39313935303338372C39313935343338302C39313935343731322C39313935373435362C39313935383033372C39313936303039392C39313936353830332C39313936373934392C39313937323932302C39313939363735372C39323033353433312C39323039393631352C39323132343032322C,0x39313932323030322C39313933333932342C39313933363237352C39313934363932382C39313935303638372C39313935343533392C39313935343835332C39313935373630392C39313935383337352C39313936303238392C39313936353935312C39313936383131382C39313937333130342C39313939363839352C39323033353631362C39323039393738392C39323132343432332C),
 (160,'TGFBR3.bApr07','chr1','-',91920570,92144479,91921883,92099676,18,0x39313932303537302C39313933333831362C39313933363233332C39313934363830372C39313935303338372C39313935343338302C39313935343731322C39313935373435362C39313935383033372C39313936303039392C39313936353830332C39313936373934392C39313937323932302C39313939363735372C39323033353433312C39323039393631352C39323133373738312C39323134333937302C,0x39313932323030322C39313933333932342C39313933363237352C39313934363932382C39313935303638372C39313935343533392C39313935343835332C39313935373630392C39313935383337322C39313936303238392C39313936353935312C39313936383131382C39313937333130342C39313939363839352C39323033353631362C39323039393738392C39323133373834322C39323134343437392C);
INSERT INTO `aceview_hg18_housekeeping` (`bin`,`name`,`chrom`,`strand`,`txStart`,`txEnd`,`cdsStart`,`cdsEnd`,`exonCount`,`exonStarts`,`exonEnds`) VALUES 
 (160,'TGFBR3.cApr07','chr1','-',91921873,92124202,91921883,92099676,17,0x39313932313837332C39313933333831362C39313933363233332C39313934363830372C39313935303338372C39313935343338302C39313935343731322C39313935373435362C39313935383033372C39313936303039392C39313936353830332C39313936373934392C39313937323932302C39313939363735372C39323033353433312C39323039393631352C39323132343032322C,0x39313932323030322C39313933333932342C39313933363237352C39313934363932382C39313935303638372C39313935343533392C39313935343835332C39313935373630392C39313935383337322C39313936303238392C39313936353935312C39313936383131382C39313937333130342C39313939363839352C39323033353631362C39323039393738392C39323132343230322C),
 (160,'TGFBR3.jApr07','chr1','-',91973081,92036487,91973083,92035551,4,0x39313937333038312C39313939363735372C39323033353433312C39323033363333322C,0x39313937333130342C39313939363839352C39323033353631362C39323033363438372C),
 (160,'TGFBR3.fApr07','chr1','-',91996342,92124295,91996745,92099676,4,0x39313939363334322C39323033353433312C39323039393631352C39323132343137342C,0x39313939363839352C39323033353631362C39323039393738392C39323132343239352C),
 (161,'KIAA1107.aApr07','chr1','+',92405196,92422871,92405198,92422475,9,0x39323430353139362C39323430353939322C39323430373031302C39323430393534332C39323431343937332C39323431353935352C39323431363435362C39323431383430392C39323432323030382C,0x39323430353238352C39323430363133302C39323430373134302C39323430393630352C39323431353639312C39323431363034332C39323431363539362C39323432303734302C39323432323837312C),
 (161,'GLMN.aApr07','chr1','-',92483374,92537153,92484674,92536144,19,0x39323438333337342C39323438353230362C39323438363032322C39323530313030372C39323530313736372C39323530323639382C39323530343536332C39323530343834342C39323530363035372C39323530363234392C39323530373836372C39323530393630392C39323532343633342C39323532373035382C39323532383334322C39323532393536322C39323533353534382C39323533363130352C39323533373036392C,0x39323438343739312C39323438353238392C39323438363133342C39323530313037312C39323530313837372C39323530323738332C39323530343633372C39323530343838362C39323530363134372C39323530363238302C39323530373932312C39323530393739372C39323532343733372C39323532373239362C39323532383435312C39323532393638322C39323533353637342C39323533363137342C39323533373135332C),
 (161,'GLMN.dApr07','chr1','-',92484630,92537131,92484674,92527189,12,0x39323438343633302C39323438353230362C39323438363032322C39323530313030372C39323530313736372C39323530323639382C39323532373035382C39323532383334322C39323532393536322C39323533353534382C39323533363130352C39323533373036392C,0x39323438343739312C39323438353238392C39323438363133342C39323530313037312C39323530313837372C39323530323737392C39323532373239362C39323532383437352C39323532393638322C39323533353637342C39323533363137342C39323533373133312C),
 (161,'GLMN.cApr07','chr1','-',92484634,92537131,92501837,92536144,18,0x39323438343633342C39323438353230362C39323438363032322C39323530313030372C39323530313736372C39323530343536332C39323530343834342C39323530363035372C39323530363234392C39323530373836372C39323530393630392C39323532343633342C39323532373035382C39323532383334322C39323532393536322C39323533353534382C39323533363130352C39323533373036392C,0x39323438343739312C39323438353238392C39323438363133342C39323530313037312C39323530313837372C39323530343633372C39323530343838362C39323530363134372C39323530363238302C39323530373932312C39323530393739372C39323532343733372C39323532373239362C39323532383435312C39323532393638322C39323533353637342C39323533363137342C39323533373133312C),
 (161,'GLMN.bApr07','chr1','-',92484669,92537111,92484674,92536144,18,0x39323438343636392C39323438353230362C39323438363032322C39323530313030372C39323530313736372C39323530323639382C39323530343536332C39323530363035372C39323530363234392C39323530373836372C39323530393630392C39323532343633342C39323532373035382C39323532383334322C39323532393536322C39323533353534382C39323533363130352C39323533373036392C,0x39323438343739312C39323438353238392C39323438363133342C39323530313037312C39323530313837372C39323530323738332C39323530343633372C39323530363134372C39323530363238302C39323530373932312C39323530393739372C39323532343733372C39323532373239362C39323532383435312C39323532393638322C39323533353637342C39323533363137342C39323533373131312C),
 (161,'GLMN.jApr07','chr1','-',92529595,92537118,92532087,92536144,5,0x39323532393539352C39323533323036342C39323533353534382C39323533363130352C39323533373036392C,0x39323532393638322C39323533323132392C39323533353637342C39323533363137342C39323533373131382C),
 (161,'GLMN.fApr07','chr1','-',92534873,92537131,92535431,92536144,3,0x39323533343837332C39323533363130352C39323533373036392C,0x39323533353637342C39323533363137342C39323533373133312C),
 (161,'GLMN.mApr07','chr1','-',92535277,92537131,0,0,2,0x39323533353237372C39323533373036392C,0x39323533363137342C39323533373133312C),
 (161,'EVI5.aApr07','chr1','-',92746840,93030550,92751800,93030548,18,0x39323734363834302C39323830313738362C39323834333435312C39323834353732352C39323836323332302C39323836333933382C39323837343334362C39323930343038332C39323931353330322C39323933313934362C39323933323434332C39323933333435342C39323933363030342C39323934303238352C39323934313533392C39323934323639392C39323937343534322C39333033303438382C,0x39323735323131352C39323830313838322C39323834333534372C39323834353837322C39323836323437392C39323836343037392C39323837343438312C39323930343133372C39323931353336332C39323933323034342C39323933323533332C39323933333539382C39323933363133302C39323934303336302C39323934313736342C39323934323838392C39323937343737322C39333033303535302C),
 (161,'EVI5.cApr07','chr1','-',92750066,92932493,92860437,92932491,15,0x39323735303036362C39323737343138312C39323830313738362C39323834333435312C39323834353732352C39323836303339352C39323836323332302C39323836333933382C39323837343334362C39323930303836332C39323930313536342C39323930343038332C39323931353330322C39323933313934362C39323933323434332C,0x39323735323131352C39323737343139312C39323830313838322C39323834333534372C39323834353837322C39323836303438352C39323836323437392C39323836343037392C39323837343438312C39323930313031302C39323930313539372C39323930343133372C39323931353336332C39323933323034342C39323933323439332C),
 (161,'EVI5.bApr07','chr1','-',92929547,93030550,92935986,93030548,6,0x39323932393534372C39323934303238352C39323934313533392C39323934323639392C39323937343534322C39333033303438382C,0x39323933363133302C39323934303336302C39323934313736342C39323934323838392C39323937343737322C39333033303535302C),
 (161,'FAM69A.cApr07','chr1','-',93070660,93199604,93071164,93199574,5,0x39333037303636302C39333038353332372C39333038383939322C39333131343434302C39333139393532302C,0x39333037313137392C39333038353530342C39333038393130302C39333131343537352C39333139393630342C),
 (161,'FAM69A.aApr07','chr1','-',93078003,93199810,93081527,93199769,5,0x39333037383030332C39333038353332372C39333038383939322C39333131343434302C39333139393532302C,0x39333038323334302C39333038353530342C39333038393130302C39333131343537352C39333139393831302C),
 (161,'FAM69A.bApr07','chr1','-',93080364,93199603,93081527,93199601,4,0x39333038303336342C39333038383939322C39333131343434302C39333139393532302C,0x39333038323334302C39333038393130302C39333131343537352C39333139393630332C),
 (162,'CCDC18.aApr07','chr1','+',93418507,93516858,93418675,93516622,28,0x39333431383530372C39333432313530342C39333432323132322C39333432343438392C39333433303134342C39333433313736302C39333434303033362C39333434333635342C39333434353235312C39333434383934362C39333435303234352C39333435323838372C39333435343738302C39333435353838322C39333435393735332C39333436303030332C39333436343437372C39333437303537302C39333437343339322C39333437373435342C39333437373832372C39333438343234392C39333438343938322C39333439323631352C39333439343437392C39333439363839322C39333530323834352C39333531363630372C,0x39333431393032372C39333432313634302C39333432323239312C39333432343634382C39333433303235312C39333433313838392C39333434303133332C39333434333737362C39333434353534332C39333434393037312C39333435303430362C39333435333131312C39333435343839312C39333435363031342C39333435393838382C39333436303038312C39333436343539342C39333437303733382C39333437343533352C39333437373631382C39333437383034312C39333438343334392C39333438353039392C39333439323735392C39333439343638332C39333439373033302C39333530333034362C39333531363835382C),
 (162,'CCDC18.bApr07','chr1','+',93418907,93485045,93421604,93485045,21,0x39333431383930372C39333432313530342C39333432343438392C39333433303134342C39333433313736302C39333434303033362C39333434333635342C39333434353235312C39333434383934362C39333435303234352C39333435323838372C39333435343738302C39333435393735332C39333436303030332C39333436343437372C39333437303537302C39333437343339322C39333437373435342C39333437373832372C39333438343234392C39333438343938322C,0x39333431383939372C39333432313634302C39333432343634382C39333433303235312C39333433313838392C39333434303133332C39333434333737362C39333434353534332C39333434393037312C39333435303430362C39333435333131312C39333435343839312C39333435393838382C39333436303038312C39333436343539342C39333437303733382C39333437343533352C39333437373631382C39333437383034312C39333438343334392C39333438353034352C),
 (162,'DR1.aApr07','chr1','+',93583680,93599545,93584790,93598784,4,0x39333538333638302C39333538343435372C39333539323035322C39333539383633372C,0x39333538343333332C39333538353031302C39333539323231362C39333539393534352C),
 (162,'DR1.bApr07','chr1','+',93584023,93600745,93584790,93598784,3,0x39333538343032332C39333539323035322C39333539383633372C,0x39333538353031302C39333539323231362C39333630303734352C),
 (162,'FNBP1L.bApr07','chr1','+',93686275,93792909,93686426,93790561,15,0x39333638363237352C39333733373631322C39333736303232362C39333736313438382C39333736323430352C39333736373739362C39333736383839392C39333737313036362C39333737323834392C39333738323235312C39333738343938362C39333738353439312C39333738373432322C39333738393039312C39333739303535332C,0x39333638363435302C39333733373732382C39333736303238302C39333736313633362C39333736323436382C39333736373930312C39333736393032382C39333737313231332C39333737333035332C39333738323336312C39333738353131392C39333738353538362C39333738373537312C39333738393235302C39333739323930392C),
 (162,'FNBP1L.aApr07','chr1','+',93686426,93792875,93686426,93789270,14,0x39333638363432362C39333733373631322C39333736303232362C39333736313438382C39333736323430352C39333736373739362C39333736383839392C39333737313036362C39333737323834392C39333738323235312C39333738343938362C39333738353439312C39333738373432322C39333738393039312C,0x39333638363435302C39333733373732382C39333736303238302C39333736313633362C39333736323436382C39333736373930312C39333736393032382C39333737313231332C39333737333035332C39333738323336312C39333738353131392C39333738353538362C39333738373537312C39333739323837352C),
 (162,'BCAR3.cApr07','chr1','-',93799885,93919981,93800385,93913074,12,0x39333739393838352C39333830353432332C39333830353838342C39333830393831342C39333831343135382C39333832303434352C39333832323136322C39333832373132312C39333833303430392C39333838303434372C39333931323735372C39333931393734312C,0x39333830303536342C39333830353633362C39333830353939362C39333830393938362C39333831343237342C39333832313039382C39333832323236362C39333832373536342C39333833303533382C39333838303438372C39333931333038352C39333931393938312C),
 (162,'BCAR3.dApr07','chr1','-',93799892,93852289,93800385,93852075,10,0x39333739393839322C39333830353432332C39333830353838342C39333830393831342C39333831343135382C39333832303434352C39333832323136322C39333832373132312C39333833303430392C39333835313939312C,0x39333830303536342C39333830353633362C39333830353939362C39333830393938362C39333831343237342C39333832313039382C39333832323236362C39333832373536342C39333833303533382C39333835323238392C),
 (162,'BCAR3.aApr07','chr1','-',93799930,93919513,93800385,93919446,12,0x39333739393933302C39333830353432332C39333830353838342C39333830393831342C39333831343135382C39333832303434352C39333832323136322C39333832373132312C39333833303430392C39333838303434372C39333931323735372C39333931393235302C,0x39333830303536342C39333830353633362C39333830353939362C39333830393938362C39333831343237342C39333832313039382C39333832323236362C39333832373536342C39333833303533382C39333838303438372C39333931333038352C39333931393531332C),
 (162,'BCAR3.bApr07','chr1','-',93799938,94085382,93800385,93913074,14,0x39333739393933382C39333830353432332C39333830353838342C39333830393831342C39333831343135382C39333832303434352C39333832323136322C39333832373132312C39333833303430392C39333838303434372C39333931323735372C39333934343233352C39343038333731302C39343038353231332C,0x39333830303536342C39333830353633362C39333830353939362C39333830393938362C39333831343237342C39333832313039382C39333832323236362C39333832373536342C39333833303533382C39333838303438372C39333931333038352C39333934343238362C39343038333835362C39343038353338322C),
 (162,'BCAR3.hApr07','chr1','-',93827213,93919883,93827213,93913074,4,0x39333832373231332C39333838303434372C39333931323735372C39333931393734312C,0x39333832373536342C39333838303438372C39333931333038352C39333931393838332C),
 (162,'BCAR3.qApr07','chr1','-',93827227,93856934,93828514,93852075,5,0x39333832373232372C39333832383339332C39333833303430392C39333835313939312C39333835363836352C,0x39333832373536342C39333832383532332C39333833303533382C39333835323130392C39333835363933342C),
 (162,'BCAR3.fApr07','chr1','-',93827559,93919509,93827561,93919507,5,0x39333832373535392C39333833303430392C39333838303434372C39333931323735372C39333931393236332C,0x39333832373536342C39333833303533382C39333838303438372C39333931333038352C39333931393530392C),
 (162,'BCAR3.pApr07','chr1','-',93830450,93886966,93880449,93886966,4,0x39333833303435302C39333838303434372C39333838343632302C39333838363837312C,0x39333833303533382C39333838303438372C39333838343731382C39333838363936362C),
 (162,'BCAR3.kApr07','chr1','-',93830470,93926376,93830472,93913074,4,0x39333833303437302C39333838303434372C39333931323735372C39333932363230382C,0x39333833303533382C39333838303438372C39333931333038352C39333932363337362C),
 (162,'BCAR3.veApr07','chr1','-',93912775,94085327,0,0,3,0x39333931323737352C39343038333731302C39343038353231332C,0x39333931333038352C39343038333835362C39343038353332372C),
 (162,'BCAR3.tApr07','chr1','-',93912982,94084117,93913079,94083803,3,0x39333931323938322C39333934343233352C39343038333731302C,0x39333931333038352C39333934343238362C39343038343131372C),
 (162,'BCAR3.vbApr07','chr1','-',93958332,94085362,0,0,4,0x39333935383333322C39333936313434322C39343038333731302C39343038353039362C,0x39333935383433382C39333936313638332C39343038333835362C39343038353336322C),
 (162,'DNTTIP2.aApr07','chr1','-',94107473,94117350,94107994,94117292,7,0x39343130373437332C39343130383832362C39343131303231352C39343131313236322C39343131333738382C39343131343431312C39343131373232302C,0x39343130383038382C39343130383933362C39343131303338302C39343131313335382C39343131333932372C39343131363030362C39343131373335302C),
 (162,'DNTTIP2.fApr07','chr1','-',94107921,94111513,94107994,94110341,4,0x39343130373932312C39343130383832362C39343131303231352C39343131313236322C,0x39343130383038382C39343130383933362C39343131303338302C39343131313531332C),
 (162,'DNTTIP2.bApr07','chr1','-',94107921,94118061,94111532,94116745,8,0x39343130373932312C39343130383832362C39343131303231352C39343131313236322C39343131313437342C39343131333738382C39343131343431312C39343131363639312C,0x39343130383038382C39343130383933362C39343131303338302C39343131313335382C39343131313536322C39343131333932372C39343131363030362C39343131383036312C),
 (162,'ABCA4.aApr07','chr1','-',94230973,94359293,94231380,94359189,50,0x39343233303937332C39343233343235322C39343233363030342C39343233383937392C39343233393134352C39343234303030312C39343234333538342C39343234353737372C39343234363337382C39343234363839342C39343234383934332C39343234393430352C39343235323638362C39343235333838322C39343235373732352C39343235393338332C39343235393738332C39343235393938392C39343236313532392C39343236333039372C39343236373538382C39343236383537312C39343236393133392C39343236393932312C39343237343838332C39343237353238382C39343237383138362C39343237393335322C39343238303930342C39343238313437392C39343238323735362C39343238353036322C39343238373031312C39343238393737362C39343239333235342C39343239343734342C39343239383638302C39343330303732302C39343330313235352C39343331353833332C39343331363733332C39343331373436352C39343331383632312C39343332313439352C39343333363933372C39343334313135382C39343334363732302C39343334393538312C39343335313131362C39343335393132332C,0x39343233313338362C39343233343333392C39343233363235342C39343233393037322C39343233393234392C39343234303133362C39343234333732362C39343234353838342C39343234363434312C39343234373031352C39343234393037332C39343234393532392C39343235323833342C39343235333939382C39343235373930332C39343235393535332C39343235393835382C39343236303039352C39343236313536322C39343236333139322C39343236373737352C39343236383637302C39343236393236342C39343237303138372C39343237343933322C39343237353439342C39343237383237312C39343237393534362C39343238313034322C39343238313631392C39343238323838382C39343238353233372C39343238373130312C39343238393834322C39343239333435392C39343239343936362C39343239383930332C39343330303839372C39343330313436312C39343331363033312C39343331363835302C39343331373630352C39343331383836322C39343332313538352C39343333373133352C39343334313238362C39343334363836302C39343334393732332C39343335313231302C39343335393239332C),
 (163,'ARHGAP29.fApr07','chr1','-',94447000,94513211,94447002,94469755,5,0x39343434373030302C39343434373339372C39343435383430312C39343436393535302C39343531333135352C,0x39343434373034382C39343434373439342C39343435383533362C39343436393738372C39343531333231312C),
 (163,'ARHGAP29.jApr07','chr1','-',94469590,94513172,0,0,3,0x39343436393539302C39343530393130322C39343531333135352C,0x39343436393738372C39343530393338382C39343531333137322C),
 (163,'ARHGAP29.lApr07','chr1','-',94469736,94552652,0,0,4,0x39343436393733362C39343531383436372C39343534393830392C39343535323633332C,0x39343436393738372C39343531383534362C39343534393839342C39343535323635322C),
 (163,'charber.bApr07','chr1','+',94486001,94572724,0,0,4,0x39343438363030312C39343438373535362C39343537313435322C39343537323635352C,0x39343438363138332C39343438373636332C39343537313535332C39343537323732342C),
 (163,'yoseyo.aApr07','chr1','+',94837474,94926368,0,0,3,0x39343833373437342C39343837333933342C39343932363033362C,0x39343833373631382C39343837343032352C39343932363336382C),
 (163,'yunara.eApr07','chr1','-',94854497,94910202,0,0,3,0x39343835343439372C39343837363538302C39343931303131392C,0x39343835353231352C39343837363730322C39343931303230322C),
 (163,'yunara.jApr07','chr1','-',94862718,95058354,0,0,4,0x39343836323731382C39343837363538302C39343931373536382C39353035383039392C,0x39343836323735332C39343837363730322C39343931373735312C39353035383335342C),
 (163,'yunara.fApr07','chr1','-',94876597,95058240,0,0,5,0x39343837363539372C39343931373536382C39343937303430312C39343938303431322C39353035383039392C,0x39343837363730322C39343931373735312C39343937303538312C39343938303535382C39353035383234302C),
 (163,'yunara.aApr07','chr1','-',94895677,94970581,94895996,94970435,2,0x39343839353637372C39343937303430312C,0x39343839363139362C39343937303538312C),
 (163,'yunara.bApr07','chr1','-',94895677,95058628,94917743,94970466,5,0x39343839353637372C39343931373536382C39343934333538322C39343937303430312C39353035383039392C,0x39343839363139392C39343931373735312C39343934333730312C39343937303538312C39353035383632382C),
 (163,'yunara.gApr07','chr1','-',94895993,94980577,0,0,4,0x39343839353939332C39343931373536382C39343937303430312C39343938303431322C,0x39343839363139392C39343931373735312C39343937303538312C39343938303537372C),
 (163,'yunara.lApr07','chr1','-',94896068,94896394,0,0,2,0x39343839363036382C39343839363334392C,0x39343839363139392C39343839363339342C),
 (163,'yunara.cApr07','chr1','-',94911041,95058381,0,0,4,0x39343931313034312C39343931373536382C39343934333538322C39353035383039392C,0x39343931313431352C39343931373735312C39343934333730312C39353035383338312C),
 (163,'yunara.dApr07','chr1','-',94917669,95058363,0,0,6,0x39343931373636392C39343934333538322C39343937303430312C39343938303431322C39343938313938312C39353035383039392C,0x39343931373735312C39343934333730312C39343937303538312C39343938303535382C39343938323133372C39353035383336332C),
 (163,'CNN3.aApr07','chr1','-',95134834,95165422,95135885,95165038,7,0x39353133343833342C39353133373531342C39353133393831322C39353134303236342C39353134313236352C39353134313534362C39353136343938312C,0x39353133363232372C39353133373636312C39353133393932392C39353134303430322C39353134313333322C39353134313636382C39353136353432322C),
 (163,'CNN3.gApr07','chr1','-',95135352,95163951,0,0,5,0x39353133353335322C39353133353934372C39353134393330392C39353136333332372C39353136333737362C,0x39353133353531312C39353133363135392C39353134393535382C39353136333439312C39353136333935312C),
 (163,'CNN3.dApr07','chr1','-',95136090,95165280,95136092,95140357,6,0x39353133363039302C39353133373531342C39353133393831322C39353134303236342C39353134313236352C39353136343938312C,0x39353133363232372C39353133373636312C39353133393932392C39353134303430322C39353134313636382C39353136353238302C),
 (163,'CNN3.cApr07','chr1','-',95136197,95163945,95136197,95141602,7,0x39353133363139372C39353133373531342C39353133393831322C39353134303236342C39353134313236352C39353134313534362C39353136333737362C,0x39353133363232372C39353133373636312C39353133393932392C39353134303430322C39353134313333322C39353134313636382C39353136333934352C),
 (163,'CNN3.bApr07','chr1','-',95137590,95165278,95137592,95165278,5,0x39353133373539302C39353133393831322C39353134313236352C39353134313534362C39353136343938312C,0x39353133373636312C39353133393932392C39353134313333322C39353134313636382C39353136353237382C),
 (163,'LOC729970.dApr07','chr1','+',95165545,95305611,0,0,3,0x39353136353534352C39353137303031352C39353330353138372C,0x39353136363036352C39353137303132392C39353330353631312C),
 (163,'ALG14.aApr07','chr1','-',95220242,95311094,95221219,95311042,4,0x39353232303234322C39353236353237322C39353330333030392C39353331303930362C,0x39353232313435302C39353236353430342C39353330333136312C39353331313039342C),
 (163,'ALG14.eApr07','chr1','-',95221269,95311029,95279705,95311027,5,0x39353232313236392C39353236353237322C39353237393633362C39353330333030392C39353331303930362C,0x39353232313435302C39353236353430342C39353237393735362C39353330333136312C39353331313032392C),
 (163,'ALG14.jApr07','chr1','-',95221281,95303137,0,0,5,0x39353232313238312C39353236353237322C39353237333938392C39353237393633362C39353330333030392C,0x39353232313435302C39353236353430342C39353237343032362C39353237393735362C39353330333133372C),
 (163,'ALG14.bApr07','chr1','-',95221359,95311009,95221439,95310958,5,0x39353232313335392C39353236353237322C39353237333938392C39353330333030392C39353331303930362C,0x39353232313435302C39353236353430342C39353237343032362C39353330333136312C39353331313030392C),
 (163,'ALG14.hApr07','chr1','-',95273964,95311019,95279705,95311018,4,0x39353237333936342C39353237393633362C39353330333030392C39353331303930362C,0x39353237343032362C39353237393735362C39353330333136312C39353331313031392C),
 (164,'LOC729977.aApr07','chr1','-',95549071,95556407,95549163,95556360,2,0x39353534393037312C39353535363239312C,0x39353534393333372C39353535363430372C),
 (164,'rorda.aApr07','chr1','+',95748307,96020486,95748389,96015359,4,0x39353734383330372C39353737363732352C39363031353239302C39363032303331312C,0x39353734383530362C39353737363833362C39363031353532322C39363032303438362C),
 (164,'steyplo.cApr07','chr1','+',96176044,96261009,0,0,2,0x39363137363034342C39363236303637362C,0x39363137363138392C39363236313030392C),
 (165,'tomira.aApr07','chr1','-',96492212,96612268,96541678,96593380,6,0x39363439323231322C39363534313632372C39363534323431362C39363539313239372C39363539333336392C39363631323232352C,0x39363439333839342C39363534313730382C39363534323438322C39363539313337362C39363539333431312C39363631323236382C),
 (165,'PTBP2.bApr07','chr1','+',96959758,97053191,96960008,97051549,14,0x39363935393735382C39363936313730372C39363938393536382C39373030373834362C39373030383835312C39373031353732382C39373031353937392C39373032333230322C39373034323932382C39373034343536322C39373034353030392C39373035303835352C39373035313137322C39373035313431362C,0x39363936303031362C39363936313733382C39363938393634342C39373030383031392C39373030383939352C39373031353839332C39373031363039302C39373032333339382C39373034333038332C39373034343539362C39373034353130322C39373035313037322C39373035313235302C39373035333139312C),
 (165,'PTBP2.eApr07','chr1','+',96959809,97052934,97007887,97051549,13,0x39363935393830392C39363936313730372C39373030373834362C39373030383835312C39373031353732382C39373031353937392C39373032333230322C39373034323934332C39373034343536322C39373034353030392C39373035303835352C39373035313137322C39373035313431362C,0x39363936303031362C39363936313733382C39373030383031392C39373030383939352C39373031353839332C39373031363039302C39373032333339382C39373034333038332C39373034343539362C39373034353130322C39373035313037322C39373035313235302C39373035323933342C),
 (165,'PTBP2.aApr07','chr1','+',96959861,97052958,96959861,97051549,14,0x39363935393836312C39363936313730372C39363938393536382C39373030373834362C39373030383835312C39373031353732382C39373031353937392C39373032333230322C39373034323934332C39373034343536322C39373034353030392C39373035303835352C39373035313137322C39373035313431362C,0x39363936303031362C39363936313733382C39363938393634342C39373030383031392C39373030383939352C39373031353839332C39373031363039302C39373032333339382C39373034333038332C39373034343539362C39373034353130322C39373035313037322C39373035313235302C39373035323935382C),
 (165,'PTBP2.hApr07','chr1','+',96959909,97012106,96959909,97009031,5,0x39363935393930392C39363936313730372C39363938393536382C39373030373834362C39373030383835312C,0x39363936303031362C39363936313733382C39363938393634342C39373030383031392C39373031323130362C),
 (165,'PTBP2.cApr07','chr1','+',96959953,97052931,96960008,97051549,14,0x39363935393935332C39363936313730372C39363938393536382C39373030373834362C39373030383835312C39373031353732382C39373031353937392C39373032333230322C39373034323932382C39373034343536322C39373034353030392C39373035303835352C39373035313137322C39373035313431392C,0x39363936303031362C39363936313733382C39363938393634342C39373030383031392C39373030383939352C39373031353839332C39373031363039302C39373032333339382C39373034333038332C39373034343539362C39373034353130322C39373035313037322C39373035313235302C39373035323933312C),
 (165,'PTBP2.dApr07','chr1','+',96959965,97052937,96960008,97051549,14,0x39363935393936352C39363936313730372C39363938393536382C39373030373834362C39373030383835312C39373031353732382C39373031353937392C39373032333230322C39373034323934332C39373034343536322C39373034353030392C39373035303835352C39373035313137322C39373035313431392C,0x39363936303031362C39363936313733382C39363938393634342C39373030383031392C39373030383939352C39373031353839332C39373031363039302C39373032333339382C39373034333038332C39373034343539362C39373034353130322C39373035313037322C39373035313235302C39373035323933372C),
 (165,'PTBP2.fApr07','chr1','+',96959982,97051766,96960008,97045036,13,0x39363935393938322C39363936313730372C39363938393536382C39373030373834362C39373030383835312C39373031353732382C39373031353937392C39373032333230322C39373034323934332C39373034353030392C39373035303835352C39373035313137322C39373035313431362C,0x39363936303031362C39363936313733382C39363938393634342C39373030383031392C39373030383939352C39373031353839332C39373031363039302C39373032333339382C39373034333038332C39373034353130322C39373035313037322C39373035313235302C39373035313736362C),
 (165,'PTBP2.mApr07','chr1','+',96960781,97008993,96989622,97008992,5,0x39363936303738312C39363936313730372C39363938393536382C39373030373834362C39373030383835312C,0x39363936303934312C39363936313733382C39363938393634342C39373030383031392C39373030383939332C),
 (166,'berplar.aApr07','chr1','-',97632297,97658779,97632537,97658547,2,0x39373633323239372C39373635383135302C,0x39373633323536332C39373635383737392C),
 (166,'DPYD.cApr07','chr1','-',97929350,98159150,97959031,98159066,8,0x39373932393335302C39373933373439342C39373935383936382C39373935393635332C39373937383533352C39383036363235372C39383132313430372C39383135393032372C,0x39373932393934322C39373933373639312C39373935393037302C39373935393831352C39373937383632332C39383036363334302C39383132313531382C39383135393135302C),
 (166,'DPYD.kApr07','chr1','-',97938332,98159140,97978575,98159066,5,0x39373933383333322C39373935393635332C39373937383533352C39383132313430372C39383135393032372C,0x39373933383434362C39373935393831352C39373937383632332C39383132313531382C39383135393134302C),
 (166,'DPYD.dApr07','chr1','-',97938369,98121579,97938371,98121512,5,0x39373933383336392C39373935393635332C39373937383533352C39383036363235372C39383132313430372C,0x39373933383434362C39373935393831352C39373937383632332C39383036363334302C39383132313537392C),
 (166,'DPYD.bApr07','chr1','-',97957896,98159193,97959031,98159192,6,0x39373935373839362C39373935393635332C39373937383533352C39383036363235372C39383132313430372C39383135393032372C,0x39373935393037302C39373935393831352C39373937383632332C39383036363334302C39383132313531382C39383135393139332C),
 (166,'DPYD.eApr07','chr1','-',97959581,98159143,97959632,98159066,5,0x39373935393538312C39373937383533352C39383036363235372C39383132313430372C39383135393032372C,0x39373935393831352C39373937383632332C39383036363334302C39383132313531382C39383135393134332C),
 (166,'DPYD.gApr07','chr1','-',97970273,98159168,97970557,98159066,5,0x39373937303237332C39373937383533352C39383036363235372C39383132313430372C39383135393032372C,0x39373937303631342C39373937383632332C39383036363334302C39383132313531382C39383135393136382C),
 (166,'DPYD.fApr07','chr1','-',97978385,98159168,97978433,98159066,4,0x39373937383338352C39383036363235372C39383132313430372C39383135393032372C,0x39373937383632332C39383036363334302C39383132313531382C39383135393136382C),
 (167,'SNX7.aApr07','chr1','+',98899800,98998644,98899800,98998275,9,0x39383839393830302C39383932333032382C39383932393231382C39383932393637382C39383933333636312C39383933363834392C39383933393936302C39383937363338302C39383939383139372C,0x39383930303035352C39383932333231312C39383932393332392C39383932393834332C39383933333836302C39383933373034392C39383934303034372C39383937363533332C39383939383634342C),
 (167,'SNX7.bApr07','chr1','+',98899881,98998642,98923040,98998275,9,0x39383839393838312C39383930303834302C39383932333032382C39383932393231382C39383932393637382C39383933333636312C39383933363834392C39383933393936302C39383939383139372C,0x39383930303035352C39383930303936302C39383932333231312C39383932393332392C39383932393834332C39383933333836302C39383933373034392C39383934303034372C39383939383634322C),
 (167,'SNX7.cApr07','chr1','+',98936920,98976505,98936920,98976503,2,0x39383933363932302C39383937363338302C,0x39383933373034392C39383937363530352C),
 (167,'PAP2D.bApr07','chr1','-',99128390,99243999,99131215,99243046,6,0x39393132383339302C39393135323934342C39393136303032352C39393139313231332C39393139343735322C39393234323537382C,0x39393133313234382C39393135333036342C39393136303230322C39393139313436342C39393139343838352C39393234333939392C),
 (167,'PAP2D.aApr07','chr1','-',99128390,99243545,99131215,99243046,6,0x39393132383339302C39393135323932392C39393136303032352C39393139313231332C39393139343735322C39393234323537382C,0x39393133313234382C39393135333036342C39393136303230322C39393139313436342C39393139343838352C39393234333534352C),
 (167,'smoyber.bApr07','chr1','+',99242420,99386996,99242780,99384969,3,0x39393234323432302C39393338323137392C39393338343931372C,0x39393234323738392C39393338323237342C39393338363939362C),
 (168,'snuber.aApr07','chr1','-',99710440,99772159,0,0,4,0x39393731303434302C39393731383235372C39393732353838372C39393737323133362C,0x39393731303739332C39393731383338312C39393732353934382C39393737323135392C),
 (168,'AGL.cApr07','chr1','+',100088227,100162167,100089186,100159795,34,0x3130303038383232372C3130303038393131382C3130303039393634362C3130303130303430302C3130303130323532392C3130303130383534332C3130303130383930312C3130303131323833302C3130303131333239372C3130303131333530312C3130303131343630312C3130303131353738342C3130303131383036362C3130303131383737352C3130303131393231392C3130303131393433352C3130303131393638342C3130303132323236332C3130303132323438322C3130303132323731322C3130303132363132312C3130303132393336332C3130303132393734392C3130303133303537352C3130303133343432392C3130303133383737392C3130303134303832362C3130303134383835352C3130303135303534382C3130303135313637302C3130303135333533322C3130303135343535332C3130303135343734312C3130303135393637372C,0x3130303038383535392C3130303038393236382C3130303039393835372C3130303130303536372C3130303130323733332C3130303130383732352C3130303130393031332C3130303131323935342C3130303131333430302C3130303131333539392C3130303131343734312C3130303131353937322C3130303131383139302C3130303131383933392C3130303131393332312C3130303131393539312C3130303131393833352C3130303132323338382C3130303132323539352C3130303132323834372C3130303132363235322C3130303132393530302C3130303132393838332C3130303133303735312C3130303133343533322C3130303133393030352C3130303134303933382C3130303134383939312C3130303135303636312C3130303135313838322C3130303135333633302C3130303135343634312C3130303135343837352C3130303136323136372C),
 (168,'AGL.aApr07','chr1','+',100088632,100162167,100089186,100159795,34,0x3130303038383633322C3130303038393137382C3130303039393634362C3130303130303430302C3130303130323532392C3130303130383534332C3130303130383930312C3130303131323833302C3130303131333239372C3130303131333530312C3130303131343630312C3130303131353738342C3130303131383036362C3130303131383737352C3130303131393231392C3130303131393433352C3130303131393638342C3130303132323236332C3130303132323438322C3130303132323731322C3130303132363132312C3130303132393336332C3130303132393734392C3130303133303537352C3130303133343432392C3130303133383737392C3130303134303832362C3130303134383835352C3130303135303534382C3130303135313637302C3130303135333533322C3130303135343535332C3130303135343734312C3130303135393637372C,0x3130303038383736322C3130303038393236382C3130303039393835372C3130303130303536372C3130303130323733332C3130303130383732352C3130303130393031332C3130303131323935342C3130303131333430302C3130303131333539392C3130303131343734312C3130303131353937322C3130303131383139302C3130303131383933392C3130303131393332312C3130303131393539312C3130303131393833352C3130303132323338382C3130303132323539352C3130303132323834372C3130303132363235322C3130303132393530302C3130303132393838332C3130303133303735312C3130303133343533322C3130303133393030352C3130303134303933382C3130303134383939312C3130303135303636312C3130303135313838322C3130303135333633302C3130303135343634312C3130303135343837352C3130303136323136372C),
 (168,'AGL.bApr07','chr1','+',100088632,100162167,100089186,100159795,34,0x3130303038383633322C3130303038393131382C3130303039393634362C3130303130303430302C3130303130323532392C3130303130383534332C3130303130383930312C3130303131323833302C3130303131333239372C3130303131333530312C3130303131343630312C3130303131353738342C3130303131383036362C3130303131383737352C3130303131393231392C3130303131393433352C3130303131393638342C3130303132323236332C3130303132323438322C3130303132323731322C3130303132363132312C3130303132393336332C3130303132393734392C3130303133303537352C3130303133343432392C3130303133383737392C3130303134303832362C3130303134383835352C3130303135303534382C3130303135313637302C3130303135333533322C3130303135343535332C3130303135343734312C3130303135393637372C,0x3130303038383736322C3130303038393236382C3130303039393835372C3130303130303536372C3130303130323733332C3130303130383732352C3130303130393031332C3130303131323935342C3130303131333430302C3130303131333539392C3130303131343734312C3130303131353937322C3130303131383139302C3130303131383933392C3130303131393332312C3130303131393539312C3130303131393833352C3130303132323338382C3130303132323539352C3130303132323834372C3130303132363235322C3130303132393530302C3130303132393838332C3130303133303735312C3130303133343533322C3130303133393030352C3130303134303933382C3130303134383939312C3130303135303636312C3130303135313838322C3130303135333633302C3130303135343634312C3130303135343837352C3130303136323136372C),
 (168,'AGL.dApr07','chr1','+',100088632,100162168,100089186,100159795,34,0x3130303038383633322C3130303038393131382C3130303039393634362C3130303130303430302C3130303130323532392C3130303130383534332C3130303130383930312C3130303131323833302C3130303131333239372C3130303131333530312C3130303131343630312C3130303131353738342C3130303131383036362C3130303131383737352C3130303131393231392C3130303131393433352C3130303131393638342C3130303132323236332C3130303132323438322C3130303132323731322C3130303132363132312C3130303132393336332C3130303132393734392C3130303133303537352C3130303133343432392C3130303133383737392C3130303134303832362C3130303134383835352C3130303135303534382C3130303135313637302C3130303135333533322C3130303135343535332C3130303135343734312C3130303135393637372C,0x3130303038393034322C3130303038393236382C3130303039393835372C3130303130303536372C3130303130323733332C3130303130383732352C3130303130393031332C3130303131323935342C3130303131333430302C3130303131333539392C3130303131343734312C3130303131353937322C3130303131383139302C3130303131383933392C3130303131393332312C3130303131393539312C3130303131393833352C3130303132323338382C3130303132323539352C3130303132323834372C3130303132363235322C3130303132393530302C3130303132393838332C3130303133303735312C3130303133343533322C3130303133393030352C3130303134303933382C3130303134383939312C3130303135303636312C3130303135313838322C3130303135333633302C3130303135343634312C3130303135343837352C3130303136323136382C),
 (168,'AGL.eApr07','chr1','+',100089118,100162167,100090813,100159795,34,0x3130303038393131382C3130303039303730342C3130303039393634362C3130303130303430302C3130303130323532392C3130303130383534332C3130303130383930312C3130303131323833302C3130303131333239372C3130303131333530312C3130303131343630312C3130303131353738342C3130303131383036362C3130303131383737352C3130303131393231392C3130303131393433352C3130303131393638342C3130303132323236332C3130303132323438322C3130303132323731322C3130303132363132312C3130303132393336332C3130303132393734392C3130303133303537352C3130303133343432392C3130303133383737392C3130303134303832362C3130303134383835352C3130303135303534382C3130303135313637302C3130303135333533322C3130303135343535332C3130303135343734312C3130303135393637372C,0x3130303038393236382C3130303039303834372C3130303039393835372C3130303130303536372C3130303130323733332C3130303130383732352C3130303130393031332C3130303131323935342C3130303131333430302C3130303131333539392C3130303131343734312C3130303131353937322C3130303131383139302C3130303131383933392C3130303131393332312C3130303131393539312C3130303131393833352C3130303132323338382C3130303132323539352C3130303132323834372C3130303132363235322C3130303132393530302C3130303132393838332C3130303133303735312C3130303133343533322C3130303133393030352C3130303134303933382C3130303134383939312C3130303135303636312C3130303135313838322C3130303135333633302C3130303135343634312C3130303135343837352C3130303136323136372C),
 (168,'AGL.fApr07','chr1','+',100099353,100162167,100099615,100159795,32,0x3130303039393335332C3130303130303430302C3130303130323532392C3130303130383534332C3130303130383930312C3130303131323833302C3130303131333239372C3130303131333530312C3130303131343630312C3130303131353738342C3130303131383036362C3130303131383737352C3130303131393231392C3130303131393433352C3130303131393638342C3130303132323236332C3130303132323438322C3130303132323731322C3130303132363132312C3130303132393336332C3130303132393734392C3130303133303537352C3130303133343432392C3130303133383737392C3130303134303832362C3130303134383835352C3130303135303534382C3130303135313637302C3130303135333533322C3130303135343535332C3130303135343734312C3130303135393637372C,0x3130303039393835372C3130303130303536372C3130303130323733332C3130303130383732352C3130303130393031332C3130303131323935342C3130303131333430302C3130303131333539392C3130303131343734312C3130303131353937322C3130303131383139302C3130303131383933392C3130303131393332312C3130303131393539312C3130303131393833352C3130303132323338382C3130303132323539352C3130303132323834372C3130303132363235322C3130303132393530302C3130303132393838332C3130303133303735312C3130303133343533322C3130303133393030352C3130303134303933382C3130303134383939312C3130303135303636312C3130303135313838322C3130303135333633302C3130303135343634312C3130303135343837352C3130303136323136372C),
 (168,'spyber.bApr07','chr1','-',100151319,100276073,0,0,5,0x3130303135313331392C3130303136323338312C3130303137383134382C3130303138333837382C3130303237353837332C,0x3130303135313336312C3130303136323532342C3130303137383231342C3130303138333934392C3130303237363037332C),
 (168,'spawber.aApr07-unspliced','chr1','+',100268292,100273781,0,0,1,0x3130303236383239322C,0x3130303237333738312C),
 (168,'LRRC39.aApr07','chr1','-',100386289,100416359,100387511,100406660,11,0x3130303338363238392C3130303338373530392C3130303339303532382C3130303339333139342C3130303339343331352C3130303339363337342C3130303339373430322C3130303339383630392C3130303430363534372C3130303431313437342C3130303431363236312C,0x3130303338373234312C3130303338373537392C3130303339303636382C3130303339333334372C3130303339343436312C3130303339363531312C3130303339373535392C3130303339383731352C3130303430363733382C3130303431313531342C3130303431363335392C),
 (168,'LRRC39.dApr07','chr1','-',100386591,100416397,100387185,100406660,10,0x3130303338363539312C3130303339303532382C3130303339333139342C3130303339343331352C3130303339363337342C3130303339373430322C3130303339383630392C3130303430363534372C3130303431313437342C3130303431363237382C,0x3130303338373234312C3130303339303636382C3130303339333334372C3130303339343436312C3130303339363531312C3130303339373535392C3130303339383731352C3130303430363733382C3130303431313531342C3130303431363339372C),
 (168,'LRRC39.cApr07','chr1','-',100386992,100416389,100387185,100406660,9,0x3130303338363939322C3130303339303532382C3130303339333139342C3130303339343331352C3130303339363337342C3130303339373430322C3130303339383630392C3130303430363534372C3130303431363237382C,0x3130303338373234312C3130303339303636382C3130303339333334372C3130303339343436312C3130303339363531312C3130303339373535392C3130303339383731352C3130303430363733382C3130303431363338392C),
 (168,'LRRC39.bApr07','chr1','-',100386994,100416418,100387185,100406660,10,0x3130303338363939342C3130303339303532382C3130303339333139342C3130303339343331352C3130303339363337342C3130303339373430322C3130303339383630392C3130303430363534372C3130303431313437342C3130303431363236312C,0x3130303338373234312C3130303339303636382C3130303339333334372C3130303339343436312C3130303339363531312C3130303339373535392C3130303339383731352C3130303430363733382C3130303431313531342C3130303431363431382C),
 (168,'LRRC39.eApr07','chr1','-',100395908,100416395,100396359,100406660,7,0x3130303339353930382C3130303339373430322C3130303339383630392C3130303430363534372C3130303430383133342C3130303431313437342C3130303431363237382C,0x3130303339363531312C3130303339373535392C3130303339383731352C3130303430363733382C3130303430383232322C3130303431313531342C3130303431363339352C),
 (168,'LRRC39.fApr07','chr1','-',100397469,100409726,100397469,100406660,4,0x3130303339373436392C3130303339383630392C3130303430363534372C3130303430393538382C,0x3130303339373535392C3130303339383731352C3130303430363733382C3130303430393732362C),
 (169,'sperroybo.aApr07','chr1','+',100882249,100942751,0,0,2,0x3130303838323234392C3130303934323432382C,0x3130303838323330302C3130303934323735312C),
 (169,'SLC30A7.aApr07','chr1','+',101134222,101217580,101134406,101213001,12,0x3130313133343232322C3130313133343731332C3130313134343939352C3130313134393230362C3130313135303235352C3130313135313830362C3130313135363232302C3130313135393834392C3130313139393937312C3130313230333931322C3130313231323935332C3130313231333336322C,0x3130313133343438362C3130313133343831352C3130313134353130392C3130313134393239342C3130313135303338322C3130313135313935302C3130313135363237312C3130313135393938352C3130313230303036322C3130313230343036322C3130313231333034362C3130313231373538302C),
 (169,'SLC30A7.cApr07','chr1','+',101134240,101234404,101134406,101213001,10,0x3130313133343234302C3130313133343731332C3130313134343939352C3130313134393230362C3130313135303235352C3130313135313830362C3130313230333935342C3130313231323935332C3130313233333631372C3130313233333738302C,0x3130313133343438362C3130313133343831352C3130313134353130392C3130313134393239342C3130313135303338322C3130313135313930312C3130313230343036322C3130313231333034362C3130313233333636332C3130313233343430342C),
 (169,'SLC30A7.bApr07','chr1','+',101134266,101219907,101134406,101213001,11,0x3130313133343236362C3130313133343731332C3130313134343939352C3130313134393230362C3130313135303235352C3130313135313830362C3130313135363232302C3130313135393834392C3130313139393937312C3130313230333931322C3130313231323935332C,0x3130313133343438362C3130313133343831352C3130313134353130392C3130313134393239342C3130313135303338322C3130313135313935302C3130313135363237312C3130313135393938352C3130313230303036322C3130313230343036322C3130313231393930372C),
 (169,'keyo.bApr07','chr1','+',101263995,101325412,0,0,9,0x3130313236333939352C3130313331303830332C3130313331333431392C3130313331353530362C3130313331383533322C3130313331393638342C3130313332313630332C3130313332333139352C3130313332343939352C,0x3130313236343230352C3130313331303937342C3130313331333836302C3130313331353635322C3130313331383735372C3130313331393837392C3130313332313731382C3130313332333330312C3130313332353431322C),
 (169,'keyo.gApr07','chr1','+',101264010,101325408,0,0,5,0x3130313236343031302C3130313331333533382C3130313331353530362C3130313332313630342C3130313332343939352C,0x3130313236343230352C3130313331333836302C3130313331353635322C3130313332313731382C3130313332353430382C),
 (169,'keyo.hApr07','chr1','+',101264015,101325331,0,0,7,0x3130313236343031352C3130313331303830332C3130313331333431392C3130313331353530362C3130313332313630342C3130313332333139352C3130313332343939352C,0x3130313236343230352C3130313331303937342C3130313331333532342C3130313331353635322C3130313332313731382C3130313332333330312C3130313332353333312C),
 (169,'keyo.dApr07','chr1','+',101264021,101325405,0,0,8,0x3130313236343032312C3130313331303830332C3130313331333431392C3130313331353530362C3130313331383533322C3130313332313630342C3130313332333139352C3130313332343939352C,0x3130313236343230352C3130313331303937342C3130313331333533382C3130313331353635322C3130313331383735372C3130313332313731382C3130313332333330312C3130313332353430352C),
 (169,'keyo.iApr07','chr1','+',101264038,101325335,0,0,4,0x3130313236343033382C3130313331303830332C3130313331333533382C3130313332343939352C,0x3130313236343230352C3130313331303937342C3130313331333836302C3130313332353333352C),
 (169,'keyo.eApr07','chr1','+',101264051,101319577,0,0,5,0x3130313236343035312C3130313331303830332C3130313331353530362C3130313331383533322C3130313331393033302C,0x3130313236343230352C3130313331303937342C3130313331353635322C3130313331383735372C3130313331393537372C),
 (169,'keyo.aApr07','chr1','+',101264061,101325405,101264062,101325032,2,0x3130313236343036312C3130313332343939352C,0x3130313236343230352C3130313332353430352C),
 (169,'keyo.kApr07','chr1','+',101295573,101325188,0,0,6,0x3130313239353537332C3130313331303830332C3130313331333431392C3130313331353530362C3130313332313630342C3130313332343939352C,0x3130313239353632332C3130313331303937342C3130313331333532342C3130313331353635322C3130313332313731382C3130313332353138382C),
 (169,'keyo.fApr07','chr1','+',101301754,101325409,0,0,7,0x3130313330313735342C3130313331303830332C3130313331333431392C3130313331353530362C3130313331383533322C3130313332313630342C3130313332343939352C,0x3130313330313738332C3130313331303937342C3130313331333533382C3130313331353635322C3130313331383735372C3130313332313731382C3130313332353430392C),
 (169,'keyo.lApr07','chr1','+',101310803,101321718,0,0,4,0x3130313331303830332C3130313331333533382C3130313331353530362C3130313332313630342C,0x3130313331303937342C3130313331333836302C3130313331353635322C3130313332313731382C),
 (169,'keyo.nApr07','chr1','+',101315633,101325405,0,0,2,0x3130313331353633332C3130313332343939352C,0x3130313331353635322C3130313332353430352C),
 (169,'barbey.bApr07','chr1','+',101561980,101615457,0,0,5,0x3130313536313938302C3130313538313938322C3130313538333930362C3130313538383139302C3130313631353430312C,0x3130313536323031392C3130313538323133392C3130313538333938392C3130313538383332392C3130313631353435372C),
 (170,'OLFM3.bApr07','chr1','-',102040714,102235375,102042381,102234960,6,0x3130323034303731342C3130323034343231392C3130323036333136392C3130323036383831352C3130323037353032322C3130323233343839312C,0x3130323034333035392C3130323034343332362C3130323036333338392C3130323036383937312C3130323037353136392C3130323233353337352C),
 (170,'OLFM3.hApr07','chr1','-',102041629,102235049,0,0,8,0x3130323034313632392C3130323034343231392C3130323035303535332C3130323036333136392C3130323036383831352C3130323037353032322C3130323230353636332C3130323233343839312C,0x3130323034333035392C3130323034343332362C3130323035313239302C3130323036333338392C3130323036383937312C3130323037353136392C3130323230353732342C3130323233353034392C),
 (170,'OLFM3.eApr07','chr1','-',102041629,102235049,102051234,102234960,7,0x3130323034313632392C3130323034343231392C3130323035303535332C3130323036333136392C3130323036383831352C3130323037353032322C3130323233343839312C,0x3130323034333035392C3130323034343332362C3130323035313239302C3130323036333338392C3130323036383937312C3130323037353136392C3130323233353034392C),
 (170,'OLFM3.cApr07','chr1','-',102041629,102235049,102042381,102068962,7,0x3130323034313632392C3130323034343231392C3130323036333136392C3130323036383831352C3130323037353032322C3130323230353636332C3130323233343839312C,0x3130323034333035392C3130323034343332362C3130323036333338392C3130323036383937312C3130323037353136392C3130323230353732342C3130323233353034392C),
 (170,'OLFM3.iApr07','chr1','-',102063272,102148298,0,0,5,0x3130323036333237322C3130323036383831352C3130323037353032322C3130323037353830332C3130323134383137392C,0x3130323036333338392C3130323036383937312C3130323037353136392C3130323037363034322C3130323134383239382C),
 (170,'OLFM3.fApr07','chr1','-',102075004,102235368,102075004,102234960,2,0x3130323037353030342C3130323233343839312C,0x3130323037353136392C3130323233353336382C),
 (170,'OLFM3.jApr07','chr1','-',102075148,102235012,0,0,3,0x3130323037353134382C3130323037353830332C3130323233343839312C,0x3130323037353136392C3130323037363034322C3130323233353031322C),
 (170,'loplu.aApr07','chr1','-',102396492,102631575,0,0,7,0x3130323339363439322C3130323534383431332C3130323632353334382C3130323632353530352C3130323632363637382C3130323632373633372C3130323633313535312C,0x3130323339363930332C3130323534383437322C3130323632353339352C3130323632353536352C3130323632363737332C3130323632373735342C3130323633313537352C),
 (171,'borbey.aApr07','chr1','-',103001465,103091986,0,0,7,0x3130333030313436352C3130333030343730302C3130333030353636362C3130333030353931382C3130333031313130312C3130333033373934372C3130333039313733352C,0x3130333030313634392C3130333030343830302C3130333030353737342C3130333030353934362C3130333031313233362C3130333033383037322C3130333039313938362C),
 (171,'COL11A1.cApr07','chr1','-',103114610,103346640,103116162,103346322,66,0x3130333131343631302C3130333131373832362C3130333131393834302C3130333132313334322C3130333132343935302C3130333132363732302C3130333132363836362C3130333132373030392C3130333132373539382C3130333132383539342C3130333133363236382C3130333133363830392C3130333133373038342C3130333135303330322C3130333135313738302C3130333135323439352C3130333135323834372C3130333135333737342C3130333135383435342C3130333135393636312C3130333136313437392C3130333137323539322C3130333137333230332C3130333137373137382C3130333137383437302C3130333138343939322C3130333230303030392C3130333230303331392C3130333230303739362C3130333230333633302C3130333230383336322C3130333231323937332C3130333231363835312C3130333231373030332C3130333231373230332C3130333231373532352C3130333232323238312C3130333232353737362C3130333232373636312C3130333233343030372C3130333233343133322C3130333233353232332C3130333233363435332C3130333234303036382C3130333234303537312C3130333234303839302C3130333234313335382C3130333234323538372C3130333234323735312C3130333234333938312C3130333234343231312C3130333234343430352C3130333234363630362C3130333235303535362C3130333235323635342C3130333235333831312C3130333235353936332C3130333235363936312C3130333235393835302C3130333236303838352C3130333236333636342C3130333236393235392C3130333331323736312C3130333331363830312C3130333332303934382C3130333334363231362C,0x3130333131363330392C3130333131383036302C3130333131393930392C3130333132313435352C3130333132353230302C3130333132363737342C3130333132363930322C3130333132373036332C3130333132373730362C3130333132383634382C3130333133363332322C3130333133363931372C3130333133373133382C3130333135303335362C3130333135313833342C3130333135323534392C3130333135323935352C3130333135333832382C3130333135383530382C3130333135393731352C3130333136313533332C3130333137323730302C3130333137333235372C3130333137373233322C3130333137383537382C3130333138353130302C3130333230303036332C3130333230303430392C3130333230303930342C3130333230333638342C3130333230383431362C3130333231333032372C3130333231363839362C3130333231373035372C3130333231373234382C3130333231373537392C3130333232323333352C3130333232353838342C3130333232373731352C3130333233343035322C3130333233343138362C3130333233353236382C3130333233363530372C3130333234303131332C3130333234303632352C3130333234303933352C3130333234313431322C3130333234323633322C3130333234323830352C3130333234343033352C3130333234343236352C3130333234343435392C3130333234363636302C3130333235303631332C3130333235323733382C3130333235333838362C3130333235363032362C3130333235373030332C3130333235393931332C3130333236313134302C3130333236333735372C3130333236393338382C3130333331323932342C3130333331373031352C3130333332313131362C3130333334363634302C),
 (171,'COL11A1.bApr07','chr1','-',103114610,103346640,103116162,103346322,67,0x3130333131343631302C3130333131373832362C3130333131393834302C3130333132313334322C3130333132343935302C3130333132363732302C3130333132363836362C3130333132373030392C3130333132373539382C3130333132383539342C3130333133363236382C3130333133363830392C3130333133373038342C3130333135303330322C3130333135313738302C3130333135323439352C3130333135323834372C3130333135333737342C3130333135383435342C3130333135393636312C3130333136313437392C3130333137323539322C3130333137333230332C3130333137373137382C3130333137383437302C3130333138343939322C3130333230303030392C3130333230303331392C3130333230303739362C3130333230333633302C3130333230383336322C3130333231323937332C3130333231363835312C3130333231373030332C3130333231373230332C3130333231373532352C3130333232323238312C3130333232353737362C3130333232373636312C3130333233343030372C3130333233343133322C3130333233353232332C3130333233363435332C3130333234303036382C3130333234303537312C3130333234303839302C3130333234313335382C3130333234323538372C3130333234323735312C3130333234333938312C3130333234343231312C3130333234343430352C3130333234363630362C3130333235303535362C3130333235323635342C3130333235333831312C3130333235353936332C3130333235363936312C3130333235393835302C3130333236303838352C3130333236333636342C3130333236343335392C3130333236393235392C3130333331323736312C3130333331363830312C3130333332303934382C3130333334363231362C,0x3130333131363330392C3130333131383036302C3130333131393930392C3130333132313435352C3130333132353230302C3130333132363737342C3130333132363930322C3130333132373036332C3130333132373730362C3130333132383634382C3130333133363332322C3130333133363931372C3130333133373133382C3130333135303335362C3130333135313833342C3130333135323534392C3130333135323935352C3130333135333832382C3130333135383530382C3130333135393731352C3130333136313533332C3130333137323730302C3130333137333235372C3130333137373233322C3130333137383537382C3130333138353130302C3130333230303036332C3130333230303430392C3130333230303930342C3130333230333638342C3130333230383431362C3130333231333032372C3130333231363839362C3130333231373035372C3130333231373234382C3130333231373537392C3130333232323333352C3130333232353838342C3130333232373731352C3130333233343035322C3130333233343138362C3130333233353236382C3130333233363530372C3130333234303131332C3130333234303632352C3130333234303933352C3130333234313431322C3130333234323633322C3130333234323830352C3130333234343033352C3130333234343236352C3130333234343435392C3130333234363636302C3130333235303631332C3130333235323733382C3130333235333838362C3130333235363032362C3130333235373030332C3130333235393931332C3130333236313134302C3130333236333735372C3130333236343437362C3130333236393338382C3130333331323932342C3130333331373031352C3130333332313131362C3130333334363634302C),
 (171,'COL11A1.aApr07','chr1','-',103114610,103346640,103116162,103346322,67,0x3130333131343631302C3130333131373832362C3130333131393834302C3130333132313334322C3130333132343935302C3130333132363732302C3130333132363836362C3130333132373030392C3130333132373539382C3130333132383539342C3130333133363236382C3130333133363830392C3130333133373038342C3130333135303330322C3130333135313738302C3130333135323439352C3130333135323834372C3130333135333737342C3130333135383435342C3130333135393636312C3130333136313437392C3130333137323539322C3130333137333230332C3130333137373137382C3130333137383437302C3130333138343939322C3130333230303030392C3130333230303331392C3130333230303739362C3130333230333633302C3130333230383336322C3130333231323937332C3130333231363835312C3130333231373030332C3130333231373230332C3130333231373532352C3130333232323238312C3130333232353737362C3130333232373636312C3130333233343030372C3130333233343133322C3130333233353232332C3130333233363435332C3130333234303036382C3130333234303537312C3130333234303839302C3130333234313335382C3130333234323538372C3130333234323735312C3130333234333938312C3130333234343231312C3130333234343430352C3130333234363630362C3130333235303535362C3130333235323635342C3130333235333831312C3130333235353936332C3130333235363936312C3130333235393835302C3130333236303838352C3130333236333636342C3130333236333934332C3130333236393235392C3130333331323736312C3130333331363830312C3130333332303934382C3130333334363231362C,0x3130333131363330392C3130333131383036302C3130333131393930392C3130333132313435352C3130333132353230302C3130333132363737342C3130333132363930322C3130333132373036332C3130333132373730362C3130333132383634382C3130333133363332322C3130333133363931372C3130333133373133382C3130333135303335362C3130333135313833342C3130333135323534392C3130333135323935352C3130333135333832382C3130333135383530382C3130333135393731352C3130333136313533332C3130333137323730302C3130333137333235372C3130333137373233322C3130333137383537382C3130333138353130302C3130333230303036332C3130333230303430392C3130333230303930342C3130333230333638342C3130333230383431362C3130333231333032372C3130333231363839362C3130333231373035372C3130333231373234382C3130333231373537392C3130333232323333352C3130333232353838342C3130333232373731352C3130333233343035322C3130333233343138362C3130333233353236382C3130333233363530372C3130333234303131332C3130333234303632352C3130333234303933352C3130333234313431322C3130333234323633322C3130333234323830352C3130333234343033352C3130333234343236352C3130333234343435392C3130333234363636302C3130333235303631332C3130333235323733382C3130333235333838362C3130333235363032362C3130333235373030332C3130333235393931332C3130333236313134302C3130333236333735372C3130333236343039362C3130333236393338382C3130333331323932342C3130333331373031352C3130333332313131362C3130333334363634302C),
 (171,'COL11A1.eApr07','chr1','-',103115578,103269357,103116162,103225850,64,0x3130333131353537382C3130333131373832362C3130333131393834302C3130333132313334322C3130333132343935302C3130333132363732302C3130333132363836362C3130333132373030392C3130333132373539382C3130333132383539342C3130333133363236382C3130333133363830392C3130333133373038342C3130333135303330322C3130333135313738302C3130333135323439352C3130333135323834372C3130333135333737342C3130333135383435342C3130333135393636312C3130333136313437392C3130333137323539322C3130333137333230332C3130333137373137382C3130333137383437302C3130333138343939322C3130333230303030392C3130333230303331392C3130333230303739362C3130333230333633302C3130333230383336322C3130333231323937332C3130333231363835312C3130333231373030332C3130333231373230332C3130333231373532352C3130333231373734302C3130333232323238312C3130333232353737362C3130333232373636312C3130333233343030372C3130333233343133322C3130333233353232332C3130333233363435332C3130333234303036382C3130333234303537312C3130333234303839302C3130333234313335382C3130333234323538372C3130333234323735312C3130333234333938312C3130333234343231312C3130333234343430352C3130333234363630362C3130333235303535362C3130333235323635342C3130333235333831312C3130333235353936332C3130333235363936312C3130333235393835302C3130333236303838352C3130333236333636342C3130333236343335392C3130333236393235392C,0x3130333131363330392C3130333131383036302C3130333131393930392C3130333132313435352C3130333132353230302C3130333132363737342C3130333132363930322C3130333132373036332C3130333132373730362C3130333132383634382C3130333133363332322C3130333133363931372C3130333133373133382C3130333135303335362C3130333135313833342C3130333135323534392C3130333135323935352C3130333135333832382C3130333135383530382C3130333135393731352C3130333136313533332C3130333137323730302C3130333137333235372C3130333137373233322C3130333137383537382C3130333138353130302C3130333230303036332C3130333230303430392C3130333230303930342C3130333230333638342C3130333230383431362C3130333231333032372C3130333231363839362C3130333231373035372C3130333231373234382C3130333231373537392C3130333231373735362C3130333232323333352C3130333232353838342C3130333232373731352C3130333233343035322C3130333233343138362C3130333233353236382C3130333233363530372C3130333234303131332C3130333234303632352C3130333234303933352C3130333234313431322C3130333234323633322C3130333234323830352C3130333234343033352C3130333234343236352C3130333234343435392C3130333234363636302C3130333235303631332C3130333235323733382C3130333235333838362C3130333235363032362C3130333235373030332C3130333235393931332C3130333236313134302C3130333236333735372C3130333236343437362C3130333236393335372C),
 (171,'COL11A1.dApr07','chr1','-',103116094,103346623,103116162,103346322,65,0x3130333131363039342C3130333131373832362C3130333131393834302C3130333132313334322C3130333132343935302C3130333132363732302C3130333132363836362C3130333132373030392C3130333132373539382C3130333132383539342C3130333133363236382C3130333133363830392C3130333133373038342C3130333135303330322C3130333135313738302C3130333135323439352C3130333135323834372C3130333135333737342C3130333135383435342C3130333135393636312C3130333136313437392C3130333137323539322C3130333137333230332C3130333137373137382C3130333137383437302C3130333138343939322C3130333230303030392C3130333230303331392C3130333230303739362C3130333230333633302C3130333230383336322C3130333231323937332C3130333231363835312C3130333231373030332C3130333231373230332C3130333231373532352C3130333232323238312C3130333232353737362C3130333232373636312C3130333233343030372C3130333233343133322C3130333233353232332C3130333233363435332C3130333234303036382C3130333234303537312C3130333234303839302C3130333234313335382C3130333234323538372C3130333234323735312C3130333234333938312C3130333234343231312C3130333234343430352C3130333234363630362C3130333235303535362C3130333235323635342C3130333235333831312C3130333235353936332C3130333235363936312C3130333235393835302C3130333236343335392C3130333236393235392C3130333331323736312C3130333331363830312C3130333332303934382C3130333334363231362C,0x3130333131363330392C3130333131383036302C3130333131393930392C3130333132313435352C3130333132353230302C3130333132363737342C3130333132363930322C3130333132373036332C3130333132373730362C3130333132383634382C3130333133363332322C3130333133363931372C3130333133373133382C3130333135303335362C3130333135313833342C3130333135323534392C3130333135323935352C3130333135333832382C3130333135383530382C3130333135393731352C3130333136313533332C3130333137323730302C3130333137333235372C3130333137373233322C3130333137383537382C3130333138353130302C3130333230303036332C3130333230303430392C3130333230303930342C3130333230333638342C3130333230383431362C3130333231333032372C3130333231363839362C3130333231373035372C3130333231373234382C3130333231373537392C3130333232323333352C3130333232353838342C3130333232373731352C3130333233343035322C3130333233343138362C3130333233353236382C3130333233363530372C3130333234303131332C3130333234303632352C3130333234303933352C3130333234313431322C3130333234323633322C3130333234323830352C3130333234343033352C3130333234343236352C3130333234343435392C3130333234363636302C3130333235303631332C3130333235323733382C3130333235333838362C3130333235363032362C3130333235373030332C3130333235393931332C3130333236343437362C3130333236393338382C3130333331323932342C3130333331373031352C3130333332313131362C3130333334363632332C),
 (171,'COL11A1.fApr07','chr1','-',103269044,103321003,103269217,103321003,4,0x3130333236393034342C3130333331323736312C3130333331363830312C3130333332303934382C,0x3130333236393338382C3130333331323932342C3130333331373031352C3130333332313030332C);
INSERT INTO `aceview_hg18_housekeeping` (`bin`,`name`,`chrom`,`strand`,`txStart`,`txEnd`,`cdsStart`,`cdsEnd`,`exonCount`,`exonStarts`,`exonEnds`) VALUES 
 (172,'choynoybu.bApr07-unspliced','chr1','-',103905235,103957790,0,0,2,0x3130333930353233352C3130333935373335362C,0x3130333930353434392C3130333935373739302C),
 (172,'RNPC3_.bApr07','chr1','+',103909174,103969921,103915747,103969891,10,0x3130333930393137342C3130333931353730312C3130333931363235342C3130333931373230372C3130333931373835322C3130333931383430342C3130333936353935302C3130333936383031302C3130333936383234302C3130333936393730312C,0x3130333930393733392C3130333931353931352C3130333931363430312C3130333931373430352C3130333931383038332C3130333931383439302C3130333936363033382C3130333936383132392C3130333936383336362C3130333936393932312C),
 (172,'RNPC3_.hApr07','chr1','+',103917991,103954619,103917993,103954547,5,0x3130333931373939312C3130333931383430342C3130333931393336372C3130333931393538352C3130333935343431382C,0x3130333931383038332C3130333931383533382C3130333931393439302C3130333931393638352C3130333935343631392C),
 (172,'RNPC3_.iApr07','chr1','+',103919486,103954623,103919488,103942214,6,0x3130333931393438362C3130333931393538352C3130333932313633342C3130333932313836342C3130333934323231312C3130333935343431382C,0x3130333931393439302C3130333931393638352C3130333932313735332C3130333932313939302C3130333934323339382C3130333935343632332C),
 (172,'jydu.cApr07','chr1','+',104417996,104469990,0,0,3,0x3130343431373939362C3130343433363135322C3130343436393730362C,0x3130343431383034392C3130343433363334392C3130343436393939302C),
 (174,'LOC727933.eApr07','chr1','-',106271768,106372356,0,0,6,0x3130363237313736382C3130363333323539342C3130363333363331302C3130363336373232362C3130363337313334372C3130363337313935302C,0x3130363237313835392C3130363333323635322C3130363333363438392C3130363336373335372C3130363337313432372C3130363337323335362C),
 (174,'LOC727933.dApr07','chr1','-',106271769,106372397,0,0,7,0x3130363237313736392C3130363239363335322C3130363239363634382C3130363239373531362C3130363336373332382C3130363337313334372C3130363337313935302C,0x3130363237313835392C3130363239363434372C3130363239363734352C3130363239373737342C3130363336373335372C3130363337313432372C3130363337323339372C),
 (175,'speelor.aApr07','chr1','+',107204243,107222467,0,0,4,0x3130373230343234332C3130373230393335362C3130373232313735332C3130373232323234362C,0x3130373230343333322C3130373230393531372C3130373232323038342C3130373232323436372C),
 (175,'NTNG1.cApr07','chr1','+',107483957,107826185,107492738,107824985,6,0x3130373438333935372C3130373439323231332C3130373636383432362C3130373733393239382C3130373735313832362C3130373832343735352C,0x3130373438353238352C3130373439323938342C3130373636393036372C3130373733393437312C3130373735313835332C3130373832363138352C),
 (175,'NTNG1.aApr07','chr1','+',107484063,107826218,107492738,107824985,10,0x3130373438343036332C3130373439323231332C3130373636383432362C3130373733393239382C3130373735313832362C3130373736323732342C3130373736353232382C3130373737343839342C3130373738303830392C3130373832343735352C,0x3130373438343334342C3130373439323938342C3130373636393036372C3130373733393437312C3130373735313835332C3130373736323739302C3130373736353238382C3130373737353036322C3130373738303934342C3130373832363231382C),
 (175,'NTNG1.bApr07','chr1','+',107484253,107825998,107492738,107824985,6,0x3130373438343235332C3130373439323231332C3130373636383432362C3130373733393239382C3130373735313832362C3130373832343735352C,0x3130373438343334342C3130373439323938342C3130373636393036372C3130373733393437312C3130373735313835332C3130373832353939382C),
 (175,'NTNG1.dApr07','chr1','+',107485064,107754730,107492738,107751861,5,0x3130373438353036342C3130373439323231332C3130373636383432362C3130373733393239382C3130373735313832362C,0x3130373438353238352C3130373439323938342C3130373636393036372C3130373733393437312C3130373735343733302C),
 (175,'NTNG1.oApr07','chr1','+',107739442,107824898,107739443,107824898,2,0x3130373733393434322C3130373832343735352C,0x3130373733393437312C3130373832343839382C),
 (175,'NTNG1.jApr07','chr1','+',107739442,107824898,107739444,107824896,4,0x3130373733393434322C3130373735313832362C3130373736323732342C3130373832343735352C,0x3130373733393437312C3130373735313835332C3130373736323739302C3130373832343839382C),
 (175,'NTNG1.kApr07','chr1','+',107739442,107824898,107762741,107824898,5,0x3130373733393434322C3130373735313832362C3130373736323732342C3130373736353232382C3130373832343735352C,0x3130373733393437312C3130373735313835332C3130373736323739302C3130373736353238382C3130373832343839382C),
 (175,'NTNG1.lApr07','chr1','+',107739442,107824898,107739444,107824896,4,0x3130373733393434322C3130373735313832362C3130373738303830392C3130373832343735352C,0x3130373733393437312C3130373735313835332C3130373738303934342C3130373832343839382C),
 (175,'NTNG1.fApr07','chr1','+',107739442,107824898,107739444,107824896,5,0x3130373733393434322C3130373735313832362C3130373736323732342C3130373738303830392C3130373832343735352C,0x3130373733393437312C3130373735313835332C3130373736323739302C3130373738303934342C3130373832343839382C),
 (175,'NTNG1.gApr07','chr1','+',107739442,107824898,107762741,107824898,6,0x3130373733393434322C3130373735313832362C3130373736323732342C3130373736353232382C3130373738303830392C3130373832343735352C,0x3130373733393437312C3130373735313835332C3130373736323739302C3130373736353238382C3130373738303934342C3130373832343839382C),
 (175,'NTNG1.hApr07','chr1','+',107739442,107824898,107775007,107824898,5,0x3130373733393434322C3130373735313832362C3130373737343839342C3130373738303830392C3130373832343735352C,0x3130373733393437312C3130373735313835332C3130373737353036322C3130373738303934342C3130373832343839382C),
 (176,'VAV3.cApr07','chr1','-',108012954,108307740,108013528,108116906,21,0x3130383031323935342C3130383032373633322C3130383033323532352C3130383034383639342C3130383034393130342C3130383039333131322C3130383039333630362C3130383039353236312C3130383039393537312C3130383130313430352C3130383130343932382C3130383130393232302C3130383131303539312C3130383131323538352C3130383131343738302C3130383131363837392C3130383132313337352C3130383132313831342C3130383132333537382C3130383231393034352C3130383330373536322C,0x3130383031333631372C3130383032373637382C3130383033323535312C3130383034383739352C3130383034393230362C3130383039333232322C3130383039333733392C3130383039353334372C3130383039393635382C3130383130313437342C3130383130353032342C3130383130393332302C3130383131303639352C3130383131323635342C3130383131343837332C3130383131363938382C3130383132313434312C3130383132313931352C3130383132333633372C3130383231393136322C3130383330373734302C),
 (176,'VAV3.gApr07','chr1','-',108110659,108165041,108110659,108164936,7,0x3130383131303635392C3130383131323538352C3130383131343738302C3130383131363837392C3130383132313337352C3130383132333537382C3130383136343933302C,0x3130383131303639352C3130383131323635342C3130383131343837332C3130383131363938382C3130383132313434312C3130383132333633372C3130383136353034312C),
 (176,'VAV3.nApr07','chr1','-',108114803,108307644,0,0,7,0x3130383131343830332C3130383131363837392C3130383132313337352C3130383132333537382C3130383230363832382C3130383231393034352C3130383330373536322C,0x3130383131343837332C3130383131363938382C3130383132313434312C3130383132333633372C3130383230363839392C3130383231393136322C3130383330373634342C),
 (176,'VAV3.iApr07','chr1','-',108114833,108308738,108114834,108308593,6,0x3130383131343833332C3130383131363837392C3130383132313337352C3130383132333537382C3130383231393034352C3130383330383539302C,0x3130383131343837332C3130383131363938382C3130383132313434312C3130383132333633372C3130383231393136322C3130383330383733382C),
 (176,'SLC25A24.aApr07','chr1','-',108478866,108544487,108480797,108544487,10,0x3130383437383836362C3130383438333230322C3130383438373638372C3130383439323432332C3130383439393132372C3130383530313630362C3130383530353332362C3130383532363038352C3130383532393937322C3130383534343130302C,0x3130383438303938322C3130383438333335332C3130383438373835352C3130383439323533312C3130383439393238302C3130383530313736352C3130383530353433382C3130383532363137332C3130383533303039392C3130383534343438372C),
 (176,'SLC25A24.bApr07','chr1','-',108478967,108536953,108480797,108536766,10,0x3130383437383936372C3130383438333230322C3130383438373638372C3130383439323432332C3130383439393132372C3130383530313630362C3130383530353332362C3130383532363038352C3130383532393937322C3130383533363634302C,0x3130383438303938322C3130383438333335332C3130383438373835352C3130383439323533312C3130383439393238302C3130383530313736352C3130383530353433382C3130383532363137332C3130383533303039392C3130383533363935332C),
 (176,'LOC727941.aApr07','chr1','+',108617087,108682253,108628385,108681532,6,0x3130383631373038372C3130383632383338342C3130383637353331352C3130383637373830312C3130383638303132312C3130383638313334372C,0x3130383631373436362C3130383632383439362C3130383637353432332C3130383637373936392C3130383638303237322C3130383638323235332C),
 (176,'FAM102B.aApr07','chr1','+',108904233,108989045,108904234,108988868,11,0x3130383930343233332C3130383934343731302C3130383935303336372C3130383935363332322C3130383936303532362C3130383936383738392C3130383937323331312C3130383937323533392C3130383937323832312C3130383937333733322C3130383938383834302C,0x3130383930343731302C3130383934343833312C3130383935303339372C3130383935363433392C3130383936303537332C3130383936383839332C3130383937323430372C3130383937323732392C3130383937323934392C3130383937333830322C3130383938393034352C),
 (176,'FAM102B.bApr07','chr1','+',108904430,108983472,108904432,108979295,11,0x3130383930343433302C3130383934343731302C3130383935303336372C3130383935363332322C3130383936303532362C3130383936383738392C3130383937323331312C3130383937323533392C3130383937323832312C3130383937333733322C3130383937393235322C,0x3130383930343731302C3130383934343833312C3130383935303339372C3130383935363433392C3130383936303537332C3130383936383839332C3130383937323430372C3130383937323732392C3130383937323934392C3130383937333830322C3130383938333437322C),
 (177,'C1orf62.bApr07','chr1','-',109160044,109202372,109161320,109196809,14,0x3130393136303034342C3130393136313139322C3130393136373531342C3130393136373731302C3130393137313334392C3130393137343730332C3130393138313639342C3130393138373237382C3130393139323839362C3130393139333035362C3130393139333638312C3130393139353831362C3130393230313037332C3130393230323230322C,0x3130393136303434372C3130393136313332332C3130393136373632322C3130393136373833332C3130393137313434372C3130393137343739352C3130393138313835312C3130393138373431322C3130393139323935392C3130393139333230352C3130393139333732312C3130393139363931322C3130393230313230352C3130393230323337322C),
 (177,'C1orf62.aApr07','chr1','-',109160067,109201248,109160315,109196809,16,0x3130393136303036372C3130393136313139322C3130393136343638392C3130393136373531342C3130393136373731302C3130393137313334392C3130393137343730332C3130393137383539312C3130393137393037332C3130393138313639342C3130393138373237382C3130393139323839362C3130393139333035362C3130393139333638312C3130393139353831362C3130393230313037332C,0x3130393136303434372C3130393136313332322C3130393136343737312C3130393136373632322C3130393136373833332C3130393137313434372C3130393137343739352C3130393137383637332C3130393137393230312C3130393138313835312C3130393138373431322C3130393139323935392C3130393139333230352C3130393139333732312C3130393139363931322C3130393230313234382C),
 (177,'C1orf62.dApr07','chr1','-',109160164,109219371,109161180,109193696,8,0x3130393136303136342C3130393136313031382C3130393138313830352C3130393138373237382C3130393139323839362C3130393139333638312C3130393230383032372C3130393231393238342C,0x3130393136303434372C3130393136313237362C3130393138313835312C3130393138373431322C3130393139323935392C3130393139333732312C3130393230383231322C3130393231393337312C),
 (177,'C1orf62.cApr07','chr1','-',109180868,109201228,109187426,109196809,7,0x3130393138303836382C3130393138373237382C3130393139323839362C3130393139333035362C3130393139333638312C3130393139353831362C3130393230313037332C,0x3130393138313835312C3130393138373432392C3130393139323935392C3130393139333230352C3130393139333732312C3130393139363931322C3130393230313232382C),
 (177,'SARS.aApr07','chr1','+',109558038,109583091,109558137,109582033,12,0x3130393535383033382C3130393536383132322C3130393537323439362C3130393537333535382C3130393537353032322C3130393537353737352C3130393537393335342C3130393538303132312C3130393538303533352C3130393538303934392C3130393538313338382C3130393538313837352C,0x3130393535383237332C3130393536383139332C3130393537323537372C3130393537333731372C3130393537353136362C3130393537353933312C3130393537393537362C3130393538303235312C3130393538303639332C3130393538313032342C3130393538313531382C3130393538333039312C),
 (177,'SARS.dApr07','chr1','+',109558042,109582249,109568187,109582033,11,0x3130393535383034322C3130393536383132362C3130393537323439362C3130393537333535382C3130393537353032322C3130393537353737352C3130393537393335342C3130393538303132312C3130393538303533352C3130393538313338382C3130393538313837352C,0x3130393535383237332C3130393536383139332C3130393537323537372C3130393537333731372C3130393537353136362C3130393537353933312C3130393537393537362C3130393538303235312C3130393538303639332C3130393538313531382C3130393538323234392C),
 (177,'SARS.fApr07','chr1','+',109558043,109582234,109558137,109582033,9,0x3130393535383034332C3130393536383132322C3130393537323439362C3130393537333535382C3130393537353032322C3130393537353737352C3130393537393335342C3130393538303132312C3130393538313837352C,0x3130393535383237332C3130393536383139332C3130393537323537372C3130393537333731372C3130393537353136362C3130393537353933312C3130393537393537362C3130393538303235312C3130393538323233342C),
 (177,'SARS.jApr07','chr1','+',109558052,109580224,109565256,109579374,9,0x3130393535383035322C3130393536353233312C3130393536383132362C3130393537323439362C3130393537333535382C3130393537353032322C3130393537353737352C3130393537393335342C3130393538303132312C,0x3130393535383237332C3130393536353334382C3130393536383139332C3130393537323537372C3130393537333731372C3130393537353136362C3130393537353838372C3130393537393537362C3130393538303232342C),
 (177,'SARS.gApr07','chr1','+',109558052,109581518,109568187,109581517,12,0x3130393535383035322C3130393536353233312C3130393536383132322C3130393537323439362C3130393537333535382C3130393537353032322C3130393537353737352C3130393537393335342C3130393538303132312C3130393538303533352C3130393538303934392C3130393538313338382C,0x3130393535383237332C3130393536353334382C3130393536383139332C3130393537323537372C3130393537333731372C3130393537353136362C3130393537353933312C3130393537393537362C3130393538303235312C3130393538303639332C3130393538313031352C3130393538313531382C),
 (177,'SARS.lApr07','chr1','+',109558060,109579576,109558137,109579576,5,0x3130393535383036302C3130393536383132322C3130393537323439362C3130393537333535382C3130393537393335342C,0x3130393535383237332C3130393536383139332C3130393537323537372C3130393537333731372C3130393537393537362C),
 (177,'SARS.bApr07','chr1','+',109558060,109582326,109558137,109582033,11,0x3130393535383036302C3130393536383132322C3130393537323439362C3130393537333535382C3130393537353032322C3130393537353737352C3130393537393335342C3130393538303132312C3130393538303533352C3130393538313338382C3130393538313837352C,0x3130393535383237332C3130393536383139332C3130393537323537372C3130393537333731372C3130393537353136362C3130393537353933312C3130393537393537362C3130393538303235312C3130393538303639332C3130393538313531382C3130393538323332362C),
 (177,'SARS.hApr07','chr1','+',109558071,109580354,109558137,109580352,8,0x3130393535383037312C3130393536383132322C3130393537323439362C3130393537333535382C3130393537353032322C3130393537353737352C3130393537393335342C3130393538303132312C,0x3130393535383237332C3130393536383139332C3130393537323537372C3130393537333731372C3130393537353136362C3130393537353933312C3130393537393537362C3130393538303335342C),
 (177,'SARS.iApr07','chr1','+',109558079,109582326,109558137,109579636,8,0x3130393535383037392C3130393536383130312C3130393537323439362C3130393537333535382C3130393537353032322C3130393537353737352C3130393537393335342C3130393538313837352C,0x3130393535383237332C3130393536383139332C3130393537323537372C3130393537333731372C3130393537353136362C3130393537353933312C3130393538313531382C3130393538323332362C),
 (177,'SARS.eApr07','chr1','+',109558123,109582278,109572538,109582033,10,0x3130393535383132332C3130393537323439362C3130393537333535382C3130393537353032322C3130393537353737352C3130393537393335342C3130393538303132312C3130393538303533352C3130393538313338382C3130393538313837352C,0x3130393535383237372C3130393537323537372C3130393537333731372C3130393537353136362C3130393537353933312C3130393537393537362C3130393538303235312C3130393538303639332C3130393538313531382C3130393538323237382C),
 (177,'SARS.cApr07','chr1','+',109558123,109582241,109558137,109582033,10,0x3130393535383132332C3130393536383132322C3130393537323439362C3130393537333535382C3130393537353737352C3130393537393335342C3130393538303132312C3130393538303533352C3130393538313338382C3130393538313837352C,0x3130393535383237332C3130393536383139332C3130393537323537372C3130393537333731372C3130393537353933312C3130393537393537362C3130393538303235312C3130393538303639332C3130393538313531382C3130393538323234312C),
 (177,'SARS.qApr07','chr1','+',109573558,109582308,109573558,109582033,3,0x3130393537333535382C3130393538313439332C3130393538313837352C,0x3130393537333731372C3130393538313531382C3130393538323330382C),
 (177,'SARS.oApr07','chr1','+',109575290,109580281,109575868,109580280,3,0x3130393537353239302C3130393537393335342C3130393538303132312C,0x3130393537353933312C3130393537393537362C3130393538303238312C),
 (177,'SORT1.aApr07','chr1','-',109653702,109742097,109658187,109742097,20,0x3130393635333730322C3130393635383430352C3130393635383831362C3130393636303939342C3130393636313939372C3130393636373037362C3130393636393034332C3130393637313133362C3130393637313634332C3130393638303338342C3130393638343836382C3130393638363135382C3130393638393839352C3130393639313632372C3130393639353037332C3130393639383531312C3130393639393531312C3130393731313535322C3130393731333637342C3130393734313733312C,0x3130393635383230322C3130393635383532392C3130393635383932332C3130393636313130332C3130393636323131342C3130393636373236362C3130393636393233342C3130393637313330352C3130393637313734362C3130393638303439312C3130393638353032342C3130393638363330332C3130393639303032362C3130393639313637372C3130393639353134372C3130393639383637362C3130393639393631342C3130393731313632362C3130393731333733342C3130393734323039372C),
 (177,'SORT1.bApr07','chr1','-',109670950,109737469,109671126,109711584,13,0x3130393637303935302C3130393637313634332C3130393638303338342C3130393638343836382C3130393638363135382C3130393638393839352C3130393639313632372C3130393639353037332C3130393639383531312C3130393639393531312C3130393731313535322C3130393731333637342C3130393733373137312C,0x3130393637313330352C3130393637313734362C3130393638303439312C3130393638353032342C3130393638363330332C3130393639303032332C3130393639313637372C3130393639353134372C3130393639383637362C3130393639393631342C3130393731313632362C3130393731333733342C3130393733373436392C),
 (177,'SORT1.cApr07','chr1','-',109695085,109734044,109695087,109711584,6,0x3130393639353038352C3130393639383531312C3130393639393531312C3130393731313535322C3130393731333637342C3130393733333931392C,0x3130393639353134372C3130393639383637362C3130393639393631342C3130393731313632362C3130393731333733342C3130393733343034342C),
 (177,'CYB561D1.bApr07','chr1','+',109838197,109840417,109838284,109840404,2,0x3130393833383139372C3130393833393930302C,0x3130393833383239392C3130393834303431372C),
 (177,'CYB561D1.cApr07','chr1','+',109838199,109840226,109838199,109840224,3,0x3130393833383139392C3130393833393238372C3130393833393930302C,0x3130393833383239392C3130393833393332352C3130393834303232362C),
 (177,'CYB561D1.fApr07','chr1','+',109838224,109843000,109838284,109839832,3,0x3130393833383232342C3130393833393238372C3130393833393832332C,0x3130393833383433322C3130393833393332352C3130393834333030302C),
 (177,'CYB561D1.aApr07','chr1','+',109838228,109844575,109838284,109840404,3,0x3130393833383232382C3130393833393238372C3130393833393930302C,0x3130393833383433322C3130393833393332352C3130393834343537352C),
 (177,'CYB561D1.dApr07','chr1','+',109838229,109844585,109838284,109840012,4,0x3130393833383232392C3130393833383636342C3130393833393238372C3130393833393930302C,0x3130393833383433322C3130393833383736382C3130393833393332352C3130393834343538352C),
 (177,'CYB561D1.eApr07','chr1','+',109838260,109844585,109838284,109839920,4,0x3130393833383236302C3130393833383636342C3130393833393238372C3130393833393832332C,0x3130393833383433322C3130393833383736382C3130393833393332352C3130393834343538352C),
 (177,'AMPD2.bApr07','chr1','+',109963804,109976279,109964413,109975297,18,0x3130393936333830342C3130393936393434372C3130393936393830362C3130393937303330342C3130393937303436332C3130393937303837302C3130393937313331392C3130393937313537332C3130393937313931382C3130393937323232372C3130393937323530382C3130393937323738372C3130393937333235332C3130393937333437312C3130393937333934302C3130393937343337372C3130393937343832372C3130393937353038372C,0x3130393936343432332C3130393936393537382C3130393936393933372C3130393937303337332C3130393937303537322C3130393937313035372C3130393937313436312C3130393937313636332C3130393937323034382C3130393937323432322C3130393937323634302C3130393937323935312C3130393937333338302C3130393937333633352C3130393937343036312C3130393937343535312C3130393937343933382C3130393937363237392C),
 (177,'AMPD2.dApr07','chr1','+',109963966,109973837,109971085,109973452,10,0x3130393936333936362C3130393936393830362C3130393937303330342C3130393937303436332C3130393937303837302C3130393937313931382C3130393937323232372C3130393937323530382C3130393937323738372C3130393937333235332C,0x3130393936343432332C3130393936393933372C3130393937303337332C3130393937303537322C3130393937313636332C3130393937323034382C3130393937323432322C3130393937323634302C3130393937323935312C3130393937333833372C),
 (177,'AMPD2.eApr07','chr1','+',109963982,109971458,109965252,109971456,7,0x3130393936333938322C3130393936353035382C3130393936393830362C3130393937303330342C3130393937303436332C3130393937303837302C3130393937313331392C,0x3130393936343432332C3130393936353431312C3130393936393933372C3130393937303337332C3130393937303537322C3130393937313035372C3130393937313435382C),
 (177,'AMPD2.kApr07','chr1','+',109964377,109971364,109970305,109971363,6,0x3130393936343337372C3130393936393830362C3130393937303330342C3130393937303436332C3130393937303837302C3130393937313331392C,0x3130393936343432332C3130393936393933372C3130393937303337332C3130393937303537322C3130393937313035372C3130393937313336342C),
 (177,'AMPD2.aApr07','chr1','+',109964465,109976200,109965158,109975297,18,0x3130393936343436352C3130393936393434372C3130393936393830362C3130393937303330342C3130393937303436332C3130393937303837302C3130393937313331392C3130393937313537332C3130393937313931382C3130393937323232372C3130393937323530382C3130393937323738372C3130393937333235332C3130393937333437312C3130393937333934302C3130393937343337372C3130393937343832372C3130393937353038372C,0x3130393936353431312C3130393936393537382C3130393936393933372C3130393937303337332C3130393937303537322C3130393937313035372C3130393937313436312C3130393937313636332C3130393937323034382C3130393937323432322C3130393937323634302C3130393937323935312C3130393937333338302C3130393937333633352C3130393937343036312C3130393937343535312C3130393937343933382C3130393937363230302C),
 (177,'AMPD2.nApr07','chr1','+',109964846,109970888,109965252,109970377,4,0x3130393936343834362C3130393936393830362C3130393937303330342C3130393937303837302C,0x3130393936353431312C3130393936393933372C3130393937303537322C3130393937303838382C),
 (177,'AMPD2.oApr07','chr1','+',109965287,109970606,109965342,109970377,3,0x3130393936353238372C3130393936393830362C3130393937303330342C,0x3130393936353431312C3130393936393933372C3130393937303630362C),
 (177,'AMPD2.iApr07','chr1','+',109967411,109971356,109967418,109971354,6,0x3130393936373431312C3130393936393830362C3130393937303330342C3130393937303436332C3130393937303837302C3130393937313331392C,0x3130393936373434322C3130393936393933372C3130393937303337332C3130393937303537322C3130393937313035372C3130393937313335362C),
 (177,'AMPD2.jApr07','chr1','+',109967984,109971018,109968183,109971017,5,0x3130393936373938342C3130393936393830362C3130393937303330342C3130393937303436332C3130393937303837302C,0x3130393936383233342C3130393936393933372C3130393937303337332C3130393937303537322C3130393937313031382C),
 (177,'AMPD2.hApr07','chr1','+',109968141,109971099,109969548,109971098,6,0x3130393936383134312C3130393936393434372C3130393936393830362C3130393937303330342C3130393937303436332C3130393937303837302C,0x3130393936383233342C3130393936393537382C3130393936393933372C3130393937303337332C3130393937303537322C3130393937313039392C),
 (178,'AHCYL1.aApr07','chr1','+',110328830,110367894,110328834,110365825,17,0x3131303332383833302C3131303335333137382C3131303335353335382C3131303335363530362C3131303335373034312C3131303335383930372C3131303335393536392C3131303336303438382C3131303336303831312C3131303336313633392C3131303336323039302C3131303336323531372C3131303336323639362C3131303336333139352C3131303336333639322C3131303336343837352C3131303336353831382C,0x3131303332393331372C3131303335333239302C3131303335353530322C3131303335363630372C3131303335373134342C3131303335393030322C3131303335393637362C3131303336303630352C3131303336303837352C3131303336313732382C3131303336323136312C3131303336323631322C3131303336323739352C3131303336333236342C3131303336333737312C3131303336343939362C3131303336373839342C),
 (178,'AHCYL1.fApr07','chr1','+',110328939,110363881,110358982,110363064,14,0x3131303332383933392C3131303335333137382C3131303335353335382C3131303335363530362C3131303335373034312C3131303335383930372C3131303336303438382C3131303336303831312C3131303336313633392C3131303336323039302C3131303336323531372C3131303336323639362C3131303336333031392C3131303336333639322C,0x3131303332393039322C3131303335333239302C3131303335353530322C3131303335363630372C3131303335373134342C3131303335393030322C3131303336303630352C3131303336303837352C3131303336313732382C3131303336323136312C3131303336323631322C3131303336323739352C3131303336333236342C3131303336333838312C),
 (178,'AHCYL1.cApr07','chr1','+',110329197,110366519,110329197,110360935,11,0x3131303332393139372C3131303333393739302C3131303335333137382C3131303335353335382C3131303335363530362C3131303335373034312C3131303335383930372C3131303335393536392C3131303336303438382C3131303336303831312C3131303336353936322C,0x3131303332393331372C3131303333393834372C3131303335333239302C3131303335353530322C3131303335363630372C3131303335373134342C3131303335393030322C3131303335393637362C3131303336303630352C3131303336313438342C3131303336363531392C),
 (178,'AHCYL1.bApr07','chr1','+',110348019,110366519,110348320,110365825,17,0x3131303334383031392C3131303335333137382C3131303335353335382C3131303335363530362C3131303335373034312C3131303335383930372C3131303335393536392C3131303336303438382C3131303336303831312C3131303336313633392C3131303336323039302C3131303336323531372C3131303336323639362C3131303336333139352C3131303336333639322C3131303336343837352C3131303336353831382C,0x3131303334383539362C3131303335333239302C3131303335353530322C3131303335363630372C3131303335373134342C3131303335393030322C3131303335393637362C3131303336303630352C3131303336303837352C3131303336313732382C3131303336323136312C3131303336323631322C3131303336323739352C3131303336333236342C3131303336333737312C3131303336343939362C3131303336363531392C),
 (178,'AHCYL1.dApr07','chr1','+',110355836,110367887,110356972,110363064,13,0x3131303335353833362C3131303335383930372C3131303335393536392C3131303336303438382C3131303336303831312C3131303336313633392C3131303336323039302C3131303336323531372C3131303336323639362C3131303336333031392C3131303336333639322C3131303336343837352C3131303336353831382C,0x3131303335373134342C3131303335393030322C3131303335393637362C3131303336303630352C3131303336303837352C3131303336313732382C3131303336323136312C3131303336323631322C3131303336323739352C3131303336333236342C3131303336333737312C3131303336343939362C3131303336373838372C),
 (178,'AHCYL1.eApr07','chr1','+',110359120,110364019,110360531,110363779,9,0x3131303335393132302C3131303336303438382C3131303336303831312C3131303336313633392C3131303336323039302C3131303336323531372C3131303336323639362C3131303336333139352C3131303336333639322C,0x3131303335393637362C3131303336303630352C3131303336303837352C3131303336313732382C3131303336323136312C3131303336323631322C3131303336323739352C3131303336333236342C3131303336343031392C),
 (178,'AHCYL1.lApr07','chr1','+',110360868,110366190,110360869,110363718,6,0x3131303336303836382C3131303336313633392C3131303336323039302C3131303336333639322C3131303336343837352C3131303336353831382C,0x3131303336303837352C3131303336313732382C3131303336323136312C3131303336333737312C3131303336343939362C3131303336363139302C),
 (178,'AHCYL1.jApr07','chr1','+',110361564,110363067,110362091,110363064,5,0x3131303336313536342C3131303336323039302C3131303336323531372C3131303336323639362C3131303336333031392C,0x3131303336313732382C3131303336323136312C3131303336323631322C3131303336323739352C3131303336333036372C),
 (178,'AHCYL1.kApr07','chr1','+',110362474,110363235,110362555,110362840,2,0x3131303336323437342C3131303336323639362C,0x3131303336323631322C3131303336333233352C),
 (178,'meybee.dApr07','chr1','+',110751666,110760419,0,0,3,0x3131303735313636362C3131303735363331372C3131303736303135332C,0x3131303735323039392C3131303735363433382C3131303736303431392C),
 (178,'meybee.bApr07','chr1','+',110751909,110760418,0,0,4,0x3131303735313930392C3131303735333131342C3131303735363331372C3131303736303135332C,0x3131303735323435392C3131303735333330332C3131303735363433382C3131303736303431382C),
 (178,'meybee.aApr07','chr1','+',110752016,110760419,110752016,110756346,4,0x3131303735323031362C3131303735333232392C3131303735363331372C3131303736303135332C,0x3131303735323039392C3131303735333330332C3131303735363433382C3131303736303431392C),
 (178,'meybee.gApr07','chr1','+',110753276,110760419,0,0,4,0x3131303735333237362C3131303735363331372C3131303735383239362C3131303736303135332C,0x3131303735333330332C3131303735363433382C3131303735383337362C3131303736303431392C),
 (178,'kusiyo.bApr07','chr1','+',110852350,111113763,0,0,5,0x3131303835323335302C3131303931343035372C3131303931343238322C3131303931353333382C3131313131333233322C,0x3131303835323432352C3131303931343139352C3131303931343338312C3131303931353439352C3131313131333736332C),
 (178,'KCNA3.aApr07','chr1','-',111003642,111019179,111017226,111018954,3,0x3131313030333634322C3131313031323336372C3131313031353632302C,0x3131313030333733312C3131313031323438392C3131313031393137392C),
 (179,'CD53.mApr07','chr1','+',111217292,111296852,0,0,3,0x3131313231373239322C3131313233353533362C3131313239363332382C,0x3131313231373339332C3131313233353631362C3131313239363835322C),
 (179,'DENND2D.aApr07','chr1','-',111527866,111544847,111531749,111544604,12,0x3131313532373836362C3131313533323237352C3131313533323834362C3131313533333335362C3131313533363238342C3131313533383732322C3131313534303036302C3131313534313332302C3131313534323036342C3131313534323737342C3131313534333736372C3131313534343533372C,0x3131313533313832362C3131313533323531352C3131313533323933312C3131313533333339382C3131313533363436322C3131313533383837312C3131313534303230312C3131313534313339382C3131313534323133342C3131313534323838372C3131313534333934332C3131313534343834372C),
 (179,'DENND2D.bApr07','chr1','-',111531318,111548682,111531749,111548498,12,0x3131313533313331382C3131313533323237352C3131313533323834362C3131313533333335362C3131313533363238342C3131313533383732322C3131313534303036302C3131313534313332302C3131313534323036342C3131313534323737342C3131313534333736372C3131313534383434302C,0x3131313533313832362C3131313533323531352C3131313533323933312C3131313533333339382C3131313533363436322C3131313533383837312C3131313534303230312C3131313534313339382C3131313534323133342C3131313534323838372C3131313534333934332C3131313534383638322C),
 (179,'DENND2D.gApr07','chr1','-',111531325,111544691,111541917,111544691,7,0x3131313533313332352C3131313533323237352C3131313533383837312C3131313534303036302C3131313534323737342C3131313534333736372C3131313534343533372C,0x3131313533313832362C3131313533323330352C3131313533393937332C3131313534323133342C3131313534323838372C3131313534333934332C3131313534343639312C),
 (179,'DENND2D.cApr07','chr1','-',111532602,111548732,111532769,111548731,11,0x3131313533323630322C3131313533333335362C3131313533363238342C3131313533383732322C3131313534303036302C3131313534313332302C3131313534323036342C3131313534323737342C3131313534333736372C3131313534363533392C3131313534383633342C,0x3131313533323933312C3131313533333339382C3131313533363436322C3131313533383837312C3131313534303230312C3131313534313339382C3131313534323133342C3131313534323838372C3131313534333934332C3131313534363539302C3131313534383733322C),
 (179,'DENND2D.dApr07','chr1','-',111536356,111548682,111536356,111548682,8,0x3131313533363335362C3131313533383732322C3131313534303036302C3131313534313332302C3131313534323036342C3131313534323737342C3131313534333736372C3131313534383636362C,0x3131313533363436322C3131313533383837312C3131313534303230312C3131313534313339382C3131313534323133342C3131313534323838372C3131313534333934332C3131313534383638322C),
 (179,'DENND2D.fApr07','chr1','-',111538799,111544785,111538799,111543965,6,0x3131313533383739392C3131313534303036302C3131313534313332302C3131313534323036342C3131313534323737342C3131313534333736372C,0x3131313533383837312C3131313534303230312C3131313534313339382C3131313534323133342C3131313534323838372C3131313534343738352C),
 (179,'DENND2D.hApr07','chr1','-',111538830,111544747,111541917,111544604,6,0x3131313533383833302C3131313534303036302C3131313534313332302C3131313534323737342C3131313534333736372C3131313534343533372C,0x3131313533383837312C3131313534303230312C3131313534323133342C3131313534323838372C3131313534333934332C3131313534343734372C),
 (179,'DENND2D.eApr07','chr1','-',111539359,111548447,111540051,111548405,6,0x3131313533393335392C3131313534313332302C3131313534323036342C3131313534323737342C3131313534333736372C3131313534383239302C,0x3131313534303230312C3131313534313339382C3131313534323133342C3131313534323838372C3131313534333934332C3131313534383434372C),
 (179,'DENND2D.jApr07','chr1','-',111541647,111544251,111541917,111543965,3,0x3131313534313634372C3131313534323737342C3131313534333736372C,0x3131313534323133342C3131313534323838372C3131313534343235312C),
 (179,'DENND2D.lApr07','chr1','-',111541879,111548653,111541917,111543899,4,0x3131313534313837392C3131313534323737342C3131313534333736372C3131313534383633342C,0x3131313534323133342C3131313534323838372C3131313534333934332C3131313534383635332C),
 (179,'DENND2D.iApr07','chr1','-',111541905,111548497,111541917,111548465,4,0x3131313534313930352C3131313534323737342C3131313534333736372C3131313534383434302C,0x3131313534323133342C3131313534323838372C3131313534333934332C3131313534383439372C),
 (179,'DENND2D.kApr07','chr1','-',111541935,111548719,111541935,111548688,4,0x3131313534313933352C3131313534323737342C3131313534333736372C3131313534383636362C,0x3131313534323133342C3131313534323838372C3131313534333934332C3131313534383731392C),
 (179,'DENND2D.qApr07','chr1','-',111542064,111544388,111542064,111543899,4,0x3131313534323036342C3131313534323737342C3131313534333736372C3131313534343035392C,0x3131313534323133342C3131313534323838372C3131313534333934332C3131313534343338382C),
 (179,'DENND2D.oApr07','chr1','-',111542064,111548680,111542064,111546570,5,0x3131313534323036342C3131313534323737342C3131313534333736372C3131313534363533392C3131313534383239302C,0x3131313534323133342C3131313534323838372C3131313534333934332C3131313534363539302C3131313534383638302C),
 (179,'DENND2D.mApr07','chr1','-',111542098,111548653,111542100,111548498,5,0x3131313534323039382C3131313534323737342C3131313534333736372C3131313534363533392C3131313534383434302C,0x3131313534323133342C3131313534323838372C3131313534333934332C3131313534363539302C3131313534383635332C),
 (179,'ATP5F1.aApr07','chr1','+',111793003,111805235,111793003,111805139,7,0x3131313739333030332C3131313739333333392C3131313739333938312C3131313739383335352C3131313830303233302C3131313830303737342C3131313830353036312C,0x3131313739333039342C3131313739333732362C3131313739343031382C3131313739383530312C3131313830303339342C3131313830303930302C3131313830353233352C),
 (179,'ATP5F1.fApr07','chr1','+',111793150,111805556,111800331,111805139,6,0x3131313739333135302C3131313739333938312C3131313830303233302C3131313830303737342C3131313830333630312C3131313830353036312C,0x3131313739333732362C3131313739343031382C3131313830303339342C3131313830303930302C3131313830333738312C3131313830353535362C),
 (179,'ATP5F1.bApr07','chr1','+',111793265,111807163,111793470,111805139,7,0x3131313739333236352C3131313739333938312C3131313739383335352C3131313830303233302C3131313830303737342C3131313830333630312C3131313830353036312C,0x3131313739333732362C3131313739343031382C3131313739383530312C3131313830303339342C3131313830303930302C3131313830333738312C3131313830373136332C),
 (179,'ATP5F1.dApr07','chr1','+',111793628,111805318,111793686,111805139,5,0x3131313739333632382C3131313830303233302C3131313830303737342C3131313830333630312C3131313830353036312C,0x3131313739333732362C3131313830303339342C3131313830303930302C3131313830333738312C3131313830353331382C),
 (179,'ATP5F1.jApr07','chr1','+',111793629,111805457,0,0,6,0x3131313739333632392C3131313739333938312C3131313830303337312C3131313830303737342C3131313830333630312C3131313830353036312C,0x3131313739333732362C3131313739343031382C3131313830303339342C3131313830303930302C3131313830333738312C3131313830353435372C),
 (179,'ATP5F1.cApr07','chr1','+',111793822,111805403,111798371,111805139,6,0x3131313739333832322C3131313739383335352C3131313830303233302C3131313830303737342C3131313830333630312C3131313830353036312C,0x3131313739343031382C3131313739383530312C3131313830303339342C3131313830303930302C3131313830333738312C3131313830353430332C),
 (179,'RAP1A.aApr07','chr1','+',111886362,112057258,112035505,112053380,8,0x3131313838363336322C3131323033353437382C3131323033393438352C3131323034313538352C3131323034373438302C3131323034383438372C3131323035333239332C3131323035363537352C,0x3131313838363635342C3131323033353536322C3131323033393535342C3131323034313634322C3131323034373632312C3131323034383633312C3131323035333430392C3131323035373235382C),
 (179,'C1orf183.eApr07','chr1','-',112024774,112083544,112030726,112083543,3,0x3131323032343737342C3131323033303639302C3131323038333333302C,0x3131323032343931392C3131323033303832382C3131323038333534342C),
 (179,'C1orf183.aApr07','chr1','-',112066207,112083568,112071112,112083387,2,0x3131323036363230372C3131323038333333302C,0x3131323037313934392C3131323038333536382C),
 (180,'smerley.bApr07','chr1','-',112520981,112704673,0,0,2,0x3131323532303938312C3131323730343530362C,0x3131323532313735382C3131323730343637332C),
 (180,'smerley.aApr07','chr1','-',112573814,112704779,112582232,112704563,4,0x3131323537333831342C3131323537383836372C3131323538323231342C3131323730343530362C,0x3131323537343337332C3131323537393034342C3131323538323334332C3131323730343737392C),
 (180,'WNT2B.cApr07','chr1','+',112810686,112865428,112859112,112864654,5,0x3131323831303638362C3131323835393031382C3131323836303238342C3131323836313236352C3131323836343432342C,0x3131323831313733362C3131323835393233392C3131323836303536322C3131323836313533302C3131323836353432382C),
 (180,'WNT2B.bApr07','chr1','+',112811171,112865428,112811682,112864654,6,0x3131323831313137312C3131323833353135352C3131323835393031382C3131323836303238342C3131323836313236352C3131323836343432342C,0x3131323831313733362C3131323833353232362C3131323835393233392C3131323836303536322C3131323836313533302C3131323836353432382C),
 (180,'WNT2B.aApr07','chr1','+',112852581,112865428,112853407,112864654,5,0x3131323835323538312C3131323835393031382C3131323836303238342C3131323836313236352C3131323836343432342C,0x3131323835333538392C3131323835393233392C3131323836303536322C3131323836313533302C3131323836353432382C),
 (180,'CAPZA1.aApr07','chr1','+',112962942,113015764,112963989,113014277,10,0x3131323936323934322C3131323939313335342C3131323939333536322C3131323939373734322C3131323939383630392C3131333030333136362C3131333030333834352C3131333031313231382C3131333031333638372C3131333031343133362C,0x3131323936343032382C3131323939313431382C3131323939333631342C3131323939373830362C3131323939383831362C3131333030333234362C3131333030333932342C3131333031313239302C3131333031333735302C3131333031353736342C),
 (180,'CAPZA1.eApr07','chr1','+',112963598,112994243,112963989,112993618,3,0x3131323936333539382C3131323939313335342C3131323939333536322C,0x3131323936343032382C3131323939313431382C3131323939343234332C),
 (180,'CAPZA1.bApr07','chr1','+',112963977,113003924,112997761,113003924,8,0x3131323936333937372C3131323939303839392C3131323939313335342C3131323939333536322C3131323939373734322C3131323939383630392C3131333030333136362C3131333030333834352C,0x3131323936343032382C3131323939303933392C3131323939313431382C3131323939333631342C3131323939373830362C3131323939383831362C3131333030333234362C3131333030333932342C),
 (181,'spypla.bApr07','chr1','-',113355831,113417250,113392599,113417249,3,0x3131333335353833312C3131333339323536372C3131333431373038332C,0x3131333335373938342C3131333339323730362C3131333431373235302C),
 (181,'spypla.aApr07','chr1','-',113355839,113417148,113357940,113417125,4,0x3131333335353833392C3131333336313331392C3131333339323536372C3131333431373130372C,0x3131333335373938342C3131333336313339342C3131333339323730362C3131333431373134382C),
 (181,'MAGI3.bApr07','chr1','+',113734619,114030067,113735178,114026406,22,0x3131333733343631392C3131333839333635392C3131333932343638362C3131333932393533312C3131333933343632382C3131333933383632352C3131333935383734352C3131333936333838302C3131333936363935302C3131333938363035352C3131333938373838372C3131333939303633302C3131333939333338312C3131333939353135382C3131333939373937342C3131343030333232342C3131343031353837382C3131343031363735392C3131343031373436362C3131343032353334322C3131343032363335362C3131343032393532322C,0x3131333733353439342C3131333839333737362C3131333932343830362C3131333932393734312C3131333933343830332C3131333933383730352C3131333935383830332C3131333936333937352C3131333936373133392C3131333938363636312C3131333938373931392C3131333939303738372C3131333939333437332C3131333939353335312C3131333939383136332C3131343030333431302C3131343031353938312C3131343031363838362C3131343031373631302C3131343032353438312C3131343032373035372C3131343033303036372C),
 (181,'MAGI3.aApr07','chr1','+',113734887,114026514,113735178,114026406,22,0x3131333733343838372C3131333839333635392C3131333932343638362C3131333932393533312C3131333933343632382C3131333933383632352C3131333935383734352C3131333936323637362C3131333936333838302C3131333936363935302C3131333938363035352C3131333938373838372C3131333939303633302C3131333939333338312C3131333939353135382C3131333939373937342C3131343030333232342C3131343031353837382C3131343031363735392C3131343031373436362C3131343032353334322C3131343032363335362C,0x3131333733353439342C3131333839333737362C3131333932343830362C3131333932393734312C3131333933343830332C3131333933383730352C3131333935383830332C3131333936323735312C3131333936333937352C3131333936373133392C3131333938363636312C3131333938373931392C3131333939303738372C3131333939333437332C3131333939353335312C3131333939383136332C3131343030333431302C3131343031353938312C3131343031363838362C3131343031373631302C3131343032353438312C3131343032363531342C),
 (181,'MAGI3.hApr07','chr1','+',113893659,113926048,113893661,113924850,2,0x3131333839333635392C3131333932343638362C,0x3131333839333737362C3131333932363034382C),
 (181,'PHTF1.mApr07','chr1','-',114026996,114043904,114033879,114043902,4,0x3131343032363939362C3131343033333836372C3131343034323430362C3131343034333834382C,0x3131343032373231352C3131343033333932342C3131343034323533322C3131343034333930342C),
 (181,'wubee.aApr07','chr1','+',114156500,114168912,114156711,114159605,4,0x3131343135363530302C3131343135383533312C3131343135393532322C3131343136383835332C,0x3131343135363735372C3131343135383633362C3131343135393631372C3131343136383931322C),
 (181,'wubee.cApr07','chr1','+',114156518,114167638,114156711,114159605,4,0x3131343135363531382C3131343135383533312C3131343135393532322C3131343136373330322C,0x3131343135363735372C3131343135383633362C3131343135393631372C3131343136373633382C),
 (181,'wubee.gApr07','chr1','+',114156757,114167545,0,0,4,0x3131343135363735372C3131343135383533312C3131343135393532322C3131343136373436372C,0x3131343135363937302C3131343135383633362C3131343135393631372C3131343136373534352C),
 (181,'wubee.fApr07','chr1','+',114156798,114244064,0,0,5,0x3131343135363739382C3131343135383533312C3131343135393532322C3131343234323031322C3131343234343031362C,0x3131343135363937302C3131343135383633362C3131343135393631372C3131343234323133342C3131343234343036342C),
 (181,'PTPN22.bApr07','chr1','-',114157955,114215843,114159049,114215768,19,0x3131343135373935352C3131343136333732312C3131343136393238362C3131343137333733362C3131343137343039332C3131343137373235352C3131343137383435332C3131343137393035342C3131343138313733342C3131343138323638382C3131343139383631352C3131343139393035312C3131343230303532362C3131343230303639322C3131343230313838322C3131343230323632322C3131343230333134362C3131343230333439362C3131343231353638312C,0x3131343135393131342C3131343136333739392C3131343136393331372C3131343137333835322C3131343137343137342C3131343137373238332C3131343137383538342C3131343137393133382C3131343138323535322C3131343138323736352C3131343139383638322C3131343139393139342C3131343230303538362C3131343230303736342C3131343230313932312C3131343230323731382C3131343230333232332C3131343230333630352C3131343231353834332C),
 (181,'PTPN22.dApr07','chr1','-',114157959,114215858,114163727,114215768,8,0x3131343135373935392C3131343136333732312C3131343230303532362C3131343230313838322C3131343230323632322C3131343230333134362C3131343230333439362C3131343231353638312C,0x3131343135393131342C3131343136333739392C3131343230303538362C3131343230313932312C3131343230323731382C3131343230333232332C3131343230333630352C3131343231353835382C),
 (181,'PTPN22.aApr07','chr1','-',114157959,114215978,114159049,114215768,21,0x3131343135373935392C3131343136333732312C3131343136393238362C3131343137333733362C3131343137343039332C3131343137373235352C3131343137383435332C3131343137393035342C3131343138313733342C3131343138323638382C3131343139323638342C3131343139363137312C3131343139383631352C3131343139393035312C3131343230303532362C3131343230303639322C3131343230313838322C3131343230323632322C3131343230333134362C3131343230333439362C3131343231353638312C,0x3131343135393131342C3131343136333739392C3131343136393331372C3131343137333835322C3131343137343137342C3131343137373238332C3131343137383538342C3131343137393133382C3131343138323535322C3131343138323736352C3131343139323737312C3131343139363234392C3131343139383638322C3131343139393139342C3131343230303538362C3131343230303736342C3131343230313932312C3131343230323731382C3131343230333232332C3131343230333630352C3131343231353937382C),
 (181,'PTPN22.jApr07','chr1','-',114158808,114163977,0,0,2,0x3131343135383830382C3131343136333732312C,0x3131343135393131342C3131343136333937372C),
 (181,'PTPN22.kApr07','chr1','-',114159029,114166939,0,0,3,0x3131343135393032392C3131343136333732312C3131343136363731322C,0x3131343135393131342C3131343136333739392C3131343136363933392C),
 (182,'woyleybo.aApr07','chr1','-',114550573,114606423,0,0,2,0x3131343535303537332C3131343630363335302C,0x3131343535303833302C3131343630363432332C),
 (182,'TRIM33.aApr07','chr1','-',114736921,114855305,114741792,114855304,19,0x3131343733363932312C3131343734333630312C3131343734353533332C3131343734363930342C3131343734393535342C3131343735313038352C3131343735323832312C3131343735343332382C3131343736353538302C3131343736383733352C3131343736393539332C3131343737313332312C3131343737313839322C3131343737343934322C3131343737373736312C3131343830373234382C3131343830373535362C3131343830383431342C3131343835343639342C,0x3131343734323030352C3131343734333735342C3131343734353630382C3131343734373032382C3131343734393930342C3131343735313234352C3131343735323838352C3131343735343436312C3131343736353738312C3131343736383930302C3131343736393836382C3131343737313433392C3131343737323033392C3131343737353035372C3131343737373837382C3131343830373338312C3131343830373730312C3131343830383533332C3131343835353330352C),
 (182,'TRIM33.bApr07','chr1','-',114736921,114855350,114741792,114855220,20,0x3131343733363932312C3131343734323038342C3131343734333630312C3131343734353533332C3131343734363930342C3131343734393535342C3131343735313038352C3131343735323832312C3131343735343332382C3131343736353538302C3131343736383733352C3131343736393539332C3131343737313332312C3131343737313839322C3131343737343934322C3131343737373736312C3131343830373234382C3131343830373535362C3131343830383431342C3131343835343639342C,0x3131343734323030352C3131343734323133352C3131343734333735342C3131343734353630382C3131343734373032382C3131343734393930342C3131343735313234352C3131343735323838352C3131343735343436312C3131343736353738312C3131343736383930302C3131343736393836382C3131343737313433392C3131343737323033392C3131343737353035372C3131343737373837382C3131343830373338312C3131343830373730312C3131343830383533332C3131343835353335302C),
 (182,'TRIM33.mApr07','chr1','-',114807663,114840472,114807665,114840128,3,0x3131343830373636332C3131343830383431342C3131343834303038352C,0x3131343830373730312C3131343830383533332C3131343834303437322C),
 (182,'barnabu.aApr07','chr1','+',114818745,114819451,114818745,114819254,2,0x3131343831383734352C3131343831393132322C,0x3131343831383739392C3131343831393435312C),
 (182,'AMPD1andDENND2CandBCAS2.cApr07','chr1','-',114865540,115014567,114929743,114970128,30,0x3131343836353534302C3131343838303038322C3131343838333033342C3131343838393232322C3131343839303234382C3131343839323130342C3131343931323235372C3131343931343133352C3131343931343834332C3131343931393733332C3131343932303833312C3131343932353434322C3131343932393637392C3131343933313533302C3131343933313835392C3131343933383631362C3131343933393937352C3131343934333431372C3131343934343939362C3131343934353635312C3131343934363236382C3131343934393036352C3131343935323832392C3131343935353231362C3131343936323532392C3131343936363033382C3131343936373133302C3131343936373635302C3131343936393332322C3131353031343338342C,0x3131343836353731312C3131343838303930362C3131343838333135332C3131343838393439322C3131343839303337382C3131343839323334312C3131343931323430302C3131343931343231362C3131343931343839342C3131343931393839352C3131343932303930322C3131343932353533352C3131343932393737352C3131343933313631372C3131343933323039362C3131343933383732322C3131343934303031372C3131343934333434312C3131343934353130342C3131343934353732392C3131343934363333382C3131343934393137352C3131343935333031372C3131343935353236312C3131343936323632362C3131343936363230392C3131343936373234332C3131343936373738372C3131343937303333322C3131353031343536372C),
 (182,'AMPD1andDENND2CandBCAS2.aApr07','chr1','-',114926990,115014179,114929743,114970128,22,0x3131343932363939302C3131343932383731332C3131343933313533302C3131343933313835392C3131343933383631362C3131343933393937352C3131343934333431372C3131343934343334372C3131343934343936332C3131343934353635312C3131343934363236382C3131343934393036352C3131343935323832392C3131343935353231362C3131343936323532392C3131343936363033382C3131343936373133302C3131343936373635302C3131343936393332322C3131343938393539312C3131343939383634382C3131353031343132362C,0x3131343932373639382C3131343932393737352C3131343933313631372C3131343933323039362C3131343933383732322C3131343934303031372C3131343934333539352C3131343934343439362C3131343934353130342C3131343934353732392C3131343934363333382C3131343934393137352C3131343935333031372C3131343935353236312C3131343936323632362C3131343936363230392C3131343936373234332C3131343936373738372C3131343937303333322C3131343938393730332C3131343939383930352C3131353031343137392C),
 (182,'AMPD1andDENND2CandBCAS2.bApr07','chr1','-',114928433,115014255,114929743,114970128,18,0x3131343932383433332C3131343933313533302C3131343933313835392C3131343933383631362C3131343933393937352C3131343934333431372C3131343934343334372C3131343934343936332C3131343934353635312C3131343934363236382C3131343934393036352C3131343935323832392C3131343935353231362C3131343936323532392C3131343936373133302C3131343936373635302C3131343936393332322C3131353031343132362C,0x3131343932393737352C3131343933313631372C3131343933323039362C3131343933383732322C3131343934303031372C3131343934333539352C3131343934343439362C3131343934353130342C3131343934353732392C3131343934363333382C3131343934393137352C3131343935333031372C3131343935353236312C3131343936323632362C3131343936373234332C3131343936373738372C3131343937303333322C3131353031343235352C),
 (182,'AMPD1andDENND2CandBCAS2.fApr07','chr1','-',114930901,115014544,114939686,114969353,19,0x3131343933303930312C3131343933313835392C3131343933383631362C3131343933393439382C3131343933393937352C3131343934333431372C3131343934343334372C3131343934343936332C3131343934353635312C3131343934363236382C3131343934393036352C3131343935323832392C3131343935353231362C3131343936323532392C3131343936363033382C3131343936373133302C3131343936373730332C3131343936393332322C3131353031343339352C,0x3131343933313631372C3131343933323039362C3131343933383732322C3131343933393739342C3131343934303031372C3131343934333539352C3131343934343439362C3131343934353130342C3131343934353732392C3131343934363333382C3131343934393137352C3131343935333031372C3131343935353236312C3131343936323632362C3131343936363230392C3131343936373234332C3131343936373738372C3131343937303333322C3131353031343534342C),
 (182,'SIKEandCSDE1andNRAS.dApr07','chr1','-',115048608,115102146,115062312,115084034,24,0x3131353034383630382C3131353035323239372C3131353035323637342C3131353035333731322C3131353035373934332C3131353036303139332C3131353036303830312C3131353036323735362C3131353036333732322C3131353036343638322C3131353036383032362C3131353036393336342C3131353037303335342C3131353037313132362C3131353037343430312C3131353037343635312C3131353037363734372C3131353037373837352C3131353037383133322C3131353037383538352C3131353038303930312C3131353038323130362C3131353038333833352C3131353130323036382C,0x3131353035323139342C3131353035323333362C3131353035323739382C3131353035333837322C3131353035383132322C3131353036303332312C3131353036323336302C3131353036323838392C3131353036333838362C3131353036343836312C3131353036383134362C3131353036393437372C3131353037303533302C3131353037313233342C3131353037343536362C3131353037343739322C3131353037363936302C3131353037383030312C3131353037383236312C3131353037383636372C3131353038303939392C3131353038323231362C3131353038343033342C3131353130323134362C),
 (182,'SIKEandCSDE1andNRAS.eApr07','chr1','-',115061053,115102147,115062312,115084034,19,0x3131353036313035332C3131353036323735362C3131353036333732322C3131353036343638322C3131353036383032362C3131353036393336342C3131353037303335342C3131353037313132362C3131353037343430312C3131353037343635312C3131353037363734372C3131353037373837352C3131353037383133322C3131353037383538352C3131353038303930312C3131353038323130362C3131353038333833352C3131353039333936342C3131353130323036382C,0x3131353036323336302C3131353036323838392C3131353036333838362C3131353036343836312C3131353036383134362C3131353036393437372C3131353037303533302C3131353037313233342C3131353037343536362C3131353037343739322C3131353037363936302C3131353037383030312C3131353037383236312C3131353037383636372C3131353038303939392C3131353038323231362C3131353038343033342C3131353039343335312C3131353130323134372C),
 (182,'SIKEandCSDE1andNRAS.cApr07','chr1','-',115061060,115102198,115062312,115084034,20,0x3131353036313036302C3131353036323735362C3131353036333732322C3131353036343638322C3131353036383032362C3131353036393336342C3131353037303335342C3131353037313132362C3131353037343430312C3131353037343635312C3131353037363734372C3131353037373837352C3131353037383133322C3131353037383538352C3131353038303930312C3131353038313631342C3131353038323130362C3131353038333833352C3131353039333936342C3131353130323036382C,0x3131353036323336302C3131353036323838392C3131353036333838362C3131353036343836312C3131353036383134362C3131353036393437372C3131353037303533302C3131353037313233342C3131353037343536362C3131353037343739322C3131353037363936302C3131353037383030312C3131353037383236312C3131353037383636372C3131353038303939392C3131353038313730372C3131353038323231362C3131353038343033342C3131353039343335312C3131353130323139382C),
 (182,'SIKEandCSDE1andNRAS.bApr07','chr1','-',115061060,115102126,115062312,115085808,20,0x3131353036313036302C3131353036323735362C3131353036333732322C3131353036343638322C3131353036383032362C3131353036393336342C3131353037303335342C3131353037313132362C3131353037343430312C3131353037343635312C3131353037363734372C3131353037373837352C3131353037383133322C3131353037383538352C3131353038303930312C3131353038323130362C3131353038333833352C3131353038353637302C3131353039333936342C3131353130323036382C,0x3131353036323336302C3131353036323838392C3131353036333838362C3131353036343836312C3131353036383134362C3131353036393437372C3131353037303533302C3131353037313233342C3131353037343536362C3131353037343739322C3131353037363936302C3131353037383030312C3131353037383236312C3131353037383636372C3131353038303939392C3131353038323231362C3131353038343033342C3131353038353831372C3131353039343335312C3131353130323132362C),
 (182,'SIKEandCSDE1andNRAS.aApr07','chr1','-',115061060,115102146,115062312,115085808,21,0x3131353036313036302C3131353036323735362C3131353036333732322C3131353036343638322C3131353036383032362C3131353036393336342C3131353037303335342C3131353037313132362C3131353037343430312C3131353037343635312C3131353037363734372C3131353037373837352C3131353037383133322C3131353037383538352C3131353038303930312C3131353038313631342C3131353038323130362C3131353038333833352C3131353038353637302C3131353039333936342C3131353130323036382C,0x3131353036323336302C3131353036323838392C3131353036333838362C3131353036343836312C3131353036383134362C3131353036393437372C3131353037303533302C3131353037313233342C3131353037343536362C3131353037343739322C3131353037363936302C3131353037383030312C3131353037383236312C3131353037383636372C3131353038303939392C3131353038313730372C3131353038323231362C3131353038343033342C3131353038353831372C3131353039343335312C3131353130323134362C),
 (182,'SIKEandCSDE1andNRAS.fApr07','chr1','-',115062171,115102136,115062312,115084034,9,0x3131353036323137312C3131353036323735362C3131353037383538352C3131353038303930312C3131353038323130362C3131353038333833352C3131353039333936342C3131353039343239322C3131353130323036382C,0x3131353036323336302C3131353036323832302C3131353037383636372C3131353038303939392C3131353038323231362C3131353038343033342C3131353039343034382C3131353039343335312C3131353130323133362C),
 (182,'SIKEandCSDE1andNRAS.hApr07','chr1','-',115076759,115102095,115076759,115082118,9,0x3131353037363735392C3131353037373837352C3131353037383133322C3131353037383538352C3131353038303930312C3131353038323130362C3131353038333833352C3131353039343239322C3131353130323036382C,0x3131353037363936302C3131353037383030312C3131353037383236312C3131353037383636372C3131353038303939392C3131353038323231362C3131353038333836392C3131353039343335312C3131353130323039352C),
 (182,'SIKEandCSDE1andNRAS.gApr07','chr1','-',115076800,115102102,115076801,115102102,7,0x3131353037363830302C3131353037373837352C3131353037383133322C3131353037383538352C3131353038303930312C3131353038323130362C3131353130323036382C,0x3131353037363936302C3131353037383030312C3131353037383236312C3131353037383636372C3131353038303939392C3131353038323231362C3131353130323130322C),
 (182,'SIKEandCSDE1andNRAS.vaApr07','chr1','-',115078196,115102155,115078198,115082118,6,0x3131353037383139362C3131353037383538352C3131353038303930312C3131353038323130362C3131353039333936342C3131353130323036382C,0x3131353037383236312C3131353037383636372C3131353038303939392C3131353038323231362C3131353039343335312C3131353130323135352C),
 (182,'SIKEandCSDE1andNRAS.lApr07','chr1','-',115078590,115103718,115078591,115084034,7,0x3131353037383539302C3131353038303930312C3131353038323130362C3131353038333833352C3131353039333936342C3131353130323036382C3131353130333730362C,0x3131353037383636372C3131353038303939392C3131353038323231362C3131353038343033342C3131353039343335312C3131353130323037362C3131353130333731382C),
 (182,'SYCP1.aApr07','chr1','+',115198948,115339516,115199608,115339163,32,0x3131353139383934382C3131353139393538342C3131353230303731362C3131353230313337352C3131353230313538372C3131353230323639302C3131353230333838362C3131353230343837392C3131353231383634392C3131353232303231322C3131353232303838302C3131353232323233372C3131353232393637382C3131353233303236382C3131353233313736392C3131353233393539312C3131353235343534302C3131353235353632322C3131353235373137362C3131353235383131382C3131353236373539322C3131353237303432312C3131353237303634342C3131353238383438322C3131353238393031352C3131353239303433322C3131353239313338392C3131353332313730302C3131353332353437392C3131353332383836382C3131353333383834312C3131353333393032352C,0x3131353139393136322C3131353139393731362C3131353230303830312C3131353230313431392C3131353230313634312C3131353230323835352C3131353230333935342C3131353230343935332C3131353231383730382C3131353232303238322C3131353232303935342C3131353232323334362C3131353232393737332C3131353233303435332C3131353233313833372C3131353233393635332C3131353235343634352C3131353235353732362C3131353235373239342C3131353235383138392C3131353236373637342C3131353237303438342C3131353237303730372C3131353238383539392C3131353238393132362C3131353239303532352C3131353239313436342C3131353332313736302C3131353332353635362C3131353332393031322C3131353333383933312C3131353333393531362C),
 (182,'SYCP1.cApr07','chr1','+',115198988,115339514,115199608,115339163,31,0x3131353139383938382C3131353139393538312C3131353230303731362C3131353230313337352C3131353230313538372C3131353230323639302C3131353230333838362C3131353230343837392C3131353231383634392C3131353232303231322C3131353232303838302C3131353232323233372C3131353232393637382C3131353233303236382C3131353233313736392C3131353233393539312C3131353235343534302C3131353235353632322C3131353235373137362C3131353235383131382C3131353236373539322C3131353237303432312C3131353237303634342C3131353238383438322C3131353238393031352C3131353239303433322C3131353239313338392C3131353332313730302C3131353332353437392C3131353333383834312C3131353333393032352C,0x3131353139393136322C3131353139393731362C3131353230303830312C3131353230313431392C3131353230313634312C3131353230323835352C3131353230333935342C3131353230343935332C3131353231383730382C3131353232303238322C3131353232303935342C3131353232323334362C3131353232393737332C3131353233303435332C3131353233313833372C3131353233393635332C3131353235343634352C3131353235353732362C3131353235373239342C3131353235383138392C3131353236373637342C3131353237303438342C3131353237303730372C3131353238383539392C3131353238393132362C3131353239303532352C3131353239313436342C3131353332313736302C3131353332353635362C3131353333383933312C3131353333393531342C),
 (182,'SYCP1.eApr07','chr1','+',115198994,115221026,115199608,115220963,10,0x3131353139383939342C3131353139393538342C3131353230303731362C3131353230313337352C3131353230323639302C3131353230333838362C3131353230343837392C3131353231383634392C3131353232303231322C3131353232303838302C,0x3131353139393136322C3131353139393731362C3131353230303830312C3131353230313431392C3131353230323835352C3131353230333935342C3131353230343935332C3131353231383730382C3131353232303238322C3131353232313032362C),
 (182,'SYCP1.bApr07','chr1','+',115199273,115339511,115199608,115339163,32,0x3131353139393237332C3131353139393538342C3131353230303731362C3131353230313337352C3131353230313538372C3131353230323639302C3131353230333838362C3131353230343837392C3131353231383634392C3131353232303231322C3131353232303838302C3131353232323233372C3131353232393637382C3131353233303236382C3131353233313736392C3131353233393539312C3131353235343534302C3131353235353632322C3131353235373232312C3131353235383131382C3131353236373539322C3131353237303432312C3131353237303634342C3131353238383438322C3131353238393031352C3131353239303433322C3131353239313338392C3131353332313730302C3131353332353437392C3131353332383836382C3131353333383834312C3131353333393032352C,0x3131353139393432352C3131353139393731362C3131353230303830312C3131353230313431392C3131353230313634312C3131353230323835352C3131353230333935342C3131353230343935332C3131353231383730382C3131353232303238322C3131353232303935342C3131353232323334362C3131353232393737332C3131353233303435332C3131353233313833372C3131353233393635332C3131353235343634352C3131353235353732362C3131353235373239342C3131353235383138392C3131353236373637342C3131353237303438342C3131353237303730372C3131353238383539392C3131353238393132362C3131353239303532352C3131353239313436342C3131353332313736302C3131353332353635362C3131353332393031322C3131353333383933312C3131353333393531312C),
 (183,'VANGL1.bApr07','chr1','+',115986077,116042370,115995557,116035523,8,0x3131353938363037372C3131353939353432302C3131363030333738342C3131363030373830342C3131363032363530372C3131363032383038372C3131363032393433362C3131363033353236322C,0x3131353938363233302C3131353939353632382C3131363030333931372C3131363030383431322C3131363032363634312C3131363032383232302C3131363032393637312C3131363034323337302C);
INSERT INTO `aceview_hg18_housekeeping` (`bin`,`name`,`chrom`,`strand`,`txStart`,`txEnd`,`cdsStart`,`cdsEnd`,`exonCount`,`exonStarts`,`exonEnds`) VALUES 
 (183,'VANGL1.cApr07','chr1','+',115986134,116035547,115995557,116035523,8,0x3131353938363133342C3131353939353432302C3131363030333738342C3131363030373830342C3131363032363530372C3131363032383038372C3131363032393433362C3131363033353236322C,0x3131353938363233302C3131353939353632382C3131363030333931312C3131363030383431322C3131363032363634312C3131363032383232302C3131363032393637312C3131363033353534372C),
 (183,'VANGL1.aApr07','chr1','+',115986772,116035580,115995557,116035523,8,0x3131353938363737322C3131353939353432302C3131363030333738342C3131363030373830342C3131363032363530372C3131363032383038372C3131363032393433362C3131363033353236322C,0x3131353938363835302C3131353939353632382C3131363030333931372C3131363030383431322C3131363032363634312C3131363032383232302C3131363032393637312C3131363033353538302C),
 (183,'VANGL1.dApr07','chr1','+',115995510,116008912,115995512,116008416,3,0x3131353939353531302C3131363030333738342C3131363030373830342C,0x3131353939353632382C3131363030333931372C3131363030383931322C),
 (183,'CASQ2.cApr07','chr1','-',116082448,116137338,116082530,116112595,5,0x3131363038323434382C3131363038343837312C3131363038383937312C3131363131323435312C3131363133373037362C,0x3131363038323533332C3131363038343937322C3131363038393035362C3131363131323633322C3131363133373333382C),
 (184,'LOC148766.bApr07','chr1','-',116767868,116822953,116768036,116822952,4,0x3131363736373836382C3131363737323532362C3131363832323139362C3131363832323932352C,0x3131363736383036302C3131363737323633392C3131363832323331372C3131363832323935332C),
 (184,'baporbo.dApr07','chr1','+',116810373,116918153,0,0,3,0x3131363831303337332C3131363837343533332C3131363931373935382C,0x3131363831303433362C3131363837343637322C3131363931383135332C),
 (184,'C1orf137.aApr07','chr1','+',117038256,117050748,117038256,117050677,4,0x3131373033383235362C3131373033383930332C3131373035303039332C3131373035303630312C,0x3131373033383334322C3131373033393030302C3131373035303134392C3131373035303734382C),
 (184,'PTGFRN.aApr07','chr1','+',117254068,117334503,117254138,117331112,9,0x3131373235343036382C3131373238353835392C3131373238383832332C3131373239333333362C3131373330353338372C3131373331313035352C3131373331383336302C3131373332383832342C3131373333303934352C,0x3131373235343339372C3131373238363232382C3131373238393233372C3131373239333731372C3131373330353831332C3131373331313437352C3131373331383436382C3131373332393133302C3131373333343530332C),
 (184,'PTGFRN.bApr07','chr1','+',117305711,117312518,117305713,117311486,2,0x3131373330353731312C3131373331313035352C,0x3131373330353831332C3131373331323531382C),
 (185,'MAN1A2.aApr07','chr1','+',117711538,117873017,117712328,117867102,13,0x3131373731313533382C3131373734363333302C3131373734393639332C3131373735383835372C3131373736343731332C3131373738363337352C3131373830343633332C3131373831303437382C3131373833373239312C3131373834303930372C3131373834333532362C3131373834363939392C3131373836363936392C,0x3131373731323633302C3131373734363538362C3131373734393739302C3131373735383937362C3131373736343739342C3131373738363437302C3131373830343735372C3131373831303537322C3131373833373430372C3131373834313132372C3131373834333639392C3131373834373131352C3131373837333031372C),
 (185,'MAN1A2.bApr07','chr1','+',117712087,117867780,117712605,117867402,12,0x3131373731323038372C3131373735383835372C3131373736343731332C3131373738363337352C3131373830343633332C3131373831303437382C3131373833373239312C3131373834303930372C3131373834333532362C3131373834363939392C3131373836363936392C3131373836373339342C,0x3131373731323633302C3131373735383937362C3131373736343739342C3131373738363437302C3131373830343735372C3131373831303537322C3131373833373430372C3131373834313132372C3131373834333639392C3131373834373131352C3131373836373038322C3131373836373738302C),
 (185,'MAN1A2.cApr07','chr1','+',117764741,117860084,117786453,117858997,9,0x3131373736343734312C3131373738363337352C3131373830343633332C3131373831303437382C3131373833373239312C3131373834303930372C3131373834333532362C3131373834363939392C3131373835383939332C,0x3131373736343739342C3131373738363437302C3131373830343735372C3131373831303537322C3131373833373430372C3131373834313132372C3131373834333639392C3131373834373131352C3131373836303038342C),
 (185,'FAM46CandWDR3.bApr07','chr1','+',117950076,117972535,117950076,117968189,2,0x3131373935303037362C3131373936363938362C,0x3131373935303239382C3131373937323533352C),
 (185,'FAM46CandWDR3.iApr07','chr1','+',117950197,118278719,118277465,118278717,4,0x3131373935303139372C3131383231303431352C3131383237373433332C3131383237383631382C,0x3131373935303239382C3131383231303536352C3131383237373633362C3131383237383731392C),
 (185,'FAM46CandWDR3.hApr07','chr1','+',117950943,117967377,117967013,117967376,2,0x3131373935303934332C3131373936363938362C,0x3131373935313133382C3131373936373337372C),
 (185,'GDAP2.aApr07','chr1','-',118213558,118274187,118214713,118264503,14,0x3131383231333535382C3131383232323135332C3131383232353936372C3131383232373633322C3131383233303732312C3131383233313834322C3131383234303937372C3131383234333230312C3131383235303635302C3131383235363133382C3131383235363637342C3131383236323734312C3131383236343332372C3131383237333539332C,0x3131383231343736312C3131383232323239372C3131383232363032322C3131383232373737322C3131383233303739382C3131383233313931392C3131383234313133342C3131383234333336312C3131383235303732372C3131383235363232372C3131383235363832382C3131383236323838312C3131383236343537302C3131383237343138372C),
 (185,'GDAP2.cApr07','chr1','-',118214328,118273757,118214713,118264503,14,0x3131383231343332382C3131383232313932302C3131383232323135332C3131383232353936372C3131383232373633322C3131383233303732312C3131383233313834322C3131383234333332352C3131383235303635302C3131383235363133382C3131383235363637342C3131383236323734312C3131383236343332372C3131383237333539332C,0x3131383231343736312C3131383232313938362C3131383232323239372C3131383232363032322C3131383232373737322C3131383233303739382C3131383233313837382C3131383234333336312C3131383235303732372C3131383235363232372C3131383235363832382C3131383236323838312C3131383236343537302C3131383237333735372C),
 (185,'GDAP2.bApr07','chr1','-',118220600,118273743,118222108,118264503,13,0x3131383232303630302C3131383232353936372C3131383232373633322C3131383233303732312C3131383233313834322C3131383234303937372C3131383234333230312C3131383235303635302C3131383235363133382C3131383235363637342C3131383236323734312C3131383236343332372C3131383237333539332C,0x3131383232323239372C3131383232363032322C3131383232373737322C3131383233303739382C3131383233313931392C3131383234313133342C3131383234333336312C3131383235303732372C3131383235363232372C3131383235363832382C3131383236323838312C3131383236343537302C3131383237333734332C),
 (185,'SPAG17.gApr07','chr1','-',118298007,118425632,118383569,118399984,11,0x3131383239383030372C3131383239393233332C3131383330373934342C3131383331303735342C3131383338303939332C3131383338333433372C3131383338353934382C3131383339383134372C3131383339393837382C3131383432353234362C3131383432353536302C,0x3131383239383139352C3131383239393337362C3131383330383038342C3131383331303832392C3131383338313032392C3131383338333539302C3131383338363138382C3131383339383233392C3131383430303036302C3131383432353436352C3131383432353633322C),
 (185,'SPAG17.bApr07','chr1','-',118298007,118381013,118307944,118380925,26,0x3131383239383030372C3131383330373933392C3131383331303735342C3131383331343230312C3131383331363030382C3131383331373537302C3131383332353431352C3131383332373935362C3131383332383832382C3131383333313937392C3131383333323235302C3131383333353030362C3131383333353536302C3131383333363631312C3131383333383535312C3131383334303531352C3131383334303734332C3131383334393535392C3131383335323138392C3131383335363337332C3131383336303131302C3131383336373434392C3131383336393338332C3131383337323431392C3131383337353833372C3131383338303931352C,0x3131383239383139352C3131383330383038342C3131383331303839392C3131383331343236322C3131383331363139332C3131383331373730372C3131383332353534372C3131383332383035392C3131383332383932382C3131383333323032372C3131383333323335302C3131383333353035322C3131383333353637342C3131383333363739342C3131383333383637362C3131383334303634362C3131383334303838392C3131383334393734382C3131383335323334342C3131383335363531382C3131383336303332382C3131383336373630392C3131383336393536322C3131383337323534302C3131383337363031332C3131383338313031332C),
 (186,'TBX15.aApr07','chr1','-',119227188,119333701,119228877,119333591,8,0x3131393232373138382C3131393234333137332C3131393235383236302C3131393236373538312C3131393236383739312C3131393237303635352C3131393237353736342C3131393333333530302C,0x3131393232393636322C3131393234333237312C3131393235383332352C3131393236373734392C3131393236383936332C3131393237303735372C3131393237353937382C3131393333333730312C),
 (186,'WARS2.aApr07','chr1','-',119374441,119484812,119377056,119484790,6,0x3131393337343434312C3131393337383234302C3131393338363430392C3131393338393732372C3131393432303439352C3131393438343730302C,0x3131393337373530352C3131393337383335392C3131393338363439352C3131393338393830382C3131393432303735332C3131393438343831322C),
 (186,'WARS2.cApr07','chr1','-',119375361,119484812,119377505,119484790,6,0x3131393337353336312C3131393337383234302C3131393338363430392C3131393338393732372C3131393432303439352C3131393438343730302C,0x3131393337373533342C3131393337383335392C3131393338363439352C3131393338393830382C3131393432303735332C3131393438343831322C),
 (186,'WARS2.hApr07','chr1','-',119377157,119484765,119377474,119484763,5,0x3131393337373135372C3131393337383234302C3131393338393732372C3131393432303636362C3131393438343730302C,0x3131393337373530352C3131393337383335392C3131393338393830382C3131393432303735332C3131393438343736352C),
 (186,'WARS2.bApr07','chr1','-',119377192,119484792,119377194,119484790,6,0x3131393337373139322C3131393337383234302C3131393338363430392C3131393338393732372C3131393432303636362C3131393438343730302C,0x3131393337373530352C3131393337383335392C3131393338363439352C3131393338393830382C3131393432303735332C3131393438343739322C),
 (186,'WARS2.dApr07','chr1','-',119377442,119484808,119377474,119484790,5,0x3131393337373434322C3131393337383234302C3131393338393732372C3131393432303439352C3131393438343730302C,0x3131393337373530352C3131393337383335392C3131393338393830382C3131393432303735332C3131393438343830382C),
 (186,'WARS2.eApr07','chr1','-',119378274,119426692,119378274,119426521,5,0x3131393337383237342C3131393338363430392C3131393338393732372C3131393432303439352C3131393432363438352C,0x3131393337383335392C3131393338363439352C3131393338393830382C3131393432303735332C3131393432363639322C),
 (186,'WARS2.gApr07','chr1','-',119378315,119484809,119378316,119420744,5,0x3131393337383331352C3131393338363430392C3131393338393732372C3131393432303439352C3131393438343730302C,0x3131393337383335392C3131393338363439352C3131393338393830382C3131393432303734392C3131393438343830392C),
 (186,'WARS2.fApr07','chr1','-',119386362,119484792,119386405,119484790,4,0x3131393338363336322C3131393338393732372C3131393432303439352C3131393438343730302C,0x3131393338363439352C3131393338393830382C3131393432303735332C3131393438343739322C),
 (186,'WARS2.jApr07','chr1','-',119389772,119484798,119389772,119420744,4,0x3131393338393737322C3131393432303439352C3131393438343431332C3131393438343730302C,0x3131393338393830382C3131393432303735332C3131393438343630342C3131393438343739382C),
 (186,'bermawbu.aApr07','chr1','+',119391551,119408931,119407493,119408015,2,0x3131393339313535312C3131393430363939392C,0x3131393339313637382C3131393430383933312C),
 (187,'smorkubo.aApr07','chr1','-',119603625,119671449,0,0,3,0x3131393630333632352C3131393633383137312C3131393637313130382C,0x3131393630343832352C3131393633383331332C3131393637313434392C),
 (187,'PHGDH.fApr07','chr1','+',120003944,120088359,120065462,120088186,9,0x3132303030333934342C3132303031333333362C3132303036353331352C3132303036373532312C3132303037303939362C3132303037313134392C3132303037383737392C3132303038363938332C3132303038383033312C,0x3132303030343035392C3132303031333534372C3132303036353436372C3132303036373538372C3132303037313035312C3132303037313234382C3132303037383832322C3132303038373139302C3132303038383335392C),
 (187,'PHGDH.aApr07','chr1','+',120052701,120088364,120056168,120088186,13,0x3132303035323730312C3132303035353838322C3132303036353331352C3132303036373532312C3132303037303939362C3132303037313134392C3132303037383737392C3132303037393434302C3132303038313235392C3132303038343533312C3132303038353931322C3132303038363935322C3132303038383033312C,0x3132303035323734362C3132303035363330362C3132303036353436372C3132303036373538372C3132303037313035312C3132303037313234382C3132303037383931322C3132303037393538392C3132303038313431322C3132303038343636342C3132303038363034332C3132303038373139302C3132303038383336342C),
 (187,'PHGDH.oApr07','chr1','+',120056025,120065641,120056168,120065471,2,0x3132303035363032352C3132303036353331352C,0x3132303035363330362C3132303036353634312C),
 (187,'PHGDH.lApr07','chr1','+',120056051,120073778,120056168,120068606,7,0x3132303035363035312C3132303036353331352C3132303036373532312C3132303036383436342C3132303037303939362C3132303037313134392C3132303037333635342C,0x3132303035363330362C3132303036353436372C3132303036373538372C3132303036383631352C3132303037313035312C3132303037313234382C3132303037333737382C),
 (187,'PHGDH.mApr07','chr1','+',120056082,120071021,120056168,120068946,5,0x3132303035363038322C3132303036353331352C3132303036373532312C3132303036383933302C3132303037303939362C,0x3132303035363330362C3132303036353436372C3132303036373538372C3132303036393032312C3132303037313032312C),
 (187,'PHGDH.gApr07','chr1','+',120056083,120088360,120065462,120088160,9,0x3132303035363038332C3132303036353431322C3132303036373532312C3132303037303939362C3132303037313134392C3132303037383737392C3132303037393434302C3132303038313235392C3132303038383033312C,0x3132303035363330362C3132303036353436372C3132303036373538372C3132303037313035312C3132303037313234382C3132303037383931322C3132303037393538392C3132303038313431322C3132303038383336302C),
 (187,'PHGDH.bApr07','chr1','+',120056085,120088332,120056168,120088186,12,0x3132303035363038352C3132303036353331352C3132303036373532312C3132303037303939362C3132303037313134392C3132303037383737392C3132303037393434302C3132303038313235392C3132303038343533312C3132303038353931322C3132303038363935322C3132303038383033312C,0x3132303035363330362C3132303036353436372C3132303036373538372C3132303037313035312C3132303037313234382C3132303037383931322C3132303037393538392C3132303038313430392C3132303038343636342C3132303038363034332C3132303038373139302C3132303038383333322C),
 (187,'PHGDH.dApr07','chr1','+',120056086,120088359,120065462,120088186,12,0x3132303035363038362C3132303036353430312C3132303036373532312C3132303037303939362C3132303037313134392C3132303037383737392C3132303037393434302C3132303038313235392C3132303038343533312C3132303038353931322C3132303038363935322C3132303038383033312C,0x3132303035363330362C3132303036353436372C3132303036373538372C3132303037313035312C3132303037313234382C3132303037383931322C3132303037393538392C3132303038313431322C3132303038343636342C3132303038363032322C3132303038373139302C3132303038383335392C),
 (187,'PHGDH.hApr07','chr1','+',120056106,120071409,120056168,120071380,5,0x3132303035363130362C3132303036353331352C3132303036373532312C3132303037303939362C3132303037313134392C,0x3132303035363330362C3132303036353436372C3132303036373538372C3132303037313035312C3132303037313430392C),
 (187,'PHGDH.eApr07','chr1','+',120056108,120088341,120056168,120088186,10,0x3132303035363130382C3132303036353331352C3132303036373532312C3132303037303939362C3132303037313134392C3132303037383737392C3132303037393434302C3132303038313235392C3132303038343533312C3132303038383033312C,0x3132303035363330362C3132303036353436372C3132303036373538372C3132303037313035312C3132303037313234382C3132303037383931322C3132303037393538392C3132303038313431322C3132303038343636342C3132303038383334312C),
 (187,'PHGDH.iApr07','chr1','+',120057244,120074217,120057462,120073771,7,0x3132303035373234342C3132303036353331352C3132303036373532312C3132303037303939362C3132303037313134392C3132303037333635342C3132303037343038352C,0x3132303035373630362C3132303036353436372C3132303036373538372C3132303037313035312C3132303037313234382C3132303037333737392C3132303037343231372C),
 (187,'NOTCH2.aApr07','chr1','-',120255698,120413839,120259451,120413825,34,0x3132303235353639382C3132303236313831302C3132303236323535312C3132303236333435372C3132303236343337342C3132303236353835382C3132303236363338312C3132303236363738312C3132303236373738322C3132303236393435302C3132303237303634342C3132303237333132312C3132303237393631372C3132303238313432372C3132303238323030322C3132303238343730302C3132303238353637312C3132303239323535392C3132303239333135322C3132303239343836392C3132303239373638382C3132303239393138352C3132303330333533372C3132303330373731392C3132303330393539382C3132303331303532312C3132303331313537382C3132303331323232322C3132303331333635362C3132303333313130352C3132303334313134322C3132303334393437342C3132303337343035312C3132303431333437302C,0x3132303236303834302C3132303236313930382C3132303236323639392C3132303236333735392C3132303236343534332C3132303236353935352C3132303236363539322C3132303236363932342C3132303236383133302C3132303236393935362C3132303237303735372C3132303237333335382C3132303237393735302C3132303238313631322C3132303238323135362C3132303238343930322C3132303238353930302C3132303239323731322C3132303239333237322C3132303239343938332C3132303239373833342C3132303239393337382C3132303330333634382C3132303330373935332C3132303330393731322C3132303331303633352C3132303331313736372C3132303331323337382C3132303331333839302C3132303333313232382C3132303334313437382C3132303334393733342C3132303337343133332C3132303431333833392C),
 (187,'NOTCH2.bApr07','chr1','-',120279258,120413789,120279564,120413789,22,0x3132303237393235382C3132303238313432372C3132303238323030322C3132303238343730302C3132303238353637312C3132303239323535392C3132303239333135322C3132303239343836392C3132303239373638382C3132303239393138352C3132303330333533372C3132303330373731392C3132303330393539382C3132303331303532312C3132303331313537382C3132303331323232322C3132303331333635362C3132303333313130352C3132303334313134322C3132303334393437342C3132303337343035312C3132303431333437302C,0x3132303237393735302C3132303238313631322C3132303238323135362C3132303238343930322C3132303238353930302C3132303239323731322C3132303239333237322C3132303239343938332C3132303239373833342C3132303239393337382C3132303330333634382C3132303330373935332C3132303330393731322C3132303331303633352C3132303331313736372C3132303331323337382C3132303331333839302C3132303333313232382C3132303334313437382C3132303334393733342C3132303337343133332C3132303431333738392C),
 (188,'HIST2H2BA.cApr07','chr1','+',120707550,120717631,120707742,120716246,3,0x3132303730373535302C3132303731363233362C3132303731363839322C,0x3132303730373934322C3132303731363539362C3132303731373633312C),
 (188,'HIST2H2BA.bApr07-unspliced','chr1','+',120716942,120717630,120717358,120717598,1,0x3132303731363934322C,0x3132303731373633302C),
 (188,'klorbey.aApr07','chr1','+',120840135,120906503,120840465,120903467,2,0x3132303834303133352C3132303930333339352C,0x3132303834303638372C3132303930363530332C),
 (188,'LOC647121.bApr07','chr1','+',120962433,121015209,121007975,121012114,8,0x3132303936323433332C3132303939393833302C3132313030303235312C3132313030353534382C3132313030373935372C3132313030393038342C3132313031313436372C3132313031323039362C,0x3132303936323738302C3132313030303031372C3132313030303334302C3132313030353637362C3132313030383233342C3132313030393131382C3132313031313532322C3132313031353230392C),
 (188,'LOC647121.aApr07','chr1','+',120962453,120999995,120962496,120999994,3,0x3132303936323435332C3132303938313634332C3132303939393833302C,0x3132303936323738302C3132303938313734312C3132303939393939352C),
 (208,'taseyo.bApr07','chr1','-',141726803,141832470,141830272,141832468,3,0x3134313732363830332C3134313833303236312C3134313833323235322C,0x3134313732373039382C3134313833303332302C3134313833323437302C),
 (208,'taseyo.eApr07','chr1','-',141744601,141832544,0,0,5,0x3134313734343630312C3134313735313738322C3134313735373433392C3134313833303236312C3134313833313733362C,0x3134313734363838342C3134313735313832372C3134313735373532372C3134313833303332302C3134313833323534342C),
 (208,'taseyo.fApr07','chr1','-',141744752,141830320,0,0,4,0x3134313734343735322C3134313734363631362C3134313735373433392C3134313833303236312C,0x3134313734363133322C3134313734363838342C3134313735373532372C3134313833303332302C),
 (208,'taseyo.dApr07','chr1','-',141746592,141832536,141830272,141832471,3,0x3134313734363539322C3134313833303236312C3134313833323333362C,0x3134313734363839392C3134313833303332302C3134313833323533362C),
 (208,'taseyo.kApr07','chr1','-',141746616,141832544,0,0,4,0x3134313734363631362C3134313735373433392C3134313833303236312C3134313833323333362C,0x3134313734363838342C3134313735373532372C3134313833303332302C3134313833323534342C),
 (208,'taseyo.cApr07','chr1','-',141746617,141832499,141831892,141832471,4,0x3134313734363631372C3134313833303236312C3134313833313836302C3134313833323333362C,0x3134313734363838342C3134313833303332302C3134313833313935352C3134313833323439392C),
 (208,'taseyo.hApr07','chr1','-',141788732,141832544,0,0,6,0x3134313738383733322C3134313739303732322C3134313832363236382C3134313833303236312C3134313833313733362C3134313833323435392C,0x3134313738393533322C3134313739303832342C3134313832363332382C3134313833303332302C3134313833313932392C3134313833323534342C),
 (208,'tiseyo.bApr07','chr1','+',142062155,142099047,0,0,5,0x3134323036323135352C3134323037323831362C3134323037343632332C3134323037363739382C3134323039353339392C,0x3134323036323234342C3134323037333038342C3134323037343635392C3134323037363835342C3134323039393034372C),
 (208,'kloyrobo.aApr07','chr1','-',142197979,142224403,0,0,2,0x3134323139373937392C3134323232343332322C,0x3134323139383631332C3134323232343430332C),
 (208,'LOC727820.tApr07','chr1','-',142439305,142535876,0,0,4,0x3134323433393330352C3134323530343938392C3134323531313236392C3134323533353732332C,0x3134323433393535332C3134323530353037332C3134323531313335362C3134323533353837362C),
 (208,'LOC727820.bApr07','chr1','-',142454298,142535916,142455225,142535916,2,0x3134323435343239382C3134323533353732332C,0x3134323435353731392C3134323533353931362C),
 (209,'LOC647135.aApr07','chr1','+',142625135,142805834,142627582,142805811,5,0x3134323632353133352C3134323632373033392C3134323732353235372C3134323736343836322C3134323830353731382C,0x3134323632353236322C3134323632373634392C3134323732353435302C3134323736353032352C3134323830353833342C),
 (209,'LOC647135.bApr07','chr1','+',142636107,142805771,142725283,142805769,5,0x3134323633363130372C3134323731383830372C3134323732353235372C3134323736343836322C3134323830353731382C,0x3134323633363231302C3134323731383835372C3134323732353435302C3134323736353032352C3134323830353737312C),
 (209,'LOC647135.eApr07','chr1','+',142725172,142764879,142725283,142760084,3,0x3134323732353137322C3134323736303036352C3134323736343836322C,0x3134323732353435302C3134323736303132362C3134323736343837392C),
 (209,'LOC728841.aApr07','chr1','+',142858158,142878238,142858158,142878238,19,0x3134323835383135382C3134323836303134362C3134323836313038332C3134323836323333382C3134323836323837352C3134323836343336392C3134323836383332382C3134323836393533342C3134323837303232372C3134323837313131392C3134323837313737312C3134323837323635332C3134323837333335372C3134323837343234342C3134323837343938332C3134323837353837352C3134323837363532372C3134323837373430392C3134323837383131372C,0x3134323835383337382C3134323836303234392C3134323836313239382C3134323836323431312C3134323836333038312C3134323836343432312C3134323836383439322C3134323836393538362C3134323837303430302C3134323837313137312C3134323837313934342C3134323837323730352C3134323837333533302C3134323837343335332C3134323837353135362C3134323837353932372C3134323837363730302C3134323837373436312C3134323837383233382C),
 (209,'LOC728841.dApr07','chr1','+',142863022,142876676,142863023,142876675,7,0x3134323836333032322C3134323836343336392C3134323836383332382C3134323836393533342C3134323837343938332C3134323837353837352C3134323837363532372C,0x3134323836333038312C3134323836343432312C3134323836383439322C3134323836393538362C3134323837353135362C3134323837353932372C3134323837363637362C),
 (209,'feyboy.aApr07','chr1','-',142991739,143001337,0,0,5,0x3134323939313733392C3134323939323038362C3134323939323432322C3134323939353937382C3134333030313135332C,0x3134323939313938362C3134323939323232352C3134323939323534372C3134323939363231342C3134333030313333372C),
 (209,'derneybo.aApr07','chr1','-',143256306,143279289,0,0,4,0x3134333235363330362C3134333235373531372C3134333237303838312C3134333237393138392C,0x3134333235363636392C3134333235373637312C3134333237303935342C3134333237393238392C),
 (209,'LOC653513.aApr07','chr1','-',143386662,143417015,143388226,143416879,4,0x3134333338363636322C3134333338383539352C3134333339313234392C3134333431363832322C,0x3134333338383430362C3134333338383731392C3134333339313332362C3134333431373031352C),
 (209,'DUF1220.1.aApr07','chr1','+',143523094,143541665,143523094,143540141,15,0x3134333532333039342C3134333532353039382C3134333532363033362C3134333532373239322C3134333532373832392C3134333532393332322C3134333533333237372C3134333533343438342C3134333533353136392C3134333533363036312C3134333533363730392C3134333533373539312C3134333533383238392C3134333533393137362C3134333533393839372C,0x3134333532333331342C3134333532353230312