/*
 * Decompiled with CFR 0.152.
 */
package GInMiR;

import DeepBowtieAligner.DeepBowtieAligner;
import GInMiR.ButtonEditor;
import GInMiR.ButtonRenderer;
import GInMiR.found_miR_details;
import GInMiR.loci_cmp;
import GInMiR.mapping_identifying;
import RNAfold.RNAfigure;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableRowSorter;
import loci.loci;
import net.sf.picard.fastq.FastqReader;
import net.sf.picard.fastq.FastqRecord;
import net.sf.samtools.SAMUtils;

public class GInMiR
extends JFrame
implements PropertyChangeListener {
    JTextField jTextField1;
    JTextField jTextField2;
    JTextField jTextField3;
    JTextField jTextField4;
    JTextField jTextField5;
    JTextField jTextField6;
    JTextField jTextField7;
    JTextField jTextField8;
    JButton jButton1;
    JButton jButton2;
    JComboBox jComboBox1;
    JCheckBox jCheckBox1;
    static JTable jTable1;
    static JLabel jLabel3;
    JProgressBar jProgressBar;
    String assembly;
    String fileName;
    String inputFileName;
    String inputfile_extend;
    String adapter_seq;
    int max_rep = 5;
    int minLenMiR = 18;
    int maxLenMiR = 23;
    int minPhred_quality = 20;
    double min_score = 0.0;
    int min_numReads = 5;
    String dir = ".";
    static ArrayList<found_miR_details> miR_details;

    public GInMiR() {
        this.InitComponent();
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        JFileChooser jfc = new JFileChooser();
        jfc.setCurrentDirectory(new File(this.dir));
        jfc.setFileFilter(new FileFilter(){

            public boolean accept(File f) {
                return f.getName().toLowerCase().endsWith(".result") || f.getName().toLowerCase().endsWith(".fastq") || f.getName().toLowerCase().endsWith(".sam") || f.getName().toLowerCase().endsWith(".bam") || f.isDirectory();
            }

            public String getDescription() {
                return "fastq Files";
            }
        });
        if (jfc.showOpenDialog(this) == 0) {
            this.jButton1.setEnabled(false);
            File file = jfc.getSelectedFile();
            this.dir = file.getParent();
            this.inputFileName = file.getAbsolutePath();
            this.jTextField8.setText(file.getAbsolutePath());
            this.jButton1.setEnabled(this.rootPaneCheckingEnabled);
            this.fileName = this.inputFileName.substring(0, this.inputFileName.lastIndexOf(46));
            this.inputfile_extend = this.inputFileName.substring(this.inputFileName.lastIndexOf(46) + 1);
        }
    }

    private boolean file_extend_legal(String extend) {
        if (extend.equalsIgnoreCase("result")) {
            return true;
        }
        if (extend.equalsIgnoreCase("fastq")) {
            return true;
        }
        if (extend.equalsIgnoreCase("sam")) {
            return true;
        }
        return extend.equalsIgnoreCase("bam");
    }

    private void jButton2ActionPerformed(ActionEvent evt) throws IOException {
        this.assembly = (String)this.jComboBox1.getSelectedItem();
        this.adapter_seq = this.jTextField1.getText().toUpperCase();
        if (!this.adapter_seq.replace("A", "").replace("C", "").replace("T", "").replace("G", "").isEmpty()) {
            JOptionPane.showMessageDialog(null, "Adapter is not nucleotide sequence (A,C,G,T)");
            return;
        }
        if (!this.isInteger(this.jTextField2.getText()) || !this.isInteger(this.jTextField3.getText())) {
            JOptionPane.showMessageDialog(null, "length is not a number");
            return;
        }
        this.minLenMiR = Integer.parseInt(this.jTextField2.getText());
        if (this.minLenMiR < 15 || this.minLenMiR > 20) {
            JOptionPane.showMessageDialog(null, "minimum length of miR should be around 18");
            return;
        }
        this.maxLenMiR = Integer.parseInt(this.jTextField3.getText());
        if (this.maxLenMiR < 20 || this.maxLenMiR > 25) {
            JOptionPane.showMessageDialog(null, "maximum length of miR should be around 23");
            return;
        }
        if (!this.isInteger(this.jTextField4.getText())) {
            JOptionPane.showMessageDialog(null, "quality is not a number");
            return;
        }
        this.minPhred_quality = Integer.parseInt(this.jTextField4.getText());
        if (!this.isInteger(this.jTextField5.getText())) {
            JOptionPane.showMessageDialog(null, "the number of max multiple mapping is not a number");
            return;
        }
        this.max_rep = Integer.parseInt(this.jTextField5.getText());
        if (!this.isInteger(this.jTextField6.getText())) {
            JOptionPane.showMessageDialog(null, "the min number of reads for a miRNA is not a number");
            return;
        }
        this.min_numReads = Integer.parseInt(this.jTextField6.getText());
        if (!this.isInteger(this.jTextField7.getText())) {
            JOptionPane.showMessageDialog(null, "the score is not a number");
            return;
        }
        this.min_score = Double.parseDouble(this.jTextField7.getText());
        if (this.jTextField8.getText().isEmpty()) {
            JOptionPane.showMessageDialog(null, "input file is empty");
            return;
        }
        this.clear_jTable();
        this.jProgressBar.setIndeterminate(true);
        if (this.file_extend_legal(this.inputfile_extend)) {
            if (this.inputfile_extend.equalsIgnoreCase("fastq")) {
                this.remove_unlikely_reads_fastq();
            }
            this.call_thread();
        } else {
            JOptionPane.showMessageDialog(null, "wrong file format");
        }
    }

    private void clear_jTable() {
        DefaultTableModel model_novel = (DefaultTableModel)jTable1.getModel();
        model_novel.getDataVector().removeAllElements();
    }

    public boolean isInteger(String input) {
        try {
            Integer.parseInt(input);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static void show_hairPin(String miR_ID) {
        for (found_miR_details fmd : miR_details) {
            if (!fmd.miR.equalsIgnoreCase(miR_ID)) continue;
            String seq = fmd.hairPin_seq;
            loci mature_offset = new loci(fmd.offset(fmd.mature));
            int numTrueReads = 0;
            for (int i = 0; i < fmd.reads.length; ++i) {
                if (!fmd.hairPin.contain(fmd.reads[i])) continue;
                ++numTrueReads;
            }
            loci[] new_reads = new loci[numTrueReads];
            int numReads = 0;
            for (int i = 0; i < fmd.reads.length; ++i) {
                if (!fmd.hairPin.contain(fmd.reads[i])) continue;
                new_reads[numReads] = fmd.offset(fmd.reads[i]);
                new_reads[numReads].setloci_start(new_reads[numReads].getstart_loci() + 1);
                new_reads[numReads].setloci_stop(new_reads[numReads].getstop_loci() + 1);
                ++numReads;
            }
            loci mature = new loci("", mature_offset.getstart_loci() + 1, mature_offset.getstop_loci() + 1);
            RNAfigure frame = new RNAfigure(seq, fmd.hairPin_struct, mature, new_reads, miR_ID, new Dimension(800, 600));
            frame.setSize(800, 800);
            frame.setVisible(true);
        }
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if ("progress" == evt.getPropertyName()) {
            int progress = (Integer)evt.getNewValue();
            this.jProgressBar.setValue(progress);
            if (progress == 0) {
                this.jProgressBar.setIndeterminate(true);
            } else {
                this.jProgressBar.setIndeterminate(false);
            }
            if (progress == 100) {
                this.jButton2.setEnabled(true);
                this.setCursor(null);
            }
        }
    }

    private void call_thread() {
        this.jButton2.setEnabled(false);
        this.setCursor(Cursor.getPredefinedCursor(3));
        mapping_identifying mp = new mapping_identifying(this.assembly, this.adapter_seq, this.inputFileName, this.max_rep, this.min_numReads, this.min_score, this.jCheckBox1.isSelected());
        mp.addPropertyChangeListener(this);
        mp.execute();
    }

    private void remove_unlikely_reads_fasta() throws FileNotFoundException, IOException {
        String line;
        File fastaname = new File(this.fileName + ".fa");
        File fastaname1 = new File(this.fileName + ".purify.fa");
        BufferedReader br = new BufferedReader(new FileReader(fastaname));
        BufferedWriter bw = new BufferedWriter(new FileWriter(fastaname1));
        String header = br.readLine();
        while ((line = br.readLine()) != null) {
            if (line.indexOf(78) >= 0 || line.indexOf(110) >= 0) {
                header = br.readLine();
                continue;
            }
            if (line.length() <= this.maxLenMiR && line.length() >= this.minLenMiR) {
                bw.write(header + "\n");
                bw.write(line + "\n");
            }
            header = br.readLine();
        }
        br.close();
        bw.close();
    }

    private void remove_unlikely_reads_fastq() throws FileNotFoundException, IOException {
        File fastqname = new File(this.fileName + ".fastq");
        FastqReader fr = new FastqReader(fastqname.getAbsoluteFile());
        int rec_no = 0;
        TreeMap<String, Integer> reads = new TreeMap<String, Integer>();
        DeepBowtieAligner DeepBowtieAligner2 = new DeepBowtieAligner(this.assembly, this.adapter_seq);
        while (fr.hasNext()) {
            ++rec_no;
            FastqRecord fq_rec = fr.next();
            String pure_read = DeepBowtieAligner2.removeAdapter(fq_rec.getReadString());
            if (pure_read.indexOf(78) >= 0 || pure_read.indexOf(110) >= 0 || this.average_phred(fq_rec.getBaseQualityString()) <= (double)this.minPhred_quality) continue;
            fq_rec.getBaseQualityString();
            int pure_len = pure_read.length();
            String pure_quality = fq_rec.getBaseQualityString().substring(0, pure_len);
            if (pure_len > this.maxLenMiR || pure_len < this.minLenMiR) continue;
            FastqRecord fq_rec1 = new FastqRecord(fq_rec.getReadHeader(), pure_read, "", pure_quality);
            if (reads.get(fq_rec1.getReadString()) == null) {
                reads.put(fq_rec1.getReadString(), 1);
                continue;
            }
            reads.put(fq_rec1.getReadString(), (Integer)reads.get(fq_rec1.getReadString()) + 1);
        }
        BufferedWriter bw = new BufferedWriter(new FileWriter(this.fileName + ".purify.fa"));
        rec_no = 0;
        for (String key : reads.keySet()) {
            bw.write(">t" + ++rec_no + "\t" + reads.get(key) + "\n");
            bw.write(key + "\n");
        }
        bw.close();
    }

    private double average_phred(String Quality_str) {
        byte[] phred = SAMUtils.fastqToPhred(Quality_str);
        double total_phred = 0.0;
        for (int i = 0; i < phred.length; ++i) {
            total_phred += (double)phred[i];
        }
        return total_phred / (double)phred.length;
    }

    public static void main(String[] args) {
        try {
            GInMiR frame = new GInMiR();
            frame.setVisible(true);
        }
        catch (Exception ex) {
            Logger.getLogger(GInMiR.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void jComboBox1ActionPerformed(ActionEvent evt) {
    }

    private void InitComponent() {
        this.setSize(900, 500);
        this.setDefaultCloseOperation(3);
        JPanel jPanel1 = new JPanel();
        Box vbox1 = Box.createVerticalBox();
        Box hbox0 = Box.createHorizontalBox();
        JLabel jLable0 = new JLabel("GInMiR: Graphical and Integrative miRNA discovery Tool");
        jLable0.setFont(new Font("Tahoma", 1, 12));
        hbox0.add(jLable0);
        hbox0.add(Box.createHorizontalStrut(95));
        String[] combobox1_items = new String[]{"hg18"};
        this.jComboBox1 = new JComboBox<String>(new DefaultComboBoxModel<String>(combobox1_items));
        this.jComboBox1.setMaximumSize(this.jComboBox1.getPreferredSize());
        this.jComboBox1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GInMiR.this.jComboBox1ActionPerformed(evt);
            }
        });
        hbox0.add(this.jComboBox1);
        hbox0.add(Box.createHorizontalStrut(5));
        this.jCheckBox1 = new JCheckBox("miRDeep");
        hbox0.add(this.jCheckBox1);
        vbox1.add(hbox0);
        vbox1.add(Box.createVerticalStrut(20));
        Box hbox1 = Box.createHorizontalBox();
        hbox1.add(new JLabel("Adapter"));
        hbox1.add(Box.createHorizontalStrut(3));
        this.jTextField1 = new JTextField("TCGTATGCCGTCTTCTGCTTG", 16);
        hbox1.add(this.jTextField1);
        hbox1.add(Box.createHorizontalStrut(15));
        hbox1.add(new JLabel("Length"));
        hbox1.add(Box.createHorizontalStrut(3));
        this.jTextField2 = new JTextField("18", 2);
        hbox1.add(this.jTextField2);
        hbox1.add(Box.createHorizontalStrut(3));
        hbox1.add(new JLabel("to"));
        hbox1.add(Box.createHorizontalStrut(3));
        this.jTextField3 = new JTextField("23", 2);
        hbox1.add(this.jTextField3);
        hbox1.add(Box.createHorizontalStrut(15));
        hbox1.add(new JLabel("min phred"));
        hbox1.add(Box.createHorizontalStrut(3));
        this.jTextField4 = new JTextField("20", 2);
        hbox1.add(this.jTextField4);
        hbox1.add(Box.createHorizontalStrut(15));
        hbox1.add(new JLabel("max multimap"));
        hbox1.add(Box.createHorizontalStrut(3));
        this.jTextField5 = new JTextField("101", 3);
        hbox1.add(this.jTextField5);
        hbox1.add(Box.createHorizontalStrut(15));
        hbox1.add(new JLabel("min reads"));
        hbox1.add(Box.createHorizontalStrut(3));
        this.jTextField6 = new JTextField("5", 1);
        hbox1.add(this.jTextField6);
        hbox1.add(Box.createHorizontalStrut(15));
        hbox1.add(new JLabel("min score"));
        hbox1.add(Box.createHorizontalStrut(3));
        this.jTextField7 = new JTextField("-10", 2);
        hbox1.add(this.jTextField7);
        JPanel jPanel2 = new JPanel();
        jPanel2.setBorder(BorderFactory.createTitledBorder("Parameters"));
        jPanel2.add(hbox1);
        vbox1.add(jPanel2);
        Box hbox2 = Box.createHorizontalBox();
        this.jButton1 = new JButton("Fastq or BAM file");
        this.jButton1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GInMiR.this.jButton1ActionPerformed(evt);
            }
        });
        hbox2.add(this.jButton1);
        hbox2.add(Box.createHorizontalStrut(5));
        this.jTextField8 = new JTextField(50);
        this.jTextField8.setEditable(false);
        hbox2.add(this.jTextField8);
        this.jButton2 = new JButton("submit");
        this.jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                try {
                    GInMiR.this.jButton2ActionPerformed(evt);
                }
                catch (IOException ex) {
                    Logger.getLogger(GInMiR.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        });
        hbox2.add(Box.createHorizontalStrut(20));
        hbox2.add(this.jButton2);
        JPanel jPanel3 = new JPanel();
        jPanel3.setBorder(BorderFactory.createTitledBorder("Mapping sequences"));
        jPanel3.add(hbox2);
        vbox1.add(Box.createVerticalStrut(20));
        vbox1.add(jPanel3);
        Box hbox3 = Box.createHorizontalBox();
        jLabel3 = new JLabel("progress");
        hbox3.add(jLabel3);
        hbox3.add(Box.createHorizontalStrut(20));
        this.jProgressBar = new JProgressBar();
        hbox3.add(this.jProgressBar);
        vbox1.add(Box.createVerticalStrut(20));
        vbox1.add(hbox3);
        JLabel jLabel2 = new JLabel("Result");
        jLabel2.setFont(new Font("Tahoma", 1, 10));
        vbox1.add(Box.createVerticalStrut(20));
        vbox1.add(jLabel2);
        DefaultTableModel dm = new DefaultTableModel(){

            public Class getColumnClass(int column) {
                Class returnValue = column >= 0 && column < this.getColumnCount() ? this.getValueAt(0, column).getClass() : Object.class;
                return returnValue;
            }
        };
        dm.setDataVector((Object[][])null, new Object[]{"miRNA ID", "Score", "expr", "loci", "sequence"});
        jTable1 = new JTable(dm);
        jTable1.getColumn("miRNA ID").setCellRenderer(new ButtonRenderer());
        jTable1.getColumn("miRNA ID").setCellEditor(new ButtonEditor(new JCheckBox()));
        jTable1.getColumnModel().getColumn(0).setPreferredWidth(90);
        jTable1.getColumnModel().getColumn(1).setPreferredWidth(25);
        jTable1.getColumnModel().getColumn(2).setPreferredWidth(25);
        jTable1.getColumnModel().getColumn(3).setPreferredWidth(120);
        jTable1.getColumnModel().getColumn(4).setPreferredWidth(210);
        TableRowSorter<5> sorter = new TableRowSorter<5>(dm);
        sorter.setComparator(3, new loci_cmp());
        jTable1.setRowSorter(sorter);
        JScrollPane jScrollPane1 = new JScrollPane(jTable1);
        vbox1.add(Box.createVerticalStrut(10));
        vbox1.add(jScrollPane1);
        jPanel1.add((Component)vbox1, "West");
        this.add(jPanel1);
    }

    static {
        miR_details = new ArrayList();
    }
}

