/*
 * Decompiled with CFR 0.152.
 */
package GInMiR;

import java.util.ArrayList;
import java.util.TreeMap;
import loci.Comp_stop;
import loci.loci;

public class hairPin {
    String subject = "";
    loci precursor;
    TreeMap<loci, ArrayList<String>> reads;
    loci highest_read;

    public loci offset(loci read) {
        loci new_loci = this.precursor.getstrand().equals("+") ? new loci(read.getChr(), read.getstrand(), read.getstart_loci() - this.precursor.getstart_loci(), read.getstop_loci() - this.precursor.getstart_loci(), read.getnumReads()) : new loci(read.getChr(), read.getstrand(), this.precursor.getstop_loci() - read.getstop_loci(), this.precursor.getstop_loci() - read.getstart_loci(), read.getnumReads());
        return new_loci;
    }

    public loci left(loci read) {
        loci new_loci = this.precursor.getstrand().equals("+") ? new loci(read.getChr(), read.getstrand(), read.getstart_loci() + this.precursor.getstart_loci(), read.getstop_loci() + this.precursor.getstart_loci(), read.getnumReads()) : new loci(read.getChr(), read.getstrand(), this.precursor.getstop_loci() - read.getstop_loci(), this.precursor.getstop_loci() - read.getstart_loci(), read.getnumReads());
        return new_loci;
    }

    public boolean add(String ID, String chr, String strand, int loci_start, int loci_stop, int numReads) {
        if (this.reads == null) {
            this.precursor = new loci(chr, strand, loci_start, loci_stop, numReads);
            this.reads = new TreeMap(new Comp_stop());
            ArrayList<String> IDs = new ArrayList<String>();
            IDs.add(ID);
            this.reads.put(new loci(chr, strand, loci_start, loci_stop, numReads), IDs);
            this.subject = chr + strand + Integer.toString(this.precursor.getstart_loci()) + "-" + this.precursor.getstop_loci();
            this.highest_read = new loci(chr, strand, loci_start, loci_stop, numReads);
            return true;
        }
        if (this.precursor.getChr().equals(chr) && this.precursor.getstrand().equals(strand) && this.precursor.getstop_loci() >= loci_start - 30) {
            boolean haveSameSeq = false;
            for (loci loci2 : this.reads.keySet()) {
                if (!loci2.equal(chr, strand, loci_start, loci_stop)) continue;
                this.reads.get(loci2).add(ID);
                loci2.increase();
                haveSameSeq = true;
                break;
            }
            if (!haveSameSeq) {
                ArrayList<String> IDs = new ArrayList<String>();
                IDs.add(ID);
                this.reads.put(new loci(chr, strand, loci_start, loci_stop, numReads), IDs);
                this.precursor.setloci_start(Math.min(this.precursor.getstart_loci(), loci_start));
                this.precursor.setloci_stop(Math.max(this.precursor.getstop_loci(), loci_stop));
                this.subject = chr + strand + Integer.toString(this.precursor.getstart_loci()) + "-" + this.precursor.getstop_loci();
            }
            return true;
        }
        return false;
    }

    public void find_mature() {
        if (this.reads == null) {
            return;
        }
        this.highest_read = new loci();
        for (loci key : this.reads.keySet()) {
            if (this.highest_read.getnumReads() >= key.getnumReads()) continue;
            this.highest_read.update(key.getChr(), key.getstrand(), key.getstart_loci(), key.getstop_loci(), key.getnumReads());
        }
    }

    public void clear() {
        this.subject = "";
        this.precursor = null;
        this.reads = null;
        this.highest_read = null;
    }

    public String toMyString() {
        String result = "subject=" + this.subject + "\n";
        result = result + "precursor\t" + this.precursor.toMyString() + "\n";
        for (loci key : this.reads.keySet()) {
            result = result + this.reads.get(key) + "\t" + key.toMyString() + "\n";
        }
        return result;
    }
}

