/*
 * Decompiled with CFR 0.152.
 */
package GInMiR;

import DeepBowtieAligner.DeepBowtieAligner;
import GInMiR.Comp_Set;
import GInMiR.Comp_num;
import GInMiR.Comp_score;
import GInMiR.GInMiR;
import GInMiR.found_miR_details;
import GInMiR.hairPin;
import GInMiR.miR_family;
import GInMiR.other_RNAs;
import GInMiR.precursor;
import GInMiR.repeatMasker;
import RNAfold.RNAfold;
import bowtie.bowtie_index;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JOptionPane;
import javax.swing.SwingWorker;
import javax.swing.table.DefaultTableModel;
import loci.loci;
import loci.loci_cmp;
import loci.loci_overlap_cmp;
import net.sf.samtools.SAMFileHeader;
import net.sf.samtools.SAMFileReader;
import net.sf.samtools.SAMFileWriter;
import net.sf.samtools.SAMFileWriterFactory;
import net.sf.samtools.SAMProgramRecord;
import net.sf.samtools.SAMRecord;
import net.sf.samtools.SAMSequenceDictionary;
import net.sf.samtools.SAMSequenceRecord;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class mapping_identifying
extends SwingWorker<Void, Void> {
    String assembly;
    String adapter_seq;
    String pure_filename;
    String inputfile_extend;
    int max_rep;
    boolean isOriginalMirDeep;
    private miR_family miR_family;
    private hairPin hairPin = new hairPin();
    private TreeMap<Integer, Integer> hash_bp;
    private Map<loci, ArrayList<String>> hash_query_offset;
    private precursor comp;
    private double score_star = 3.9;
    private double score_star_not = -1.3;
    private double score_min = -2.0;
    private int numRead_min = 0;
    private double score_intercept = 0.3;
    private double[] score_stem = new double[]{-3.1, -2.3, -2.2, -1.6, -1.5, 0.1, 0.6, 0.8, 0.9, 0.9, 0.0};
    private SAMFileHeader samFileHeader;
    int novel_miR_no = 0;
    int all_miR_no = 0;
    private BufferedWriter bw_novel_tmp;
    static int len_loop = 15;
    static int len_flank = 22;
    public bowtie_index bwt_index;
    TreeMap<String, Integer> knownMiR = new TreeMap();

    public mapping_identifying(String assembly1, String adapter_seq1, String inputFilename1, int max_rep1, int min_numReads1, double min_score1, boolean isOriginalMirDeep1) {
        this.assembly = assembly1;
        this.adapter_seq = adapter_seq1;
        this.pure_filename = inputFilename1.substring(0, inputFilename1.lastIndexOf(46));
        this.inputfile_extend = inputFilename1.substring(inputFilename1.lastIndexOf(46) + 1);
        this.max_rep = max_rep1;
        this.numRead_min = min_numReads1;
        this.score_min = min_score1;
        this.isOriginalMirDeep = isOriginalMirDeep1;
    }

    @Override
    public Void doInBackground() {
        try {
            if (this.inputfile_extend.equalsIgnoreCase("result")) {
                this.read_middle_file(this.pure_filename + "." + this.inputfile_extend);
                this.show_jTable();
            } else {
                if (this.inputfile_extend.equalsIgnoreCase("fastq") || this.inputfile_extend.equalsIgnoreCase("fa")) {
                    this.setProgress(0);
                    GInMiR.jLabel3.setText("mapping");
                    this.alignment();
                    this.remove_duplicats_over_max_rep(this.pure_filename + ".tmp.sam");
                }
                this.setProgress(0);
                GInMiR.jLabel3.setText("Identifying");
                this.miDeep_miR();
                GInMiR.jLabel3.setText("finish");
            }
        }
        catch (IOException ex) {
            Logger.getLogger(mapping_identifying.class.getName()).log(Level.SEVERE, null, ex);
        }
        return null;
    }

    @Override
    public void done() {
        this.setProgress(100);
    }

    private void miDeep_miR() {
        String original_miRDeep = this.isOriginalMirDeep ? ".original.miRDeep" : "";
        try {
            GInMiR.miR_details = this.find_miR();
            Map<String, Set<String>> miR_reads = this.read_middle_file(this.pure_filename + original_miRDeep + ".result");
            this.show_jTable();
            this.write_cluster_file(miR_reads, original_miRDeep);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, e.toString());
        }
    }

    private void write_cluster_file(Map<String, Set<String>> miR_reads, String original_miRDeep) throws IOException {
        ArrayList clusters = new ArrayList();
        for (String key : miR_reads.keySet()) {
            HashSet hashSet = new HashSet(miR_reads.get(key));
            boolean hasGroup = false;
            for (Set set : clusters) {
                if (!set.removeAll(hashSet)) continue;
                set.addAll(hashSet);
                hasGroup = true;
            }
            if (hasGroup) continue;
            clusters.add(hashSet);
        }
        TreeMap<Set, Integer> cluster_map = new TreeMap<Set, Integer>(new Comp_Set());
        for (Set set : clusters) {
            cluster_map.put(set, 0);
        }
        for (String string : miR_reads.keySet()) {
            String[] str = string.split(":");
            int numReads = str.length + Integer.parseInt(str[1]);
            for (Set s : cluster_map.keySet()) {
                if (!miR_reads.get(string).containsAll(s)) continue;
                cluster_map.put(s, (Integer)cluster_map.get(s) + numReads);
            }
        }
        BufferedWriter bw2 = new BufferedWriter(new FileWriter(this.pure_filename + ".cluster" + original_miRDeep));
        bw2.write("miRNAs having same reads \texpression(number of reads)\n");
        for (Set s : cluster_map.keySet()) {
            bw2.write(s.toString() + "\t" + cluster_map.get(s) + "\n");
        }
        bw2.close();
    }

    private Map<String, Set<String>> read_middle_file(String filename) throws FileNotFoundException, IOException {
        TreeMap<String, Set<String>> miR_reads = new TreeMap<String, Set<String>>();
        BufferedReader br_novel = new BufferedReader(new FileReader(filename));
        String line = br_novel.readLine();
        GInMiR.miR_details.clear();
        while ((line = br_novel.readLine()) != null) {
            String[] str = line.split("\t");
            String miR_ID = str[0];
            double score = Double.parseDouble(str[1]);
            String chr = str[2];
            String strand = str[3];
            String[] substr = str[4].split("-");
            int hairPin_start = Integer.parseInt(substr[0]);
            int hairPin_stop = Integer.parseInt(substr[1]);
            loci hairPin1 = new loci(chr, strand, hairPin_start, hairPin_stop);
            double expr = Double.parseDouble(str[5]);
            substr = str[6].split("-");
            int mature_start = Integer.parseInt(substr[0]);
            int mature_stop = Integer.parseInt(substr[1]);
            loci mature = new loci(chr, strand, mature_start, mature_stop);
            String hairPin_seq = str[7];
            String hairPin_struct = str[8];
            String[] subStr = str[11].split(";");
            loci[] reads = new loci[subStr.length];
            for (int i = 0; i < subStr.length; ++i) {
                HashSet<String> al;
                String patternStr = "(\\s|\\+|\\-|\\:)+";
                String[] subsubStr = subStr[i].split(patternStr);
                String read_no_set = subsubStr[0];
                String current_strand = subStr[i].substring(subsubStr[0].length() + subsubStr[1].length() + 1, subsubStr[0].length() + subsubStr[1].length() + 2);
                reads[i] = new loci(subsubStr[1], current_strand, Integer.parseInt(subsubStr[2]), Integer.parseInt(subsubStr[3]), Integer.parseInt(subsubStr[4]));
                if (miR_reads.get(read_no_set) == null) {
                    al = new HashSet<String>();
                    al.add(str[0]);
                    miR_reads.put(subStr[i], al);
                    continue;
                }
                al = new HashSet((Collection)miR_reads.get(read_no_set));
                if (str[0].startsWith("novel")) {
                    al.add(str[1] + ":" + str[2] + str[3]);
                } else {
                    al.add(str[0]);
                }
                miR_reads.put(subStr[i], al);
            }
            GInMiR.miR_details.add(new found_miR_details(miR_ID, score, expr, hairPin1, hairPin_seq, hairPin_struct, mature, reads));
        }
        Collections.sort(GInMiR.miR_details, new Comp_score());
        br_novel.close();
        return miR_reads;
    }

    private void show_jTable() {
        DefaultTableModel model_novel = (DefaultTableModel)GInMiR.jTable1.getModel();
        model_novel.getDataVector().removeAllElements();
        for (found_miR_details key : GInMiR.miR_details) {
            String miR_ID = key.miR;
            double score = key.score;
            double expr = key.expr;
            String chr = key.hairPin.getChr();
            String strand = key.hairPin.getstrand();
            int loci_start = key.hairPin.getstart_loci();
            int loci_stop = key.hairPin.getstop_loci();
            String mature_seq = key.mature_sequence();
            DecimalFormat fmt = new DecimalFormat("###,###,###");
            String loci_str = chr + strand + fmt.format(loci_start) + "~" + fmt.format(loci_stop);
            model_novel.addRow(new Object[]{miR_ID, score, expr, loci_str, mature_seq.toUpperCase().replace('T', 'U')});
        }
        GInMiR.jTable1.setModel(model_novel);
    }

    private int numLines(String fastaName) throws FileNotFoundException, IOException {
        BufferedReader br = new BufferedReader(new FileReader(fastaName));
        String line = br.readLine();
        int rec_no = 0;
        while ((line = br.readLine()) != null) {
            ++rec_no;
            line = br.readLine();
        }
        br.close();
        return rec_no;
    }

    private void alignment() throws IOException {
        other_RNAs other_RNAs2 = new other_RNAs(this.assembly);
        repeatMasker repeat_masker = new repeatMasker(this.assembly);
        DeepBowtieAligner DeepBowtieAligner2 = new DeepBowtieAligner(this.assembly, this.adapter_seq);
        SAMFileWriterFactory factory = new SAMFileWriterFactory();
        SAMFileHeader header = new SAMFileHeader();
        header.setSortOrder(SAMFileHeader.SortOrder.queryname);
        ArrayList<SAMSequenceRecord> chrom = new ArrayList<SAMSequenceRecord>();
        for (int i = 0; i < DeepBowtieAligner2.numChr(); ++i) {
            chrom.add(new SAMSequenceRecord(DeepBowtieAligner2.getChrInfo(i).getChr(), DeepBowtieAligner2.getChrInfo(i).getLen()));
        }
        header.setSequenceDictionary(new SAMSequenceDictionary(chrom));
        ArrayList<SAMProgramRecord> pg = new ArrayList<SAMProgramRecord>();
        SAMProgramRecord one_pg = new SAMProgramRecord("binary-based");
        one_pg.setProgramVersion("0.0.1");
        one_pg.setCommandLine("JBowtie_Aligner -k 1 -v 0");
        pg.add(one_pg);
        header.setProgramRecords(pg);
        factory.setCreateIndex(true);
        File samfile = new File(this.pure_filename + ".tmp.sam");
        SAMFileWriter writer = factory.makeSAMOrBAMWriter(header, false, samfile);
        int numRec = this.numLines(this.pure_filename + ".purify.fa");
        int numSteps = Math.min(numRec, 100);
        int step = numRec / numSteps;
        int numChromo = DeepBowtieAligner2.numChr();
        for (int chr_no = 0; chr_no < numChromo; ++chr_no) {
            String line;
            String current_chr = DeepBowtieAligner2.getChrInfo(chr_no).getChr();
            DeepBowtieAligner2.load_one_chrom(current_chr);
            BufferedReader br = new BufferedReader(new FileReader(this.pure_filename + ".purify.fa"));
            int rec_no = 0;
            while ((line = br.readLine()) != null) {
                int i;
                if (++rec_no % step == 0) {
                    double sub_percentage = (double)chr_no + (double)(rec_no / step) / (double)numSteps;
                    GInMiR.jLabel3.setText("Mapping (" + (double)((int)(10000.0 * sub_percentage / (double)numChromo)) / 100.0 + "%)");
                    this.setProgress((int)Math.min(99.0, 100.0 * (sub_percentage / (double)numChromo)));
                }
                String[] strarray = line.split("\\s+");
                int numReads = 1;
                if (strarray.length > 1) {
                    numReads = Integer.parseInt(strarray[1]);
                }
                String pure_read = br.readLine();
                ArrayList<Integer> matched_start = DeepBowtieAligner2.BWA_query_chrom(current_chr, pure_read, this.max_rep);
                ArrayList<loci> matched_loci = new ArrayList<loci>();
                for (i = 0; i < matched_start.size(); ++i) {
                    int loci_start = matched_start.get(i);
                    String strand = loci_start > 0 ? "+" : "-";
                    loci_start = Math.abs(loci_start);
                    int loci_end = loci_start + pure_read.length() - 1;
                    matched_loci.add(new loci(current_chr, strand, loci_start, loci_end));
                }
                if (matched_loci.isEmpty()) continue;
                for (i = 0; i < matched_loci.size(); ++i) {
                    if (Collections.binarySearch(other_RNAs2.gff, matched_loci.get(i), new loci_overlap_cmp()) >= 0 || Collections.binarySearch(repeat_masker.gff, matched_loci.get(i), new loci_overlap_cmp()) >= 0) continue;
                    SAMRecord SAMRecord2 = new SAMRecord(header);
                    SAMRecord2.setReadName(Integer.toString(rec_no));
                    if (((loci)matched_loci.get(i)).getstrand().equals("+")) {
                        SAMRecord2.setFlags(0);
                    } else {
                        SAMRecord2.setFlags(16);
                    }
                    SAMRecord2.setReferenceName(((loci)matched_loci.get(i)).getChr());
                    SAMRecord2.setAlignmentStart(((loci)matched_loci.get(i)).getstart_loci());
                    SAMRecord2.setMappingQuality(255);
                    int len = ((loci)matched_loci.get(i)).getstop_loci() - ((loci)matched_loci.get(i)).getstart_loci() + 1;
                    SAMRecord2.setCigarString(len + "M");
                    SAMRecord2.setReadString(pure_read);
                    SAMRecord2.setAttribute("MD", (Object)Integer.toString(len));
                    SAMRecord2.setAttribute("NM", (Object)new Integer(0));
                    SAMRecord2.setAttribute("XS", (Object)new Integer(numReads));
                    writer.addAlignment(SAMRecord2);
                }
            }
            br.close();
        }
        writer.close();
        File file = new File(this.pure_filename + ".purify.fa");
        file.delete();
    }

    private void remove_duplicats_over_max_rep(String pre_samFileName) {
        File samfile = new File(pre_samFileName);
        SAMFileReader SAMFileReader2 = new SAMFileReader(samfile);
        SAMFileHeader header = SAMFileReader2.getFileHeader();
        header.setSortOrder(SAMFileHeader.SortOrder.coordinate);
        SAMFileWriterFactory factory = new SAMFileWriterFactory();
        SAMFileWriter writer = factory.makeSAMOrBAMWriter(header, false, new File(this.pure_filename + ".sam"));
        boolean rec_no = false;
        ArrayList<SAMRecord> al = new ArrayList<SAMRecord>();
        String pre_name = "";
        for (SAMRecord re : SAMFileReader2) {
            String current_name = re.getReadName();
            if (current_name.equals(pre_name)) {
                al.add(re);
                continue;
            }
            if (al.size() <= this.max_rep) {
                for (SAMRecord savedRec : al) {
                    writer.addAlignment(savedRec);
                }
            }
            al.clear();
            al.add(re);
            pre_name = current_name;
        }
        if (al.size() <= this.max_rep) {
            for (SAMRecord savedRec : al) {
                writer.addAlignment(savedRec);
            }
        }
        SAMFileReader2.close();
        File file = new File(pre_samFileName);
        file.delete();
        writer.close();
    }

    private int numSamRec(String bamFileName) {
        File in = new File(bamFileName);
        SAMFileReader SAMFileReader2 = new SAMFileReader(in);
        int rec_no = 0;
        for (SAMRecord re : SAMFileReader2) {
            ++rec_no;
        }
        return rec_no;
    }

    public ArrayList<found_miR_details> find_miR() throws FileNotFoundException, IOException {
        this.bwt_index = new bowtie_index(this.assembly);
        ArrayList<found_miR_details> miR_details = new ArrayList<found_miR_details>();
        String original_miRDeep = this.isOriginalMirDeep ? ".original.miRDeep" : "";
        this.miR_family = new miR_family();
        String result_filename = this.pure_filename + original_miRDeep + ".result";
        this.bw_novel_tmp = new BufferedWriter(new FileWriter(result_filename));
        this.bw_novel_tmp.write("miR_ID");
        this.bw_novel_tmp.write("\tscore");
        this.bw_novel_tmp.write("\tchr");
        this.bw_novel_tmp.write("\tstrand");
        this.bw_novel_tmp.write("\thairPin_loci");
        this.bw_novel_tmp.write("\texpression(number of mature reads)");
        this.bw_novel_tmp.write("\tmature_loci");
        this.bw_novel_tmp.write("\tsequence");
        this.bw_novel_tmp.write("\thairPin 2nd second RNA Structure");
        this.bw_novel_tmp.write("\tmature miR");
        this.bw_novel_tmp.write("\tmature_loop_star_seq");
        this.bw_novel_tmp.write("\treads_no\n");
        File in = new File(this.pure_filename + ".sam");
        int numRec = this.numSamRec(this.pure_filename + ".sam");
        int numSteps = Math.min(numRec, 100);
        double step = numRec / numSteps;
        ArrayList<String> strand_type = new ArrayList<String>();
        strand_type.add("+");
        strand_type.add("-");
        for (int strand_no = 0; strand_no < strand_type.size(); ++strand_no) {
            String current_strand = (String)strand_type.get(strand_no);
            SAMFileReader SAMFileReader2 = new SAMFileReader(in);
            this.samFileHeader = SAMFileReader2.getFileHeader();
            int rec_no = 0;
            for (SAMRecord re : SAMFileReader2) {
                if (++rec_no % (int)step == 0) {
                    double sub_percentage = (double)strand_no + (double)rec_no / step / (double)numSteps;
                    GInMiR.jLabel3.setText("Identifying (" + (double)((int)(10000.0 * sub_percentage / (double)strand_type.size())) / 100.0 + "%)");
                    this.setProgress(Math.min(99, (int)(100.0 * (sub_percentage / (double)strand_type.size()))));
                }
                if (this.assign_read(re, current_strand, true)) continue;
                this.hairPin.find_mature();
                if (this.isOriginalMirDeep) {
                    this.test_hairPin(miR_details);
                } else {
                    this.test_hairPin_new(miR_details);
                }
                this.hairPin.clear();
                this.assign_read(re, current_strand, false);
            }
            this.hairPin.find_mature();
            if (this.isOriginalMirDeep) {
                this.test_hairPin(miR_details);
            } else {
                this.test_hairPin_new(miR_details);
            }
            SAMFileReader2.close();
        }
        this.bw_novel_tmp.close();
        this.writeKnownMiR();
        return miR_details;
    }

    private boolean assign_read(SAMRecord re, String current_strand, boolean checkKnownMiR) {
        String debug;
        String strand;
        String ID = re.getReadName();
        if (ID.equalsIgnoreCase("251605")) {
            boolean debug2 = false;
        }
        String seq = re.getReadString();
        String chr = re.getReferenceName();
        if (chr.equals("*")) {
            return true;
        }
        String string = strand = re.getReadNegativeStrandFlag() ? "-" : "+";
        if (!strand.equals(current_strand)) {
            return true;
        }
        int loci_start = re.getAlignmentStart();
        int loci_stop = re.getAlignmentEnd();
        int numReads = re.getAttribute("XS") == null ? 1 : (Integer)re.getAttribute("XS");
        if (loci_start >= 1092403) {
            debug = "kk";
        }
        if (chr.equals("chr21") && strand.equals("+") && loci_start < 16834051 && loci_start > 16834027) {
            debug = "gg";
        }
        if (checkKnownMiR) {
            this.checkKnownMiR(new loci(chr, strand, loci_start, loci_stop), seq, numReads);
        }
        return this.hairPin.add(ID, chr, strand, loci_start, loci_stop, numReads);
    }

    private void writeKnownMiR() throws IOException {
        BufferedWriter bw = new BufferedWriter(new FileWriter(this.pure_filename + ".knownMiR"));
        for (String miR : this.knownMiR.keySet()) {
            if (this.knownMiR.get(miR) < 5) continue;
            bw.write(miR + "\t" + this.knownMiR.get(miR) + "\n");
        }
        bw.close();
    }

    private void checkKnownMiR(loci l, String seq, int numReads) {
        for (String key : this.miR_family.hsa_gff.keySet()) {
            if (!this.miR_family.hsa_gff.get(key).isOverlapped(l)) continue;
            if (this.knownMiR.get(key) == null) {
                this.knownMiR.put(key, numReads);
                continue;
            }
            this.knownMiR.put(key, this.knownMiR.get(key) + numReads);
        }
    }

    private String getKnownMiR(loci mature_loci) {
        for (String key : this.miR_family.hsa_gff.keySet()) {
            if (key.length() <= 3 || !key.substring(0, 3).equals("hsa") && !key.substring(0, 3).equals("let") || !this.miR_family.hsa_gff.get(key).contain(mature_loci)) continue;
            if (key.equals("hsa-mir-1248")) {
                boolean bebug = false;
            }
            return key;
        }
        return "";
    }

    private void test_hairPin(ArrayList<found_miR_details> miR_details) throws FileNotFoundException, IOException {
        loci mature_loci = this.hairPin.highest_read;
        ArrayList<String> mature_ID = this.hairPin.reads.get(mature_loci);
        String KnownMiR = this.getKnownMiR(mature_loci);
        int precursor_loci_start = this.hairPin.precursor.getstart_loci();
        int precursor_loci_stop = this.hairPin.precursor.getstop_loci();
        if (this.hairPin.precursor.getstop_loci() - this.hairPin.precursor.getstart_loci() > 30) {
            this.hairPin.precursor.setloci_start(Math.max(1, this.hairPin.precursor.getstart_loci() - len_flank));
            this.hairPin.precursor.setloci_stop(Math.min(this.samFileHeader.getSequence(this.hairPin.precursor.getChr()).getSequenceLength(), this.hairPin.precursor.getstop_loci() + len_flank));
            if (this.hairPin.precursor.getstop_loci() - this.hairPin.precursor.getstart_loci() <= 140) {
                this.resolve_potential_precursor(KnownMiR, miR_details);
            }
        } else {
            this.hairPin.precursor.setloci_start(Math.max(1, precursor_loci_start - len_flank));
            this.hairPin.precursor.setloci_stop(Math.min(this.samFileHeader.getSequence(this.hairPin.precursor.getChr()).getSequenceLength(), precursor_loci_start + 87));
            if (this.hairPin.precursor.getstop_loci() - this.hairPin.precursor.getstart_loci() <= 140) {
                this.resolve_potential_precursor(KnownMiR, miR_details);
            }
            this.hairPin.precursor.setloci_start(Math.max(1, precursor_loci_stop - 87));
            this.hairPin.precursor.setloci_stop(Math.min(this.samFileHeader.getSequence(this.hairPin.precursor.getChr()).getSequenceLength(), precursor_loci_stop + len_flank));
            if (this.hairPin.precursor.getstop_loci() - this.hairPin.precursor.getstart_loci() <= 140) {
                this.resolve_potential_precursor(KnownMiR, miR_details);
            }
        }
    }

    private void test_hairPin_new(ArrayList<found_miR_details> miR_details) throws FileNotFoundException, IOException {
        loci mature_loci;
        if (this.hairPin.subject.equals("chr1+1092403-1092425") || this.hairPin.subject.length() < 1) {
            String debug = "debug";
        }
        if ((mature_loci = this.hairPin.highest_read) == null) {
            return;
        }
        ArrayList<String> mature_ID = this.hairPin.reads.get(mature_loci);
        String KnownMiR = this.getKnownMiR(mature_loci);
        int length_mature = mature_loci.getstop_loci() - mature_loci.getstart_loci() + 1;
        this.hairPin.precursor.setloci_start(Math.max(1, mature_loci.getstart_loci() - length_mature - len_loop - len_flank));
        this.hairPin.precursor.setloci_stop(Math.min(this.samFileHeader.getSequence(this.hairPin.precursor.getChr()).getSequenceLength(), mature_loci.getstop_loci() + len_flank));
        this.resolve_potential_precursor(KnownMiR, miR_details);
        this.hairPin.precursor.setloci_start(Math.max(1, mature_loci.getstart_loci() - len_flank));
        this.hairPin.precursor.setloci_stop(Math.min(this.samFileHeader.getSequence(this.hairPin.precursor.getChr()).getSequenceLength(), mature_loci.getstop_loci() + len_loop + length_mature + len_flank));
        this.resolve_potential_precursor(KnownMiR, miR_details);
    }

    private void resolve_potential_precursor(String knownMiR, ArrayList<found_miR_details> miR_details) throws FileNotFoundException, IOException {
        int fuzzy;
        this.comp = new precursor();
        this.comp.pri_id = this.hairPin.subject;
        this.comp.pri_seq = this.bwt_index.BWA_seq_chrom(this.hairPin.precursor.getChr(), this.hairPin.precursor.getstrand(), this.hairPin.precursor.getstart_loci(), this.hairPin.precursor.getstop_loci());
        RNAfold RNAfold2 = new RNAfold(this.comp.pri_seq);
        this.comp.pri_struct = RNAfold2.getStruct();
        this.comp.pri_mfe = RNAfold2.getMFE();
        this.hash_bp = new TreeMap();
        Stack<Integer> stack = new Stack<Integer>();
        for (int i = 1; i <= this.comp.pri_struct.length(); ++i) {
            if (this.comp.pri_struct.substring(i - 1, i).equals("(")) {
                stack.push(i);
                continue;
            }
            if (!this.comp.pri_struct.substring(i - 1, i).equals(")")) continue;
            int opposite = (Integer)stack.pop();
            this.hash_bp.put(i, opposite);
            this.hash_bp.put(opposite, i);
        }
        this.comp.pri_beg = 1;
        this.comp.pri_end = this.comp.pri_seq.length();
        this.hash_query_offset = new TreeMap<loci, ArrayList<String>>(new loci_cmp());
        for (loci key : this.hairPin.reads.keySet()) {
            this.hash_query_offset.put(this.hairPin.offset(key), this.hairPin.reads.get(key));
        }
        loci mature_loci = this.hairPin.highest_read;
        this.comp.mature_query = this.hairPin.reads.get(mature_loci);
        loci offset_mature_loci = this.hairPin.offset(mature_loci);
        this.comp.mature_beg = offset_mature_loci.getstart_loci() + 1;
        this.comp.mature_end = offset_mature_loci.getstop_loci() + 1;
        this.comp.mature_strand = offset_mature_loci.getstrand();
        this.comp.mature_numRead = mature_loci.getnumReads();
        if (this.comp.mature_numRead < this.numRead_min) {
            return;
        }
        this.comp.mature_struct = this.comp.pri_struct.substring(this.comp.mature_beg - 1, this.comp.mature_end);
        this.comp.mature_seq = this.comp.pri_seq.substring(this.comp.mature_beg - 1, this.comp.mature_end);
        if (this.comp.mature_struct.matches("(\\(|\\.)+") && this.comp.mature_struct.matches(".*\\(.*")) {
            this.comp.mature_arm = "first";
            this.comp.star_arm = "second";
        } else if (this.comp.mature_struct.matches("(\\)|\\.)+") && this.comp.mature_struct.matches(".*\\).*")) {
            this.comp.mature_arm = "second";
            this.comp.star_arm = "first";
        } else {
            return;
        }
        int last_bp = -1;
        int first_bp = -1;
        for (int i = this.comp.mature_beg; i <= this.comp.mature_end - 2; ++i) {
            if (this.hash_bp.get(i) == null) continue;
            if (first_bp == -1) {
                first_bp = i;
            }
            last_bp = i;
        }
        if (first_bp == -1) {
            return;
        }
        this.comp.star_end = this.hash_bp.get(first_bp) + (first_bp - this.comp.mature_beg) + 2;
        this.comp.star_beg = this.hash_bp.get(last_bp) - (this.comp.mature_end - 2 - last_bp);
        this.comp.star_end = Math.min(this.comp.star_end, this.comp.pri_seq.length());
        this.comp.star_beg = Math.max(1, this.comp.star_beg);
        if (this.comp.star_beg >= 0 && this.comp.star_beg <= this.comp.pri_end && this.comp.star_end >= 0 && this.comp.star_end <= this.comp.pri_end && this.comp.star_beg <= this.comp.star_end) {
            if (this.comp.mature_arm.equals("first") ? this.comp.mature_end >= this.comp.star_beg : this.comp.mature_arm.equals("second") && this.comp.star_end >= this.comp.mature_beg) {
                return;
            }
        } else {
            return;
        }
        this.comp.star_seq = this.comp.pri_seq.substring(this.comp.star_beg - 1, this.comp.star_end);
        this.comp.star_struct = this.comp.pri_struct.substring(this.comp.star_beg - 1, this.comp.star_end);
        if (this.comp.star_struct.matches("(\\(|\\.)+") && this.comp.star_struct.matches(".*\\(.*")) {
            this.comp.star_arm = "first";
        } else if (this.comp.star_struct.matches("(\\)|\\.)+") && this.comp.star_struct.matches(".*\\).*")) {
            this.comp.star_arm = "second";
        } else {
            return;
        }
        if (this.comp.mature_arm.equals("first")) {
            this.comp.loop_beg = this.comp.mature_end + 1;
            this.comp.loop_end = this.comp.star_beg - 1;
            fuzzy = 2;
            if (this.comp.loop_end - this.comp.loop_beg + 1 < 12 - fuzzy) {
                return;
            }
        } else if (this.comp.mature_arm.equals("second")) {
            this.comp.loop_beg = this.comp.star_end + 1;
            this.comp.loop_end = this.comp.mature_beg - 1;
            fuzzy = 2;
            if (this.comp.loop_end - this.comp.loop_beg + 1 < 10 - fuzzy) {
                return;
            }
        }
        this.comp.loop_seq = this.comp.pri_seq.substring(this.comp.loop_beg - 1, this.comp.loop_end);
        this.comp.loop_struct = this.comp.pri_struct.substring(this.comp.loop_beg - 1, this.comp.loop_end);
        if (this.comp.mature_arm.equals("first")) {
            this.comp.flank_first_end = this.comp.mature_beg - 1;
        } else {
            this.comp.flank_second_beg = this.comp.mature_end + 1;
        }
        if (this.comp.star_arm.equals("first")) {
            this.comp.flank_first_end = this.comp.star_beg - 1;
        } else {
            this.comp.flank_second_beg = this.comp.star_end + 1;
        }
        this.comp.flank_first_seq = this.comp.pri_seq.substring(this.comp.pri_beg - 1, this.comp.flank_first_end);
        this.comp.flank_first_struct = this.comp.pri_struct.substring(this.comp.pri_beg - 1, this.comp.flank_first_end);
        this.comp.flank_second_seq = this.comp.pri_seq.substring(this.comp.flank_second_beg - 1, this.comp.pri_end);
        this.comp.flank_second_struct = this.comp.pri_struct.substring(this.comp.flank_second_beg - 1, this.comp.pri_end);
        this.comp.stem_first = this.comp.flank_first_struct.substring(Math.max(0, this.comp.flank_first_struct.length() - 10), this.comp.flank_first_struct.length());
        this.comp.stem_second = this.comp.flank_second_struct.substring(0, Math.min(10, this.comp.flank_second_struct.length()));
        this.comp.Stem_bp_first = this.comp.stem_first.replace(")", "").replace(".", "").length();
        this.comp.stem_bp_second = this.comp.stem_second.replace("(", "").replace(".", "").length();
        this.comp.stem_bp = Math.min(this.comp.Stem_bp_first, this.comp.stem_bp_second);
        this.comp.score_stem = this.score_stem[this.comp.stem_bp];
        if (this.pass_filtering_structure() && this.pass_filtering_signature() && this.pass_threshold_score()) {
            String miR_ID;
            String chr = this.hairPin.precursor.getChr();
            String strand = this.hairPin.precursor.getstrand();
            loci mature_miR = strand.equals("+") ? new loci(chr, strand, this.hairPin.precursor.getstart_loci() + this.comp.mature_beg - 1, this.hairPin.precursor.getstart_loci() + this.comp.mature_end - 1, this.comp.mature_numRead) : new loci(chr, strand, this.hairPin.precursor.getstop_loci() - this.comp.mature_end + 1, this.hairPin.precursor.getstop_loci() - this.comp.mature_beg + 1, this.comp.mature_numRead);
            int num_mature = mapping_identifying.mature_expr(offset_mature_loci, this.hash_query_offset);
            String novelMiR_str = "";
            if (knownMiR.length() == 0) {
                miR_ID = "novelMiR_" + this.novel_miR_no;
                ++this.novel_miR_no;
            } else {
                miR_ID = knownMiR;
                if (this.alreadyExist(miR_details, miR_ID)) {
                    miR_ID = miR_ID + "*";
                }
            }
            ++this.all_miR_no;
            novelMiR_str = miR_ID;
            DecimalFormat onePlaces = new DecimalFormat("0.00");
            novelMiR_str = novelMiR_str + "\t" + onePlaces.format(this.comp.score);
            novelMiR_str = novelMiR_str + "\t" + chr;
            novelMiR_str = novelMiR_str + "\t" + strand;
            novelMiR_str = novelMiR_str + "\t" + this.hairPin.precursor.getstart_loci() + "-" + this.hairPin.precursor.getstop_loci();
            novelMiR_str = novelMiR_str + "\t" + num_mature;
            novelMiR_str = novelMiR_str + "\t" + mature_miR.getstart_loci() + "-" + mature_miR.getstop_loci();
            novelMiR_str = novelMiR_str + "\t" + this.comp.pri_seq;
            this.comp.pri_struct = this.remove_loops_in_flank(this.hash_bp, this.comp.loop_beg, this.comp.loop_end, this.comp.pri_struct.length());
            novelMiR_str = novelMiR_str + "\t" + this.comp.pri_struct;
            novelMiR_str = novelMiR_str + "\t" + this.comp.mature_seq;
            novelMiR_str = this.comp.mature_arm.equals("first") ? novelMiR_str + "\t" + this.comp.pri_seq.substring(this.comp.mature_beg - 1, this.comp.star_end) : novelMiR_str + "\t" + this.comp.pri_seq.substring(this.comp.star_beg - 1, this.comp.mature_end);
            this.bw_novel_tmp.write(novelMiR_str + "\t");
            for (loci key : this.hash_query_offset.keySet()) {
                ArrayList temp_al = new ArrayList(this.hash_query_offset.get(key));
                Collections.sort(temp_al, new Comp_num());
                this.bw_novel_tmp.write(temp_al.toString().replace(" ", "") + " " + this.hairPin.left(key).toSimpleStringWithNumReads() + ";");
            }
            miR_details.add(new found_miR_details(miR_ID, this.comp.score, (double)num_mature, this.hairPin.precursor, this.comp.pri_seq, this.comp.pri_struct, mature_miR, this.hairPin.reads));
            this.bw_novel_tmp.write("\n");
        }
    }

    private boolean alreadyExist(ArrayList<found_miR_details> miR_details, String miR_ID) {
        for (found_miR_details fmd : miR_details) {
            if (!fmd.miR.equalsIgnoreCase(miR_ID)) continue;
            return true;
        }
        return false;
    }

    private String remove_loops_in_flank(TreeMap<Integer, Integer> basePair, int loop_beg, int loop_end, int len) {
        String result = "";
        for (int i = 1; i <= len; ++i) {
            if (basePair.get(i) != null) {
                int j = basePair.get(i);
                if (Math.max(i, j) < loop_beg || Math.min(i, j) > loop_end) {
                    result = result + ".";
                    continue;
                }
                if (i < j) {
                    result = result + "(";
                    continue;
                }
                result = result + ")";
                continue;
            }
            result = result + ".";
        }
        return result;
    }

    private static int mature_expr(loci mature_loci, Map<loci, ArrayList<String>> reads) {
        int num_mature = 0;
        int length_mature = mature_loci.getstop_loci() - mature_loci.getstart_loci() + 1;
        loci extend_mature = new loci(mature_loci.getChr(), mature_loci.getstrand(), mature_loci.getstart_loci() - (int)(0.1 * (double)length_mature), mature_loci.getstop_loci() + (int)(0.1 * (double)length_mature));
        for (loci key : reads.keySet()) {
            if (!extend_mature.contain(mature_loci.getChr(), mature_loci.getstrand(), key.getstart_loci(), key.getstop_loci())) continue;
            num_mature += key.getnumReads();
        }
        return num_mature;
    }

    private boolean pass_threshold_score() {
        this.comp.score_mfe = this.score_mfe(this.comp.pri_mfe);
        this.comp.score_freq = this.score_freq(this.comp.pri_freq);
        this.comp.score = this.comp.score_mfe + this.comp.score_freq;
        if (this.comp.star_read) {
            this.comp.score_star = this.score_star;
            this.comp.score += this.score_star;
        } else {
            this.comp.score_star = this.score_star_not;
            this.comp.score += this.score_star_not;
        }
        this.comp.score += this.score_intercept;
        this.comp.score += this.comp.score_stem;
        return !(this.comp.score < this.score_min);
    }

    private double score_freq(double freq) {
        double parameter_test = 0.999;
        double parameter_control = 0.6;
        double intercept = Math.log((1.0 - parameter_test) / (1.0 - parameter_control));
        double slope = Math.log(parameter_test / parameter_control);
        double log_odds = slope * freq + intercept;
        if (!this.comp.star_read) {
            log_odds = Math.min(log_odds, 0.0);
        }
        return log_odds;
    }

    private double score_mfe(double mfe) {
        double mfe_adj = Math.max(1.0, -1.0 * mfe);
        double prob_test = this.prob_gumbel_discretized(mfe_adj, 5.5, 32.0);
        double prob_background = this.prob_gumbel_discretized(mfe_adj, 4.8, 23.0);
        double odds = prob_test / prob_background;
        double log_odds = Math.log(odds);
        return log_odds;
    }

    private double prob_gumbel_discretized(double var, double scale, double location) {
        double bound_lower = var - 0.5;
        double bound_upper = var + 0.5;
        double cdf_lower = this.cdf_gumbel(bound_lower, scale, location);
        double cdf_upper = this.cdf_gumbel(bound_upper, scale, location);
        double prob = cdf_upper - cdf_lower;
        return prob;
    }

    private double cdf_gumbel(double var, double scale, double location) {
        double cdf = Math.pow(Math.E, -1.0 * Math.pow(Math.E, -1.0 * (var - location) / scale));
        return cdf;
    }

    private boolean pass_filtering_structure() {
        if (this.comp.loop_seq.equals("")) {
            return false;
        }
        if (this.comp.flank_first_struct.length() == 0) {
            return false;
        }
        if (this.comp.flank_second_struct.length() == 0) {
            return false;
        }
        String pre_struct = "";
        if (this.comp.mature_arm.equals("first")) {
            pre_struct = this.comp.mature_struct + this.comp.loop_struct + this.comp.star_struct;
        } else if (this.comp.mature_arm.equals("second")) {
            pre_struct = this.comp.star_struct + this.comp.loop_struct + this.comp.mature_struct;
        }
        if (!pre_struct.matches("(\\.|\\()+..(\\.|\\))+")) {
            return false;
        }
        if (this.comp.mature_struct.replace(".", "").length() < 14) {
            return false;
        }
        return Math.abs(this.comp.mature_struct.length() - this.comp.star_struct.length()) < 6;
    }

    private boolean pass_filtering_signature() {
        int consistent = 0;
        int inconsistent = 0;
        int star_perfect = 0;
        int star_fuzzy = 0;
        int fuzz_beg = 2;
        int fuzz_end = 5;
        for (loci subject : this.hash_query_offset.keySet()) {
            int read_start = subject.getstart_loci() + 1;
            int read_stop = subject.getstop_loci() + 1;
            if (read_start >= this.comp.mature_beg - fuzz_beg && read_stop <= this.comp.mature_end + fuzz_end || read_start >= this.comp.star_beg - fuzz_beg && read_stop <= this.comp.star_end + fuzz_end || read_start >= this.comp.loop_beg - fuzz_beg && read_stop <= this.comp.loop_end + fuzz_end) {
                consistent += subject.getnumReads();
            } else {
                inconsistent += subject.getnumReads();
            }
            if (read_start < this.comp.star_beg - fuzz_beg || read_stop > this.comp.star_end + fuzz_end) continue;
            if (Math.abs(read_start - this.comp.star_beg) <= 1) {
                star_perfect += subject.getnumReads();
                continue;
            }
            star_fuzzy += subject.getnumReads();
        }
        if (star_perfect > star_fuzzy) {
            this.comp.star_read = true;
        }
        this.comp.pri_freq = consistent + inconsistent;
        if (this.comp.pri_freq == 0) {
            return false;
        }
        return !((double)inconsistent / (double)(inconsistent + consistent) > 1.0);
    }
}

