/*
 * Decompiled with CFR 0.152.
 */
package GInMiR;

import GInMiR.mature_str;
import GInMiR.readFasta;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import loci.loci;

public class miR_family {
    public TreeMap<String, loci> hsa_gff = new TreeMap();
    public Map<String, String> hsa_miR = new HashMap<String, String>();
    public Map<String, String> family = new HashMap<String, String>();
    public Map<String, ArrayList<loci>> family_loci = new TreeMap<String, ArrayList<loci>>();
    public Map<String, Integer> family_loci_reads = new TreeMap<String, Integer>();
    public Map<String, String> hairpin = new TreeMap<String, String>();
    public Map<String, mature_str> mature = new TreeMap<String, mature_str>();

    miR_family() throws FileNotFoundException, IOException {
        String line;
        String filename1 = "miRbase/hsa_hg18.gff";
        BufferedReader in1 = new BufferedReader(new FileReader(filename1));
        int rec_no = 0;
        while ((line = in1.readLine()) != null) {
            boolean i;
            if (line.startsWith("#")) continue;
            ++rec_no;
            String[] str = line.split("\t");
            if (str.length < 8) continue;
            String chr = "chr" + str[0];
            String strand = str[6];
            int loci_start = Integer.parseInt(str[3]);
            int loci_stop = Integer.parseInt(str[4]);
            String[] substr = str[8].split(";");
            String miR_ID = substr[1].trim().replace("\"", "").replace("ID=", "");
            if (miR_ID.startsWith("hsa-mir-3198")) {
                i = false;
            }
            if (rec_no > 1286) {
                i = false;
            }
            this.hsa_gff.put(miR_ID, new loci(chr, strand, loci_start, loci_stop));
        }
        in1.close();
        readFasta rfa_hairpin = new readFasta("miRbase/hairpin.fa");
        this.hairpin = rfa_hairpin.getFa();
        readFasta rfa = new readFasta("miRbase/mature.fa");
        TreeMap<String, String> mature_having_3p_5p = rfa.getFa();
        for (String key : mature_having_3p_5p.keySet()) {
            if (key.equals("hsa-mir-3198")) {
                boolean debug = false;
            }
            String mature_seq = mature_having_3p_5p.get(key);
            this.mature.put(key, new mature_str(mature_seq));
            String hairpin_mir_id = key.replace("-3p", "").replace("-5p", "").replace("*", "");
            if (this.hsa_gff.get(hairpin_mir_id) != null && this.hairpin.get(hairpin_mir_id) != null) {
                loci l = this.hsa_gff.get(hairpin_mir_id);
                String hairPin_seq = this.hairpin.get(hairpin_mir_id);
                this.mature_add_loci(key, l, mature_seq, hairPin_seq);
            } else {
                int seq_no = 1;
                hairpin_mir_id = hairpin_mir_id + "-" + seq_no;
                while (this.hsa_gff.get(hairpin_mir_id) != null && this.hairpin.get(hairpin_mir_id) != null) {
                    loci l = this.hsa_gff.get(hairpin_mir_id);
                    String hairPin_seq = this.hairpin.get(hairpin_mir_id);
                    this.mature_add_loci(key, l, mature_seq, hairPin_seq);
                    hairpin_mir_id = hairpin_mir_id + "-" + ++seq_no;
                }
            }
            if (!this.mature.get((Object)key).locus.isEmpty()) continue;
            this.mature.remove(key);
            boolean debug = false;
        }
    }

    private void mature_add_loci(String miR_ID, loci l, String mature_seq, String hairPin_seq) {
        int mature_offset_start = hairPin_seq.indexOf(mature_seq);
        int mature_offset_stop = mature_offset_start + mature_seq.length() - 1;
        if (l.getstrand().equals("+")) {
            this.mature.get(miR_ID).add_locus(new loci(l.getChr(), l.getstrand(), l.getstart_loci() + mature_offset_start, l.getstart_loci() + mature_offset_stop));
        } else {
            this.mature.get(miR_ID).add_locus(new loci(l.getChr(), l.getstrand(), l.getstop_loci() - mature_offset_stop, l.getstop_loci() - mature_offset_start));
        }
    }

    public void miR_family_read_reset() {
        for (String key : this.family_loci_reads.keySet()) {
            this.family_loci_reads.put(key, 0);
        }
    }

    static void get_hsa_gff() throws FileNotFoundException, IOException {
        String filename = "targetScan/hsa.gff";
        BufferedReader in = new BufferedReader(new FileReader(filename), 0x100000);
        String line = in.readLine();
        boolean rec_no = false;
        for (int i = 0; i < 7; ++i) {
            line = in.readLine();
        }
        while ((line = in.readLine()) != null) {
            String[] str = line.split("\t");
        }
    }
}

