/*
 * Decompiled with CFR 0.152.
 */
package RNAfold;

import RNAfold.Line;
import RNAfold.NT_position;
import RNAfold.subSeq_struct;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import javax.swing.JPanel;
import loci.loci;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Canvas
extends JPanel {
    String seq;
    String structure;
    String title;
    Dimension canvasSize;
    int len_edge = 25;
    int numRecursor = 0;
    Point2D.Double left_bottom_position = new Point2D.Double(500.0, 500.0);
    NT_position[] all_positions;
    ArrayList<Point> bond = new ArrayList();
    loci[] annotations;
    int max_x_pos;

    Canvas(String seq1, String structure1, loci[] reads1, String title1, Dimension canvasSize1) {
        if (seq1.length() != structure1.length()) {
            System.out.println(seq1.length() + "!=" + structure1.length());
            return;
        }
        this.seq = seq1;
        this.structure = structure1;
        this.annotations = reads1;
        this.title = title1;
        this.canvasSize = canvasSize1;
    }

    public void setSeq(String seq1, String structure1, loci[] reads1, String title1) {
        this.seq = seq1;
        this.structure = structure1;
        this.annotations = reads1;
        this.title = title1;
    }

    @Override
    public void paintComponent(Graphics g) {
        int i;
        int i2;
        super.paintComponent(g);
        this.bond.clear();
        Font f = g.getFont();
        g.setFont(new Font("SansSerif", 1, 14));
        int title_height = g.getFontMetrics().getAscent();
        g.drawString(this.title, (this.getWidth() - g.getFontMetrics().stringWidth(this.title)) / 2, 5 + title_height);
        g.setFont(f);
        ArrayList a = new ArrayList();
        this.all_positions = new NT_position[this.seq.length()];
        Point2D.Double start_pt = new Point2D.Double(10.0, 5 + this.len_edge);
        Point2D.Double stop_pt = new Point2D.Double(10.0, 5.0);
        Line start_pair = new Line(start_pt, stop_pt);
        this.draw(g, this.seq, 0, this.structure, start_pair);
        this.find_end_loop();
        double[] annotations_y_pos = this.getAnnotation_y_pos(g);
        double min_x = Double.MAX_VALUE;
        double min_y = Double.MAX_VALUE;
        for (i2 = 0; i2 < this.all_positions.length; ++i2) {
            if (min_x > this.all_positions[i2].pos.x) {
                min_x = this.all_positions[i2].pos.x;
            }
            if (!(min_y > -this.all_positions[i2].pos.y)) continue;
            min_y = -this.all_positions[i2].pos.y;
        }
        if (annotations_y_pos != null) {
            for (i2 = 0; i2 < annotations_y_pos.length; ++i2) {
                if (!(min_y > -annotations_y_pos[i2])) continue;
                min_y = -annotations_y_pos[i2];
            }
        }
        this.left_bottom_position.x = min_x - 50.0;
        this.left_bottom_position.y = min_y - 20.0 - (double)title_height;
        double max_x = Double.MIN_VALUE;
        double max_y = Double.MIN_VALUE;
        for (i = 0; i < this.all_positions.length; ++i) {
            this.all_positions[i].pos.x -= this.left_bottom_position.x;
            this.all_positions[i].pos.y = -this.left_bottom_position.y - this.all_positions[i].pos.y;
            if (max_x < this.all_positions[i].pos.x) {
                max_x = this.all_positions[i].pos.x;
            }
            if (!(max_y < this.all_positions[i].pos.y)) continue;
            max_y = this.all_positions[i].pos.y;
        }
        if (annotations_y_pos != null) {
            for (i = 0; i < annotations_y_pos.length; ++i) {
                annotations_y_pos[i] = -this.left_bottom_position.y - annotations_y_pos[i];
                if (!(max_y < annotations_y_pos[i])) continue;
                max_y = annotations_y_pos[i];
            }
        }
        this.setPreferredSize(new Dimension((int)(max_x += 20.0), (int)(max_y += 20.0)));
        this.drawBoldString(g, this.all_positions[0].nt, (int)this.all_positions[0].pos.x, (int)this.all_positions[0].pos.y);
        for (i = 1; i < this.all_positions.length; ++i) {
            this.drawColoredString(g, this.all_positions[i].nt, (int)this.all_positions[i].pos.x, (int)this.all_positions[i].pos.y);
        }
        for (i = 0; i < this.bond.size(); ++i) {
            this.drawBond(g, this.all_positions[this.bond.get((int)i).x].pos, this.all_positions[this.bond.get((int)i).y].pos);
        }
        this.drawReads(g, annotations_y_pos);
    }

    private void find_end_loop() {
        double max_x = -1.7976931348623157E308;
        this.max_x_pos = -1;
        for (int i = 0; i < this.all_positions.length; ++i) {
            this.all_positions[i].pos.x -= this.left_bottom_position.x;
            if (!(max_x < this.all_positions[i].pos.x)) continue;
            max_x = this.all_positions[i].pos.x;
            this.max_x_pos = i + 1;
        }
    }

    private double[] getAnnotation_y_pos(Graphics g) {
        if (this.annotations == null) {
            return null;
        }
        double[] annotations_y_pos = new double[this.annotations.length];
        int fontHeight = g.getFontMetrics().getAscent();
        for (int read_no = 0; read_no < this.annotations.length; ++read_no) {
            int j;
            int i;
            int start_pos = this.annotations[read_no].getstart_loci();
            int stop_pos = this.annotations[read_no].getstop_loci();
            double test_up_y_pos = Double.MIN_VALUE;
            double test_down_y_pos = Double.MAX_VALUE;
            if (this.all_positions[start_pos - 1].pos.x < this.all_positions[stop_pos - 1].pos.x) {
                if (this.line_through_loop(start_pos, stop_pos)) {
                    stop_pos = this.max_x_pos;
                }
                for (i = start_pos - 1; i < stop_pos; ++i) {
                    if (!(test_up_y_pos < this.all_positions[i].pos.y)) continue;
                    test_up_y_pos = this.all_positions[i].pos.y;
                }
                for (j = 0; j < read_no; ++j) {
                    if (this.annotations[j].compare(this.annotations[read_no]) != 0 || !(test_up_y_pos < annotations_y_pos[j])) continue;
                    test_up_y_pos = annotations_y_pos[j];
                }
                annotations_y_pos[read_no] = test_up_y_pos += (double)fontHeight;
                continue;
            }
            if (this.line_through_loop(start_pos, stop_pos)) {
                start_pos = this.max_x_pos;
            }
            for (i = start_pos - 1; i < stop_pos; ++i) {
                if (!(test_down_y_pos > this.all_positions[i].pos.y)) continue;
                test_down_y_pos = this.all_positions[i].pos.y;
            }
            for (j = 0; j < read_no; ++j) {
                if (this.annotations[j].compare(this.annotations[read_no]) != 0 || !(test_down_y_pos > annotations_y_pos[j])) continue;
                test_down_y_pos = annotations_y_pos[j];
            }
            annotations_y_pos[read_no] = test_down_y_pos -= (double)fontHeight;
        }
        return annotations_y_pos;
    }

    private boolean line_through_loop(int x_start, int x_stop) {
        return this.max_x_pos > Math.min(x_start, x_stop) && this.max_x_pos < Math.max(x_start, x_stop);
    }

    private void drawReads(Graphics g, double[] annotations_test_y_pos) {
        if (annotations_test_y_pos == null) {
            return;
        }
        int fontwidth = g.getFontMetrics().charWidth('A');
        for (int read_no = 0; read_no < this.annotations.length; ++read_no) {
            double middle_pos;
            String str = Integer.toString(this.annotations[read_no].getnumReads());
            int start_pos = this.annotations[read_no].getstart_loci() - 1;
            int stop_pos = this.annotations[read_no].getstop_loci() - 1;
            int y_pos = (int)annotations_test_y_pos[read_no];
            if (this.all_positions[start_pos].pos.x < this.all_positions[stop_pos].pos.x) {
                if (this.line_through_loop(start_pos, stop_pos)) {
                    g.drawLine((int)this.all_positions[start_pos].pos.x, y_pos, (int)this.all_positions[stop_pos].pos.x + fontwidth, y_pos);
                    g.fillRect((int)this.all_positions[stop_pos].pos.x, y_pos, (int)(this.all_positions[this.max_x_pos - 1].pos.x - this.all_positions[stop_pos].pos.x + (double)fontwidth), 2);
                } else {
                    g.drawLine((int)this.all_positions[start_pos].pos.x, y_pos, (int)this.all_positions[stop_pos].pos.x + fontwidth, y_pos);
                }
                middle_pos = (this.all_positions[start_pos].pos.x + this.all_positions[stop_pos].pos.x + (double)fontwidth) / 2.0;
                g.drawString(str, (int)(middle_pos - (double)g.getFontMetrics().stringWidth(str) / 2.0), y_pos);
                continue;
            }
            if (this.line_through_loop(start_pos, stop_pos)) {
                g.drawLine((int)this.all_positions[start_pos].pos.x + fontwidth, y_pos - g.getFontMetrics().getAscent(), (int)this.all_positions[stop_pos].pos.x, y_pos - g.getFontMetrics().getAscent());
                g.fillRect((int)this.all_positions[start_pos].pos.x, y_pos - g.getFontMetrics().getAscent() - 1, (int)(this.all_positions[this.max_x_pos - 1].pos.x - this.all_positions[start_pos].pos.x + (double)fontwidth), 2);
            } else {
                g.drawLine((int)this.all_positions[start_pos].pos.x + fontwidth, y_pos - g.getFontMetrics().getAscent(), (int)this.all_positions[stop_pos].pos.x, y_pos - g.getFontMetrics().getAscent());
            }
            middle_pos = (this.all_positions[start_pos].pos.x + this.all_positions[stop_pos].pos.x + (double)fontwidth) / 2.0;
            g.drawString(str, (int)(middle_pos - (double)(g.getFontMetrics().stringWidth(str) / 2)), y_pos - 2);
        }
    }

    private double drawReadExpressionLine(Graphics g, int start_pos, int stop_pos, String str, double up_y_pos, double down_y_pos, int left) {
        double result;
        int fontwidth = g.getFontMetrics().charWidth('A');
        if (this.all_positions[start_pos - 1].pos.x < this.all_positions[stop_pos - 1].pos.x) {
            double y_pos = up_y_pos;
            for (int i = start_pos - 1; i < stop_pos - 1; ++i) {
                if (!(y_pos > this.all_positions[i].pos.y)) continue;
                y_pos = this.all_positions[i].pos.y;
            }
            result = y_pos;
            y_pos = y_pos - (double)g.getFontMetrics().getAscent() - (double)left;
            g.drawLine((int)this.all_positions[start_pos - 1].pos.x, (int)y_pos, (int)this.all_positions[stop_pos - 1].pos.x + fontwidth, (int)y_pos);
            double middle_pos = (this.all_positions[start_pos - 1].pos.x + this.all_positions[stop_pos - 1].pos.x + (double)fontwidth) / 2.0;
            g.drawString(str, (int)(middle_pos - (double)g.getFontMetrics().stringWidth(str) / 2.0), (int)y_pos);
        } else {
            double y_pos = down_y_pos;
            for (int i = start_pos - 1; i < stop_pos - 1; ++i) {
                if (!(y_pos < this.all_positions[i].pos.y)) continue;
                y_pos = this.all_positions[i].pos.y;
            }
            result = y_pos;
            y_pos = y_pos + 1.0 + (double)left;
            g.drawLine((int)this.all_positions[start_pos - 1].pos.x + fontwidth, (int)y_pos, (int)this.all_positions[stop_pos - 1].pos.x, (int)y_pos);
            double middle_pos = (this.all_positions[start_pos - 1].pos.x + this.all_positions[stop_pos - 1].pos.x + (double)fontwidth) / 2.0;
            g.drawString(str, (int)(middle_pos - (double)(g.getFontMetrics().stringWidth(str) / 2)), (int)(y_pos + (double)g.getFontMetrics().getAscent() - 3.0));
        }
        return result;
    }

    private void draw(Graphics g, String seq, int seq_no, String structure, Line start_pair) {
        ArrayList<Point> next_pair = new ArrayList<Point>();
        if (this.find_pair(structure, next_pair)) {
            if (next_pair.size() == 1) {
                int left_next_terminal = next_pair.get((int)0).x;
                int right_next_terminal = next_pair.get((int)0).y;
                Line terminal_pair = this.draw_bias_loop(g, seq.substring(0, left_next_terminal + 1), seq_no, seq.substring(right_next_terminal), seq_no + right_next_terminal, start_pair);
                this.draw(g, seq.substring(left_next_terminal + 1, right_next_terminal), seq_no + left_next_terminal + 1, structure.substring(left_next_terminal + 1, right_next_terminal), terminal_pair);
            } else if (next_pair.isEmpty()) {
                this.draw_loop(g, seq, seq_no, start_pair);
            } else {
                String loop_seq = seq.substring(0, next_pair.get((int)0).x + 1);
                ArrayList<subSeq_struct> branch_no = new ArrayList<subSeq_struct>();
                branch_no.add(new subSeq_struct(next_pair.get((int)0).x, seq.substring(next_pair.get((int)0).x + 1, next_pair.get((int)0).y), structure.substring(next_pair.get((int)0).x + 1, next_pair.get((int)0).y)));
                for (int i = 0; i < next_pair.size() - 1; ++i) {
                    loop_seq = loop_seq + seq.substring(next_pair.get((int)i).y, next_pair.get((int)(i + 1)).x + 1);
                    branch_no.add(new subSeq_struct(loop_seq.length() - 1, seq.substring(next_pair.get((int)(i + 1)).x + 1, next_pair.get((int)(i + 1)).y), structure.substring(next_pair.get((int)(i + 1)).x + 1, next_pair.get((int)(i + 1)).y)));
                }
                loop_seq = loop_seq + seq.substring(next_pair.get((int)(next_pair.size() - 1)).y);
                this.draw_multi_loop(g, loop_seq, seq_no, branch_no, start_pair);
            }
        }
    }

    private int draw_multi_loop(Graphics g, String seq, int seq_no, ArrayList<subSeq_struct> branch_no, Line start_pair) {
        int numVertices = seq.length();
        int numBranch = branch_no.size();
        int numPoints = seq.length() - 2 * branch_no.size();
        double alpha = this.first_angle_multi_loop(numBranch, numPoints);
        double a = 180.0 * alpha / Math.PI;
        double radius = (double)this.len_edge / (2.0 * Math.sin(alpha));
        Point2D.Double center_pt = this.find_origin(start_pair.start_pt, start_pair.stop_pt, radius);
        double beta = (Math.PI * 2 - (double)(2 * (branch_no.size() + 1)) * alpha) / (double)(numBranch + numPoints + 1);
        double aa = 180.0 * beta / Math.PI;
        double current_angle = 0.0;
        double aaa = 180.0 * current_angle / Math.PI;
        int current_pos_no = seq_no;
        for (int i = 0; i < numVertices; ++i) {
            Point2D.Double rotate_pt;
            int current_branch = this.findBranchNo(i - 1, branch_no);
            if (current_branch > -1) {
                aaa = 180.0 * (current_angle += 2.0 * alpha) / Math.PI;
                rotate_pt = this.rotation(start_pair.start_pt, center_pt, current_angle);
                int subHairPin_len = branch_no.get((int)current_branch).seq.length();
                int previous_pos_no = current_pos_no - 1;
                this.all_positions[current_pos_no += subHairPin_len] = new NT_position(seq.charAt(i), rotate_pt.x, rotate_pt.y);
                this.bond.add(new Point(previous_pos_no, current_pos_no));
                Point2D.Double new_start_pair1 = new Point2D.Double(this.all_positions[previous_pos_no].pos.x, this.all_positions[previous_pos_no].pos.y);
                Point2D.Double new_start_pair2 = new Point2D.Double(this.all_positions[current_pos_no].pos.x, this.all_positions[current_pos_no].pos.y);
                Line sub_start_pair = new Line(new_start_pair1, new_start_pair2);
                int new_seq_no = current_pos_no - (branch_no.get((int)current_branch).seq.length() + 1);
                this.draw(g, branch_no.get((int)current_branch).seq, previous_pos_no + 1, branch_no.get((int)current_branch).struct, sub_start_pair);
            } else {
                aaa = 180.0 * (current_angle += beta) / Math.PI;
                rotate_pt = this.rotation(start_pair.start_pt, center_pt, current_angle);
                this.all_positions[current_pos_no] = new NT_position(seq.charAt(i), rotate_pt.x, rotate_pt.y);
            }
            ++current_pos_no;
        }
        return (int)radius * 2;
    }

    private int findBranchNo(int seq_no, ArrayList<subSeq_struct> branch_no) {
        for (int i = 0; i < branch_no.size(); ++i) {
            if (branch_no.get((int)i).no != seq_no) continue;
            return i;
        }
        return -1;
    }

    private double first_angle_multi_loop(int numBranch, int numPoints) {
        double best_beta = -1.0;
        double min_error = Double.MAX_VALUE;
        for (double degree = 1.0; degree <= Math.ceil(360.0 / ((double)(numPoints + 2 * numBranch) + 3.0)); degree += 0.01) {
            double beta = Math.PI * (degree / 180.0);
            double alpha = (Math.PI * 2 - (double)(numBranch + numPoints + 1) * beta) / (2.0 * (double)(numBranch + 1));
            double error = Math.abs(2.0 * Math.sin(beta / 2.0) - Math.sin(alpha));
            if (!(error < min_error)) continue;
            min_error = error;
            best_beta = beta;
        }
        double a = 180.0 * best_beta / Math.PI;
        double b = (Math.PI * 2 - (double)(numBranch + numPoints + 1) * best_beta) / (double)(2 * (numBranch + 1)) * 180.0 / Math.PI;
        return (Math.PI * 2 - (double)(numBranch + numPoints + 1) * best_beta) / (double)(2 * (numBranch + 1));
    }

    private double first_angle_loop(int numPoints) {
        double best_beta = -1.0;
        double min_error = Double.MAX_VALUE;
        for (double degree = Math.floor(180.0 / ((double)numPoints + 1.0)); degree <= Math.ceil(360.0 / ((double)numPoints + 3.0)); degree += 0.01) {
            double beta = Math.PI * (degree / 180.0);
            double error = Math.abs(2.0 * Math.sin(beta / 2.0) - Math.sin((double)(numPoints + 1) * beta / 2.0));
            if (!(error < min_error)) continue;
            min_error = error;
            best_beta = beta;
        }
        double a = 180.0 * best_beta / Math.PI;
        double b = (Math.PI - (double)(numPoints + 1) * best_beta / 2.0) * 180.0 / Math.PI;
        return Math.PI - (double)(numPoints + 1) * best_beta / 2.0;
    }

    private boolean find_pair(String struct, ArrayList<Point> pair) {
        int bracket_balance = 0;
        int internal_loop_start = -1;
        for (int pos = 0; pos < struct.length(); ++pos) {
            if (struct.charAt(pos) == '(' && ++bracket_balance == 1) {
                internal_loop_start = pos;
            }
            if (struct.charAt(pos) != ')' || --bracket_balance != 0) continue;
            pair.add(new Point(internal_loop_start, pos));
        }
        return bracket_balance == 0;
    }

    private int draw_loop(Graphics g, String seq, int seq_no, Line start_pair) {
        int numVertices = seq.length();
        double alpha = this.first_angle_loop(numVertices);
        double a = alpha * 180.0 / Math.PI;
        double radius = (double)this.len_edge / (2.0 * Math.sin(alpha));
        Point2D.Double center_pt = this.find_origin(start_pair.start_pt, start_pair.stop_pt, radius);
        double beta = (Math.PI * 2 - 2.0 * alpha) / (double)(numVertices + 1);
        double b = beta * 180.0 / Math.PI;
        int current_pos_no = seq_no;
        for (int i = 0; i < numVertices; ++i) {
            Point2D.Double rotate_pt = this.rotation(start_pair.start_pt, center_pt, (double)(i + 1) * beta);
            this.all_positions[current_pos_no] = new NT_position(seq.charAt(i), rotate_pt.x, rotate_pt.y);
            ++current_pos_no;
        }
        return (int)radius * 2;
    }

    private Line draw_bias_loop(Graphics g, String seq1, int seq_no1, String seq2, int seq_no2, Line start_pair) {
        Point2D.Double rotate_pt;
        Line result = new Line();
        double alpha = this.first_angle_bias_loop(Math.max(seq1.length(), seq2.length()));
        double a = alpha * 180.0 / Math.PI;
        double radius = (double)this.len_edge / (2.0 * Math.sin(alpha));
        Point2D.Double center_pt = this.find_origin(start_pair.start_pt, start_pair.stop_pt, radius);
        int numVertices1 = seq1.length();
        double beta1 = (Math.PI - 2.0 * alpha) / (double)numVertices1;
        double b = beta1 * 180.0 / Math.PI;
        int current_pos_no1 = seq_no1;
        for (int i = 0; i < numVertices1; ++i) {
            rotate_pt = this.rotation(start_pair.start_pt, center_pt, (double)(i + 1) * beta1);
            this.all_positions[current_pos_no1] = new NT_position(seq1.charAt(i), rotate_pt.x, rotate_pt.y);
            ++current_pos_no1;
        }
        result.start_pt.x = this.all_positions[current_pos_no1 - 1].pos.x;
        result.start_pt.y = this.all_positions[current_pos_no1 - 1].pos.y;
        int current_pos_no2 = seq_no2;
        rotate_pt = this.rotation(start_pair.start_pt, center_pt, Math.PI);
        this.all_positions[current_pos_no2] = new NT_position(seq2.charAt(0), rotate_pt.x, rotate_pt.y);
        result.stop_pt.x = this.all_positions[current_pos_no2].pos.x;
        result.stop_pt.y = this.all_positions[current_pos_no2].pos.y;
        int numVertices2 = seq2.length();
        double beta2 = (Math.PI - 2.0 * alpha) / (double)numVertices2;
        this.bond.add(new Point(current_pos_no1 - 1, current_pos_no2));
        for (int i = 1; i < numVertices2; ++i) {
            rotate_pt = this.rotation(start_pair.start_pt, center_pt, Math.PI + (double)i * beta2);
            this.all_positions[++current_pos_no2] = new NT_position(seq2.charAt(i), rotate_pt.x, rotate_pt.y);
        }
        return result;
    }

    private void drawBond(Graphics g, Point2D.Double pt_1, Point2D.Double pt_2) {
        int font_width = g.getFontMetrics().charWidth('A');
        int font_height = g.getFontMetrics().getAscent();
        double x1 = pt_1.x + (double)font_width / 2.0;
        double y1 = pt_1.y + (double)g.getFontMetrics().getDescent() / 2.0 - (double)font_height / 2.0;
        double x2 = pt_2.x + (double)font_width / 2.0;
        double y2 = pt_2.y + (double)g.getFontMetrics().getDescent() / 2.0 - (double)font_height / 2.0;
        Point2D.Double point_1 = new Point2D.Double(x1, y1);
        Point2D.Double point_2 = new Point2D.Double(x2, y2);
        this.cutting_both_terminal(point_1, point_2, font_width, font_height);
        g.drawLine((int)point_1.x, (int)point_1.y, (int)point_2.x, (int)point_2.y);
    }

    private void cutting_both_terminal(Point2D.Double p1, Point2D.Double p2, double box_x_len, double box_y_len) {
        double r = Math.sqrt(box_x_len * box_x_len + box_y_len * box_y_len) / 2.0;
        double short_x = r * (p2.x - p1.x) / p2.distance(p1);
        double short_y = r * (p2.y - p1.y) / p2.distance(p1);
        p1.x += short_x;
        p1.y += short_y;
        short_x = r * (p1.x - p2.x) / p1.distance(p2);
        short_y = r * (p1.y - p2.y) / p1.distance(p2);
        p2.x += short_x;
        p2.y += short_y;
    }

    private Point2D.Double rotation(Point2D.Double pt, Point2D.Double origin, double theta) {
        double x = (pt.x - origin.x) * Math.cos(theta) + (pt.y - origin.y) * Math.sin(theta) + origin.x;
        double y = (pt.y - origin.y) * Math.cos(theta) - (pt.x - origin.x) * Math.sin(theta) + origin.y;
        return new Point2D.Double(x, y);
    }

    private Point2D.Double find_origin(Point2D.Double pt1, Point2D.Double pt2, double radius) {
        double half_dist = Math.sqrt((pt1.x - pt2.x) * (pt1.x - pt2.x) + (pt1.y - pt2.y) * (pt1.y - pt2.y) + 1.0E-4) / 2.0;
        double dist_center2middle = Math.sqrt(radius * radius - half_dist * half_dist + 1.0E-4);
        double center_x = (pt1.x + pt2.x) / 2.0;
        double center_y = (pt1.y + pt2.y) / 2.0;
        double p1_side_x = dist_center2middle / half_dist * (pt1.x - center_x) + center_x;
        double p1_side_y = dist_center2middle / half_dist * (pt1.y - center_y) + center_y;
        return this.rotation(new Point2D.Double(p1_side_x, p1_side_y), new Point2D.Double(center_x, center_y), 1.5707963267948966);
    }

    private void drawColoredString(Graphics g, char letter, int x, int y) {
        if (Character.isUpperCase(letter)) {
            Color c = g.getColor();
            g.setColor(Color.red);
            g.drawString(Character.toString(letter), x, y);
            g.setColor(c);
        } else {
            g.drawString(Character.toString(letter).toUpperCase(), x, y);
        }
    }

    private void drawBoldString(Graphics g, char letter, int x, int y) {
        Font font = g.getFont();
        g.setFont(new Font(font.getFontName(), 1, font.getSize()));
        g.drawString(Character.toString(letter).toUpperCase(), x, y);
        g.setFont(font);
    }

    private double first_angle_bias_loop(int numPoints) {
        double best_beta = -1.0;
        double min_error = Double.MAX_VALUE;
        if (numPoints > 10) {
            boolean i = false;
        }
        for (double degree = Math.floor(180.0 / ((double)numPoints * 3.0)); degree <= Math.ceil(180.0 / ((double)numPoints + 2.0)); degree += 0.01) {
            double beta = Math.PI * (degree / 180.0);
            double error = Math.abs(2.0 * Math.sin(beta / 2.0) - Math.cos((double)numPoints * beta / 2.0));
            if (!(error < min_error)) continue;
            min_error = error;
            best_beta = beta;
        }
        return 1.5707963267948966 - (double)numPoints * best_beta / 2.0;
    }
}

