/*
 * Decompiled with CFR 0.152.
 */
package RNAfold;

import RNAfold.Canvas;
import RNAfold.RNAfold;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import loci.loci;

public class RNAfigure
extends JFrame {
    Canvas canvas;
    JScrollPane jScrollPane2;
    JTextArea jTextArea1;
    JTextArea jTextArea2;
    String title;
    String seq;
    String struct;
    loci[] reads;
    Dimension canvasSize;

    public RNAfigure(String seq1, String struct1, loci mature, loci[] reads1, String title1, Dimension canvasSize1) {
        this.title = title1;
        seq1 = seq1.toLowerCase().replace('t', 'u');
        this.seq = mature != null ? seq1.substring(0, mature.getstart_loci() - 1) + seq1.substring(mature.getstart_loci() - 1, mature.getstop_loci()).toUpperCase() + seq1.substring(mature.getstop_loci()) : seq1;
        this.struct = struct1;
        this.canvasSize = canvasSize1;
        this.reads = reads1;
        this.componentinit();
    }

    private void componentinit() {
        if (this.seq.length() != this.struct.length()) {
            System.out.println(this.seq.length() + "!=" + this.struct.length());
            return;
        }
        Box vbox = Box.createVerticalBox();
        Box hbox1 = Box.createHorizontalBox();
        JButton jButton2 = new JButton("change sequence");
        hbox1.add(Box.createHorizontalStrut(50));
        hbox1.add(jButton2);
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                RNAfigure.this.jButton2ActionPerformed(evt);
            }
        });
        JButton jButton3 = new JButton("anti-sense");
        hbox1.add(Box.createHorizontalStrut(50));
        hbox1.add(jButton3);
        jButton3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                RNAfigure.this.jButton3ActionPerformed(evt);
            }
        });
        JButton jButton1 = new JButton("sava image");
        hbox1.add(Box.createHorizontalStrut(50));
        hbox1.add(jButton1);
        jButton1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                RNAfigure.this.jButton1ActionPerformed(evt);
            }
        });
        vbox.add(Box.createVerticalStrut(10));
        vbox.add(hbox1);
        Box hbox2 = Box.createHorizontalBox();
        this.jTextArea1 = new JTextArea(this.seq, 3, 5);
        this.jTextArea1.setLineWrap(true);
        Font f = this.jTextArea1.getFont();
        this.jTextArea1.setFont(new Font("Courier New", f.getStyle(), f.getSize()));
        JScrollPane jScrollPane1 = new JScrollPane();
        jScrollPane1.setViewportView(this.jTextArea1);
        vbox.add(Box.createVerticalStrut(10));
        hbox2.add(jScrollPane1);
        vbox.add(hbox2);
        Box hbox3 = Box.createHorizontalBox();
        this.jTextArea2 = new JTextArea(this.struct, 3, 5);
        this.jTextArea2.setLineWrap(true);
        this.jTextArea2.setEditable(false);
        this.jTextArea2.setFont(new Font("Courier New", f.getStyle(), f.getSize()));
        JScrollPane jScrollPane3 = new JScrollPane();
        jScrollPane3.setViewportView(this.jTextArea2);
        vbox.add(Box.createVerticalStrut(10));
        hbox3.add(jScrollPane3);
        vbox.add(hbox3);
        this.canvas = new Canvas(this.seq, this.struct, this.reads, this.title, this.canvasSize);
        this.canvas.setBackground(new Color(255, 255, 255));
        this.jScrollPane2 = new JScrollPane();
        this.jScrollPane2.setPreferredSize(this.canvasSize);
        this.jScrollPane2.setViewportView(this.canvas);
        vbox.add(Box.createVerticalStrut(10));
        vbox.add(this.jScrollPane2);
        this.add(vbox);
    }

    private void jButton3ActionPerformed(ActionEvent evt) {
        this.seq = this.toMinusStrand(this.seq).replace('t', 'u');
        this.jTextArea1.setText(this.seq);
        RNAfold rf = new RNAfold(this.seq);
        this.struct = rf.getStruct();
        this.jTextArea2.setText(this.struct);
        this.reads = null;
        this.canvas.setSeq(this.seq, this.struct, this.reads, this.title);
        this.canvas.repaint();
    }

    public String toMinusStrand(String seq) {
        seq = seq.toLowerCase().replace("u", "t");
        String reverse = new StringBuffer(seq).reverse().toString();
        return reverse.replace("c", "@").replace("g", "c").replace("@", "g").replace("a", "#").replace("t", "a").replace("#", "t");
    }

    private void jButton2ActionPerformed(ActionEvent evt) {
        this.seq = this.jTextArea1.getText();
        RNAfold rf = new RNAfold(this.seq);
        this.struct = rf.getStruct();
        this.jTextArea2.setText(this.struct);
        this.reads = null;
        this.canvas.setSeq(this.seq, this.struct, this.reads, this.title);
        this.canvas.repaint();
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        int w = this.canvas.getWidth();
        int h = this.canvas.getHeight();
        BufferedImage bi = new BufferedImage(w, h, 13);
        Graphics2D g2 = bi.createGraphics();
        this.canvas.paint(g2);
        g2.dispose();
        try {
            String iamgeName = this.title + ".jpg";
            ImageIO.write((RenderedImage)bi, "jpg", new File(iamgeName));
            JOptionPane.showMessageDialog(null, "A image has been stored in " + new File(".").getAbsolutePath().substring(0, new File(".").getAbsolutePath().length() - 1) + iamgeName, "message", -1);
        }
        catch (IOException ioe) {
            System.out.println("Panel write help: " + ioe.getMessage());
        }
    }
}

