/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.analysis;

import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import net.sf.picard.analysis.RnaSeqMetrics;
import net.sf.picard.analysis.SinglePassSamProgram;
import net.sf.picard.annotation.Gene;
import net.sf.picard.annotation.GeneAnnotationReader;
import net.sf.picard.annotation.LocusFunction;
import net.sf.picard.cmdline.Option;
import net.sf.picard.cmdline.Usage;
import net.sf.picard.metrics.MetricsFile;
import net.sf.picard.reference.ReferenceSequence;
import net.sf.picard.util.Interval;
import net.sf.picard.util.IntervalList;
import net.sf.picard.util.Log;
import net.sf.picard.util.OverlapDetector;
import net.sf.samtools.AlignmentBlock;
import net.sf.samtools.SAMFileHeader;
import net.sf.samtools.SAMRecord;
import net.sf.samtools.SAMSequenceDictionary;
import net.sf.samtools.util.CoordMath;
import net.sf.samtools.util.SequenceUtil;

public class CollectRnaSeqMetrics
extends SinglePassSamProgram {
    private static final Log LOG = Log.getInstance(CollectRnaSeqMetrics.class);
    @Usage
    public final String USAGE = this.getStandardUsagePreamble() + "Program to collect metrics about the alignment of RNA to various functional classes of loci in the genome:" + " coding, intronic, UTR, intergenic, ribosomal.\n" + "Also determines strand-specificity for strand-specific libraries.";
    @Option(doc="Gene annotations in refFlat form.  Format described here: http://genome.ucsc.edu/goldenPath/gbdDescriptionsOld.html#RefFlat")
    public File REF_FLAT;
    @Option(doc="Location of rRNA sequences in genome, in interval_list format.  If not specified no bases will be identified as being ribosomal.  Format described here: http://picard.sourceforge.net/javadoc/net/sf/picard/util/IntervalList.html", optional=true)
    public File RIBOSOMAL_INTERVALS;
    @Option(shortName="STRAND", doc="For strand-specific library prep. For unpaired reads, use FIRST_READ_TRANSCRIPTION_STRAND if the reads are expected to be on the transcription strand.")
    public StrandSpecificity STRAND_SPECIFICITY;
    private OverlapDetector<Gene> geneOverlapDetector;
    private final OverlapDetector<Interval> ribosomalSequenceOverlapDetector = new OverlapDetector(0, 0);
    private RnaSeqMetrics metrics;

    public static void main(String[] argv) {
        new CollectRnaSeqMetrics().instanceMainWithExit(argv);
    }

    @Override
    protected void setup(SAMFileHeader header, File samFile) {
        this.geneOverlapDetector = GeneAnnotationReader.loadRefFlat(this.REF_FLAT, header.getSequenceDictionary());
        LOG.info("Loaded " + this.geneOverlapDetector.getAll().size() + " genes.");
        if (this.RIBOSOMAL_INTERVALS != null) {
            IntervalList ribosomalIntervals = IntervalList.fromFile(this.RIBOSOMAL_INTERVALS);
            SequenceUtil.assertSequenceDictionariesEqual((SAMSequenceDictionary)header.getSequenceDictionary(), (SAMSequenceDictionary)ribosomalIntervals.getHeader().getSequenceDictionary());
            ribosomalIntervals.unique();
            List<Interval> intervals = ribosomalIntervals.getIntervals();
            this.ribosomalSequenceOverlapDetector.addAll(intervals, intervals);
        }
        this.metrics = new RnaSeqMetrics();
    }

    @Override
    protected void acceptRead(SAMRecord rec, ReferenceSequence ref) {
        if (rec.getReadUnmappedFlag() || rec.getReadFailsVendorQualityCheckFlag() || rec.getNotPrimaryAlignmentFlag()) {
            return;
        }
        Interval readInterval = new Interval(rec.getReferenceName(), rec.getAlignmentStart(), rec.getAlignmentEnd());
        Collection<Gene> overlappingGenes = this.geneOverlapDetector.getOverlaps(readInterval);
        Collection<Interval> overlappingRibosomalIntervals = this.ribosomalSequenceOverlapDetector.getOverlaps(readInterval);
        List alignmentBlocks = rec.getAlignmentBlocks();
        boolean overlapsExon = false;
        for (AlignmentBlock alignmentBlock : alignmentBlocks) {
            LocusFunction[] locusFunctions = new LocusFunction[alignmentBlock.getLength()];
            Arrays.fill((Object[])locusFunctions, 0, locusFunctions.length, (Object)LocusFunction.INTERGENIC);
            for (Gene gene : overlappingGenes) {
                for (Gene.Transcript transcript : gene) {
                    transcript.assignLocusFunctionForRange(alignmentBlock.getReferenceStart(), locusFunctions);
                }
            }
            for (Interval ribosomalInterval : overlappingRibosomalIntervals) {
                this.assignValueForOverlappingRange(ribosomalInterval, alignmentBlock.getReferenceStart(), locusFunctions, LocusFunction.RIBOSOMAL);
            }
            block11: for (LocusFunction locusFunction : locusFunctions) {
                ++this.metrics.PF_ALIGNED_BASES;
                switch (locusFunction) {
                    case INTERGENIC: {
                        ++this.metrics.INTERGENIC_BASES;
                        continue block11;
                    }
                    case INTRONIC: {
                        ++this.metrics.INTRONIC_BASES;
                        continue block11;
                    }
                    case UTR: {
                        ++this.metrics.UTR_BASES;
                        overlapsExon = true;
                        continue block11;
                    }
                    case CODING: {
                        ++this.metrics.CODING_BASES;
                        overlapsExon = true;
                        continue block11;
                    }
                    case RIBOSOMAL: {
                        ++this.metrics.RIBOSOMAL_BASES;
                    }
                }
            }
        }
        if (overlapsExon && this.STRAND_SPECIFICITY != StrandSpecificity.NONE && overlappingGenes.size() == 1) {
            boolean thisReadExpectedToAgree;
            boolean negativeTranscriptionStrand = overlappingGenes.iterator().next().isNegativeStrand();
            boolean negativeReadStrand = rec.getReadNegativeStrandFlag();
            boolean readAndTranscriptStrandsAgree = negativeReadStrand == negativeTranscriptionStrand;
            boolean readOneOrUnpaired = !rec.getReadPairedFlag() || rec.getFirstOfPairFlag();
            boolean firstReadExpectedToAgree = this.STRAND_SPECIFICITY == StrandSpecificity.FIRST_READ_TRANSCRIPTION_STRAND;
            boolean bl = thisReadExpectedToAgree = readOneOrUnpaired == firstReadExpectedToAgree;
            if (readAndTranscriptStrandsAgree == thisReadExpectedToAgree) {
                ++this.metrics.CORRECT_STRAND_READS;
            } else {
                ++this.metrics.INCORRECT_STRAND_READS;
            }
        }
    }

    @Override
    protected void finish() {
        if (this.metrics.PF_ALIGNED_BASES > 0L) {
            this.metrics.PCT_RIBOSOMAL_BASES = (double)this.metrics.RIBOSOMAL_BASES / (double)this.metrics.PF_ALIGNED_BASES;
            this.metrics.PCT_CODING_BASES = (double)this.metrics.CODING_BASES / (double)this.metrics.PF_ALIGNED_BASES;
            this.metrics.PCT_UTR_BASES = (double)this.metrics.UTR_BASES / (double)this.metrics.PF_ALIGNED_BASES;
            this.metrics.PCT_INTRONIC_BASES = (double)this.metrics.INTRONIC_BASES / (double)this.metrics.PF_ALIGNED_BASES;
            this.metrics.PCT_INTERGENIC_BASES = (double)this.metrics.INTERGENIC_BASES / (double)this.metrics.PF_ALIGNED_BASES;
            this.metrics.PCT_RNA_BASES = this.metrics.PCT_CODING_BASES + this.metrics.PCT_UTR_BASES;
        }
        if (this.metrics.CORRECT_STRAND_READS > 0L || this.metrics.INCORRECT_STRAND_READS > 0L) {
            this.metrics.PCT_CORRECT_STRAND_READS = (double)this.metrics.CORRECT_STRAND_READS / (double)(this.metrics.CORRECT_STRAND_READS + this.metrics.INCORRECT_STRAND_READS);
        }
        MetricsFile file = this.getMetricsFile();
        file.addMetric(this.metrics);
        file.write(this.OUTPUT);
    }

    private void assignValueForOverlappingRange(Interval interval, int start, LocusFunction[] locusFunctions, LocusFunction valueToAssign) {
        for (int i = Math.max(start, interval.getStart()); i <= Math.min(interval.getEnd(), CoordMath.getEnd((int)start, (int)locusFunctions.length)); ++i) {
            locusFunctions[i - start] = valueToAssign;
        }
    }

    public static enum StrandSpecificity {
        NONE,
        FIRST_READ_TRANSCRIPTION_STRAND,
        SECOND_READ_TRANSCRIPTION_STRAND;

    }
}

