/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.annotation;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.sf.picard.annotation.AnnotationException;
import net.sf.picard.annotation.LocusFunction;
import net.sf.picard.util.Interval;
import net.sf.samtools.util.CoordMath;

public class Gene
extends Interval
implements Iterable<Transcript> {
    private final Map<String, Transcript> transcripts = new HashMap<String, Transcript>();

    public Gene(String sequence, int start, int end, boolean negative, String name) {
        super(sequence, start, end, negative, name);
    }

    public Gene(String sequence, int start, int end, boolean negative, String name, Iterable<Transcript> transcriptIterable) {
        super(sequence, start, end, negative, name);
        for (Transcript transcript : transcriptIterable) {
            this.addTranscript(transcript);
        }
    }

    public void addTranscript(Transcript transcript) {
        if (this.transcripts.containsKey(transcript.name)) {
            throw new AnnotationException("Transcript " + transcript.name + " for gene " + this.getName() + " appears more than once");
        }
        this.transcripts.put(transcript.name, transcript);
    }

    @Override
    public Iterator<Transcript> iterator() {
        return this.transcripts.values().iterator();
    }

    public static class Transcript {
        public final String name;
        public final int transcriptionStart;
        public final int transcriptionEnd;
        public final int codingStart;
        public final int codingEnd;
        public final Exon[] exons;

        public Transcript(String name, int transcriptionStart, int transcriptionEnd, int codingStart, int codingEnd, Exon[] exons) {
            this.name = name;
            this.transcriptionStart = transcriptionStart;
            this.transcriptionEnd = transcriptionEnd;
            this.codingStart = codingStart;
            this.codingEnd = codingEnd;
            this.exons = exons;
        }

        public int start() {
            return this.exons[0].start;
        }

        public int end() {
            return this.exons[this.exons.length - 1].end;
        }

        public void assignLocusFunctionForRange(int start, LocusFunction[] locusFunctions) {
            for (int i = Math.max(start, this.transcriptionStart); i <= Math.min(this.transcriptionEnd, CoordMath.getEnd((int)start, (int)locusFunctions.length)); ++i) {
                if (locusFunctions[i - start].ordinal() > LocusFunction.CODING.ordinal()) continue;
                LocusFunction locusFunction = this.inExon(i) ? (this.utr(i) ? LocusFunction.UTR : LocusFunction.CODING) : LocusFunction.INTRONIC;
                if (locusFunction.ordinal() <= locusFunctions[i - start].ordinal()) continue;
                locusFunctions[i - start] = locusFunction;
            }
        }

        private boolean utr(int locus) {
            return locus < this.codingStart || locus > this.codingEnd;
        }

        private boolean inExon(int locus) {
            for (int i = 0; i < this.exons.length; ++i) {
                Exon exon = this.exons[i];
                if (exon.start > locus) {
                    return false;
                }
                if (!this.inRange(exon.start, exon.end, locus)) continue;
                return true;
            }
            return false;
        }

        private boolean inRange(int start, int end, int locus) {
            return locus >= start && locus <= end;
        }

        public static class Exon {
            public final int start;
            public final int end;

            public Exon(int start, int end) {
                this.start = start;
                this.end = end;
            }
        }
    }
}

