/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.illumina;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.sf.picard.PicardException;
import net.sf.picard.cmdline.CommandLineProgram;
import net.sf.picard.cmdline.Option;
import net.sf.picard.cmdline.Usage;
import net.sf.picard.illumina.IlluminaBasecallsToSamConverter;
import net.sf.picard.illumina.parser.AbstractIlluminaDataProvider;
import net.sf.picard.illumina.parser.BarcodeFilter;
import net.sf.picard.illumina.parser.IlluminaDataProviderFactory;
import net.sf.picard.illumina.parser.IlluminaDataType;
import net.sf.picard.illumina.parser.IlluminaReadData;
import net.sf.picard.io.IoUtil;
import net.sf.picard.util.ClippingUtility;
import net.sf.picard.util.FileChannelJDKBugWorkAround;
import net.sf.picard.util.IlluminaUtil;
import net.sf.picard.util.Log;
import net.sf.picard.util.TabbedTextFileWithHeaderParser;
import net.sf.samtools.BAMRecordCodec;
import net.sf.samtools.SAMFileHeader;
import net.sf.samtools.SAMFileWriter;
import net.sf.samtools.SAMFileWriterFactory;
import net.sf.samtools.SAMReadGroupRecord;
import net.sf.samtools.SAMRecord;
import net.sf.samtools.SAMRecordQueryNameComparator;
import net.sf.samtools.util.Iso8601Date;
import net.sf.samtools.util.PeekIterator;
import net.sf.samtools.util.SortingCollection;

public class IlluminaBasecallsToSam
extends CommandLineProgram {
    private static final Log log = Log.getInstance(IlluminaBasecallsToSam.class);
    private static final boolean PRINT_TIMING = false;
    @Usage
    public String USAGE = this.getStandardUsagePreamble() + "Generate a SAM or BAM file from data in an Illumina basecalls output directory.\n";
    @Option(doc="Deprecated.  This does nothing.")
    public boolean GENERATE_SECONDARY_BASE_CALLS = false;
    @Option(doc="Deprecated option; Use BASECALLS_DIR", mutex={"BASECALLS_DIR"})
    public File BUSTARD_DIR;
    @Option(doc="The basecalls output directory. ", shortName="B", mutex={"BUSTARD_DIR"})
    public File BASECALLS_DIR;
    @Option(doc="Lane number. ", shortName="L")
    public Integer LANE;
    @Option(doc="The output SAM or BAM file. Format is determined by extension.", shortName="O", mutex={"BARCODE_PARAMS"})
    public File OUTPUT;
    @Option(doc="Prefixed to read names.")
    public String RUN_BARCODE;
    @Option(doc="The name of the sequenced sample", shortName="ALIAS", mutex={"BARCODE_PARAMS"})
    public String SAMPLE_ALIAS;
    @Option(doc="ID used to link RG header record with RG tag in SAM record.  If these are unique in SAM files that get merged, merge performance is better.  If not specified, READ_GROUP_ID = <first 5 chars of RUN_BARCODE>.<LANE> .", shortName="RG", optional=true)
    public String READ_GROUP_ID;
    @Option(doc="Use this option to override auto-detection of base caller version", optional=true)
    public IlluminaDataProviderFactory.BaseCallerVersion BASE_CALLER_VERSION;
    @Option(doc="Use this option to override auto-detection of image analyzer version", optional=true)
    public IlluminaDataProviderFactory.ImageAnalyzerVersion IMAGE_ANALYZER_VERSION;
    @Option(doc="The name of the sequenced library", shortName="LIB", optional=true, mutex={"BARCODE_PARAMS"})
    public String LIBRARY_NAME;
    @Option(doc="This option no longer used.", optional=true)
    public Integer FIRST_READ_LENGTH;
    @Option(doc="The name of the sequencing center that produced the reads to fill in the RG.CN tag.", optional=true)
    public String SEQUENCING_CENTER = "BI";
    @Option(doc="The start date of the run.", optional=true)
    public Date RUN_START_DATE;
    @Option(doc="The name of the sequencing technology that produced the read.", optional=true)
    public String PLATFORM = "illumina";
    @Option(doc="For a barcoded-run, the desired barcode to select for.  Leave null to select all non-matching reads.", optional=true, shortName="BARCODE", mutex={"BARCODE_PARAMS"})
    public String MOLECULAR_BARCODE_SEQUENCE;
    @Option(doc="1-based cycle number of the start of the barcode.  If BARCODE or BARCODE_LENGTH are specified, this must be specified.", optional=true, shortName="BARCODE_POSITION")
    public Integer BARCODE_CYCLE;
    @Option(doc="Length of the barcode.  If BARCODE_CYCLE or BARCODE is specified, this must be specified.", optional=true)
    public Integer BARCODE_LENGTH;
    @Option(doc="Tab-separated file for creating all output BAMs for barcoded run with single IlluminaBasecallsToSam invocation.  Columns are BARCODE, OUTPUT, SAMPLE_ALIAS, and LIBRARY_NAME.  Row with BARCODE=N is used to specify a file for no barcode match", mutex={"MOLECULAR_BARCODE_SEQUENCE", "OUTPUT", "SAMPLE_ALIAS", "LIBRARY_NAME"})
    public File BARCODE_PARAMS;
    @Option(doc="Whether to mark the position of the adapter in the read")
    public boolean MARK_ADAPTER = true;
    @Option(doc="Run this many TileProcessors in parallel.  If NUM_PROCESSORS = 0, number of cores is automatically set to the number of cores available on the machine. If NUM_PROCESSORS < 0 then the number of cores used will be the number available on the machine less NUM_PROCESSORS.")
    public Integer NUM_PROCESSORS = 0;
    @Option(doc="If set, this is the first tile to be processed (for debugging).  Note that tiles are not processed in numerical order.", optional=true)
    public Integer FIRST_TILE;
    @Option(doc="If set, process no more than this many tiles (for debugging).", optional=true)
    public Integer TILE_LIMIT;
    @Option(doc="If true, call System.gc() periodically.  This is useful in cases in which the -Xmx value passed is larger than the available memory.  Default: enable FORCE_GC if multi-threading.", optional=true)
    public Boolean FORCE_GC;
    @Option(doc="Configure SortingCollections in TileProcessors to store this many records before spilling to disk.  For an indexed run, each SortingCollection gets this value/number of indices.")
    public int MAX_READS_IN_RAM_PER_TILE = 1200000;
    private int recordsWritten = 0;
    private IlluminaBasecallsToSamConverter converter;
    private IlluminaDataProviderFactory factory;
    private final Map<String, SAMFileWriter> writersByBarcode = new HashMap<String, SAMFileWriter>();

    @Override
    protected int doWork() {
        if (this.BUSTARD_DIR != null) {
            this.BASECALLS_DIR = this.BUSTARD_DIR;
        }
        log.info("BARCODE  IS " + this.MOLECULAR_BARCODE_SEQUENCE);
        log.info("POSITION  IS " + this.BARCODE_CYCLE);
        if (this.OUTPUT != null) {
            IoUtil.assertFileIsWritable(this.OUTPUT);
        }
        if (this.BARCODE_PARAMS != null) {
            IoUtil.assertFileIsReadable(this.BARCODE_PARAMS);
        }
        this.factory = !this.isBarcoded() ? new IlluminaDataProviderFactory(this.BASECALLS_DIR, (int)this.LANE, IlluminaDataType.BaseCalls, IlluminaDataType.QualityScores, IlluminaDataType.PF) : new IlluminaDataProviderFactory(this.BASECALLS_DIR, (int)this.LANE, this.BARCODE_CYCLE, this.BARCODE_LENGTH, IlluminaDataType.BaseCalls, IlluminaDataType.QualityScores, IlluminaDataType.PF, IlluminaDataType.Barcodes);
        this.addOptionalFactorySettings(this.factory);
        List<Integer> tiles = this.factory.getTiles();
        Collections.sort(tiles, new Comparator<Integer>(){

            @Override
            public int compare(Integer integer1, Integer integer2) {
                String s1 = integer1.toString();
                String s2 = integer2.toString();
                if (s1.length() < s2.length()) {
                    if (s2.startsWith(s1)) {
                        return 1;
                    }
                } else if (s2.length() < s1.length() && s1.startsWith(s2)) {
                    return -1;
                }
                return s1.compareTo(s2);
            }
        });
        if (this.FIRST_TILE != null) {
            for (int i = 0; i < tiles.size(); ++i) {
                if (tiles.get(i).intValue() != this.FIRST_TILE.intValue()) continue;
                tiles = tiles.subList(i, tiles.size());
                break;
            }
            if (tiles.get(0).intValue() != this.FIRST_TILE.intValue()) {
                throw new PicardException("FIRST_TILE=" + this.FIRST_TILE + ", but that tile was not found.");
            }
        }
        if (this.TILE_LIMIT != null && tiles.size() > this.TILE_LIMIT) {
            tiles = tiles.subList(0, this.TILE_LIMIT);
        }
        log.info(new Object[]{"Base caller version: ", this.factory.getBaseCallerVersion()});
        log.info(new Object[]{"Image analyzer version: ", this.factory.getImageAnalyzerVersion()});
        if (this.OUTPUT != null) {
            this.writersByBarcode.put(this.MOLECULAR_BARCODE_SEQUENCE, this.buildSamFileWriter(this.OUTPUT, this.SAMPLE_ALIAS, this.LIBRARY_NAME, null));
        } else {
            this.populateWritersByBarcode();
        }
        this.converter = new IlluminaBasecallsToSamConverter(this.RUN_BARCODE, this.READ_GROUP_ID);
        int numProcessors = this.NUM_PROCESSORS == 0 ? Runtime.getRuntime().availableProcessors() : (this.NUM_PROCESSORS < 0 ? Runtime.getRuntime().availableProcessors() + this.NUM_PROCESSORS : this.NUM_PROCESSORS);
        numProcessors = Math.min(numProcessors, tiles.size());
        if (this.FORCE_GC == null) {
            this.FORCE_GC = numProcessors > 1;
        }
        if (numProcessors > 1) {
            FileChannelJDKBugWorkAround.doBugWorkAround();
            log.info("Creating " + numProcessors + " TileProcessors.");
            LinkedList<TileProcessor> activeProcessors = new LinkedList<TileProcessor>();
            Iterator<Integer> tileIterator = tiles.iterator();
            for (int i = 0; i < numProcessors; ++i) {
                TileProcessor tileProcessor = new TileProcessor();
                tileProcessor.initialize(tileIterator.next());
                tileProcessor.startThread();
                activeProcessors.addLast(tileProcessor);
            }
            while (!activeProcessors.isEmpty()) {
                TileProcessor earliestProcessor = (TileProcessor)activeProcessors.removeFirst();
                this.maybeGC();
                earliestProcessor.waitUntilDone();
                earliestProcessor.sortAndFlush();
                if (!tileIterator.hasNext()) continue;
                earliestProcessor.initialize(tileIterator.next());
                earliestProcessor.startThread();
                activeProcessors.addLast(earliestProcessor);
            }
        } else {
            log.info("Single TileProcessor mode.");
            TileProcessor tileProcessor = new TileProcessor();
            for (int tile : tiles) {
                tileProcessor.initialize(tile);
                tileProcessor.run();
                this.maybeGC();
                tileProcessor.sortAndFlush();
            }
        }
        for (SAMFileWriter writer : this.writersByBarcode.values()) {
            writer.close();
        }
        log.info("Wrote " + this.recordsWritten + " read records total.");
        return 0;
    }

    private void populateWritersByBarcode() {
        TabbedTextFileWithHeaderParser barcodeParamsParser = new TabbedTextFileWithHeaderParser(this.BARCODE_PARAMS);
        for (String columnLabel : new String[]{"BARCODE", "OUTPUT", "SAMPLE_ALIAS", "LIBRARY_NAME"}) {
            if (barcodeParamsParser.hasColumn(columnLabel)) continue;
            throw new PicardException("BARCODE_PARAMS file " + this.BARCODE_PARAMS + " does not have column " + columnLabel + ".");
        }
        for (TabbedTextFileWithHeaderParser.Row row : barcodeParamsParser) {
            String key;
            String barcode = row.getField("BARCODE");
            String string = key = barcode.equals("N") ? null : barcode;
            if (this.writersByBarcode.containsKey(key)) {
                throw new PicardException("Row for barcode " + barcode + " appears more than once in BARCODE_PARAMS file " + this.BARCODE_PARAMS);
            }
            SAMFileWriter writer = this.buildSamFileWriter(new File(row.getField("OUTPUT")), row.getField("SAMPLE_ALIAS"), row.getField("LIBRARY_NAME"), barcode);
            this.writersByBarcode.put(key, writer);
        }
        if (this.writersByBarcode.isEmpty()) {
            throw new PicardException("BARCODE_PARAMS file " + this.BARCODE_PARAMS + " does have any data rows.");
        }
    }

    private void maybeGC() {
        if (this.FORCE_GC.booleanValue()) {
            System.out.println("Before explicit GC, Runtime.totalMemory()=" + Runtime.getRuntime().totalMemory());
            System.gc();
            System.runFinalization();
            System.out.println("After explicit GC, Runtime.totalMemory()=" + Runtime.getRuntime().totalMemory());
        }
    }

    private synchronized void incrementRecordsWritten() {
        ++this.recordsWritten;
        if (this.recordsWritten % 1000000 == 0) {
            log.info(this.recordsWritten + " read records written...");
        }
    }

    private void addOptionalFactorySettings(IlluminaDataProviderFactory factory) {
        if (this.BASE_CALLER_VERSION != null) {
            factory.setBaseCallerVersion(this.BASE_CALLER_VERSION);
        }
        if (this.IMAGE_ANALYZER_VERSION != null) {
            factory.setImageAnalyzerVersion(this.IMAGE_ANALYZER_VERSION);
        }
    }

    protected SAMReadGroupRecord buildReadGroup() {
        SAMReadGroupRecord rg = new SAMReadGroupRecord(this.READ_GROUP_ID);
        rg.setSample(this.SAMPLE_ALIAS);
        rg.setAttribute("PU", this.RUN_BARCODE + "." + this.LANE);
        if (this.LIBRARY_NAME != null) {
            rg.setLibrary(this.LIBRARY_NAME);
        }
        if (this.SEQUENCING_CENTER != null) {
            rg.setAttribute("CN", this.SEQUENCING_CENTER);
        }
        if (this.PLATFORM != null) {
            rg.setAttribute("PL", this.PLATFORM);
        }
        if (this.RUN_START_DATE != null) {
            Iso8601Date date = new Iso8601Date(this.RUN_START_DATE);
            rg.setAttribute("DT", date.toString());
        }
        return rg;
    }

    private SAMFileWriter buildSamFileWriter(File output, String sampleAlias, String libraryName, String barcode) {
        IoUtil.assertFileIsWritable(output);
        SAMReadGroupRecord rg = new SAMReadGroupRecord(this.READ_GROUP_ID);
        rg.setSample(sampleAlias);
        String platformUnit = this.RUN_BARCODE + "." + this.LANE;
        if (barcode != null) {
            platformUnit = platformUnit + "." + barcode;
        }
        rg.setAttribute("PU", platformUnit);
        if (libraryName != null) {
            rg.setLibrary(libraryName);
        }
        if (this.SEQUENCING_CENTER != null) {
            rg.setAttribute("CN", this.SEQUENCING_CENTER);
        }
        if (this.PLATFORM != null) {
            rg.setAttribute("PL", this.PLATFORM);
        }
        if (this.RUN_START_DATE != null) {
            Iso8601Date date = new Iso8601Date(this.RUN_START_DATE);
            rg.setAttribute("DT", date.toString());
        }
        SAMFileHeader header = new SAMFileHeader();
        header.setSortOrder(SAMFileHeader.SortOrder.queryname);
        header.addReadGroup(rg);
        return new SAMFileWriterFactory().makeSAMOrBAMWriter(header, true, output);
    }

    public static void main(String[] argv) {
        System.exit(new IlluminaBasecallsToSam().instanceMain(argv));
    }

    @Override
    protected String[] customCommandLineValidation() {
        ArrayList<String> messages = new ArrayList<String>();
        if (this.MOLECULAR_BARCODE_SEQUENCE != null || this.BARCODE_PARAMS != null) {
            if (this.BARCODE_CYCLE == null || this.BARCODE_LENGTH == null) {
                messages.add("BARCODE_CYCLE and BARCODE_LENGTH must be specified when MOLECULAR_BARCODE_SEQUENCE or BARCODE_PARAMS is set.");
            }
        } else if (this.BARCODE_CYCLE == null && this.BARCODE_LENGTH != null || this.BARCODE_CYCLE != null && this.BARCODE_LENGTH == null) {
            messages.add("Either both BARCODE_CYCLE and BARCODE_LENGTH must be specified or neither.");
        }
        if (this.BARCODE_CYCLE != null && this.BARCODE_CYCLE < 1) {
            messages.add("BARCODE_CYCLE must be >= 1");
        }
        if (this.READ_GROUP_ID == null) {
            this.READ_GROUP_ID = this.RUN_BARCODE.substring(0, 5) + "." + this.LANE;
        }
        if (messages.size() == 0) {
            return null;
        }
        return messages.toArray(new String[messages.size()]);
    }

    private boolean isBarcoded() {
        return this.BARCODE_CYCLE != null;
    }

    private class TileProcessor
    implements Runnable {
        private final Map<String, SamRecordSorter> sorters = new HashMap<String, SamRecordSorter>();
        private final Object tileProcessedMonitor = new Object();
        private boolean tileProcessed;
        private int tile;
        private Thread thread;
        private boolean threadFailed;

        private TileProcessor() {
            int maxRecordsInRam = IlluminaBasecallsToSam.this.MAX_READS_IN_RAM_PER_TILE / IlluminaBasecallsToSam.this.writersByBarcode.size();
            for (Map.Entry entry : IlluminaBasecallsToSam.this.writersByBarcode.entrySet()) {
                this.sorters.put((String)entry.getKey(), new SamRecordSorter(maxRecordsInRam, (SAMFileWriter)entry.getValue(), IlluminaBasecallsToSam.this.TMP_DIR));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void initialize(int tile) {
            this.tile = tile;
            this.thread = null;
            this.threadFailed = false;
            Object object = this.tileProcessedMonitor;
            synchronized (object) {
                this.tileProcessed = false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void waitUntilDone() {
            Object object = this.tileProcessedMonitor;
            synchronized (object) {
                if (this.threadFailed) {
                    throw new PicardException("TileProcessor thread terminated with an exception");
                }
                if (this.tileProcessed) {
                    return;
                }
                try {
                    this.tileProcessedMonitor.wait();
                    if (this.threadFailed) {
                        throw new PicardException("TileProcessor thread terminated with an exception");
                    }
                }
                catch (InterruptedException e) {
                    throw new PicardException("Waiting for tile to finish.", e);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block16: {
                Object parser;
                try {
                    List<Integer> oneTile = Arrays.asList(this.tile);
                    parser = IlluminaBasecallsToSam.this.factory.makeDataProvider(oneTile);
                    if (IlluminaBasecallsToSam.this.isBarcoded() && IlluminaBasecallsToSam.this.BARCODE_PARAMS == null) {
                        parser = new BarcodeFilter(IlluminaBasecallsToSam.this.MOLECULAR_BARCODE_SEQUENCE, (AbstractIlluminaDataProvider)parser, IlluminaBasecallsToSam.this.MOLECULAR_BARCODE_SEQUENCE == null);
                    }
                    this.processTile((AbstractIlluminaDataProvider)parser);
                }
                catch (Throwable e) {
                    if (this.thread != null) {
                        this.threadFailed = true;
                        log.error(e, "Exception in TileProcessor");
                        break block16;
                    }
                    throw new PicardException("Exception in TileProcessor", e);
                }
                finally {
                    parser = this.tileProcessedMonitor;
                    synchronized (parser) {
                        this.tileProcessed = true;
                        this.tileProcessedMonitor.notifyAll();
                    }
                }
            }
        }

        public void startThread() {
            this.thread = new Thread(this);
            this.thread.start();
        }

        private void processTile(AbstractIlluminaDataProvider parser) {
            Object sqCallWatch = null;
            Object readWatch = null;
            while (parser.hasNext()) {
                SAMRecord sam2;
                IlluminaReadData ird = parser.next();
                SamRecordSorter sorter = this.sorters.get(ird.getMatchedBarcode());
                if (sorter == null) {
                    throw new PicardException("Barcode encountered in that was not specified in BARCODE_PARAMS: " + ird.getMatchedBarcode());
                }
                SAMFileHeader header = sorter.getWriter().getFileHeader();
                SAMRecord sam = IlluminaBasecallsToSam.this.converter.createSamRecord(ird, true, header, null);
                SAMRecord sAMRecord = sam2 = ird.isPairedEnd() ? IlluminaBasecallsToSam.this.converter.createSamRecord(ird, false, header, sam.getReadName()) : null;
                if (IlluminaBasecallsToSam.this.MARK_ADAPTER) {
                    if (ird.isPairedEnd()) {
                        assert (sam.getFirstOfPairFlag() && sam2.getSecondOfPairFlag());
                        String warnString = ClippingUtility.adapterTrimIlluminaPairedReads(sam, sam2, IlluminaBasecallsToSam.this.isBarcoded() ? IlluminaUtil.IlluminaAdapterPair.INDEXED.adapterPair : IlluminaUtil.IlluminaAdapterPair.PAIRED_END.adapterPair);
                        if (warnString != null) {
                            log.debug("Adapter trimming " + warnString);
                        }
                    } else {
                        ClippingUtility.adapterTrimIlluminaSingleRead(sam, IlluminaBasecallsToSam.this.isBarcoded() ? IlluminaUtil.IlluminaAdapterPair.INDEXED.adapterPair : IlluminaUtil.IlluminaAdapterPair.PAIRED_END.adapterPair);
                    }
                }
                sorter.addAlignment(sam);
                IlluminaBasecallsToSam.this.incrementRecordsWritten();
                if (!ird.isPairedEnd()) continue;
                sorter.addAlignment(sam2);
                IlluminaBasecallsToSam.this.incrementRecordsWritten();
            }
        }

        void sortAndFlush() {
            for (Map.Entry<String, SamRecordSorter> entry : this.sorters.entrySet()) {
                log.info("Writing " + entry.getValue().size() + " records for tile " + this.tile + " and barcode " + entry.getKey());
                entry.getValue().sortAndFlush();
            }
        }
    }

    private static class SamRecordSorter {
        private final Comparator<SAMRecord> comparator = new SAMRecordQueryNameComparator();
        private final SortingCollection.Codec<SAMRecord> codec;
        private final SAMFileWriter writer;
        private final int maxRecordsInRam;
        private final File tmpDir;
        private SortingCollection<SAMRecord> records;
        private int numRecords = 0;

        private SamRecordSorter(int maxRecordsInRam, SAMFileWriter writer, File tmpDir) {
            this.maxRecordsInRam = maxRecordsInRam;
            this.tmpDir = tmpDir;
            this.codec = new BAMRecordCodec(writer.getFileHeader());
            this.writer = writer;
            this.createSortingCollection();
        }

        private void createSortingCollection() {
            if (this.records != null) {
                this.records.cleanup();
            }
            this.records = SortingCollection.newInstance(SAMRecord.class, this.codec, this.comparator, (int)this.maxRecordsInRam, (File)this.tmpDir);
        }

        void addAlignment(SAMRecord rec) {
            this.records.add((Object)rec);
            ++this.numRecords;
        }

        void sortAndFlush() {
            Object writeWatch = null;
            this.records.doneAdding();
            PeekIterator it = new PeekIterator((Iterator)this.records.iterator());
            while (it.hasNext()) {
                SAMRecord rec = (SAMRecord)it.next();
                if (it.hasNext()) {
                    SAMRecord lookAhead = (SAMRecord)it.peek();
                    if (!rec.getReadUnmappedFlag() || !lookAhead.getReadUnmappedFlag()) {
                        throw new IllegalStateException("Should not have mapped reads.");
                    }
                    if (this.comparator.compare(rec, lookAhead) == 0) {
                        it.next();
                        log.info("Skipping reads with identical read names: " + rec.getReadName());
                        continue;
                    }
                }
                this.writer.addAlignment(rec);
            }
            this.createSortingCollection();
            this.numRecords = 0;
        }

        int size() {
            return this.numRecords;
        }

        SAMFileWriter getWriter() {
            return this.writer;
        }
    }
}

