/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.illumina;

import java.util.Arrays;
import net.sf.picard.filter.AggregateFilter;
import net.sf.picard.filter.SolexaNoiseFilter;
import net.sf.picard.illumina.parser.IlluminaEndData;
import net.sf.picard.illumina.parser.IlluminaReadData;
import net.sf.picard.util.IlluminaUtil;
import net.sf.samtools.SAMFileHeader;
import net.sf.samtools.SAMRecord;

public class IlluminaBasecallsToSamConverter {
    private final String runBarcode;
    private final String readGroupId;
    private AggregateFilter filters;

    public IlluminaBasecallsToSamConverter(String runBarcode, String readGroupId) {
        this.runBarcode = runBarcode;
        this.readGroupId = readGroupId;
        this.initializeFilters();
    }

    private void initializeFilters() {
        this.filters = new AggregateFilter(Arrays.asList(new SolexaNoiseFilter()));
    }

    private String createReadName(IlluminaReadData ird) {
        return IlluminaUtil.makeReadName(this.runBarcode, ird.getLane(), ird.getTile(), ird.getX(), ird.getY());
    }

    public SAMRecord createSamRecord(IlluminaReadData ird, boolean isFirstRead, SAMFileHeader header, String readName) {
        SAMRecord sam = new SAMRecord(header);
        sam.setReadName(readName != null ? readName : this.createReadName(ird));
        IlluminaEndData end = isFirstRead ? ird.getFirstEnd() : ird.getSecondEnd();
        sam.setReadBases(end.getBases());
        sam.setBaseQualities(end.getQualities());
        sam.setReadPairedFlag(ird.isPairedEnd());
        sam.setReadUnmappedFlag(true);
        sam.setReadFailsVendorQualityCheckFlag(ird.isPf() == false);
        if (ird.isPairedEnd()) {
            sam.setMateUnmappedFlag(true);
            sam.setFirstOfPairFlag(isFirstRead);
            sam.setSecondOfPairFlag(!isFirstRead);
        }
        if (this.filters.filterOut(sam)) {
            sam.setAttribute("XN", (Object)1);
        }
        if (this.readGroupId != null) {
            sam.setAttribute("RG", (Object)this.readGroupId);
        }
        return sam;
    }
}

