/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.illumina.parser;

import net.sf.picard.illumina.parser.AbstractIlluminaDataProvider;
import net.sf.picard.illumina.parser.IlluminaReadData;

public class BarcodeFilter
implements AbstractIlluminaDataProvider {
    private final AbstractIlluminaDataProvider dataProvider;
    private final String barcode;
    private IlluminaReadData read;
    private final boolean includeUnmatched;

    public BarcodeFilter(String barcode, AbstractIlluminaDataProvider dataProvider, boolean includeUnmatched) {
        if (barcode == null && !includeUnmatched) {
            throw new IllegalArgumentException("Barcode must be non-null when includeUnmatched is false");
        }
        this.barcode = barcode;
        this.dataProvider = dataProvider;
        this.includeUnmatched = includeUnmatched;
        this.advance();
    }

    public BarcodeFilter(String barcode, AbstractIlluminaDataProvider dataProvider) {
        this(barcode, dataProvider, false);
    }

    private void advance() {
        while (this.dataProvider.hasNext()) {
            this.read = this.dataProvider.next();
            if ((this.barcode == null || !this.barcode.equals(this.read.getMatchedBarcode())) && (!this.includeUnmatched || this.read.getMatchedBarcode() != null)) continue;
            return;
        }
        this.read = null;
    }

    @Override
    public boolean hasNext() {
        return this.read != null;
    }

    @Override
    public IlluminaReadData next() {
        IlluminaReadData ret = this.read;
        this.advance();
        return ret;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void seekToTile(int oneBasedTileNumber) {
        this.dataProvider.seekToTile(oneBasedTileNumber);
        this.advance();
    }
}

