/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.illumina.parser;

import java.io.File;
import java.util.List;
import net.sf.picard.illumina.parser.ClusterIntensityFileReader;
import net.sf.picard.illumina.parser.FourChannelIntensityData;
import net.sf.picard.illumina.parser.IlluminaCycleFileSetParser;
import net.sf.picard.illumina.parser.IlluminaEndData;
import net.sf.picard.illumina.parser.ReadConfiguration;

public class CifParser
extends IlluminaCycleFileSetParser {
    public CifParser(ReadConfiguration readConfiguration, File directory, int lane, List<Integer> tiles) {
        super(readConfiguration, directory, lane, ClusterIntensityFileReader.FileType.cif, tiles);
    }

    @Override
    protected void setFCID(IlluminaEndData end, FourChannelIntensityData fourChannelIntensityData) {
        end.setRawIntensities(fourChannelIntensityData);
    }

    @Override
    protected FourChannelIntensityData getFCID(IlluminaEndData end) {
        return end.getRawIntensities();
    }

    public static boolean cifExists(File directory, int lane, int tile) {
        return CifParser.filesExist(directory, lane, ClusterIntensityFileReader.FileType.cif, tile);
    }
}

