/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.illumina.parser;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.ByteOrder;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Arrays;
import net.sf.picard.PicardException;
import net.sf.picard.illumina.parser.IntensityChannel;
import net.sf.samtools.util.CloserUtil;
import net.sf.samtools.util.StringUtil;

public class ClusterIntensityFileReader {
    private static final byte[] IDENTIFIER = StringUtil.stringToBytes((String)"CIF");
    private static final byte FILE_VERSION = 1;
    private static final int HEADER_SIZE = 13;
    private static final int NUM_CHANNELS = IntensityChannel.values().length;
    private final File file;
    private final MappedByteBuffer buf;
    private final int elementSize;
    private final int firstCycle;
    private final int numCycles;
    private final int numClusters;
    private final int cycleSize;
    private final int channelSize;

    public ClusterIntensityFileReader(File file) {
        try {
            this.file = file;
            FileInputStream is = new FileInputStream(this.file);
            FileChannel channel = is.getChannel();
            long fileSize = channel.size();
            this.buf = channel.map(FileChannel.MapMode.READ_ONLY, 0L, fileSize);
            this.buf.order(ByteOrder.LITTLE_ENDIAN);
            CloserUtil.close((Object)channel);
            CloserUtil.close((Object)is);
            byte[] identifierBuf = new byte[IDENTIFIER.length];
            this.buf.get(identifierBuf);
            if (!Arrays.equals(identifierBuf, IDENTIFIER)) {
                throw new PicardException("Cluster intensity file " + file + " contains unexpected header: " + StringUtil.bytesToString((byte[])identifierBuf));
            }
            byte fileVersion = this.buf.get();
            if (fileVersion != 1) {
                throw new PicardException("Cluster intensity file " + file + " contains unexpected version: " + fileVersion);
            }
            this.elementSize = this.buf.get();
            if (this.elementSize < 1 || this.elementSize > 2) {
                throw new PicardException("Cluster intensity file " + file + " contains unexpected element size: " + this.elementSize);
            }
            this.firstCycle = this.buf.getShort() & 0xFFFF;
            this.numCycles = this.buf.getShort() & 0xFFFF;
            if (this.numCycles == 0) {
                throw new PicardException("Cluster intensity file " + file + " has zero cycles.");
            }
            this.numClusters = this.buf.getInt();
            if (this.numClusters < 0) {
                throw new PicardException("Cluster intensity file " + file + " has negative number of clusters: " + this.numClusters);
            }
        }
        catch (IOException e) {
            throw new PicardException("IOException opening cluster intensity file " + file, e);
        }
        this.cycleSize = NUM_CHANNELS * this.numClusters * this.elementSize;
        this.channelSize = this.numClusters * this.elementSize;
    }

    public short getValue(int cluster, IntensityChannel channel, int cycle) {
        if (cycle < this.firstCycle || cycle >= this.firstCycle + this.numCycles) {
            throw new IllegalArgumentException("Requested cycle (" + cycle + ") number out of range.  First cycle=" + this.firstCycle + "; numCycles=" + this.numCycles);
        }
        if (cluster < 0 || cluster >= this.numClusters) {
            throw new IllegalArgumentException("Requested cluster (" + cluster + ") number out of range. numClusters=" + this.numClusters);
        }
        int relativeCycle = cycle - this.firstCycle;
        int position = 13 + relativeCycle * this.cycleSize + channel.ordinal() * this.channelSize + cluster * this.elementSize;
        this.buf.position(position);
        if (this.elementSize == 1) {
            return this.buf.get();
        }
        return this.buf.getShort();
    }

    public File getFile() {
        return this.file;
    }

    public int getFirstCycle() {
        return this.firstCycle;
    }

    public int getNumClusters() {
        return this.numClusters;
    }

    public int getNumCycles() {
        return this.numCycles;
    }

    public static enum FileType {
        cif,
        cnf;

    }
}

