/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.illumina.parser;

import java.io.File;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.picard.PicardException;
import net.sf.picard.illumina.parser.ClusterIntensityFileReader;
import net.sf.picard.illumina.parser.IlluminaFileNotFoundException;
import net.sf.picard.illumina.parser.IlluminaFileUtil;
import net.sf.picard.illumina.parser.TiledIlluminaFile;
import net.sf.picard.io.IoUtil;
import net.sf.picard.util.Log;

class CycleFileSetIterator
implements Iterator<Iterator<TiledIlluminaFile>> {
    private static Log log = Log.getInstance(CycleFileSetIterator.class);
    private static final Pattern CYCLE_SUBDIRECTORY_PATTERN = Pattern.compile("C(\\d+)\\..+");
    private final File directory;
    private final int lane;
    private final ClusterIntensityFileReader.FileType fileType;
    private final File[] cycleDirs;
    private final TiledIlluminaFile[] firstCycleFiles;
    private int tileIndex = 0;

    CycleFileSetIterator(File directory, int lane, ClusterIntensityFileReader.FileType fileType, int numCycles) {
        this(directory, lane, fileType, numCycles, null);
    }

    CycleFileSetIterator(File directory, int lane, ClusterIntensityFileReader.FileType fileType, int numCycles, List<Integer> tiles) {
        int i;
        this.directory = directory;
        this.fileType = fileType;
        this.lane = lane;
        File[] tempCycleDirs = IoUtil.getFilesMatchingRegexp(this.directory, CYCLE_SUBDIRECTORY_PATTERN);
        if (tempCycleDirs == null || tempCycleDirs.length == 0) {
            throw new IlluminaFileNotFoundException(directory, directory + " has no cycle subdirectories");
        }
        CycleDirectoryComparator comparator = new CycleDirectoryComparator();
        Arrays.sort(tempCycleDirs, comparator);
        for (i = 0; i < tempCycleDirs.length - 1; ++i) {
            if (comparator.compare(tempCycleDirs[i], tempCycleDirs[i + 1]) != 0) continue;
            throw new PicardException("More than one directory with same cycle number: " + tempCycleDirs[i] + "; " + tempCycleDirs[i + 1]);
        }
        if (tempCycleDirs.length < numCycles) {
            throw new PicardException("Requested more cycle directories (" + numCycles + ") than available (" + tempCycleDirs.length + ") for " + directory);
        }
        if (tempCycleDirs.length > numCycles) {
            log.warn(directory + " contains " + tempCycleDirs.length + " cycle directories, but only " + numCycles + " cycles were requested.");
            this.cycleDirs = Arrays.copyOf(tempCycleDirs, numCycles);
        } else {
            this.cycleDirs = tempCycleDirs;
        }
        if (tiles == null) {
            String regexp = "s_" + this.lane + "_(\\d+)." + (Object)((Object)this.fileType);
            this.firstCycleFiles = IlluminaFileUtil.getTiledIlluminaBasecallFiles(this.cycleDirs[0], regexp);
        } else {
            this.firstCycleFiles = new TiledIlluminaFile[tiles.size()];
            for (i = 0; i < tiles.size(); ++i) {
                File f = new File(this.cycleDirs[0], "s_" + this.lane + "_" + tiles.get(i) + "." + (Object)((Object)this.fileType));
                if (!f.exists()) {
                    throw new IlluminaFileNotFoundException(f, "Requested tile not found");
                }
                this.firstCycleFiles[i] = new TiledIlluminaFile(f, tiles.get(i));
            }
        }
    }

    void seekToTile(int tileNumber) {
        this.tileIndex = 0;
        while (this.tileIndex < this.firstCycleFiles.length && this.firstCycleFiles[this.tileIndex].tile != tileNumber) {
            ++this.tileIndex;
        }
    }

    int getNumberOfCycleFiles() {
        return this.cycleDirs.length;
    }

    @Override
    public boolean hasNext() {
        return this.tileIndex < this.firstCycleFiles.length;
    }

    @Override
    public Iterator<TiledIlluminaFile> next() {
        return new TileCycleFileIterator(this.tileIndex++);
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    private static class CycleDirectoryComparator
    implements Comparator<File> {
        private CycleDirectoryComparator() {
        }

        @Override
        public int compare(File file1, File file2) {
            Matcher matcher = CYCLE_SUBDIRECTORY_PATTERN.matcher(file1.getName());
            if (!matcher.matches()) {
                throw new PicardException("unpossible");
            }
            int cycle1 = Integer.parseInt(matcher.group(1));
            matcher = CYCLE_SUBDIRECTORY_PATTERN.matcher(file2.getName());
            if (!matcher.matches()) {
                throw new PicardException("unpossible");
            }
            int cycle2 = Integer.parseInt(matcher.group(1));
            return cycle1 - cycle2;
        }
    }

    class TileCycleFileIterator
    implements Iterator<TiledIlluminaFile> {
        private final int tileIndex;
        private int cycleIndex = 0;

        TileCycleFileIterator(int tileIndex) {
            this.tileIndex = tileIndex;
        }

        @Override
        public boolean hasNext() {
            return this.cycleIndex < CycleFileSetIterator.this.cycleDirs.length;
        }

        @Override
        public TiledIlluminaFile next() {
            File f = new File(CycleFileSetIterator.this.cycleDirs[this.cycleIndex++], ((CycleFileSetIterator)CycleFileSetIterator.this).firstCycleFiles[this.tileIndex].file.getName());
            return new TiledIlluminaFile(f, ((CycleFileSetIterator)CycleFileSetIterator.this).firstCycleFiles[this.tileIndex].tile);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

