/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.illumina.parser;

import java.util.Arrays;
import net.sf.picard.illumina.parser.IntensityChannel;

public class FourChannelIntensityData {
    private short[][] channels = new short[IntensityChannel.NUM_CHANNELS][];

    public FourChannelIntensityData() {
    }

    public FourChannelIntensityData(int length) {
        for (int i = 0; i < this.channels.length; ++i) {
            this.channels[i] = new short[length];
        }
    }

    public short[] getChannel(IntensityChannel channel) {
        return this.channels[channel.ordinal()];
    }

    public void setChannel(IntensityChannel channel, short[] array) {
        this.channels[channel.ordinal()] = array;
    }

    public short[] getA() {
        return this.getChannel(IntensityChannel.A_CHANNEL);
    }

    public void setA(short[] a) {
        this.setChannel(IntensityChannel.A_CHANNEL, a);
    }

    public short[] getC() {
        return this.getChannel(IntensityChannel.C_CHANNEL);
    }

    public void setC(short[] c) {
        this.setChannel(IntensityChannel.C_CHANNEL, c);
    }

    public short[] getG() {
        return this.getChannel(IntensityChannel.G_CHANNEL);
    }

    public void setG(short[] g) {
        this.setChannel(IntensityChannel.G_CHANNEL, g);
    }

    public short[] getT() {
        return this.getChannel(IntensityChannel.T_CHANNEL);
    }

    public void setT(short[] t) {
        this.setChannel(IntensityChannel.T_CHANNEL, t);
    }

    public short[][] getChannels() {
        return this.channels;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FourChannelIntensityData other = (FourChannelIntensityData)o;
        for (int i = 0; i < this.channels.length; ++i) {
            if (Arrays.equals(this.channels[i], other.channels[i])) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int ret = 0;
        for (short[] channel : this.channels) {
            ret = ret * 31 + Arrays.hashCode(channel);
        }
        return ret;
    }
}

