/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.illumina.parser;

import java.io.File;
import java.util.Arrays;
import java.util.List;
import net.sf.picard.PicardException;
import net.sf.picard.illumina.parser.ClusterIntensityFileReader;
import net.sf.picard.illumina.parser.CycleFileSetIterator;
import net.sf.picard.illumina.parser.FourChannelIntensityData;
import net.sf.picard.illumina.parser.IlluminaEndData;
import net.sf.picard.illumina.parser.IlluminaFileNotFoundException;
import net.sf.picard.illumina.parser.IlluminaParser;
import net.sf.picard.illumina.parser.IlluminaReadData;
import net.sf.picard.illumina.parser.IntensityChannel;
import net.sf.picard.illumina.parser.ReadConfiguration;
import net.sf.picard.illumina.parser.TiledIlluminaFile;

public abstract class IlluminaCycleFileSetParser
implements IlluminaParser {
    private final ReadConfiguration readConfiguration;
    private final File laneDirectory;
    private final int lane;
    private final CycleFileSetIterator cycleFileSetIterator;
    private final ClusterIntensityFileReader[] readers;
    private int cluster = 0;

    public IlluminaCycleFileSetParser(ReadConfiguration readConfiguration, File directory, int lane, ClusterIntensityFileReader.FileType fileType, List<Integer> tiles) {
        this.lane = lane;
        this.readConfiguration = readConfiguration;
        this.laneDirectory = new File(directory, "L00" + this.lane);
        this.cycleFileSetIterator = new CycleFileSetIterator(this.laneDirectory, this.lane, fileType, readConfiguration.getMaxCycleNumber(), tiles);
        this.readers = new ClusterIntensityFileReader[this.cycleFileSetIterator.getNumberOfCycleFiles()];
        if (!this.cycleFileSetIterator.hasNext()) {
            return;
        }
        this.getNextReaders();
    }

    @Override
    public void seekToTile(int oneBasedTileNumber) {
        this.cycleFileSetIterator.seekToTile(oneBasedTileNumber);
        this.getNextReaders();
    }

    @Override
    public void next(IlluminaReadData data) {
        this.initializeFCIDs(data);
        for (ClusterIntensityFileReader reader : this.readers) {
            for (int cycle = reader.getFirstCycle(); cycle < reader.getFirstCycle() + reader.getNumCycles(); ++cycle) {
                IlluminaEndData illuminaEndData = data.getEnd(this.readConfiguration.getEndTypeForCycle(cycle));
                FourChannelIntensityData fcid = this.getFCID(illuminaEndData);
                int offset = this.readConfiguration.getOffsetForCycle(cycle);
                for (IntensityChannel channel : IntensityChannel.values()) {
                    fcid.getChannel((IntensityChannel)channel)[offset] = reader.getValue(this.cluster, channel, cycle);
                }
            }
        }
        ++this.cluster;
        if (this.cluster == this.readers[0].getNumClusters() && this.cycleFileSetIterator.hasNext()) {
            this.cluster = 0;
            this.getNextReaders();
        }
    }

    @Override
    public boolean hasNext() {
        return this.readers.length > 0 && this.cluster < this.readers[0].getNumClusters();
    }

    private void getNextReaders() {
        Object it = this.cycleFileSetIterator.next();
        for (int i = 0; i < this.readers.length; ++i) {
            TiledIlluminaFile tiledFile = (TiledIlluminaFile)it.next();
            this.readers[i] = new ClusterIntensityFileReader(tiledFile.file);
        }
        if (it.hasNext()) {
            throw new PicardException("More cycle files than expected: " + ((TiledIlluminaFile)it.next()).file);
        }
    }

    private void initializeFCIDs(IlluminaReadData data) {
        this.setFCID(data.getFirstEnd(), new FourChannelIntensityData(this.readConfiguration.getFirstLength()));
        if (this.readConfiguration.isPairedEnd()) {
            this.setFCID(data.getSecondEnd(), new FourChannelIntensityData(this.readConfiguration.getSecondLength()));
        }
        if (this.readConfiguration.isBarcoded()) {
            this.setFCID(data.getBarcodeRead(), new FourChannelIntensityData(this.readConfiguration.getBarcodeLength()));
        }
    }

    protected abstract void setFCID(IlluminaEndData var1, FourChannelIntensityData var2);

    protected abstract FourChannelIntensityData getFCID(IlluminaEndData var1);

    protected static boolean filesExist(File directory, int lane, ClusterIntensityFileReader.FileType fileType, int tile) {
        try {
            CycleFileSetIterator fileSetIterator = new CycleFileSetIterator(new File(directory, "L00" + lane), lane, fileType, 1, Arrays.asList(tile));
            return fileSetIterator.hasNext();
        }
        catch (IlluminaFileNotFoundException e) {
            return false;
        }
    }
}

