/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.illumina.parser;

import java.io.File;
import java.util.List;
import java.util.NoSuchElementException;
import net.sf.picard.PicardException;
import net.sf.picard.illumina.parser.AbstractIlluminaDataProvider;
import net.sf.picard.illumina.parser.IlluminaEndData;
import net.sf.picard.illumina.parser.IlluminaParser;
import net.sf.picard.illumina.parser.IlluminaReadData;

public class IlluminaDataProvider
implements AbstractIlluminaDataProvider {
    private final List<IlluminaParser> parsers;
    private final boolean pairedEnd;
    private final boolean barcoded;
    private final File basecallDirectory;
    private final int lane;

    IlluminaDataProvider(boolean barcoded, boolean pairedEnd, List<IlluminaParser> parsers, File basecallDirectory, int lane) {
        this.barcoded = barcoded;
        this.basecallDirectory = basecallDirectory;
        this.lane = lane;
        this.pairedEnd = pairedEnd;
        this.parsers = parsers;
    }

    @Override
    public boolean hasNext() {
        if (this.parsers.isEmpty()) {
            return false;
        }
        boolean ret = this.parsers.get(0).hasNext();
        for (int i = 1; i < this.parsers.size(); ++i) {
            if (this.parsers.get(i).hasNext() == ret) continue;
            throw new PicardException("Unequal length basecall files in " + this.basecallDirectory + ", lane " + this.lane);
        }
        return ret;
    }

    @Override
    public IlluminaReadData next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        IlluminaReadData ret = new IlluminaReadData();
        ret.setFirstEnd(new IlluminaEndData());
        if (this.pairedEnd) {
            ret.setSecondEnd(new IlluminaEndData());
        }
        if (this.barcoded) {
            ret.setBarcodeRead(new IlluminaEndData());
        }
        for (IlluminaParser parser : this.parsers) {
            parser.next(ret);
        }
        return ret;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void seekToTile(int oneBasedTileNumber) {
        for (IlluminaParser parser : this.parsers) {
            parser.seekToTile(oneBasedTileNumber);
        }
    }
}

