/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.illumina.parser;

import net.sf.picard.PicardException;
import net.sf.picard.illumina.parser.EndType;
import net.sf.picard.illumina.parser.IlluminaEndData;

public class IlluminaReadData {
    private int lane = -1;
    private int tile = -1;
    private int x = -1;
    private int y = -1;
    private IlluminaEndData firstEnd;
    private IlluminaEndData secondEnd;
    private IlluminaEndData barcodeRead;
    private Boolean pf;
    private String matchedBarcode;

    public String toString() {
        return "IlluminaReadData(lane: " + this.lane + "; tile: " + this.tile + "; x: " + this.x + "; y: " + this.y + "; pf: " + this.pf + "; matchedBarcode: " + this.matchedBarcode + ")";
    }

    public int getTile() {
        return this.tile;
    }

    public void setTile(int tile) {
        this.tile = tile;
    }

    public boolean tileIsSet() {
        return this.tile != -1;
    }

    public void setOrCheckTile(int tile) {
        if (this.tileIsSet()) {
            if (this.tile != tile) {
                throw new PicardException("Tile number mismatch for " + this + " : " + this.tile + " != " + tile);
            }
        } else {
            this.tile = tile;
        }
    }

    public int getLane() {
        return this.lane;
    }

    public void setLane(int lane) {
        this.lane = lane;
    }

    public boolean laneIsSet() {
        return this.lane != -1;
    }

    public void setOrCheckLane(int lane) {
        if (this.laneIsSet()) {
            if (this.lane != lane) {
                throw new PicardException("Lane number mismatch for " + this + " : " + this.lane + " != " + lane);
            }
        } else {
            this.lane = lane;
        }
    }

    public int getX() {
        return this.x;
    }

    public void setX(int x) {
        this.x = x;
    }

    public boolean xIsSet() {
        return this.x != -1;
    }

    public void setOrCheckX(int x) {
        if (this.xIsSet()) {
            if (this.x != x) {
                throw new PicardException("X value mismatch for " + this + " : " + this.x + " != " + x);
            }
        } else {
            this.x = x;
        }
    }

    public int getY() {
        return this.y;
    }

    public void setY(int y) {
        this.y = y;
    }

    public boolean yIsSet() {
        return this.y != -1;
    }

    public void setOrCheckY(int y) {
        if (this.yIsSet()) {
            if (this.y != y) {
                throw new PicardException("Y value mismatch for " + this + " : " + this.y + " != " + y);
            }
        } else {
            this.y = y;
        }
    }

    public Boolean isPf() {
        return this.pf;
    }

    public void setPf(boolean pf) {
        this.pf = pf;
    }

    public void setOrCheckPf(boolean pf) {
        if (this.pf == null) {
            this.pf = pf;
        } else if (this.pf != pf) {
            throw new PicardException("PF value mismatch for " + this + " : ");
        }
    }

    public boolean isPairedEnd() {
        return this.secondEnd != null;
    }

    public int getNumEnds() {
        return this.isPairedEnd() ? 2 : 1;
    }

    public IlluminaEndData getEnd(int oneBasedEndIndex) {
        return oneBasedEndIndex == 2 ? this.secondEnd : this.firstEnd;
    }

    public void setEnd(IlluminaEndData end, int oneBasedEndIndex) {
        if (oneBasedEndIndex == 1) {
            this.firstEnd = end;
        } else if (oneBasedEndIndex == 2) {
            this.secondEnd = end;
        } else {
            throw new IllegalArgumentException();
        }
    }

    public IlluminaEndData getFirstEnd() {
        return this.firstEnd;
    }

    public void setFirstEnd(IlluminaEndData firstEnd) {
        this.firstEnd = firstEnd;
    }

    public IlluminaEndData getSecondEnd() {
        return this.secondEnd;
    }

    public void setSecondEnd(IlluminaEndData secondEnd) {
        this.secondEnd = secondEnd;
    }

    public IlluminaEndData getBarcodeRead() {
        return this.barcodeRead;
    }

    public void setBarcodeRead(IlluminaEndData barcodeRead) {
        this.barcodeRead = barcodeRead;
    }

    public String getMatchedBarcode() {
        return this.matchedBarcode;
    }

    public void setMatchedBarcode(String matchedBarcode) {
        this.matchedBarcode = matchedBarcode;
    }

    public IlluminaEndData getEnd(EndType whichEndType) {
        switch (whichEndType) {
            case BARCODE: {
                return this.barcodeRead;
            }
            case FIRST: {
                return this.firstEnd;
            }
            case SECOND: {
                return this.secondEnd;
            }
        }
        throw new IllegalArgumentException("Null or strange value passed to getEnd");
    }
}

