/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.illumina.parser;

import java.io.File;
import java.util.Arrays;
import java.util.List;
import net.sf.picard.illumina.parser.AbstractIlluminaTextParser;
import net.sf.picard.illumina.parser.FourChannelIntensityData;
import net.sf.picard.illumina.parser.IlluminaEndData;
import net.sf.picard.illumina.parser.IlluminaFileNotFoundException;
import net.sf.picard.illumina.parser.IlluminaFileUtil;
import net.sf.picard.illumina.parser.IlluminaReadData;
import net.sf.picard.illumina.parser.ReadConfiguration;

public abstract class IntensitiesOrNoiseParser
extends AbstractIlluminaTextParser {
    private static final int COLUMNS_PER_BASE = 4;
    private static final int INTENSITIES_OFFSET = 4;

    public IntensitiesOrNoiseParser(ReadConfiguration readConfiguration, File directory, int lane, String fileType, List<Integer> tiles) {
        super(readConfiguration, lane, directory);
        this.setFiles(IlluminaFileUtil.getNonEndedIlluminaBasecallFiles(directory, fileType, lane, tiles));
        this.initializeParser(0);
    }

    @Override
    protected void processLine(IlluminaReadData data, String[] fields) {
        int lane = IntensitiesOrNoiseParser.getFormatter().parseInt(fields[0]);
        this.validateLane(lane);
        int tile = IntensitiesOrNoiseParser.getFormatter().parseInt(fields[1]);
        int x = IntensitiesOrNoiseParser.getFormatter().parseInt(fields[2]);
        int y = IntensitiesOrNoiseParser.getFormatter().parseInt(fields[3]);
        data.setOrCheckLane(lane);
        data.setOrCheckTile(tile);
        data.setOrCheckX(x);
        data.setOrCheckY(y);
        int firstStart = this.convertCycleNumberToIntensityIndex(this.getReadConfiguration().getFirstStart());
        int firstEnd = this.convertCycleNumberToIntensityIndex(this.getReadConfiguration().getFirstEnd() + 1);
        this.setValues(data.getFirstEnd(), IlluminaFileUtil.parseSig2Intensities(fields, firstStart, firstEnd));
        if (this.getReadConfiguration().isPairedEnd()) {
            int secondStart = this.convertCycleNumberToIntensityIndex(this.getReadConfiguration().getSecondStart());
            int secondEnd = this.convertCycleNumberToIntensityIndex(this.getReadConfiguration().getSecondEnd() + 1);
            this.setValues(data.getSecondEnd(), IlluminaFileUtil.parseSig2Intensities(fields, secondStart, secondEnd));
        }
        if (this.getReadConfiguration().isBarcoded()) {
            int barcodeStart = this.convertCycleNumberToIntensityIndex(this.getReadConfiguration().getBarcodeStart());
            int barcodeEnd = this.convertCycleNumberToIntensityIndex(this.getReadConfiguration().getBarcodeEnd() + 1);
            this.setValues(data.getBarcodeRead(), IlluminaFileUtil.parseSig2Intensities(fields, barcodeStart, barcodeEnd));
        }
    }

    private int convertCycleNumberToIntensityIndex(int cycleNumber) {
        return (cycleNumber - 1) * 4 + 4;
    }

    protected abstract void setValues(IlluminaEndData var1, FourChannelIntensityData var2);

    protected static boolean fileExists(File directory, int lane, String fileType, int tile) {
        try {
            return IlluminaFileUtil.getNonEndedIlluminaBasecallFiles(directory, fileType, lane, Arrays.asList(tile)).length > 0;
        }
        catch (IlluminaFileNotFoundException ex) {
            return false;
        }
    }
}

