/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.illumina.parser;

import java.io.File;
import java.util.List;
import net.sf.picard.PicardException;
import net.sf.picard.illumina.parser.AbstractIlluminaTextParser;
import net.sf.picard.illumina.parser.IlluminaFileUtil;
import net.sf.picard.illumina.parser.IlluminaReadData;
import net.sf.picard.illumina.parser.ReadConfiguration;
import net.sf.picard.util.IlluminaUtil;

public class PrbParser
extends AbstractIlluminaTextParser {
    public PrbParser(ReadConfiguration readConfiguration, File directory, int lane, List<Integer> tiles) {
        super(readConfiguration, lane, directory);
        this.setFiles(IlluminaFileUtil.getNonEndedIlluminaBasecallFiles(directory, "prb", lane, tiles));
        this.initializeParser(0);
    }

    @Override
    protected void processLine(IlluminaReadData data, String[] fields) {
        int i;
        int expectedLength = this.getReadConfiguration().getFirstLength() + this.getReadConfiguration().getSecondLength() + this.getReadConfiguration().getBarcodeLength();
        if (expectedLength * 4 != fields.length) {
            throw new PicardException("Number of fields does not match expected in " + this.getCurrentFilename());
        }
        byte[] solexaQualityChars = new byte[this.getReadConfiguration().getFirstLength()];
        int startCycle = this.getReadConfiguration().getFirstStart();
        for (i = 0; i < this.getReadConfiguration().getFirstLength(); ++i) {
            solexaQualityChars[i] = IlluminaUtil.getSolexaQualityCharFromFourQualities(fields, startCycle + i, PrbParser.getFormatter());
        }
        IlluminaUtil.convertSolexaQualityAscii_1_1_ToPhredBinary(solexaQualityChars);
        data.getFirstEnd().setQualities(solexaQualityChars);
        if (this.getReadConfiguration().isPairedEnd()) {
            solexaQualityChars = new byte[this.getReadConfiguration().getSecondLength()];
            startCycle = this.getReadConfiguration().getSecondStart();
            for (i = 0; i < this.getReadConfiguration().getSecondLength(); ++i) {
                solexaQualityChars[i] = IlluminaUtil.getSolexaQualityCharFromFourQualities(fields, startCycle + i, PrbParser.getFormatter());
            }
            IlluminaUtil.convertSolexaQualityAscii_1_1_ToPhredBinary(solexaQualityChars);
            data.getSecondEnd().setQualities(solexaQualityChars);
        }
        if (this.getReadConfiguration().isBarcoded()) {
            solexaQualityChars = new byte[this.getReadConfiguration().getBarcodeLength()];
            startCycle = this.getReadConfiguration().getBarcodeStart();
            for (i = 0; i < this.getReadConfiguration().getBarcodeLength(); ++i) {
                solexaQualityChars[i] = IlluminaUtil.getSolexaQualityCharFromFourQualities(fields, startCycle + i, PrbParser.getFormatter());
            }
            IlluminaUtil.convertSolexaQualityAscii_1_1_ToPhredBinary(solexaQualityChars);
            data.getBarcodeRead().setQualities(solexaQualityChars);
        }
    }
}

