/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.illumina.parser;

import java.io.File;
import java.util.List;
import net.sf.picard.illumina.parser.AbstractIlluminaTextParser;
import net.sf.picard.illumina.parser.IlluminaFileUtil;
import net.sf.picard.illumina.parser.IlluminaReadData;
import net.sf.picard.illumina.parser.ReadConfiguration;

public class QhgParser
extends AbstractIlluminaTextParser {
    private static final double PASSING_FILTER_THRESHOLD = 0.6;
    private static final int LANE_COLUMN = 0;
    private static final int TILE_COLUMN = 1;
    private static final int X_COLUMN = 2;
    private static final int Y_COLUMN = 3;
    private static final int PF_SCORE_COLUMN = 5;

    public QhgParser(ReadConfiguration readConfiguration, File directory, int lane, List<Integer> tiles) {
        super(readConfiguration, lane, directory);
        this.setFiles(IlluminaFileUtil.getNonEndedIlluminaBasecallFiles(directory, "qhg", lane, tiles));
        this.initializeParser(0);
    }

    @Override
    protected void processLine(IlluminaReadData data, String[] fields) {
        int lane = QhgParser.getFormatter().parseInt(fields[0]);
        this.validateLane(lane);
        int tile = QhgParser.getFormatter().parseInt(fields[1]);
        int x = QhgParser.getFormatter().parseInt(fields[2]);
        int y = QhgParser.getFormatter().parseInt(fields[3]);
        double pfScore = QhgParser.getFormatter().parseDouble(fields[5]);
        boolean passingFilter = pfScore >= 0.6;
        data.setOrCheckLane(lane);
        data.setOrCheckTile(tile);
        data.setOrCheckX(x);
        data.setOrCheckY(y);
        data.setOrCheckPf(passingFilter);
    }
}

