/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.illumina.parser;

import java.io.File;
import java.util.List;
import net.sf.picard.PicardException;
import net.sf.picard.illumina.parser.AbstractIlluminaTextParser;
import net.sf.picard.illumina.parser.EndType;
import net.sf.picard.illumina.parser.IlluminaEndData;
import net.sf.picard.illumina.parser.IlluminaFileUtil;
import net.sf.picard.illumina.parser.IlluminaReadData;
import net.sf.picard.illumina.parser.ReadConfiguration;
import net.sf.picard.util.BasicInputParser;
import net.sf.picard.util.IlluminaUtil;
import net.sf.samtools.util.StringUtil;

public class QseqParser
extends AbstractIlluminaTextParser {
    private static final int LANE_COLUMN = 2;
    private static final int TILE_COLUMN = 3;
    private static final int X_COLUMN = 4;
    private static final int Y_COLUMN = 5;
    private static final int MACHINE_COLUMN = 0;
    private static final int RUN__COLUMN = 1;
    private static final int PF_COLUMN = 10;
    private static final int BASES_COLUMN = 8;
    private static final int QUALS_COLUMN = 9;
    private final EndType endType;

    public QseqParser(ReadConfiguration readConfiguration, File directory, int lane, EndType endType, List<Integer> tiles) {
        this(readConfiguration, directory, lane, endType, endType.getDefaultFileNumber(), tiles);
        if (endType != EndType.FIRST && endType != EndType.SECOND) {
            throw new IllegalArgumentException("Invalid EndType: " + (Object)((Object)endType));
        }
    }

    public QseqParser(ReadConfiguration readConfiguration, File directory, int lane, EndType endType, int fileNumber, List<Integer> tiles) {
        super(readConfiguration, lane, directory);
        if (fileNumber < 1 || fileNumber > 3) {
            throw new IllegalArgumentException("Invalid fileNumber: " + fileNumber);
        }
        this.endType = endType;
        this.setFiles(IlluminaFileUtil.getEndedIlluminaBasecallFiles(directory, "qseq", lane, fileNumber, tiles));
        this.initializeParser(0);
    }

    @Override
    protected void processLine(IlluminaReadData data, String[] fields) {
        IlluminaEndData end;
        boolean containsBarcode;
        int lane = QseqParser.getFormatter().parseInt(fields[2]);
        this.validateLane(lane);
        int tile = QseqParser.getFormatter().parseInt(fields[3]);
        int x = QseqParser.getFormatter().parseInt(fields[4]);
        int y = QseqParser.getFormatter().parseInt(fields[5]);
        boolean pf = QseqParser.getFormatter().parseInt(fields[10]) == 1;
        String baseString = fields[8];
        String qualString = fields[9];
        if (baseString.length() != qualString.length()) {
            throw new PicardException("Length of bases and quals don't match in " + this.getCurrentFilename());
        }
        int expectedLength = this.endType == EndType.FIRST ? this.getReadConfiguration().getFirstLength() : (this.endType == EndType.SECOND ? this.getReadConfiguration().getSecondLength() : this.getReadConfiguration().getBarcodeLength());
        int expectedLengthIncludingBarcode = expectedLength;
        boolean bl = containsBarcode = this.getReadConfiguration().isBarcoded() && this.getReadConfiguration().getBarcodeRead() == this.endType && !this.isBarcodeQseq();
        if (containsBarcode) {
            expectedLengthIncludingBarcode += this.getReadConfiguration().getBarcodeLength();
        }
        if (expectedLengthIncludingBarcode != baseString.length()) {
            throw new PicardException("Length of bases does not match expected in " + this.getCurrentFilename());
        }
        data.setOrCheckLane(lane);
        data.setOrCheckTile(tile);
        data.setOrCheckX(x);
        data.setOrCheckY(y);
        data.setOrCheckPf(pf);
        IlluminaEndData illuminaEndData = end = this.isBarcodeQseq() ? data.getBarcodeRead() : data.getEnd(this.endType);
        if (containsBarcode) {
            int barcodeOffset = this.getReadConfiguration().getOffsetOfBarcodeInRead();
            int readOffset = this.getReadConfiguration().getOffsetOfNonBarcodeInRead();
            if (expectedLength > 0) {
                byte[] readBases = StringUtil.stringToBytes((String)baseString, (int)readOffset, (int)expectedLength);
                byte[] readQuals = IlluminaUtil.makePhredBinaryFromSolexaQualityAscii_1_3(qualString, readOffset, expectedLength);
                end.setBases(readBases);
                end.setQualities(readQuals);
            }
            byte[] barcodeBases = StringUtil.stringToBytes((String)baseString, (int)barcodeOffset, (int)this.getReadConfiguration().getBarcodeLength());
            byte[] barcodeQuals = IlluminaUtil.makePhredBinaryFromSolexaQualityAscii_1_3(qualString, barcodeOffset, this.getReadConfiguration().getBarcodeLength());
            data.getBarcodeRead().setBases(barcodeBases);
            data.getBarcodeRead().setQualities(barcodeQuals);
        } else {
            byte[] bases = StringUtil.stringToBytes((String)baseString);
            end.setBases(bases);
            byte[] quals = IlluminaUtil.makePhredBinaryFromSolexaQualityAscii_1_3(qualString);
            end.setQualities(quals);
        }
    }

    private boolean isBarcodeQseq() {
        return this.endType == EndType.BARCODE;
    }

    public static int getReadLength(File qseqFile) {
        BasicInputParser parser = new BasicInputParser(true, qseqFile);
        if (!parser.hasNext()) {
            throw new PicardException("Unexpected empty qseq file: " + qseqFile);
        }
        String[] fields = (String[])parser.next();
        return fields[8].length();
    }
}

