/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.illumina.parser;

import java.util.ArrayList;
import net.sf.picard.PicardException;
import net.sf.picard.illumina.parser.EndType;
import net.sf.samtools.util.CoordMath;

public class ReadConfiguration {
    private boolean pairedEnd;
    private boolean barcoded;
    private EndType barcodeRead;
    private final InclusiveRange first = new InclusiveRange("first");
    private final InclusiveRange second = new InclusiveRange("second");
    private final InclusiveRange barcode = new InclusiveRange("barcode");

    public void assertValid() {
        this.assertValid(false);
    }

    public void assertValid(boolean allowZeroLengthFirstEnd) {
        if (this.first.getLength() > 0 || !allowZeroLengthFirstEnd) {
            this.first.assertValid();
        }
        if (this.pairedEnd) {
            this.second.assertValid();
            if (this.first.compareTo(this.second) >= 0) {
                throw new PicardException("Second end precedes first end in ReadConfiguration.");
            }
        }
        if (this.barcoded) {
            this.barcode.assertValid();
        }
        ArrayList<InclusiveRange> ranges = new ArrayList<InclusiveRange>();
        ranges.add(this.first);
        if (this.pairedEnd) {
            ranges.add(this.second);
        }
        if (this.barcoded) {
            boolean added = false;
            for (int i = 0; i < ranges.size(); ++i) {
                if (this.barcode.compareTo((InclusiveRange)ranges.get(i)) >= 0) continue;
                ranges.add(i, this.barcode);
                added = true;
                break;
            }
            if (!added) {
                ranges.add(this.barcode);
            }
        }
        if (((InclusiveRange)ranges.get((int)0)).start != 1) {
            throw new PicardException("ReadConfiguration does not start at cycle 1.");
        }
        for (int i = 0; i < ranges.size() - 1; ++i) {
            if (!((InclusiveRange)ranges.get(i)).abuts((InclusiveRange)ranges.get(i + 1))) {
                throw new PicardException("ReadConfiguration has cycle number gap.");
            }
            if (((InclusiveRange)ranges.get(i)).compareTo((InclusiveRange)ranges.get(i + 1)) < 0) continue;
            throw new PicardException("That's unpossible");
        }
    }

    public int getMaxCycleNumber() {
        int ret = this.pairedEnd ? this.second.end : this.first.end;
        if (this.barcoded) {
            return Math.max(ret, this.barcode.end);
        }
        return ret;
    }

    public boolean isBarcoded() {
        return this.barcoded;
    }

    public void setBarcoded(boolean barcoded) {
        this.barcoded = barcoded;
    }

    public EndType getBarcodeRead() {
        return this.barcodeRead;
    }

    public void setBarcodeRead(EndType barcodeRead) {
        this.barcodeRead = barcodeRead;
    }

    public int getBarcodeEnd() {
        return this.barcode.end;
    }

    public void setBarcodeEnd(int barcodeEnd) {
        this.barcode.end = barcodeEnd;
    }

    public int getBarcodeStart() {
        return this.barcode.start;
    }

    public void setBarcodeStart(int barcodeStart) {
        this.barcode.start = barcodeStart;
    }

    public int getFirstEnd() {
        return this.first.end;
    }

    public void setFirstEnd(int firstEnd) {
        this.first.end = firstEnd;
    }

    public int getFirstStart() {
        return this.first.start;
    }

    public void setFirstStart(int firstStart) {
        this.first.start = firstStart;
    }

    public boolean isPairedEnd() {
        return this.pairedEnd;
    }

    public void setPairedEnd(boolean pairedEnd) {
        this.pairedEnd = pairedEnd;
    }

    public int getSecondEnd() {
        return this.second.end;
    }

    public void setSecondEnd(int secondEnd) {
        this.second.end = secondEnd;
    }

    public int getSecondStart() {
        return this.second.start;
    }

    public void setSecondStart(int secondStart) {
        this.second.start = secondStart;
    }

    public int getFirstLength() {
        return this.first.getLength();
    }

    public int getSecondLength() {
        if (!this.pairedEnd) {
            return 0;
        }
        return this.second.getLength();
    }

    public int getBarcodeLength() {
        if (!this.barcoded) {
            return 0;
        }
        return this.barcode.getLength();
    }

    public InclusiveRange getFirstRange() {
        return this.first;
    }

    public InclusiveRange getSecondRange() {
        return this.second;
    }

    public InclusiveRange getBarcodeRange() {
        return this.barcode;
    }

    public int getOffsetOfBarcodeInRead() {
        InclusiveRange range;
        if (!this.barcoded) {
            throw new IllegalStateException();
        }
        InclusiveRange inclusiveRange = range = this.barcodeRead == EndType.FIRST ? this.first : this.second;
        if (this.getBarcodeEnd() + 1 == range.getStart()) {
            return 0;
        }
        return range.getLength();
    }

    public int getOffsetOfNonBarcodeInRead() {
        InclusiveRange range;
        if (!this.barcoded) {
            throw new IllegalStateException();
        }
        InclusiveRange inclusiveRange = range = this.barcodeRead == EndType.FIRST ? this.first : this.second;
        if (this.getBarcodeEnd() + 1 == range.getStart()) {
            return this.getBarcodeLength();
        }
        return 0;
    }

    public EndType getEndTypeForCycle(int cycle) {
        if (cycle >= this.first.getStart() && cycle <= this.first.getEnd()) {
            return EndType.FIRST;
        }
        if (cycle >= this.second.getStart() && cycle <= this.second.getEnd()) {
            return EndType.SECOND;
        }
        if (cycle >= this.barcode.getStart() && cycle <= this.barcode.getEnd()) {
            return EndType.BARCODE;
        }
        throw new IllegalArgumentException("Invalid cycle number for read configuration: " + cycle);
    }

    public int getOffsetForCycle(int cycle) {
        if (cycle >= this.first.getStart() && cycle <= this.first.getEnd()) {
            return cycle - this.first.getStart();
        }
        if (cycle >= this.second.getStart() && cycle <= this.second.getEnd()) {
            return cycle - this.second.getStart();
        }
        if (cycle >= this.barcode.getStart() && cycle <= this.barcode.getEnd()) {
            return cycle - this.barcode.getStart();
        }
        throw new IllegalArgumentException("Invalid cycle number for read configuration: " + cycle);
    }

    public static class InclusiveRange {
        String name;
        int start = 0;
        int end = 0;

        InclusiveRange(String name) {
            this.name = name;
        }

        public int getEnd() {
            return this.end;
        }

        public void setEnd(int end) {
            this.end = end;
        }

        public int getStart() {
            return this.start;
        }

        public void setStart(int start) {
            this.start = start;
        }

        public int getLength() {
            if (this.end == 0) {
                return 0;
            }
            return CoordMath.getLength((int)this.start, (int)this.end);
        }

        public void assertValid() {
            if (this.start < 1) {
                throw new PicardException("ReadConfiguration.Range " + this.name + " has start < 1");
            }
            if (this.end < this.start) {
                throw new PicardException("ReadConfiguration.Range " + this.name + " has end < start");
            }
        }

        public boolean overlaps(InclusiveRange other) {
            return CoordMath.overlaps((int)this.start, (int)this.end, (int)other.start, (int)other.end);
        }

        public int compareTo(InclusiveRange that) {
            if (this.start != that.start) {
                return this.start - that.start;
            }
            return this.end - that.end;
        }

        public boolean abuts(InclusiveRange that) {
            return this.end + 1 == that.start || that.end + 1 == this.start;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            InclusiveRange that = (InclusiveRange)o;
            if (this.end != that.end) {
                return false;
            }
            if (this.start != that.start) {
                return false;
            }
            return !(this.name != null ? !this.name.equals(that.name) : that.name != null);
        }

        public int hashCode() {
            int result = this.name != null ? this.name.hashCode() : 0;
            result = 31 * result + this.start;
            result = 31 * result + this.end;
            return result;
        }
    }
}

