/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.illumina.parser;

import java.io.File;
import java.util.List;
import net.sf.picard.PicardException;
import net.sf.picard.illumina.parser.AbstractIlluminaTextParser;
import net.sf.picard.illumina.parser.IlluminaFileUtil;
import net.sf.picard.illumina.parser.IlluminaReadData;
import net.sf.picard.illumina.parser.ReadConfiguration;
import net.sf.picard.util.BasicInputParser;
import net.sf.samtools.util.StringUtil;

public class SeqParser
extends AbstractIlluminaTextParser {
    private static final int LANE_COLUMN = 0;
    private static final int TILE_COLUMN = 1;
    private static final int X_COLUMN = 2;
    private static final int Y_COLUMN = 3;
    private static final int BASES_COLUMN = 4;

    public SeqParser(ReadConfiguration readConfiguration, File directory, int lane, List<Integer> tiles) {
        super(readConfiguration, lane, directory);
        this.setFiles(IlluminaFileUtil.getNonEndedIlluminaBasecallFiles(directory, "seq", lane, tiles));
        this.initializeParser(0);
    }

    @Override
    protected void processLine(IlluminaReadData data, String[] fields) {
        int lane = SeqParser.getFormatter().parseInt(fields[0]);
        this.validateLane(lane);
        int tile = SeqParser.getFormatter().parseInt(fields[1]);
        int x = SeqParser.getFormatter().parseInt(fields[2]);
        int y = SeqParser.getFormatter().parseInt(fields[3]);
        String baseString = fields[4];
        int expectedLength = this.getReadConfiguration().getFirstLength() + this.getReadConfiguration().getSecondLength() + this.getReadConfiguration().getBarcodeLength();
        if (expectedLength != baseString.length()) {
            throw new PicardException("Length of bases does not match expected in " + this.getCurrentFilename());
        }
        data.setOrCheckLane(lane);
        data.setOrCheckTile(tile);
        data.setOrCheckX(x);
        data.setOrCheckY(y);
        byte[] bases1 = StringUtil.stringToBytes((String)baseString, (int)(this.getReadConfiguration().getFirstStart() - 1), (int)this.getReadConfiguration().getFirstLength());
        data.getFirstEnd().setBases(bases1);
        if (this.getReadConfiguration().isPairedEnd()) {
            byte[] bases2 = StringUtil.stringToBytes((String)baseString, (int)(this.getReadConfiguration().getSecondStart() - 1), (int)this.getReadConfiguration().getSecondLength());
            data.getSecondEnd().setBases(bases2);
        }
        if (this.getReadConfiguration().isBarcoded()) {
            byte[] barcodeBases = StringUtil.stringToBytes((String)baseString, (int)(this.getReadConfiguration().getBarcodeStart() - 1), (int)this.getReadConfiguration().getBarcodeLength());
            data.getBarcodeRead().setBases(barcodeBases);
        }
    }

    public static int getReadLength(File seqFile) {
        BasicInputParser parser = new BasicInputParser(true, seqFile);
        if (!parser.hasNext()) {
            throw new PicardException("Unexpected empty qseq file: " + seqFile);
        }
        String[] fields = (String[])parser.next();
        return fields[4].length();
    }
}

