/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.sam;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.picard.PicardException;
import net.sf.picard.cmdline.CommandLineProgram;
import net.sf.picard.cmdline.Option;
import net.sf.picard.cmdline.Usage;
import net.sf.picard.fastq.FastqRecord;
import net.sf.picard.fastq.FastqWriter;
import net.sf.picard.io.IoUtil;
import net.sf.samtools.SAMFileReader;
import net.sf.samtools.SAMReadGroupRecord;
import net.sf.samtools.SAMRecord;
import net.sf.samtools.SAMUtils;
import net.sf.samtools.util.SequenceUtil;
import net.sf.samtools.util.StringUtil;

public class SamToFastq
extends CommandLineProgram {
    @Usage
    public String USAGE = "Extracts read sequences and qualities from the input SAM/BAM file and writes them into the output file in Sanger fastq format. In the RC mode (default is True), if the read is aligned and the alignment is to the reverse strand on the genome, the read's sequence from input SAM file will be reverse-complemented prior to writing it to fastq in order restore correctly the original read sequence as it was generated by the sequencer.";
    @Option(doc="Input SAM/BAM file to extract reads from", shortName="I")
    public File INPUT;
    @Option(shortName="F", doc="Output fastq file (single-end fastq or, if paired, first end of the pair fastq).", mutex={"OUTPUT_PER_RG"})
    public File FASTQ;
    @Option(shortName="F2", doc="Output fastq file (if paired, second end of the pair fastq).", optional=true, mutex={"OUTPUT_PER_RG"})
    public File SECOND_END_FASTQ;
    @Option(shortName="OPRG", doc="Output a fastq file per read group (two fastq files per read group if the group is paired).", optional=true, mutex={"FASTQ", "SECOND_END_FASTQ"})
    public boolean OUTPUT_PER_RG;
    @Option(shortName="ODIR", doc="Directory in which to output the fastq file(s).  Used only when OUTPUT_PER_RG is true.", optional=true)
    public File OUTPUT_DIR;
    @Option(shortName="RC", doc="Re-reverse bases and qualities of reads with negative strand flag set before writing them to fastq", optional=true)
    public boolean RE_REVERSE = true;
    @Option(shortName="NON_PF", doc="Include non-PF reads from the SAM file into the output FASTQ files.")
    public boolean INCLUDE_NON_PF_READS = false;
    @Option(shortName="CLIP_ATTR", doc="The attribute that stores the position at which the SAM record should be clipped", optional=true)
    public String CLIPPING_ATTRIBUTE;
    @Option(shortName="CLIP_ACT", doc="The action that should be taken with clipped reads: 'X' means the reads and qualities should be trimmed at the clipped position; 'N' means the bases should be changed to Ns in the clipped region; and any integer means that the base qualities should be set to that value in the clipped region.", optional=true)
    public String CLIPPING_ACTION;
    @Option(shortName="R1_TRIM", doc="The number of bases to trim from the beginning of read 1.")
    public int READ1_TRIM = 0;
    @Option(shortName="R1_MAX_BASES", doc="The maximum number of bases to write from read 1 after trimming. If there are fewer than this many bases left after trimming, all will be written.  If this value is null then all bases left after trimming will be written.", optional=true)
    public Integer READ1_MAX_BASES_TO_WRITE;
    @Option(shortName="R2_TRIM", doc="The number of bases to trim from the beginning of read 2.")
    public int READ2_TRIM = 0;
    @Option(shortName="R2_MAX_BASES", doc="The maximum number of bases to write from read 2 after trimming. If there are fewer than this many bases left after trimming, all will be written.  If this value is null then all bases left after trimming will be written.", optional=true)
    public Integer READ2_MAX_BASES_TO_WRITE;

    public static void main(String[] argv) {
        System.exit(new SamToFastq().instanceMain(argv));
    }

    @Override
    protected int doWork() {
        IoUtil.assertFileIsReadable(this.INPUT);
        SAMFileReader reader = new SAMFileReader(IoUtil.openFileForReading(this.INPUT));
        HashMap<String, SAMRecord> firstSeenMates = new HashMap<String, SAMRecord>();
        HashMap<SAMReadGroupRecord, List<FastqWriter>> writers = new HashMap<SAMReadGroupRecord, List<FastqWriter>>();
        for (SAMRecord currentRecord : reader) {
            if (currentRecord.getReadFailsVendorQualityCheckFlag() && !this.INCLUDE_NON_PF_READS) continue;
            if (currentRecord.getReadPairedFlag()) {
                String currentReadName = currentRecord.getReadName();
                SAMRecord firstRecord = (SAMRecord)firstSeenMates.remove(currentReadName);
                if (firstRecord == null) {
                    firstSeenMates.put(currentReadName, currentRecord);
                    continue;
                }
                this.assertPairedMates(firstRecord, currentRecord);
                List<FastqWriter> fq = this.getWriters(currentRecord, writers);
                SAMRecord read1 = currentRecord.getFirstOfPairFlag() ? currentRecord : firstRecord;
                SAMRecord read2 = currentRecord.getFirstOfPairFlag() ? firstRecord : currentRecord;
                this.writeRecord(read1, 1, fq.get(0), this.READ1_TRIM, this.READ1_MAX_BASES_TO_WRITE);
                this.writeRecord(read2, 2, fq.get(1), this.READ2_TRIM, this.READ2_MAX_BASES_TO_WRITE);
                continue;
            }
            this.writeRecord(currentRecord, null, this.getWriter(currentRecord, writers), this.READ1_TRIM, this.READ1_MAX_BASES_TO_WRITE);
        }
        reader.close();
        if (firstSeenMates.size() > 0) {
            throw new PicardException("Found " + firstSeenMates.size() + " unpaired mates");
        }
        for (List listOfWriters : writers.values()) {
            for (FastqWriter w : listOfWriters) {
                w.close();
            }
        }
        return 0;
    }

    private List<FastqWriter> getWriters(SAMRecord sam, Map<SAMReadGroupRecord, List<FastqWriter>> writers) {
        SAMReadGroupRecord rg = sam.getReadGroup();
        if (!this.OUTPUT_PER_RG) {
            if (writers.isEmpty()) {
                ArrayList<FastqWriter> fqw = new ArrayList<FastqWriter>();
                IoUtil.assertFileIsWritable(this.FASTQ);
                fqw.add(new FastqWriter(this.FASTQ));
                if (this.SECOND_END_FASTQ != null) {
                    IoUtil.assertFileIsWritable(this.SECOND_END_FASTQ);
                    fqw.add(new FastqWriter(this.SECOND_END_FASTQ));
                }
                writers.put(rg, fqw);
            }
            return writers.values().iterator().next();
        }
        List<FastqWriter> fqw = writers.get(rg);
        if (fqw == null) {
            fqw = new ArrayList<FastqWriter>();
            fqw.add(new FastqWriter(this.makeReadGroupFile(rg, "_1")));
            if (sam.getReadPairedFlag()) {
                fqw.add(new FastqWriter(this.makeReadGroupFile(rg, "_2")));
            }
            writers.put(rg, fqw);
        }
        return fqw;
    }

    private FastqWriter getWriter(SAMRecord sam, Map<SAMReadGroupRecord, List<FastqWriter>> writers) {
        return this.getWriters(sam, writers).get(0);
    }

    private File makeReadGroupFile(SAMReadGroupRecord readGroup, String preExtSuffix) {
        String fileName = readGroup.getPlatformUnit();
        if (fileName == null) {
            fileName = readGroup.getReadGroupId();
        }
        fileName = IoUtil.makeFileNameSafe(fileName);
        if (preExtSuffix != null) {
            fileName = fileName + preExtSuffix;
        }
        fileName = fileName + ".fastq";
        File result = this.OUTPUT_DIR != null ? new File(this.OUTPUT_DIR, fileName) : new File(fileName);
        IoUtil.assertFileIsWritable(result);
        return result;
    }

    void writeRecord(SAMRecord read, Integer mateNumber, FastqWriter writer, int basesToTrim, Integer maxBasesToWrite) {
        Integer clipPoint;
        String seqHeader = mateNumber == null ? read.getReadName() : read.getReadName() + "/" + mateNumber;
        String readString = read.getReadString();
        String baseQualities = read.getBaseQualityString();
        if (this.CLIPPING_ATTRIBUTE != null && (clipPoint = (Integer)read.getAttribute(this.CLIPPING_ATTRIBUTE)) != null) {
            if (this.CLIPPING_ACTION.equalsIgnoreCase("X")) {
                readString = this.clip(readString, clipPoint, null, !read.getReadNegativeStrandFlag());
                baseQualities = this.clip(baseQualities, clipPoint, null, !read.getReadNegativeStrandFlag());
            } else if (this.CLIPPING_ACTION.equalsIgnoreCase("N")) {
                readString = this.clip(readString, clipPoint, Character.valueOf('N'), !read.getReadNegativeStrandFlag());
            } else {
                char newQual = SAMUtils.phredToFastq((byte[])new byte[]{(byte)Integer.parseInt(this.CLIPPING_ACTION)}).charAt(0);
                baseQualities = this.clip(baseQualities, clipPoint, Character.valueOf(newQual), !read.getReadNegativeStrandFlag());
            }
        }
        if (this.RE_REVERSE && read.getReadNegativeStrandFlag()) {
            readString = SequenceUtil.reverseComplement((String)readString);
            baseQualities = StringUtil.reverseString((String)baseQualities);
        }
        if (basesToTrim > 0) {
            readString = readString.substring(basesToTrim);
            baseQualities = baseQualities.substring(basesToTrim);
        }
        if (maxBasesToWrite != null && maxBasesToWrite < readString.length()) {
            readString = readString.substring(0, maxBasesToWrite);
            baseQualities = baseQualities.substring(0, maxBasesToWrite);
        }
        writer.write(new FastqRecord(seqHeader, readString, "", baseQualities));
    }

    private String clip(String src, int point, Character replacement, boolean posStrand) {
        String result;
        block4: {
            int len = src.length();
            String string = result = posStrand ? src.substring(0, point - 1) : src.substring(len - point + 1);
            if (replacement == null) break block4;
            if (posStrand) {
                for (int i = point; i <= len; ++i) {
                    result = result + replacement;
                }
            } else {
                for (int i = 0; i <= len - point; ++i) {
                    result = replacement + result;
                }
            }
        }
        return result;
    }

    private void assertPairedMates(SAMRecord record1, SAMRecord record2) {
        if (!(record1.getFirstOfPairFlag() && record2.getSecondOfPairFlag() || record2.getFirstOfPairFlag() && record1.getSecondOfPairFlag())) {
            throw new PicardException("Illegal mate state: " + record1.getReadName());
        }
    }

    @Override
    protected String[] customCommandLineValidation() {
        if (this.CLIPPING_ATTRIBUTE != null && this.CLIPPING_ACTION == null || this.CLIPPING_ATTRIBUTE == null && this.CLIPPING_ACTION != null) {
            return new String[]{"Both or neither of CLIPPING_ATTRIBUTE and CLIPPING_ACTION should be set."};
        }
        if (this.CLIPPING_ACTION != null && !this.CLIPPING_ACTION.equals("N") && !this.CLIPPING_ACTION.equals("X")) {
            try {
                Integer.parseInt(this.CLIPPING_ACTION);
            }
            catch (NumberFormatException nfe) {
                return new String[]{"CLIPPING ACTION must be one of: N, X, or an integer"};
            }
        }
        if (this.OUTPUT_PER_RG && this.OUTPUT_DIR == null || !this.OUTPUT_PER_RG && this.OUTPUT_DIR != null) {
            return new String[]{"If OUTPUT_PER_RG is true, then OUTPUT_DIR should be set. If "};
        }
        return null;
    }
}

