/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.util;

import net.sf.samtools.SAMRecord;
import net.sf.samtools.util.SequenceUtil;
import net.sf.samtools.util.StringUtil;

public class ClippingUtility {
    public static final int MIN_MATCH_BASES = 12;
    public static final int MIN_MATCH_PE_BASES = 6;
    public static final double MAX_ERROR_RATE = 0.1;
    public static final double MAX_PE_ERROR_RATE = 0.1;
    public static final int NO_MATCH = -1;

    public static void adapterTrimIlluminaSingleRead(SAMRecord read, AdapterPair adapter) {
        ClippingUtility.adapterTrimIlluminaSingleRead(read, adapter, 12, 0.1);
    }

    public static void adapterTrimIlluminaSingleRead(SAMRecord read, AdapterPair adapter, int minMatchBases, double maxErrorRate) {
        byte[] bases = read.getReadBases();
        int indexOfAdapterSequence = ClippingUtility.findIndex(bases, read.getReadNegativeStrandFlag(), adapter.get3PrimeAdapterBytes(), minMatchBases, maxErrorRate);
        if (indexOfAdapterSequence != -1) {
            read.setAttribute("XT", (Object)(indexOfAdapterSequence + 1));
        }
    }

    public static String adapterTrimIlluminaPairedReads(SAMRecord read1, SAMRecord read2, AdapterPair adapters) {
        return ClippingUtility.adapterTrimIlluminaPairedReads(read1, read2, adapters, 6, 0.1);
    }

    public static String adapterTrimIlluminaPairedReads(SAMRecord read1, SAMRecord read2, AdapterPair adapters, int minMatchBases, double maxErrorRate) {
        byte[] bases2;
        int index2;
        String warnString = null;
        byte[] bases1 = read1.getReadBases();
        int index1 = ClippingUtility.findIndex(bases1, read1.getReadNegativeStrandFlag(), adapters.get3PrimeAdapterBytes(), minMatchBases, maxErrorRate);
        if (index1 == (index2 = ClippingUtility.findIndex(bases2 = read2.getReadBases(), read2.getReadNegativeStrandFlag(), adapters.get5PrimeAdapterBytesInReadOrder(), minMatchBases, maxErrorRate))) {
            if (index1 != -1) {
                read1.setAttribute("XT", (Object)(index1 + 1));
                read2.setAttribute("XT", (Object)(index2 + 1));
            }
        } else if (index1 == -1 || index2 == -1) {
            int stricterMinMatchBases = 2 * minMatchBases;
            warnString = ClippingUtility.oneSidedMatch(read1, read2, bases1, bases2, index1, index2, adapters, stricterMinMatchBases, maxErrorRate);
        } else {
            warnString = "Adapters mismatch at position " + index1 + " " + StringUtil.bytesToString((byte[])bases1) + " " + read1 + " and reverse " + index2 + " " + StringUtil.bytesToString((byte[])bases2);
        }
        return warnString;
    }

    private static int findIndex(byte[] bases, boolean isNegativeStrand, byte[] adapterBytes, int minMatchBases, double maxErrorRate) {
        byte[] copiedBases = null;
        if (isNegativeStrand) {
            copiedBases = new byte[bases.length];
            System.arraycopy(bases, 0, copiedBases, 0, bases.length);
            SequenceUtil.reverseComplement((byte[])copiedBases);
        } else {
            copiedBases = bases;
        }
        return ClippingUtility.findIndexOfClipSequence(copiedBases, adapterBytes, minMatchBases, maxErrorRate);
    }

    private static String oneSidedMatch(SAMRecord read1, SAMRecord read2, byte[] bases1, byte[] bases2, int index1, int index2, AdapterPair adapters, int stricterMinMatchBases, double maxErrorRate) {
        String willTrim = "won't";
        boolean needsRematch = true;
        boolean stillMatches = false;
        if (0.1 == maxErrorRate) {
            SAMRecord successfulRead;
            needsRematch = false;
            int successIndex = index1 == -1 ? index2 : index1;
            SAMRecord sAMRecord = successfulRead = index1 == -1 ? read2 : read1;
            if (successfulRead.getReadLength() - successIndex >= stricterMinMatchBases) {
                stillMatches = true;
            }
        }
        if (!needsRematch && !stillMatches || needsRematch && ClippingUtility.indexOfStrictMatchingBase(index1, bases1, bases2, adapters, stricterMinMatchBases) == -1) {
            willTrim = "will not";
        } else {
            int trimIndex;
            int n = trimIndex = index1 == -1 ? index2 : index1;
            if (bases1.length > trimIndex) {
                read1.setAttribute("XT", (Object)(trimIndex + 1));
                willTrim = "will only trim at position " + trimIndex;
            }
            if (bases2.length > trimIndex) {
                read2.setAttribute("XT", (Object)(trimIndex + 1));
                willTrim = "will trim at position " + trimIndex;
            }
        }
        String warnString = "No adapter match " + willTrim + " trim in paired read of length " + bases1.length + " and length " + bases2.length + " " + (index1 == -1 ? read2 + " " + StringUtil.bytesToString((byte[])bases2) : " reverse " + read1 + " " + StringUtil.bytesToString((byte[])bases1)) + " after strict check using minMaxBases=" + stricterMinMatchBases;
        return warnString;
    }

    private static int indexOfStrictMatchingBase(int index1, byte[] bases1, byte[] bases2, AdapterPair adapters, int stricterMinMatchBases) {
        byte[] adapterToCheck;
        byte[] basesToCheck;
        if (index1 == -1) {
            basesToCheck = bases2;
            adapterToCheck = adapters.get5PrimeAdapterBytesInReadOrder();
        } else {
            basesToCheck = bases1;
            adapterToCheck = adapters.get3PrimeAdapterBytesInReadOrder();
        }
        int newIndex = ClippingUtility.findIndexOfClipSequence(basesToCheck, adapterToCheck, stricterMinMatchBases, 0.1);
        return newIndex;
    }

    public static int findIndexOfClipSequence(byte[] read, byte[] toClip, int minMatch, double maxErrorRate) {
        if (read == null || read.length < minMatch) {
            return -1;
        }
        int minClipPosition = Math.max(0, read.length - toClip.length);
        block0: for (int start = read.length - minMatch; start > minClipPosition - 1; --start) {
            int length = Math.min(read.length - start, toClip.length);
            int mismatchesAllowed = (int)((double)length * maxErrorRate);
            int mismatches = 0;
            for (int i = 0; i < length; ++i) {
                if (!SequenceUtil.isNoCall((byte)toClip[i]) && !SequenceUtil.basesEqual((byte)toClip[i], (byte)read[start + i]) && ++mismatches > mismatchesAllowed) continue block0;
            }
            return start;
        }
        return -1;
    }

    public static class AdapterPair {
        final String fivePrime;
        final String threePrime;
        final String fivePrimeReadOrder;
        final byte[] fivePrimeBytes;
        final byte[] threePrimeBytes;
        final byte[] fivePrimeReadOrderBytes;

        public AdapterPair(String fivePrime, String threePrime) {
            this.threePrime = threePrime;
            this.fivePrime = fivePrime;
            this.fivePrimeReadOrder = SequenceUtil.reverseComplement((String)fivePrime);
            this.threePrimeBytes = StringUtil.stringToBytes((String)threePrime);
            this.fivePrimeBytes = StringUtil.stringToBytes((String)fivePrime);
            this.fivePrimeReadOrderBytes = StringUtil.stringToBytes((String)this.fivePrimeReadOrder);
        }

        public String get3PrimeAdapter() {
            return this.threePrime;
        }

        public String get5PrimeAdapter() {
            return this.fivePrime;
        }

        public String get3PrimeAdapterInReadOrder() {
            return this.threePrime;
        }

        public String get5PrimeAdapterInReadOrder() {
            return this.fivePrimeReadOrder;
        }

        public byte[] get3PrimeAdapterBytes() {
            return this.threePrimeBytes;
        }

        public byte[] get5PrimeAdapterBytes() {
            return this.fivePrimeBytes;
        }

        public byte[] get3PrimeAdapterBytesInReadOrder() {
            return this.threePrimeBytes;
        }

        public byte[] get5PrimeAdapterBytesInReadOrder() {
            return this.fivePrimeReadOrderBytes;
        }
    }
}

