/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.util;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.TreeMap;

public class Histogram<K extends Comparable>
extends TreeMap<K, Bin> {
    private String binLabel = "BIN";
    private String valueLabel = "VALUE";
    private Double mean;

    public Histogram() {
    }

    public Histogram(String binLabel, String valueLabel) {
        this.binLabel = binLabel;
        this.valueLabel = valueLabel;
    }

    public Histogram(Comparator<K> comparator) {
        super(comparator);
    }

    public Histogram(String binLabel, String valueLabel, Comparator<K> comparator) {
        this(comparator);
        this.binLabel = binLabel;
        this.valueLabel = valueLabel;
    }

    public Histogram(Histogram<K> in) {
        super(in);
        this.binLabel = in.binLabel;
        this.valueLabel = in.valueLabel;
        this.mean = in.mean;
    }

    public void prefillBins(K ... ids) {
        for (K id : ids) {
            this.put(id, new Bin(this, (Comparable)id));
        }
    }

    public void increment(K id) {
        this.increment(id, 1.0);
    }

    public void increment(K id, double increment) {
        Bin bin = (Bin)this.get(id);
        if (bin == null) {
            bin = new Bin(this, (Comparable)id);
            this.put(id, bin);
        }
        bin.value += increment;
        this.mean = null;
    }

    public String getBinLabel() {
        return this.binLabel;
    }

    public void setBinLabel(String binLabel) {
        this.binLabel = binLabel;
    }

    public String getValueLabel() {
        return this.valueLabel;
    }

    public void setValueLabel(String valueLabel) {
        this.valueLabel = valueLabel;
    }

    @Override
    public boolean equals(Object o) {
        return o != null && o instanceof Histogram && ((Histogram)o).binLabel.equals(this.binLabel) && ((Histogram)o).valueLabel.equals(this.valueLabel) && super.equals(o);
    }

    public double getMean() {
        if (this.mean == null) {
            this.mean = this.getSum() / this.getCount();
        }
        return this.mean;
    }

    public double getSum() {
        double total = 0.0;
        for (Bin bin : this.values()) {
            total += bin.getValue() * bin.getIdValue();
        }
        return total;
    }

    public double getSumOfValues() {
        double total = 0.0;
        for (Bin bin : this.values()) {
            total += bin.getValue();
        }
        return total;
    }

    public double getStandardDeviation() {
        double mean = this.getMean();
        double count = 0.0;
        double total = 0.0;
        for (Bin bin : this.values()) {
            double localCount = bin.getValue();
            double value = bin.getIdValue();
            count += localCount;
            total += localCount * Math.pow(value - mean, 2.0);
        }
        return Math.sqrt(total / (count - 1.0));
    }

    public double getPercentile(double percentile) {
        if (percentile <= 0.0) {
            throw new IllegalArgumentException("Cannot query percentiles of 0 or below");
        }
        if (percentile >= 1.0) {
            throw new IllegalArgumentException("Cannot query percentiles of 1 or above");
        }
        double total = this.getCount();
        double sofar = 0.0;
        for (Bin bin : this.values()) {
            if (!((sofar += bin.getValue()) / total >= percentile)) continue;
            return bin.getIdValue();
        }
        throw new IllegalStateException("Could not find percentile: " + percentile);
    }

    public double getCumulativeProbability(double v) {
        double count = 0.0;
        double total = 0.0;
        for (Bin bin : this.values()) {
            double binValue = bin.getIdValue();
            if (binValue <= v) {
                count += bin.getValue();
            }
            total += bin.getValue();
        }
        return count / total;
    }

    public double getMedian() {
        double total = 0.0;
        double halfCount = this.getCount() / 2.0;
        for (Bin bin : this.values()) {
            if (!((total += bin.getValue()) >= halfCount)) continue;
            return bin.getIdValue();
        }
        return 0.0;
    }

    public double getMode() {
        return this.getModeBin().getIdValue();
    }

    private Bin getModeBin() {
        Bin modeBin = null;
        for (Bin bin : this.values()) {
            if (modeBin != null && !(modeBin.value < bin.value)) continue;
            modeBin = bin;
        }
        return modeBin;
    }

    public double getMin() {
        return ((Bin)this.firstEntry().getValue()).getIdValue();
    }

    public double getMax() {
        return ((Bin)this.lastEntry().getValue()).getIdValue();
    }

    public double getCount() {
        double count = 0.0;
        for (Bin bin : this.values()) {
            count += bin.value;
        }
        return count;
    }

    public void trimByTailLimit(int tailLimit) {
        Object[] keys;
        if (this.isEmpty()) {
            return;
        }
        Bin modeBin = this.getModeBin();
        double mode = modeBin.getIdValue();
        double sizeOfModeBin = modeBin.getValue();
        double minimumBinSize = sizeOfModeBin / (double)tailLimit;
        Bin lastBin = null;
        ArrayList binsToKeep = new ArrayList();
        for (Bin bin : this.values()) {
            double binId = ((Number)bin.getId()).doubleValue();
            if (binId <= mode) {
                binsToKeep.add(bin.getId());
            } else {
                if (lastBin != null && ((Number)lastBin.getId()).doubleValue() != binId - 1.0 || bin.getValue() < minimumBinSize) break;
                binsToKeep.add(bin.getId());
            }
            lastBin = bin;
        }
        for (Object binId : keys = this.keySet().toArray()) {
            if (binsToKeep.contains((Comparable)binId)) continue;
            this.remove(binId);
        }
    }

    public void trimByWidth(int width) {
        Object[] keys;
        Bin bin;
        double binId;
        if (this.isEmpty()) {
            return;
        }
        ArrayList binsToKeep = new ArrayList();
        Iterator i$ = this.values().iterator();
        while (i$.hasNext() && (binId = ((Number)(bin = (Bin)i$.next()).getId()).doubleValue()) <= (double)width) {
            binsToKeep.add(bin.getId());
        }
        for (Object binId2 : keys = this.keySet().toArray()) {
            if (binsToKeep.contains((Comparable)binId2)) continue;
            this.remove(binId2);
        }
    }

    public static class Bin {
        private final K id;
        private double value = 0.0;
        final /* synthetic */ Histogram this$0;

        private Bin(K id) {
            this.this$0 = var1_1;
            this.id = id;
        }

        public K getId() {
            return this.id;
        }

        public double getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Bin bin = (Bin)o;
            if (Double.compare(bin.value, this.value) != 0) {
                return false;
            }
            return this.id.equals(bin.id);
        }

        public int hashCode() {
            int result = this.id.hashCode();
            long temp = this.value != 0.0 ? Double.doubleToLongBits(this.value) : 0L;
            result = 31 * result + (int)(temp ^ temp >>> 32);
            return result;
        }

        public double getIdValue() {
            if (this.id instanceof Number) {
                return ((Number)this.id).doubleValue();
            }
            throw new UnsupportedOperationException("getIdValue only supported for Histogram<? extends Number>");
        }
    }
}

