/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.util;

import java.math.BigDecimal;

public class MathUtil {
    public static double mean(double[] in, int start, int stop) {
        double total = 0.0;
        for (int i = start; i < stop; ++i) {
            total += in[i];
        }
        return total / (double)(stop - start);
    }

    public static double stddev(double[] in, int start, int length) {
        return MathUtil.stddev(in, start, length, MathUtil.mean(in, start, length));
    }

    public static double stddev(double[] in, int start, int stop, double mean) {
        double total = 0.0;
        for (int i = start; i < stop; ++i) {
            total += in[i] * in[i];
        }
        return Math.sqrt(total / (double)(stop - start) - mean * mean);
    }

    public static int compare(int v1, int v2) {
        return v1 < v2 ? -1 : (v1 == v2 ? 0 : 1);
    }

    public static double round(double num, int precision) {
        BigDecimal bd = new BigDecimal(num);
        bd = bd.setScale(precision, 4);
        return bd.doubleValue();
    }

    public static double max(double[] nums) {
        double max = nums[0];
        for (int i = 1; i < nums.length; ++i) {
            if (!(nums[i] > max)) continue;
            max = nums[i];
        }
        return max;
    }

    public static double min(double[] nums) {
        double min = nums[0];
        for (int i = 1; i < nums.length; ++i) {
            if (!(nums[i] < min)) continue;
            min = nums[i];
        }
        return min;
    }

    public static double[] logLikelihoodsToProbs(double[] likelihoods) {
        int i;
        double maxLikelihood = MathUtil.max(likelihoods);
        double bump = 300.0 - maxLikelihood;
        double[] tmp = new double[likelihoods.length];
        double total = 0.0;
        for (i = 0; i < likelihoods.length; ++i) {
            tmp[i] = Math.pow(10.0, likelihoods[i] + bump);
            total += tmp[i];
        }
        i = 0;
        while (i < likelihoods.length) {
            int n = i++;
            tmp[n] = tmp[n] / total;
        }
        return tmp;
    }
}

