/*
 * Decompiled with CFR 0.152.
 */
package bowtie;

import bowtie.chrInfo;
import bowtie.mini_INDEX;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Collections;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import loci.cmp_overlap_without_strand;
import loci.loci;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BWT_mini_index {
    String DNA = "acgt";
    String assembly;
    ArrayList<chrInfo> chrList = new ArrayList();
    BufferedWriter bw_FM_profile;
    mini_INDEX[] index;
    RandomAccessFile[] idx_randomAccessFile;
    String whole_chr_seq;

    public BWT_mini_index(String assembly1) throws IOException {
        this.assembly = assembly1;
        this.load_profile();
    }

    private void load_profile() throws FileNotFoundException, IOException {
        String line;
        this.chrList.clear();
        BufferedReader br = new BufferedReader(new FileReader(this.assembly + "/FM_profile.idx"), 0x400000);
        while ((line = br.readLine()) != null) {
            String chr = line;
            line = br.readLine();
            String[] strarray = line.split("\t");
            int len = Integer.parseInt(strarray[1]);
            line = br.readLine();
            strarray = line.split("\t");
            int[] nt_left_col_start = new int[]{Integer.parseInt(strarray[1]), Integer.parseInt(strarray[2]), Integer.parseInt(strarray[3]), Integer.parseInt(strarray[4])};
            line = br.readLine();
            strarray = line.split("\t");
            int dollar_row = Integer.parseInt(strarray[1]);
            line = br.readLine();
            strarray = line.split("\t");
            int FM_interval = Integer.parseInt(strarray[1]);
            int SA_interval = Integer.parseInt(strarray[2]);
            chrInfo ci = new chrInfo(chr, len, nt_left_col_start, dollar_row, FM_interval, SA_interval);
            line = br.readLine();
            strarray = line.split("\t");
            int numRegion = Integer.parseInt(strarray[1]);
            for (int i = 0; i < numRegion; ++i) {
                line = br.readLine();
                strarray = line.split("\t");
                ci.N_regions.add(new loci(chr, Integer.parseInt(strarray[0]), Integer.parseInt(strarray[1])));
            }
            this.chrList.add(ci);
        }
        this.index = new mini_INDEX[this.chrList.size()];
        this.idx_randomAccessFile = new RandomAccessFile[this.chrList.size()];
    }

    public void load_all_chrom() throws IOException {
        for (int chr_no = 0; chr_no < this.chrList.size(); ++chr_no) {
            this.load_chrom(this.chrList.get((int)chr_no).chr, false);
        }
    }

    public void load_chrom(String chr_name, boolean saveing_memory) throws IOException {
        int chr_no = this.chr_name2no(chr_name);
        if (chr_no == -1) {
            System.out.println("chrosome name does not exist");
            return;
        }
        if (saveing_memory) {
            for (int i = 0; i < this.chrList.size(); ++i) {
                this.index[i] = null;
            }
        }
        this.index[chr_no] = new mini_INDEX(this.chrList.get((int)chr_no).length, this.chrList.get((int)chr_no).SA_interval, this.chrList.get((int)chr_no).FM_interval);
        this.idx_randomAccessFile[chr_no] = new RandomAccessFile(new File(this.assembly + "/" + "bwt." + this.chrList.get((int)chr_no).chr + ".idx"), "rw");
        FileInputStream fis_SA = new FileInputStream(this.assembly + "/" + "SA." + this.chrList.get((int)chr_no).chr + ".idx");
        DataInputStream dis_SA = new DataInputStream(fis_SA);
        for (int i = 0; i < this.index[chr_no].SA.length; ++i) {
            this.index[chr_no].SA[i] = dis_SA.readInt();
        }
        dis_SA.close();
        FileInputStream fis_FM = new FileInputStream(this.assembly + "/" + "FM." + this.chrList.get((int)chr_no).chr + ".idx");
        DataInputStream dis_FM = new DataInputStream(fis_FM);
        for (int row_no = 0; row_no < this.index[chr_no].FM.length; ++row_no) {
            for (int col_no = 0; col_no < this.index[chr_no].FM[row_no].length; ++col_no) {
                this.index[chr_no].FM[row_no][col_no] = dis_FM.readInt();
            }
        }
        dis_FM.close();
    }

    private int chr_name2no(String chr_name) {
        for (int chr_no = 0; chr_no < this.chrList.size(); ++chr_no) {
            if (!this.chrList.get((int)chr_no).chr.equalsIgnoreCase(chr_name)) continue;
            return chr_no;
        }
        return -1;
    }

    private String byte2nt(byte b) {
        String result = Character.toString(this.DNA.charAt(b >> 6 & Byte.parseByte("00000011", 2)));
        result = result + Character.toString(this.DNA.charAt(b >> 4 & Byte.parseByte("00000011", 2)));
        result = result + Character.toString(this.DNA.charAt(b >> 2 & Byte.parseByte("00000011", 2)));
        result = result + Character.toString(this.DNA.charAt(b & Byte.parseByte("00000011", 2)));
        return result;
    }

    public String BWA_seq_chrom(String chr_name, String strand, int loci_start, int loci_stop) {
        String result = "";
        int chr_no = this.chr_name2no(chr_name);
        int[] nt_left_col_start = this.chrList.get(chr_no).get_nt_left_col_start();
        int min_dist = Integer.MAX_VALUE;
        int best_idx_row = -1;
        int loci_stop_extended = loci_stop;
        for (int i = 0; i < this.index[chr_no].SA.length; ++i) {
            int dist = this.index[chr_no].SA[i] - loci_stop;
            if (dist <= 0 || dist >= min_dist) continue;
            loci_stop_extended = this.index[chr_no].SA[i];
            best_idx_row = i * this.chrList.get((int)chr_no).SA_interval;
            min_dist = dist;
        }
        int current_row = best_idx_row;
        result = result + this.get_left_col_nt(chr_no, best_idx_row);
        while (result.length() <= loci_stop_extended - loci_start) {
            try {
                char left_extend_nt = this.get_right_col_NTs(chr_no, current_row, current_row + 1).charAt(0);
                current_row = nt_left_col_start[this.DNA.indexOf(left_extend_nt)] + this.getAccumulateNT(chr_no, current_row, left_extend_nt) - 1;
                result = left_extend_nt + result;
            }
            catch (IOException ex) {
                Logger.getLogger(BWT_mini_index.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        result = result.substring(0, loci_stop - loci_start + 1);
        if (strand.equals("+")) {
            return result;
        }
        return this.toMinusStrand(result);
    }

    private char get_left_col_nt(int chr_no, int left_col_no) {
        if (left_col_no < this.chrList.get((int)chr_no).nt_left_col_start[1]) {
            return 'a';
        }
        if (left_col_no < this.chrList.get((int)chr_no).nt_left_col_start[2]) {
            return 'c';
        }
        if (left_col_no < this.chrList.get((int)chr_no).nt_left_col_start[3]) {
            return 'g';
        }
        return 't';
    }

    public ArrayList<Integer> BWA_query_chrom(String chr_name, String query_str, int max_multipleMatching) throws IOException {
        query_str = query_str.toLowerCase();
        ArrayList<Integer> result = new ArrayList<Integer>();
        int chr_no = this.chr_name2no(chr_name);
        if (chr_no == -1) {
            System.out.println("chrosome name does not exist");
            return result;
        }
        if (this.index[chr_no] == null) {
            System.out.println("the chrom " + chr_name + " has not loaded");
            return result;
        }
        String[] query_both_strand = new String[]{query_str, this.toMinusStrand(query_str)};
        for (int strand_no = 0; strand_no < 2; ++strand_no) {
            int i;
            String query = query_both_strand[strand_no];
            int bot = 0;
            int top = this.chrList.get(chr_no).getLen();
            int[] nt_left_col_start = this.chrList.get(chr_no).get_nt_left_col_start();
            for (i = query.length() - 1; i >= 0 && top >= bot; --i) {
                System.out.print("i=" + i + "\n");
                if (i == 0) {
                    int debug = 9;
                }
                char now_nt = query.charAt(i);
                bot = nt_left_col_start[this.DNA.indexOf(now_nt)] + this.getAccumulateNT(chr_no, bot - 1, now_nt);
                top = nt_left_col_start[this.DNA.indexOf(now_nt)] + this.getAccumulateNT(chr_no, top, now_nt) - 1;
            }
            if (top - bot + 1 > max_multipleMatching) {
                result.clear();
                return result;
            }
            for (i = bot; i <= top; ++i) {
                int debug;
                int pos;
                int new_i = i;
                int num_extented_nt = 0;
                while (new_i % this.chrList.get((int)chr_no).SA_interval != 0 && new_i != this.chrList.get((int)chr_no).dollar_row) {
                    ++num_extented_nt;
                    char left_extend_nt = this.get_right_col_NTs(chr_no, new_i, new_i + 1).charAt(0);
                    new_i = nt_left_col_start[this.DNA.indexOf(left_extend_nt)] + this.getAccumulateNT(chr_no, new_i, left_extend_nt) - 1;
                }
                if (new_i == this.chrList.get((int)chr_no).dollar_row) {
                    pos = 1 + num_extented_nt;
                    if (!this.isOverlapN_region(chr_no, pos, pos + query.length() - 1)) {
                        System.out.print("strand_no=" + strand_no + ";pos=" + pos + "\n");
                        if (strand_no == 1) {
                            pos = -1 * pos;
                        }
                        result.add(pos);
                        continue;
                    }
                    debug = 9;
                    continue;
                }
                pos = this.index[chr_no].SA[(int)Math.floor((double)new_i / (double)this.chrList.get((int)chr_no).SA_interval)] + num_extented_nt;
                if (!this.isOverlapN_region(chr_no, pos, pos + query.length() - 1)) {
                    System.out.print("strand_no=" + strand_no + ";pos=" + pos + "\n");
                    if (strand_no == 1) {
                        pos = -1 * pos;
                    }
                    result.add(pos);
                    continue;
                }
                debug = 9;
            }
        }
        return result;
    }

    private boolean isOverlapN_region(int chr_no, int loci_start, int loci_stop) {
        return Collections.binarySearch(this.chrList.get((int)chr_no).N_regions, new loci(this.chrList.get(chr_no).getChr(), loci_start, loci_stop), new cmp_overlap_without_strand()) >= 0;
    }

    public TreeMap<String, ArrayList<Integer>> BWA_query(String query_str, int max_multipleMatching) throws IOException {
        TreeMap<String, ArrayList<Integer>> chr_result = new TreeMap<String, ArrayList<Integer>>();
        for (int chr_no = 0; chr_no < this.chrList.size(); ++chr_no) {
            chr_result.put(this.chrList.get((int)chr_no).chr, this.BWA_query_chrom(this.chrList.get(chr_no).getChr(), query_str, max_multipleMatching));
        }
        return chr_result;
    }

    private String get_right_col_NTs(int chr_no, int bwt_start, int bwt_stop) throws IOException {
        int adjusted_bwt_start = (int)Math.floor((double)bwt_start / 4.0) * 4;
        int left_trim_len = bwt_start - adjusted_bwt_start;
        if (left_trim_len < 0) {
            boolean debug = false;
        }
        int adjusted_bwt_stop = (int)Math.ceil((double)bwt_stop / 4.0) * 4;
        byte[] scanning_bwt = new byte[adjusted_bwt_stop / 4 - adjusted_bwt_start / 4];
        this.idx_randomAccessFile[chr_no].seek(adjusted_bwt_start / 4);
        this.idx_randomAccessFile[chr_no].read(scanning_bwt);
        String result = "";
        for (int i = 0; i < scanning_bwt.length; ++i) {
            result = result + this.byte2nt(scanning_bwt[i]);
        }
        int pos_dollar = this.chrList.get((int)chr_no).dollar_row - adjusted_bwt_start;
        if (pos_dollar >= 0 && pos_dollar < result.length()) {
            result = result.substring(0, pos_dollar) + "$" + result.substring(pos_dollar + 1);
        }
        result = result.substring(left_trim_len, left_trim_len + (bwt_stop - bwt_start));
        return result;
    }

    public int numNT_in_bwt_region(int chr_no, int bwt_start, int bwt_stop, char nt) throws IOException {
        int adjusted_bwt_start = (int)Math.floor((double)bwt_start / 4.0) * 4;
        int adjusted_bwt_stop = (int)Math.ceil((double)bwt_stop / 4.0) * 4;
        byte[] scanning_bwt = new byte[adjusted_bwt_stop / 4 - adjusted_bwt_start / 4];
        this.idx_randomAccessFile[chr_no].seek(adjusted_bwt_start / 4);
        this.idx_randomAccessFile[chr_no].read(scanning_bwt);
        byte nt_byte = (byte)this.DNA.indexOf(nt);
        int result = 0;
        int start_in_scanning_region = bwt_start - adjusted_bwt_start;
        int stop_in_scanning_region = bwt_stop - adjusted_bwt_start;
        int pos_dollar = this.chrList.get((int)chr_no).dollar_row - adjusted_bwt_start;
        if (scanning_bwt.length > 1) {
            byte current_byte;
            int i;
            int pos_byte = 0;
            int pos_bwt = start_in_scanning_region;
            for (i = start_in_scanning_region; i < 4; ++i) {
                if (pos_bwt != pos_dollar && (current_byte = (byte)(scanning_bwt[pos_byte] >> 2 * (3 - i) & 3)) == nt_byte) {
                    ++result;
                }
                ++pos_bwt;
            }
            for (pos_byte = 1; pos_byte < scanning_bwt.length - 1; ++pos_byte) {
                for (int j = 0; j < 4; ++j) {
                    if (pos_bwt != pos_dollar && (current_byte = (byte)(scanning_bwt[pos_byte] >> 2 * (3 - j) & 3)) == nt_byte) {
                        ++result;
                    }
                    ++pos_bwt;
                }
            }
            for (i = pos_bwt; i < stop_in_scanning_region; ++i) {
                if (pos_bwt != pos_dollar && (current_byte = (byte)(scanning_bwt[pos_byte] >> 2 * (3 - i % 4) & 3)) == nt_byte) {
                    ++result;
                }
                ++pos_bwt;
            }
        } else {
            for (int i = start_in_scanning_region; i < stop_in_scanning_region; ++i) {
                byte current_byte;
                if (i == pos_dollar || (current_byte = (byte)(scanning_bwt[0] >> 2 * (3 - i) & 3)) != nt_byte) continue;
                ++result;
            }
        }
        return result;
    }

    private int getAccumulateNT(int chr_no, int row_no, char nt) throws IOException {
        if (row_no == -1) {
            return 0;
        }
        int checkPoint_no_in_FM = (int)Math.floor((double)row_no / (double)this.chrList.get((int)chr_no).FM_interval);
        int checkPoint_no_in_BWT = checkPoint_no_in_FM * this.chrList.get((int)chr_no).FM_interval;
        int nt_in_gap = this.numNT_in_bwt_region(chr_no, checkPoint_no_in_BWT + 1, row_no + 1, nt);
        return this.index[chr_no].FM[checkPoint_no_in_FM][this.DNA.indexOf(nt)] + nt_in_gap;
    }

    private char get_nt(int chr_no, int bwt_no, int start_read_in_region_in_bwt, byte[] scanning_bwt) {
        if (this.chrList.get((int)chr_no).dollar_row == bwt_no) {
            return '$';
        }
        int offset = bwt_no - start_read_in_region_in_bwt;
        byte b = scanning_bwt[(int)Math.floor(offset / 4)];
        return this.DNA.charAt(b >> 2 * (3 - bwt_no % 4) & Byte.parseByte("00000011", 2));
    }

    public String toMinusStrand(String seq) {
        String reverse = new StringBuffer(seq).reverse().toString();
        return reverse.replace("c", "@").replace("g", "c").replace("@", "g").replace("a", "#").replace("t", "a").replace("#", "t");
    }

    public int numChr() {
        return this.chrList.size();
    }

    public chrInfo getChrInfo(int chr_no) {
        return this.chrList.get(chr_no);
    }
}

