/*
 * Decompiled with CFR 0.152.
 */
package bowtie;

import bowtie.INDEX;
import bowtie.chrInfo;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.TreeMap;
import loci.cmp_overlap_without_strand;
import loci.loci;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class bowtie_index {
    String DNA = "acgt";
    String assembly;
    ArrayList<chrInfo> chrList = new ArrayList();
    BufferedWriter bw_FM_profile;
    INDEX[] index;
    String whole_chr_seq;
    ArrayList<String> loaded_chrom = new ArrayList();

    public bowtie_index(String assembly1) throws IOException {
        this.assembly = assembly1;
        this.load_profile();
    }

    private void load_profile() throws FileNotFoundException, IOException {
        String line;
        this.chrList.clear();
        BufferedReader br = new BufferedReader(new FileReader(this.assembly + "/FM_profile.idx"), 0x400000);
        while ((line = br.readLine()) != null) {
            String chr = line;
            line = br.readLine();
            String[] strarray = line.split("\t");
            int len = Integer.parseInt(strarray[1]);
            line = br.readLine();
            strarray = line.split("\t");
            int[] nt_left_col_start = new int[]{Integer.parseInt(strarray[1]), Integer.parseInt(strarray[2]), Integer.parseInt(strarray[3]), Integer.parseInt(strarray[4])};
            line = br.readLine();
            strarray = line.split("\t");
            int dollar_row = Integer.parseInt(strarray[1]);
            line = br.readLine();
            strarray = line.split("\t");
            int FM_interval = Integer.parseInt(strarray[1]);
            int SA_interval = Integer.parseInt(strarray[2]);
            chrInfo ci = new chrInfo(chr, len, nt_left_col_start, dollar_row, FM_interval, SA_interval);
            line = br.readLine();
            strarray = line.split("\t");
            int numRegion = Integer.parseInt(strarray[1]);
            for (int i = 0; i < numRegion; ++i) {
                line = br.readLine();
                strarray = line.split("\t");
                ci.N_regions.add(new loci(chr, Integer.parseInt(strarray[0]), Integer.parseInt(strarray[1])));
            }
            this.chrList.add(ci);
        }
        this.index = new INDEX[this.chrList.size()];
    }

    public void load_all_chrom() throws IOException {
        this.loaded_chrom.clear();
        for (int chr_no = 0; chr_no < this.chrList.size(); ++chr_no) {
            this.load_chrom(this.chrList.get((int)chr_no).chr);
            this.loaded_chrom.add(this.chrList.get((int)chr_no).chr);
        }
    }

    public void load_one_chrom(String chr_name) throws IOException {
        if (this.loaded_chrom.indexOf(chr_name) > -1) {
            return;
        }
        for (int i = 0; i < this.chrList.size(); ++i) {
            this.index[i] = null;
        }
        this.loaded_chrom.clear();
        this.load_chrom(chr_name);
    }

    private void load_chrom(String chr_name) throws IOException {
        int chr_no = this.chr_name2no(chr_name);
        if (chr_no == -1) {
            System.out.println("chrosome name does not exist");
            return;
        }
        this.loaded_chrom.add(chr_name);
        this.index[chr_no] = new INDEX(this.chrList.get((int)chr_no).length, this.chrList.get((int)chr_no).SA_interval, this.chrList.get((int)chr_no).FM_interval);
        FileInputStream fis_bwt = new FileInputStream(this.assembly + "/" + "bwt." + this.chrList.get((int)chr_no).chr + ".idx");
        DataInputStream dis_bwt = new DataInputStream(fis_bwt);
        for (int i = 0; i < this.index[chr_no].bwt.length; ++i) {
            this.index[chr_no].bwt[i] = dis_bwt.readByte();
        }
        dis_bwt.close();
        FileInputStream fis_SA = new FileInputStream(this.assembly + "/" + "SA." + this.chrList.get((int)chr_no).chr + ".idx");
        DataInputStream dis_SA = new DataInputStream(fis_SA);
        for (int i = 0; i < this.index[chr_no].SA.length; ++i) {
            int left_col_no;
            this.index[chr_no].SA[i] = left_col_no = dis_SA.readInt();
        }
        dis_SA.close();
        FileInputStream fis_FM = new FileInputStream(this.assembly + "/" + "FM." + this.chrList.get((int)chr_no).chr + ".idx");
        DataInputStream dis_FM = new DataInputStream(fis_FM);
        for (int row_no = 0; row_no < this.index[chr_no].FM.length; ++row_no) {
            for (int col_no = 0; col_no < this.index[chr_no].FM[row_no].length; ++col_no) {
                this.index[chr_no].FM[row_no][col_no] = dis_FM.readInt();
            }
        }
        dis_FM.close();
    }

    public String BWA_seq_chrom(String chr_name, String strand, int loci_start, int loci_stop) throws IOException {
        this.load_one_chrom(chr_name);
        String result = "";
        int chr_no = this.chr_name2no(chr_name);
        int[] nt_left_col_start = this.chrList.get(chr_no).get_nt_left_col_start();
        int min_dist = Integer.MAX_VALUE;
        int best_idx_row = -1;
        int loci_stop_extended = loci_stop;
        for (int i = 0; i < this.index[chr_no].SA.length; ++i) {
            int dist = this.index[chr_no].SA[i] - loci_stop;
            if (dist <= 0 || dist >= min_dist) continue;
            loci_stop_extended = this.index[chr_no].SA[i];
            best_idx_row = i * this.chrList.get((int)chr_no).SA_interval;
            min_dist = dist;
        }
        int current_row = best_idx_row;
        result = result + this.get_left_col_nt(chr_no, best_idx_row);
        while (result.length() <= loci_stop_extended - loci_start) {
            char left_extend_nt = this.get_right_col_nt(chr_no, current_row);
            current_row = nt_left_col_start[this.DNA.indexOf(left_extend_nt)] + this.getAccumulateNT(chr_no, current_row, left_extend_nt) - 1;
            result = left_extend_nt + result;
        }
        if (strand.equals("-")) {
            return this.toMinusStrand(result.substring(0, loci_stop - loci_start + 1));
        }
        return result.substring(0, loci_stop - loci_start + 1);
    }

    private char get_left_col_nt(int chr_no, int left_col_no) {
        if (left_col_no < this.chrList.get((int)chr_no).nt_left_col_start[1]) {
            return 'a';
        }
        if (left_col_no < this.chrList.get((int)chr_no).nt_left_col_start[2]) {
            return 'c';
        }
        if (left_col_no < this.chrList.get((int)chr_no).nt_left_col_start[3]) {
            return 'g';
        }
        return 't';
    }

    public ArrayList<Integer> BWA_query_chrom(String chr_name, String query_str, int max_multipleMatching) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        int chr_no = this.chr_name2no(chr_name);
        if (chr_no == -1) {
            System.out.println("chrosome name does not exist");
            return result;
        }
        if (this.index[chr_no] == null) {
            System.out.println("the chrom " + chr_name + " has not loaded");
            return result;
        }
        query_str = query_str.toLowerCase();
        String[] query_both_strand = new String[]{query_str, this.toMinusStrand(query_str)};
        for (int strand_no = 0; strand_no < 2; ++strand_no) {
            int i;
            String query = query_both_strand[strand_no];
            int bot = 0;
            int top = this.chrList.get(chr_no).getLen();
            int[] nt_left_col_start = this.chrList.get(chr_no).get_nt_left_col_start();
            for (i = query.length() - 1; i >= 0 && top >= bot; --i) {
                char now_nt = query.charAt(i);
                bot = nt_left_col_start[this.DNA.indexOf(now_nt)] + this.getAccumulateNT(chr_no, bot - 1, now_nt);
                top = nt_left_col_start[this.DNA.indexOf(now_nt)] + this.getAccumulateNT(chr_no, top, now_nt) - 1;
            }
            if (top - bot + 1 > max_multipleMatching) {
                result.clear();
                return result;
            }
            for (i = bot; i <= top; ++i) {
                int debug;
                int pos;
                int new_i = i;
                int num_extented_nt = 0;
                while (new_i % this.chrList.get((int)chr_no).SA_interval != 0 && new_i != this.chrList.get((int)chr_no).dollar_row) {
                    ++num_extented_nt;
                    char left_extend_nt = this.get_right_col_NTs(chr_no, new_i, new_i + 1).charAt(0);
                    new_i = nt_left_col_start[this.DNA.indexOf(left_extend_nt)] + this.getAccumulateNT(chr_no, new_i, left_extend_nt) - 1;
                }
                if (new_i == this.chrList.get((int)chr_no).dollar_row) {
                    pos = 1 + num_extented_nt;
                    if (!this.isOverlapN_region(chr_no, pos, pos + query.length() - 1)) {
                        if (strand_no == 1) {
                            pos = -1 * pos;
                        }
                        result.add(pos);
                        continue;
                    }
                    debug = 9;
                    continue;
                }
                pos = this.index[chr_no].SA[(int)Math.floor((double)new_i / (double)this.chrList.get((int)chr_no).SA_interval)] + num_extented_nt;
                if (!this.isOverlapN_region(chr_no, pos, pos + query.length() - 1)) {
                    if (strand_no == 1) {
                        pos = -1 * pos;
                    }
                    result.add(pos);
                    continue;
                }
                debug = 9;
            }
        }
        return result;
    }

    private boolean isOverlapN_region(int chr_no, int loci_start, int loci_stop) {
        return Collections.binarySearch(this.chrList.get((int)chr_no).N_regions, new loci(this.chrList.get(chr_no).getChr(), loci_start, loci_stop), new cmp_overlap_without_strand()) >= 0;
    }

    public TreeMap<String, ArrayList<Integer>> BWA_query(String query_str, int max_multipleMatching) {
        TreeMap<String, ArrayList<Integer>> chr_result = new TreeMap<String, ArrayList<Integer>>();
        for (int chr_no = 0; chr_no < this.chrList.size(); ++chr_no) {
            chr_result.put(this.chrList.get((int)chr_no).chr, this.BWA_query_chrom(this.chrList.get(chr_no).getChr(), query_str, max_multipleMatching));
        }
        return chr_result;
    }

    private int getAccumulateNT(int chr_no, int row_no, char nt) {
        if (row_no == -1) {
            return 0;
        }
        int checkPoint_no_in_FM = (int)Math.floor((double)row_no / (double)this.chrList.get((int)chr_no).FM_interval);
        int checkPoint_no_in_BWT = checkPoint_no_in_FM * this.chrList.get((int)chr_no).FM_interval;
        int nt_in_gap = this.numNT_in_bwt_region(chr_no, checkPoint_no_in_BWT + 1, row_no + 1, nt);
        return this.index[chr_no].FM[checkPoint_no_in_FM][this.DNA.indexOf(nt)] + nt_in_gap;
    }

    int numNT_in_bwt_region(int chr_no, int bwt_start, int bwt_stop, char nt) {
        int nt_in_gap = 0;
        for (int i = bwt_start; i < bwt_stop; ++i) {
            if (nt != this.get_right_col_nt(chr_no, i)) continue;
            ++nt_in_gap;
        }
        return nt_in_gap;
    }

    private String get_right_col_NTs(int chr_no, int bwt_start, int bwt_stop) {
        String result = "";
        int adjusted_bwt_start = (int)Math.floor((double)bwt_start / 4.0) * 4;
        int left_trim_len = bwt_start - adjusted_bwt_start;
        int adjusted_bwt_stop = (int)Math.ceil((double)bwt_stop / 4.0) * 4;
        for (int i = adjusted_bwt_start / 4; i < adjusted_bwt_stop / 4; ++i) {
            result = result + this.byte2nt(this.index[chr_no].bwt[i]);
        }
        int pos_dollar = this.chrList.get((int)chr_no).dollar_row - adjusted_bwt_start;
        if (pos_dollar >= 0 && pos_dollar < result.length()) {
            result = result.substring(0, pos_dollar) + "$" + result.substring(pos_dollar + 1);
        }
        result = result.substring(left_trim_len, left_trim_len + (bwt_stop - bwt_start));
        return result;
    }

    private String byte2nt(byte b) {
        String result = Character.toString(this.DNA.charAt(b >> 6 & Byte.parseByte("00000011", 2)));
        result = result + Character.toString(this.DNA.charAt(b >> 4 & Byte.parseByte("00000011", 2)));
        result = result + Character.toString(this.DNA.charAt(b >> 2 & Byte.parseByte("00000011", 2)));
        result = result + Character.toString(this.DNA.charAt(b & Byte.parseByte("00000011", 2)));
        return result;
    }

    private char get_right_col_nt(int chr_no, int bwt_no) {
        if (this.chrList.get((int)chr_no).dollar_row == bwt_no) {
            return '$';
        }
        byte b = this.index[chr_no].bwt[(int)Math.floor(bwt_no / 4)];
        return this.DNA.charAt(b >> 2 * (3 - bwt_no % 4) & Byte.parseByte("00000011", 2));
    }

    public String toMinusStrand(String seq) {
        String reverse = new StringBuffer(seq).reverse().toString();
        return reverse.replace("c", "@").replace("g", "c").replace("@", "g").replace("a", "#").replace("t", "a").replace("#", "t");
    }

    public int numChr() {
        return this.chrList.size();
    }

    public chrInfo getChrInfo(int chr_no) {
        return this.chrList.get(chr_no);
    }

    private int chr_name2no(String chr_name) {
        for (int chr_no = 0; chr_no < this.chrList.size(); ++chr_no) {
            if (!this.chrList.get((int)chr_no).chr.equalsIgnoreCase(chr_name)) continue;
            return chr_no;
        }
        return -1;
    }
}

