/*
 * Decompiled with CFR 0.152.
 */
package bowtie;

import bowtie.INDEX;
import bowtie.bwt_str;
import bowtie.chrInfo;
import bowtie.chr_comp;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Random;
import loci.loci;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class create_BWT_Index {
    String DNA = "acgt";
    String assembly;
    ArrayList<chrInfo> chrList = new ArrayList();
    BufferedWriter bw_FM_profile;
    INDEX[] index;
    StringBuilder whole_chr_seq;
    int SA_interval = 3;
    int FM_interval = 3;

    public create_BWT_Index(String assembly1, int FM_interval1, int SA_interval1) {
        this.assembly = assembly1;
        this.FM_interval = FM_interval1;
        this.SA_interval = SA_interval1;
    }

    public void createIdx() throws IOException {
        File assembly_directory = new File(this.assembly);
        this.bw_FM_profile = new BufferedWriter(new FileWriter(this.assembly + "/" + "FM_profile.idx"));
        String[] files = assembly_directory.list();
        this.chrList.clear();
        for (int i = 0; i < files.length; ++i) {
            if (files[i].endsWith("fa")) {
                this.chrList.add(new chrInfo(files[i].replace(".fa", "")));
            }
            if (!files[i].endsWith("fasta")) continue;
            this.chrList.add(new chrInfo(files[i].replace(".fasta", "")));
        }
        Collections.sort(this.chrList, new chr_comp());
        try {
            for (int chr_no = 0; chr_no < this.chrList.size(); ++chr_no) {
                chrInfo chr_info = this.chrList.get(chr_no);
                chr_info.N_regions = this.create_index_tmp_files(chr_info);
                this.write_index(chr_info);
            }
            this.bw_FM_profile.close();
        }
        catch (IOException ex) {
            System.out.println(ex.toString());
        }
    }

    StringBuilder getseq(String chr_name) throws FileNotFoundException, IOException {
        BufferedReader br = new BufferedReader(new FileReader(this.assembly + "/" + chr_name + ".fa"));
        String line = br.readLine();
        StringBuilder result = new StringBuilder();
        while ((line = br.readLine()) != null) {
            result.append(line);
        }
        return result;
    }

    private ArrayList<loci> create_index_tmp_files(chrInfo chr_info) throws FileNotFoundException, IOException {
        ArrayList<loci> N_regions = new ArrayList<loci>();
        System.out.println(chr_info.getChr());
        this.whole_chr_seq = this.getseq(chr_info.getChr());
        chr_info.length = this.whole_chr_seq.length();
        this.whole_chr_seq.append('$');
        bwt_str[] bwt = new bwt_str[chr_info.length + 1];
        bwt[0] = new bwt_str(1, '$');
        int N_start = -1;
        Random random_generator = new Random();
        for (int i = 1; i < chr_info.length + 1; ++i) {
            int current_last = i - 1;
            char now_nt = this.whole_chr_seq.charAt(i - 1);
            if ((now_nt = Character.toLowerCase(now_nt)) == 'n') {
                if (N_start == -1) {
                    N_start = i;
                }
                int random_nt = (int)Math.floor(random_generator.nextDouble() * 4.0);
                now_nt = this.DNA.charAt(random_nt);
            } else if (N_start != -1) {
                N_regions.add(new loci(chr_info.getChr(), N_start, i));
                N_start = -1;
            }
            this.whole_chr_seq.setCharAt(i - 1, now_nt);
            bwt[current_last + 1] = new bwt_str(i + 1, this.whole_chr_seq.charAt(i - 1));
        }
        Arrays.sort(bwt, new bwt_cmp());
        BufferedWriter bw = new BufferedWriter(new FileWriter(this.assembly + "/" + chr_info.chr + ".media_tmp"));
        for (int j = 0; j < chr_info.length + 1; ++j) {
            bw.write(bwt[j].no + "\t" + this.whole_chr_seq.substring(bwt[j].no - 1, bwt[j].no) + "\t" + bwt[j].nt + "\n");
        }
        bw.close();
        return N_regions;
    }

    private void write_FM_profile(chrInfo chr_info) throws IOException {
        int[] nt_left_col_start = chr_info.get_nt_left_col_start();
        chr_info.setLen(nt_left_col_start[0] + nt_left_col_start[1] + nt_left_col_start[2] + nt_left_col_start[3]);
        this.bw_FM_profile.write(chr_info.getChr() + "\n");
        this.bw_FM_profile.write("numRow\t" + chr_info.getLen() + "\n");
        this.bw_FM_profile.write("ACGT_startPos\t1");
        this.bw_FM_profile.write("\t" + Integer.toString(nt_left_col_start[0] + 1));
        this.bw_FM_profile.write("\t" + Integer.toString(nt_left_col_start[0] + nt_left_col_start[1] + 1));
        this.bw_FM_profile.write("\t" + Integer.toString(nt_left_col_start[0] + nt_left_col_start[1] + nt_left_col_start[2] + 1) + "\n");
        this.bw_FM_profile.write("noOfRowOf$\t" + chr_info.dollar_row + "\n");
        this.bw_FM_profile.write("interval\t" + this.FM_interval + "\t" + this.SA_interval + "\n");
        this.bw_FM_profile.write("N_region\t" + chr_info.N_regions.size() + "\n");
        for (loci nr : chr_info.N_regions) {
            this.bw_FM_profile.write(nr.getstart_loci() + "\t" + nr.getstop_loci() + "\n");
        }
    }

    private void write_index(chrInfo chr_info) throws FileNotFoundException, IOException {
        String line;
        FileOutputStream fos_bwt = new FileOutputStream(this.assembly + "/" + "bwt." + chr_info.chr + ".idx");
        DataOutputStream dos_bwt = new DataOutputStream(fos_bwt);
        FileOutputStream fos_SA = new FileOutputStream(this.assembly + "/" + "SA." + chr_info.chr + ".idx");
        DataOutputStream dos_SA = new DataOutputStream(fos_SA);
        FileOutputStream fos_FM = new FileOutputStream(this.assembly + "/" + "FM." + chr_info.chr + ".idx");
        DataOutputStream dos_FM = new DataOutputStream(fos_FM);
        BufferedReader br = new BufferedReader(new FileReader(this.assembly + "/" + chr_info.chr + ".media_tmp"));
        int[] accumulated_nt = new int[4];
        int b = 0;
        int rec_no = 0;
        while ((line = br.readLine()) != null) {
            String[] strarray = line.split("\t");
            char now_nt = strarray[2].charAt(0);
            if (now_nt == '$') {
                chr_info.dollar_row = rec_no;
                now_nt = 'c';
            } else {
                int n = this.DNA.indexOf(now_nt);
                chr_info.nt_left_col_start[n] = chr_info.nt_left_col_start[n] + 1;
                int n2 = this.DNA.indexOf(now_nt);
                accumulated_nt[n2] = accumulated_nt[n2] + 1;
            }
            if (rec_no % this.SA_interval == 0) {
                dos_SA.writeInt(Integer.parseInt(strarray[0]));
            }
            if (rec_no % this.FM_interval == 0) {
                dos_FM.writeInt(accumulated_nt[0]);
                dos_FM.writeInt(accumulated_nt[1]);
                dos_FM.writeInt(accumulated_nt[2]);
                dos_FM.writeInt(accumulated_nt[3]);
            }
            b = (byte)(b << 2 | this.nt2bit(now_nt));
            if ((rec_no + 1) % 4 == 0) {
                dos_bwt.writeByte(b);
                b = 0;
            }
            ++rec_no;
        }
        if (rec_no % 4 != 0) {
            b = (byte)(b << 2 * (4 - rec_no % 4));
            dos_bwt.writeByte(b);
        }
        br.close();
        File tmp_file = new File(this.assembly + "/" + chr_info.chr + ".media_tmp");
        dos_bwt.writeByte(b);
        dos_bwt.close();
        dos_SA.close();
        dos_FM.close();
        this.write_FM_profile(chr_info);
    }

    private byte nt2bit(char nt) {
        return (byte)this.DNA.indexOf(nt);
    }

    private String byte2nt(byte b) {
        String result = Character.toString(this.DNA.charAt(b >> 6 & Byte.parseByte("00000011", 2)));
        result = result + Character.toString(this.DNA.charAt(b >> 4 & Byte.parseByte("00000011", 2)));
        result = result + Character.toString(this.DNA.charAt(b >> 2 & Byte.parseByte("00000011", 2)));
        result = result + Character.toString(this.DNA.charAt(b & Byte.parseByte("00000011", 2)));
        return result;
    }

    private char get_nt(int chr_no, int bwt_no) {
        if (this.chrList.get((int)chr_no).dollar_row == bwt_no) {
            return '$';
        }
        byte b = this.index[chr_no].bwt[(int)Math.floor(bwt_no / 4)];
        return this.DNA.charAt(b >> 2 * (3 - bwt_no % 4) & Byte.parseByte("00000011", 2));
    }

    class bwt_cmp
    implements Comparator {
        bwt_cmp() {
        }

        public int compare(Object o1, Object o2) {
            bwt_str bwt1 = (bwt_str)o1;
            bwt_str bwt2 = (bwt_str)o2;
            int i1 = bwt1.no - 1;
            int i2 = bwt2.no - 1;
            while (create_BWT_Index.this.whole_chr_seq.charAt(i1) == create_BWT_Index.this.whole_chr_seq.charAt(i2)) {
                ++i1;
                ++i2;
            }
            return create_BWT_Index.this.whole_chr_seq.charAt(i1) - create_BWT_Index.this.whole_chr_seq.charAt(i2);
        }
    }
}

