/*
 * Decompiled with CFR 0.152.
 */
package genomeSearch;

import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;

public class genomeSearch {
    public static String getSubseq(String chr, String strand, int query_start, int query_stop) throws FileNotFoundException, IOException {
        int bytes_read;
        byte[] buffer;
        String result = "";
        FileInputStream fis = new FileInputStream("hg18/" + chr + ".binary");
        DataInputStream dis = new DataInputStream(fis);
        int start = dis.readInt();
        int stop = dis.readInt();
        int offset_stop = (int)Math.floor((double)(stop - start) / 4.0) + 1;
        while (query_start > stop) {
            dis.skip(offset_stop);
            start = dis.readInt();
            stop = dis.readInt();
            offset_stop = (int)Math.floor((double)(stop - start) / 4.0) + 1;
        }
        if (query_start < start) {
            if (query_stop < start) {
                for (int i = query_start; i < query_stop + 1; ++i) {
                    result = result + "n";
                }
                return result;
            }
            for (int i = query_start; i < start; ++i) {
                result = result + "n";
            }
            query_start = start;
        }
        int offset_query_start = (int)Math.floor((double)(query_start - start) / 4.0) + 1;
        int offset_query_stop = (int)Math.floor((double)(query_stop - start) / 4.0) + 1;
        dis.skip(offset_query_start - 1);
        while (stop < query_stop) {
            buffer = new byte[offset_stop - offset_query_start + 1];
            bytes_read = dis.read(buffer, 0, offset_stop - offset_query_start + 1);
            String to_Stop = genomeSearch.byte_to_DNA(buffer, query_start - start - (offset_query_start - 1) * 4, stop - start - (offset_query_start - 1) * 4);
            result = result + to_Stop;
            start = dis.readInt();
            int previous_stop = stop;
            stop = dis.readInt();
            for (int i = previous_stop + 1; i <= Math.min(query_stop, start - 1); ++i) {
                result = result + "n";
            }
            query_start = start;
            offset_query_start = (int)Math.floor((double)(query_start - start) / 4.0) + 1;
            offset_stop = (int)Math.floor((double)(stop - start) / 4.0) + 1;
            offset_query_stop = (int)Math.floor((double)(query_stop - start) / 4.0) + 1;
        }
        int read_blocks = offset_query_stop - offset_query_start + 1;
        if (read_blocks > 0) {
            buffer = new byte[read_blocks];
            bytes_read = dis.read(buffer, 0, read_blocks);
            String to_Stop = genomeSearch.byte_to_DNA(buffer, query_start - start - (offset_query_start - 1) * 4, query_stop - start - (offset_query_start - 1) * 4);
            result = result + to_Stop;
        }
        dis.close();
        if (strand.equals("-")) {
            String reverse = new StringBuffer(result).reverse().toString();
            result = reverse.replace("c", "@").replace("g", "c").replace("@", "g").replace("a", "#").replace("t", "a").replace("#", "t");
        }
        return result;
    }

    static String byte_to_DNA(byte[] bytes, int offset_start, int offset_stop) {
        String result = "";
        for (int i = 0; i < bytes.length; ++i) {
            String byte_str = genomeSearch.byte2Str(bytes[i]);
            for (int j = 0; j < 8; j += 2) {
                if (byte_str.substring(j, j + 2).equals("00")) {
                    result = result + "a";
                    continue;
                }
                if (byte_str.substring(j, j + 2).equals("01")) {
                    result = result + "c";
                    continue;
                }
                if (byte_str.substring(j, j + 2).equals("10")) {
                    result = result + "g";
                    continue;
                }
                if (!byte_str.substring(j, j + 2).equals("11")) continue;
                result = result + "t";
            }
            if (result.length() > offset_stop) break;
        }
        return result.substring(offset_start, Math.min(result.length(), offset_stop + 1));
    }

    static String byte2Str(byte myb) {
        String result = "";
        for (int i = 0; i < 8; ++i) {
            result = (myb & 0x80) == 0 ? result + "0" : result + "1";
            myb = (byte)(myb << 1);
        }
        return result;
    }

    public static void write_byte(String chr) throws FileNotFoundException, IOException {
        BufferedReader br = new BufferedReader(new FileReader("hg18/" + chr + ".fa"), 0x400000);
        FileOutputStream fos = new FileOutputStream("hg18/" + chr + ".binary");
        DataOutputStream dos = new DataOutputStream(fos);
        int start = 1;
        String line = br.readLine();
        StringBuilder seq = new StringBuilder();
        while ((line = br.readLine()) != null) {
            int N_start = (line = line.toLowerCase()).indexOf(110);
            if (N_start < 0) {
                seq.append(line);
                continue;
            }
            for (int line_no = 0; line_no < line.length(); ++line_no) {
                if (line.charAt(line_no) != 'n') {
                    seq.append(line.charAt(line_no));
                    continue;
                }
                if (seq.length() > 0) {
                    genomeSearch.seq_write(start, seq, dos);
                    start += seq.length();
                    seq.setLength(0);
                }
                ++start;
            }
        }
        genomeSearch.seq_write(start, seq, dos);
        dos.writeInt(Integer.MAX_VALUE);
        dos.writeInt(0x7FFFFFFE);
        dos.close();
        br.close();
    }

    private static void seq_write(int start, StringBuilder seq, DataOutputStream dos) throws IOException {
        int stop = start + seq.length() - 1;
        dos.writeInt(start);
        dos.writeInt(stop);
        String byte_string = "";
        for (int i = 0; i < seq.length(); ++i) {
            if (seq.charAt(i) == 'a') {
                byte_string = byte_string + "00";
            } else if (seq.charAt(i) == 'c') {
                byte_string = byte_string + "01";
            } else if (seq.charAt(i) == 'g') {
                byte_string = byte_string + "10";
            } else if (seq.charAt(i) == 't') {
                byte_string = byte_string + "11";
            } else {
                System.out.println("ERROR\n");
            }
            if (byte_string.length() != 8) continue;
            dos.write((byte)Short.parseShort(byte_string, 2));
            byte_string = "";
        }
        if (byte_string.length() > 0) {
            while (byte_string.length() < 8) {
                byte_string = byte_string + "11";
            }
            dos.write((byte)Short.parseShort(byte_string, 2));
        }
    }
}

