/*
 * Decompiled with CFR 0.152.
 */
package RNAfold;

import RNAfold.bond;
import RNAfold.energy_para;
import RNAfold.int11;
import RNAfold.int21;
import RNAfold.int22;
import RNAfold.sect;

public class RNAfold {
    private String RNA;
    private int length;
    private String struct;
    private double MFE;
    private int[][] C;
    private int[][] FM;
    private int[][] DML;
    private int[] f5;
    private sect[] sector = new sect[50];
    int[] BP;
    char backtrack_type = (char)70;
    bond[] base_pair;
    int22 int22;
    static int[] rtype = new int[]{0, 2, 1, 4, 3, 6, 5, 7};
    private int bt_i;
    private int bt_j;
    private int bt_b = 0;
    private int bt_s = 0;

    public RNAfold(String RNA_string) {
        int j;
        this.RNA = RNA_string.toUpperCase().replace("T", "U");
        this.int22 = new int22();
        this.length = this.RNA.length();
        this.C = new int[this.length + 1][this.length + 1];
        this.FM = new int[this.length + 1][this.length + 1];
        this.DML = new int[this.length + 1][this.length + 1];
        this.BP = new int[this.length + 2];
        this.base_pair = new bond[1 + this.length / 2];
        for (int i = 0; i < this.length + 1; ++i) {
            for (j = 0; j < this.length + 1; ++j) {
                this.C[i][j] = 100000;
                this.FM[i][j] = 100000;
                this.DML[i][j] = 100000;
            }
        }
        int stackEnergy = 100000;
        this.RNA = "X" + this.RNA;
        for (int i = this.length - 3 - 1; i >= 1; --i) {
            for (int j2 = i + 3 + 1; j2 <= this.length; ++j2) {
                int tt;
                char char_j;
                if (i == 5 && j2 == 26) {
                    int jj = 99;
                }
                this.C[i][j2] = 100000;
                char char_i = this.RNA.charAt(i);
                int pairType = this.pairType(char_i, char_j = this.RNA.charAt(j2));
                if (pairType > 0) {
                    int temp;
                    this.C[i][j2] = this.HairpinE(pairType, i, j2, this.RNA);
                    for (int p = i + 1; p <= Math.min(j2 - 2 - 3, i + 30 + 1); ++p) {
                        for (int q = Math.max(j2 - i + p - 30 - 2, p + 1 + 3); q < j2; ++q) {
                            int pairType2;
                            if (p == 8 && q == 23) {
                                int debug = 99;
                            }
                            if ((pairType2 = this.pairType(this.RNA.charAt(p), this.RNA.charAt(q))) == 0) continue;
                            pairType2 = this.pairType(this.RNA.charAt(q), this.RNA.charAt(p));
                            int energy = this.LoopEnergy(p - i - 1, j2 - q - 1, pairType, pairType2, this.RNAType(this.RNA.charAt(i + 1)), this.RNAType(this.RNA.charAt(j2 - 1)), this.RNAType(this.RNA.charAt(p - 1)), this.RNAType(this.RNA.charAt(q + 1)));
                            temp = this.C[i][j2];
                            this.C[i][j2] = Math.min(this.C[i][j2], energy + this.C[p][q]);
                            if (temp > this.C[i][j2]) {
                                // empty if block
                            }
                            if (p != i + 1 || q != j2 - 1) continue;
                            stackEnergy = energy;
                        }
                    }
                    int decomp = this.DML[i + 1][j2 - 1];
                    tt = this.pairType(this.RNA.charAt(j2), this.RNA.charAt(i));
                    int d3 = energy_para.dangle3_37[tt][this.RNAType(this.RNA.charAt(i + 1))];
                    int d5 = energy_para.dangle5_37[tt][this.RNAType(this.RNA.charAt(j2 - 1))];
                    temp = decomp;
                    temp = decomp = Math.min(decomp, this.DML[i + 2][j2 - 1] + d3 + energy_para.ML_BASE37);
                    temp = decomp = Math.min(decomp, this.DML[i + 1][j2 - 2] + d5 + energy_para.ML_BASE37);
                    decomp = Math.min(decomp, this.DML[i + 2][j2 - 2] + d5 + d3 + 2 * energy_para.ML_BASE37);
                    int MLenergy = energy_para.ML_closing37 + energy_para.ML_intern37[pairType] + decomp;
                    this.C[i][j2] = Math.min(this.C[i][j2], MLenergy);
                    this.C[i][j2] = Math.min(this.C[i][j2], this.C[i + 1][j2 - 1] + stackEnergy);
                } else {
                    this.C[i][j2] = 100000;
                }
                this.FM[i][j2] = this.FM[i + 1][j2] + energy_para.ML_BASE37;
                this.FM[i][j2] = Math.min(this.FM[i][j2], this.FM[i][j2 - 1] + energy_para.ML_BASE37);
                int energy = this.C[i][j2] + energy_para.ML_intern37[pairType];
                this.FM[i][j2] = Math.min(this.FM[i][j2], energy);
                tt = this.pairType(this.RNA.charAt(i + 1), this.RNA.charAt(j2));
                this.FM[i][j2] = Math.min(this.FM[i][j2], this.C[i + 1][j2] + energy_para.dangle5_37[tt][this.RNAType(this.RNA.charAt(i))] + energy_para.ML_intern37[tt] + energy_para.ML_BASE37);
                tt = this.pairType(this.RNA.charAt(i), this.RNA.charAt(j2 - 1));
                this.FM[i][j2] = Math.min(this.FM[i][j2], this.C[i][j2 - 1] + energy_para.dangle3_37[tt][this.RNAType(this.RNA.charAt(j2))] + energy_para.ML_intern37[tt] + energy_para.ML_BASE37);
                tt = this.pairType(this.RNA.charAt(i + 1), this.RNA.charAt(j2 - 1));
                this.FM[i][j2] = Math.min(this.FM[i][j2], this.C[i + 1][j2 - 1] + energy_para.dangle5_37[tt][this.RNAType(this.RNA.charAt(i))] + energy_para.dangle3_37[tt][this.RNAType(this.RNA.charAt(j2))] + energy_para.ML_intern37[tt] + 2 * energy_para.ML_BASE37);
                int decomp = 100000;
                for (int k = i + 1 + 3; k <= j2 - 2 - 3; ++k) {
                    decomp = Math.min(decomp, this.FM[i][k] + this.FM[k + 1][j2]);
                }
                this.DML[i][j2] = Math.min(this.DML[i][j2], decomp);
                this.FM[i][j2] = Math.min(this.FM[i][j2], decomp);
            }
        }
        this.f5 = new int[this.length + 1];
        this.f5[4] = 0;
        for (j = 5; j <= this.length; ++j) {
            int energy;
            this.f5[j] = this.f5[j - 1];
            int type = this.pairType(this.RNA.charAt(1), this.RNA.charAt(j));
            if (type > 0) {
                energy = this.C[1][j];
                if (type > 2) {
                    energy += energy_para.TerminalAU;
                }
                this.f5[j] = Math.min(this.f5[j], energy);
            }
            if ((type = this.pairType(this.RNA.charAt(1), this.RNA.charAt(j - 1))) > 0) {
                energy = this.C[1][j - 1] + energy_para.dangle3_37[type][this.RNAType(this.RNA.charAt(j))];
                if (type > 2) {
                    energy += energy_para.TerminalAU;
                }
                this.f5[j] = Math.min(this.f5[j], energy);
            }
            for (int i = j - 3 - 1; i > 1; --i) {
                int energy2;
                type = this.pairType(this.RNA.charAt(i), this.RNA.charAt(j));
                if (type > 0) {
                    energy2 = this.f5[i - 1] + this.C[i][j];
                    if (type > 2) {
                        energy2 += energy_para.TerminalAU;
                    }
                    this.f5[j] = Math.min(this.f5[j], energy2);
                    energy2 = this.f5[i - 2] + this.C[i][j] + energy_para.dangle5_37[type][this.RNAType(this.RNA.charAt(i - 1))];
                    if (type > 2) {
                        energy2 += energy_para.TerminalAU;
                    }
                    this.f5[j] = Math.min(this.f5[j], energy2);
                }
                if ((type = this.pairType(this.RNA.charAt(i), this.RNA.charAt(j - 1))) <= 0) continue;
                energy2 = this.C[i][j - 1] + energy_para.dangle3_37[type][this.RNAType(this.RNA.charAt(j))];
                if (type > 2) {
                    energy2 += energy_para.TerminalAU;
                }
                this.f5[j] = Math.min(this.f5[j], this.f5[i - 1] + energy2);
                this.f5[j] = Math.min(this.f5[j], this.f5[i - 2] + energy2 + energy_para.dangle5_37[type][this.RNAType(this.RNA.charAt(i - 1))]);
            }
        }
        this.MFE = (double)this.f5[this.length] / 100.0;
        this.backtrack();
        this.parenthesis_structure();
    }

    public double getMFE() {
        return this.MFE;
    }

    public String getStruct() {
        return this.struct;
    }

    private int LoopEnergy(int n1, int n2, int type, int type_2, int si1, int sj1, int sp1, int sq1) {
        int ns;
        int nl;
        if (n1 > n2) {
            nl = n1;
            ns = n2;
        } else {
            nl = n2;
            ns = n1;
        }
        if (nl == 0) {
            return energy_para.stack37[type][type_2];
        }
        if (ns == 0) {
            int energy = n1 <= 30 ? energy_para.bulge37[nl] : energy_para.bulge37[30] + (int)(energy_para.lxc37 * Math.log((double)nl / 30.0));
            if (nl == 1) {
                energy += energy_para.stack37[type][type_2];
            } else {
                if (type > 2) {
                    energy += energy_para.TerminalAU;
                }
                if (type_2 > 2) {
                    energy += energy_para.TerminalAU;
                }
            }
            return energy;
        }
        if (ns == 1) {
            if (nl == 1) {
                return int11.int11_37[type][type_2][si1][sj1];
            }
            if (nl == 2) {
                int energy = n1 == 1 ? int21.int21_37[type][type_2][si1][sq1][sj1] : int21.int21_37[type_2][type][sq1][si1][sp1];
                return energy;
            }
        } else if (n1 == 2 && n2 == 2) {
            return this.int22.int22_37[type][type_2][si1][sp1][sq1][sj1];
        }
        int energy = n1 + n2 <= 30 ? energy_para.internal_loop37[n1 + n2] : energy_para.internal_loop37[30] + (int)(energy_para.lxc37 * Math.log((double)(n1 + n2) / 30.0));
        energy += Math.min(energy_para.MAX_NINIO, (nl - ns) * energy_para.F_ninio37[2]);
        return energy += energy_para.mismatchI37[type][si1][sj1] + energy_para.mismatchI37[type_2][sq1][sp1];
    }

    private int HairpinE(int type, int i, int j, String string) {
        int no;
        int size = j - i - 1;
        int energy = size <= 30 ? energy_para.hairpin37[size] : energy_para.hairpin37[30] + (int)(energy_para.lxc37 * Math.log((double)size / 30.0));
        if (size == 4 && (no = this.getSubSeqPos(energy_para.Tetraloops, string.substring(i, i + 6))) >= 0) {
            energy += energy_para.TETRA_ENERGY37[no];
        }
        if (size == 3) {
            no = this.getSubSeqPos(energy_para.Triloops, string.substring(i, i + 5));
            if (no >= 0) {
                energy += energy_para.Triloop_E37[no];
            }
            if (type > 2) {
                energy += energy_para.TerminalAU;
            }
        } else {
            energy += energy_para.mismatchH37[type][this.RNAType(string.charAt(i + 1))][this.RNAType(string.charAt(j - 1))];
        }
        return energy;
    }

    private int getSubSeqPos(String[] Str_lst, String str) {
        for (int i = 0; i < Str_lst.length; ++i) {
            if (Str_lst[i] == null || Str_lst[i].length() < str.length() || !str.equalsIgnoreCase(Str_lst[i].substring(0, str.length()))) continue;
            return i;
        }
        return -1;
    }

    private int RNAType(char nt) {
        if (nt == 'A') {
            return 1;
        }
        if (nt == 'C') {
            return 2;
        }
        if (nt == 'G') {
            return 3;
        }
        if (nt == 'U') {
            return 4;
        }
        return 0;
    }

    private int pairType(char first, char second) {
        if (first == 'C') {
            if (second == 'G') {
                return 1;
            }
            return 0;
        }
        if (first == 'G') {
            if (second == 'C') {
                return 2;
            }
            if (second == 'U') {
                return 3;
            }
            return 0;
        }
        if (first == 'U') {
            if (second == 'G') {
                return 4;
            }
            if (second == 'A') {
                return 6;
            }
            return 0;
        }
        if (first == 'A') {
            if (second == 'U') {
                return 5;
            }
            return 0;
        }
        return 0;
    }

    private void parenthesis_structure() {
        StringBuilder sb = new StringBuilder(this.length);
        for (int i = 0; i < this.length; ++i) {
            sb.append('.');
        }
        for (int k = 1; k <= this.base_pair[0].i; ++k) {
            sb.setCharAt(this.base_pair[k].i - 1, '(');
            sb.setCharAt(this.base_pair[k].j - 1, ')');
        }
        this.struct = sb.toString();
    }

    private void backtrack() {
        int i;
        for (i = 0; i < this.sector.length; ++i) {
            this.sector[i] = new sect();
        }
        for (i = 0; i < this.base_pair.length; ++i) {
            this.base_pair[i] = new bond();
        }
        ++this.bt_s;
        this.sector[this.bt_s + 1].i = 1;
        this.sector[this.bt_s].j = this.length;
        int n = this.backtrack_type == 'M' ? 1 : (this.sector[this.bt_s].ml = this.backtrack_type == 'C' ? 2 : 0);
        while (this.bt_s > 0) {
            int k;
            int fi;
            int jj = 0;
            this.bt_i = this.sector[this.bt_s].i;
            this.bt_j = this.sector[this.bt_s].j;
            int ml = this.sector[this.bt_s--].ml;
            if (ml == 2) {
                ++this.bt_b;
                this.base_pair[this.bt_b + 1].i = this.bt_i;
                this.base_pair[this.bt_b].j = this.bt_j;
                this.repeat();
                continue;
            }
            if (this.bt_j < this.bt_i + 3 + 1) continue;
            int fij = ml > 0 ? this.FM[this.bt_i][this.bt_j] : this.f5[this.bt_j];
            int n2 = fi = ml > 0 ? this.FM[this.bt_i][this.bt_j - 1] + energy_para.ML_BASE37 : this.f5[this.bt_j - 1];
            if (fij == fi) {
                ++this.bt_s;
                this.sector[this.bt_s + 1].i = this.bt_i;
                this.sector[this.bt_s].j = this.bt_j - 1;
                this.sector[this.bt_s].ml = ml;
                continue;
            }
            if (ml == 0) {
                int traced = 0;
                for (k = this.bt_j - 3 - 1; k >= 1; --k) {
                    int cc;
                    jj = k - 1;
                    int type = this.pairType(this.RNA.charAt(k), this.RNA.charAt(this.bt_j - 1));
                    if (type > 0) {
                        cc = this.C[k][this.bt_j - 1] + energy_para.dangle3_37[type][this.RNAType(this.RNA.charAt(this.bt_j))];
                        if (type > 2) {
                            cc += energy_para.TerminalAU;
                        }
                        if (fij == cc + this.f5[k - 1]) {
                            traced = this.bt_j - 1;
                        }
                        if (k > this.bt_i && fij == this.f5[k - 2] + cc + energy_para.dangle5_37[type][this.RNAType(this.RNA.charAt(k - 1))]) {
                            traced = this.bt_j - 1;
                            jj = k - 2;
                        }
                    }
                    if ((type = this.pairType(this.RNA.charAt(k), this.RNA.charAt(this.bt_j))) > 0) {
                        int en;
                        cc = this.C[k][this.bt_j];
                        if (type > 2) {
                            cc += energy_para.TerminalAU;
                        }
                        if (fij == (en = cc + this.f5[k - 1])) {
                            traced = this.bt_j;
                        }
                        if (k > 1 && fij == this.f5[k - 2] + cc + energy_para.dangle5_37[type][this.RNAType(this.RNA.charAt(k - 1))]) {
                            traced = this.bt_j;
                            jj = k - 2;
                        }
                    }
                    if (traced > 0) break;
                }
                if (traced == 0) {
                    System.out.print("backtrack failed in f5");
                }
                ++this.bt_s;
                this.sector[this.bt_s + 1].i = 1;
                this.sector[this.bt_s].j = jj;
                this.sector[this.bt_s].ml = ml;
                this.bt_i = k;
                this.bt_j = traced;
                ++this.bt_b;
                this.base_pair[this.bt_b + 1].i = this.bt_i;
                this.base_pair[this.bt_b].j = this.bt_j;
                this.repeat();
                continue;
            }
            int cij1 = 100000;
            int ci1j = 100000;
            int ci1j1 = 100000;
            if (this.FM[this.bt_i + 1][this.bt_j] + energy_para.ML_BASE37 == fij) {
                ++this.bt_s;
                this.sector[this.bt_s + 1].i = this.bt_i + 1;
                this.sector[this.bt_s].j = this.bt_j;
                this.sector[this.bt_s].ml = ml;
                continue;
            }
            int tt = this.pairType(this.RNA.charAt(this.bt_i), this.RNA.charAt(this.bt_j));
            int cij = this.C[this.bt_i][this.bt_j] + energy_para.ML_intern37[tt];
            tt = this.pairType(this.RNA.charAt(this.bt_i + 1), this.RNA.charAt(this.bt_j));
            ci1j = this.C[this.bt_i + 1][this.bt_j] + energy_para.dangle5_37[tt][this.RNAType(this.RNA.charAt(this.bt_i))] + energy_para.ML_intern37[tt] + energy_para.ML_BASE37;
            tt = this.pairType(this.RNA.charAt(this.bt_i), this.RNA.charAt(this.bt_j - 1));
            cij1 = this.C[this.bt_i][this.bt_j - 1] + energy_para.dangle3_37[tt][this.RNAType(this.RNA.charAt(this.bt_j))] + energy_para.ML_intern37[tt] + energy_para.ML_BASE37;
            tt = this.pairType(this.RNA.charAt(this.bt_i + 1), this.RNA.charAt(this.bt_j - 1));
            ci1j1 = this.C[this.bt_i + 1][this.bt_j - 1] + energy_para.dangle5_37[tt][this.RNAType(this.RNA.charAt(this.bt_i))] + energy_para.dangle3_37[tt][this.RNAType(this.RNA.charAt(this.bt_j))] + energy_para.ML_intern37[tt] + 2 * energy_para.ML_BASE37;
            if (fij == cij || fij == ci1j || fij == cij1 || fij == ci1j1) {
                if (fij != ci1j && fij != cij1 && fij == ci1j1) {
                    ++this.bt_i;
                    --this.bt_j;
                }
                ++this.bt_b;
                this.base_pair[this.bt_b + 1].i = ++this.bt_i;
                this.base_pair[this.bt_b].j = --this.bt_j;
                this.repeat();
                continue;
            }
            for (k = this.bt_i + 1 + 3; k <= this.bt_j - 2 - 3 && fij != this.FM[this.bt_i][k] + this.FM[k + 1][this.bt_j]; ++k) {
            }
            ++this.bt_s;
            this.sector[this.bt_s + 1].i = this.bt_i;
            this.sector[this.bt_s].j = k;
            this.sector[this.bt_s].ml = ml;
            ++this.bt_s;
            this.sector[this.bt_s + 1].i = k + 1;
            this.sector[this.bt_s].j = this.bt_j;
            this.sector[this.bt_s].ml = ml;
            if (k <= this.bt_j - 2 - 3) continue;
            System.out.print("backtrack failed in fML");
        }
        this.base_pair[0].i = this.bt_b;
    }

    private void repeat() {
        int en;
        int k;
        boolean repeat = true;
        int type = 0;
        int cij = 0;
        block0: while (repeat) {
            cij = this.C[this.bt_i][this.bt_j];
            type = this.pairType(this.RNA.charAt(this.bt_i), this.RNA.charAt(this.bt_j));
            if (cij == this.HairpinE(type, this.bt_i, this.bt_j, this.RNA)) {
                return;
            }
            for (int p = this.bt_i + 1; p <= Math.min(this.bt_j - 2 - 3, this.bt_i + 30 + 1); ++p) {
                int minq = this.bt_j - this.bt_i + p - 30 - 2;
                if (minq < p + 1 + 3) {
                    minq = p + 1 + 3;
                }
                for (int q = this.bt_j - 1; q >= minq; --q) {
                    int type_2 = this.pairType(this.RNA.charAt(p), this.RNA.charAt(q));
                    if (type_2 == 0) {
                        repeat = false;
                        continue;
                    }
                    type_2 = this.pairType(this.RNA.charAt(q), this.RNA.charAt(p));
                    int energy = this.LoopEnergy(p - this.bt_i - 1, this.bt_j - q - 1, type, type_2, this.RNAType(this.RNA.charAt(this.bt_i + 1)), this.RNAType(this.RNA.charAt(this.bt_j - 1)), this.RNAType(this.RNA.charAt(p - 1)), this.RNAType(this.RNA.charAt(q + 1)));
                    int new1 = energy + this.C[p][q];
                    if (cij == new1) {
                        ++this.bt_b;
                        this.base_pair[this.bt_b + 1].i = p;
                        this.base_pair[this.bt_b].j = q;
                        this.bt_i = p;
                        this.bt_j = q;
                        repeat = true;
                        break;
                    }
                    repeat = false;
                }
                if (repeat) continue block0;
            }
        }
        int tt = rtype[type];
        int mm = energy_para.ML_closing37 + energy_para.ML_intern37[tt];
        int d5 = energy_para.dangle5_37[tt][this.RNAType(this.RNA.charAt(this.bt_j - 1))];
        int d3 = energy_para.dangle3_37[tt][this.RNAType(this.RNA.charAt(this.bt_i + 1))];
        int i1 = this.bt_i + 1;
        int j1 = this.bt_j - 1;
        this.sector[this.bt_s + 1].ml = 1;
        this.sector[this.bt_s + 2].ml = 1;
        for (k = this.bt_i + 2 + 3; k < this.bt_j - 2 - 3 && cij != (en = this.FM[this.bt_i + 1][k] + this.FM[k + 1][this.bt_j - 1] + mm); ++k) {
            if (cij == this.FM[this.bt_i + 2][k] + this.FM[k + 1][this.bt_j - 1] + mm + d3 + energy_para.ML_BASE37) {
                i1 = this.bt_i + 2;
                break;
            }
            if (cij == this.FM[this.bt_i + 1][k] + this.FM[k + 1][this.bt_j - 2] + mm + d5 + energy_para.ML_BASE37) {
                j1 = this.bt_j - 2;
                break;
            }
            if (cij != this.FM[this.bt_i + 2][k] + this.FM[k + 1][this.bt_j - 2] + mm + d3 + d5 + energy_para.ML_BASE37 + energy_para.ML_BASE37) continue;
            i1 = this.bt_i + 2;
            j1 = this.bt_j - 2;
            break;
        }
        if (k <= this.bt_j - 3 - 3) {
            ++this.bt_s;
            this.sector[this.bt_s + 1].i = i1;
            this.sector[this.bt_s].j = k;
            ++this.bt_s;
            this.sector[this.bt_s + 1].i = k + 1;
            this.sector[this.bt_s].j = j1;
        } else {
            System.out.print("backtracking failed in repeat");
        }
    }
}

