/*
 * Decompiled with CFR 0.152.
 */
package GenomeLite;

import GenomeLite.MyCellRenderer;
import GenomeLite.MyCellRenderer1;
import GenomeLite.RectText;
import GenomeLite.canvas;
import GenomeLite.custom_track;
import GenomeLite.myBufferedImage;
import GenomeLite.popup;
import GenomeLite.track_image;
import RNAfold.RNAfold;
import genomeSearch.genomeSearch;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JProgressBar;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SwingWorker;
import javax.swing.ToolTipManager;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.plaf.basic.BasicComboBoxUI;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class genome
extends JFrame
implements PropertyChangeListener {
    static String xml_filename = "track.xml";
    static HashMap<String, Integer> chr_size = new HashMap();
    static String IP;
    static String account;
    static String password;
    static Connection conn;
    String assembly;
    String housekeeping_tableName;
    static ArrayList<String> DB_tables;
    static ArrayList<custom_track> custom_tracks;
    int movingTrack;
    static int mouseStoppedTrack;
    static String chr;
    static long loci_start;
    static long loci_stop;
    static int LEFT_MARGIN;
    int browser_max_length = 3000;
    static int canvas_width;
    static int canvas_height;
    static int browser_width;
    static int browser_height;
    static double ratio;
    static String geneSymbol;
    static boolean inDrag;
    static int rect_x1;
    static int rect_y1;
    static int rect_x2;
    static int rect_y2;
    String[] bed_col = new String[]{"chrom varchar(255)", "chromStart int", "chromEnd int", "name varchar(255)", "score int", "strand varchar(10)", "thickStart int", "thickEnd int", "itemRgb varchar(20)", "blockCount int", "blockSizes longblob", "blockStarts longblob"};
    String bed_index = "index chrom_start (chrom,chromStart),index chrom_stop (chrom,chromEnd)";
    int[] is_bed_varchar = new int[]{1, 0, 0, 1, 0, 1, 0, 0, 1, 0, 1, 1};
    String[] wig_col = new String[]{"name varchar(200)", "chrom varchar(255)", "strand varchar(1)", "chromStart int", "chromEnd int", "value double", "color varchar(20)"};
    String wig_index = "index chrom_strand_start (chrom,strand,chromStart),index chrom_strand_stop (chrom,strand,chromEnd)";
    int[] is_wig_varchar = new int[]{1, 1, 1, 0, 0, 0, 1};
    String[] combinedwig_col = new String[]{"name varchar(200)", "chrom varchar(255)", "strand varchar(1)", "chromStart int", "chromEnd int", "multi_expr varchar(200)"};
    String combinedWig_index = "index chrom_start (chrom,chromStart),index chrom_stop (chrom,chromEnd)";
    int[] is_combinedwig_varchar = new int[]{1, 1, 1, 0, 0, 1};
    String[] refseq_hosuekeeping_col = new String[]{"bin smallint(5) unsigned", "name varchar(255)", "chrom varchar(255)", "strand char(1)", "txStart int(10) unsigned", "txEnd int(10) unsigned", "cdsStart int(10) unsigned", "cdsEnd int(10) unsigned", "exonCount int(10) unsigned", "exonStarts longblob", "exonEnds longblob", "id int(10) unsigned", "name2 varchar(255)", "cdsStartStat enum('none', 'unk', 'incmpl', 'cmpl')", "cdsEndStat enum('none','unk','incmpl','cmpl')", "exonFrames longblob"};
    String refseq_hosuekeeping_index = "index chrom_start (chrom,txStart),index chrom_stop (chrom,txEnd)";
    int[] is_refseq_hosuekeeping_varchar = new int[]{0, 1, 1, 1, 0, 0, 0, 0, 0, 1, 1, 0, 1, 1, 1, 1};
    static boolean hasStrip;
    static myBufferedImage image;
    static myBufferedImage drag_region;
    static ArrayList<track_image> track_image_lst;
    String userID;
    String OS_name;
    String DB_name_for_fill_DB;
    String datafilename_for_fill_DB;
    boolean hasHeader_for_fill_DB;
    static popup popup;
    private progressBar_task progressBar_task;
    static int color_seq;
    static String bedgraph_auto_assign_color;
    private ButtonGroup buttonGroup1;
    private ButtonGroup buttonGroup2;
    private JButton jButton1;
    private JButton jButton10;
    private JButton jButton11;
    private JButton jButton12;
    private JButton jButton13;
    private JButton jButton14;
    private JButton jButton15;
    private JButton jButton16;
    private JButton jButton17;
    private JButton jButton18;
    private JButton jButton19;
    private JButton jButton2;
    private JButton jButton21;
    private JButton jButton22;
    private JButton jButton3;
    private JButton jButton4;
    private JButton jButton5;
    private JButton jButton6;
    private JButton jButton7;
    private JButton jButton8;
    private JButton jButton9;
    private JComboBox jComboBox2;
    private JComboBox jComboBox3;
    private JLabel jLabel1;
    private JLabel jLabel10;
    private JLabel jLabel11;
    private JLabel jLabel12;
    private JLabel jLabel13;
    private JLabel jLabel14;
    private JLabel jLabel15;
    private JLabel jLabel16;
    private JLabel jLabel17;
    private JLabel jLabel18;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel jPanel5;
    private JPanel jPanel6;
    private JPanel jPanel7;
    private JPasswordField jPasswordField1;
    private JProgressBar jProgressBar1;
    private static JRadioButton jRadioButton1;
    private static JRadioButton jRadioButton2;
    private static JRadioButton jRadioButton3;
    private JRadioButton jRadioButton4;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JScrollPane jScrollPane3;
    private JTabbedPane jTabbedPane1;
    private JTable jTable1;
    private JTextArea jTextArea1;
    private JTextField jTextField1;
    private JTextField jTextField2;
    private JTextField jTextField3;
    private JTextField jTextField4;
    private JTextField jTextField5;
    private JTextField jTextField6;
    private JTextField jTextField7;
    private JTextField jTextField8;
    private JTextField jTextField9;

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equalsIgnoreCase("progress")) {
            int progress = (Integer)evt.getNewValue();
            this.jProgressBar1.setValue(progress);
        }
    }

    private void get_auto_assign_Color() {
        bedgraph_auto_assign_color = "0,0,0";
        String[] combinedColor = new String[]{"0", "125", "255"};
        while (bedgraph_auto_assign_color.indexOf("125") < 0) {
            bedgraph_auto_assign_color = combinedColor[color_seq % 3] + "," + combinedColor[color_seq / 3 % 3] + "," + combinedColor[color_seq / 3 / 3 % 27];
            ++color_seq;
        }
        bedgraph_auto_assign_color = JOptionPane.showInputDialog(null, "is the color suitable?", bedgraph_auto_assign_color);
    }

    public genome() throws SQLException, ParserConfigurationException, SAXException, IOException, ClassNotFoundException, InstantiationException, IllegalAccessException {
        this.initComponents();
        this.jButton21.setToolTipText("get DNA sequqnce");
        this.jButton22.setToolTipText("get RNA secondary structure");
        this.jTable1.getColumnModel().getColumn(0).setCellRenderer(new MyCellRenderer());
        this.jTable1.getColumnModel().getColumn(1).setCellRenderer(new MyCellRenderer1());
        this.jTable1.setShowGrid(true);
        this.jTable1.setShowHorizontalLines(true);
        this.jTable1.setShowVerticalLines(true);
        this.userID = System.getProperty("user.name");
        this.OS_name = System.getProperty("os.name");
        browser_width = Integer.parseInt(this.jTextField5.getText());
        browser_height = Integer.parseInt(this.jTextField9.getText());
        this.jScrollPane1.setPreferredSize(new Dimension(browser_width, browser_height));
        this.jScrollPane1.setSize(new Dimension(browser_width, browser_height));
        this.jScrollPane1.revalidate();
        UIDefaults uidef = UIManager.getDefaults();
        int scrollbar_width = Integer.parseInt(uidef.get("ScrollBar.width").toString());
        canvas_width = browser_width - scrollbar_width - 1;
        canvas_height = browser_height;
        this.jPanel3.setPreferredSize(new Dimension(canvas_width, canvas_height));
        this.jPanel3.setSize(new Dimension(canvas_width, canvas_height));
        this.jPanel3.revalidate();
        if (!this.readXML()) {
            JOptionPane.showConfirmDialog(null, "\"track.xml file has error format", "ERROR", -1);
            return;
        }
        this.add_combobox_listener();
        if (this.get_loci()) {
            System.out.print("*****before read_custom_track\n");
            if (this.read_custom_track()) {
                System.out.print("*****before refresh_position\n");
                this.refresh_position();
                inDrag = false;
                this.create_image();
            }
        }
    }

    private boolean getChromosomeSize() {
        try {
            Statement statement = conn.createStatement();
            String SQL = "select chrom, max(txEnd) from " + this.housekeeping_tableName + " group by chrom";
            ResultSet resultSet = statement.executeQuery(SQL);
            while (resultSet.next()) {
                chr_size.put(resultSet.getString(1), resultSet.getInt(2));
            }
        }
        catch (SQLException ex) {
            JOptionPane.showMessageDialog(null, "failed to access housekeeping tack table", "message", -1);
            return false;
        }
        return true;
    }

    private void create_image() throws SQLException {
        track_image_lst.clear();
        Rectangle rect = new Rectangle();
        ArrayList<RectText> MouseOver = new ArrayList<RectText>();
        myBufferedImage header_image = new myBufferedImage(this.jPanel3.getWidth(), this.browser_max_length, 2, "header", rect, MouseOver);
        track_image_lst.add(new track_image(header_image, rect, MouseOver));
        for (custom_track track : custom_tracks) {
            ArrayList<RectText> MouseOver1;
            Rectangle rect1;
            custom_track ct = this.covert2custom_track(track.DB);
            if (ct.type.equalsIgnoreCase("wiggle") && track.isVisable.equalsIgnoreCase("full")) {
                rect1 = new Rectangle();
                MouseOver1 = new ArrayList<RectText>();
                myBufferedImage wiggle_image = new myBufferedImage(this.jPanel3.getWidth(), this.browser_max_length, 2, track.DB, ct.scaleType, "wiggle", rect1, MouseOver1);
                track_image_lst.add(new track_image(wiggle_image, rect1, MouseOver1));
            }
            if (ct.type.equalsIgnoreCase("bed") && track.isVisable.equalsIgnoreCase("full")) {
                rect1 = new Rectangle();
                MouseOver1 = new ArrayList();
                myBufferedImage bed_image = new myBufferedImage(this.jPanel3.getWidth(), this.browser_max_length, 2, track.DB, ct.scaleType, "bed", rect1, MouseOver1);
                track_image_lst.add(new track_image(bed_image, rect1, MouseOver1));
            }
            if (ct.type.equalsIgnoreCase("combinedwiggle") && track.isVisable.equalsIgnoreCase("full")) {
                rect1 = new Rectangle();
                MouseOver1 = new ArrayList();
                myBufferedImage combinedwiggle_image = new myBufferedImage(this.jPanel3.getWidth(), this.browser_max_length, 2, track.DB, ct.scaleType, "combinedwiggle", rect1, MouseOver1);
                track_image_lst.add(new track_image(combinedwiggle_image, rect1, MouseOver1));
            }
            if (ct.type.equalsIgnoreCase("housekeeping") && track.isVisable.equalsIgnoreCase("full")) {
                rect1 = new Rectangle();
                MouseOver1 = new ArrayList();
                myBufferedImage refSeq_image = new myBufferedImage(this.jPanel3.getWidth(), this.browser_max_length, 2, ct.DB, rect1, MouseOver1);
                track_image_lst.add(new track_image(refSeq_image, rect1, MouseOver1));
            }
            if (!ct.type.equalsIgnoreCase("") || !track.isVisable.equalsIgnoreCase("full") || !ct.DB.equals("sno_mirna")) continue;
            rect1 = new Rectangle();
            MouseOver1 = new ArrayList();
            myBufferedImage miR_image = new myBufferedImage(this.jPanel3.getWidth(), this.browser_max_length, 2, "sno_miR", rect1, MouseOver1);
            track_image_lst.add(new track_image(miR_image, rect1, MouseOver1));
        }
        canvas_height = 0;
        for (track_image key : track_image_lst) {
            canvas_height += key.rect.height;
        }
        canvas_height += 5;
        canvas_height = Math.min(canvas_height, this.browser_max_length);
        this.jPanel3.setPreferredSize(new Dimension(canvas_width, canvas_height));
        this.jPanel3.revalidate();
    }

    private custom_track covert2custom_track(String DB_name) {
        String[] files = DB_name.split(",");
        String[] str = files[0].split("_");
        String type = "";
        String scaleType = "";
        if (str.length > 1) {
            type = str[str.length - 1];
        }
        if (!type.equalsIgnoreCase("bed") && str.length > 2) {
            scaleType = str[str.length - 2];
        }
        for (int i = 1; i < files.length; ++i) {
            str = files[i].split("_");
            if (!(type.equalsIgnoreCase("bed") ? !type.equalsIgnoreCase(str[str.length - 1]) : !type.equalsIgnoreCase(str[str.length - 1]) || !scaleType.equalsIgnoreCase(str[str.length - 2]))) continue;
            return null;
        }
        return new custom_track(DB_name, type, scaleType, "full");
    }

    private void add_combobox_listener() {
        this.jComboBox2.setUI(new BasicComboBoxUI(){

            protected JButton createArrowButton() {
                return new JButton(){

                    public int getWidth() {
                        return 0;
                    }
                };
            }
        });
        final JTextField editorcomp = (JTextField)this.jComboBox2.getEditor().getEditorComponent();
        editorcomp.addKeyListener(new KeyAdapter(){

            public void keyTyped(KeyEvent evt) {
                char keychar = evt.getKeyChar();
                String prefix = editorcomp.getText();
                genome.this.jComboBox2.setPopupVisible(false);
                if (keychar == '\n') {
                    genome.this.jComboBox2.setPopupVisible(false);
                    genome.this.jButton2.requestFocus();
                    if (genome.this.getGeneSymbol()) {
                        genome.this.refresh_position();
                        genome.this.jPanel3.repaint();
                    }
                }
                if (keychar == '\b') {
                    if (prefix.length() < 2) {
                        return;
                    }
                    ArrayList all_genes = genome.this.listGeneSymbol_fromPrefix(prefix);
                    genome.this.jComboBox2.removeAllItems();
                    for (String key : all_genes) {
                        genome.this.jComboBox2.addItem(key);
                    }
                    genome.this.jComboBox2.showPopup();
                    editorcomp.setText(prefix);
                    return;
                }
                if (keychar < ' ' && keychar > '~') {
                    return;
                }
                if (prefix.length() > 0) {
                    ArrayList all_genes = genome.this.listGeneSymbol_fromPrefix(prefix + keychar);
                    genome.this.jComboBox2.removeAllItems();
                    for (String key : all_genes) {
                        genome.this.jComboBox2.addItem(key);
                    }
                    genome.this.jComboBox2.revalidate();
                    genome.this.jComboBox2.showPopup();
                    genome.this.jComboBox2.setPopupVisible(true);
                    genome.this.jComboBox2.repaint();
                    genome.this.jComboBox2.setSize(40, 50);
                    editorcomp.setText(prefix);
                }
            }
        });
    }

    private ArrayList<String> listGeneSymbol_fromPrefix(String gene_prefix) {
        ArrayList<String> al = new ArrayList<String>();
        if (this.assembly.isEmpty()) {
            return al;
        }
        String SQL = "";
        try {
            Statement statement = conn.createStatement();
            SQL = "select distinct(name2) from refgene_" + this.assembly + "_housekeeping where name2 like  '" + gene_prefix + "%' order by name2";
            ResultSet resultSet = statement.executeQuery(SQL);
            while (resultSet.next()) {
                al.add(resultSet.getString(1));
            }
        }
        catch (SQLException ex) {
            JOptionPane.showMessageDialog(null, "SQL " + SQL + " error", "message", -1);
        }
        return al;
    }

    private boolean isDecentColorCode(String RGB) {
        String[] str = RGB.split(",");
        if (str.length != 3) {
            return false;
        }
        for (int i = 0; i < str.length; ++i) {
            if (!genome.isNumeric(str[i])) {
                return false;
            }
            if (Integer.parseInt(str[i]) >= 0 && Integer.parseInt(str[i]) <= 255) continue;
            return false;
        }
        return true;
    }

    private boolean isDecentChrName(String chr) {
        if (chr_size.get(chr) != null) {
            return true;
        }
        return chr.startsWith("chr");
    }

    private boolean get_loci() {
        String loci_string = this.jTextField1.getText();
        if (loci_string.indexOf(45) < 0) {
            JOptionPane.showMessageDialog(null, "locus format is chr?:xxx-xxx(e.g. chr1:111-333)", "message", -1);
            return false;
        }
        if (loci_string.indexOf(58) < 0) {
            JOptionPane.showMessageDialog(null, "locus format is chr?:???-???(e.g. chr1:111-333)", "message", -1);
            return false;
        }
        String position = this.jTextField1.getText().replace(",", "");
        String[] str = position.split(":");
        chr = str[0].trim();
        if (!this.isDecentChrName(chr)) {
            JOptionPane.showMessageDialog(null, "locus format is chr?:???-???(e.g. chr1:111-333)", "message", -1);
            return false;
        }
        if (str.length < 2) {
            JOptionPane.showMessageDialog(null, "locus format is chr?:???-???(e.g. chr1:111-333)", "message", -1);
            return false;
        }
        loci_start = Integer.parseInt((str = str[1].split("-"))[0]);
        if (loci_start > (loci_stop = (long)Integer.parseInt(str[1]))) {
            loci_start = loci_stop;
            this.set_loci();
        }
        if (loci_stop - loci_start > 10000000L) {
            JOptionPane.showMessageDialog(null, "The Max chromosome region is 10,000,000", "message", -1);
            loci_stop = loci_start + 10000000L;
            this.set_loci();
        }
        return true;
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.buttonGroup2 = new ButtonGroup();
        this.jTabbedPane1 = new JTabbedPane();
        this.jPanel1 = new JPanel();
        this.jButton4 = new JButton();
        this.jButton5 = new JButton();
        this.jButton2 = new JButton();
        this.jButton3 = new JButton();
        this.jLabel5 = new JLabel();
        this.jButton6 = new JButton();
        this.jButton7 = new JButton();
        this.jLabel6 = new JLabel();
        this.jButton10 = new JButton();
        this.jButton9 = new JButton();
        this.jButton8 = new JButton();
        this.jButton11 = new JButton();
        this.jTextField1 = new JTextField();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jButton1 = new JButton();
        this.jLabel4 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.jPanel3 = new canvas();
        this.jButton12 = new JButton();
        this.jComboBox2 = new JComboBox();
        this.jLabel9 = new JLabel();
        this.jTextField2 = new JTextField();
        this.jButton21 = new JButton();
        this.jButton22 = new JButton();
        this.jPanel2 = new JPanel();
        this.jPanel4 = new JPanel();
        this.jTextField4 = new JTextField();
        this.jLabel8 = new JLabel();
        this.jLabel15 = new JLabel();
        this.jTextField8 = new JTextField();
        this.jLabel16 = new JLabel();
        this.jPasswordField1 = new JPasswordField();
        this.jScrollPane2 = new JScrollPane();
        this.jTable1 = new JTable();
        this.jButton15 = new JButton();
        this.jButton16 = new JButton();
        this.jButton17 = new JButton();
        this.jButton14 = new JButton();
        this.jButton18 = new JButton();
        this.jTextField3 = new JTextField();
        this.jLabel7 = new JLabel();
        this.jTextField5 = new JTextField();
        this.jLabel14 = new JLabel();
        this.jTextField9 = new JTextField();
        this.jPanel5 = new JPanel();
        this.jPanel7 = new JPanel();
        this.jLabel11 = new JLabel();
        this.jButton19 = new JButton();
        this.jTextField6 = new JTextField();
        this.jLabel12 = new JLabel();
        this.jTextField7 = new JTextField();
        this.jLabel13 = new JLabel();
        this.jPanel6 = new JPanel();
        jRadioButton1 = new JRadioButton();
        jRadioButton2 = new JRadioButton();
        jRadioButton3 = new JRadioButton();
        this.jRadioButton4 = new JRadioButton();
        this.jLabel10 = new JLabel();
        this.jLabel17 = new JLabel();
        this.jScrollPane3 = new JScrollPane();
        this.jTextArea1 = new JTextArea();
        this.jButton13 = new JButton();
        this.jLabel18 = new JLabel();
        this.jComboBox3 = new JComboBox();
        this.jLabel1 = new JLabel();
        this.jProgressBar1 = new JProgressBar();
        this.setDefaultCloseOperation(3);
        this.jButton4.setText("<");
        this.jButton4.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                genome.this.jButton4ActionPerformed(evt);
            }
        });
        this.jButton5.setText(">");
        this.jButton5.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                genome.this.jButton5ActionPerformed(evt);
            }
        });
        this.jButton2.setText("<<<");
        this.jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                genome.this.jButton2ActionPerformed(evt);
            }
        });
        this.jButton3.setText("<<");
        this.jButton3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                genome.this.jButton3ActionPerformed(evt);
            }
        });
        this.jLabel5.setText("zoom in");
        this.jButton6.setText(">>");
        this.jButton6.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                genome.this.jButton6ActionPerformed(evt);
            }
        });
        this.jButton7.setText(">>>");
        this.jButton7.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                genome.this.jButton7ActionPerformed(evt);
            }
        });
        this.jLabel6.setText("zoom out");
        this.jButton10.setText("3X");
        this.jButton10.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                genome.this.jButton10ActionPerformed(evt);
            }
        });
        this.jButton9.setText("10X");
        this.jButton9.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                genome.this.jButton9ActionPerformed(evt);
            }
        });
        this.jButton8.setText("3X");
        this.jButton8.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                genome.this.jButton8ActionPerformed(evt);
            }
        });
        this.jButton11.setText("10X");
        this.jButton11.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                genome.this.jButton11ActionPerformed(evt);
            }
        });
        this.jTextField1.setText("chr19:56,100,981-56,105,368");
        this.jLabel2.setText("position");
        this.jLabel3.setText("gene");
        this.jButton1.setText("jump");
        this.jButton1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                genome.this.jButton1ActionPerformed(evt);
            }
        });
        this.jLabel4.setText("move");
        this.jScrollPane1.setVerticalScrollBarPolicy(22);
        this.jScrollPane1.setPreferredSize(new Dimension(200, 200));
        this.jPanel3.setBackground(new Color(255, 255, 255));
        this.jPanel3.setPreferredSize(new Dimension(100, 100));
        this.jPanel3.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent evt) {
                genome.this.jPanel3mousePressed(evt);
            }

            public void mouseReleased(MouseEvent evt) {
                genome.this.jPanel3mouseReleased(evt);
            }
        });
        this.jPanel3.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseDragged(MouseEvent evt) {
                genome.this.jPanel3mouseDragged(evt);
            }
        });
        GroupLayout jPanel3Layout = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 181, Short.MAX_VALUE));
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 198, Short.MAX_VALUE));
        this.jScrollPane1.setViewportView(this.jPanel3);
        this.jButton12.setText("save image");
        this.jButton12.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                genome.this.jButton12ActionPerformed(evt);
            }
        });
        this.jComboBox2.setEditable(true);
        this.jComboBox2.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.jComboBox2.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent evt) {
                genome.this.keypressed(evt);
            }
        });
        this.jLabel9.setText("Assembly");
        this.jTextField2.setEditable(false);
        this.jTextField2.setHorizontalAlignment(0);
        this.jTextField2.setText("hg18");
        this.jButton21.setText("DNA");
        this.jButton21.setToolTipText("DNA sequence");
        this.jButton21.addMouseListener(new MouseAdapter(){

            public void mouseEntered(MouseEvent evt) {
                genome.this.mouseEntered_DNA(evt);
            }
        });
        this.jButton21.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                genome.this.jButton21ActionPerformed(evt);
            }
        });
        this.jButton22.setText("RNA");
        this.jButton22.setToolTipText("RNA secondary structure");
        this.jButton22.addMouseListener(new MouseAdapter(){

            public void mouseEntered(MouseEvent evt) {
                genome.this.mouseEnter_RNA(evt);
            }
        });
        this.jButton22.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                genome.this.jButton22ActionPerformed(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGap(28, 28, 28).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -2, -1, -2).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel4).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton2)).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel9).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextField2))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jButton3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton4).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton5).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton6).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton7).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel5).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton8).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton9).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jLabel6).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jButton10).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jButton11).addGap(18, 18, 18).addComponent(this.jButton21)).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextField1, -2, 206, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jComboBox2, -2, 102, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton1).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jButton12).addGap(18, 18, 18).addComponent(this.jButton22, -2, 77, -2))))).addGap(265, 265, 265)));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel4).addComponent(this.jButton3).addComponent(this.jButton2).addComponent(this.jButton4).addComponent(this.jButton5).addComponent(this.jButton6).addComponent(this.jButton7).addComponent(this.jLabel5).addComponent(this.jButton8).addComponent(this.jButton9).addComponent(this.jLabel6).addComponent(this.jButton10).addComponent(this.jButton11).addComponent(this.jButton21)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel9).addComponent(this.jTextField2, -2, -1, -2).addComponent(this.jLabel2).addComponent(this.jTextField1, -2, -1, -2))).addGroup(jPanel1Layout.createSequentialGroup().addGap(34, 34, 34).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.jComboBox2).addComponent(this.jButton1).addComponent(this.jButton12).addComponent(this.jButton22)))).addGap(18, 18, 18).addComponent(this.jScrollPane1, -2, -1, -2).addContainerGap(404, Short.MAX_VALUE)));
        this.jTabbedPane1.addTab("genome browser", null, this.jPanel1, "2nd structure");
        this.jPanel2.setPreferredSize(new Dimension(600, 663));
        this.jPanel4.setBorder(BorderFactory.createBevelBorder(0));
        this.jTextField4.setText("131.181.4.72");
        this.jTextField4.setEnabled(false);
        this.jLabel8.setText("IP address");
        this.jLabel15.setText("account");
        this.jTextField8.setText("root");
        this.jTextField8.setEnabled(false);
        this.jLabel16.setText("password");
        this.jPasswordField1.setText("ansaigen");
        this.jPasswordField1.setEnabled(false);
        this.jTable1.setModel(new DefaultTableModel(new Object[0][], new String[]{"track/DB name", "visible"}){
            Class[] types;
            {
                this.types = new Class[]{String.class, String.class};
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }
        });
        this.jScrollPane2.setViewportView(this.jTable1);
        this.jButton15.setText("^");
        this.jButton15.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                genome.this.jButton15ActionPerformed(evt);
            }
        });
        this.jButton16.setText("V");
        this.jButton16.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                genome.this.jButton16ActionPerformed(evt);
            }
        });
        this.jButton17.setText("refresh");
        this.jButton17.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                genome.this.jButton17ActionPerformed(evt);
            }
        });
        this.jButton14.setText("+");
        this.jButton14.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                genome.this.jButton14ActionPerformed(evt);
            }
        });
        this.jButton18.setText("-");
        this.jButton18.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                genome.this.jButton18ActionPerformed(evt);
            }
        });
        this.jTextField3.setEditable(false);
        this.jTextField3.setText("      ");
        this.jLabel7.setText("genome borwser width");
        this.jTextField5.setText("800");
        this.jLabel14.setText("genome borwser height");
        this.jTextField9.setText("500");
        GroupLayout jPanel4Layout = new GroupLayout(this.jPanel4);
        this.jPanel4.setLayout(jPanel4Layout);
        jPanel4Layout.setHorizontalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createSequentialGroup().addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createSequentialGroup().addGap(19, 19, 19).addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jScrollPane2, GroupLayout.Alignment.LEADING, -1, 634, Short.MAX_VALUE).addGroup(jPanel4Layout.createSequentialGroup().addComponent(this.jTextField3, -2, 38, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 124, Short.MAX_VALUE).addComponent(this.jLabel8).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextField4, -2, 124, -2).addGap(23, 23, 23).addComponent(this.jLabel15).addGap(18, 18, 18).addComponent(this.jTextField8, -2, 64, -2).addGap(18, 18, 18).addComponent(this.jLabel16).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPasswordField1, -2, 76, -2).addGap(6, 6, 6))).addGap(18, 18, 18).addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jButton15, -1, 80, Short.MAX_VALUE).addComponent(this.jButton17, -1, 80, Short.MAX_VALUE).addComponent(this.jButton18, -1, 80, Short.MAX_VALUE).addComponent(this.jButton14, -1, 80, Short.MAX_VALUE).addComponent(this.jButton16, -1, 80, Short.MAX_VALUE))).addGroup(jPanel4Layout.createSequentialGroup().addGap(38, 38, 38).addComponent(this.jLabel7).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jTextField5, -2, 51, -2).addGap(18, 18, 18).addComponent(this.jLabel14).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jTextField9, -2, 46, -2))).addContainerGap()));
        jPanel4Layout.setVerticalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createSequentialGroup().addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createSequentialGroup().addGap(22, 22, 22).addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextField8, -2, -1, -2).addComponent(this.jLabel15).addComponent(this.jTextField4, -2, -1, -2).addComponent(this.jLabel8).addComponent(this.jTextField3, -2, -1, -2))).addGroup(jPanel4Layout.createSequentialGroup().addGap(20, 20, 20).addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel16).addComponent(this.jPasswordField1, -2, -1, -2)))).addGap(21, 21, 21).addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createSequentialGroup().addGap(37, 37, 37).addComponent(this.jButton15).addGap(15, 15, 15).addComponent(this.jButton16).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jButton14).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jButton18).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jButton17)).addComponent(this.jScrollPane2, -1, 233, Short.MAX_VALUE)).addGap(18, 18, 18).addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel7).addComponent(this.jTextField5, -2, -1, -2).addComponent(this.jLabel14).addComponent(this.jTextField9, -2, -1, -2)).addGap(13, 13, 13)));
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel4, -2, -1, -2).addContainerGap(321, Short.MAX_VALUE)));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel4, -2, -1, -2).addContainerGap(328, Short.MAX_VALUE)));
        this.jTabbedPane1.addTab("customize", this.jPanel2);
        this.jPanel7.setBorder(BorderFactory.createBevelBorder(0));
        this.jLabel11.setText("data file");
        this.jButton19.setText("file browser");
        this.jButton19.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                genome.this.jButton19ActionPerformed(evt);
            }
        });
        this.jTextField6.setEditable(false);
        this.jLabel12.setText("track name");
        this.jLabel13.setText("tack type");
        this.jPanel6.setBorder(BorderFactory.createEtchedBorder());
        this.buttonGroup2.add(jRadioButton1);
        jRadioButton1.setSelected(true);
        jRadioButton1.setText("bed");
        jRadioButton1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                genome.this.jRadioButton1ActionPerformed(evt);
            }
        });
        this.buttonGroup2.add(jRadioButton2);
        jRadioButton2.setText("wiggle");
        jRadioButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                genome.this.jRadioButton2ActionPerformed(evt);
            }
        });
        this.buttonGroup2.add(jRadioButton3);
        jRadioButton3.setText("combinedWiggle");
        jRadioButton3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                genome.this.jRadioButton3ActionPerformed(evt);
            }
        });
        this.buttonGroup2.add(this.jRadioButton4);
        this.jRadioButton4.setText("refseq housekeeping track");
        this.jRadioButton4.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                genome.this.jRadioButton4ActionPerformed(evt);
            }
        });
        GroupLayout jPanel6Layout = new GroupLayout(this.jPanel6);
        this.jPanel6.setLayout(jPanel6Layout);
        jPanel6Layout.setHorizontalGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel6Layout.createSequentialGroup().addContainerGap().addComponent(jRadioButton1).addGap(30, 30, 30).addComponent(jRadioButton2).addGap(18, 18, 18).addComponent(jRadioButton3).addGap(18, 18, 18).addComponent(this.jRadioButton4).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel6Layout.setVerticalGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(jRadioButton1).addComponent(jRadioButton2).addComponent(jRadioButton3).addComponent(this.jRadioButton4)));
        this.jLabel10.setFont(new Font("Tahoma", 1, 14));
        this.jLabel10.setText("Add DB for tracks");
        this.jLabel17.setText("paste data (track name \"user track\")");
        this.jTextArea1.setColumns(20);
        this.jTextArea1.setRows(5);
        this.jScrollPane3.setViewportView(this.jTextArea1);
        this.jButton13.setText("generate custom track");
        this.jButton13.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                genome.this.jButton13ActionPerformed(evt);
            }
        });
        this.jLabel18.setText("value scale");
        this.jComboBox3.setModel(new DefaultComboBoxModel<String>(new String[]{"logScale", "originalValue"}));
        this.jComboBox3.setEnabled(false);
        this.jLabel1.setText("         ");
        this.jProgressBar1.setForeground(new Color(255, 0, 0));
        GroupLayout jPanel7Layout = new GroupLayout(this.jPanel7);
        this.jPanel7.setLayout(jPanel7Layout);
        jPanel7Layout.setHorizontalGroup(jPanel7Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel7Layout.createSequentialGroup().addGroup(jPanel7Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(GroupLayout.Alignment.LEADING, jPanel7Layout.createSequentialGroup().addGap(239, 239, 239).addComponent(this.jLabel10)).addGroup(GroupLayout.Alignment.LEADING, jPanel7Layout.createSequentialGroup().addGap(72, 72, 72).addGroup(jPanel7Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jProgressBar1, GroupLayout.Alignment.LEADING, -1, 609, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.LEADING, jPanel7Layout.createSequentialGroup().addComponent(this.jLabel17).addGap(98, 98, 98).addComponent(this.jButton13).addGap(18, 18, 18).addComponent(this.jLabel1, -2, 86, -2)).addGroup(GroupLayout.Alignment.LEADING, jPanel7Layout.createSequentialGroup().addComponent(this.jLabel12).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextField7, -2, 175, -2).addGap(18, 18, 18).addComponent(this.jLabel18).addGap(18, 18, 18).addComponent(this.jComboBox3, -2, -1, -2)).addGroup(GroupLayout.Alignment.LEADING, jPanel7Layout.createSequentialGroup().addComponent(this.jLabel11).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jButton19).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextField6, -2, 443, -2)).addGroup(GroupLayout.Alignment.LEADING, jPanel7Layout.createSequentialGroup().addComponent(this.jLabel13).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jPanel6, -2, -1, -2)).addComponent(this.jScrollPane3, GroupLayout.Alignment.LEADING, -2, 499, -2)).addGap(41, 41, 41))).addContainerGap()));
        jPanel7Layout.setVerticalGroup(jPanel7Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel7Layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel10).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel7Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel13).addComponent(this.jPanel6, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel7Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel12).addComponent(this.jLabel18).addComponent(this.jComboBox3, -2, -1, -2).addComponent(this.jTextField7, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel7Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel11).addComponent(this.jButton19).addComponent(this.jTextField6, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel7Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel17).addComponent(this.jLabel1).addComponent(this.jButton13)).addGap(3, 3, 3).addComponent(this.jProgressBar1, -2, 5, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane3, -2, 234, -2).addGap(70, 70, 70)));
        GroupLayout jPanel5Layout = new GroupLayout(this.jPanel5);
        this.jPanel5.setLayout(jPanel5Layout);
        jPanel5Layout.setHorizontalGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel5Layout.createSequentialGroup().addGap(49, 49, 49).addComponent(this.jPanel7, -2, -1, -2).addContainerGap(321, Short.MAX_VALUE)));
        jPanel5Layout.setVerticalGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel5Layout.createSequentialGroup().addComponent(this.jPanel7, -2, -1, -2).addContainerGap(218, Short.MAX_VALUE)));
        this.jTabbedPane1.addTab("Add DB Tables", this.jPanel5);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jTabbedPane1));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jTabbedPane1, -1, 718, Short.MAX_VALUE));
        this.pack();
    }

    private boolean read_custom_track() throws ParserConfigurationException, SAXException, IOException, SQLException, ClassNotFoundException, InstantiationException, IllegalAccessException {
        if (this.readXML()) {
            if (IP.equalsIgnoreCase("localhost")) {
                this.jTextField4.setText("localhost");
            } else {
                this.jTextField4.setText(IP);
            }
            this.jTextField8.setText(account);
            this.jPasswordField1.setText(password);
            TableColumn DB_table_Column = this.jTable1.getColumnModel().getColumn(0);
            DB_table_Column.setPreferredWidth(500);
            TableColumn visualColumn = this.jTable1.getColumnModel().getColumn(1);
            JComboBox<String> comboBox = new JComboBox<String>();
            comboBox.addItem("full");
            comboBox.addItem("hide");
            visualColumn.setCellEditor(new DefaultCellEditor(comboBox));
            this.fill_jTable();
            return true;
        }
        JOptionPane.showConfirmDialog(null, "\"track.xml file has error format", "ERROR", -1);
        return false;
    }

    private void fill_jTable() {
        DefaultTableModel model = (DefaultTableModel)this.jTable1.getModel();
        model.setRowCount(0);
        for (custom_track ct : custom_tracks) {
            Object[] str = new String[]{ct.DB, ct.isVisable};
            model.addRow(str);
        }
        Object[] emptyRow = new String[]{"", ""};
        model.addRow(emptyRow);
        this.jTable1.revalidate();
        this.jPanel4.repaint();
    }

    private void readDB_name() {
        try {
            Statement statement = conn.createStatement();
            String SQL = "select table_name from information_schema.tables where table_schema like  'genome'";
            ResultSet resultSet = statement.executeQuery(SQL);
            DB_tables.clear();
            while (resultSet.next()) {
                String table_name = resultSet.getString("table_name");
                DB_tables.add(table_name);
            }
        }
        catch (SQLException ex) {
            JOptionPane.showConfirmDialog(null, "can not get DB table names", "ERROR", -1);
            System.exit(0);
        }
    }

    private void fileCopy(String sourcefile, String destinationFile) throws IOException {
        int c;
        File inputFile = new File(sourcefile);
        File outputFile = new File(destinationFile);
        FileReader in = new FileReader(inputFile);
        FileWriter out = new FileWriter(outputFile);
        while ((c = in.read()) != -1) {
            out.write(c);
        }
        in.close();
        out.close();
    }

    private boolean readXML() throws ParserConfigurationException, SAXException, ClassNotFoundException, InstantiationException, IllegalAccessException, IOException {
        System.out.print("readXML " + xml_filename + "\n");
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = dbf.newDocumentBuilder();
        File file = new File(xml_filename);
        if (!file.exists()) {
            File file_original = new File("track.xml");
            if (!file_original.exists()) {
                JOptionPane.showConfirmDialog(null, "\"track.xml file not exist", "ERROR", -1);
                System.exit(1);
            }
            this.fileCopy("track.xml", xml_filename);
        }
        custom_tracks.clear();
        Document doc = db.parse(file);
        Element docEle = doc.getDocumentElement();
        NodeList DB_info = docEle.getElementsByTagName("DB");
        if (DB_info != null && DB_info.getLength() > 0) {
            Node node = DB_info.item(0);
            if (node.getNodeType() == 1) {
                Element e = (Element)node;
                NodeList IP_List = e.getElementsByTagName("IP");
                NodeList account_List = e.getElementsByTagName("account");
                if (account_List.item(0).getChildNodes().item(0) == null) {
                    return false;
                }
                NodeList password_List = e.getElementsByTagName("password");
                if (password_List.item(0).getChildNodes().item(0) == null) {
                    return false;
                }
                IP = IP_List.item(0).getChildNodes().item(0).getNodeValue();
                account = account_List.item(0).getChildNodes().item(0).getNodeValue();
                password = password_List.item(0).getChildNodes().item(0).getNodeValue();
            }
        } else {
            JOptionPane.showConfirmDialog(null, "DB server IP, account or password error", "ERROR", -1);
            System.exit(1);
        }
        Class.forName("com.mysql.jdbc.Driver").newInstance();
        try {
            conn = DriverManager.getConnection("jdbc:mysql://" + IP + ":3306/genome", account, password);
        }
        catch (SQLException ex) {
            System.out.println("can not connect to Database server IP(" + IP + ")");
            JOptionPane.showConfirmDialog(null, "can not connect to Database server IP(" + IP + ")", "ERROR", -1);
            System.exit(0);
        }
        this.readDB_name();
        NodeList genomeList = docEle.getElementsByTagName("genome");
        if (genomeList != null && genomeList.getLength() > 0) {
            Node node = genomeList.item(0);
            if (node.getNodeType() == 1) {
                Element e = (Element)node;
                NodeList assembly_nameList = e.getElementsByTagName("assembly");
                this.assembly = assembly_nameList.item(0).getChildNodes().item(0).getNodeValue();
                this.jTextField3.setText(this.assembly);
                this.jTextField2.setText(this.assembly);
                this.housekeeping_tableName = "refgene_" + this.assembly + "_housekeeping";
                if (!this.check_housekeeping_track(this.housekeeping_tableName)) {
                    JOptionPane.showConfirmDialog(null, "housekeeping table \"" + this.housekeeping_tableName + "\" not exist", "ERROR", -1);
                    return false;
                }
                if (!this.getChromosomeSize()) {
                    return false;
                }
            }
        } else {
            this.assembly = "hg18";
            this.jTextField3.setText(this.assembly);
            this.jTextField2.setText(this.assembly);
            this.housekeeping_tableName = "refgene_" + this.assembly + "_housekeeping";
            if (!this.check_housekeeping_track(this.housekeeping_tableName)) {
                JOptionPane.showConfirmDialog(null, "housekeeping table \"" + this.housekeeping_tableName + "\" not exist", "ERROR", -1);
                return false;
            }
            if (!this.getChromosomeSize()) {
                return false;
            }
            JOptionPane.showConfirmDialog(null, "genome assembly not assigned, hg18 is assumed", "Warning", -1);
        }
        NodeList locus_info = docEle.getElementsByTagName("locus");
        if (locus_info != null && locus_info.getLength() > 0) {
            Node node = locus_info.item(0);
            if (node.getNodeType() == 1) {
                Element e = (Element)node;
                NodeList chr_List = e.getElementsByTagName("chr");
                NodeList locus_start_List = e.getElementsByTagName("loci_start");
                NodeList locus_stop_List = e.getElementsByTagName("loci_stop");
                chr = chr_List.item(0).getChildNodes().item(0).getNodeValue();
                loci_start = Long.parseLong(locus_start_List.item(0).getChildNodes().item(0).getNodeValue());
                loci_stop = Long.parseLong(locus_stop_List.item(0).getChildNodes().item(0).getNodeValue());
            }
        } else {
            chr = "chr1";
            loci_start = 56101419L;
            loci_stop = 56105806L;
        }
        NodeList browser_info = docEle.getElementsByTagName("browser_size");
        if (browser_info != null && browser_info.getLength() > 0) {
            Node node = browser_info.item(0);
            if (node.getNodeType() == 1) {
                Element e = (Element)node;
                NodeList width_List = e.getElementsByTagName("width");
                NodeList height_List = e.getElementsByTagName("height");
                browser_width = Integer.parseInt(width_List.item(0).getChildNodes().item(0).getNodeValue());
                browser_height = Integer.parseInt(height_List.item(0).getChildNodes().item(0).getNodeValue());
            }
        } else {
            browser_width = 800;
            browser_height = 600;
        }
        this.jTextField5.setText(Integer.toString(browser_width));
        this.jTextField9.setText(Integer.toString(browser_height));
        this.jScrollPane1.setSize(new Dimension(browser_width, browser_height));
        this.jScrollPane1.setPreferredSize(new Dimension(browser_width, browser_height));
        this.jScrollPane1.revalidate();
        UIDefaults uidef = UIManager.getDefaults();
        int scrollbar_width = Integer.parseInt(uidef.get("ScrollBar.width").toString());
        canvas_width = browser_width - scrollbar_width - 1;
        this.jPanel3.setPreferredSize(new Dimension(canvas_width, canvas_height));
        this.jPanel3.setSize(new Dimension(canvas_width, canvas_height));
        this.jPanel3.revalidate();
        NodeList trackList = docEle.getElementsByTagName("track");
        if (trackList != null && trackList.getLength() > 0) {
            for (int i = 0; i < trackList.getLength(); ++i) {
                Node node = trackList.item(i);
                if (node.getNodeType() != 1) continue;
                Element e = (Element)node;
                NodeList DB_nameList = e.getElementsByTagName("DB_table_name");
                NodeList visibleList = e.getElementsByTagName("visible");
                String Current_DB_table_names = DB_nameList.item(0).getChildNodes().item(0).getNodeValue();
                String visible = visibleList.item(0).getChildNodes().item(0).getNodeValue();
                this.add_custom_track(Current_DB_table_names, visible);
            }
        } else {
            JOptionPane.showConfirmDialog(null, "track.xml is empty, go customize to add tracks", "Warning", -1);
        }
        return true;
    }

    public boolean containsIgnoreCase(List<String> l, String s) {
        Iterator<String> it = l.iterator();
        while (it.hasNext()) {
            if (!it.next().equalsIgnoreCase(s)) continue;
            return true;
        }
        return false;
    }

    private void add_custom_track(String Current_DB_table_names, String visible) {
        String[] table_names = Current_DB_table_names.split(",");
        String[] str = table_names[0].split("_");
        String type = "";
        String scaleType = "";
        if (str.length > 1) {
            type = str[str.length - 1];
        }
        if (str.length > 2) {
            scaleType = str[str.length - 2];
        }
        for (int i = 0; i < table_names.length; ++i) {
            str = table_names[i].split("_");
            String type1 = "";
            String scaleType1 = "";
            if (str.length > 1) {
                type1 = str[str.length - 1];
            }
            if (str.length > 2) {
                scaleType1 = str[str.length - 2];
            }
            if (!type.equalsIgnoreCase(type1) || !scaleType.equalsIgnoreCase(scaleType1)) {
                return;
            }
            custom_track current_ct = new custom_track(table_names[0], type, scaleType, visible);
            if (current_ct.type.equalsIgnoreCase("housekeeping") && current_ct.DB.indexOf(this.assembly) <= 0) {
                JOptionPane.showConfirmDialog(null, current_ct.DB + " in xml file is not selected Assembly:" + this.assembly, "ERROR", -1);
                return;
            }
            if (DB_tables.contains(current_ct.DB)) continue;
            return;
        }
        custom_tracks.add(new custom_track(Current_DB_table_names, type, scaleType, visible));
    }

    private void jButton4ActionPerformed(ActionEvent evt) {
        long temp = loci_start;
        loci_start = Math.min((long)chr_size.get(chr).intValue(), loci_start - (long)((int)((double)(loci_stop - loci_start) * 0.1)));
        loci_stop = Math.min((long)chr_size.get(chr).intValue(), loci_stop - (long)((int)((double)(loci_stop - temp) * 0.1)));
        this.refresh_position();
        this.jPanel3.repaint();
    }

    private void jButton5ActionPerformed(ActionEvent evt) {
        long temp = loci_start;
        loci_start = Math.max(1L, loci_start + (long)((int)((double)(loci_stop - loci_start) * 0.1)));
        loci_stop = Math.max(1L, loci_stop + (long)((int)((double)(loci_stop - temp) * 0.1)));
        this.refresh_position();
        this.jPanel3.repaint();
    }

    private void jButton2ActionPerformed(ActionEvent evt) {
        long temp = loci_start;
        loci_start = Math.min((long)chr_size.get(chr).intValue(), loci_start - (long)((int)((double)(loci_stop - loci_start) * 0.95)));
        loci_stop = Math.min((long)chr_size.get(chr).intValue(), loci_stop - (long)((int)((double)(loci_stop - temp) * 0.95)));
        this.refresh_position();
        this.jPanel3.repaint();
    }

    private void jButton3ActionPerformed(ActionEvent evt) {
        long temp = loci_start;
        loci_start = Math.min((long)chr_size.get(chr).intValue(), loci_start - (long)((int)((double)(loci_stop - loci_start) * 0.45)));
        loci_stop = Math.min((long)chr_size.get(chr).intValue(), loci_stop - (long)((int)((double)(loci_stop - temp) * 0.45)));
        this.refresh_position();
        this.jPanel3.repaint();
    }

    private void jButton6ActionPerformed(ActionEvent evt) {
        long temp = loci_start;
        loci_start = Math.max(1L, loci_start + (long)((int)((double)(loci_stop - loci_start) * 0.45)));
        loci_stop = Math.max(1L, loci_stop + (long)((int)((double)(loci_stop - temp) * 0.45)));
        this.refresh_position();
        this.jPanel3.repaint();
    }

    private void jButton7ActionPerformed(ActionEvent evt) {
        long temp = loci_start;
        loci_start = Math.max(1L, loci_start + (long)((int)((double)(loci_stop - loci_start) * 0.95)));
        loci_stop = Math.max(1L, loci_stop + (long)((int)((double)(loci_stop - temp) * 0.95)));
        this.refresh_position();
        this.jPanel3.repaint();
    }

    private void jButton10ActionPerformed(ActionEvent evt) {
        long dist;
        if ((loci_stop += (dist = loci_stop - loci_start + 1L)) - (loci_start -= dist) < 10000000L) {
            this.refresh_position();
            this.jPanel3.repaint();
        } else {
            JOptionPane.showMessageDialog(null, "The Max chromosome region is 10,000,000", "message", -1);
            this.get_loci();
        }
    }

    private void jButton9ActionPerformed(ActionEvent evt) {
        long dist = loci_stop - loci_start + 1L;
        loci_stop -= (long)((int)((double)dist * 0.45));
        loci_stop = Math.max((loci_start += (long)((int)((double)dist * 0.45))) + 1L, loci_stop);
        this.refresh_position();
        this.jPanel3.repaint();
    }

    private void jButton8ActionPerformed(ActionEvent evt) {
        long dist = loci_stop - loci_start + 1L;
        loci_stop -= (long)((int)(dist / 3L));
        loci_stop = Math.max((loci_start += (long)((int)(dist / 3L))) + 1L, loci_stop);
        this.refresh_position();
        this.jPanel3.repaint();
    }

    private void jButton11ActionPerformed(ActionEvent evt) {
        long dist;
        if ((loci_stop += (long)((int)((double)(dist = loci_stop - loci_start + 1L) * 4.5))) - (loci_start -= (long)((int)((double)dist * 4.5))) < 10000000L) {
            this.refresh_position();
            this.jPanel3.repaint();
        } else {
            JOptionPane.showMessageDialog(null, "The Max chromosome region is 10,000,000", "message", -1);
            this.get_loci();
        }
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        if (this.get_loci() && this.getGeneSymbol()) {
            this.refresh_position();
            this.jPanel3.repaint();
        }
    }

    private void jPanel3mousePressed(MouseEvent evt) {
        rect_x1 = evt.getX();
        rect_y1 = evt.getY();
        if (rect_y1 < 30 || rect_x1 < LEFT_MARGIN) {
            inDrag = true;
        }
        if (rect_y1 >= 30 && rect_x1 < LEFT_MARGIN) {
            this.movingTrack = mouseStoppedTrack;
        }
    }

    private void jPanel3mouseReleased(MouseEvent evt) {
        if (inDrag) {
            inDrag = false;
            if (rect_y1 < 30 && rect_x1 >= LEFT_MARGIN) {
                long dist = loci_stop - loci_start;
                long orig_loci_start = loci_start;
                long pre_loci_start = loci_start;
                long pre_loci_stop = loci_stop;
                loci_start = (long)((double)dist * (double)(rect_x1 - LEFT_MARGIN) / (double)(this.jPanel3.getWidth() - LEFT_MARGIN) + (double)orig_loci_start);
                loci_stop = (long)((double)dist * (double)(rect_x2 - LEFT_MARGIN) / (double)(this.jPanel3.getWidth() - LEFT_MARGIN) + (double)orig_loci_start);
                if (loci_stop > loci_start) {
                    this.refresh_position();
                } else {
                    loci_start = pre_loci_start;
                    loci_stop = pre_loci_stop;
                }
                drag_region = null;
                this.jPanel3.repaint();
            }
        }
    }

    private void jPanel3mouseDragged(MouseEvent evt) {
        if (inDrag) {
            inDrag = false;
            rect_x2 = evt.getX();
            rect_y2 = evt.getY();
            if (rect_y1 < 30 && rect_x1 >= LEFT_MARGIN) {
                Rectangle rect = new Rectangle(rect_x1, 1, rect_x2 - rect_x1, this.jPanel1.getHeight());
                drag_region = new myBufferedImage(this.jPanel3.getWidth(), this.jPanel3.getHeight(), 2, rect);
                this.jPanel3.repaint();
            }
            if (rect_y1 >= 30 && rect_x1 < LEFT_MARGIN) {
                for (int track_no = 1; track_no < track_image_lst.size(); ++track_no) {
                    int y_pos = genome.track_image_lst.get((int)0).rect.height;
                    for (int up_track_no = 1; up_track_no < track_no; ++up_track_no) {
                        y_pos += genome.track_image_lst.get((int)up_track_no).rect.height;
                    }
                    track_image key = track_image_lst.get(track_no);
                    int trigger_y = y_pos;
                    if (rect_y2 > rect_y1) {
                        trigger_y = key.rect.height + y_pos;
                    }
                    if (rect_y2 < trigger_y || rect_y2 > trigger_y + 5) continue;
                    if (track_no == this.movingTrack) break;
                    track_image tmp = new track_image(track_image_lst.get(this.movingTrack));
                    track_image_lst.set(this.movingTrack, track_image_lst.get(track_no));
                    track_image_lst.set(track_no, tmp);
                    y_pos = genome.track_image_lst.get((int)0).rect.height;
                    for (int up_track_no = 1; up_track_no < track_no; ++up_track_no) {
                        y_pos += genome.track_image_lst.get((int)up_track_no).rect.height;
                    }
                    key = track_image_lst.get(track_no);
                    Rectangle lefted_rect = new Rectangle(key.rect.x, key.rect.y + y_pos, key.rect.width, key.rect.height);
                    drag_region = new myBufferedImage(canvas_width, canvas_height, 2, lefted_rect);
                    this.jPanel3.repaint();
                    this.jTableExchange(this.trackNo2tableNo(this.movingTrack - 1), this.trackNo2tableNo(track_no - 1));
                    this.writeXML();
                    this.movingTrack = track_no;
                    break;
                }
            }
            inDrag = true;
        }
    }

    private int trackNo2tableNo(int number) {
        DefaultTableModel model = (DefaultTableModel)this.jTable1.getModel();
        int number_full = -1;
        for (int i = 0; i < model.getRowCount(); ++i) {
            String visual = (String)model.getValueAt(i, 1);
            if (visual.equals("full")) {
                ++number_full;
            }
            if (number_full != number) continue;
            return i;
        }
        return -1;
    }

    private void jButton15ActionPerformed(ActionEvent evt) {
        int selectRow = this.jTable1.getSelectedRow();
        if (selectRow > 0) {
            this.jTableExchange(selectRow - 1, selectRow);
            this.jTable1.changeSelection(selectRow - 1, 0, false, false);
        }
    }

    private void jButton16ActionPerformed(ActionEvent evt) {
        int selectRow = this.jTable1.getSelectedRow();
        if (selectRow < this.jTable1.getRowCount() - 1) {
            this.jTableExchange(selectRow + 1, selectRow);
            this.jTable1.changeSelection(selectRow + 1, 0, false, false);
        }
    }

    private void jTableExchange(int from, int to) {
        DefaultTableModel model = (DefaultTableModel)this.jTable1.getModel();
        String from_tableName = (String)model.getValueAt(from, 0);
        String from_visual = (String)model.getValueAt(from, 1);
        String to_tableName = (String)model.getValueAt(to, 0);
        String to_visual = (String)model.getValueAt(to, 1);
        model.setValueAt(from_tableName, to, 0);
        model.setValueAt(from_visual, to, 1);
        model.setValueAt(to_tableName, from, 0);
        model.setValueAt(to_visual, from, 1);
    }

    private void jTableAdd(String DB_name, String full_or_hide) {
        String tableName;
        int i;
        DefaultTableModel model = (DefaultTableModel)this.jTable1.getModel();
        for (i = 0; i < model.getRowCount(); ++i) {
            tableName = (String)model.getValueAt(i, 0);
            if (!DB_name.equalsIgnoreCase(tableName)) continue;
            return;
        }
        for (i = model.getRowCount() - 1; i > 0; --i) {
            tableName = (String)model.getValueAt(i - 1, 0);
            String visual = (String)model.getValueAt(i - 1, 1);
            model.setValueAt(tableName, i, 0);
            model.setValueAt(visual, i, 1);
        }
        model.setValueAt(DB_name, 0, 0);
        model.setValueAt(full_or_hide, 0, 1);
    }

    private void jButton17ActionPerformed(ActionEvent evt) {
        if (!this.isIntNumber(this.jTextField5.getText())) {
            this.jTextField5.setText("800");
            return;
        }
        browser_width = Integer.parseInt(this.jTextField5.getText());
        browser_height = Integer.parseInt(this.jTextField9.getText());
        this.jScrollPane1.setSize(new Dimension(browser_width, browser_height));
        this.jScrollPane1.setPreferredSize(new Dimension(browser_width, browser_height));
        this.jScrollPane1.revalidate();
        UIDefaults uidef = UIManager.getDefaults();
        int scrollbar_width = Integer.parseInt(uidef.get("ScrollBar.width").toString());
        canvas_width = browser_width - scrollbar_width - 1;
        this.jPanel3.setPreferredSize(new Dimension(canvas_width, canvas_height));
        this.jPanel3.setSize(new Dimension(canvas_width, canvas_height));
        this.jPanel3.revalidate();
        this.writeXML();
        this.refresh_position();
        this.jPanel3.repaint();
    }

    private boolean isIntNumber(String num) {
        try {
            Integer.parseInt(num);
        }
        catch (NumberFormatException nfe) {
            return false;
        }
        return true;
    }

    private void writeXML() {
        IP = this.jTextField4.getText();
        account = this.jTextField8.getText();
        password = new String(this.jPasswordField1.getPassword());
        this.assembly = this.jTextField3.getText();
        this.jTextField2.setText(this.assembly);
        DefaultTableModel model = (DefaultTableModel)this.jTable1.getModel();
        custom_tracks.clear();
        for (int i = 0; i < model.getRowCount(); ++i) {
            String tableName = (String)model.getValueAt(i, 0);
            String visual = (String)model.getValueAt(i, 1);
            this.add_custom_track(tableName, visual);
        }
        try {
            BufferedWriter bw = new BufferedWriter(new FileWriter(xml_filename));
            bw.write("<?xml version=\"1.0\"?>\n");
            bw.write("<tracks>\n");
            bw.write("\t<DB>\n");
            bw.write("\t\t<IP>");
            bw.write(IP);
            bw.write("</IP>\n");
            bw.write("\t\t<account>");
            bw.write(account);
            bw.write("</account>\n");
            bw.write("\t\t<password>");
            bw.write(password);
            bw.write("</password>\n");
            bw.write("\t</DB>\n");
            bw.write("\t<genome>\n");
            bw.write("\t\t<assembly>");
            bw.write(this.assembly);
            bw.write("</assembly>\n");
            bw.write("\t</genome>\n");
            bw.write("\t<locus>\n");
            bw.write("\t\t<chr>");
            bw.write(chr);
            bw.write("</chr>\n");
            bw.write("\t\t<loci_start>");
            bw.write(Long.toString(loci_start));
            bw.write("</loci_start>\n");
            bw.write("\t\t<loci_stop>");
            bw.write(Long.toString(loci_stop));
            bw.write("</loci_stop>\n");
            bw.write("\t</locus>\n");
            bw.write("\t<browser_size>\n");
            bw.write("\t\t<width>");
            bw.write(Integer.toString(browser_width));
            bw.write("</width>\n");
            bw.write("\t\t<height>");
            bw.write(Integer.toString(browser_height));
            bw.write("</height>\n");
            bw.write("\t</browser_size>\n");
            for (custom_track ct : custom_tracks) {
                bw.write("\t<track>\n");
                bw.write("\t\t<DB_table_name>");
                bw.write(ct.DB);
                bw.write("</DB_table_name>\n");
                bw.write("\t\t<visible>");
                bw.write(ct.isVisable);
                bw.write("</visible>\n");
                bw.write("\t</track>\n");
            }
            bw.write("</tracks>\n");
            bw.close();
        }
        catch (IOException ex) {
            System.err.print(genome.class.getName() + ":" + ex.toString());
            Logger.getLogger(genome.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void jButton19ActionPerformed(ActionEvent evt) {
        JFileChooser fc = new JFileChooser();
        fc.setCurrentDirectory(new File("."));
        int returnVal = fc.showOpenDialog(this);
        if (returnVal == 0) {
            File file = fc.getSelectedFile();
            this.jTextField6.setText(file.getPath());
        } else {
            this.jTextField6.setText("");
        }
    }

    private void jButton12ActionPerformed(ActionEvent evt) {
        int more = JOptionPane.showConfirmDialog(null, "remove strips?", "Input", 1);
        if (more == 2) {
            return;
        }
        if (more == 0) {
            hasStrip = false;
            this.refresh_position();
            this.jPanel3.repaint();
        }
        int w = this.jPanel3.getWidth() - LEFT_MARGIN;
        int h = this.jPanel3.getHeight();
        BufferedImage bi = new BufferedImage(w, h, 1);
        Graphics2D g2 = bi.createGraphics();
        this.jPanel3.paint(g2);
        g2.dispose();
        try {
            ImageIO.write((RenderedImage)bi, "png", new File("image.png"));
            JOptionPane.showMessageDialog(null, "A image is stored in working_dir/image.png", "message", -1);
        }
        catch (IOException ioe) {
            System.out.println("Panel write help: " + ioe.getMessage());
        }
        hasStrip = true;
        if (more == 0) {
            this.jPanel3.repaint();
        }
    }

    private String DB_plus_ext(String DB_name) {
        String result = "";
        if (jRadioButton1.isSelected()) {
            result = DB_name + "_" + jRadioButton1.getText();
        }
        if (jRadioButton2.isSelected()) {
            result = DB_name + "_" + this.jComboBox3.getSelectedItem() + "_" + jRadioButton2.getText();
        }
        if (jRadioButton3.isSelected()) {
            result = DB_name + "_" + this.jComboBox3.getSelectedItem() + "_" + jRadioButton3.getText();
        }
        if (this.jRadioButton4.isSelected()) {
            result = DB_name + "_" + "housekeeping";
        }
        if (this.OS_name.toLowerCase().indexOf("linux") < 0) {
            result = result.toLowerCase();
        }
        return result;
    }

    private void jButton13ActionPerformed(ActionEvent evt) {
        this.jProgressBar1.setValue(0);
        String datafilename = this.jTextField6.getText();
        String DB_name = this.jTextField7.getText();
        if (DB_name.isEmpty()) {
            DB_name = "user_track";
        } else {
            String regularExpression = "([a-zA-Z])([a-zA-Z0-9_]*)";
            if (!Pattern.matches(regularExpression, DB_name)) {
                JOptionPane.showConfirmDialog(null, "DB table name not acceptable (\".\" or \"-\" is not allowed)", "ERROR", -1);
                return;
            }
        }
        if (this.jRadioButton4.isSelected() && !DB_name.startsWith("refgene_")) {
            JOptionPane.showMessageDialog(null, "housekeeping track name is like \"refgene_hg18\" or \"refgene_hg18\"", "message", -1);
            this.jTextField7.setText("refgene_");
            return;
        }
        if (this.refuse_delete_existing_table(DB_name = this.DB_plus_ext(DB_name))) {
            return;
        }
        boolean header = false;
        if (datafilename.isEmpty()) {
            try {
                datafilename = "__tmp_textArea";
                BufferedWriter bw = new BufferedWriter(new FileWriter(datafilename));
                String data = this.jTextArea1.getText();
                String[] line = data.split("\n");
                for (int i = 0; i < line.length; ++i) {
                    bw.write(line[i] + "\n");
                }
                bw.close();
                header = false;
            }
            catch (IOException ex) {
                JOptionPane.showMessageDialog(null, "failed to write temperate file in working directory", "message", -1);
                return;
            }
        } else {
            int more = JOptionPane.showConfirmDialog(null, "Is the 1st row header?", "Input", 1);
            if (more == 0) {
                header = true;
            } else if (more == 1) {
                header = false;
            } else {
                return;
            }
        }
        this.fill_data(DB_name, datafilename, header);
    }

    private boolean fill_data(String DB_name, String datafilename, boolean hasHeader) {
        try {
            BufferedReader in = new BufferedReader(new FileReader(datafilename));
            String line = in.readLine();
            in.close();
            if (this.create_DB(DB_name, line.split("\\t|\\s+").length)) {
                this.DB_name_for_fill_DB = DB_name;
                this.datafilename_for_fill_DB = datafilename;
                this.hasHeader_for_fill_DB = hasHeader;
                this.progressBar_task = new progressBar_task();
                this.progressBar_task.addPropertyChangeListener(this);
                this.progressBar_task.execute();
            }
        }
        catch (Exception ex) {
            System.err.print(genome.class.getName() + ":" + ex.toString());
            Logger.getLogger(genome.class.getName()).log(Level.SEVERE, null, ex);
            return false;
        }
        return true;
    }

    private String track_type(String DB_name) {
        String[] files = DB_name.split(",");
        String[] str = files[0].split("_");
        String type = "";
        if (str.length > 1) {
            type = str[str.length - 1];
        }
        for (int i = 1; i < files.length; ++i) {
            str = files[i].split("_");
            if (str.length > 1) {
                if (type.equalsIgnoreCase(str[str.length - 1])) continue;
                return "";
            }
            return "";
        }
        return type;
    }

    private void jButton14ActionPerformed(ActionEvent evt) {
        int selectRow = this.jTable1.getSelectedRow();
        if (selectRow < 0) {
            JOptionPane.showConfirmDialog(null, "select a row to add", "ERROR", -1);
            return;
        }
        String[] list = DB_tables.toArray(new String[DB_tables.size()]);
        JComboBox<String> jcb = new JComboBox<String>(list);
        jcb.setEditable(true);
        int rtn = JOptionPane.showConfirmDialog(null, jcb, "select or input a DB table name", 2);
        if (rtn != 0) {
            return;
        }
        DefaultTableModel model = (DefaultTableModel)this.jTable1.getModel();
        String tableNames = (String)model.getValueAt(selectRow, 0);
        String new_DB_table = (String)jcb.getSelectedItem();
        String[] table_names = tableNames.split(",");
        for (int i = 0; i < table_names.length; ++i) {
            if (!table_names[i].equalsIgnoreCase(new_DB_table)) continue;
            JOptionPane.showConfirmDialog(null, "already exist", "ERROR", -1);
            return;
        }
        if (tableNames.isEmpty()) {
            custom_track ct = this.covert2custom_track(new_DB_table);
            if (ct.type.equalsIgnoreCase("housekeeping") && ct.DB.indexOf(this.assembly) <= 0) {
                JOptionPane.showConfirmDialog(null, ct.DB + " is not selected Assembly:" + this.assembly, "ERROR", -1);
                return;
            }
            model.setValueAt(new_DB_table, selectRow, 0);
            model.setValueAt("full", selectRow, 1);
            Object[] str = new String[]{"", ""};
            model.addRow(str);
        } else {
            custom_track ct = this.covert2custom_track(new_DB_table);
            if (this.track_type(tableNames).equalsIgnoreCase("wiggle") && ct.type.equalsIgnoreCase("wiggle")) {
                model.setValueAt(tableNames + "," + new_DB_table, selectRow, 0);
            } else {
                JOptionPane.showConfirmDialog(null, "only wiggle tracks allow to overlay", "ERROR", -1);
            }
        }
    }

    private void jButton18ActionPerformed(ActionEvent evt) {
        int selectRow = this.jTable1.getSelectedRow();
        if (selectRow < 0) {
            JOptionPane.showConfirmDialog(null, "select a row to remove", "ERROR", -1);
            return;
        }
        DefaultTableModel model = (DefaultTableModel)this.jTable1.getModel();
        for (int i = selectRow; i < this.jTable1.getRowCount() - 1; ++i) {
            String next_tableName = (String)model.getValueAt(i + 1, 0);
            String next_visual = (String)model.getValueAt(i + 1, 1);
            model.setValueAt(next_tableName, i, 0);
            model.setValueAt(next_visual, i, 1);
        }
        model.removeRow(this.jTable1.getRowCount() - 1);
        if (model.getRowCount() == 0) {
            Object[] str = new String[]{"", ""};
            model.addRow(str);
        }
    }

    private void keypressed(KeyEvent evt) {
        if (evt.getKeyChar() == '\n') {
            // empty if block
        }
    }

    private void jRadioButton1ActionPerformed(ActionEvent evt) {
        this.jComboBox3.setSelectedIndex(0);
        this.jComboBox3.setEnabled(false);
    }

    private void jRadioButton2ActionPerformed(ActionEvent evt) {
        this.jComboBox3.setSelectedIndex(1);
        this.jComboBox3.setEnabled(true);
    }

    private void jRadioButton3ActionPerformed(ActionEvent evt) {
        this.jComboBox3.setSelectedIndex(0);
        this.jComboBox3.setEnabled(true);
    }

    private void jButton21ActionPerformed(ActionEvent evt) {
        File file = new File(this.jTextField2.getText());
        if (!file.exists() || !file.isDirectory()) {
            JOptionPane.showConfirmDialog(null, "assembly " + this.jTextField2.getText() + " sequence is not available", "ERROR", -1);
            return;
        }
        if (this.get_loci()) {
            if (loci_stop - loci_start > 100000L) {
                JOptionPane.showConfirmDialog(null, "Tha Maximum length is 100000", "ERROR", -1);
                return;
            }
            try {
                String seq = genomeSearch.getSubseq((String)chr, (String)"+", (int)((int)loci_start), (int)((int)loci_stop));
                int str_length = seq.length();
                String str = this.jTextField1.getText() + " Length=(" + str_length + ")\n" + "Strand +\n" + seq + "\n";
                str = str + "Strand -\n" + genomeSearch.getSubseq((String)chr, (String)"-", (int)((int)loci_start), (int)((int)loci_stop)) + "\n";
                GenomeLite.popup.jTextArea1.setText(str);
                popup.setVisible(true);
            }
            catch (FileNotFoundException ex) {
                JOptionPane.showConfirmDialog(null, "<html><center>hg18 sequence file not found.</center> <center> download hg18.zip and unzip it in working directory</center><html>", "ERROR", -1);
            }
            catch (IOException ex) {
                JOptionPane.showConfirmDialog(null, "error in reading hg18 sequence file", "ERROR", -1);
            }
        }
    }

    private void jButton22ActionPerformed(ActionEvent evt) {
        File file = new File(this.jTextField2.getText());
        if (!file.exists() || !file.isDirectory()) {
            JOptionPane.showConfirmDialog(null, "assembly " + this.jTextField2.getText() + " sequence is not available", "ERROR", -1);
            return;
        }
        if (this.get_loci()) {
            if (loci_stop - loci_start > 1000L) {
                JOptionPane.showConfirmDialog(null, "The Maximum length is 1000", "ERROR", -1);
                return;
            }
            try {
                String seq = genomeSearch.getSubseq((String)chr, (String)"+", (int)((int)loci_start), (int)((int)loci_stop));
                int str_length = seq.length();
                String str = this.jTextField1.getText() + " Length=(" + str_length + ")\n" + "Strand +\n";
                str = str + seq.replace("t", "u") + "\n";
                RNAfold RNAfold2 = new RNAfold(seq);
                str = str + RNAfold2.getStruct() + "\nMFE=" + RNAfold2.getMFE() + "\n\n";
                seq = genomeSearch.getSubseq((String)chr, (String)"-", (int)((int)loci_start), (int)((int)loci_stop));
                str = str + seq.replace("t", "u") + "\n";
                RNAfold RNAfold1 = new RNAfold(seq);
                str = str + "Strand -\n" + RNAfold1.getStruct() + "\nMFE=" + RNAfold1.getMFE() + "\n";
                GenomeLite.popup.jTextArea1.setText(str);
                popup.setVisible(true);
            }
            catch (FileNotFoundException ex) {
                JOptionPane.showConfirmDialog(null, "<html><center>hg18 sequence file not found.</center> <center> download hg18.zip and unzip it in working directory</center><html>", "ERROR", -1);
            }
            catch (IOException ex) {
                JOptionPane.showConfirmDialog(null, "error in reading hg18 sequence file", "ERROR", -1);
            }
        }
    }

    private void mouseEntered_DNA(MouseEvent evt) {
        ToolTipManager.sharedInstance().setEnabled(true);
    }

    private void mouseEnter_RNA(MouseEvent evt) {
        ToolTipManager.sharedInstance().setEnabled(true);
    }

    private void jRadioButton4ActionPerformed(ActionEvent evt) {
        this.jTextField7.setText("refgene_");
        this.jComboBox3.setSelectedIndex(0);
        this.jComboBox3.setEnabled(false);
    }

    private String get_combined_columns(String line, int rec_no) {
        int i;
        String[] field = line.split("\\t|\\s+");
        String result = "";
        if (jRadioButton1.isSelected()) {
            if (field.length != 6 && field.length != 9 && field.length != 12) {
                JOptionPane.showConfirmDialog(null, "wrong number of column: " + field.length + "(bed file has 6,9 or 12 column) in line no." + rec_no, "ERROR", -1);
                return "";
            }
            if (!this.isDecentChrName(field[0])) {
                JOptionPane.showConfirmDialog(null, "the first column is not chromosome name in line no." + rec_no, "ERROR", -1);
                return "";
            }
            if (!field[5].equals("+") && !field[5].equals("-")) {
                JOptionPane.showConfirmDialog(null, "the sixth column is not strand \"+\" or \"-\" in line no." + rec_no, "ERROR", -1);
                return "";
            }
            if (field.length > 6 && !this.isDecentColorCode(field[8])) {
                JOptionPane.showConfirmDialog(null, "the nineth column is RGB code (such as 255,255,255) in line no." + rec_no, "ERROR", -1);
                return "";
            }
            if (this.is_bed_varchar[0] == 1) {
                result = "'" + field[0] + "'";
            } else {
                if (!genome.isNumeric(field[0])) {
                    JOptionPane.showConfirmDialog(null, "column 0 must be a number in line no." + rec_no, "ERROR", -1);
                    return "";
                }
                result = field[0];
            }
            for (i = 1; i < field.length; ++i) {
                if (this.is_bed_varchar[i] == 1) {
                    result = result + "\t'" + field[i] + "'";
                    continue;
                }
                if (!genome.isNumeric(field[i])) {
                    JOptionPane.showConfirmDialog(null, "column " + i + " must be a number in line no." + rec_no, "ERROR", -1);
                    return "";
                }
                result = result + "\t" + field[i];
            }
        }
        if (jRadioButton2.isSelected()) {
            String[] new_field = new String[7];
            if (field.length == 4) {
                new_field[0] = Double.toString(Math.abs(Double.parseDouble(field[3])));
                new_field[1] = field[0];
                new_field[2] = "+";
                new_field[3] = field[1];
                new_field[4] = field[2];
                new_field[5] = field[3];
                new_field[6] = bedgraph_auto_assign_color;
            } else {
                if (field.length != 7) {
                    JOptionPane.showConfirmDialog(null, "wrong number of column:" + field.length + "(wiggle file has 7 columns) in line no." + rec_no, "ERROR", -1);
                    return "";
                }
                new_field[0] = field[0];
                new_field[1] = field[1];
                new_field[2] = field[2];
                new_field[3] = field[3];
                new_field[4] = field[4];
                new_field[5] = field[5];
                new_field[6] = field[6];
            }
            if (!this.isDecentChrName(new_field[1])) {
                JOptionPane.showConfirmDialog(null, "the second column is not chromosome name in line no." + rec_no, "ERROR", -1);
                return "";
            }
            if (!new_field[2].equals("+") && !new_field[2].equals("-")) {
                JOptionPane.showConfirmDialog(null, "the second column is not strand \"+\" or \"-\" in line no." + rec_no, "ERROR", -1);
                return "";
            }
            if (!this.isDecentColorCode(new_field[6])) {
                JOptionPane.showConfirmDialog(null, "the 7th column is RGB code (such as 255,255,255) in line no." + rec_no, "ERROR", -1);
                return "";
            }
            if (this.is_wig_varchar[0] == 1) {
                result = "'" + new_field[0] + "'";
            } else {
                if (!genome.isNumeric(new_field[0])) {
                    JOptionPane.showConfirmDialog(null, "column 0 must be a number in line no." + rec_no, "ERROR", -1);
                    return "";
                }
                result = new_field[0];
            }
            for (int i2 = 1; i2 < this.wig_col.length; ++i2) {
                if (this.is_wig_varchar[i2] == 1) {
                    result = result + "\t'" + new_field[i2] + "'";
                    continue;
                }
                if (!genome.isNumeric(new_field[i2])) {
                    JOptionPane.showConfirmDialog(null, "column " + i2 + " must be a number in line no." + rec_no, "ERROR", -1);
                    return "";
                }
                result = result + "\t" + new_field[i2];
            }
        }
        if (jRadioButton3.isSelected()) {
            if (!this.isDecentChrName(field[1])) {
                JOptionPane.showConfirmDialog(null, "the second column is not chromosome name in line no." + rec_no, "ERROR", -1);
                return "";
            }
            if (!field[2].equals("+") && !field[2].equals("-")) {
                JOptionPane.showConfirmDialog(null, "the second column is not strand \"+\" or \"-\" in line no." + rec_no, "ERROR", -1);
                return "";
            }
            if (field.length != 6) {
                JOptionPane.showConfirmDialog(null, "wrong number of column:" + field.length + "(combinedWiggle has 6 columns) in line no." + rec_no, "ERROR", -1);
                return "";
            }
            if (this.is_combinedwig_varchar[0] == 1) {
                result = "'" + field[0] + "'";
            } else {
                if (!genome.isNumeric(field[0])) {
                    JOptionPane.showConfirmDialog(null, "column 0 must be a number in line no." + rec_no, "ERROR", -1);
                    return "";
                }
                result = field[0];
            }
            for (i = 1; i < this.combinedwig_col.length; ++i) {
                if (this.is_combinedwig_varchar[i] == 1) {
                    result = result + "\t'" + field[i] + "'";
                    continue;
                }
                if (!genome.isNumeric(field[i])) {
                    JOptionPane.showConfirmDialog(null, "column " + i + " must be a number in line no." + rec_no, "ERROR", -1);
                    return "";
                }
                result = result + "\t" + field[i];
            }
        }
        if (this.jRadioButton4.isSelected()) {
            if (!field[3].equals("+") && !field[3].equals("-")) {
                JOptionPane.showConfirmDialog(null, "the third column is not strand \"+\" or \"-\" in line no." + rec_no, "ERROR", -1);
                return "";
            }
            if (field.length != 16) {
                JOptionPane.showConfirmDialog(null, "wrong number of column:" + field.length + "(combinedWiggle has 16 columns) in line no." + rec_no, "ERROR", -1);
                return "";
            }
            if (this.is_refseq_hosuekeeping_varchar[0] == 1) {
                result = "'" + field[0] + "'";
            } else {
                if (!genome.isNumeric(field[0])) {
                    JOptionPane.showConfirmDialog(null, "column 0 must be a number in line no." + rec_no, "ERROR", -1);
                    return "";
                }
                result = field[0];
            }
            for (i = 1; i < this.refseq_hosuekeeping_col.length; ++i) {
                if (this.is_refseq_hosuekeeping_varchar[i] == 1) {
                    result = result + "\t'" + field[i] + "'";
                    continue;
                }
                if (!genome.isNumeric(field[i])) {
                    JOptionPane.showConfirmDialog(null, "column " + i + " must be a number in line no." + rec_no, "ERROR", -1);
                    return "";
                }
                result = result + "\t" + field[i];
            }
        }
        return result;
    }

    private boolean insert_one_row(String DB_name, String line, int rec_no) throws SQLException {
        line = line.replace("\"", "");
        line = line.replace("'", "");
        if ((line = line.trim()).isEmpty()) {
            return true;
        }
        String col_part = this.get_combined_columns(line, rec_no);
        Statement statement = conn.createStatement();
        String SQL = "insert into " + DB_name + " values (" + col_part.replace("\t", ",") + ")";
        statement.execute(SQL);
        return true;
    }

    public static boolean isNumeric(String string) {
        return string.matches("^[-+]?\\d+(\\.\\d+)?$");
    }

    private boolean create_DB(String DB_name, int numCol) {
        try {
            int i;
            Statement statement = conn.createStatement();
            String col_part = "";
            String index = "";
            if (jRadioButton1.isSelected()) {
                if (numCol != 6 && numCol != 9 && numCol != 12) {
                    JOptionPane.showConfirmDialog(null, "number of columns (" + numCol + ") is not correct for bed file(6,9,12)", "ERROR", -1);
                    return false;
                }
                col_part = this.bed_col[0];
                for (i = 1; i < numCol; ++i) {
                    col_part = col_part + "," + this.bed_col[i];
                }
                index = this.bed_index;
            }
            if (jRadioButton2.isSelected()) {
                if (numCol != 4 && numCol != this.wig_col.length) {
                    JOptionPane.showConfirmDialog(null, "number of columns (" + numCol + " is not correct for wiggle file(" + this.wig_col.length + ")", "ERROR", -1);
                    return false;
                }
                if (numCol == 4) {
                    this.get_auto_assign_Color();
                    if (bedgraph_auto_assign_color == null) {
                        return false;
                    }
                }
                col_part = this.wig_col[0];
                for (i = 1; i < this.wig_col.length; ++i) {
                    col_part = col_part + "," + this.wig_col[i];
                }
                index = this.wig_index;
            }
            if (jRadioButton3.isSelected()) {
                if (numCol != this.combinedwig_col.length) {
                    JOptionPane.showConfirmDialog(null, "number of columns (" + numCol + " is not correct for combinedwig file(" + this.combinedwig_col.length + ")", "ERROR", -1);
                    return false;
                }
                col_part = this.combinedwig_col[0];
                for (i = 1; i < this.combinedwig_col.length; ++i) {
                    col_part = col_part + "," + this.combinedwig_col[i];
                }
                index = this.combinedWig_index;
            }
            if (this.jRadioButton4.isSelected()) {
                if (numCol != this.refseq_hosuekeeping_col.length) {
                    JOptionPane.showConfirmDialog(null, "number of columns (" + numCol + " is not correct for refseq_hosuekeeping file(" + this.refseq_hosuekeeping_col.length + ")", "ERROR", -1);
                    return false;
                }
                col_part = this.refseq_hosuekeeping_col[0];
                for (i = 1; i < this.refseq_hosuekeeping_col.length; ++i) {
                    col_part = col_part + "," + this.refseq_hosuekeeping_col[i];
                }
                index = this.refseq_hosuekeeping_index;
            }
            String SQL = "create table " + DB_name + "(" + col_part + "," + index + ")engine=MyISAM";
            statement.execute(SQL);
            DB_tables.add(0, DB_name);
            return true;
        }
        catch (SQLException ex) {
            JOptionPane.showMessageDialog(null, "create DB table \"" + DB_name + "\" failed", "message", -1);
            return false;
        }
    }

    private boolean check_housekeeping_track(String table_name) {
        try {
            Statement statement = conn.createStatement();
            String SQL = "select table_name from information_schema.tables where table_schema like  'genome' and table_name = '" + table_name + "'";
            ResultSet resultSet = statement.executeQuery(SQL);
            if (resultSet.isLast()) {
                JOptionPane.showConfirmDialog(null, "please create refseq housekeeping table named \"refgene_hg18(or hg19)_housekeeping\"", "alert", -1);
                return false;
            }
        }
        catch (SQLException ex) {
            System.err.print(genome.class.getName() + ":" + ex.toString());
            Logger.getLogger(genome.class.getName()).log(Level.SEVERE, null, ex);
        }
        return true;
    }

    private boolean refuse_delete_existing_table(String DB_name) {
        String SQL = "";
        try {
            Statement statement = conn.createStatement();
            SQL = "select table_name from information_schema.tables where table_schema like  'genome'";
            ResultSet resultSet = statement.executeQuery(SQL);
            while (resultSet.next()) {
                String table_name = resultSet.getString("table_name");
                if (!table_name.equalsIgnoreCase(DB_name)) continue;
                int more = JOptionPane.showConfirmDialog(null, "already exist, overwrite it?", "Input", 1);
                if (more == 0) {
                    SQL = "drop table " + table_name;
                    statement.execute(SQL);
                    DB_tables.remove(table_name);
                    return false;
                }
                return true;
            }
        }
        catch (SQLException ex) {
            JOptionPane.showMessageDialog(null, "\"genome\" DB missing or " + SQL + " error", "message", -1);
        }
        return false;
    }

    private boolean getGeneSymbol() {
        if (this.assembly.isEmpty()) {
            return false;
        }
        geneSymbol = (String)this.jComboBox2.getSelectedItem();
        if (geneSymbol != null && !geneSymbol.isEmpty()) {
            try {
                Statement statement = conn.createStatement();
                String SQL = "select chrom,txStart,txEnd from refgene_" + this.assembly + "_housekeeping where name2='" + geneSymbol + "'";
                ResultSet resultSet = statement.executeQuery(SQL);
                String chr_new = "";
                int start_new = Integer.MAX_VALUE;
                int stop_new = 0;
                while (resultSet.next()) {
                    String chr_temp = resultSet.getString(1);
                    int txStart_temp = resultSet.getInt(2);
                    int txStop_temp = resultSet.getInt(3);
                    if (chr_new.isEmpty()) {
                        chr_new = chr_temp;
                    }
                    if (!chr_temp.equalsIgnoreCase(chr_new)) continue;
                    if (start_new > txStart_temp) {
                        start_new = txStart_temp;
                    }
                    if (stop_new >= txStop_temp) continue;
                    stop_new = txStop_temp;
                }
                if (!chr_new.isEmpty()) {
                    chr = chr_new;
                    loci_start = start_new;
                    loci_stop = stop_new;
                }
            }
            catch (SQLException ex) {
                System.err.print(genome.class.getName() + ":" + ex.toString());
                Logger.getLogger(genome.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return true;
    }

    private void set_loci() {
        DecimalFormat df = new DecimalFormat("###,###,###,###,###,###");
        String disply_position = chr + ":" + df.format(loci_start) + "-" + df.format(loci_stop);
        this.jTextField1.setText(disply_position);
    }

    private boolean isPosNumeric(String s) {
        for (int i = 0; i < s.length(); ++i) {
            char a = s.charAt(i);
            if (a >= '0' && a <= '9') continue;
            return false;
        }
        return true;
    }

    private void refresh_position() {
        if (chr_size.get(chr) == null) {
            JOptionPane.showMessageDialog(null, "chromosome is not correct", "message", -1);
            return;
        }
        loci_start = Math.max(1L, loci_start);
        loci_stop = Math.min((long)chr_size.get(chr).intValue(), loci_stop);
        this.set_loci();
        DefaultComboBoxModel theModel = (DefaultComboBoxModel)this.jComboBox2.getModel();
        theModel.removeAllElements();
        ratio = ((double)this.jPanel3.getWidth() - (double)LEFT_MARGIN) / (double)(loci_stop - loci_start);
        try {
            this.create_image();
        }
        catch (SQLException ex) {
            System.err.print(genome.class.getName() + ":" + ex.toString());
            Logger.getLogger(genome.class.getName()).log(Level.SEVERE, null, ex);
        }
        this.writeXML();
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                try {
                    new genome().setVisible(true);
                }
                catch (Exception ex) {
                    System.err.print(genome.class.getName() + ":" + ex.toString());
                    Logger.getLogger(genome.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        });
    }

    static {
        DB_tables = new ArrayList();
        custom_tracks = new ArrayList();
        LEFT_MARGIN = 100;
        inDrag = false;
        hasStrip = true;
        track_image_lst = new ArrayList();
        popup = new popup();
        color_seq = 0;
        bedgraph_auto_assign_color = "125,125,125";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class progressBar_task
    extends SwingWorker<Boolean, Void> {
        progressBar_task() {
        }

        @Override
        public Boolean doInBackground() {
            genome.this.jButton13.setEnabled(false);
            this.setProgress(1);
            try {
                String line;
                File input_file = new File(genome.this.datafilename_for_fill_DB);
                long file_size = input_file.length();
                BufferedReader in1 = new BufferedReader(new FileReader(genome.this.datafilename_for_fill_DB));
                File output_file = new File("__tmp");
                BufferedWriter wr = new BufferedWriter(new FileWriter(output_file.getName()));
                long finished_byte = 0L;
                if (genome.this.hasHeader_for_fill_DB) {
                    line = in1.readLine();
                    finished_byte = line.length();
                }
                int rec_no = 0;
                genome.this.jLabel1.setText("<html><font color='red'>checking</font></html>");
                while ((line = in1.readLine()) != null) {
                    line = line.replace("\"", "");
                    line = line.replace("'", "");
                    if ((line = line.trim()).isEmpty()) continue;
                    String purified_line = genome.this.get_combined_columns(line, rec_no).replace("'", "");
                    if (purified_line.isEmpty()) {
                        wr.close();
                        boolean success = output_file.delete();
                        return false;
                    }
                    ++rec_no;
                    this.setProgress((int)(Math.max(1L, (finished_byte += (long)line.length()) * 100L) / file_size));
                    wr.write(purified_line + "\n");
                }
                in1.close();
                wr.close();
                File TextArea_file = new File("__tmp_textArea");
                if (TextArea_file.exists()) {
                    boolean success = TextArea_file.delete();
                }
                genome.this.jLabel1.setText("<html><font color='red'>uploading</font></html>");
                genome.this.jProgressBar1.setIndeterminate(true);
                try {
                    Statement statement = conn.createStatement();
                    String SQL = "load data local infile '" + output_file.getCanonicalPath().replace("\\", "/") + "' into table " + genome.this.DB_name_for_fill_DB;
                    statement.execute(SQL);
                    genome.this.jProgressBar1.setIndeterminate(false);
                }
                catch (SQLException ex) {
                    genome.this.jProgressBar1.setIndeterminate(false);
                    JOptionPane.showMessageDialog(null, "error in loading the table", "message", -1);
                }
                boolean success = output_file.delete();
                if (!genome.this.track_type(genome.this.DB_name_for_fill_DB).equals("housekeeping")) {
                    genome.this.jTableAdd(genome.this.DB_name_for_fill_DB, "full");
                    genome.this.writeXML();
                    genome.this.read_custom_track();
                    genome.this.refresh_position();
                    genome.this.jPanel3.repaint();
                }
            }
            catch (Exception ex) {
                this.setProgress(0);
                return false;
            }
            return true;
        }

        @Override
        public void done() {
            genome.this.jButton13.setEnabled(true);
            try {
                boolean succ = (Boolean)this.get();
                if (succ) {
                    if (genome.this.jRadioButton4.isSelected()) {
                        String[] str = genome.this.DB_name_for_fill_DB.split("_");
                        String its_assembly = str[str.length - 2];
                        JOptionPane.showMessageDialog(null, "<html><center>new housekeeping track data has been created successfully.</center><center> replace assembly item with \"" + its_assembly + "\" in \"track.xml\" file, if you want to use it as current assembly</center></html>", "message", -1);
                    } else {
                        JOptionPane.showMessageDialog(null, "DB table \"" + genome.this.DB_name_for_fill_DB + "\" has been created successfully. Its track shown in \"genome browser\" window", "message", -1);
                    }
                } else {
                    try {
                        Statement statement = conn.createStatement();
                        String SQL = "drop table " + genome.this.DB_name_for_fill_DB;
                        statement.execute(SQL);
                    }
                    catch (SQLException ex) {
                        JOptionPane.showMessageDialog(null, "error in dropping unfinished table", "message", -1);
                    }
                    JOptionPane.showMessageDialog(null, "DB table \"" + genome.this.DB_name_for_fill_DB + "\" upload failed", "message", -1);
                    genome.this.jLabel1.setText("");
                    this.setProgress(0);
                    return;
                }
                genome.this.jLabel1.setText("");
                this.setProgress(0);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(genome.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (ExecutionException ex) {
                Logger.getLogger(genome.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }
}

