/*
 * Decompiled with CFR 0.152.
 */
package GenomeLite;

import GenomeLite.RectText;
import GenomeLite.bed;
import GenomeLite.bed_track_position;
import GenomeLite.block;
import GenomeLite.genome;
import GenomeLite.locus_range;
import GenomeLite.wig;
import GenomeLite.y_max;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.DecimalFormat;
import java.util.ArrayList;
import javax.swing.JOptionPane;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class myBufferedImage
extends BufferedImage {
    int WIDTH_LEFT_BOX = 7;
    int WIG_HEIGHT = 28;
    int BED_HEIGHT = 18;
    int BED_EXON_HEIGHT = 14;
    int BED_UTR_HEIGHT = 8;
    int INTERVAL_HEIGHT = 14;
    int MAX_EXPR = 16;
    int MAX_READS = 65536;
    static int pos_y;
    final boolean hasToolTip = true;
    final boolean noToolTip = false;
    final boolean isTransparency = true;
    final boolean notTransparency = false;

    public myBufferedImage(int width, int height, int imageType, Rectangle rect) {
        super(width, height, imageType);
        Graphics g = super.getGraphics();
        Graphics2D g2d = (Graphics2D)g;
        AlphaComposite translucent = AlphaComposite.getInstance(3, 0.5f);
        g2d.setComposite(translucent);
        g2d.setColor(Color.lightGray);
        g2d.fillRect(rect.x, rect.y - 1, rect.width, rect.height);
        g2d.setColor(Color.RED);
        g2d.drawRect(rect.x, rect.y - 1, rect.width, rect.height);
        g2d.dispose();
    }

    public myBufferedImage(int width, int height, int imageType, String houseKeepTrack, Rectangle pos_rect, ArrayList MouseOver) throws SQLException {
        super(width, height, imageType);
        Graphics g = super.getGraphics();
        if (houseKeepTrack.equalsIgnoreCase("header")) {
            this.draw_header(g, pos_rect);
        } else if (houseKeepTrack.startsWith("sno_mirna")) {
            this.show_miR(g, pos_rect, houseKeepTrack, MouseOver);
        } else {
            this.show_TXs(g, pos_rect, houseKeepTrack, MouseOver);
        }
    }

    public myBufferedImage(int width, int height, int imageType, String track_DB, String scaleType, String trackType, Rectangle pos_rect, ArrayList MouseOver) {
        super(width, height, imageType);
        Graphics g = super.getGraphics();
        if (trackType.equals("bed") && !this.show_custom_bed(g, track_DB, pos_rect, MouseOver)) {
            return;
        }
        if (trackType.equals("wiggle") && !this.show_custom_wiggle(g, track_DB, scaleType, pos_rect, MouseOver)) {
            return;
        }
        if (trackType.equals("combinedwiggle") && !this.show_multi_wig(g, track_DB, scaleType, pos_rect, MouseOver)) {
            return;
        }
    }

    private void draw_header(Graphics g, Rectangle pos_rect) {
        Graphics2D g2d = (Graphics2D)g;
        if (genome.hasStrip) {
            this.draw_strip(g2d);
        }
        if (!genome.chr.isEmpty()) {
            this.draw_chr_loci(g);
        }
        pos_rect.x = 1;
        pos_rect.y = 1;
        pos_rect.width = genome.browser_width;
        pos_rect.height = 30;
        pos_y = 30;
    }

    private void draw_strip(Graphics g) {
        for (int i = genome.LEFT_MARGIN; i < this.getWidth(); i += 15) {
            g.setColor(new Color(210, 210, 230));
            g.drawLine(i, 0, i, this.getHeight());
        }
    }

    private void draw_chr_loci(Graphics g) {
        g.setColor(Color.black);
        if (genome.ratio > 0.0) {
            g.drawString(genome.chr, 0, 10);
            int interval = (int)((genome.loci_stop - genome.loci_start) / 5L);
            for (int i = 1; i < 5; ++i) {
                long pos = (long)(interval * i) + genome.loci_start;
                String pos_str = String.format("|%d", pos);
                int panel_loci = (int)((double)(pos - genome.loci_start) * genome.ratio) + genome.LEFT_MARGIN;
                g.drawString(pos_str, panel_loci, 10);
            }
        }
    }

    private String coreName(String DB_name) {
        int j;
        String result = "";
        String[] files = DB_name.split(",");
        String[] str = files[0].split("_");
        result = result + str[0];
        if (str[str.length - 1].equalsIgnoreCase("bed") || str[str.length - 1].equalsIgnoreCase("housekeeping")) {
            for (j = 1; j < str.length - 1; ++j) {
                result = result + "_" + str[j];
            }
        } else {
            for (j = 1; j < str.length - 2; ++j) {
                result = result + "_" + str[j];
            }
        }
        for (int i = 1; i < files.length; ++i) {
            int j2;
            result = result + ",";
            str = files[i].split("_");
            result = result + str[0];
            if (str[str.length - 1].equalsIgnoreCase("bed") || str[str.length - 1].equalsIgnoreCase("housekeeping")) {
                for (j2 = 1; j2 < str.length - 1; ++j2) {
                    result = result + "_" + str[j2];
                }
                continue;
            }
            for (j2 = 1; j2 < str.length - 2; ++j2) {
                result = result + "_" + str[j2];
            }
        }
        return result;
    }

    private void draw_title(Graphics g, String track_name, int offset) throws SQLException {
        String[] DB_name = track_name.split(",");
        Statement statement = genome.conn.createStatement();
        String[] colors = new String[DB_name.length];
        for (int i = 0; i < DB_name.length; ++i) {
            String SQL = "select color from " + DB_name[i] + " limit 1";
            ResultSet resultSet = statement.executeQuery(SQL);
            if (!resultSet.next()) continue;
            colors[i] = resultSet.getString("color");
        }
        String[] pureNames = this.coreName(track_name).split(",");
        int length_title = g.getFontMetrics().stringWidth(this.coreName(track_name));
        int central_x = (int)((double)(this.getWidth() + genome.LEFT_MARGIN) / 2.0);
        int start_pos = central_x - (length_title + 10 * DB_name.length) / 2;
        for (int i = 0; i < pureNames.length; ++i) {
            g.setColor(Color.black);
            g.drawString(pureNames[i], start_pos, offset);
            this.setColor(g, colors[i]);
            g.fillRect(start_pos += g.getFontMetrics().stringWidth(pureNames[i]), offset - 10, 10, 10);
            String stop_mark = ", ";
            g.drawString(stop_mark, start_pos += 10, offset);
            start_pos += g.getFontMetrics().stringWidth(stop_mark);
        }
    }

    private void write_scale(Graphics g, double scale_val, int offset) {
        DecimalFormat twoPlaces = new DecimalFormat("0.0");
        String scale_str = twoPlaces.format(scale_val);
        int x_start = genome.LEFT_MARGIN - g.getFontMetrics().stringWidth(scale_str);
        int y_start = offset;
        g.setColor(Color.black);
        g.drawString(scale_str, x_start - 7, y_start + g.getFontMetrics().getHeight() / 3);
        g.drawLine(genome.LEFT_MARGIN - 5, y_start, genome.LEFT_MARGIN, y_start);
    }

    private boolean show_custom_wiggle(Graphics g, String track_name, String scaleType, Rectangle pos_rect, ArrayList<RectText> MouseOver) {
        try {
            int track_start_pos_y = pos_y;
            int offset = 0;
            g.setColor(Color.black);
            this.draw_title(g, track_name, offset += this.INTERVAL_HEIGHT);
            y_max max_height = this.max_wig_height(track_name);
            if (max_height.plueStrand > 0.0) {
                this.write_scale(g, max_height.plueStrand, offset);
                offset += this.WIG_HEIGHT;
            }
            this.draw_line_wig(g, offset);
            String[] DB_name = track_name.split(",");
            for (int i = 0; i < DB_name.length; ++i) {
                String[] myStrand = new String[]{"+", "-"};
                for (int strand_no = 0; strand_no < 2; ++strand_no) {
                    Statement statement = genome.conn.createStatement();
                    String SQL = "select min(chromStart) from " + DB_name[i] + " where chrom='" + genome.chr + "' and strand='" + myStrand[strand_no] + "' and chromEnd between " + genome.loci_start + " and " + genome.loci_stop;
                    ResultSet resultSet = statement.executeQuery(SQL);
                    long first_wiggle_start = genome.loci_start;
                    if (resultSet.next() && resultSet.getInt(1) > 0) {
                        first_wiggle_start = resultSet.getInt(1);
                    }
                    SQL = "select chromStart from " + DB_name[i] + " where chrom='" + genome.chr + "' and strand='" + myStrand[strand_no] + "' and chromEnd >= " + genome.loci_stop + " limit 10";
                    resultSet = statement.executeQuery(SQL);
                    while (resultSet.next()) {
                        if (resultSet.getInt(1) <= 0 || (long)resultSet.getInt(1) > genome.loci_stop || first_wiggle_start <= (long)resultSet.getInt(1)) continue;
                        first_wiggle_start = resultSet.getInt(1);
                    }
                    SQL = "select * from " + DB_name[i] + " where chrom='" + genome.chr + "' and strand='" + myStrand[strand_no] + "' and chromStart between " + first_wiggle_start + " and " + genome.loci_stop;
                    resultSet = statement.executeQuery(SQL);
                    this.draw_one_wigTrack(i, resultSet, g, offset, max_height, scaleType, MouseOver);
                }
            }
            if (max_height.minusStrand > 0.0) {
                this.write_scale(g, max_height.minusStrand, (offset += this.WIG_HEIGHT) + 2);
            }
            g.setColor(Color.black);
            g.setColor(Color.LIGHT_GRAY);
            g.fillRect(1, 1, this.WIDTH_LEFT_BOX, offset);
            g.setColor(Color.gray);
            g.drawRect(1, 1, this.WIDTH_LEFT_BOX, offset);
            pos_rect.x = 1;
            pos_rect.y = 1;
            pos_rect.width = genome.browser_width;
            pos_rect.height = offset;
        }
        catch (SQLException ex) {
            JOptionPane.showConfirmDialog(null, "wiggle track DB " + track_name + " access error", "ERROR", -1);
            return false;
        }
        return true;
    }

    private long draw_one_wigTrack(int table_no, ResultSet resultSet, Graphics g, int offset, y_max max_height, String scaleType, ArrayList<RectText> MouseOver) throws SQLException {
        wig previous_wig = new wig("", "", "+", 0L, 0L, 0.0, "0,0,0");
        boolean num_wigs = true;
        long last_wiggle_start = genome.loci_start;
        while (resultSet.next()) {
            double value;
            String name = resultSet.getString(1);
            String chr = resultSet.getString(2);
            String strand = resultSet.getString(3);
            int start = resultSet.getInt(4);
            int stop = resultSet.getInt(5);
            if (last_wiggle_start < (long)start) {
                last_wiggle_start = start;
            }
            if ((value = resultSet.getDouble(6)) < 0.0) {
                value = Math.abs(value);
                strand = strand.equals("+") ? "-" : "+";
            }
            String color = resultSet.getString(7);
            locus_range lr = new locus_range((long)start - genome.loci_start, (long)stop - genome.loci_start);
            this.loci2pos(lr);
            if (lr.equal(previous_wig.loci)) {
                previous_wig.value = Math.max(previous_wig.value, value);
                continue;
            }
            if (table_no == 0) {
                this.draw_wig(g, previous_wig, offset, max_height, scaleType, true, MouseOver, false);
            } else {
                this.draw_wig(g, previous_wig, offset, max_height, scaleType, true, MouseOver, true);
            }
            previous_wig.name = name;
            previous_wig.chr = chr;
            previous_wig.strand = strand;
            previous_wig.loci.x1 = lr.x1;
            previous_wig.loci.x2 = lr.x2;
            previous_wig.value = value;
            previous_wig.color = color;
        }
        previous_wig.value /= (double)num_wigs;
        if (table_no == 0) {
            this.draw_wig(g, previous_wig, offset, max_height, scaleType, true, MouseOver, false);
        } else {
            this.draw_wig(g, previous_wig, offset, max_height, scaleType, true, MouseOver, true);
        }
        return last_wiggle_start;
    }

    private boolean show_custom_bed(Graphics g, String track_name, Rectangle pos_rect, ArrayList<RectText> MouseOver) {
        try {
            g.setColor(Color.black);
            g.drawString(this.coreName(track_name), (int)((double)(this.getWidth() + genome.LEFT_MARGIN - g.getFontMetrics().stringWidth(track_name)) / 2.0), this.INTERVAL_HEIGHT);
            Statement statement = genome.conn.createStatement();
            String SQL = "SELECT column_name,data_type FROM INFORMATION_SCHEMA.COLUMNS WHERE (TABLE_NAME = '" + track_name + "')";
            ResultSet resultSet1 = statement.executeQuery(SQL);
            int numCols = 0;
            while (resultSet1.next()) {
                ++numCols;
            }
            SQL = "select min(chromStart) from " + track_name + " where chrom='" + genome.chr + "' and chromEnd between " + genome.loci_start + " and " + genome.loci_stop;
            ResultSet resultSet = statement.executeQuery(SQL);
            long first_wiggle_start = genome.loci_start;
            if (resultSet.next() && resultSet.getInt(1) > 0) {
                first_wiggle_start = resultSet.getInt(1);
            }
            SQL = "select chromStart from " + track_name + " where chrom='" + genome.chr + "' and chromEnd >= " + genome.loci_stop + " limit 10";
            resultSet = statement.executeQuery(SQL);
            while (resultSet.next()) {
                if (resultSet.getInt(1) <= 0 || (long)resultSet.getInt(1) > genome.loci_stop || first_wiggle_start <= (long)resultSet.getInt(1)) continue;
                first_wiggle_start = resultSet.getInt(1);
            }
            SQL = "select * from " + track_name + " where chrom='" + genome.chr + "' and chromStart between " + first_wiggle_start + " and " + genome.loci_stop;
            resultSet = statement.executeQuery(SQL);
            ArrayList<bed_track_position> track_positions = new ArrayList<bed_track_position>();
            track_positions.add(new bed_track_position(this.INTERVAL_HEIGHT, Integer.MIN_VALUE));
            while (resultSet.next()) {
                bed b;
                String chr = resultSet.getString(1);
                int tx_start = resultSet.getInt(2);
                int tx_stop = resultSet.getInt(3);
                if ((long)tx_start >= genome.loci_stop || (long)tx_stop <= genome.loci_start) continue;
                int thick_start = tx_start;
                int thick_stop = tx_stop;
                String name = resultSet.getString(4);
                int score = resultSet.getInt(5);
                String gray_degree = Integer.toString((int)(0.255 * (double)score));
                String itemRgb = gray_degree + "," + gray_degree + "," + gray_degree;
                String strand = resultSet.getString(6);
                if (numCols > 6) {
                    thick_start = resultSet.getInt(7);
                    thick_stop = resultSet.getInt(8);
                    itemRgb = resultSet.getString(9);
                    if (itemRgb.equalsIgnoreCase("0")) {
                        itemRgb = "0,0,0";
                    }
                    if (numCols > 9) {
                        int blockCount = resultSet.getInt(10);
                        String blockSizes = resultSet.getString(11);
                        String blockStarts = resultSet.getString(12);
                        b = new bed(chr, tx_start, tx_stop, name, score, strand, thick_start, thick_stop, itemRgb, blockCount, blockSizes, blockStarts);
                    } else {
                        b = new bed(chr, tx_start, tx_stop, name, score, strand, thick_start, thick_stop, itemRgb);
                    }
                } else {
                    b = new bed(chr, tx_start, tx_stop, name, score, strand, thick_start, thick_stop, itemRgb);
                }
                String[] strands = b.strand.equals(".") ? new String[]{"-", "+"} : new String[]{b.strand};
                for (int strand_no = 0; strand_no < strands.length; ++strand_no) {
                    b.strand = strands[strand_no];
                    this.draw_bed(g, track_positions, b, true, MouseOver);
                }
            }
            g.setColor(Color.lightGray);
            int last_line_y = ((bed_track_position)track_positions.get((int)(track_positions.size() - 1))).y;
            g.fillRect(1, 1, this.WIDTH_LEFT_BOX, last_line_y + this.BED_HEIGHT);
            g.setColor(Color.gray);
            g.drawRect(1, 1, this.WIDTH_LEFT_BOX, last_line_y + this.BED_HEIGHT);
            pos_rect.x = 1;
            pos_rect.y = 1;
            pos_rect.width = genome.browser_width;
            pos_rect.height = last_line_y + this.BED_HEIGHT;
        }
        catch (SQLException ex) {
            JOptionPane.showConfirmDialog(null, "bed track: DB " + track_name + " access error", "ERROR", -1);
            return false;
        }
        return true;
    }

    private void show_miR(Graphics g, Rectangle pos_rect, String sno_miR_name, ArrayList<RectText> MouseOver) throws SQLException {
        g.setColor(Color.black);
        g.drawString("sno-miR", (int)((double)(this.getWidth() + genome.LEFT_MARGIN - g.getFontMetrics().stringWidth("sno-miR")) / 2.0), this.INTERVAL_HEIGHT);
        Statement statement = genome.conn.createStatement();
        String SQL = "select min(chromStart) from " + sno_miR_name + " where chrom='" + genome.chr + "' and chromEnd between " + genome.loci_start + " and " + genome.loci_stop;
        ResultSet resultSet = statement.executeQuery(SQL);
        long first_wiggle_start = genome.loci_start;
        if (resultSet.next() && resultSet.getInt(1) > 0) {
            first_wiggle_start = resultSet.getInt(1);
        }
        SQL = "select chromStart from " + sno_miR_name + " where chrom='" + genome.chr + "' and chromEnd >= " + genome.loci_stop + " limit 10";
        resultSet = statement.executeQuery(SQL);
        while (resultSet.next()) {
            if (resultSet.getInt(1) <= 0 || (long)resultSet.getInt(1) > genome.loci_stop || first_wiggle_start <= (long)resultSet.getInt(1)) continue;
            first_wiggle_start = resultSet.getInt(1);
        }
        SQL = "select name,strand,chromStart,chromEnd,thickStart,thickEnd from " + sno_miR_name + " where chrom='" + genome.chr + "' and chromStart between " + first_wiggle_start + " and " + genome.loci_stop;
        resultSet = statement.executeQuery(SQL);
        ArrayList<bed_track_position> track_positions = new ArrayList<bed_track_position>();
        track_positions.add(new bed_track_position(this.INTERVAL_HEIGHT, Integer.MIN_VALUE));
        while (resultSet.next()) {
            String tmp_name = resultSet.getString(1);
            String tmp_strand = resultSet.getString(2);
            int tmp_txStart = resultSet.getInt(3);
            int tmp_txStop = resultSet.getInt(4);
            int tmp_cdsStart = resultSet.getInt(5);
            int tmp_cdsStop = resultSet.getInt(6);
            if ((long)tmp_txStart >= genome.loci_stop || (long)tmp_txStop <= genome.loci_start) continue;
            bed b = new bed(genome.chr, tmp_txStart, tmp_txStop, tmp_name, 960, tmp_strand, tmp_cdsStart, tmp_cdsStop, "255,0,0");
            this.draw_bed(g, track_positions, b, true, MouseOver);
        }
        g.setColor(Color.lightGray);
        int last_line_y = ((bed_track_position)track_positions.get((int)(track_positions.size() - 1))).y;
        g.fillRect(1, 1, this.WIDTH_LEFT_BOX, last_line_y + this.BED_HEIGHT);
        g.setColor(Color.gray);
        g.drawRect(1, 1, this.WIDTH_LEFT_BOX, last_line_y + this.BED_HEIGHT);
        pos_rect.x = 1;
        pos_rect.y = 1;
        pos_rect.width = genome.browser_width;
        pos_rect.height = last_line_y + this.BED_HEIGHT;
    }

    private void show_TXs(Graphics g, Rectangle pos_rect, String TX_name, ArrayList<RectText> MouseOver) throws SQLException {
        if (TX_name.startsWith("aceview")) {
            g.setColor(Color.MAGENTA);
        } else if (TX_name.startsWith("ref")) {
            g.setColor(Color.blue);
        } else {
            g.setColor(Color.black);
        }
        g.drawString(this.coreName(TX_name), (int)((double)(this.getWidth() + genome.LEFT_MARGIN - g.getFontMetrics().stringWidth(TX_name)) / 2.0), this.INTERVAL_HEIGHT);
        Statement statement = genome.conn.createStatement();
        String SQL = "select min(txStart) from " + TX_name + " where chrom='" + genome.chr + "' and txEnd between " + genome.loci_start + " and " + genome.loci_stop;
        ResultSet resultSet = statement.executeQuery(SQL);
        long first_wiggle_start = genome.loci_start;
        if (resultSet.next() && resultSet.getInt(1) > 0) {
            first_wiggle_start = resultSet.getInt(1);
        }
        SQL = "select txStart from " + TX_name + " where chrom='" + genome.chr + "' and txEnd >= " + genome.loci_stop + " limit 10";
        resultSet = statement.executeQuery(SQL);
        while (resultSet.next()) {
            if (resultSet.getInt(1) <= 0 || (long)resultSet.getInt(1) > genome.loci_stop || first_wiggle_start <= (long)resultSet.getInt(1)) continue;
            first_wiggle_start = resultSet.getInt(1);
        }
        SQL = TX_name.startsWith("aceview") ? "select name,strand,txStart,txEnd,cdsStart,cdsEnd,exonCount,exonStarts,exonEnds from " + TX_name + " where chrom='" + genome.chr + "' and txStart between " + first_wiggle_start + " and " + genome.loci_stop : "select name2,strand,txStart,txEnd,cdsStart,cdsEnd,exonCount,exonStarts,exonEnds from " + TX_name + " where chrom='" + genome.chr + "' and txStart between " + first_wiggle_start + " and " + genome.loci_stop;
        resultSet = statement.executeQuery(SQL);
        ArrayList<bed_track_position> track_positions = new ArrayList<bed_track_position>();
        track_positions.add(new bed_track_position(this.INTERVAL_HEIGHT, Integer.MIN_VALUE));
        while (resultSet.next()) {
            String tmp_name = resultSet.getString(1);
            String tmp_strand = resultSet.getString(2);
            int tmp_txStart = resultSet.getInt(3);
            int tmp_txStop = resultSet.getInt(4);
            int tmp_cdsStart = resultSet.getInt(5);
            int tmp_cdsStop = resultSet.getInt(6);
            int tmp_numExon = resultSet.getInt(7);
            if ((long)tmp_txStart >= genome.loci_stop || (long)tmp_txStop <= genome.loci_start) continue;
            String tmp_exonStarts = resultSet.getString(8);
            String[] S = tmp_exonStarts.split(",");
            String tmp_exonEnds = resultSet.getString(9);
            String[] E = tmp_exonEnds.split(",");
            String blockStarts = Integer.toString(Integer.parseInt(S[0]) - tmp_txStart);
            String blockSizes = Integer.toString(Integer.parseInt(E[0]) - Integer.parseInt(S[0]));
            for (int i = 1; i < tmp_numExon; ++i) {
                blockStarts = blockStarts + "," + Integer.toString(Integer.parseInt(S[i]) - tmp_txStart);
                blockSizes = blockSizes + "," + Integer.toString(Integer.parseInt(E[i]) - Integer.parseInt(S[i]));
            }
            bed b = new bed(genome.chr, tmp_txStart, tmp_txStop, tmp_name, 960, tmp_strand, tmp_cdsStart, tmp_cdsStop, "0,0,0", tmp_numExon, blockSizes, blockStarts);
            this.draw_bed(g, track_positions, b, true, MouseOver);
        }
        g.setColor(Color.lightGray);
        int last_line_y = ((bed_track_position)track_positions.get((int)(track_positions.size() - 1))).y;
        g.fillRect(1, 1, this.WIDTH_LEFT_BOX, last_line_y + this.BED_HEIGHT);
        g.setColor(Color.gray);
        g.drawRect(1, 1, this.WIDTH_LEFT_BOX, last_line_y + this.BED_HEIGHT);
        pos_rect.x = 1;
        pos_rect.y = 1;
        pos_rect.width = genome.browser_width;
        pos_rect.height = last_line_y + this.BED_HEIGHT;
    }

    private void draw_bed(Graphics g, ArrayList<bed_track_position> track_positions, bed bed1, boolean tooltip, ArrayList<RectText> MouseOver) {
        if (bed1.name.equals("RMND1.aApr07")) {
            int i = 99;
        }
        int which_line = -1;
        for (int i = 0; i < track_positions.size(); ++i) {
            if (!(genome.ratio * (double)(bed1.loci.x1 - genome.loci_start) - (double)g.getFontMetrics().stringWidth(bed1.name) > (double)track_positions.get((int)i).x_most_right)) continue;
            which_line = i;
            break;
        }
        if (which_line == -1) {
            which_line = track_positions.size();
            bed_track_position new_bed_line = new bed_track_position(track_positions.get((int)(which_line - 1)).y + this.BED_HEIGHT, Integer.MIN_VALUE);
            track_positions.add(new_bed_line);
        }
        track_positions.get((int)which_line).x_most_right = (int)(genome.ratio * (double)(bed1.loci.x2 - genome.loci_start));
        this.draw_line_bed(g, track_positions.get((int)which_line).y, bed1);
        this.setColor(g, bed1.itemRgb);
        if (bed1.type.equalsIgnoreCase("bed12")) {
            int UTR_left = bed1.thickStart - (int)bed1.loci.x1;
            int UTR_right = bed1.thickStop - (int)bed1.loci.x1;
            ArrayList<block> blocks = this.sepreate_block_on_UTR(bed1);
            for (block b : blocks) {
                RectText tectText;
                Rectangle rt;
                int myStart = (int)((long)b.start + bed1.loci.x1 - genome.loci_start);
                locus_range lr = new locus_range(myStart, myStart + b.length);
                this.loci2pos(lr);
                if (lr.x1 <= 0L) continue;
                if (b.start < UTR_left || b.start + b.length > UTR_right) {
                    g.fillRect((int)lr.x1, track_positions.get((int)which_line).y + this.BED_HEIGHT / 2 - 4, (int)lr.width(), 8);
                    if (!tooltip) continue;
                    rt = new Rectangle((int)lr.x1, track_positions.get((int)which_line).y + this.BED_HEIGHT / 2 - 4, (int)lr.width(), 8);
                    tectText = new RectText(rt, bed1.name);
                    MouseOver.add(tectText);
                    continue;
                }
                g.fillRect((int)lr.x1, track_positions.get((int)which_line).y + this.BED_HEIGHT / 2 - 7, (int)lr.width(), 14);
                if (tooltip) {
                    rt = new Rectangle((int)lr.x1, track_positions.get((int)which_line).y + this.BED_HEIGHT / 2 - 7, (int)lr.width(), 14);
                    tectText = new RectText(rt, bed1.name);
                    MouseOver.add(tectText);
                }
                if (bed1.blockCount != 1) continue;
                g.setColor(Color.white);
                this.draw_arrow(g, track_positions.get((int)which_line).y + this.BED_HEIGHT / 2, bed1, (int)lr.x1, (int)lr.x2);
                this.setColor(g, bed1.itemRgb);
            }
        } else {
            int yy_width = 14;
            locus_range lr = new locus_range((int)(bed1.loci.x1 - genome.loci_start), (int)(bed1.loci.x2 - genome.loci_start));
            this.loci2pos(lr);
            if (lr.x1 > 0L) {
                g.fillRect((int)lr.x1, track_positions.get((int)which_line).y + this.BED_HEIGHT / 2 - 7, (int)lr.width(), yy_width);
                if (tooltip) {
                    Rectangle rt = new Rectangle((int)lr.x1, track_positions.get((int)which_line).y + this.BED_HEIGHT / 2 - 7, (int)lr.width(), yy_width);
                    RectText tectText = new RectText(rt, bed1.name);
                    MouseOver.add(tectText);
                }
                g.setColor(Color.white);
                this.draw_arrow(g, track_positions.get((int)which_line).y + this.BED_HEIGHT / 2, bed1, (int)lr.x1, (int)lr.x2);
                this.setColor(g, bed1.itemRgb);
            }
        }
    }

    protected void draw_line_bed(Graphics g, int y, bed bed1) {
        g.setColor(Color.black);
        locus_range lr = new locus_range(bed1.loci.x1 - genome.loci_start, bed1.loci.x2 - genome.loci_start);
        this.loci2pos(lr);
        if (lr.x1 > 0L) {
            int word_start_pos;
            int word_width = Math.max(20, g.getFontMetrics().stringWidth(bed1.name));
            if (bed1.name.equals("ESR1.gApr07")) {
                String debug = "";
            }
            if ((word_start_pos = (int)lr.x1 - word_width) < genome.LEFT_MARGIN) {
                word_start_pos = genome.LEFT_MARGIN - word_width;
            }
            g.drawString(bed1.name, word_start_pos, y + g.getFontMetrics().getHeight());
            this.setColor(g, bed1.itemRgb);
            g.drawLine((int)lr.x1, y + this.BED_HEIGHT / 2, (int)lr.x2, y + this.BED_HEIGHT / 2);
            this.draw_arrow(g, y + this.BED_HEIGHT / 2, bed1, (int)lr.x1, (int)lr.x2);
        }
    }

    private void draw_arrow(Graphics g, int y, bed bed1, int start, int stop) {
        if (bed1.strand.equalsIgnoreCase("+")) {
            for (int i = start; i < stop; i += 10) {
                if (i <= genome.LEFT_MARGIN) continue;
                g.drawLine(i, y - 3, i + 3, y);
                g.drawLine(i, y + 3, i + 3, y);
            }
        } else {
            for (int i = start; i < stop; i += 10) {
                if (i <= genome.LEFT_MARGIN) continue;
                g.drawLine(i + 3, y - 3, i, y);
                g.drawLine(i + 3, y + 3, i, y);
            }
        }
    }

    private void draw_wig(Graphics g, wig wig1, int offset, y_max max_height, String scaleType, boolean tooltip, ArrayList<RectText> MouseOver, boolean transparency) {
        String[] colors = wig1.color.split(",");
        Color color = transparency ? new Color(Integer.parseInt(colors[0]), Integer.parseInt(colors[1]), Integer.parseInt(colors[2]), 125) : new Color(Integer.parseInt(colors[0]), Integer.parseInt(colors[1]), Integer.parseInt(colors[2]));
        if (Integer.parseInt(colors[0]) > Integer.parseInt(colors[1]) && Integer.parseInt(colors[0]) > Integer.parseInt(colors[2])) {
            Color edgeColor = Color.red;
        } else if (Integer.parseInt(colors[1]) > Integer.parseInt(colors[2])) {
            Color edgeColor = Color.green;
        } else {
            Color edgeColor = Color.blue;
        }
        g.setColor(color);
        if (wig1.loci.x1 > 0L) {
            y_max height = new y_max(0.0, 0.0);
            if (scaleType.equalsIgnoreCase("logscale")) {
                height.plueStrand = (double)this.WIG_HEIGHT * Math.pow(2.0, Math.min((double)this.MAX_EXPR, wig1.value) - Math.min((double)this.MAX_EXPR, max_height.plueStrand));
                height.minusStrand = (double)this.WIG_HEIGHT * Math.pow(2.0, Math.min((double)this.MAX_EXPR, wig1.value) - Math.min((double)this.MAX_EXPR, max_height.minusStrand));
            } else {
                height.plueStrand = (double)this.WIG_HEIGHT * Math.min((double)this.MAX_READS, wig1.value) / Math.min((double)this.MAX_READS, max_height.plueStrand);
                height.minusStrand = (double)this.WIG_HEIGHT * Math.min((double)this.MAX_READS, wig1.value) / Math.min((double)this.MAX_READS, max_height.minusStrand);
            }
            if (wig1.strand.equals("+")) {
                g.fillRect((int)wig1.loci.x1, offset - (int)height.plueStrand, (int)wig1.loci.width(), (int)height.plueStrand);
                g.fillRect((int)wig1.loci.x1, offset - (int)height.plueStrand, (int)wig1.loci.width(), Math.min(2, (int)height.plueStrand));
                if (tooltip) {
                    Rectangle tooltip_rect = new Rectangle((int)wig1.loci.x1, offset - (int)height.plueStrand, (int)wig1.loci.width(), 4);
                    MouseOver.add(new RectText(tooltip_rect, wig1.name));
                }
            } else {
                g.fillRect((int)wig1.loci.x1, offset + 1, (int)wig1.loci.width(), (int)height.minusStrand);
                g.fillRect((int)wig1.loci.x1, offset + 1 + (int)height.minusStrand, (int)wig1.loci.width(), Math.min(2, (int)height.minusStrand));
                if (tooltip) {
                    Rectangle tooltip_rect = new Rectangle((int)wig1.loci.x1, offset + 1 + (int)height.minusStrand, (int)wig1.loci.width(), 4);
                    MouseOver.add(new RectText(tooltip_rect, wig1.name));
                }
            }
        }
    }

    private void draw_line_wig(Graphics g, int y) {
        this.setColor(g, "0,0,0");
        g.drawLine(genome.LEFT_MARGIN, y, this.getWidth(), y);
    }

    y_max max_wig_height(String db_name) throws SQLException {
        Statement statement = genome.conn.createStatement();
        y_max result = new y_max(0.0, 0.0);
        String[] DB_files = db_name.split(",");
        for (int i = 0; i < DB_files.length; ++i) {
            double min_value;
            String SQL = "select min(chromStart) from " + DB_files[i] + " where chrom='" + genome.chr + "' and strand = '+'" + " and chromEnd between " + genome.loci_start + " and " + genome.loci_stop;
            ResultSet resultSet = statement.executeQuery(SQL);
            long first_wiggle_start = genome.loci_start;
            if (resultSet.next() && resultSet.getInt(1) > 0) {
                first_wiggle_start = resultSet.getInt(1);
            }
            SQL = "select chromStart from " + DB_files[i] + " where chrom='" + genome.chr + "' and strand='" + "+' and chromEnd >= " + genome.loci_stop + " limit 10";
            resultSet = statement.executeQuery(SQL);
            while (resultSet.next()) {
                if (resultSet.getInt(1) <= 0 || (long)resultSet.getInt(1) > genome.loci_stop || first_wiggle_start <= (long)resultSet.getInt(1)) continue;
                first_wiggle_start = resultSet.getInt(1);
            }
            SQL = "select max(value), min(value) from " + DB_files[i] + " where chrom='" + genome.chr + "' and strand = '+'" + " and chromStart between " + first_wiggle_start + " and " + genome.loci_stop;
            resultSet = statement.executeQuery(SQL);
            if (resultSet.next()) {
                if (result.plueStrand < resultSet.getDouble(1)) {
                    result.plueStrand = resultSet.getDouble(1);
                }
                if ((min_value = resultSet.getDouble(2)) < 0.0 && result.minusStrand < Math.abs(min_value)) {
                    result.minusStrand = Math.abs(min_value);
                }
            }
            SQL = "select min(chromStart) from " + DB_files[i] + " where chrom='" + genome.chr + "' and strand = '-'" + " and chromEnd between " + genome.loci_start + " and " + genome.loci_stop;
            resultSet = statement.executeQuery(SQL);
            first_wiggle_start = genome.loci_start;
            if (resultSet.next() && resultSet.getInt(1) > 0) {
                first_wiggle_start = resultSet.getInt(1);
            }
            SQL = "select chromStart from " + DB_files[i] + " where chrom='" + genome.chr + "' and strand='" + "-' and chromStart >= " + genome.loci_stop + " limit 10";
            resultSet = statement.executeQuery(SQL);
            while (resultSet.next()) {
                if (resultSet.getInt(1) <= 0 || (long)resultSet.getInt(1) > genome.loci_stop || first_wiggle_start <= (long)resultSet.getInt(1)) continue;
                first_wiggle_start = resultSet.getInt(1);
            }
            SQL = "select max(value),min(value) from " + DB_files[i] + " where chrom='" + genome.chr + "' and strand = '-' " + " and chromStart between " + first_wiggle_start + " and " + genome.loci_stop;
            resultSet = statement.executeQuery(SQL);
            if (!resultSet.next()) continue;
            if (result.minusStrand < resultSet.getDouble(1)) {
                result.minusStrand = resultSet.getDouble(1);
            }
            if (!((min_value = resultSet.getDouble(2)) < 0.0) || !(result.plueStrand < Math.abs(min_value))) continue;
            result.plueStrand = Math.abs(min_value);
        }
        return result;
    }

    private y_max max_multiWig_height(String db_name) throws SQLException {
        Statement statement = genome.conn.createStatement();
        String SQL = "select min(chromStart) from " + db_name + " where chrom='" + genome.chr + "' and chromEnd between " + genome.loci_start + " and " + genome.loci_stop;
        ResultSet resultSet = statement.executeQuery(SQL);
        long first_wiggle_start = genome.loci_start;
        if (resultSet.next() && resultSet.getInt(1) > 0) {
            first_wiggle_start = resultSet.getInt(1);
        }
        SQL = "select chromStart from " + db_name + " where chrom='" + genome.chr + "' and chromEnd >= " + genome.loci_stop + " limit 10";
        resultSet = statement.executeQuery(SQL);
        while (resultSet.next()) {
            if (resultSet.getInt(1) <= 0 || (long)resultSet.getInt(1) > genome.loci_stop || first_wiggle_start <= (long)resultSet.getInt(1)) continue;
            first_wiggle_start = resultSet.getInt(1);
        }
        SQL = "select multi_expr, strand from " + db_name + " where chrom='" + genome.chr + "' and chromStart between " + first_wiggle_start + " and " + genome.loci_stop;
        resultSet = statement.executeQuery(SQL);
        y_max result = new y_max(0.0, 0.0);
        while (resultSet.next()) {
            int i;
            String[] str = resultSet.getString("multi_expr").split(",");
            String strand = resultSet.getString("strand");
            if (strand.equals("+")) {
                for (i = 0; i < str.length; ++i) {
                    if (!(result.plueStrand < Double.parseDouble(str[i]))) continue;
                    result.plueStrand = Double.parseDouble(str[i]);
                }
                continue;
            }
            for (i = 0; i < str.length; ++i) {
                if (!(result.minusStrand < Double.parseDouble(str[i]))) continue;
                result.minusStrand = Double.parseDouble(str[i]);
            }
        }
        return result;
    }

    private boolean show_multi_wig(Graphics g, String db_name, String scaleType, Rectangle pos_rect, ArrayList<RectText> MouseOver) {
        try {
            int track_start_pos_y = pos_y;
            int offset = 0;
            g.setColor(Color.black);
            g.drawString(this.coreName(db_name), (int)((double)(this.getWidth() + genome.LEFT_MARGIN - g.getFontMetrics().stringWidth(this.coreName(db_name))) / 2.0), offset + this.INTERVAL_HEIGHT);
            offset += this.INTERVAL_HEIGHT;
            y_max max_height = this.max_multiWig_height(db_name);
            if (max_height.plueStrand > 0.0) {
                this.write_scale(g, max_height.plueStrand, offset);
                offset += this.WIG_HEIGHT;
            }
            this.draw_line_wig(g, offset);
            Statement statement = genome.conn.createStatement();
            String SQL = "select min(chromStart) from " + db_name + " where chrom='" + genome.chr + "' and chromEnd between " + genome.loci_start + " and " + genome.loci_stop;
            ResultSet resultSet = statement.executeQuery(SQL);
            long first_wiggle_start = genome.loci_start;
            if (resultSet.next() && resultSet.getInt(1) > 0) {
                first_wiggle_start = resultSet.getInt(1);
            }
            SQL = "select chromStart from " + db_name + " where chrom='" + genome.chr + "' and chromEnd >= " + genome.loci_stop + " limit 10";
            resultSet = statement.executeQuery(SQL);
            while (resultSet.next()) {
                if (resultSet.getInt(1) <= 0 || (long)resultSet.getInt(1) > genome.loci_stop || first_wiggle_start <= (long)resultSet.getInt(1)) continue;
                first_wiggle_start = resultSet.getInt(1);
            }
            SQL = "select name,strand,chromStart,chromEnd,multi_expr from " + db_name + " where chrom='" + genome.chr + "' and chromStart between " + first_wiggle_start + " and " + genome.loci_stop;
            resultSet = statement.executeQuery(SQL);
            while (resultSet.next()) {
                String tmp_name = resultSet.getString("name");
                String tmp_strand = resultSet.getString("strand");
                int tmp_start = resultSet.getInt("chromStart");
                int tmp_stop = resultSet.getInt("chromEnd");
                String tmp_expr = resultSet.getString("multi_expr");
                String[] str = tmp_expr.split(",");
                locus_range lr_mouseOver = new locus_range((long)tmp_start - genome.loci_start, (long)tmp_stop - genome.loci_start);
                this.loci2pos(lr_mouseOver);
                g.setColor(Color.black);
                if (lr_mouseOver.x1 > 0L) {
                    Rectangle tooltip_rect;
                    if (tmp_strand.equals("+")) {
                        tooltip_rect = new Rectangle((int)lr_mouseOver.x1, offset - this.WIG_HEIGHT, (int)lr_mouseOver.width(), this.WIG_HEIGHT);
                        MouseOver.add(new RectText(tooltip_rect, tmp_name + "(" + tmp_expr + ")"));
                    } else {
                        tooltip_rect = new Rectangle((int)lr_mouseOver.x1, offset, (int)lr_mouseOver.width(), this.WIG_HEIGHT);
                        MouseOver.add(new RectText(tooltip_rect, tmp_name + "(" + tmp_expr + ")"));
                    }
                }
                String[] color = new String[]{"0,0,255", "0,0,200", "255,0,0", "255,20,147", "0,255,0", "150,255,0"};
                int sub_interval = (int)Math.ceil((tmp_stop - tmp_start) / str.length);
                for (int i = 0; i < str.length; ++i) {
                    int color_interval = (int)Math.floor(color.length / str.length);
                    double tmp_value = Double.parseDouble(str[i]);
                    locus_range lr_interval = new locus_range(tmp_start + sub_interval * i, tmp_start + sub_interval * (i + 1));
                    wig wig1 = new wig(tmp_name, genome.chr, tmp_strand, lr_interval, tmp_value, color[i * color_interval]);
                    wig1.loci.x1 -= genome.loci_start;
                    wig1.loci.x2 -= genome.loci_start;
                    this.loci2pos(wig1.loci);
                    this.draw_wig(g, wig1, offset, max_height, scaleType, false, MouseOver, false);
                }
            }
            if (max_height.minusStrand > 0.0) {
                this.write_scale(g, max_height.minusStrand, (offset += this.WIG_HEIGHT) + 2);
            }
            g.setColor(Color.lightGray);
            g.fillRect(1, 1, this.WIDTH_LEFT_BOX, offset);
            g.setColor(Color.gray);
            g.drawRect(1, 1, this.WIDTH_LEFT_BOX, offset);
            pos_rect.x = 1;
            pos_rect.y = 1;
            pos_rect.width = genome.browser_width;
            pos_rect.height = offset;
        }
        catch (SQLException ex) {
            JOptionPane.showConfirmDialog(null, "combinedWiggle track: DB " + db_name + " access error", "ERROR", -1);
            return false;
        }
        return true;
    }

    private void setColor(Graphics g, String Rgb) {
        int B;
        int G;
        int R;
        String[] RGB = Rgb.split(",");
        if (RGB.length < 3) {
            R = 255;
            G = 255;
            B = 255;
        } else {
            R = Integer.parseInt(RGB[0]);
            G = Integer.parseInt(RGB[1]);
            B = Integer.parseInt(RGB[2]);
        }
        g.setColor(new Color(R, G, B));
    }

    ArrayList<block> sepreate_block_on_UTR(bed bed1) {
        int i;
        int UTR_left = bed1.thickStart - (int)bed1.loci.x1;
        int UTR_right = bed1.thickStop - (int)bed1.loci.x1;
        int[] length_block = new int[bed1.blockCount];
        int[] start_block = new int[bed1.blockCount];
        String[] str = bed1.blockSizes.split(",");
        for (i = 0; i < bed1.blockCount; ++i) {
            length_block[i] = Integer.parseInt(str[i]);
        }
        str = bed1.blockStarts.split(",");
        for (i = 0; i < bed1.blockCount; ++i) {
            start_block[i] = Integer.parseInt(str[i]);
        }
        ArrayList<block> blocks = new ArrayList<block>();
        for (int i2 = 0; i2 < bed1.blockCount; ++i2) {
            if (start_block[i2] < UTR_left && UTR_left < start_block[i2] + length_block[i2]) {
                if (start_block[i2] + length_block[i2] < UTR_right) {
                    blocks.add(new block(start_block[i2], UTR_left - start_block[i2]));
                    blocks.add(new block(UTR_left, length_block[i2] - (UTR_left - start_block[i2])));
                    continue;
                }
                blocks.add(new block(start_block[i2], UTR_left - start_block[i2]));
                blocks.add(new block(UTR_left, UTR_right - UTR_left));
                blocks.add(new block(UTR_right, length_block[i2] - (UTR_right - start_block[i2])));
                continue;
            }
            if (start_block[i2] < UTR_right && UTR_right < start_block[i2] + length_block[i2]) {
                blocks.add(new block(start_block[i2], UTR_right - start_block[i2]));
                blocks.add(new block(UTR_right, length_block[i2] - (UTR_right - start_block[i2])));
                continue;
            }
            blocks.add(new block(start_block[i2], length_block[i2]));
        }
        return blocks;
    }

    private void loci2pos(locus_range range) {
        long x1 = range.x1;
        long x2 = range.x2;
        long xx1 = (long)((double)x1 * genome.ratio);
        if (xx1 > (long)this.getWidth()) {
            range.x1 = -1L;
            return;
        }
        xx1 = Math.max(0L, xx1) + (long)genome.LEFT_MARGIN;
        long xx2 = (long)((double)x2 * genome.ratio);
        if (xx2 < 0L) {
            range.x1 = -1L;
            return;
        }
        xx2 = Math.min(xx2 + (long)genome.LEFT_MARGIN, (long)this.getWidth());
        range.x1 = xx1;
        range.x2 = Math.max(xx1 + 1L, xx2);
    }
}

