/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.cmdline;

import java.io.File;
import java.net.InetAddress;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import net.sf.picard.cmdline.CommandLineParser;
import net.sf.picard.cmdline.Option;
import net.sf.picard.metrics.Header;
import net.sf.picard.metrics.MetricBase;
import net.sf.picard.metrics.MetricsFile;
import net.sf.picard.metrics.StringHeader;
import net.sf.picard.util.Log;
import net.sf.samtools.SAMFileReader;
import net.sf.samtools.SAMFileWriterFactory;
import net.sf.samtools.SAMFileWriterImpl;
import net.sf.samtools.util.BlockCompressedOutputStream;
import net.sf.samtools.util.IOUtil;

public abstract class CommandLineProgram {
    @Option(common=true, optional=true)
    public List<File> TMP_DIR = new ArrayList<File>();
    @Option(doc="Control verbosity of logging.", common=true)
    public Log.LogLevel VERBOSITY = Log.LogLevel.INFO;
    @Option(doc="Whether to suppress job-summary info on System.err.", common=true)
    public Boolean QUIET = false;
    @Option(doc="Validation stringency for all SAM files read by this program.  Setting stringency to SILENT can improve performance when processing a BAM file in which variable-length data (read, qualities, tags) do not otherwise need to be decoded.", common=true)
    public SAMFileReader.ValidationStringency VALIDATION_STRINGENCY = SAMFileReader.ValidationStringency.DEFAULT_STRINGENCY;
    @Option(doc="Compression level for all compressed files created (e.g. BAM and GELI).", common=true)
    public int COMPRESSION_LEVEL = 5;
    @Option(doc="When writing SAM files that need to be sorted, this will specify the number of records stored in RAM before spilling to disk. Increasing this number reduces the number of file handles needed to sort a SAM file, and increases the amount of RAM needed.", optional=true, common=true)
    public Integer MAX_RECORDS_IN_RAM = SAMFileWriterImpl.getDefaultMaxRecordsInRam();
    @Option(doc="Whether to create a BAM index when writing a coordinate-sorted BAM file.", common=true)
    public Boolean CREATE_INDEX = false;
    @Option(doc="Whether to create an MD5 digest for any BAM files created.  ", common=true)
    public boolean CREATE_MD5_FILE = false;
    private final String standardUsagePreamble = CommandLineParser.getStandardUsagePreamble(this.getClass());
    private CommandLineParser commandLineParser;
    private final List<Header> defaultHeaders = new ArrayList<Header>();
    private String commandLine;

    protected abstract int doWork();

    public void instanceMainWithExit(String[] argv) {
        System.exit(this.instanceMain(argv));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int instanceMain(String[] argv) {
        int ret;
        if (!this.parseArgs(argv)) {
            return 1;
        }
        if (this.TMP_DIR == null) {
            this.TMP_DIR = new ArrayList<File>();
        }
        if (this.TMP_DIR.isEmpty()) {
            this.TMP_DIR.add(IOUtil.getDefaultTmpDir());
        }
        Date startDate = new Date();
        this.defaultHeaders.add(new StringHeader(this.commandLine));
        this.defaultHeaders.add(new StringHeader("Started on: " + startDate));
        Log.setGlobalLogLevel(this.VERBOSITY);
        SAMFileReader.ValidationStringency originalStringency = SAMFileReader.getDefaultValidationStringency();
        SAMFileReader.setDefaultValidationStringency((SAMFileReader.ValidationStringency)this.VALIDATION_STRINGENCY);
        BlockCompressedOutputStream.setDefaultCompressionLevel((int)this.COMPRESSION_LEVEL);
        if (this.MAX_RECORDS_IN_RAM != null) {
            SAMFileWriterImpl.setDefaultMaxRecordsInRam((int)this.MAX_RECORDS_IN_RAM);
        }
        if (this.CREATE_INDEX.booleanValue()) {
            SAMFileWriterFactory.setDefaultCreateIndexWhileWriting((boolean)true);
        }
        SAMFileWriterFactory.setDefaultCreateMd5File((boolean)this.CREATE_MD5_FILE);
        for (File f : this.TMP_DIR) {
            if (!f.exists()) {
                f.mkdirs();
            }
            f.setReadable(true, false);
            f.setWritable(true, false);
            System.setProperty("java.io.tmpdir", f.getAbsolutePath());
        }
        if (!this.QUIET.booleanValue()) {
            System.err.println("[" + new Date() + "] " + this.commandLine);
            try {
                System.err.println("[" + new Date() + "] Executing as " + System.getProperty("user.name") + "@" + InetAddress.getLocalHost().getHostName() + " on " + System.getProperty("os.name") + " " + System.getProperty("os.version") + " " + System.getProperty("os.arch") + "; " + System.getProperty("java.vm.name") + " " + System.getProperty("java.runtime.version"));
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        try {
            ret = this.doWork();
        }
        finally {
            SAMFileReader.setDefaultValidationStringency((SAMFileReader.ValidationStringency)originalStringency);
            try {
                if (!this.QUIET.booleanValue()) {
                    Date endDate = new Date();
                    double elapsedMinutes = (double)(endDate.getTime() - startDate.getTime()) / 60000.0;
                    String elapsedString = new DecimalFormat("#,##0.00").format(elapsedMinutes);
                    System.err.println("[" + endDate + "] " + this.getClass().getName() + " done. Elapsed time: " + elapsedString + " minutes.");
                    System.err.println("Runtime.totalMemory()=" + Runtime.getRuntime().totalMemory());
                }
            }
            catch (Throwable e) {}
        }
        return ret;
    }

    protected String[] customCommandLineValidation() {
        return null;
    }

    protected boolean parseArgs(String[] argv) {
        this.commandLineParser = new CommandLineParser(this);
        boolean ret = this.commandLineParser.parseOptions(System.err, argv);
        this.commandLine = this.commandLineParser.getCommandLine();
        if (!ret) {
            return false;
        }
        String[] customErrorMessages = this.customCommandLineValidation();
        if (customErrorMessages != null) {
            for (String msg : customErrorMessages) {
                System.err.println(msg);
            }
            this.commandLineParser.usage(System.err, false);
            return false;
        }
        return true;
    }

    protected <A extends MetricBase, B extends Comparable<?>> MetricsFile<A, B> getMetricsFile() {
        MetricsFile file = new MetricsFile();
        for (Header h : this.defaultHeaders) {
            file.addHeader(h);
        }
        return file;
    }

    public String getStandardUsagePreamble() {
        return this.standardUsagePreamble;
    }

    public CommandLineParser getCommandLineParser() {
        return this.commandLineParser;
    }

    public String getProgramVersion() {
        return this.commandLineParser.getProgramVersion();
    }

    public String getCommandLine() {
        return this.commandLine;
    }

    public void setDefaultHeaders(List<Header> headers) {
        this.defaultHeaders.clear();
        this.defaultHeaders.addAll(headers);
    }

    public List<Header> getDefaultHeaders() {
        return this.defaultHeaders;
    }
}

