/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.illumina;

import java.util.Arrays;
import net.sf.picard.filter.AggregateFilter;
import net.sf.picard.filter.SolexaNoiseFilter;
import net.sf.picard.illumina.parser.ClusterData;
import net.sf.picard.illumina.parser.ReadData;
import net.sf.picard.util.IlluminaUtil;
import net.sf.samtools.SAMFileHeader;
import net.sf.samtools.SAMRecord;
import net.sf.samtools.util.StringUtil;

public class IlluminaBasecallsToSamConverter {
    private final String runBarcode;
    private final String readGroupId;
    private AggregateFilter filters;

    public IlluminaBasecallsToSamConverter(String runBarcode, String readGroupId) {
        this.runBarcode = runBarcode;
        this.readGroupId = readGroupId;
        this.initializeFilters();
    }

    private void initializeFilters() {
        this.filters = new AggregateFilter(Arrays.asList(new SolexaNoiseFilter()));
    }

    private String createReadName(ClusterData cluster) {
        return IlluminaUtil.makeReadName(this.runBarcode, cluster.getLane(), cluster.getTile(), cluster.getX(), cluster.getY());
    }

    public SAMRecord createSamRecord(ClusterData cluster, boolean isFirstRead, SAMFileHeader header, String readName) {
        SAMRecord sam = new SAMRecord(header);
        sam.setReadName(readName != null ? readName : this.createReadName(cluster));
        ReadData readData = isFirstRead ? cluster.getFirstEnd() : cluster.getSecondEnd();
        sam.setReadBases(readData.getBases());
        sam.setBaseQualities(readData.getQualities());
        sam.setReadPairedFlag(cluster.isPairedEnd());
        sam.setReadUnmappedFlag(true);
        sam.setReadFailsVendorQualityCheckFlag(cluster.isPf() == false);
        if (cluster.isPairedEnd()) {
            sam.setMateUnmappedFlag(true);
            sam.setFirstOfPairFlag(isFirstRead);
            sam.setSecondOfPairFlag(!isFirstRead);
        }
        if (this.filters.filterOut(sam)) {
            sam.setAttribute("XN", (Object)1);
        }
        if (this.readGroupId != null) {
            sam.setAttribute("RG", (Object)this.readGroupId);
        }
        if (cluster.getMatchedBarcode() == null && cluster.getBarcodeRead() != null) {
            sam.setAttribute("BC", (Object)StringUtil.bytesToString((byte[])cluster.getBarcodeRead().getBases()).replace('.', 'N'));
        }
        return sam;
    }
}

