/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.illumina.parser;

import java.io.File;
import java.util.NoSuchElementException;
import net.sf.picard.PicardException;
import net.sf.picard.illumina.parser.ClusterData;
import net.sf.picard.illumina.parser.IlluminaParser;
import net.sf.picard.illumina.parser.ReadConfiguration;
import net.sf.picard.illumina.parser.TiledIlluminaFile;
import net.sf.picard.util.BasicInputParser;
import net.sf.picard.util.FormatUtil;
import net.sf.picard.util.Log;

abstract class AbstractIlluminaTextParser
implements IlluminaParser {
    private static final FormatUtil formatter = new FormatUtil();
    private final ReadConfiguration readConfiguration;
    private final File directory;
    private final int lane;
    private TiledIlluminaFile[] files;
    private boolean treatGroupedDelimitersAsOne = true;
    private BasicInputParser parser;
    private final Log log = Log.getInstance(AbstractIlluminaTextParser.class);

    public AbstractIlluminaTextParser(ReadConfiguration readConfiguration, int lane, File directory) {
        this.readConfiguration = readConfiguration;
        this.lane = lane;
        this.directory = directory;
    }

    public AbstractIlluminaTextParser(ReadConfiguration readConfiguration, int lane, File directory, boolean treatGroupedDelimitersAsOne) {
        this.readConfiguration = readConfiguration;
        this.lane = lane;
        this.directory = directory;
        this.treatGroupedDelimitersAsOne = treatGroupedDelimitersAsOne;
    }

    @Override
    public void seekToTile(int oneBasedTileNumber) {
        int i;
        for (i = 0; i < this.files.length && this.files[i].tile != oneBasedTileNumber; ++i) {
        }
        this.initializeParser(i);
    }

    protected void initializeParser(int fileIndex) {
        File[] files = new File[this.files.length - fileIndex];
        for (int i = fileIndex; i < this.files.length; ++i) {
            files[i - fileIndex] = this.files[i].file;
        }
        this.parser = new BasicInputParser(this.treatGroupedDelimitersAsOne, files);
    }

    @Override
    public void next(ClusterData data) {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        try {
            String[] fields = (String[])this.parser.next();
            this.processLine(data, fields);
        }
        catch (RuntimeException re) {
            this.log.error(re, "Error parsing " + this.parser.getFileName() + ":" + this.parser.getCurrentLineNumber() + " - " + this.parser.getCurrentLine());
            throw re;
        }
    }

    protected abstract void processLine(ClusterData var1, String[] var2);

    @Override
    public boolean hasNext() {
        return this.parser.hasNext();
    }

    protected File getDirectory() {
        return this.directory;
    }

    protected static FormatUtil getFormatter() {
        return formatter;
    }

    protected int getLane() {
        return this.lane;
    }

    protected void setFiles(TiledIlluminaFile[] files) {
        this.files = files;
    }

    public ReadConfiguration getReadConfiguration() {
        return this.readConfiguration;
    }

    public String getCurrentFilename() {
        return this.parser.getFileName();
    }

    protected void validateLane(int lane) {
        if (lane != this.getLane()) {
            throw new PicardException("Lane number mismatch: " + lane + " != " + this.getLane());
        }
    }
}

