/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.illumina.parser;

import java.io.File;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.picard.PicardException;
import net.sf.picard.illumina.parser.IlluminaFileNotFoundException;
import net.sf.picard.illumina.parser.TiledIlluminaFile;
import net.sf.picard.io.IoUtil;
import net.sf.picard.util.MathUtil;

public class IlluminaFileUtil {
    private static final ThreadLocal<NumberFormat> tileNumberFormatter = new ThreadLocal<NumberFormat>(){

        @Override
        protected NumberFormat initialValue() {
            NumberFormat formatter = NumberFormat.getNumberInstance();
            formatter.setMinimumIntegerDigits(4);
            formatter.setGroupingUsed(false);
            return formatter;
        }
    };

    public static boolean endedIlluminaBasecallFilesExist(File directory, String fileType, int lane, int end) {
        return IlluminaFileUtil.getEndedIlluminaBasecallFiles(directory, fileType, lane, end).length > 0;
    }

    public static TiledIlluminaFile[] getEndedIlluminaBasecallFiles(File directory, String fileType, int lane, int end) {
        String regexp = "s_" + lane + "_" + end + "_(\\d{4})_" + fileType + ".txt(.gz)?";
        return IlluminaFileUtil.getTiledIlluminaBasecallFiles(directory, regexp);
    }

    public static TiledIlluminaFile[] getEndedIlluminaBasecallFiles(File directory, String fileType, int lane, int end, List<Integer> tiles) {
        if (tiles == null) {
            return IlluminaFileUtil.getEndedIlluminaBasecallFiles(directory, fileType, lane, end);
        }
        TiledIlluminaFile[] ret = new TiledIlluminaFile[tiles.size()];
        for (int i = 0; i < tiles.size(); ++i) {
            String filename = "s_" + lane + "_" + end + "_" + tileNumberFormatter.get().format(tiles.get(i)) + "_" + fileType + ".txt";
            File f = new File(directory, filename);
            if (!f.exists() && !(f = new File(directory, filename + ".gz")).exists()) {
                throw new IlluminaFileNotFoundException(f, "Requested tile file " + f + " not found, with or without .gz.");
            }
            ret[i] = new TiledIlluminaFile(f, tiles.get(i));
        }
        return ret;
    }

    static TiledIlluminaFile[] getTiledIlluminaBasecallFiles(File directory, String regexp) {
        Pattern pattern = Pattern.compile(regexp);
        File[] files = IlluminaFileUtil.getNonEmptyFilesMatchingRegexp(directory, pattern);
        TiledIlluminaFile[] ret = new TiledIlluminaFile[files.length];
        for (int i = 0; i < files.length; ++i) {
            Matcher m = pattern.matcher(files[i].getName());
            if (!m.matches()) {
                throw new PicardException(files[i].getName() + " does not match " + m.pattern());
            }
            String tileString = m.group(1);
            int tile = Integer.parseInt(tileString);
            ret[i] = new TiledIlluminaFile(files[i], tile);
        }
        Arrays.sort(ret, new TiledIlluminaFileComparator());
        return ret;
    }

    private static File[] getNonEmptyFilesMatchingRegexp(File directory, Pattern pattern) {
        File[] files = IoUtil.getFilesMatchingRegexp(directory, pattern);
        ArrayList<File> nonEmptyFiles = new ArrayList<File>(files.length);
        for (File file : files) {
            if (file.length() <= 0L) continue;
            nonEmptyFiles.add(file);
        }
        return nonEmptyFiles.toArray(new File[nonEmptyFiles.size()]);
    }

    public static boolean nonEndedIlluminaBasecallFilesExist(File directory, String fileType, int lane) {
        return IlluminaFileUtil.getNonEndedIlluminaBasecallFiles(directory, fileType, lane).length > 0;
    }

    public static TiledIlluminaFile[] getNonEndedIlluminaBasecallFiles(File directory, String fileType, int lane) {
        String regexp = "s_" + lane + "_(\\d{4})_" + fileType + ".txt(.gz)?";
        return IlluminaFileUtil.getTiledIlluminaBasecallFiles(directory, regexp);
    }

    public static TiledIlluminaFile[] getNonEndedIlluminaBasecallFiles(File directory, String fileType, int lane, List<Integer> tiles) {
        if (tiles == null) {
            return IlluminaFileUtil.getNonEndedIlluminaBasecallFiles(directory, fileType, lane);
        }
        TiledIlluminaFile[] ret = new TiledIlluminaFile[tiles.size()];
        for (int i = 0; i < tiles.size(); ++i) {
            String filename = IlluminaFileUtil.makeNonEndedIlluminaBasecallFilename(fileType, lane, tiles.get(i));
            File f = new File(directory, filename);
            if (!f.exists() && !(f = new File(directory, filename + ".gz")).exists()) {
                throw new IlluminaFileNotFoundException(f, "Requested tile file " + f + " not found, with or without .gz.");
            }
            ret[i] = new TiledIlluminaFile(f, tiles.get(i));
        }
        return ret;
    }

    public static String makeNonEndedIlluminaBasecallFilename(String fileType, int lane, int tile) {
        return "s_" + lane + "_" + tileNumberFormatter.get().format(tile) + "_" + fileType + ".txt";
    }

    static class TiledIlluminaFileComparator
    implements Comparator<TiledIlluminaFile> {
        TiledIlluminaFileComparator() {
        }

        @Override
        public int compare(TiledIlluminaFile v1, TiledIlluminaFile v2) {
            return MathUtil.compare(v1.tile, v2.tile);
        }
    }
}

