/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.illumina;

import net.sf.picard.PicardException;

public class BarcodeUtil {
    public static BarcodePosition findBarcodeEndAndStart(boolean isPairedEnd, int firstEndLength, int secondEndLength, int barcodeCycle, int barcodeLength) {
        boolean isSecondEnd;
        int barcodeOffset;
        if (!isPairedEnd && barcodeCycle + barcodeLength - 1 > firstEndLength) {
            throw new PicardException("Barcode position it past the end of unpaired read.");
        }
        if (barcodeCycle == 1) {
            if (barcodeLength > firstEndLength) {
                throw new PicardException("First end read is not long enough for barcode.");
            }
            barcodeOffset = 0;
            isSecondEnd = false;
        } else if (barcodeCycle <= firstEndLength) {
            if (barcodeCycle + barcodeLength != firstEndLength + 1) {
                throw new PicardException("Barcode position is not at end of first end.");
            }
            barcodeOffset = barcodeCycle - 1;
            isSecondEnd = false;
        } else if (barcodeCycle == firstEndLength + 1) {
            if (barcodeLength > secondEndLength) {
                throw new PicardException("Second end read is not long enough for barcode.");
            }
            barcodeOffset = 0;
            isSecondEnd = true;
        } else {
            if (barcodeCycle + barcodeLength != firstEndLength + secondEndLength + 1) {
                throw new PicardException("Barcode position is not at end of second end.");
            }
            barcodeOffset = barcodeCycle - firstEndLength - 1;
            isSecondEnd = true;
        }
        return new BarcodePosition(barcodeOffset, isSecondEnd, barcodeLength, barcodeCycle);
    }

    public static class BarcodePosition {
        public final boolean barcodeIsInSecondRead;
        public final int barcodeOffset;
        public final int barcodeLength;
        public final int barcodeCycle;

        public BarcodePosition(int barcodeOffset, boolean barcodeIsInSecondRead, int barcodeLength, int barcodeCycle) {
            this.barcodeOffset = barcodeOffset;
            this.barcodeIsInSecondRead = barcodeIsInSecondRead;
            this.barcodeLength = barcodeLength;
            this.barcodeCycle = barcodeCycle;
        }
    }
}

