/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.illumina.parser;

import java.io.File;
import java.util.List;
import java.util.NoSuchElementException;
import net.sf.picard.PicardException;
import net.sf.picard.illumina.parser.ClusterData;
import net.sf.picard.illumina.parser.IlluminaParser;
import net.sf.picard.illumina.parser.ReadData;

public class IlluminaDataProvider {
    private final List<IlluminaParser> parsers;
    private final boolean pairedEnd;
    private final boolean barcoded;
    private final File basecallDirectory;
    private final int lane;

    IlluminaDataProvider(boolean barcoded, boolean pairedEnd, List<IlluminaParser> parsers, File basecallDirectory, int lane) {
        this.barcoded = barcoded;
        this.basecallDirectory = basecallDirectory;
        this.lane = lane;
        this.pairedEnd = pairedEnd;
        this.parsers = parsers;
    }

    public boolean hasNext() {
        if (this.parsers.isEmpty()) {
            return false;
        }
        boolean ret = this.parsers.get(0).hasNext();
        for (int i = 1; i < this.parsers.size(); ++i) {
            if (this.parsers.get(i).hasNext() == ret) continue;
            throw new PicardException("Unequal length basecall files in " + this.basecallDirectory + ", lane " + this.lane);
        }
        return ret;
    }

    public ClusterData next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        ClusterData cluster = new ClusterData();
        cluster.setFirstEnd(new ReadData());
        if (this.pairedEnd) {
            cluster.setSecondEnd(new ReadData());
        }
        if (this.barcoded) {
            cluster.setBarcodeRead(new ReadData());
        }
        for (IlluminaParser parser : this.parsers) {
            parser.next(cluster);
        }
        return cluster;
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }

    public void seekToTile(int oneBasedTileNumber) {
        for (IlluminaParser parser : this.parsers) {
            parser.seekToTile(oneBasedTileNumber);
        }
    }
}

