/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.illumina.parser;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.picard.PicardException;
import net.sf.picard.illumina.BarcodeUtil;
import net.sf.picard.illumina.parser.BarcodeParser;
import net.sf.picard.illumina.parser.CifParser;
import net.sf.picard.illumina.parser.CnfParser;
import net.sf.picard.illumina.parser.IlluminaDataProvider;
import net.sf.picard.illumina.parser.IlluminaDataType;
import net.sf.picard.illumina.parser.IlluminaFileUtil;
import net.sf.picard.illumina.parser.IlluminaParser;
import net.sf.picard.illumina.parser.QseqParser;
import net.sf.picard.illumina.parser.ReadConfiguration;
import net.sf.picard.illumina.parser.ReadType;
import net.sf.picard.illumina.parser.TiledIlluminaFile;
import net.sf.picard.util.Log;
import net.sf.samtools.util.BufferedLineReader;
import net.sf.samtools.util.CoordMath;

public class IlluminaDataProviderFactory {
    private static final Log log = Log.getInstance(IlluminaDataProviderFactory.class);
    private final File basecallDirectory;
    private final int lane;
    private final Integer barcodeCycle;
    private final Integer barcodeLength;
    private Map<Integer, ReadType> readToEndType = new HashMap<Integer, ReadType>();
    private final Set<IlluminaDataType> dataTypes = EnumSet.noneOf(IlluminaDataType.class);
    private File rawIntensityDirectory;
    private Boolean pairedEnd;
    private BaseCallerVersion baseCallerVersion;
    private boolean prepared = false;
    private boolean allowZeroLengthFirstEnd = false;
    private final ReadConfiguration readConfiguration = new ReadConfiguration();

    public IlluminaDataProviderFactory(File basecallDirectory, int lane, IlluminaDataType ... dataTypes) {
        this.basecallDirectory = basecallDirectory;
        this.lane = lane;
        this.barcodeCycle = null;
        this.barcodeLength = null;
        this.dataTypes.addAll(Arrays.asList(dataTypes));
    }

    public IlluminaDataProviderFactory(File basecallDirectory, int lane, int barcodeCycle, int barcodeLength, IlluminaDataType ... dataTypes) {
        this.basecallDirectory = basecallDirectory;
        this.lane = lane;
        if (barcodeCycle < 1) {
            throw new IllegalArgumentException("barcodeCycle is < 1: " + barcodeCycle);
        }
        if (barcodeLength < 1) {
            throw new IllegalArgumentException("barcodeLength is < 1: " + barcodeLength);
        }
        this.barcodeCycle = barcodeCycle;
        this.barcodeLength = barcodeLength;
        this.dataTypes.addAll(Arrays.asList(dataTypes));
    }

    public List<Integer> getTiles() {
        if (!this.prepared) {
            this.computeReadConfiguration();
        }
        TiledIlluminaFile[] tiledFiles = IlluminaFileUtil.getEndedIlluminaBasecallFiles(this.basecallDirectory, "qseq", this.lane, 1);
        ArrayList<Integer> ret = new ArrayList<Integer>(tiledFiles.length);
        for (TiledIlluminaFile tiledFile : tiledFiles) {
            ret.add(tiledFile.tile);
        }
        return ret;
    }

    public IlluminaDataProvider makeDataProvider() {
        return this.makeDataProvider(null);
    }

    public IlluminaDataProvider makeDataProvider(List<Integer> tiles) {
        if (this.dataTypes.isEmpty()) {
            throw new PicardException("No data types have been specified for basecall output " + this.basecallDirectory + ", lane " + this.lane);
        }
        if (!this.prepared) {
            this.computeReadConfiguration();
        }
        boolean madeQseqParser = false;
        ArrayList<IlluminaParser> parsers = new ArrayList<IlluminaParser>();
        for (IlluminaDataType dataType : this.dataTypes) {
            switch (dataType) {
                case Barcodes: {
                    parsers.add(new BarcodeParser(this.readConfiguration, this.basecallDirectory, this.lane, tiles));
                    break;
                }
                case BaseCalls: {
                    if (madeQseqParser) break;
                    this.makeQseqParsers(parsers, tiles);
                    madeQseqParser = true;
                    break;
                }
                case Noise: {
                    parsers.add(new CnfParser(this.readConfiguration, this.rawIntensityDirectory, this.lane, tiles));
                    break;
                }
                case PF: {
                    if (madeQseqParser) break;
                    this.makeQseqParsers(parsers, tiles);
                    madeQseqParser = true;
                    break;
                }
                case QualityScores: {
                    if (madeQseqParser) break;
                    this.makeQseqParsers(parsers, tiles);
                    madeQseqParser = true;
                    break;
                }
                case RawIntensities: {
                    parsers.add(new CifParser(this.readConfiguration, this.rawIntensityDirectory, this.lane, tiles));
                }
            }
        }
        return new IlluminaDataProvider(this.readConfiguration.isBarcoded(), this.readConfiguration.isPairedEnd(), parsers, this.basecallDirectory, this.lane);
    }

    private void makeQseqParsers(List<IlluminaParser> parsers, List<Integer> tiles) {
        if (this.isBarcodeAwareBaseCaller()) {
            for (int read : this.readToEndType.keySet()) {
                ReadType type = this.readToEndType.get(read);
                parsers.add(new QseqParser(this.readConfiguration, this.basecallDirectory, this.lane, type, read, tiles));
            }
        } else {
            parsers.add(new QseqParser(this.readConfiguration, this.basecallDirectory, this.lane, ReadType.FIRST, tiles));
            if (this.pairedEnd.booleanValue() || this.readConfiguration.isBarcoded() && this.readConfiguration.getBarcodeRead() == ReadType.SECOND) {
                parsers.add(new QseqParser(this.readConfiguration, this.basecallDirectory, this.lane, ReadType.SECOND, tiles));
            }
        }
    }

    public boolean intensitiesAvailable(int tile) {
        if (!this.prepared) {
            this.computeReadConfiguration();
        }
        return CifParser.cifExists(this.rawIntensityDirectory, this.lane, tile);
    }

    public void computeReadConfiguration() {
        if (this.prepared) {
            throw new IllegalStateException("Already prepared");
        }
        if (this.baseCallerVersion == null) {
            this.detectPipelineVersion();
        }
        if (this.rawIntensityDirectory == null) {
            this.rawIntensityDirectory = this.basecallDirectory.getParentFile();
        }
        boolean qseqIsBarcodeAware = false;
        switch (this.baseCallerVersion) {
            case rta: 
            case Bustard_1_3: 
            case Bustard_1_4: {
                this.computeReadConfigurationFromBarcodeUnawareQseq();
                break;
            }
            case Bustard_1_5: 
            case Bustard_1_6: {
                this.computeReadConfigurationFromBarcodeAwareQseq();
                qseqIsBarcodeAware = true;
                break;
            }
            default: {
                throw new IllegalStateException("Could not determine base caller version for " + this.basecallDirectory + "; lane " + this.lane);
            }
        }
        if (!qseqIsBarcodeAware) {
            this.updateReadConfigurationForBarcode();
        }
        this.readConfiguration.assertValid(this.allowZeroLengthFirstEnd);
        this.prepared = true;
    }

    private void computeReadConfigurationFromBarcodeUnawareQseq() {
        if (this.pairedEnd == null) {
            this.pairedEnd = IlluminaFileUtil.endedIlluminaBasecallFilesExist(this.basecallDirectory, "qseq", this.lane, 2);
        }
        this.readConfiguration.setPairedEnd(this.pairedEnd);
        if (this.readConfiguration.getFirstLength() == 0) {
            this.readConfiguration.setFirstStart(1);
            File firstEnd = IlluminaFileUtil.getEndedIlluminaBasecallFiles((File)this.basecallDirectory, (String)"qseq", (int)this.lane, (int)1)[0].file;
            this.readConfiguration.setFirstEnd(QseqParser.getReadLength(firstEnd));
        }
        if (this.pairedEnd.booleanValue() && this.readConfiguration.getSecondLength() == 0) {
            File secondEnd = IlluminaFileUtil.getEndedIlluminaBasecallFiles((File)this.basecallDirectory, (String)"qseq", (int)this.lane, (int)2)[0].file;
            int end2Length = QseqParser.getReadLength(secondEnd);
            this.readConfiguration.setSecondStart(this.readConfiguration.getFirstLength() + 1);
            this.readConfiguration.setSecondEnd(this.readConfiguration.getFirstLength() + end2Length);
        }
    }

    private void computeReadConfigurationFromBarcodeAwareQseq() {
        int MAX_QSEQS_PER_TILE = 4;
        File[] qseqs = new File[4];
        int[] readLengths = new int[4];
        qseqs[0] = IlluminaFileUtil.getEndedIlluminaBasecallFiles((File)this.basecallDirectory, (String)"qseq", (int)this.lane, (int)1)[0].file;
        readLengths[0] = QseqParser.getReadLength(qseqs[0]);
        for (int end = 2; end <= 4; ++end) {
            TiledIlluminaFile[] files = IlluminaFileUtil.getEndedIlluminaBasecallFiles(this.basecallDirectory, "qseq", this.lane, end);
            if (files.length <= 0) continue;
            qseqs[end - 1] = files[0].file;
            readLengths[end - 1] = QseqParser.getReadLength(qseqs[end - 1]);
        }
        boolean barcoded = this.barcodeCycle != null;
        this.readConfiguration.setBarcoded(barcoded);
        int barcodeStart = barcoded ? this.barcodeCycle : 0;
        int barcodeEnd = barcoded ? barcodeStart + this.barcodeLength - 1 : 0;
        ReadConfiguration.InclusiveRange first = this.readConfiguration.getFirstRange();
        ReadConfiguration.InclusiveRange second = this.readConfiguration.getSecondRange();
        ReadConfiguration.InclusiveRange barcode = this.readConfiguration.getBarcodeRange();
        int start = 1;
        for (int i = 0; i < readLengths.length; ++i) {
            int len = readLengths[i];
            if (len == 0) continue;
            int end = start + len - 1;
            if (CoordMath.encloses((int)barcodeStart, (int)barcodeEnd, (int)start, (int)end)) {
                if (barcode.getStart() == 0) {
                    barcode.setStart(start);
                }
                barcode.setEnd(end);
                this.readToEndType.put(i + 1, ReadType.BARCODE);
                this.readConfiguration.setBarcodeReads(this.readConfiguration.getBarcodeReads() + 1);
            } else {
                if (CoordMath.overlaps((int)barcodeStart, (int)barcodeEnd, (int)start, (int)end)) {
                    throw new PicardException("Read #" + (i + 1) + " is part barcode read and part non-barcode read!");
                }
                if (first.getStart() == 0) {
                    first.setStart(start);
                    first.setEnd(end);
                    this.readToEndType.put(i + 1, ReadType.FIRST);
                } else if (second.getStart() == 0) {
                    second.setStart(start);
                    second.setEnd(end);
                    this.readToEndType.put(i + 1, ReadType.SECOND);
                } else {
                    throw new PicardException("Found more reads than we know what to do with!");
                }
            }
            start += len;
        }
        if (this.pairedEnd == null) {
            this.pairedEnd = second.getLength() != 0;
        }
        this.readConfiguration.setPairedEnd(this.pairedEnd);
    }

    private void updateReadConfigurationForBarcode() {
        if (this.barcodeCycle == null) {
            this.readConfiguration.setBarcoded(false);
            return;
        }
        BarcodeUtil.BarcodePosition barcodePosition = BarcodeUtil.findBarcodeEndAndStart(this.pairedEnd, this.readConfiguration.getFirstLength(), this.readConfiguration.getSecondLength(), this.barcodeCycle, this.barcodeLength);
        this.readConfiguration.setBarcoded(true);
        this.readConfiguration.setBarcodeStart(this.barcodeCycle);
        this.readConfiguration.setBarcodeEnd(this.barcodeCycle + this.barcodeLength - 1);
        this.readConfiguration.setBarcodeRead(barcodePosition.barcodeIsInSecondRead ? ReadType.SECOND : ReadType.FIRST);
        if (barcodePosition.barcodeIsInSecondRead) {
            if (this.barcodeCycle.intValue() == this.readConfiguration.getSecondStart()) {
                this.readConfiguration.setSecondStart(this.barcodeCycle + this.barcodeLength);
            } else {
                this.readConfiguration.setSecondEnd(this.barcodeCycle - 1);
            }
            if (this.readConfiguration.getSecondLength() == 0) {
                this.readConfiguration.setPairedEnd(false);
                this.setPairedEnd(false);
            }
        } else if (this.barcodeCycle.intValue() == this.readConfiguration.getFirstStart()) {
            this.readConfiguration.setFirstStart(this.barcodeCycle + this.barcodeLength);
        } else {
            this.readConfiguration.setFirstEnd(this.barcodeCycle - 1);
        }
    }

    public void addDataType(IlluminaDataType dataType) {
        this.dataTypes.add(dataType);
    }

    public void removeDataType(IlluminaDataType dataType) {
        this.dataTypes.remove((Object)dataType);
    }

    public void setPairedEnd(boolean pairedEnd) {
        this.pairedEnd = pairedEnd;
    }

    public Boolean isPairedEnd() {
        return this.pairedEnd;
    }

    public void setBaseCallerVersion(BaseCallerVersion baseCallerVersion) {
        this.baseCallerVersion = baseCallerVersion;
    }

    public BaseCallerVersion getBaseCallerVersion() {
        return this.baseCallerVersion;
    }

    public void setRawIntensityDirectory(File rawIntensityDirectory) {
        this.rawIntensityDirectory = rawIntensityDirectory;
    }

    private boolean isBarcodeAwareBaseCaller() {
        return this.baseCallerVersion == BaseCallerVersion.Bustard_1_6 || this.baseCallerVersion == BaseCallerVersion.Bustard_1_5;
    }

    public void setAllowZeroLengthFirstEnd(boolean allowZeroLengthFirstEnd) {
        this.allowZeroLengthFirstEnd = allowZeroLengthFirstEnd;
    }

    private <T> T elvisOperator(T v1, T v2) {
        if (v1 != null) {
            return v1;
        }
        return v2;
    }

    private void detectPipelineVersion() {
        File solexaBuildVersion = new File(this.basecallDirectory, ".solexaBuildVersion");
        if (solexaBuildVersion.exists()) {
            BufferedLineReader reader;
            try {
                reader = new BufferedLineReader((InputStream)new FileInputStream(solexaBuildVersion));
            }
            catch (FileNotFoundException e) {
                throw new PicardException("Unexpected FileNotFound: " + solexaBuildVersion, e);
            }
            String version = reader.readLine();
            log.info("solexaBuildVersion: ", version);
            reader.close();
            if (version.startsWith("1.6")) {
                this.baseCallerVersion = this.elvisOperator(this.baseCallerVersion, BaseCallerVersion.Bustard_1_6);
            } else if (version.startsWith("1.5")) {
                this.baseCallerVersion = this.elvisOperator(this.baseCallerVersion, BaseCallerVersion.Bustard_1_5);
            } else if (version.startsWith("1.4")) {
                this.baseCallerVersion = this.elvisOperator(this.baseCallerVersion, BaseCallerVersion.Bustard_1_4);
            } else if (version.startsWith("1.3")) {
                this.baseCallerVersion = this.elvisOperator(this.baseCallerVersion, BaseCallerVersion.Bustard_1_3);
            } else {
                if (version.startsWith("1.1")) {
                    throw new PicardException("Solexa version 1.1 is no longer supported by Picard.");
                }
                log.info("Unrecognized solexaBuildVersion, using fallback to detect version. ", version);
            }
        } else {
            log.info(solexaBuildVersion, " not found, using fallback to detect version.");
        }
        if (new File(this.basecallDirectory.getParentFile(), "BaseCalls").exists()) {
            log.info("Found BaseCalls directory.");
            if (IlluminaFileUtil.endedIlluminaBasecallFilesExist(this.basecallDirectory, "qseq", this.lane, 3)) {
                log.info("Found barcode qseq file.");
                this.baseCallerVersion = this.elvisOperator(this.baseCallerVersion, BaseCallerVersion.Bustard_1_5);
            } else {
                log.info("Did not find barcode qseq file.");
                this.baseCallerVersion = this.elvisOperator(this.baseCallerVersion, BaseCallerVersion.Bustard_1_4);
            }
        } else if (IlluminaFileUtil.endedIlluminaBasecallFilesExist(this.basecallDirectory, "qseq", this.lane, 1)) {
            log.info("Found end-specific qseq file.");
            this.baseCallerVersion = this.elvisOperator(this.baseCallerVersion, BaseCallerVersion.Bustard_1_3);
        } else {
            if (IlluminaFileUtil.nonEndedIlluminaBasecallFilesExist(this.basecallDirectory, "seq", this.lane)) {
                log.info("Found non-end-specific qseq file.  Picard no longer supports Bustard_1_1!");
            }
            throw new IllegalStateException("Cannot determine pipeline version for basecall directory: " + this.basecallDirectory);
        }
        log.info("BaseCallerVersion: " + (Object)((Object)this.baseCallerVersion));
    }

    public static enum ImageAnalyzerVersion {
        Firecrest_1_1,
        Firecrest_1_3,
        Firecrest_1_4,
        rta;

    }

    public static enum BaseCallerVersion {
        Bustard_1_3,
        Bustard_1_4,
        rta,
        Bustard_1_5,
        Bustard_1_6;

    }
}

