/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.illumina.parser;

import java.io.File;
import java.util.List;
import net.sf.picard.PicardException;
import net.sf.picard.illumina.parser.AbstractIlluminaTextParser;
import net.sf.picard.illumina.parser.ClusterData;
import net.sf.picard.illumina.parser.IlluminaFileUtil;
import net.sf.picard.illumina.parser.ReadConfiguration;
import net.sf.picard.illumina.parser.ReadData;
import net.sf.picard.illumina.parser.ReadType;
import net.sf.picard.util.BasicInputParser;
import net.sf.picard.util.IlluminaUtil;
import net.sf.samtools.util.StringUtil;

public class QseqParser
extends AbstractIlluminaTextParser {
    private static final int LANE_COLUMN = 2;
    private static final int TILE_COLUMN = 3;
    private static final int X_COLUMN = 4;
    private static final int Y_COLUMN = 5;
    private static final int MACHINE_COLUMN = 0;
    private static final int RUN__COLUMN = 1;
    private static final int PF_COLUMN = 10;
    private static final int BASES_COLUMN = 8;
    private static final int QUALS_COLUMN = 9;
    private final ReadType readType;

    public QseqParser(ReadConfiguration readConfiguration, File directory, int lane, ReadType readType, List<Integer> tiles) {
        this(readConfiguration, directory, lane, readType, readType.getDefaultFileNumber(), tiles);
        if (readType != ReadType.FIRST && readType != ReadType.SECOND) {
            throw new IllegalArgumentException("Invalid EndType: " + (Object)((Object)readType));
        }
    }

    public QseqParser(ReadConfiguration readConfiguration, File directory, int lane, ReadType readType, int fileNumber, List<Integer> tiles) {
        super(readConfiguration, lane, directory);
        if (fileNumber < 1 || fileNumber > 4) {
            throw new IllegalArgumentException("Invalid fileNumber: " + fileNumber);
        }
        this.readType = readType;
        this.setFiles(IlluminaFileUtil.getEndedIlluminaBasecallFiles(directory, "qseq", lane, fileNumber, tiles));
        this.initializeParser(0);
    }

    @Override
    protected void processLine(ClusterData data, String[] fields) {
        ReadData end;
        boolean containsBarcode;
        int lane = QseqParser.getFormatter().parseInt(fields[2]);
        this.validateLane(lane);
        int tile = QseqParser.getFormatter().parseInt(fields[3]);
        int x = QseqParser.getFormatter().parseInt(fields[4]);
        int y = QseqParser.getFormatter().parseInt(fields[5]);
        boolean pf = QseqParser.getFormatter().parseInt(fields[10]) == 1;
        String baseString = fields[8];
        String qualString = fields[9];
        if (baseString.length() != qualString.length()) {
            throw new PicardException("Length of bases and quals don't match in " + this.getCurrentFilename());
        }
        int expectedLength = this.readType == ReadType.FIRST ? this.getReadConfiguration().getFirstLength() : (this.readType == ReadType.SECOND ? this.getReadConfiguration().getSecondLength() : this.getReadConfiguration().getBarcodeLength());
        int expectedLengthIncludingBarcode = expectedLength;
        boolean bl = containsBarcode = this.getReadConfiguration().isBarcoded() && this.getReadConfiguration().getBarcodeRead() == this.readType && !this.isBarcodeQseq();
        if (containsBarcode) {
            expectedLengthIncludingBarcode += this.getReadConfiguration().getBarcodeLength();
        }
        if (!(expectedLengthIncludingBarcode == baseString.length() || this.isBarcodeQseq() && this.getReadConfiguration().getBarcodeReads() > 1)) {
            throw new PicardException("Length of bases does not match expected in " + this.getCurrentFilename());
        }
        data.setOrCheckLane(lane);
        data.setOrCheckTile(tile);
        data.setOrCheckX(x);
        data.setOrCheckY(y);
        data.setOrCheckPf(pf);
        ReadData readData = end = this.isBarcodeQseq() ? data.getBarcodeRead() : data.getEnd(this.readType);
        if (containsBarcode) {
            int barcodeOffset = this.getReadConfiguration().getOffsetOfBarcodeInRead();
            int readOffset = this.getReadConfiguration().getOffsetOfNonBarcodeInRead();
            if (expectedLength > 0) {
                byte[] readBases = StringUtil.stringToBytes((String)baseString, (int)readOffset, (int)expectedLength);
                byte[] readQuals = IlluminaUtil.makePhredBinaryFromSolexaQualityAscii_1_3(qualString, readOffset, expectedLength);
                end.setBases(readBases);
                end.setQualities(readQuals);
            }
            byte[] barcodeBases = StringUtil.stringToBytes((String)baseString, (int)barcodeOffset, (int)this.getReadConfiguration().getBarcodeLength());
            byte[] barcodeQuals = IlluminaUtil.makePhredBinaryFromSolexaQualityAscii_1_3(qualString, barcodeOffset, this.getReadConfiguration().getBarcodeLength());
            data.getBarcodeRead().setBases(barcodeBases);
            data.getBarcodeRead().setQualities(barcodeQuals);
        } else {
            byte[] bases = StringUtil.stringToBytes((String)baseString);
            byte[] quals = IlluminaUtil.makePhredBinaryFromSolexaQualityAscii_1_3(qualString);
            if (!this.isBarcodeQseq() || end.getBases() == null) {
                end.setBases(bases);
                end.setQualities(quals);
            } else {
                end.setBases(this.concat(end.getBases(), bases));
                end.setQualities(this.concat(end.getQualities(), quals));
            }
        }
    }

    private byte[] concat(byte[] b1, byte[] b2) {
        byte[] retval = new byte[b1.length + b2.length];
        System.arraycopy(b1, 0, retval, 0, b1.length);
        System.arraycopy(b2, 0, retval, b1.length, b2.length);
        return retval;
    }

    private boolean isBarcodeQseq() {
        return this.readType == ReadType.BARCODE;
    }

    public static int getReadLength(File qseqFile) {
        BasicInputParser parser = new BasicInputParser(true, qseqFile);
        if (!parser.hasNext()) {
            throw new PicardException("Unexpected empty qseq file: " + qseqFile);
        }
        String[] fields = (String[])parser.next();
        return fields[8].length();
    }
}

