/*
 * Decompiled with CFR 0.152.
 */
package wiggleGenerator;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.samtools.Cigar;
import net.sf.samtools.CigarElement;
import net.sf.samtools.CigarOperator;
import net.sf.samtools.SAMFileHeader;
import net.sf.samtools.SAMFileReader;
import net.sf.samtools.SAMFileWriter;
import net.sf.samtools.SAMFileWriterFactory;
import net.sf.samtools.SAMRecord;

public class wiggleGenerator {
    String samfilename;

    public wiggleGenerator(String filename) {
        this.samfilename = filename;
    }

    public void createWiggle() {
        String sortedSamFile = this.sortSamfile(this.samfilename, SAMFileHeader.SortOrder.queryname);
        File samfile = new File(sortedSamFile);
        SAMFileReader reader = new SAMFileReader(samfile);
        SAMFileHeader header = reader.getFileHeader();
        header.setSortOrder(SAMFileHeader.SortOrder.coordinate);
        String tmpSamFile = sortedSamFile.substring(0, sortedSamFile.lastIndexOf(46)) + ".tmp.sam";
        File out = new File(tmpSamFile);
        SAMFileWriterFactory factory = new SAMFileWriterFactory();
        factory.setCreateIndex(true);
        SAMFileWriter writer = factory.makeSAMOrBAMWriter(header, false, out);
        int rec_no = 0;
        ArrayList<SAMRecord> re_array = new ArrayList<SAMRecord>();
        String current_ID = "";
        for (SAMRecord re : reader) {
            boolean d = re.getProperPairFlag();
            if (!current_ID.equals(re.getReadName())) {
                this.write_sam(writer, header, re_array);
                re_array.clear();
                current_ID = re.getReadName();
            }
            this.add_pair(re_array, re);
            ++rec_no;
        }
        this.write_sam(writer, header, re_array);
        reader.close();
        writer.close();
        try {
            this.UCSC_wiggle(this.samfilename, tmpSamFile);
        }
        catch (IOException ex) {
            Logger.getLogger(wiggleGenerator.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void UCSC_wiggle(String samfilename, String input_file) throws IOException {
        String outputfilename = samfilename.substring(0, samfilename.lastIndexOf(46));
        BufferedWriter wr_wiggle_plus_strand = new BufferedWriter(new FileWriter(outputfilename + ".plus.wiggle"));
        BufferedWriter wr_wiggle_minus_strand = new BufferedWriter(new FileWriter(outputfilename + ".minus.wiggle"));
        File file = new File(input_file);
        SAMFileReader SAMFileReader2 = new SAMFileReader(file);
        loci_region[] current_region = new loci_region[]{new loci_region(), new loci_region()};
        int rec_no = 0;
        for (SAMRecord re : SAMFileReader2) {
            String strand_str;
            ++rec_no;
            String chr = re.getReferenceName();
            if (chr.startsWith("*")) break;
            Boolean isNegStrand = re.getReadNegativeStrandFlag();
            int start = re.getAlignmentStart();
            int stop = re.getAlignmentEnd();
            int strand_idx = isNegStrand != false ? 1 : 0;
            String string = strand_str = isNegStrand != false ? "-" : "+";
            if (!chr.equals(current_region[strand_idx].chr)) {
                this.wiggle_write(wr_wiggle_plus_strand, wr_wiggle_minus_strand, current_region[strand_idx], strand_str, Integer.MAX_VALUE);
                current_region[strand_idx].chr = chr;
            }
            this.increase_counter(wr_wiggle_plus_strand, wr_wiggle_minus_strand, current_region[strand_idx], strand_str, start, stop);
        }
        this.wiggle_write(wr_wiggle_plus_strand, wr_wiggle_minus_strand, current_region[0], "+", Integer.MAX_VALUE);
        this.wiggle_write(wr_wiggle_plus_strand, wr_wiggle_minus_strand, current_region[1], "-", Integer.MAX_VALUE);
        try {
            wr_wiggle_plus_strand.close();
            wr_wiggle_minus_strand.close();
        }
        catch (IOException ex) {
            System.out.print(ex.toString());
        }
    }

    private void increase_counter(BufferedWriter wr_plus, BufferedWriter wr_minus, loci_region current_region, String strand, int start, int stop) {
        this.wiggle_write(wr_plus, wr_minus, current_region, strand, start);
        for (int i = start; i <= stop; ++i) {
            if (current_region.depth.get(i) == null) {
                current_region.depth.put(i, 1);
                continue;
            }
            current_region.depth.put(i, current_region.depth.get(i) + 1);
        }
    }

    private void wiggle_write(BufferedWriter wr_plus, BufferedWriter wr_minus, loci_region current_region, String strand, int start) {
        if (current_region.depth.isEmpty()) {
            return;
        }
        int pre_start = current_region.depth.firstKey();
        if (pre_start == start) {
            return;
        }
        int lastKey = current_region.depth.lastKey();
        int pre_depth = current_region.depth.get(pre_start);
        try {
            int current_pos;
            for (current_pos = pre_start; current_pos < start && current_pos <= lastKey; ++current_pos) {
                if (current_pos == 183) {
                    boolean debug = false;
                }
                if (current_region.depth.get(current_pos) != pre_depth) {
                    if (strand.equals("+")) {
                        wr_plus.write(current_region.chr + "\t" + Integer.toString(pre_start - 1) + "\t" + Integer.toString(current_pos - 1) + "\t" + pre_depth + "\n");
                    } else {
                        wr_minus.write(current_region.chr + "\t" + Integer.toString(pre_start - 1) + "\t" + Integer.toString(current_pos - 1) + "\t" + -pre_depth + "\n");
                    }
                    pre_start = current_pos;
                    pre_depth = current_region.depth.get(current_pos);
                }
                current_region.depth.remove(current_pos);
            }
            if (strand.equals("+")) {
                wr_plus.write(current_region.chr + "\t" + Integer.toString(pre_start - 1) + "\t" + Integer.toString(current_pos - 1) + "\t" + pre_depth + "\n");
            } else {
                wr_minus.write(current_region.chr + "\t" + Integer.toString(pre_start - 1) + "\t" + Integer.toString(current_pos - 1) + "\t" + -pre_depth + "\n");
            }
        }
        catch (IOException ex) {
            Logger.getLogger(wiggleGenerator.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void add_pair(ArrayList<SAMRecord> re_array, SAMRecord re) {
        int pos = 0;
        for (pos = 0; pos < re_array.size() && re_array.get(pos).getAlignmentStart() <= re.getAlignmentStart(); ++pos) {
        }
        re_array.add(pos, re);
    }

    private void write_sam(SAMFileWriter writer, SAMFileHeader header, ArrayList<SAMRecord> re_array) {
        if (re_array.size() == 2 && re_array.get(0).getProperPairFlag() && re_array.get(1).getProperPairFlag()) {
            if (re_array.get(0).getFirstOfPairFlag()) {
                if (re_array.get(0).getMateNegativeStrandFlag() && re_array.get(1).getReadNegativeStrandFlag()) {
                    this.write_pair(writer, header, re_array, 16);
                } else if (re_array.get(0).getReadNegativeStrandFlag() && re_array.get(1).getMateNegativeStrandFlag()) {
                    this.write_pair(writer, header, re_array, 0);
                } else {
                    System.out.println("##the left read of pair is not forward##");
                    System.out.println(re_array.get(0).toString());
                    System.out.println(re_array.get(1).toString());
                }
            } else if (re_array.get(0).getSecondOfPairFlag()) {
                if (re_array.get(0).getMateNegativeStrandFlag() && re_array.get(1).getReadNegativeStrandFlag()) {
                    this.write_pair(writer, header, re_array, 0);
                } else if (re_array.get(0).getReadNegativeStrandFlag() && re_array.get(1).getMateNegativeStrandFlag()) {
                    this.write_pair(writer, header, re_array, 16);
                } else {
                    System.out.println("##the left read of pair is not forward##");
                    System.out.println(re_array.get(0).toString());
                    System.out.println(re_array.get(1).toString());
                }
            }
        }
    }

    private void write_pair(SAMFileWriter writer, SAMFileHeader header, ArrayList<SAMRecord> re_array, int strand) {
        if (re_array.get(0).getReadName().equals("FCD0L1YACXX:2:1103:4321:63583#CCAGCGCT")) {
            boolean debug = false;
        }
        String ID = re_array.get(0).getReadName();
        String chr = re_array.get(0).getReferenceName();
        int loci_start1 = re_array.get(0).getAlignmentStart();
        int loci_start2 = re_array.get(1).getAlignmentStart();
        Cigar cigar1 = re_array.get(0).getCigar();
        Cigar cigar2 = re_array.get(1).getCigar();
        int mapQ = re_array.get(0).getMappingQuality();
        String seq1 = re_array.get(0).getReadString();
        String seq2 = re_array.get(1).getReadString();
        int loci_offset = 0;
        int read_offset = 0;
        for (int ele_no = 0; ele_no < cigar1.numCigarElements() - 1; ++ele_no) {
            CigarElement ce = cigar1.getCigarElement(ele_no);
            int len = ce.getLength();
            if (ce.getOperator() == CigarOperator.M) {
                SAMRecord new_rec = new SAMRecord(header);
                new_rec.setReadName(ID);
                new_rec.setFlags(strand);
                new_rec.setReferenceName(chr);
                new_rec.setAlignmentStart(loci_start1 + loci_offset);
                new_rec.setCigarString(len + "M");
                if (len <= 0) {
                    System.out.println("len <= 0(" + len + ")");
                }
                new_rec.setMappingQuality(mapQ);
                new_rec.setReadString(seq1.substring(read_offset, read_offset + len));
                writer.addAlignment(new_rec);
                read_offset += len;
                loci_offset += len;
                continue;
            }
            if (ce.getOperator() == CigarOperator.N) {
                loci_offset += len;
                continue;
            }
            if (ce.getOperator() == CigarOperator.I) {
                read_offset += len;
                continue;
            }
            if (ce.getOperator() == CigarOperator.D) {
                loci_offset += len;
                continue;
            }
            return;
        }
        CigarElement ce_last_cigar1 = cigar1.getCigarElement(cigar1.numCigarElements() - 1);
        int last_len_left_read = ce_last_cigar1.getLength();
        CigarElement ce_1st_cigar2 = cigar2.getCigarElement(0);
        int first_len_right_read = ce_1st_cigar2.getLength();
        if (ce_1st_cigar2.getOperator() == CigarOperator.M) {
            String seq;
            int len_combined_read;
            SAMRecord new_rec = new SAMRecord(header);
            new_rec.setReadName(ID);
            new_rec.setFlags(strand);
            new_rec.setReferenceName(chr);
            if (loci_start2 >= loci_start1 + loci_offset + last_len_left_read) {
                new_rec.setAlignmentStart(loci_start1 + loci_offset);
                len_combined_read = loci_start2 + first_len_right_read - (loci_start1 + loci_offset);
                if (len_combined_read <= 0) {
                    System.out.println("len_combined_read <= 0(" + len_combined_read + ")");
                }
                new_rec.setCigarString(len_combined_read + "M");
                new_rec.setMappingQuality(mapQ);
                String N_str = "";
                for (int N_no = loci_start1 + loci_offset + last_len_left_read; N_no < loci_start2; ++N_no) {
                    N_str = N_str + "N";
                }
                String seq3 = seq1.substring(read_offset, read_offset + last_len_left_read) + N_str + seq2.substring(0, first_len_right_read);
                if (seq3.length() != len_combined_read) {
                    System.out.println(seq3.length() + "!=" + len_combined_read);
                }
                new_rec.setReadString(seq3);
                writer.addAlignment(new_rec);
                read_offset = first_len_right_read;
                loci_offset = first_len_right_read;
            } else if (loci_start2 >= loci_start1 + loci_offset) {
                if (loci_start1 + loci_offset + last_len_left_read <= loci_start2 + first_len_right_read) {
                    new_rec.setAlignmentStart(loci_start1 + loci_offset);
                    len_combined_read = loci_start2 + first_len_right_read - (loci_start1 + loci_offset);
                    if (len_combined_read <= 0) {
                        System.out.println("len_combined_read <= 0(" + len_combined_read + ")");
                    }
                    new_rec.setCigarString(len_combined_read + "M");
                    new_rec.setMappingQuality(mapQ);
                    seq = seq1.substring(read_offset, read_offset + loci_start2 - (loci_start1 + loci_offset)) + seq2.substring(0, first_len_right_read);
                    if (seq.length() != len_combined_read) {
                        System.out.println(seq.length() + "!=" + len_combined_read);
                    }
                    new_rec.setReadString(seq);
                    writer.addAlignment(new_rec);
                    read_offset = first_len_right_read;
                    loci_offset = first_len_right_read;
                } else {
                    new_rec.setAlignmentStart(loci_start1 + loci_offset);
                    len_combined_read = last_len_left_read;
                    if (len_combined_read <= 0) {
                        System.out.println("len_combined_read <= 0(" + len_combined_read + ")");
                    }
                    new_rec.setCigarString(len_combined_read + "M");
                    new_rec.setMappingQuality(mapQ);
                    seq = seq1.substring(read_offset, read_offset + last_len_left_read);
                    if (seq.length() != len_combined_read) {
                        System.out.println(seq.length() + "!=" + len_combined_read);
                    }
                    new_rec.setReadString(seq);
                    writer.addAlignment(new_rec);
                    read_offset = first_len_right_read;
                    loci_offset = first_len_right_read;
                }
            } else if (loci_start2 + first_len_right_read >= loci_start1 + loci_offset) {
                if (loci_start2 + first_len_right_read < loci_start1 + loci_offset + last_len_left_read) {
                    new_rec.setAlignmentStart(loci_start2);
                    len_combined_read = loci_start1 + loci_offset + last_len_left_read - loci_start2;
                    if (len_combined_read <= 0) {
                        System.out.println("len_combined_read <= 0(" + len_combined_read + ")");
                    }
                    new_rec.setCigarString(len_combined_read + "M");
                    new_rec.setMappingQuality(mapQ);
                    seq = seq2.substring(0, loci_start1 + loci_offset - loci_start2) + seq1.substring(read_offset, read_offset + last_len_left_read);
                    if (seq.length() != len_combined_read) {
                        System.out.println(seq.length() + "!=" + len_combined_read);
                    }
                    new_rec.setReadString(seq);
                    writer.addAlignment(new_rec);
                    read_offset = first_len_right_read;
                    loci_offset = first_len_right_read;
                } else {
                    new_rec.setAlignmentStart(loci_start2);
                    len_combined_read = first_len_right_read;
                    if (len_combined_read <= 0) {
                        System.out.println("len_combined_read <= 0(" + len_combined_read + ")");
                    }
                    new_rec.setCigarString(len_combined_read + "M");
                    new_rec.setMappingQuality(mapQ);
                    seq = seq2.substring(0, first_len_right_read);
                    if (seq.length() != len_combined_read) {
                        System.out.println(seq.length() + "!=" + len_combined_read);
                    }
                    new_rec.setReadString(seq);
                    writer.addAlignment(new_rec);
                    read_offset = first_len_right_read;
                    loci_offset = first_len_right_read;
                }
            } else {
                new_rec.setAlignmentStart(loci_start1 + loci_offset);
                len_combined_read = last_len_left_read;
                if (len_combined_read <= 0) {
                    System.out.println("len_combined_read <= 0(" + len_combined_read + ")");
                }
                new_rec.setCigarString(len_combined_read + "M");
                new_rec.setMappingQuality(mapQ);
                seq = seq1.substring(read_offset, read_offset + last_len_left_read);
                if (seq.length() != len_combined_read) {
                    System.out.println(seq.length() + "!=" + len_combined_read);
                }
                new_rec.setReadString(seq);
                writer.addAlignment(new_rec);
                SAMRecord new_rec1 = new SAMRecord(header);
                new_rec1.setReadName(ID);
                new_rec1.setFlags(strand);
                new_rec1.setReferenceName(chr);
                new_rec1.setAlignmentStart(loci_start2);
                len_combined_read = first_len_right_read;
                if (len_combined_read <= 0) {
                    System.out.println("len_combined_read <= 0(" + len_combined_read + ")");
                }
                new_rec1.setCigarString(len_combined_read + "M");
                new_rec1.setMappingQuality(mapQ);
                seq = seq2.substring(0, first_len_right_read);
                if (seq.length() != len_combined_read) {
                    System.out.println(seq.length() + "!=" + len_combined_read);
                }
                new_rec1.setReadString(seq);
                writer.addAlignment(new_rec1);
                read_offset = first_len_right_read;
                loci_offset = first_len_right_read;
            }
        } else {
            System.out.println("error");
        }
        for (int ele_no = 1; ele_no < cigar2.numCigarElements(); ++ele_no) {
            CigarElement ce = cigar2.getCigarElement(ele_no);
            int len = ce.getLength();
            if (ce.getOperator() == CigarOperator.M) {
                SAMRecord new_rec = new SAMRecord(header);
                new_rec.setReadName(ID);
                new_rec.setFlags(strand);
                new_rec.setReferenceName(chr);
                new_rec.setAlignmentStart(loci_start2 + loci_offset);
                new_rec.setCigarString(len + "M");
                if (len <= 0) {
                    System.out.println("len <= 0(" + len + ")");
                }
                new_rec.setMappingQuality(mapQ);
                new_rec.setReadString(seq2.substring(read_offset, read_offset + len));
                writer.addAlignment(new_rec);
                read_offset += len;
                continue;
            }
            if (ce.getOperator() == CigarOperator.N) {
                loci_offset += len;
                continue;
            }
            if (ce.getOperator() == CigarOperator.I) {
                read_offset += len;
                continue;
            }
            if (ce.getOperator() == CigarOperator.D) {
                loci_offset += len;
                continue;
            }
            return;
        }
    }

    private String sortSamfile(String samfilename, SAMFileHeader.SortOrder order) {
        File in = new File(samfilename);
        SAMFileReader reader = new SAMFileReader(in);
        SAMFileHeader header_in = reader.getFileHeader();
        SAMFileHeader header_out = new SAMFileHeader();
        header_out.setSortOrder(order);
        header_out.setSequenceDictionary(header_in.getSequenceDictionary());
        header_out.setProgramRecords(header_in.getProgramRecords());
        String sortedSamFile = samfilename.substring(0, samfilename.lastIndexOf(46) + 1) + order.toString() + "_sorted" + samfilename.substring(samfilename.lastIndexOf(46));
        File out = new File(sortedSamFile);
        SAMFileWriterFactory factory = new SAMFileWriterFactory();
        factory.setCreateIndex(true);
        SAMFileWriter writer = factory.makeSAMOrBAMWriter(header_out, false, out);
        for (SAMRecord re : reader) {
            writer.addAlignment(re);
        }
        reader.close();
        writer.close();
        return sortedSamFile;
    }

    class loci_region {
        String chr = "";
        TreeMap<Integer, Integer> depth = new TreeMap();

        public String toString() {
            return this.chr + ":" + this.depth.firstKey() + "-" + this.depth.lastKey();
        }
    }
}

